(*Session: Transitive_Union_Closed_Families
  Title: Transitive Union-Closed Families
  Authors: Angeliki Koutsoukou-Argyraki, Royal Holloway, University of London and University of Cambridge
  and Lawrence C. Paulson, University of Cambridge
  Date: 24 December 2024.*)

section\<open>Transitive Union-Closed Families\<close>

text\<open> A family of sets is union-closed if the union of any two sets from the family is in the family. 
The Union-Closed Conjecture is an open problem in combinatorics posed by Frankl in 1979. It
states that for every finite, union-closed family of sets (other than the family containing 
only the empty set) there exists an element that belongs to at least half of the sets in the family.
We formalise a proof by Aaronson, Ellis and Leader showing that the Union-Closed Conjecture 
holds for the union-closed family generated by the cyclic translates of any fixed set 
\cite{Aaronson_Ellis_Leader}.\<close>


theory Transitive_Union_Closed_Families 
  imports "Pluennecke_Ruzsa_Inequality.Pluennecke_Ruzsa_Inequality"

begin

no_notation equivalence.Partition (infixl "'/" 75)

definition union_closed:: "'a set set \<Rightarrow> bool" 
  where "union_closed \<F> \<equiv> (\<forall>A\<in>\<F>. \<forall> B\<in>\<F>. A \<union> B \<in> \<F>)"

abbreviation set_difference :: "['a set,'a set] \<Rightarrow> 'a set" (infixl "\<setminus>" 65)
  where "A \<setminus> B \<equiv> A-B"

locale Family = additive_abelian_group +
  fixes R 
  assumes finG: "finite G"
  assumes RG: "R \<subseteq> G"
  assumes R_nonempty: "R \<noteq> {}" 

begin

definition union_closed_conjecture_property:: "'a set set \<Rightarrow> bool"
  where "union_closed_conjecture_property \<F> 
       \<equiv> \<exists>\<X>\<subseteq>\<F>. \<exists>x\<in>G. x \<in> \<Inter>\<X> \<and> card \<X> \<ge> card \<F> / 2"

definition "Neighbd \<equiv> \<lambda>A. sumset A R"

definition "Interior \<equiv> \<lambda>A. {x\<in>G. sumset {x} R \<subseteq> A}"

definition "\<F> \<equiv> Neighbd ` Pow G" 

text\<open>the family @{term \<F>} as defined above and appears in the statement of the theorem 
\cite{Aaronson_Ellis_Leader} is finite, nonempty union-closed family .\<close>

lemma card\<F>_gt0 [simp]: "card \<F> > 0" and finite\<F>: "finite \<F>"
  using \<F>_def finG by fastforce+

text \<open>As a remark, we note that @{term \<F>} is nontrivial.\<close>
lemma "\<F> \<noteq> {{}}"
  unfolding \<F>_def image_def Neighbd_def set_eq_iff
  apply simp
  by (metis RG R_nonempty Pow_top disjoint_iff emptyE subset_eq sumset_is_empty_iff)

lemma "union_closed \<F>"    
proof-
  have *:"\<forall> A \<subseteq> G. \<forall> B \<subseteq> G. (sumset A R) \<union> (sumset B R) = sumset (A \<union> B) R"
    by (simp add: sumset_subset_Un1)
  show ?thesis using *  
    by (auto simp: union_closed_def \<F>_def Neighbd_def)
qed

lemma cardG_gt0: "card G > 0"
  using RG R_nonempty card_0_eq finG by blast

lemma \<F>_subset: "\<F> \<subseteq> Pow G"
  by (simp add: Neighbd_def PowI \<F>_def image_subset_iff sumset_subset_carrier)

subsection\<open>Proof of the main theorem\<close>

lemma card_Interior_le:
  assumes "S \<subseteq> G"
  shows "card (Interior S) \<le> card S"
proof -
  obtain r where "r \<in> R"
    using R_nonempty by blast
  show ?thesis
  proof (intro card_inj_on_le)
    let ?f = "(\<lambda>x. x \<oplus> r)"
    show "inj_on ?f (Interior S)" "?f ` Interior S \<subseteq> S"
      using RG \<open>r \<in> R\<close> by (auto simp: Interior_def inj_on_def)
    show "finite S"
      using assms finG finite_subset by blast
  qed
qed

lemma Interior_subset_G [iff]: "Interior S \<subseteq> G"
  using Interior_def by auto

lemma Neighbd_subset_G [iff]: "Neighbd S \<subseteq> G"
  by (simp add: Neighbd_def sumset_subset_carrier)

lemma average_ge: 
  shows "(\<Sum>S\<in>\<F>.(card S)) / card \<F> \<ge> card G / 2"
proof-
  define f where "f \<equiv> \<lambda>S. minusset (G \<setminus> Interior S)" 

  text\<open>The following corresponds to (1) in the paper.\<close>
  have 1: "card S + card (f S) \<ge> card G" if "S \<subseteq> G" for S
  proof-
    have "card (f S) = card G - card (Interior S)"
      unfolding f_def
      by (metis Diff_subset Interior_subset_G card_Diff_subset card_minusset' finG finite_subset)
    with that show ?thesis using card_Interior_le
      by (metis (no_types, lifting) add.commute diff_le_mono2 le_diff_conv)
  qed

  text\<open>The following corresponds to (2) in the paper.\<close>
  have 2: "f S = sumset (minusset (G \<setminus> S)) R" if "S \<subseteq> G" for S
  proof-
    have *: "x \<in> f S \<longleftrightarrow> x \<in> sumset (minusset (G \<setminus> S)) R" if "x \<in> G" for x
    proof -
      have "x \<in> f S \<longleftrightarrow> inverse x \<notin> Interior S"
        using that minusset.simps by (fastforce simp: f_def)+
      also have "\<dots> \<longleftrightarrow> (sumset {inverse x} R) \<inter> (G\<setminus>S) \<noteq> {}"
        using sumset_subset_carrier that by (auto simp: Interior_def)
      also have "\<dots> \<longleftrightarrow> x \<in> sumset (minusset (G\<setminus>S)) R"
      proof
        assume L: "sumset {inverse x} R \<inter> (G \<setminus> S) \<noteq> {}"
        then obtain r where r: "inverse x \<oplus> r \<notin> S" and "r \<in> R"
          using \<open>S \<subseteq> G\<close> \<open>x \<in> G\<close> by (auto simp: sumset_eq minusset_eq)
        then have "inverse (inverse x \<oplus> r) \<in> minusset (G \<setminus> S)"
          using RG that by auto
        moreover have "x = inverse (inverse x \<oplus> r) \<oplus> r"
          using RG \<open>r \<in> R\<close> that commutative inverse_composition_commute invertible_right_inverse2 
          by auto
        ultimately show "x \<in> sumset (minusset (G \<setminus> S)) R"
          by (metis RG \<open>r \<in> R\<close> minusset_subset_carrier subset_eq sumset.simps)
      next
        assume R: "x \<in> sumset (minusset (G \<setminus> S)) R"
        then obtain g r where *: "g\<in>G" "g \<notin> S" "r\<in>R" "x = inverse g \<oplus> r"
          by (metis Diff_iff minusset.simps sumset.cases)
        show "sumset {inverse x} R \<inter> (G \<setminus> S) \<noteq> {}"
        proof
          assume "sumset {inverse x} R \<inter> (G \<setminus> S) = {}"
          then have "g \<notin> sumset {inverse x} R" 
            using \<open>g \<notin> S\<close> sumset_subset_carrier that by fastforce
          then have "g \<noteq> local.inverse (local.inverse g \<oplus> r) \<oplus> r"
            using * RG that by (auto simp: sumset_eq)
          with * RG that show False
            by (metis commutative invertible invertible_left_inverse2 invertible_right_inverse2 subset_eq)
        qed
      qed
      finally show ?thesis .
    qed
    show ?thesis
    proof
      show "f S \<subseteq> sumset (minusset (G \<setminus> S)) R"
      using "*" f_def minusset_subset_carrier by blast
    next
      show "sumset (minusset (G \<setminus> S)) R \<subseteq> f S"
      by (meson "*" subset_iff sumset_subset_carrier)
    qed
  qed
  then have "f ` Pow G \<subseteq> \<F>"
    by (auto simp: Neighbd_def \<F>_def minusset_subset_carrier)

  text\<open>The following corresponds to (3) in the paper.\<close>

  have 3: "Neighbd (Interior (sumset A R)) = sumset A R" 
    if "A \<subseteq> G" for A
    using that by (force simp: sumset_eq Neighbd_def Interior_def)
  
  text\<open>"Putting everything together": \<close>
  moreover
  have "sumset X R = sumset Y R"
    if "X \<subseteq> G" "Y \<subseteq> G"
      "minusset (G \<setminus> Interior (sumset X R)) = minusset (G \<setminus> Interior (sumset Y R))"
    for X Y
    using that 3
    by (metis Diff_Diff_Int Int_absorb2 Interior_subset_G inf_commute minus_minusset)
  ultimately have "inj_on f \<F>"
    by (auto simp: inj_on_def \<F>_def f_def Neighbd_def)
  moreover have "f ` \<F> \<subseteq> \<F>"
    using 2 \<F>_def \<open>f ` Pow G \<subseteq> \<F>\<close> by force
  moreover have "\<F> \<subseteq> f ` \<F>"
    by (metis \<open>inj_on f \<F>\<close> \<open>f ` \<F> \<subseteq> \<F>\<close> endo_inj_surj finite\<F>)
  ultimately have "bij_betw f \<F> \<F>" 
    by (simp add: bij_betw_def)
  then have sum_card_eq: "(\<Sum>S\<in>\<F>. card (f S)) = (\<Sum>S\<in>\<F>. card S)"
    by (simp add: sum.reindex_bij_betw)

  have "card G / 2 = (1 / (2 * card \<F>)) * (\<Sum>S\<in>\<F>. card G)"
    by simp
  also have "\<dots> \<le> (1 / (2 * card \<F>)) * (\<Sum>S\<in>\<F>. card S + card (f S))"
    by (intro sum_mono mult_left_mono of_nat_mono 1) (auto simp: \<F>_def)
  also have "\<dots> = (1 / card \<F>) * (\<Sum>S\<in>\<F>. card S)"
    by (simp add: sum_card_eq sum.distrib)
  finally show ?thesis
    by argo
qed

text\<open>We have thus shown that the average size of a set in the family @{term \<F>} is
at least $|G|/2$, proving the first part of Theorem 2 in the paper \cite{Aaronson_Ellis_Leader}. 
Using this, we will now show the main statement, i.e. that the Union-Closed Conjecture holds for 
the family @{term \<F>}.\<close>
 

theorem Aaronson_Ellis_Leader_union_closed_conjecture:
  shows "union_closed_conjecture_property \<F>"
proof -
  \<comment> \<open>First, quite a big calculation not mentioned in the article:
      counting all the elements in two different ways.\<close>
have *: "(\<Sum>S\<in>\<F>.(card S)) = (\<Sum>x\<in>G. card {S\<in>\<F>. x\<in>S})"
    using finite\<F> \<F>_subset
  proof induction
    case empty
    then show ?case 
      by simp
  next
    case (insert S \<G>)
    then have A: "{T. (T = S \<or> T\<in>\<G>) \<and> x\<in>T} 
                 = {T\<in>\<G>. x\<in>T} \<union> (if x\<in>S then {S} else {})"
      for x
      by auto
    have B: "card {T. (T = S \<or> T\<in>\<G>) \<and> x\<in>T} 
           = card {T\<in>\<G>. x\<in>T} + (if x\<in>S then 1 else 0)"
      for x
      by (simp add: A card_insert_if insert)
    have "S = (\<Union>x\<in>G. if x \<in> S then {x} else {})"
      using insert.prems by auto
    then have "card S = card (\<Union>x\<in>G. if x \<in> S then {x} else {})"
      by simp
    also have "\<dots> = (\<Sum>i\<in>G. card (if i \<in> S then {i} else {}))"
      by (intro card_UN_disjoint) (auto simp: finG)
    also have "\<dots> = (\<Sum>x\<in>G. if x \<in> S then 1 else 0)"
      by (force intro: sum.cong)
    finally have C: "card S = (\<Sum>x\<in>G. if x \<in> S then 1 else 0)" .
    show ?case
      using insert by (auto simp: sum.distrib B C)
  qed
 
  have "1/2 \<le> (sum card \<F>) / (card \<F> * card G)"
    using mult_right_mono [OF average_ge, of "1 / card G"] 
    using cardG_gt0 by (simp add: divide_simps split: if_splits)
  also have "\<dots> = (\<Sum>x\<in>G. ((card {S\<in>\<F>. x\<in>S}) / (card  \<F>))) / card G"
    by (simp add: * sum_divide_distrib)
  finally have **: "1/2 \<le> (\<Sum>x\<in>G. card {S\<in>\<F>. x\<in>S} / card \<F>) / card G" .
    \<comment> \<open>There is a typo in the paper (bottom of page): 
               instead of @{term "x \<in> S"} it says @{term "x \<in> \<F>"}.\<close>
  show ?thesis
  proof (rule ccontr)  \<comment>\<open>Contradict the inequality proved above\<close>
    assume "\<not> union_closed_conjecture_property \<F>"
    then have A: "\<And>\<X> x. \<lbrakk>\<X>\<subseteq>\<F>; x\<in>G; x \<in> \<Inter>\<X>\<rbrakk> \<Longrightarrow> card \<X> < card \<F> / 2"
      by (fastforce simp: union_closed_conjecture_property_def)
    have "(\<Sum>x\<in>G. real (card {S\<in>\<F>. x\<in>S})) < (\<Sum>x\<in>G. card \<F> / 2)"
    proof (intro sum_strict_mono)
      fix x :: 'a
      assume "x \<in> G"
      then have "card {S\<in>\<F>. x\<in>S} < card \<F> / 2"
        by (intro A) auto
      then show "real (card {S\<in>\<F>. x\<in>S}) < real (card \<F>) / 2"
        by blast
    qed (use unit_closed finG in auto)
    also have "\<dots> = card \<F> * (card G / 2)"
      by simp
    finally have B: "(\<Sum>x\<in>G. real (card {S\<in>\<F>. x\<in>S})) < card \<F> * (card G / 2)" .
    have "(\<Sum>x\<in>G. card {S\<in>\<F>. x\<in>S} / card \<F>) / card G < 1/2"
      using cardG_gt0 divide_strict_right_mono [OF B, of "card \<F> * card G"]
      by (simp add: divide_simps sum_divide_distrib)
    with ** show False
      by argo
  qed
qed

end

end

