(*  Title:   Lemmas_StandardBorel.thy
    Author:  Michikazu Hirata, Tokyo Institute of Technology
*)

text \<open> We refer to the HOL-Analysis library,
       the textbooks by Matsuzaka~\cite{topology} and Srivastava~\cite{borelsets},
       and the lecture note by Biskup~\cite{standardborel}.\<close>

section  \<open>Lemmas\<close>
theory Lemmas_StandardBorel
  imports "HOL-Probability.Probability"
begin

subsection \<open>Lemmas for Abstract Topology\<close>

subsubsection \<open> Generated By \<close>
lemma topology_generated_by_sub:
  assumes "\<And>U. U \<in> \<U> \<Longrightarrow> (openin X U)"
      and "openin (topology_generated_by \<U>) U"
    shows "openin X U"
proof -
  have "generate_topology_on \<U> U"
    by (simp add: assms(2) openin_topology_generated_by)
  then show ?thesis
    by induction (use assms(1) in auto)
qed

lemma topology_generated_by_open:
 "S = topology_generated_by {U | U . openin S U}"
  unfolding topology_eq
proof standard+
  fix U
  assume "openin (topology_generated_by {U |U. openin S U}) U"
  note this[simplified openin_topology_generated_by_iff]
  then show "openin S U"
    by induction auto
qed(simp add: openin_topology_generated_by_iff generate_topology_on.Basis)

lemma topology_generated_by_eq:
  assumes "\<And>U. U \<in> \<U> \<Longrightarrow> (openin (topology_generated_by \<O>) U)"
      and "\<And>U. U \<in> \<O> \<Longrightarrow> (openin (topology_generated_by \<U>) U)"
    shows "topology_generated_by \<O> = topology_generated_by \<U>"
  using topology_generated_by_sub[of \<U>, OF assms(1)] topology_generated_by_sub[of \<O>,OF assms(2)]
  by(auto simp: topology_eq)

lemma topology_generated_by_homeomorphic_spaces:
  assumes "homeomorphic_map X Y f" "X = topology_generated_by \<O>"
  shows "Y = topology_generated_by ((`) f ` \<O>)"
  unfolding topology_eq
proof
  have f:"open_map X Y f" "inj_on f (topspace X)"
    using assms(1) by (simp_all add: homeomorphic_imp_open_map perfect_injective_eq_homeomorphic_map[symmetric])
  obtain g where g: "\<And>x. x \<in> topspace X \<Longrightarrow> g (f x) = x" "\<And>y. y \<in> topspace Y \<Longrightarrow> f (g y) = y" "open_map Y X g" "inj_on g (topspace Y)"
    using homeomorphic_map_maps[of X Y f,simplified assms(1)] homeomorphic_imp_open_map homeomorphic_maps_map[of X Y f] homeomorphic_imp_injective_map[of Y X] by blast
  show "\<And>S. openin Y S = openin (topology_generated_by ((`) f ` \<O>)) S"
  proof safe
    fix S
    assume "openin Y S"
    then have "openin X (g ` S)"
      using g(3) by (simp add: open_map_def)
    hence h:"generate_topology_on \<O> (g ` S)"
      by(simp add: assms(2) openin_topology_generated_by_iff)
    have "S = f ` (g `  S)"
      using openin_subset[OF \<open>openin Y S\<close>] g(2) by(fastforce simp: image_def)
    also have "openin (topology_generated_by ((`) f ` \<O>)) ..."
      using h
    proof induction
      case Empty
      then show ?case by simp
    next
      case (Int a b)
      with inj_on_image_Int[OF f(2),of a b] show ?case
        by (metis assms(2) openin_Int openin_subset openin_topology_generated_by_iff)
    next
      case (UN K)
      then show ?case
        by(auto simp: image_Union)
    next
      case (Basis s)
      then show ?case
        by(auto intro!: generate_topology_on.Basis simp: openin_topology_generated_by_iff)
    qed
    finally show "openin (topology_generated_by ((`) f ` \<O>)) S" .
  next
    fix S
    assume "openin (topology_generated_by ((`) f ` \<O>)) S"
    then have "generate_topology_on ((`) f ` \<O>) S"
      by(simp add: openin_topology_generated_by_iff)
    thus "openin Y S"
    proof induction
      case (Basis s)
      then obtain U where u:"U \<in> \<O>" "s = f ` U" by auto
      then show ?case
        using assms(1) assms(2) homeomorphic_map_openness_eq topology_generated_by_Basis by blast
    qed auto
  qed
qed

lemma open_map_generated_topo:
  assumes "\<And>u. u \<in> U \<Longrightarrow> openin S (f ` u)" "inj_on f (topspace (topology_generated_by U))"
  shows "open_map (topology_generated_by U) S f"
  unfolding open_map_def
proof safe
  fix u
  assume "openin (topology_generated_by U) u"
  then have "generate_topology_on U u" 
    by(simp add: openin_topology_generated_by_iff)
  thus "openin S (f ` u)"
  proof induction
    case (Int a b)
    then have [simp]:"f ` (a \<inter> b) = f ` a \<inter> f ` b"
      by (meson assms(2) inj_on_image_Int openin_subset openin_topology_generated_by_iff)
    from Int show ?case by auto
  qed (simp_all add: image_Union openin_clauses(3) assms)
qed

lemma subtopology_generated_by:
 "subtopology (topology_generated_by \<O>) T = topology_generated_by {T \<inter> U | U. U \<in> \<O>}"
  unfolding topology_eq openin_subtopology openin_topology_generated_by_iff
proof safe
  fix A
  assume "generate_topology_on \<O> A"
  then show "generate_topology_on {T \<inter> U |U. U \<in> \<O>} (A \<inter> T)"
  proof induction
    case Empty
    then show ?case
      by (simp add: generate_topology_on.Empty)
  next
    case (Int a b)
    moreover have "a \<inter> b \<inter> T = (a \<inter> T) \<inter> (b \<inter> T)" by auto
    ultimately show ?case
      by(auto intro!: generate_topology_on.Int)
  next
    case (UN K)
    moreover have "(\<Union> K \<inter> T) = (\<Union> { k \<inter> T | k. k \<in> K})" by auto
    ultimately show ?case
      by(auto intro!: generate_topology_on.UN)
  next
    case (Basis s)
    then show ?case
      by(auto intro!: generate_topology_on.Basis)
  qed
next
  fix A
  assume "generate_topology_on {T \<inter> U |U. U \<in> \<O>} A"
  then show "\<exists>L. generate_topology_on \<O> L \<and> A = L \<inter> T"
  proof induction
    case Empty
    show ?case
      by(auto intro!: exI[where x="{}"] generate_topology_on.Empty)
  next
    case ih:(Int a b)
    then obtain La Lb where
     "generate_topology_on \<O> La" "a = La \<inter> T" "generate_topology_on \<O> Lb" "b = Lb \<inter> T"
      by auto
    thus ?case
      using ih by(auto intro!: exI[where x="La \<inter> Lb"] generate_topology_on.Int)
  next
    case ih:(UN K)
    then obtain L where
    "\<And>k. k \<in> K \<Longrightarrow> generate_topology_on \<O> (L k) " "\<And>k. k \<in> K \<Longrightarrow> k = (L k) \<inter> T"
      by metis
    thus ?case
      using ih by(auto intro!: exI[where x="\<Union>k\<in>K. L k"] generate_topology_on.UN)
  next
    case (Basis s)
    then show ?case
      using generate_topology_on.Basis by fastforce
  qed
qed

lemma prod_topology_generated_by:
  "topology_generated_by { U \<times> V | U V. U \<in> \<O> \<and> V \<in> \<U>} = prod_topology (topology_generated_by \<O>) (topology_generated_by \<U>)"
  unfolding topology_eq
proof safe
  fix U
  assume h:"openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) U"
  show "openin (prod_topology (topology_generated_by \<O>) (topology_generated_by \<U>)) U"
    by(auto simp: openin_prod_Times_iff[of "topology_generated_by \<O>" "topology_generated_by \<U>"]
          intro!: topology_generated_by_Basis topology_generated_by_sub[OF _ h])
next
  fix U
  assume "openin (prod_topology (topology_generated_by \<O>) (topology_generated_by \<U>)) U"
  then have "\<forall>z\<in>U. \<exists>V1 V2. openin (topology_generated_by \<O>) V1 \<and> openin (topology_generated_by \<U>) V2 \<and> fst z \<in> V1 \<and> snd z \<in> V2 \<and> V1 \<times> V2 \<subseteq> U"
    by(auto simp: openin_prod_topology_alt)
  hence "\<exists>V1. \<forall>z\<in>U. \<exists>V2. openin (topology_generated_by \<O>) (V1 z) \<and> openin (topology_generated_by \<U>) V2 \<and> fst z \<in> (V1 z) \<and> snd z \<in> V2 \<and> (V1 z) \<times> V2 \<subseteq> U"
    by(rule bchoice)
  then obtain V1 where "\<forall>z\<in>U. \<exists>V2. openin (topology_generated_by \<O>) (V1 z) \<and> openin (topology_generated_by \<U>) V2 \<and> fst z \<in> (V1 z) \<and> snd z \<in> V2 \<and> (V1 z) \<times> V2 \<subseteq> U"
    by auto
  hence "\<exists>V2. \<forall>z\<in>U. openin (topology_generated_by \<O>) (V1 z) \<and> openin (topology_generated_by \<U>) (V2 z) \<and> fst z \<in> (V1 z) \<and> snd z \<in> (V2 z) \<and> (V1 z) \<times> (V2 z) \<subseteq> U"
    by(rule bchoice)
  then obtain V2 where hv12:"\<And>z. z\<in>U \<Longrightarrow> openin (topology_generated_by \<O>) (V1 z) \<and> openin (topology_generated_by \<U>) (V2 z) \<and> fst z \<in> (V1 z) \<and> snd z \<in> (V2 z) \<and> (V1 z) \<times> (V2 z) \<subseteq> U"
    by auto
  hence 1:"U = (\<Union>z\<in>U. (V1 z) \<times> (V2 z))"
    by auto
  have "openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) (\<Union>z\<in>U. (V1 z) \<times> (V2 z))"
  proof(rule openin_Union)
    show "\<And>S. S \<in> (\<lambda>z. V1 z \<times> V2 z) ` U \<Longrightarrow> openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) S"
    proof safe
      fix x y
      assume h:"(x,y) \<in> U"
      then have "generate_topology_on \<O> (V1 (x,y))"
        using hv12 by(auto simp: openin_topology_generated_by_iff)
      thus "openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) (V1 (x, y) \<times> V2 (x, y))"
      proof induction
        case Empty
        then show ?case by auto
      next
        case (Int a b)
        thus ?case
          by (auto simp: Sigma_Int_distrib1) 
      next
        case (UN K)
        then have "openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) (\<Union>{ k \<times> V2 (x, y) | k. k \<in> K})"
          by auto
        moreover have "(\<Union> {k \<times> V2 (x, y) |k. k \<in> K}) = (\<Union> K \<times> V2 (x, y))"
          by blast
        ultimately show ?case by simp
      next
        case ho:(Basis s)
        have "generate_topology_on \<U> (V2 (x,y))"
          using h hv12 by(auto simp: openin_topology_generated_by_iff)
        thus ?case
        proof induction
          case Empty
          then show ?case by auto
        next
          case (Int a b)
          then show ?case
            by (auto simp: Sigma_Int_distrib2) 
        next
          case (UN K)
          then have "openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) (\<Union> { s \<times> k | k. k \<in>K})"
            by auto
          moreover have "(\<Union> { s \<times> k | k. k \<in>K}) = s \<times> \<Union>K"
            by blast
          ultimately show ?case by simp
        next
          case (Basis s')
          then show ?case
            using ho by(auto intro!: topology_generated_by_Basis)
        qed
      qed
    qed
  qed
  thus "openin (topology_generated_by {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<U>}) U"
    using 1 by auto
qed

lemma prod_topology_generated_by_open:
 "prod_topology S S' = topology_generated_by {U \<times> V | U V. openin S U \<and> openin S' V}"
  using prod_topology_generated_by[of " {U |U. openin S U}" "{U |U. openin S' U}"] topology_generated_by_open[of S,symmetric] topology_generated_by_open[of S']
  by auto

lemma product_topology_cong:
  assumes "\<And>i. i \<in> I \<Longrightarrow> S i = K i"
  shows "product_topology S I = product_topology K I"
proof -
  have 1:"{\<Pi>\<^sub>E i\<in>I. X i |X. (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)}} \<subseteq> {\<Pi>\<^sub>E i\<in>I. X i |X. (\<forall>i. openin (K i) (X i)) \<and> finite {i. X i \<noteq> topspace (K i)}}" if "\<And>i. i \<in> I \<Longrightarrow> S i = K i" for S K :: "_ \<Rightarrow> 'b topology"
  proof
    fix x
    assume hx:"x \<in> {\<Pi>\<^sub>E i\<in>I. X i |X. (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)}}"
    then obtain X where hX:
     "x = (\<Pi>\<^sub>E i\<in>I. X i)" "\<And>i. openin (S i) (X i)" "finite {i. X i \<noteq> topspace (S i)}"
      by auto
    define X' where "X' \<equiv> (\<lambda>i. if i \<in> I then X i else topspace (K i))"
    have "x = (\<Pi>\<^sub>E i\<in>I. X' i)"
      by(auto simp: hX(1) X'_def PiE_def Pi_def)
    moreover have "finite {i. X' i \<noteq> topspace (K i)}"
      using that by(auto intro!: finite_subset[OF _ hX(3)] simp: X'_def)
    moreover have "openin (K i) (X' i)" for i
      using hX(2)[of i] that[of i] by(auto simp: X'_def)
    ultimately show "x \<in> {\<Pi>\<^sub>E i\<in>I. X i |X. (\<forall>i. openin (K i) (X i)) \<and> finite {i. X i \<noteq> topspace (K i)}}"
      by(auto intro!: exI[where x="X'"])
  qed
  have "{\<Pi>\<^sub>E i\<in>I. X i |X. (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)}} = {\<Pi>\<^sub>E i\<in>I. X i |X. (\<forall>i. openin (K i) (X i)) \<and> finite {i. X i \<noteq> topspace (K i)}}"
    using 1[of S K] 1[of K S] assms by auto
  thus ?thesis
    by(simp add: product_topology_def)
qed

lemma topology_generated_by_without_empty:
 "topology_generated_by \<O> = topology_generated_by { U \<in> \<O>. U \<noteq> {}}"
proof(rule topology_generated_by_eq)
  fix U
  show "U \<in> \<O> \<Longrightarrow> openin (topology_generated_by { U \<in> \<O>. U \<noteq> {}}) U"
    by(cases "U = {}") (simp_all add: topology_generated_by_Basis)
qed (simp add: topology_generated_by_Basis)

lemma topology_from_bij:
  assumes "bij_betw f A (topspace S)"
  shows "homeomorphic_map (pullback_topology A f S) S f" "topspace (pullback_topology A f S) = A"
proof -
  note h = bij_betw_imp_surj_on[OF assms] bij_betw_inv_into_left[OF assms] bij_betw_inv_into_right[OF assms]
  then show [simp]:"topspace (pullback_topology A f S) = A"
    by(auto simp: topspace_pullback_topology)
  show "homeomorphic_map (pullback_topology A f S) S f"
    by(auto simp: homeomorphic_map_maps homeomorphic_maps_def h continuous_map_pullback[OF continuous_map_id,simplified] inv_into_into intro!: exI[where x="inv_into A f"] continuous_map_pullback'[where f=f]) (metis (mono_tags, opaque_lifting) comp_apply continuous_map_eq continuous_map_id h(3) id_apply)
qed

lemma openin_pullback_topology':
  assumes "bij_betw f A (topspace S)"
  shows "openin (pullback_topology A f S) u \<longleftrightarrow> (openin S (f ` u)) \<and> u \<subseteq> A"
  unfolding openin_pullback_topology
proof safe
  fix U
  assume h:"openin S U" "u = f -` U \<inter> A"
  from openin_subset[OF this(1)] assms
  have [simp]:"f ` (f -` U \<inter> A) = U"
    by(auto simp: image_def vimage_def bij_betw_def)
  show "openin S (f ` (f -` U \<inter> A))"
    by(simp add: h)
next
  assume "openin S (f ` u)" "u \<subseteq> A"
  with assms show "\<exists>U. openin S U \<and> u = f -` U \<inter> A"
    by(auto intro!: exI[where x="f ` u"] simp: bij_betw_def inj_on_def)
qed

subsubsection \<open> Isolated Point \<close>    
definition isolated_points_of :: "'a topology \<Rightarrow> 'a set \<Rightarrow> 'a set" (infixr \<open>isolated'_points'_of\<close> 80) where
"X isolated_points_of A \<equiv> {x\<in>topspace X \<inter> A. x \<notin> X derived_set_of A}"

lemma isolated_points_of_eq:
 "X isolated_points_of A = {x\<in>topspace X \<inter> A. \<exists>U. x \<in> U \<and> openin X U \<and> U \<inter> (A - {x}) = {}}"
  unfolding isolated_points_of_def by(auto simp: in_derived_set_of)

lemma in_isolated_points_of:
 "x \<in> X isolated_points_of A \<longleftrightarrow> x \<in> topspace X \<and> x \<in> A \<and> (\<exists>U. x \<in> U \<and> openin X U \<and> U \<inter> (A - {x}) = {})"
  by(simp add: isolated_points_of_eq)

lemma derived_set_of_eq:
 "x \<in> X derived_set_of A \<longleftrightarrow> x \<in> X closure_of (A - {x})"
  by(auto simp: in_derived_set_of in_closure_of)

subsubsection \<open> Perfect Set \<close>
definition perfect_set :: "'a topology \<Rightarrow> 'a set \<Rightarrow> bool" where
"perfect_set X A \<longleftrightarrow> closedin X A \<and> X isolated_points_of A = {}"

abbreviation "perfect_space X \<equiv> perfect_set X (topspace X)"

lemma perfect_space_euclidean: "perfect_space (euclidean :: 'a :: perfect_space topology)"
  by(auto simp: isolated_points_of_def perfect_set_def derived_set_of_eq closure_interior)

lemma perfect_setI:
  assumes "closedin X A"
      and "\<And>x T. \<lbrakk>x \<in> A; x \<in> T; openin X T\<rbrakk> \<Longrightarrow> \<exists>y\<noteq>x. y \<in> T \<and> y \<in> A"
    shows "perfect_set X A"
  using assms by(simp add: perfect_set_def isolated_points_of_def in_derived_set_of) blast

lemma perfect_spaceI:
  assumes "\<And>x T. \<lbrakk>x \<in> T; openin X T\<rbrakk> \<Longrightarrow> \<exists>y\<noteq>x. y \<in> T"
  shows "perfect_space X"
  using assms by(auto intro!: perfect_setI) (meson in_mono openin_subset)

lemma perfect_setD:
  assumes "perfect_set X A"
  shows "closedin X A" "A \<subseteq> topspace X" "\<And>x T. \<lbrakk>x \<in> A; x \<in> T; openin X T\<rbrakk> \<Longrightarrow> \<exists>y\<noteq>x. y \<in> T \<and> y \<in> A"
  using assms closedin_subset[of X A] by(simp_all add: perfect_set_def isolated_points_of_def in_derived_set_of) blast

lemma perfect_space_perfect:
  "perfect_set euclidean (UNIV :: 'a :: perfect_space set)"
  by(auto simp: perfect_set_def in_isolated_points_of) (metis Int_Diff inf_top.right_neutral insert_Diff not_open_singleton)

lemma perfect_set_subtopology:
  assumes "perfect_set X A"
  shows "perfect_space (subtopology X A)"
  using perfect_setD[OF assms] by(auto intro!: perfect_setI simp: inf.absorb_iff2 openin_subtopology)

subsubsection \<open> Bases and Sub-Bases in Abstract Topology\<close>
definition subbase_in :: "['a topology, 'a set set] \<Rightarrow> bool" where
"subbase_in S \<O> \<longleftrightarrow> S = topology_generated_by \<O>"

definition base_in :: "['a topology, 'a set set] \<Rightarrow> bool" where
"base_in S \<O> \<longleftrightarrow> (\<forall>U. openin S U \<longleftrightarrow> (\<exists>\<U>. U = \<Union>\<U> \<and> \<U> \<subseteq> \<O>))"

lemma second_countable_base_in: "second_countable S \<longleftrightarrow> (\<exists>\<O>. countable \<O> \<and> base_in S \<O>)"
proof -
  have [simp]:"\<And>\<B>. (openin S = arbitrary union_of (\<lambda>x. x \<in> \<B>)) \<longleftrightarrow> (\<forall>U. openin S U \<longleftrightarrow> (\<exists>\<U>. U = \<Union>\<U> \<and> \<U> \<subseteq> \<B>))"
    by(simp add: arbitrary_def union_of_def fun_eq_iff) metis
  show ?thesis
    by(auto simp: second_countable base_in_def)
qed

definition zero_dimensional :: "'a topology \<Rightarrow> bool" where
"zero_dimensional S \<longleftrightarrow> (\<exists>\<O>. base_in S \<O> \<and> (\<forall>u\<in>\<O>. openin S u \<and> closedin S u))"

lemma openin_base:
  assumes "base_in S \<O> " "U = \<Union>\<U>" and "\<U> \<subseteq> \<O>"
  shows "openin S U"
  using assms by(auto simp: base_in_def)

lemma base_is_subbase:
  assumes "base_in S \<O>"
  shows "subbase_in S \<O>"
  unfolding subbase_in_def topology_eq openin_topology_generated_by_iff
proof safe
  fix U
  assume "openin S U"
  then obtain \<U> where hu:"U = \<Union>\<U>" "\<U> \<subseteq> \<O>"
    using assms by(auto simp: base_in_def)
  thus "generate_topology_on \<O> U"
    by(auto intro!: generate_topology_on.UN) (auto intro!:  generate_topology_on.Basis)
next
  fix U
  assume "generate_topology_on \<O> U"
  then show "openin S U"
  proof induction
    case (Basis s)
    then show ?case
      using openin_base[OF assms,of s "{s}"]
      by auto
  qed auto
qed

lemma subbase_in_subset:
  assumes "subbase_in S \<O>" and "U \<in> \<O>"
  shows "U \<subseteq> topspace S"
  using assms(1)[simplified subbase_in_def] topology_generated_by_topspace assms
  by auto

lemma subbase_in_openin:
  assumes "subbase_in S \<O>" and "U \<in> \<O>"
  shows "openin S U"
  using assms by(simp add: subbase_in_def openin_topology_generated_by_iff generate_topology_on.Basis)

lemma base_in_subset:
  assumes "base_in S \<O>" and "U \<in> \<O>"
  shows "U \<subseteq> topspace S"
  using subbase_in_subset[OF base_is_subbase[OF assms(1)] assms(2)] .

lemma base_in_openin:
  assumes "base_in S \<O>" and "U \<in> \<O>"
  shows "openin S U"
  using subbase_in_openin[OF base_is_subbase[OF assms(1)] assms(2)] .

lemma base_in_def2:
  assumes "\<And>U. U \<in> \<O> \<Longrightarrow> openin S U"
  shows "base_in S \<O> \<longleftrightarrow> (\<forall>U. openin S U \<longrightarrow> (\<forall>x\<in>U. \<exists>W\<in>\<O>. x \<in> W \<and> W \<subseteq> U))"
proof
  assume h:"base_in S \<O>"
  show "\<forall>U. openin S U \<longrightarrow> (\<forall>x\<in>U. \<exists>W\<in>\<O>. x \<in> W \<and> W \<subseteq> U)"
  proof safe
    fix U x
    assume h':"openin S U" "x \<in> U"
    then obtain \<U> where hu: "U = \<Union>\<U>" "\<U> \<subseteq> \<O>"
      using h by(auto simp: base_in_def)
    then obtain W where "x \<in> W" "W \<in> \<U>"
      using h'(2) by blast
    thus "\<exists>W\<in>\<O>. x \<in> W \<and> W \<subseteq> U"
      using hu by(auto intro!: bexI[where x=W])
  qed
next
  assume h:"\<forall>U. openin S U \<longrightarrow> (\<forall>x\<in>U. \<exists>W\<in>\<O>. x \<in> W \<and> W \<subseteq> U)"
  show "base_in S \<O>"
    unfolding base_in_def
  proof safe
    fix U
    assume "openin S U"
    then have "\<forall>x\<in>U. \<exists>W. W\<in>\<O> \<and> x \<in> W \<and> W \<subseteq> U"
      using h by blast
    hence "\<exists>W. \<forall>x\<in>U. W x \<in> \<O> \<and> x \<in> W x \<and> W x \<subseteq> U"
      by(rule bchoice)
    then obtain W where hw:
     "\<forall>x\<in>U. W x \<in> \<O> \<and> x \<in> W x \<and> W x \<subseteq> U" by auto
    thus "\<exists>\<U>. U = \<Union> \<U> \<and> \<U> \<subseteq> \<O>"
      by(auto intro!: exI[where x="W ` U"])
  next
    fix U \<U>
    show "\<U> \<subseteq> \<O> \<Longrightarrow> openin S (\<Union> \<U>)"
      using assms by auto
  qed
qed

lemma base_in_def2':
 "base_in S \<O> \<longleftrightarrow> (\<forall>b\<in>\<O>. openin S b) \<and> (\<forall>x. openin S x \<longrightarrow> (\<exists>B'\<subseteq>\<O>. \<Union> B' = x))"
proof
  assume h:"base_in S \<O>"
  show "(\<forall>b\<in>\<O>. openin S b) \<and> (\<forall>x. openin S x \<longrightarrow> (\<exists>B'\<subseteq>\<O>. \<Union> B' = x))"
  proof(rule conjI)
    show "\<forall>b\<in>\<O>. openin S b"
      using openin_base[OF h,of _ "{_}"] by auto
  next
    show "\<forall>x. openin S x \<longrightarrow> (\<exists>B'\<subseteq>\<O>. \<Union> B' = x)"
      using h by(auto simp: base_in_def)
  qed
next
  assume h:"(\<forall>b\<in>\<O>. openin S b) \<and> (\<forall>x. openin S x \<longrightarrow> (\<exists>B'\<subseteq>\<O>. \<Union> B' = x))"
  show "base_in S \<O>"
    unfolding base_in_def
  proof safe
    fix U
    assume "openin S U"
    then obtain B' where "B'\<subseteq>\<O>" "\<Union> B' = U"
      using h by blast
    thus "\<exists>\<U>. U = \<Union> \<U> \<and> \<U> \<subseteq> \<O>"
      by(auto intro!: exI[where x=B'])
  next
    fix U \<U>
    show "\<U> \<subseteq> \<O> \<Longrightarrow> openin S (\<Union> \<U>)"
      using h by auto
  qed
qed

corollary base_in_in_subset:
  assumes "base_in S \<O>" "openin S u" "x \<in> u"
  shows "\<exists>v\<in>\<O>. x \<in> v \<and> v \<subseteq> u"
  using assms base_in_def2 base_in_def2' by fastforce

lemma base_in_without_empty:
  assumes "base_in S \<O>"
  shows "base_in S {U \<in> \<O>. U \<noteq> {}}"
  unfolding base_in_def2'
proof safe
  fix x
  assume "x \<in> \<O>" " \<not> openin S x"
  thus "\<And>y. y \<in> {}"
    using base_in_openin[OF assms \<open>x \<in> \<O>\<close>] by simp
next
  fix x
  assume "openin S x"
  then obtain B' where "B' \<subseteq>\<O>" "\<Union> B' = x"
    using assms by(simp add: base_in_def2') metis
  thus "\<exists>B'\<subseteq>{U \<in> \<O>. U \<noteq> {}}. \<Union> B' = x"
    by(auto intro!: exI[where x="{y \<in> B'. y \<noteq> {}}"])
qed

lemma second_countable_ex_without_empty:
  assumes "second_countable S"
  shows "\<exists>\<O>. countable \<O> \<and> base_in S \<O> \<and> (\<forall>U\<in>\<O>. U \<noteq> {})"
proof -
  obtain \<O> where "countable \<O>" "base_in S \<O>"
    using assms second_countable_base_in by blast
  thus ?thesis
    by(auto intro!: exI[where x="{U \<in> \<O>. U \<noteq> {}}"] base_in_without_empty)
qed

lemma subtopology_subbase_in:
  assumes "subbase_in S \<O>"
  shows "subbase_in (subtopology S T) {T \<inter> U | U. U \<in> \<O>}"
  using assms subtopology_generated_by
  by(auto simp: subbase_in_def)

lemma subtopology_base_in:
  assumes "base_in S \<O>"
  shows "base_in (subtopology S T) {T \<inter> U | U. U \<in> \<O>}"
  unfolding base_in_def
proof
  fix L
  show "openin (subtopology S T) L = (\<exists>\<U>. L = \<Union> \<U> \<and> \<U> \<subseteq> {T \<inter> U |U. U \<in> \<O>})"
  proof
    assume "openin (subtopology S T) L "
    then obtain T' where ht:
       "openin S T'" "L = T' \<inter> T"
      by(auto simp: openin_subtopology)
    then obtain \<U> where hu:
      "T' = (\<Union> \<U>)" "\<U> \<subseteq> \<O>"
      using assms by(auto simp: base_in_def)
    show "\<exists>\<U>. L = \<Union> \<U> \<and> \<U> \<subseteq> {T \<inter> U |U. U \<in> \<O>}"
      using hu ht by(auto intro!: exI[where x="{T \<inter> U | U. U \<in> \<U>}"])
  next
    assume "\<exists>\<U>. L = \<Union> \<U> \<and> \<U> \<subseteq> {T \<inter> U |U. U \<in> \<O>}"
    then obtain \<U> where hu: "L = \<Union> \<U>" "\<U> \<subseteq> {T \<inter> U |U. U \<in> \<O>}"
      by auto
    hence "\<forall>U\<in>\<U>. \<exists>U'\<in>\<O>. U = T \<inter> U'" by blast
    then obtain k where hk:"\<And>U. U \<in> \<U> \<Longrightarrow> k U \<in> \<O>" "\<And>U. U \<in> \<U> \<Longrightarrow> U = T \<inter> k U"
      by metis
    hence "L =  \<Union> {T \<inter> k U |U. U \<in> \<U>}" 
      using hu by auto
    also have "... = \<Union> {k U |U. U \<in> \<U>} \<inter> T" by auto
    finally have 1:"L = \<Union> {k U |U. U \<in> \<U>} \<inter> T" .
    moreover have "openin S (\<Union> {k U |U. U \<in> \<U>})"
      using hu hk assms by(auto simp: base_in_def)
    ultimately show "openin (subtopology S T) L"
      by(auto intro!: exI[where x="\<Union> {k U |U. U \<in> \<U>}"] simp: openin_subtopology)
  qed
qed

lemma second_countable_subtopology:
  assumes "second_countable S"
  shows "second_countable (subtopology S T)"
proof -
  obtain \<O> where "countable \<O>" "base_in S \<O>"
    using assms second_countable_base_in by blast
  thus ?thesis
    by(auto intro!: exI[where x="{T \<inter> U | U. U \<in> \<O>}"] simp: second_countable_base_in Setcompr_eq_image dest: subtopology_base_in)
qed

lemma open_map_with_base:
  assumes "base_in S \<O>" "\<And>A. A \<in> \<O> \<Longrightarrow> openin S' (f ` A)"
  shows "open_map S S' f"
  unfolding open_map_def
proof safe
  fix U
  assume "openin S U"
  then obtain \<U> where "U = \<Union>\<U>" "\<U> \<subseteq> \<O>"
    using assms(1) by(auto simp: base_in_def)
  hence "f ` U = \<Union>{ f ` A | A. A \<in> \<U>}" by blast
  also have "openin S' ..."
    using assms(2) \<open>\<U> \<subseteq> \<O>\<close> by auto
  finally show "openin S' (f ` U)" .
qed

text \<open> Construct a base from a subbase.\<close>

lemma finite'_intersection_of_idempot [simp]:
   "finite' intersection_of finite' intersection_of P = finite' intersection_of P"
proof
  fix A
  show "(finite' intersection_of finite' intersection_of P) A = (finite' intersection_of P) A"
  proof
    assume "(finite' intersection_of finite' intersection_of P) A"
    then obtain \<U> where \<U>:"finite' \<U> \<and> \<U> \<subseteq> Collect (finite' intersection_of P) \<and> \<Inter>\<U> = A"
      by(auto simp: intersection_of_def)
    hence "\<forall>U\<in>\<U>. \<exists>\<U>'. finite' \<U>' \<and> \<U>' \<subseteq> Collect P \<and> \<Inter>\<U>' = U"
      by(auto simp: intersection_of_def)
    then obtain \<U>' where \<U>':
     "\<And>U. U \<in> \<U> \<Longrightarrow> finite' (\<U>' U)" "\<And>U. U \<in> \<U> \<Longrightarrow> \<U>' U \<subseteq> Collect P" "\<And>U. U \<in> \<U> \<Longrightarrow> \<Inter>(\<U>' U) = U"
      by metis
    have 1: "\<Inter> (\<Union> (\<U>' ` \<U>)) = A"
      using  \<U> \<U>'(3) by blast
    show "(finite' intersection_of P) A"
      unfolding intersection_of_def
      using \<U> \<U>'(1,2) 1 by(auto intro!: exI[where x="\<Union>U\<in>\<U>. \<U>' U"])
  qed(rule finite'_intersection_of_inc)
qed

lemma finite'_intersection_of_countable:
  assumes "countable \<O>"
  shows "countable (Collect (finite' intersection_of (\<lambda>x. x \<in> \<O>)))"
proof -
  have "Collect (finite' intersection_of (\<lambda>x. x \<in> \<O>)) = (\<Union>i\<in>{\<O>'. \<O>' \<noteq> {} \<and> finite \<O>' \<and> \<O>' \<subseteq> \<O>}. {\<Inter> i})"
    by(auto simp: intersection_of_def)
  also have "countable ..."
    using  countable_Collect_finite_subset[OF assms] 
    by(auto intro!: countable_UN[of "{ \<O>'. \<O>' \<noteq> {} \<and> finite \<O>' \<and> \<O>' \<subseteq> \<O>}" "\<lambda>\<O>'. {\<Inter>\<O>'}"])
      (auto intro!: countable_subset[of "{\<O>'. \<O>' \<noteq> {} \<and> finite \<O>' \<and> \<O>' \<subseteq> \<O>}" "{A. finite A \<and> A \<subseteq> \<O>}"])
  finally show ?thesis .
qed

lemma finite'_intersection_of_openin:
  assumes "(finite' intersection_of (\<lambda>x. x \<in> \<O>)) U"
  shows "openin (topology_generated_by \<O>) U"
  unfolding openin_topology_generated_by_iff
  using assms by(auto simp: generate_topology_on_eq arbitrary_union_of_inc)

lemma topology_generated_by_finite_intersections:
 "topology_generated_by \<O> = topology_generated_by (Collect (finite' intersection_of (\<lambda>x. x \<in> \<O>)))"
  unfolding topology_eq openin_topology_generated_by_iff by(simp add: generate_topology_on_eq)

lemma base_from_subbase:
  assumes "subbase_in S \<O>"
  shows "base_in S (Collect (finite' intersection_of (\<lambda>x. x \<in> \<O>)))"
  unfolding subbase_in_def base_in_def assms[simplified subbase_in_def] openin_topology_generated_by_iff
  by(auto simp: arbitrary_def union_of_def generate_topology_on_eq)

lemma countable_base_from_countable_subbase:
  assumes "countable \<O>" and "subbase_in S \<O>"
  shows "second_countable S"
  using finite'_intersection_of_countable[OF assms(1)] base_from_subbase[OF assms(2)]
  by(auto simp: second_countable_base_in)

lemma prod_topology_second_countable:
  assumes "second_countable S" and "second_countable S'"
  shows "second_countable (prod_topology S S')"
proof -
  obtain \<O> \<O>' where ho:
   "countable \<O>" "base_in S \<O>" "countable \<O>'" "base_in S' \<O>'"
    using assms by(auto simp: second_countable_base_in)
  show ?thesis
  proof(rule countable_base_from_countable_subbase[where \<O>="{ U \<times> V | U V. U \<in> \<O> \<and> V \<in> \<O>'}"])
    have "{U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<O>'} = (\<lambda>(U,V). U \<times> V) ` (\<O> \<times> \<O>')"
      by auto
    also have "countable ..."
      using ho(1,3) by auto
    finally show "countable {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<O>'}" .
  next
    show "subbase_in (prod_topology S S') {U \<times> V |U V. U \<in> \<O> \<and> V \<in> \<O>'}"
      using base_is_subbase[OF ho(2)] base_is_subbase[OF ho(4)]
      by(simp add: subbase_in_def prod_topology_generated_by)
  qed
qed

text \<open> Abstract version of the theorem @{thm product_topology_countable_basis}.\<close>
lemma product_topology_countable_base_in:
  assumes "countable I" and "\<And>i. i \<in> I \<Longrightarrow> second_countable (S i)"
  shows "\<exists>\<O>'. countable \<O>' \<and> base_in (product_topology S I) \<O>' \<and>
             (\<forall>k \<in> \<O>'. \<exists>X. k = (\<Pi>\<^sub>E i\<in>I. X i) \<and> (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)} \<and> {i. X i \<noteq> topspace (S i)} \<subseteq> I)"
proof -
  obtain \<O> where ho:
  "\<And>i. i \<in> I \<Longrightarrow> countable (\<O> i)" "\<And>i. i \<in> I \<Longrightarrow> base_in (S i) (\<O> i)"
    using assms(2)[simplified second_countable_base_in] by metis
  show ?thesis
    unfolding second_countable_base_in
  proof(intro exI[where x="{\<Pi>\<^sub>E i\<in>I. U i | U. finite {i\<in>I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i\<in>I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i)}"] conjI)
    show "countable {\<Pi>\<^sub>E i\<in>I. U i | U. finite {i\<in>I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i\<in>I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i)}"
         (is "countable ?X")
    proof -
      have "?X  = {\<Pi>\<^sub>E i\<in>I. U i | U. finite {i\<in>I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i\<in>I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i) \<and> (\<forall>i \<in>(UNIV- I). U i = {undefined})}"
           (is "_ = ?Y")
      proof (rule set_eqI)
        show "\<And>x. x \<in> ?X \<longleftrightarrow> x \<in> ?Y"
        proof
          fix x
          assume "x \<in> ?X"
          then obtain U where hu:
         "x = (\<Pi>\<^sub>E i\<in>I. U i)" "finite {i\<in>I. U i \<noteq> topspace (S i)}" "(\<forall>i\<in>{i\<in>I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i)"
            by auto
          define U' where "U' i \<equiv> (if i \<in> I then U i else {undefined})" for i
          have "x = (\<Pi>\<^sub>E i\<in>I. U' i)"
            using hu(1) by(auto simp: U'_def PiE_def extensional_def Pi_def)
          moreover have "finite {i\<in>I. U' i \<noteq> topspace (S i)}" "(\<forall>i\<in>{i\<in>I. U' i \<noteq> topspace (S i)}. U' i \<in> \<O> i)" "\<forall>i \<in>(UNIV- I). U' i = {undefined}"
            using hu(2,3) by(auto simp: U'_def) (metis (mono_tags, lifting) Collect_cong)
          ultimately show "x \<in> ?Y" by auto
        qed auto
      qed
      also have "... = (\<lambda>U. \<Pi>\<^sub>E i\<in>I. U i) ` {U. finite {i\<in>I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i\<in>I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i) \<and> (\<forall>i \<in>(UNIV- I). U i = {undefined})}" by auto
      also have "countable ..."
      proof(rule countable_image)
        have "{U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})} = {U. \<exists>I'. finite I' \<and> I' \<subseteq> I \<and> (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>(I - I'). U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
            (is "?A = ?B")
        proof (rule set_eqI)
          show "\<And>x. x \<in> ?A \<longleftrightarrow> x \<in> ?B"
          proof
            fix U
            assume "U \<in> {U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
            then show "U \<in> {U. \<exists>I'. finite I' \<and> I' \<subseteq> I \<and> (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
              by auto
          next
            fix U
            assume assm:"U \<in> {U. \<exists>I'. finite I' \<and> I' \<subseteq> I \<and> (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
            then obtain I' where hi':
               "finite I'" "I' \<subseteq> I" "\<forall>i\<in>I'. U i \<in> \<O> i" "\<forall>i\<in>I - I'. U i = topspace (S i)" "\<forall>i\<in>UNIV - I. U i = {undefined}"
              by auto
            then have "\<And>i. i \<in> I \<Longrightarrow> U i \<noteq> topspace (S i) \<Longrightarrow> i \<in> I'" by auto
            hence "{i \<in> I. U i \<noteq> topspace (S i)} \<subseteq> I'" by auto
            hence "finite {i \<in> I. U i \<noteq> topspace (S i)}"
              using hi'(1) by (simp add: rev_finite_subset) 
            thus "U \<in> {U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
              using hi' by auto
          qed
        qed
        also have "... = (\<Union>I'\<in>{I'. finite I' \<and> I' \<subseteq> I}. {U. (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})})"
          by auto
        also have "countable ..."
        proof(rule countable_UN[OF countable_Collect_finite_subset[OF assms(1)]])
          fix I'
          assume "I' \<in> {I'. finite I' \<and> I' \<subseteq> I}"
          hence hi':"finite I'" "I' \<subseteq> I" by auto
          have "(\<lambda>U i. if i \<in> I' then U i else undefined) ` {U. (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})} \<subseteq> (\<Pi>\<^sub>E i\<in>I'. \<O> i)"
            by auto
          moreover have "countable ..."
            using hi' by(auto intro!: countable_PiE ho)
          ultimately have "countable ((\<lambda>U i. if i \<in> I' then U i else undefined) ` {U. (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})})"
            by(simp add: countable_subset)
          moreover have "inj_on (\<lambda>U i. if i \<in> I' then U i else undefined) {U. (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
                        (is "inj_on ?f ?X")
          proof
            fix x y
            assume hxy: "x \<in> ?X" "y \<in> ?X" "?f x = ?f y"
            show "x = y"
            proof
              fix i
              consider "i \<in> I'" | "i \<in> I - I'" | "i \<in> UNIV - I"
                using hi'(2) by blast
              then show "x i = y i"
              proof cases
                case i:1
                then show ?thesis
                  using fun_cong[OF hxy(3),of i] by auto
              next
                case i:2
                then show ?thesis
                  using hxy(1,2) by auto
              next
                case i:3
                then show ?thesis
                  using hxy(1,2) by auto
              qed
            qed
          qed
          ultimately show "countable {U. (\<forall>i\<in>I'. U i \<in> \<O> i) \<and> (\<forall>i\<in>I - I'. U i = topspace (S i)) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}"
            using countable_image_inj_on by auto
        qed
        finally show "countable {U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i) \<and> (\<forall>i\<in>UNIV - I. U i = {undefined})}" .
      qed
      finally show ?thesis .
    qed
  next
    show "base_in (product_topology S I) {\<Pi>\<^sub>E i\<in>I. U i |U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i)}"
         (is "base_in (product_topology S I) ?X")
      unfolding base_in_def
    proof safe
      fix U
      assume "openin (product_topology S I) U"
      then have "\<forall>x\<in>U. \<exists>Ux. finite {i \<in> I. Ux i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>I. openin (S i) (Ux i)) \<and> x \<in> Pi\<^sub>E I Ux \<and> Pi\<^sub>E I Ux \<subseteq> U"
        by(simp add: openin_product_topology_alt)
      hence "\<exists>Ux. \<forall>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>I. openin (S i) (Ux x i)) \<and> x \<in> Pi\<^sub>E I (Ux x) \<and> Pi\<^sub>E I (Ux x) \<subseteq> U"
        by(rule bchoice)
      then obtain Ux where hui:
       "\<And>x. x \<in> U \<Longrightarrow> finite {i \<in> I. Ux x i \<noteq> topspace (S i)}" "\<And>x i. x \<in> U \<Longrightarrow> i \<in> I \<Longrightarrow> openin (S i) (Ux x i)" "\<And>x. x \<in> U \<Longrightarrow> x \<in> Pi\<^sub>E I (Ux x)" "\<And>x. x \<in> U \<Longrightarrow> Pi\<^sub>E I (Ux x) \<subseteq> U"
        by fastforce
      then have 1:"\<forall>x\<in>U. \<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. \<exists>\<U>xj. \<U>xj \<subseteq> \<O> i \<and> Ux x i = \<Union> \<U>xj"
        using ho[simplified base_in_def] by (metis (no_types, lifting) mem_Collect_eq) 
      have "\<forall>x\<in>U. \<exists>\<U>xj. \<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. \<U>xj i \<subseteq> \<O> i \<and> Ux x i = \<Union> (\<U>xj i)"
        by(standard, rule bchoice) (use 1 in simp)
      hence "\<exists>\<U>xj. \<forall>x\<in>U. \<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. \<U>xj x i \<subseteq> \<O> i \<and> Ux x i = \<Union> (\<U>xj x i)"
        by(rule bchoice)
      then obtain \<U>xj where
       "\<forall>x\<in>U. \<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. \<U>xj x i \<subseteq> \<O> i \<and> Ux x i = \<Union> (\<U>xj x i)"
        by auto
      hence huxj: "\<And>x i. x \<in> U \<Longrightarrow> i \<in> {i \<in> I. Ux x i \<noteq> topspace (S i)} \<Longrightarrow> \<U>xj x i \<subseteq> \<O> i"
                  "\<And>x i. x \<in> U \<Longrightarrow> i \<in> {i \<in> I. Ux x i \<noteq> topspace (S i)} \<Longrightarrow> Ux x i = \<Union> (\<U>xj x i)"
        by blast+
      show "\<exists>\<U>. U = \<Union> \<U> \<and> \<U> \<subseteq> ?X"
      proof(intro exI[where x="{\<Pi>\<^sub>E i\<in>I. K i | K. \<exists>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i \<in> \<U>xj x i) \<and> (\<forall>i\<in>UNIV -{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i = topspace (S i))}"] conjI)
        show "U = \<Union> {\<Pi>\<^sub>E i\<in>I. K i | K. \<exists>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i \<in> \<U>xj x i) \<and> (\<forall>i\<in>UNIV -{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i = topspace (S i))}"
        proof safe
          fix x
          assume hxu:"x \<in> U"
          have "\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. Ux x i = \<Union> (\<U>xj x i)"
            using huxj[OF hxu] by blast
          hence "\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. \<exists>Uxj. Uxj \<in> \<U>xj x i \<and> x i \<in> Uxj"
            using hui(3)[OF hxu] by auto
          hence "\<exists>Uxj. \<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. Uxj i \<in> \<U>xj x i \<and> x i \<in> Uxj i"
            by(rule bchoice)
          then obtain Uxj where huxj':
             "\<And>i. i \<in> {i \<in> I. Ux x i \<noteq> topspace (S i)} \<Longrightarrow> Uxj i \<in> \<U>xj x i"
             "\<And>i. i \<in> {i \<in> I. Ux x i \<noteq> topspace (S i)} \<Longrightarrow> x i \<in> Uxj i"
            by auto
          define K where "K \<equiv> (\<lambda>i. if i \<in> {i \<in> I. Ux x i \<noteq> topspace (S i)} then Uxj i else topspace (S i))"
          have "x \<in> (\<Pi>\<^sub>E i\<in>I. K i)"
            using huxj'(2) hui(3,4)[OF hxu] openin_subset[OF hui(2)[OF hxu]]
            by(auto simp: K_def PiE_def Pi_def)
          moreover have "\<exists>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i \<in> \<U>xj x i) \<and> (\<forall>i\<in>UNIV -{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i = topspace (S i))"
            by(rule bexI[OF _ hxu], rule conjI,simp add: hui(1)[OF hxu]) (use hui(2) hxu openin_subset huxj'(1)  K_def in auto)
          ultimately show "x \<in> \<Union> {\<Pi>\<^sub>E i\<in>I. K i | K. \<exists>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i \<in> \<U>xj x i) \<and> (\<forall>i\<in>UNIV -{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i = topspace (S i))}"
            by auto
        next
          fix x X K u
          assume  hu: "x \<in> (\<Pi>\<^sub>E i\<in>I. K i)"  "u \<in> U" "finite {i \<in> I. Ux u i \<noteq> topspace (S i)}" "\<forall>i\<in>{i \<in> I. Ux u i \<noteq> topspace (S i)}. K i \<in> \<U>xj u i" "\<forall>i\<in>UNIV -{i \<in> I. Ux u i \<noteq> topspace (S i)}. K i = topspace (S i)"            
          have "\<And>i. i \<in> {i \<in> I. Ux u i \<noteq> topspace (S i)} \<Longrightarrow> K i \<subseteq> Ux u i"
            using huxj[OF hu(2)] hu(4) by blast
          moreover have "\<And>i. i \<in> I - {i \<in> I. Ux u i \<noteq> topspace (S i)} \<Longrightarrow> K i = Ux u i"
            using hu(5) by auto
          ultimately have "\<And>i. i \<in> I \<Longrightarrow> K i \<subseteq> Ux u i"
            by blast
          thus "x \<in> U"
            using hui(4)[OF hu(2)] hu(1) by blast
        qed
      next
        show "{\<Pi>\<^sub>E i\<in>I. K i | K. \<exists>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i \<in> \<U>xj x i) \<and> (\<forall>i\<in>UNIV -{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i = topspace (S i))} \<subseteq> ?X"
        proof
          fix x
          assume "x \<in> {\<Pi>\<^sub>E i\<in>I. K i | K. \<exists>x\<in>U. finite {i \<in> I. Ux x i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i \<in> \<U>xj x i) \<and> (\<forall>i\<in>UNIV -{i \<in> I. Ux x i \<noteq> topspace (S i)}. K i = topspace (S i))}"
          then obtain u K where hu:
           "x = (\<Pi>\<^sub>E i\<in>I. K i)"  "u \<in> U" "finite {i \<in> I. Ux u i \<noteq> topspace (S i)}" "\<forall>i\<in>{i \<in> I. Ux u i \<noteq> topspace (S i)}. K i \<in> \<U>xj u i" "\<forall>i\<in>UNIV -{i \<in> I. Ux u i \<noteq> topspace (S i)}. K i = topspace (S i)"
            by auto
          have hksubst:"{i \<in> I. K i \<noteq> topspace (S i)} \<subseteq> {i \<in> I. Ux u i \<noteq> topspace (S i)}"
            using hu(5) by fastforce
          hence "finite {i \<in> I. K i \<noteq> topspace (S i)}"
            using hu(3) by (simp add: finite_subset)
          moreover have "\<forall>i\<in>{i \<in> I. K i \<noteq> topspace (S i)}. K i \<in> \<O> i"
            using huxj(1)[OF hu(2)] hu(4) hksubst
            by (meson subsetD)
          ultimately show "x \<in> ?X"
            using hu(1) by auto
        qed
      qed
    next
      fix \<U>
      assume "\<U> \<subseteq> ?X"
      have "openin (product_topology S I) u" if hu:"u \<in> \<U>" for u
      proof -
        have hu': "u \<in> ?X"
          using \<open>\<U> \<subseteq> ?X\<close> hu by auto
        then obtain U where hU:
       "u = (\<Pi>\<^sub>E i\<in>I. U i)" "finite {i \<in> I. U i \<noteq> topspace (S i)}" "\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i"
          by auto
        define U' where "U' \<equiv> (\<lambda>i. if i \<in> {i \<in> I. U i \<noteq> topspace (S i)} then U i else topspace (S i))"
        have hU': "u = (\<Pi>\<^sub>E i\<in>I. U' i)"
          by(auto simp: hU(1) U'_def PiE_def Pi_def)
        have hUfinite : "finite {i. U' i \<noteq> topspace (S i)}"
          using hU(2) by(auto simp: U'_def)
        have hUoi: "\<forall>i\<in>{i. U' i \<noteq> topspace (S i)}. U' i \<in> \<O> i"
          using hU(3) by(auto simp: U'_def)
        have hUi: "\<forall>i\<in>{i. U' i \<noteq> topspace (S i)}. i \<in> I"
          using hU(2) by(auto simp: U'_def)
        have hallopen:"openin (S i) (U' i)" for i
        proof -
          consider "i \<in> {i. U' i \<noteq> topspace (S i)}" | "i \<notin> {i. U' i \<noteq> topspace (S i)}" by auto
          then show ?thesis
          proof cases
            case 1
            then show ?thesis
              using hUoi ho(2)[of i] base_in_openin[of "S i" "\<O> i" "U' i"] hUi
              by auto
          next
            case 2
            then have "U' i = topspace (S i)" by auto
            thus ?thesis by auto
          qed
        qed
        show "openin (product_topology S I) u"
          using hallopen hUfinite by(auto intro!: product_topology_basis simp: hU')
      qed
      thus "openin (product_topology S I) (\<Union> \<U>)"
        by auto
    qed
  next
    show "\<forall>k\<in>{Pi\<^sub>E I U |U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i)}. \<exists>X. k = Pi\<^sub>E I X \<and> (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)} \<and> {i. X i \<noteq> topspace (S i)} \<subseteq> I"
    proof
      fix k
      assume "k \<in> {Pi\<^sub>E I U |U. finite {i \<in> I. U i \<noteq> topspace (S i)} \<and> (\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i)}"
      then obtain U where hu:
         "k = (\<Pi>\<^sub>E i\<in>I. U i)" "finite {i \<in> I. U i \<noteq> topspace (S i)}" "\<forall>i\<in>{i \<in> I. U i \<noteq> topspace (S i)}. U i \<in> \<O> i"
        by auto
      define X where "X \<equiv> (\<lambda>i. if i \<in> {i \<in> I. U i \<noteq> topspace (S i)} then U i else topspace (S i))"
      have hX1: "k = (\<Pi>\<^sub>E i\<in>I. X i)"
        using hu(1) by(auto simp: X_def PiE_def Pi_def)
      have hX2: "openin (S i) (X i)" for i
        using hu(3) base_in_openin[of "S i" _ "U i",OF ho(2)]
        by(auto simp: X_def)
      have hX3: "finite {i. X i \<noteq> topspace (S i)}"
        using hu(2) by(auto simp: X_def)
      have hX4: "{i. X i \<noteq> topspace (S i)} \<subseteq> I"
        by(auto simp: X_def)
      show "\<exists>X. k = (\<Pi>\<^sub>E i\<in>I. X i) \<and> (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)} \<and> {i. X i \<noteq> topspace (S i)} \<subseteq> I"
        using hX1 hX2 hX3 hX4 by(auto intro!: exI[where x=X])
    qed
  qed
qed

lemma product_topology_second_countable:
  assumes "countable I" and "\<And>i. i \<in> I \<Longrightarrow> second_countable (S i)"
  shows "second_countable (product_topology S I)"
  using product_topology_countable_base_in[OF assms(1)] assms(2)
  by(fastforce simp: second_countable_base_in)

lemma second_countable_euclidean[simp]:
 "second_countable (euclidean :: 'a :: second_countable_topology topology)"
  using ex_countable_basis second_countable_def topological_basis_def by fastforce

lemma Cantor_Bendixon:
  assumes "second_countable X"
  shows "\<exists>U P. countable U \<and> openin X U \<and> perfect_set X P \<and> U \<union> P = topspace X \<and> U \<inter> P = {} \<and> (\<forall>a\<noteq>{}. openin (subtopology X P) a \<longrightarrow> uncountable a)"
proof -
  obtain \<O> where o: "countable \<O>" "base_in X \<O>"
    using assms by(auto simp: second_countable_base_in)
  define U where "U \<equiv> \<Union> {u\<in>\<O>. countable u}"
  define P where "P \<equiv> topspace X - U"
  have 1: "countable U"
    using o(1) by(auto simp: U_def intro!: countable_UN[of _ id,simplified])
  have 2: "openin X U"
    using base_in_openin[OF o(2)] by(auto simp: U_def)
  have openin_c:"countable v \<longleftrightarrow> v \<subseteq> U" if "openin X v" for v
  proof
    assume "countable v"
    obtain \<U> where "v = \<Union>\<U>" "\<U> \<subseteq> \<O>"
      using \<open>openin X v\<close> o(2) by(auto simp: base_in_def)
    with \<open>countable v\<close> have "\<And>u. u \<in> \<U> \<Longrightarrow> countable u"
      by (meson Sup_upper countable_subset)
    thus "v \<subseteq> U"
      using \<open>\<U> \<subseteq> \<O>\<close> by(auto simp: \<open>v = \<Union>\<U>\<close> U_def)
  qed(rule countable_subset[OF _ 1])
  have 3: "perfect_set X P"
  proof(rule perfect_setI)
    fix x T
    assume h:"x \<in> P" "x \<in> T" "openin X T"
    have T_unc:"uncountable T"
      using openin_c[OF h(3)] h(1,2) by(auto simp: P_def)
    obtain \<U> where U:"T = \<Union>\<U>" "\<U> \<subseteq> \<O>"
      using h(3) o(2) by(auto simp: base_in_def)
    then obtain u where u:"u \<in> \<U>" "uncountable u"
      using T_unc U_def h(3) openin_c by auto
    hence "uncountable (u - {x})" by simp
    hence "\<not> (u - {x} \<subseteq> U)"
      using 1 by (metis countable_subset) 
    then obtain y where "y \<in> u - {x}" "y \<notin> U"
      by blast
    thus "\<exists>y. y \<noteq> x \<and> y \<in> T \<and> y \<in> P"
      using U u base_in_subset[OF o(2),of u] by(auto intro!: exI[where x=y] simp:P_def)
  qed(use 2 P_def in auto)
  have 4 : "uncountable a" if "openin (subtopology X P) a" "a \<noteq> {}" for a
  proof
    assume contable:"countable a"
    obtain b where b: "openin X b" "a = P \<inter> b"
      using \<open>openin (subtopology X P) a\<close> by(auto simp: openin_subtopology)
    hence "uncountable b"
      using P_def openin_c that(2) by auto
    thus False
      by (metis 1 Diff_Int_distrib2 Int_absorb1 P_def b(1) b(2) contable countable_Int1 openin_subset uncountable_minus_countable)
  qed
  show ?thesis
    using 1 2 3 4 by(auto simp: P_def)
qed

subsubsection \<open> Separable Spaces \<close>
definition dense_in :: "['a topology, 'a set] \<Rightarrow> bool" where
"dense_in S U \<longleftrightarrow> (U \<subseteq> topspace S \<and> (\<forall>V. openin S V \<longrightarrow> V \<noteq> {} \<longrightarrow> U \<inter> V \<noteq> {}))"

lemma dense_in_def2:
 "dense_in S U \<longleftrightarrow> (U \<subseteq> topspace S \<and> (S closure_of U) = topspace S)"
  using dense_intersects_open by(auto simp: dense_in_def closure_of_subset_topspace in_closure_of) auto

lemma dense_in_topspace[simp]: "dense_in S (topspace S)"
  by(auto simp: dense_in_def2)

lemma dense_in_subset:
  assumes "dense_in S U"
  shows "U \<subseteq> topspace S"
  using assms by(simp add: dense_in_def)

lemma dense_in_nonempty:
  assumes "topspace S \<noteq> {}" "dense_in S U"
  shows "U \<noteq> {}"
  using assms by(auto simp: dense_in_def)

lemma dense_inI:
  assumes "U \<subseteq> topspace S"
      and "\<And>V. openin S V \<Longrightarrow> V \<noteq> {} \<Longrightarrow> U \<inter> V \<noteq> {}"
    shows "dense_in S U"
  using assms by(auto simp: dense_in_def)

lemma dense_in_infinite:
  assumes "t1_space X" "infinite (topspace X)" "dense_in X U"
  shows "infinite U"
proof
  assume fin: "finite U"
  then have "closedin X U"
    by (metis assms(1,3) dense_in_def t1_space_closedin_finite)
  hence "X closure_of U = U"
    by (simp add: closure_of_eq)
  thus False
    by (metis assms(2) assms(3) dense_in_def2 fin)
qed

lemma dense_in_prod:
  assumes "dense_in S U" and "dense_in S' U'"
  shows "dense_in (prod_topology S S') (U \<times> U')"
proof(rule dense_inI)
  fix V
  assume h:"openin (prod_topology S S') V" "V \<noteq> {}"
  then obtain x y where hxy:"(x,y) \<in> V" by auto
  then obtain V1 V2 where hv12:
  "openin S V1" "openin S' V2" "x \<in> V1" "y \<in> V2" "V1 \<times> V2 \<subseteq> V"
    using h(1) openin_prod_topology_alt[of S S' V] by blast
  hence "V1 \<noteq> {}" "V2 \<noteq> {}" by auto
  hence "U \<inter> V1 \<noteq> {}" "U' \<inter> V2 \<noteq> {}"
    using assms hv12 by(auto simp: dense_in_def)
  thus "U \<times> U' \<inter> V \<noteq> {}"
    using hv12 by auto
next
  show "U \<times> U' \<subseteq> topspace (prod_topology S S')"
    using assms by(auto simp add: dense_in_def)
qed

lemma separable_space_def2:"separable_space S \<longleftrightarrow> (\<exists>U. countable U \<and> dense_in S U)"
  by(auto simp: separable_space_def dense_in_def2)

lemma countable_space_separable_space:
  assumes "countable (topspace S)"
  shows "separable_space S"
  using assms by(auto simp: separable_space_def2 intro!: exI[where x="topspace S"])

lemma separable_space_prod:
  assumes "separable_space S" and "separable_space S'"
  shows "separable_space (prod_topology S S')"
proof -
  obtain U U' where
    "countable U" "dense_in S U" "countable U'" "dense_in S' U'"
    using assms by(auto simp: separable_space_def2)
  thus ?thesis
    by(auto intro!: exI[where x="U\<times>U'"] dense_in_prod simp: separable_space_def2)
qed

lemma dense_in_product:
  assumes "\<And>i. i \<in> I \<Longrightarrow> dense_in (T i) (U i)"
  shows "dense_in (product_topology T I) (\<Pi>\<^sub>E i\<in>I. U i)"
proof(rule dense_inI)
  fix V
  assume h:"openin (product_topology T I) V" "V \<noteq> {}"
  then obtain x where hx:"x \<in> V" by auto
  then obtain K where hk:
   "finite {i \<in> I. K i \<noteq> topspace (T i)}" "\<forall>i\<in>I. openin (T i) (K i)" "x \<in> (\<Pi>\<^sub>E i\<in>I. K i)" "(\<Pi>\<^sub>E i\<in>I. K i) \<subseteq> V"
    using h(1) openin_product_topology_alt[of T I V] by auto
  hence "\<And>i. i \<in> I \<Longrightarrow> K i \<noteq> {}" by auto
  hence "\<And>i. i \<in> I \<Longrightarrow> U i \<inter> K i \<noteq> {}"
    using assms hk by(auto simp: dense_in_def)
  hence "(\<Pi>\<^sub>E i\<in>I. U i) \<inter> (\<Pi>\<^sub>E i\<in>I. K i) \<noteq> {}"
    by (simp add: PiE_Int PiE_eq_empty_iff) 
  thus "(\<Pi>\<^sub>E i\<in>I. U i) \<inter> V \<noteq> {}"
    using hk by auto
next
  show "(\<Pi>\<^sub>E i\<in>I. U i) \<subseteq> topspace (product_topology T I)"
    using assms by(auto simp: dense_in_def)
qed

lemma separable_countable_product:
  assumes "countable I" and "\<And>i. i \<in> I \<Longrightarrow> separable_space (T i)"
  shows "separable_space (product_topology T I)"
proof -
  consider "\<exists>i\<in>I. T i = trivial_topology" | "\<And>i. i \<in> I \<Longrightarrow> T i \<noteq> trivial_topology"
    by auto
  thus ?thesis
  proof cases
    case 1
    then obtain i where i:"i \<in> I" "topspace (T i) = {}"
      by auto
    show ?thesis
      unfolding separable_space_def2 dense_in_def
    proof(intro exI[where x="{}"] conjI)
      show "\<forall>V. openin (product_topology T I) V \<longrightarrow> V \<noteq> {} \<longrightarrow> {} \<inter> V \<noteq> {}"
      proof safe
        fix V x
        assume h: "openin (product_topology T I) V" "x \<in> V"
        from i have "(product_topology T I) = trivial_topology"
          using product_topology_trivial_iff by auto
        with h(1) have "V = {}"
          by simp
        thus "x \<in> {}"
          using h(2) by auto
      qed
    qed auto
  next
    case 2
    then have "\<exists>x. \<forall>i\<in>I. x i \<in> topspace (T i)" "\<exists>U. \<forall>i\<in>I. countable (U i) \<and> dense_in (T i) (U i)"
      using assms(2) by(auto intro!: bchoice simp: separable_space_def2 ex_in_conv)
    then obtain x U where hxu:
     "\<And>i. i \<in> I \<Longrightarrow> x i \<in> topspace (T i)" "\<And>i. i \<in> I \<Longrightarrow> countable (U i)" "\<And>i. i \<in> I \<Longrightarrow> dense_in (T i) (U i)"
      by auto
    define U' where "U' \<equiv> (\<lambda>J i. if i \<in> J then U i else {x i})"
    show ?thesis
      unfolding separable_space_def2
    proof(intro exI[where x="\<Union>{\<Pi>\<^sub>E i\<in>I. U' J i | J. finite J \<and> J \<subseteq> I}"] conjI)
      have "(\<Union>{ \<Pi>\<^sub>E i\<in>I. U' J i | J. finite J \<and> J \<subseteq> I}) = (\<Union> ((\<lambda>J. \<Pi>\<^sub>E i\<in>I. U' J i) ` {J. finite J \<and> J \<subseteq> I}))"
        by auto
      also have "countable ..."
      proof(rule countable_UN)
        fix J
        assume hj:"J \<in> {J. finite J \<and> J \<subseteq> I}"
        have "inj_on (\<lambda>f. (\<lambda>i\<in>J. f i, \<lambda>i\<in>(I-J). f i)) (\<Pi>\<^sub>E i\<in>I. U' J i)"
        proof(rule inj_onI)
          fix f g
          assume h:"f \<in> Pi\<^sub>E I (U' J)" "g \<in> Pi\<^sub>E I (U' J)"
                   "(restrict f J, restrict f (I - J)) = (restrict g J, restrict g (I - J))"
          then have "\<And>i. i \<in> J \<Longrightarrow> f i = g i" "\<And>i. i \<in>(I-J) \<Longrightarrow> f i = g i"
             by(auto simp: restrict_def) meson+
          thus "f = g"
            using h(1,2) by(auto simp: U'_def) (meson PiE_ext)
        qed
        moreover have "countable ((\<lambda>f. (\<lambda>i\<in>J. f i, \<lambda>i\<in>(I-J). f i)) ` (\<Pi>\<^sub>E i\<in>I. U' J i))" (is "countable ?K")
        proof -
          have 1:"?K \<subseteq> (\<Pi>\<^sub>E i\<in>J. U i) \<times> (\<Pi>\<^sub>E i\<in>(I-J). {x i})"
            using hj by(auto simp: U'_def PiE_def Pi_def)
          have 2:"countable ..."
          proof(rule countable_SIGMA)
            show "countable (Pi\<^sub>E J U)"
              using hj hxu(2) by(auto intro!: countable_PiE)
          next
            have "(\<Pi>\<^sub>E i\<in>I - J. {x i}) = { \<lambda>i\<in>I-J. x i }"
              by(auto simp: PiE_def extensional_def restrict_def Pi_def)
            thus "countable (\<Pi>\<^sub>E i\<in>I - J. {x i})"
              by simp
          qed
          show ?thesis
            by(rule countable_subset[OF 1 2])
        qed
        ultimately show "countable (\<Pi>\<^sub>E i\<in>I. U' J i)"
          by(simp add: countable_image_inj_eq)
      qed(rule countable_Collect_finite_subset[OF assms(1)])
      finally show "countable (\<Union>{ \<Pi>\<^sub>E i\<in>I. U' J i | J. finite J \<and> J \<subseteq> I})" .
    next
      show "dense_in (product_topology T I) (\<Union> {\<Pi>\<^sub>E i\<in>I. U' J i |J. finite J \<and> J \<subseteq> I})"
      proof(rule dense_inI)
        fix V
        assume h:"openin (product_topology T I) V" "V \<noteq> {}"
        then obtain y where hx:"y \<in> V" by auto
        then obtain K where hk:
         "finite {i \<in> I. K i \<noteq> topspace (T i)}" "\<And>i. i\<in>I \<Longrightarrow> openin (T i) (K i)" "y \<in> (\<Pi>\<^sub>E i\<in>I. K i)" "(\<Pi>\<^sub>E i\<in>I. K i) \<subseteq> V"
          using h(1) openin_product_topology_alt[of T I V] by auto
        hence 3:"\<And>i. i \<in> I \<Longrightarrow> K i \<noteq> {}" by auto
        hence 4:"i \<in> {i \<in> I. K i \<noteq> topspace (T i)} \<Longrightarrow> K i \<inter> U' {i \<in> I. K i \<noteq> topspace (T i)} i \<noteq> {}" for i
          using hxu(3)[of i] hk(2)[of i] by(auto simp: U'_def dense_in_def)
        have "\<exists>z. \<forall>i\<in>{i \<in> I. K i \<noteq> topspace (T i)}. z i \<in> K i \<inter> U' {i \<in> I. K i \<noteq> topspace (T i)} i"
          by(rule bchoice) (use 4 in auto)
        then obtain z where hz: "\<forall>i\<in>{i \<in> I. K i \<noteq> topspace (T i)}. z i \<in> K i \<inter> U' {i \<in> I. K i \<noteq> topspace (T i)} i"
          by auto          
        have 5: "i \<notin> {i \<in> I. K i \<noteq> topspace (T i)} \<Longrightarrow> i \<in> I \<Longrightarrow> x i \<in> K i" for i
          using hxu(1)[of i] by auto
        have "(\<lambda>i. if i \<in> {i \<in> I. K i \<noteq> topspace (T i)} then z i else if i \<in> I then x i else undefined) \<in> (\<Pi>\<^sub>E i\<in>I. U' {i \<in> I. K i \<noteq> topspace (T i)} i) \<inter> (\<Pi>\<^sub>E i\<in>I. K i)"
          using 4 5 hz by(auto simp: U'_def)
        thus "\<Union> {Pi\<^sub>E I (U' J) |J. finite J \<and> J \<subseteq> I} \<inter> V \<noteq> {}"
          using hk(1,4) by blast
      next
        have "\<And>J. J \<subseteq> I \<Longrightarrow> (\<Pi>\<^sub>E i\<in>I. U' J i) \<subseteq> topspace (product_topology T I)"
          using hxu by(auto simp: dense_in_def U'_def PiE_def Pi_def) (metis subsetD)
        thus "(\<Union> {\<Pi>\<^sub>E i\<in>I. U' J i |J. finite J \<and> J \<subseteq> I}) \<subseteq> topspace (product_topology T I)"
          by auto
      qed
    qed
  qed
qed

lemma separable_finite_product:
  assumes "finite I" and "\<And>i. i \<in> I \<Longrightarrow> separable_space (T i)"
  shows "separable_space (product_topology T I)"
  using separable_countable_product[OF countable_finite[OF assms(1)]] assms by auto

subsubsection \<open> $G_{\delta}$ Set \<close>
lemma gdelta_inD:
  assumes "gdelta_in S A"
  shows "\<exists>\<U>. \<U> \<noteq> {} \<and> countable \<U> \<and> (\<forall>b\<in>\<U>. openin S b) \<and> A = \<Inter> \<U>"
  using assms unfolding gdelta_in_def relative_to_def intersection_of_def
  by (metis IntD1 Int_insert_right_if1 complete_lattice_class.Inf_insert countable_insert empty_not_insert inf.absorb_iff2 mem_Collect_eq openin_topspace)

lemma gdelta_inD':
  assumes "gdelta_in S A"
  shows "\<exists>U. (\<forall>n::nat. openin S (U n)) \<and> A = \<Inter> (range U)"
proof-
  obtain \<U> where h:"\<U> \<noteq> {}" "countable \<U>" "\<And>b. b\<in>\<U> \<Longrightarrow> openin S b" "A = \<Inter> \<U>"
    using gdelta_inD[OF assms] by metis
  show ?thesis
    using range_from_nat_into[OF h(1,2)] h(3,4)
    by(auto intro!: exI[where x="from_nat_into \<U>"])
qed

lemma gdelta_in_continuous_map:
  assumes "continuous_map X Y f" "gdelta_in Y a"
  shows "gdelta_in X (f -` a \<inter> topspace X)"
proof -
  obtain Ua where u:
  "Ua \<noteq> {}" "countable Ua" "\<And>b. b \<in> Ua \<Longrightarrow> openin Y b" "a = \<Inter> Ua"
    using gdelta_inD[OF assms(2)] by metis
  then have 0:"f -` a \<inter> topspace X = \<Inter> {f -` b \<inter> topspace X|b. b \<in> Ua}"
    by auto
  have 1: "{f -` b \<inter> topspace X |b. b \<in> Ua} \<noteq> {}"
    using u(1) by simp
  have 2:"countable {f -` b \<inter> topspace X|b. b \<in> Ua}"
    using u by (simp add: Setcompr_eq_image)
  have 3:"\<And>c. c \<in> {f -` b \<inter> topspace X|b. b \<in> Ua} \<Longrightarrow> openin X c"
    using assms u(3) by blast
  show ?thesis
    by (metis (mono_tags, lifting) "0" "1" "2" "3" gdelta_in_Inter open_imp_gdelta_in)
qed

lemma g_delta_of_inj_open_map:
  assumes "open_map X Y f" "inj_on f (topspace X)" "gdelta_in X a"
  shows "gdelta_in Y (f ` a)"
proof -
  obtain Ua where u:
  "Ua \<noteq> {}" "countable Ua" "\<And>b. b \<in> Ua \<Longrightarrow> openin X b" "a = \<Inter> Ua"
    using gdelta_inD[OF assms(3)] by metis
  then obtain j where "j \<in> Ua" by auto
  have "f ` a = f ` \<Inter> Ua" by(simp add: u(4))
  also have "... = \<Inter> ((`) f ` Ua)"
    using u openin_subset by(auto intro!: image_INT[OF assms(2) _ \<open>j \<in> Ua\<close>,of id,simplified])
  also have "... = \<Inter> {f ` u|u. u \<in> Ua}" by auto
  finally have 0: "f ` a = \<Inter> {f ` u |u. u \<in> Ua}" .
  have 1:"{f ` u |u. u \<in> Ua} \<noteq> {}"
    using u(1) by auto
  have 2:"countable {f ` u |u. u \<in> Ua}"
    using u(2) by (simp add: Setcompr_eq_image)
  have 3: "\<And>c. c \<in> {f ` u |u. u \<in> Ua} \<Longrightarrow> openin Y c"
    using assms(1) u(3) by(auto simp: open_map_def)
  show ?thesis
    by (metis (no_types, lifting) "0" "1" "2" "3" gdelta_in_Inter open_imp_gdelta_in)
qed

lemma gdelta_in_prod:
  assumes "gdelta_in X A" "gdelta_in Y B"
  shows "gdelta_in (prod_topology X Y) (A \<times> B)"
proof -
  obtain Ua Ub where hu:
  "Ua \<noteq> {}" "countable Ua" "\<And>b. b \<in> Ua \<Longrightarrow> openin X b" "A = \<Inter> Ua"
  "Ub \<noteq> {}" "countable Ub" "\<And>b. b \<in> Ub \<Longrightarrow> openin Y b" "B = \<Inter> Ub"
    by (meson gdelta_inD assms) 
  then have 0:"A \<times> B = \<Inter> {a \<times> b | a b. a \<in> Ua \<and> b \<in> Ub}" by blast
  have 1: "{a \<times> b | a b. a \<in> Ua \<and> b \<in> Ub} \<noteq> {}"
    using hu(1,5) by auto
  have 2: "countable {a \<times> b | a b. a \<in> Ua \<and> b \<in> Ub}"
  proof -
    have "countable ((\<lambda>(x, y). x \<times> y) ` (Ua \<times> Ub))"
      using hu(2,6) by(auto intro!: countable_image[of "Ua \<times> Ub" "\<lambda>(x,y). x \<times> y"])
    moreover have "... = {a \<times> b | a b. a \<in> Ua \<and> b \<in> Ub}" by auto
    ultimately show ?thesis by simp
  qed
  have 3: "\<And>c. c \<in> {a \<times> b | a b. a \<in> Ua \<and> b \<in> Ub} \<Longrightarrow> openin (prod_topology X Y) c"
    using hu(3,7) by(auto simp: openin_prod_Times_iff)
  show ?thesis
    by (metis (no_types, lifting) gdelta_in_Inter open_imp_gdelta_in 0 1 2 3)
qed

corollary gdelta_in_prod1:
  assumes "gdelta_in X A"
  shows "gdelta_in (prod_topology X Y) (A \<times> topspace Y)"
  by(auto intro!: gdelta_in_prod assms)

corollary gdelta_in_prod2:
  assumes "gdelta_in Y B"
  shows "gdelta_in (prod_topology X Y) (topspace X \<times> B)"
  by(auto intro!: gdelta_in_prod assms)

lemma continuous_map_imp_closed_graph':
  assumes "continuous_map X Y f" "Hausdorff_space Y"
  shows "closedin (prod_topology Y X) ((\<lambda>x. (f x,x)) ` topspace X)"
  using assms closed_map_def closed_map_paired_continuous_map_left by blast

subsubsection \<open> Continuous Maps on First Countable Topology\<close>
text \<open> Generalized version of @{thm Metric_space.eventually_atin_sequentially}\<close>
lemma eventually_atin_sequentially:
  assumes "first_countable X"
  shows "eventually P (atin X a) \<longleftrightarrow> (\<forall>\<sigma>. range \<sigma> \<subseteq> topspace X - {a} \<and> limitin X \<sigma> a sequentially \<longrightarrow> eventually (\<lambda>n. P (\<sigma> n)) sequentially)"
proof safe
  fix an
  assume h:"eventually P (atin X a)" "range an \<subseteq> topspace X - {a}" "limitin X an a sequentially"
  then obtain U where U: "openin X U" "a \<in> U" "\<forall>x\<in>U - {a}. P x"
    by (auto simp: eventually_atin limitin_topspace)
  with h(3) obtain N where "\<forall>n\<ge>N. an n \<in> U"
    by (meson limitin_sequentially)
  with U(3) h(2) show "\<forall>\<^sub>F n in sequentially. P (an n)"
    unfolding eventually_sequentially by blast
next
  assume h:"\<forall>an. range an \<subseteq> topspace X - {a} \<and> limitin X an a sequentially \<longrightarrow> (\<forall>\<^sub>F n in sequentially. P (an n))"
  consider "a \<notin> topspace X" | "a \<in> topspace X"
    by blast
  then show "eventually P (atin X a)"
  proof cases
    assume a:"a \<in> topspace X"
    from a assms obtain B' where B': "countable B'" "\<And>V. V \<in> B' \<Longrightarrow> openin X V" "\<And>U. openin X U \<Longrightarrow> a \<in> U \<Longrightarrow> (\<exists>V \<in> B'. a \<in> V \<and> V \<subseteq> U)"
      by(fastforce simp: first_countable_def)
    define B where "B \<equiv> {V\<in>B'. a \<in> V}"
    have B:"\<And>V. V \<in> B \<Longrightarrow> openin X V" "countable B" "B \<noteq> {}"  "\<And>U. openin X U \<Longrightarrow> a \<in> U \<Longrightarrow> (\<exists>V \<in> B. a \<in> V \<and> V \<subseteq> U)"
      using B' B'(3)[OF _ a] by(fastforce simp: B_def)+
    define An where "An \<equiv> (\<lambda>n. \<Inter>i\<le>n. from_nat_into B i)"
    have a_in_An:"a \<in> An n" for n
      by (metis (no_types, lifting) An_def B_def B(3) INT_I from_nat_into mem_Collect_eq)
    have openAn:"\<And>n. openin X (An n)"
      using B by(auto simp: An_def from_nat_into[OF B(3)] openin_Inter)
    have deqseq_An:"decseq An"
      by(fastforce simp: decseq_def An_def)
    have "\<exists>U. openin X U \<and> a \<in> U \<and> Ball (U - {a}) P"
    proof(rule ccontr)
      assume "\<nexists>U. openin X U \<and> a \<in> U \<and> Ball (U - {a}) P"
      then have "\<And>U. openin X U \<Longrightarrow> a \<in> U \<Longrightarrow> \<exists>x \<in> U - {a}. \<not> P x"
        by blast
      hence "\<exists>b\<in>An n - {a}. \<not> P b" for n
        using openAn a_in_An by auto
      then obtain an where an: "\<And>n. an n \<in> An n" "\<And>n. an n \<noteq> a" "\<And>n. \<not> P (an n)"
        by (metis Diff_iff singletonI)
      have "limitin X an a sequentially"
        unfolding limitin_sequentially
      proof safe
        fix U
        assume "openin X U" "a \<in> U"
        then obtain V where V:"a \<in> V" "V \<subseteq> U" "V \<in> B"
          using B by meson
        then obtain N where "V = from_nat_into B N"
          by (metis B(2) from_nat_into_surj)
        hence "\<And>n. n \<ge> N \<Longrightarrow> an n \<in> V"
          using an(1) An_def by blast
        thus "\<exists>N. \<forall>n\<ge>N. an n \<in> U"
          using V by blast
      qed fact
      hence 1:"\<forall>\<^sub>F n in sequentially. P (an n)"
        using an(2) h an(1) openin_subset[OF openAn] by blast
      thus False
        using an(3) by simp
    qed
    thus ?thesis
      by(simp add: eventually_atin)
  qed(auto simp: eventually_atin)
qed

lemma continuous_map_iff_limit_seq:
  assumes "first_countable X"
  shows "continuous_map X Y f \<longleftrightarrow> (\<forall>xn x. limitin X xn x sequentially \<longrightarrow> limitin Y (\<lambda>n. f (xn n)) (f x) sequentially)"
  unfolding continuous_map_atin
proof safe
  fix xn x
  assume h:"\<forall>x\<in>topspace X. limitin Y f (f x) (atin X x)" "limitin X xn x sequentially"
  then have limfx: "limitin Y f (f x) (atin X x)"
    by(simp add: limitin_topspace)
  show "limitin Y (\<lambda>n. f (xn n)) (f x) sequentially"
    unfolding limitin_sequentially
  proof safe
    fix U
    assume U:"openin Y U" "f x \<in> U"
    then have h':"\<And>\<sigma>. range \<sigma> \<subseteq> topspace X - {x} \<Longrightarrow> x \<in> topspace X \<Longrightarrow> limitin X \<sigma> x sequentially \<Longrightarrow> (\<exists>N. \<forall>n\<ge>N. f (\<sigma> n) \<in> U)"
      using limfx by(auto simp: limitin_def eventually_atin_sequentially[OF assms(1)] eventually_sequentially)
    show "\<exists>N. \<forall>n\<ge>N. f (xn n) \<in> U"
    proof(cases "finite {n. xn n \<noteq> x}")
      assume "finite {n. xn n \<noteq> x}"
      then obtain N where "\<And>n. n \<ge> N \<Longrightarrow> xn n = x"
        using infinite_nat_iff_unbounded_le by blast
      then show ?thesis
        using U by auto
    next
      assume inf:"infinite {n. xn n \<noteq> x}"
      obtain n0 where n0:"\<And>n. n \<ge> n0 \<Longrightarrow> xn n \<in> topspace X"
        by (meson h(2) limitin_sequentially openin_topspace)
      have inf':"infinite ({n. xn n \<noteq> x} \<inter> {n0..})"
      proof
        have 1:"({n. xn n \<noteq> x} \<inter> {n0..}) \<union> ({n. xn n \<noteq> x} \<inter> {..<n0}) = {n. xn n \<noteq> x}"
          by auto
        assume "finite ({n. xn n \<noteq> x} \<inter> {n0..})"
        then have "finite (({n. xn n \<noteq> x} \<inter> {n0..}) \<union> ({n. xn n \<noteq> x} \<inter> {..<n0}))"
          by auto
        with inf show False
          unfolding 1 by blast
      qed
      define a where "a \<equiv> enumerate ({n. xn n \<noteq> x} \<inter> {n0..})"
      have a: "strict_mono a" "range a = ({n. xn n \<noteq> x} \<inter> {n0..})"
        using range_enumerate[OF inf'] strict_mono_enumerate[OF inf']
        by(auto simp: a_def)
      have "\<exists>N. \<forall>n\<ge>N. f (xn (a n)) \<in> U"
        using limitin_subsequence[OF a(1) h(2)] a(2) n0
        by(auto intro!: h' limitin_topspace[OF h(2)] simp: comp_def)
      then obtain N where N:"\<And>n. n \<ge> N \<Longrightarrow> f (xn (a n)) \<in> U"
        by blast
      show "\<exists>N. \<forall>n\<ge>N. f (xn n) \<in> U"
      proof(auto intro!: exI[where x="a N"])
        fix n
        assume n:"n \<ge> a N"
        show "f (xn n) \<in> U"
        proof (cases "xn n = x")
          assume "xn n \<noteq> x"
          moreover have "n0 \<le> n"
            using seq_suble[OF a(1),of N] n a(2)
            by (metis Int_Collect atLeast_def dual_order.trans rangeI)
          ultimately obtain n1 where n1:"n = a n1"
            by (metis (mono_tags, lifting) Int_Collect atLeast_def imageE mem_Collect_eq a(2))
          have "n1 \<ge> N"
            using strict_mono_less_eq[OF a(1),of N n1] n by(simp add: n1)
          thus ?thesis
            by(auto intro!: N simp: n1)
        qed(auto simp: U)
      qed
    qed
  qed(auto intro!: limitin_topspace limfx)
next
  fix x
  assume h:"\<forall>xn x. limitin X xn x sequentially \<longrightarrow> limitin Y (\<lambda>n. f (xn n)) (f x) sequentially" "x \<in> topspace X"
  then have "f x \<in> topspace Y"
    by (meson Abstract_Limits.limitin_const_iff limitin_topspace)
  thus "limitin Y f (f x) (atin X x)"
    using h by(auto simp: eventually_atin_sequentially[OF assms(1)] limitin_def )
qed

subsubsection \<open> Upper-Semicontinuous Functions \<close>
definition upper_semicontinuous_map :: "['a topology, 'a \<Rightarrow> 'b :: linorder_topology] \<Rightarrow> bool" where
"upper_semicontinuous_map X f \<longleftrightarrow> (\<forall>a. openin X {x\<in>topspace X. f x < a})"

lemma continuous_upper_semicontinuous:
  assumes "continuous_map X (euclidean :: ('b :: linorder_topology) topology) f"
  shows "upper_semicontinuous_map X f"
  unfolding upper_semicontinuous_map_def
proof safe
  fix a :: 'b
  have *:"openin euclidean U \<Longrightarrow> openin X {x \<in> topspace X. f x \<in> U}" for U
    using assms by(simp add: continuous_map)
  have "openin euclidean {..<a}" by auto
  with *[of "{..<a}"] show "openin X {x \<in> topspace X. f x < a}" by auto
qed

lemma upper_semicontinuous_map_iff_closed:
 "upper_semicontinuous_map X f \<longleftrightarrow> (\<forall>a. closedin X {x\<in>topspace X. f x \<ge> a})"
proof -
  have "{x \<in> topspace X. f x < a} = topspace X - {x \<in> topspace X. f x \<ge> a}" for a
    by auto
  thus ?thesis
    by (simp add: closedin_def upper_semicontinuous_map_def)
qed

lemma upper_semicontinuous_map_real_iff:
  fixes f :: "'a \<Rightarrow> real"
  shows "upper_semicontinuous_map X f \<longleftrightarrow> upper_semicontinuous_map X (\<lambda>x. ereal (f x))"
  unfolding upper_semicontinuous_map_def
proof safe
  fix a :: ereal
  assume h:"\<forall>a::real. openin X {x \<in> topspace X. f x < a}"
  consider "a = - \<infinity>" | "a = \<infinity>" | "a \<noteq> - \<infinity> \<and> a \<noteq> \<infinity>" by auto
  then show "openin X {x \<in> topspace X. ereal (f x) < a}"
  proof cases
    case 3
    then have "ereal (f x) < a \<longleftrightarrow> f x < real_of_ereal a" for x
      by (metis ereal_less_eq(3) linorder_not_less real_of_ereal.elims)
    thus ?thesis
      using h by simp
  qed simp_all
next
  fix a :: real
  assume h:"\<forall>a::ereal. openin X {x \<in> topspace X. ereal (f x) < a}"
  then have "openin X {x \<in> topspace X. ereal (f x) < ereal a}"
    by blast
  moreover have"ereal (f x) < real_of_ereal a \<longleftrightarrow> f x < a" for x
    by auto
  ultimately show "openin X {x \<in> topspace X. f x < a}" by auto
qed

subsubsection \<open> Lower-Semicontinuous Functions \<close>
definition lower_semicontinuous_map :: "['a topology, 'a \<Rightarrow> 'b :: linorder_topology] \<Rightarrow> bool" where
"lower_semicontinuous_map X f \<longleftrightarrow> (\<forall>a. openin X {x\<in>topspace X. a < f x})"

lemma continuous_lower_semicontinuous:
  assumes "continuous_map X (euclidean :: ('b :: linorder_topology) topology) f"
  shows "lower_semicontinuous_map X f"
  unfolding lower_semicontinuous_map_def
proof safe
  fix a :: 'b
  have *:"openin euclidean U \<Longrightarrow> openin X {x \<in> topspace X. f x \<in> U}" for U
    using assms by(simp add: continuous_map)
  have "openin euclidean {a<..}" by auto
  with *[of "{a<..}"] show "openin X {x \<in> topspace X. a < f x}" by auto
qed

lemma lower_semicontinuous_map_iff_closed:
 "lower_semicontinuous_map X f \<longleftrightarrow> (\<forall>a. closedin X {x\<in>topspace X. f x \<le> a})"
proof -
  have "{x \<in> topspace X. a < f x} = topspace X - {x \<in> topspace X. f x \<le> a}" for a
    by auto
  thus ?thesis
    by (simp add: closedin_def lower_semicontinuous_map_def)
qed

lemma lower_semicontinuous_map_real_iff:
  fixes f :: "'a \<Rightarrow> real"
  shows "lower_semicontinuous_map X f \<longleftrightarrow> lower_semicontinuous_map X (\<lambda>x. ereal (f x))"
  unfolding lower_semicontinuous_map_def
proof safe
  fix a :: ereal
  assume h:"\<forall>a::real. openin X {x \<in> topspace X. a < f x}"
  consider "a = - \<infinity>" | "a = \<infinity>" | "a \<noteq> - \<infinity> \<and> a \<noteq> \<infinity>" by auto
  then show "openin X {x \<in> topspace X. a < ereal (f x)}"
  proof cases
    case 3
    then have "a < ereal (f x) \<longleftrightarrow> real_of_ereal a < f x" for x
      by (metis ereal_less_eq(3) linorder_not_less real_of_ereal.elims)
    thus ?thesis
      using h by simp
  qed simp_all
next
  fix a :: real
  assume h:"\<forall>a::ereal. openin X {x \<in> topspace X. a < ereal (f x)}"
  then have "openin X {x \<in> topspace X. ereal (f x) > ereal a}"
    by blast
  moreover have"ereal (f x) > real_of_ereal a \<longleftrightarrow> a < f x" for x
    by auto
  ultimately show "openin X {x \<in> topspace X. f x > a}" by auto
qed

subsection \<open>Lemmas for Measure Theory\<close>
subsubsection \<open> Lemmas for Measurable Sets\<close>
lemma measurable_preserve_sigma_sets:
  assumes "sets M = sigma_sets \<Omega> S" "S \<subseteq> Pow \<Omega>"
          "\<And>a. a \<in> S \<Longrightarrow> f ` a \<in> sets N" "inj_on f (space M)" "f ` space M \<in> sets N"
      and "b \<in> sets M" 
    shows "f ` b \<in> sets N"
proof -
  have "b \<in> sigma_sets \<Omega> S"
    using assms(1,6) by simp
  thus ?thesis
  proof induction
    case (Basic a)
    then show ?case by(rule assms(3))
  next
    case Empty
    then show ?case by simp
  next
    case (Compl a)
    moreover have " \<Omega> = space M"
      by (metis assms(1) assms(2) sets.sets_into_space sets.top sigma_sets_into_sp sigma_sets_top subset_antisym)
    ultimately show ?case
      by (metis Diff_subset assms(2) assms(4) assms(5) inj_on_image_set_diff sets.Diff sigma_sets_into_sp)
  next
    case (Union a)
    then show ?case
      by (simp add: image_UN)
  qed
qed

inductive_set sigma_sets_cinter :: "'a set \<Rightarrow> 'a set set \<Rightarrow> 'a set set"
  for sp :: "'a set" and A :: "'a set set"
  where
    Basic_c[intro, simp]: "a \<in> A \<Longrightarrow> a \<in> sigma_sets_cinter sp A"
  | Top_c[simp]: "sp \<in> sigma_sets_cinter sp A"
  | Inter_c: "(\<And>i::nat. a i \<in> sigma_sets_cinter sp A) \<Longrightarrow> (\<Inter>i. a i) \<in> sigma_sets_cinter sp A"
  | Union_c: "(\<And>i::nat. a i \<in> sigma_sets_cinter sp A) \<Longrightarrow> (\<Union>i. a i) \<in> sigma_sets_cinter sp A"

inductive_set sigma_sets_cinter_dunion :: "'a set \<Rightarrow> 'a set set \<Rightarrow> 'a set set"
  for sp :: "'a set" and A :: "'a set set"
  where
    Basic_cd[intro, simp]: "a \<in> A \<Longrightarrow> a \<in> sigma_sets_cinter_dunion sp A"
  | Top_cd[simp]: "sp \<in> sigma_sets_cinter_dunion sp A"
  | Inter_cd: "(\<And>i::nat. a i \<in> sigma_sets_cinter_dunion sp A) \<Longrightarrow> (\<Inter>i. a i) \<in> sigma_sets_cinter_dunion sp A"
  | Union_cd: "(\<And>i::nat. a i \<in> sigma_sets_cinter_dunion sp A) \<Longrightarrow> disjoint_family a \<Longrightarrow> (\<Union>i. a i) \<in> sigma_sets_cinter_dunion sp A"

lemma sigma_sets_cinter_dunion_subset: "sigma_sets_cinter_dunion sp A \<subseteq> sigma_sets_cinter sp A"
proof safe
  fix x
  assume "x \<in> sigma_sets_cinter_dunion sp A"
  then show "x \<in> sigma_sets_cinter sp A"
    by induction (auto intro!: Union_c Inter_c)
qed

lemma sigma_sets_cinter_into_sp:
  assumes "A \<subseteq> Pow sp" "x \<in> sigma_sets_cinter sp A"
  shows "x \<subseteq> sp"
  using assms(2) by induction (use assms(1) subsetD in blast)+

lemma sigma_sets_cinter_dunion_into_sp:
  assumes "A \<subseteq> Pow sp" "x \<in> sigma_sets_cinter_dunion sp A"
  shows "x \<subseteq> sp"
  using assms(2) by induction (use assms(1) subsetD in blast)+

lemma sigma_sets_cinter_int:
  assumes "a \<in> sigma_sets_cinter sp A" "b \<in> sigma_sets_cinter sp A"
  shows "a \<inter> b \<in> sigma_sets_cinter sp A"
proof -
  have 1:"a \<inter> b = (\<Inter>i::nat. if i = 0 then a else b)" by auto
  show ?thesis
    unfolding 1 by(rule Inter_c,use assms in auto)
qed

lemma sigma_sets_cinter_dunion_int:
  assumes "a \<in> sigma_sets_cinter_dunion sp A" "b \<in> sigma_sets_cinter_dunion sp A"
  shows "a \<inter> b \<in> sigma_sets_cinter_dunion sp A"
proof -
  have 1:"a \<inter> b = (\<Inter>i::nat. if i = 0 then a else b)" by auto
  show ?thesis
    unfolding 1 by(rule Inter_cd,use assms in auto)
qed

lemma sigma_sets_cinter_un:
  assumes "a \<in> sigma_sets_cinter sp A" "b \<in> sigma_sets_cinter sp A"
  shows "a \<union> b \<in> sigma_sets_cinter sp A"
proof -
  have 1:"a \<union> b = (\<Union>i::nat. if i = 0 then a else b)" by auto
  show ?thesis
    unfolding 1 by(rule Union_c,use assms in auto)
qed

lemma sigma_sets_eq_cinter_dunion:
  assumes "metrizable_space X"
  shows "sigma_sets (topspace X) {U. openin X U} = sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
proof safe
  fix a
  interpret sa: sigma_algebra "topspace X" "sigma_sets (topspace X) {U. openin X U}"
    by(auto intro!: sigma_algebra_sigma_sets openin_subset)
  assume "a \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
  then show "a \<in> sigma_sets (topspace X) {U. openin X U}"
    by induction auto
next
  have c:"sigma_sets_cinter_dunion (topspace X) {U. openin X U} \<subseteq> {U\<in>sigma_sets_cinter_dunion (topspace X) {U. openin X U}. topspace X - U \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}}"
  proof
    fix a
    assume a: "a \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
    then show "a \<in> {U \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}. topspace X - U \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}}"
    proof induction
      case a:(Basic_cd a)
      then have "gdelta_in X (topspace X - a)"
        by(auto intro!: closed_imp_gdelta_in assms)
      from gdelta_inD'[OF this] obtain U where U:
       "\<And>n :: nat. openin X (U n)" "topspace X - a = \<Inter> (range U)" by auto
      show ?case
        using a U(1) by(auto simp: U(2) intro!: Inter_cd)
    next
      case Top_cd
      then show ?case by auto
    next
      case ca:(Inter_cd a)
      define b where "b \<equiv> (\<lambda>n. (topspace X - a n) \<inter> (\<Inter>i. if i < n then a i else topspace X))"
      have bd:"disjoint_family b"
        using nat_neq_iff by(fastforce simp: disjoint_family_on_def b_def)
      have bin:"b i \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}" for i
        unfolding b_def
        apply(rule sigma_sets_cinter_dunion_int)
        using ca(2)[of i]
         apply auto[1]
        apply(rule Inter_cd) using ca by auto
      have bun:"topspace X - (\<Inter> (range a)) = (\<Union>i. b i)" (is "?lhs = ?rhs")
      proof -
        { fix x
          have "x \<in> ?lhs \<longleftrightarrow> x \<in> topspace X \<and> x \<in> (\<Union>i. topspace X - a i)"
            by auto
          also have "... \<longleftrightarrow> x \<in> topspace X \<and> (\<exists>n. x \<in> topspace X - a n)"
            by auto
          also have "... \<longleftrightarrow> x \<in> topspace X \<and> (\<exists>n. x \<in> topspace X - a n \<and> (\<forall>i<n. x \<in> a i))"
          proof safe
            fix n
            assume 1:"x \<notin> a n" "x \<in> topspace X"
            define N where "N \<equiv> Min {m. m \<le> n \<and> x \<notin> a m}"
            have N:"x \<notin> a N" "N \<le> n"
              using linorder_class.Min_in[of "{m. m \<le> n \<and> x \<notin> a m}"] 1
              by(auto simp: N_def)
            have N':"x \<in> a i" if "i < N" for i
            proof(rule ccontr)
              assume "x \<notin> a i"
              then have "N \<le> i"
                using linorder_class.Min_le[of "{m. m \<le> n \<and> x \<notin> a m}" i] that N(2)
                by(auto simp: N_def)
              with that show False by auto
            qed
            show "\<exists>n. x \<in> topspace X - a n \<and> (\<forall>i<n. x \<in> a i)"
              using N N' by(auto intro!: exI[where x=N] 1)
          qed auto
          also have "... \<longleftrightarrow> x \<in> ?rhs"
            by(auto simp: b_def)
          finally have "x \<in> ?lhs \<longleftrightarrow> x \<in> ?rhs" . }
        thus ?thesis by auto
      qed
      have "... \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
        by(rule Union_cd) (use bin bd in auto)
      thus ?case
        using Inter_cd[of a,OF ca(1)] by(auto simp: bun)
    next
      case ca:(Union_cd a)
      have "topspace X - (\<Union> (range a)) = (\<Inter>i. (topspace X - a i))"
        by simp
      have "... \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
        by(rule Inter_cd) (use ca in auto)
      then show ?case
        using Union_cd[of a,OF ca(1,2)] by auto 
    qed
  qed
  fix a
  assume "a \<in> sigma_sets (topspace X) {U. openin X U}"
  then show "a \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
  proof induction
    case a:(Union a)
    define b where "b \<equiv> (\<lambda>n. a n \<inter>  (\<Inter>i. if i < n then topspace X - a i else topspace X))"
    have bd:"disjoint_family b"
      by(auto simp: disjoint_family_on_def b_def) (metis Diff_iff UnCI image_eqI linorder_neqE_nat mem_Collect_eq)
    have bin:"b i \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}" for i
      unfolding b_def
      apply(rule sigma_sets_cinter_dunion_int)
      using a(2)[of i]
       apply auto[1]
      apply(rule Inter_cd) using c a by auto
    have bun:"(\<Union>i. a i) = (\<Union>i. b i)" (is "?lhs = ?rhs")
    proof -
      {
        fix x
        have "x \<in> ?lhs \<longleftrightarrow> x \<in> topspace X \<and> x \<in> ?lhs"
          using sigma_sets_cinter_dunion_into_sp[OF _ a(2)]
          by (metis UN_iff subsetD subset_Pow_Union topspace_def)
        also have "... \<longleftrightarrow> x \<in> topspace X \<and> (\<exists>n. x \<in> a n)" by auto
        also have "... \<longleftrightarrow> x \<in> topspace X \<and> (\<exists>n. x \<in> a n \<and> (\<forall>i<n. x \<in> topspace X - a i))"
        proof safe
          fix n
          assume 1:"x \<in> topspace X" "x \<in> a n"
          define N where "N \<equiv> Min {m. m \<le> n \<and> x \<in> a m}"
          have N:"x \<in> a N" "N \<le> n"
            using linorder_class.Min_in[of "{m. m \<le> n \<and> x \<in> a m}"] 1
            by(auto simp: N_def)
          have N':"x \<notin> a i" if "i < N" for i
          proof(rule ccontr)
            assume "\<not> x \<notin> a i"
            then have "N \<le> i"
              using linorder_class.Min_le[of "{m. m \<le> n \<and> x \<in> a m}" i] that N(2)
              by(auto simp: N_def)
            with that show False by auto
          qed
          show "\<exists>n. x \<in> a n \<and> (\<forall>i<n. x \<in> topspace X - a i)"
            using N N' 1 by(auto intro!: exI[where x=N])
        qed auto
        also have "... \<longleftrightarrow> x \<in> ?rhs"
        proof safe
          fix m
          assume "x \<in> b m"
          then show "x \<in> topspace X" "\<exists>n. x \<in> a n \<and> (\<forall>i<n. x \<in> topspace X - a i)"
            by(auto intro!: exI[where x=m] simp: b_def)
        qed(auto simp: b_def)
        finally have "x \<in> ?lhs \<longleftrightarrow> x \<in> ?rhs" . }
      thus ?thesis by auto
    qed
    have "... \<in> sigma_sets_cinter_dunion (topspace X) {U. openin X U}"
      by(rule Union_cd) (use bin bd in auto)
    thus ?case
      by(auto simp: bun)
  qed(use c in auto)
qed

lemma sigma_sets_eq_cinter:
  assumes "metrizable_space X"
  shows "sigma_sets (topspace X) {U. openin X U} = sigma_sets_cinter (topspace X) {U. openin X U}"
proof safe
  fix a
  interpret sa: sigma_algebra "topspace X" "sigma_sets (topspace X) {U. openin X U}"
    by(auto intro!: sigma_algebra_sigma_sets openin_subset)
  assume "a \<in> sigma_sets_cinter (topspace X) {U. openin X U}"
  then show "a \<in> sigma_sets (topspace X) {U. openin X U}"
    by induction auto
qed (use sigma_sets_cinter_dunion_subset sigma_sets_eq_cinter_dunion[OF assms] in auto)

subsubsection \<open> Measurable Isomorphisms \<close>
definition measurable_isomorphic_map::"['a measure, 'b measure, 'a \<Rightarrow> 'b] \<Rightarrow> bool" where
"measurable_isomorphic_map M N f \<longleftrightarrow> bij_betw f (space M) (space N) \<and> f \<in> M \<rightarrow>\<^sub>M N \<and> the_inv_into (space M) f \<in> N \<rightarrow>\<^sub>M M"

lemma measurable_isomorphic_map_sets_cong:
  assumes "sets M = sets M'" "sets N = sets N'"
  shows "measurable_isomorphic_map M N f \<longleftrightarrow> measurable_isomorphic_map M' N' f"
  by(simp add: measurable_isomorphic_map_def sets_eq_imp_space_eq[OF assms(1)] sets_eq_imp_space_eq[OF assms(2)] measurable_cong_sets[OF assms] measurable_cong_sets[OF assms(2,1)])

lemma measurable_isomorphic_map_surj:
  assumes "measurable_isomorphic_map M N f"
  shows "f ` space M = space N"
  using assms by(auto simp: measurable_isomorphic_map_def bij_betw_def)

lemma measurable_isomorphic_mapI:
  assumes "bij_betw f (space M) (space N)" "f \<in> M \<rightarrow>\<^sub>M N" "the_inv_into (space M) f \<in> N \<rightarrow>\<^sub>M M"
  shows "measurable_isomorphic_map M N f"
  using assms by(simp add: measurable_isomorphic_map_def)

lemma measurable_isomorphic_map_byWitness:
  assumes "f \<in> M \<rightarrow>\<^sub>M N" "g \<in> N \<rightarrow>\<^sub>M M" "\<And>x. x \<in> space M \<Longrightarrow> g (f x) = x" "\<And>x. x \<in> space N \<Longrightarrow> f (g x) = x"
  shows "measurable_isomorphic_map M N f"
proof -
  have *:"bij_betw f (space M) (space N)"
    using assms by(auto intro!: bij_betw_byWitness[where f'=g] dest:measurable_space)
  show ?thesis
  proof(rule measurable_isomorphic_mapI)
    have "the_inv_into (space M) f x = g x" if "x \<in> space N" for x
      by (metis * assms(2) assms(4) bij_betw_imp_inj_on measurable_space that the_inv_into_f_f)
    thus "the_inv_into (space M) f \<in> N \<rightarrow>\<^sub>M M"
      using measurable_cong assms(2) by blast
  qed (simp_all add: * assms(1))
qed

lemma measurable_isomorphic_map_restrict_space:
  assumes "f \<in> M \<rightarrow>\<^sub>M N" "\<And>A. A \<in> sets M \<Longrightarrow> f ` A \<in> sets N" "inj_on f (space M)"
  shows "measurable_isomorphic_map M (restrict_space N (f ` space M)) f"
proof(rule measurable_isomorphic_mapI)
  show "bij_betw f (space M) (space (restrict_space N (f ` space M)))"
    by (simp add: assms(2,3) inj_on_imp_bij_betw)
next
  show "f \<in> M \<rightarrow>\<^sub>M restrict_space N (f ` space M)"
    by (simp add: assms(1) measurable_restrict_space2)
next
  show "the_inv_into (space M) f \<in> restrict_space N (f ` space M) \<rightarrow>\<^sub>M M"
  proof(rule measurableI)
    show "x \<in> space (restrict_space N (f ` space M)) \<Longrightarrow> the_inv_into (space M) f x \<in> space M" for x
      by (simp add: assms(2,3) the_inv_into_into)
  next
    fix A
    assume "A \<in> sets M"
    have "the_inv_into (space M) f -` A \<inter> space (restrict_space N (f ` space M)) = f ` A"
      by (simp add: \<open>A \<in> sets M\<close> assms(2,3) sets.sets_into_space the_inv_into_vimage)
    also note assms(2)[OF \<open>A \<in> sets M\<close>]
    finally show "the_inv_into (space M) f -` A \<inter> space (restrict_space N (f ` space M)) \<in> sets (restrict_space N (f ` space M))"
      by (simp add: assms(2) sets_restrict_space_iff)
  qed
qed

lemma measurable_isomorphic_mapD':
  assumes "measurable_isomorphic_map M N f"
  shows "\<And>A. A \<in> sets M \<Longrightarrow> f ` A \<in> sets N" "f \<in> M \<rightarrow>\<^sub>M N"
        "\<exists>g. bij_betw g (space N) (space M) \<and> g \<in> N \<rightarrow>\<^sub>M M \<and> (\<forall>x \<in> space M. g (f x) = x) \<and> (\<forall>x\<in> space N. f (g x) = x) \<and> (\<forall>A\<in>sets N. g ` A \<in> sets M)"
proof -
  have h:"bij_betw f (space M) (space N)" "f \<in> M \<rightarrow>\<^sub>M N" "the_inv_into (space M) f \<in> N \<rightarrow>\<^sub>M M"
    using assms by(simp_all add: measurable_isomorphic_map_def)
  show "f ` A \<in> sets N" if "A \<in> sets M" for A
  proof -
    have "f ` A = the_inv_into (space M) f -` A \<inter> space N"
      using the_inv_into_vimage[OF bij_betw_imp_inj_on[OF h(1)] sets.sets_into_space[OF that]]
      by(simp add: bij_betw_imp_surj_on[OF h(1)])
    also have "... \<in> sets N"
      using that h(3) by auto
    finally show ?thesis .
  qed
  show "f \<in> M \<rightarrow>\<^sub>M N"
    using assms by(simp add: measurable_isomorphic_map_def)

  show "\<exists>g. bij_betw g (space N) (space M) \<and> g \<in> N \<rightarrow>\<^sub>M M \<and> (\<forall>x \<in> space M. g (f x) = x) \<and> (\<forall>x\<in> space N. f (g x) = x) \<and> (\<forall>A\<in>sets N. g ` A \<in> sets M)"
  proof(rule exI[where x="the_inv_into (space M) f"])
    have *:"the_inv_into (space M) f ` A \<in> sets M" if "A \<in> sets N" for A
    proof -
      have "\<And>x. x \<in> space M \<Longrightarrow> the_inv_into (space N) (the_inv_into (space M) f) x = f x"
        by (metis bij_betw_imp_inj_on bij_betw_the_inv_into h(1) h(2) measurable_space the_inv_into_f_f)
      from vimage_inter_cong[of "space M" _ f A,OF this] the_inv_into_vimage[OF bij_betw_imp_inj_on[OF bij_betw_the_inv_into[OF h(1)]] sets.sets_into_space[OF that]]
           bij_betw_imp_surj_on[OF bij_betw_the_inv_into[OF h(1)]] measurable_sets[OF h(2) that]
      show ?thesis
        by fastforce
    qed
    show "bij_betw (the_inv_into (space M) f) (space N) (space M) \<and> the_inv_into (space M) f \<in> N \<rightarrow>\<^sub>M M \<and> (\<forall>x\<in>space M. the_inv_into (space M) f (f x) = x) \<and> (\<forall>x\<in>space N. f (the_inv_into (space M) f x) = x) \<and> (\<forall>A\<in>sets N. the_inv_into (space M) f ` A \<in> sets M)"
      using bij_betw_the_inv_into[OF h(1)]
      by (meson * bij_betw_imp_inj_on f_the_inv_into_f_bij_betw h(1) h(3) the_inv_into_f_f)
  qed
qed

lemma measurable_isomorphic_map_inv:
  assumes "measurable_isomorphic_map M N f"
  shows "measurable_isomorphic_map N M (the_inv_into (space M) f)"
  using assms[simplified measurable_isomorphic_map_def]
  by(auto intro!: measurable_isomorphic_map_byWitness[where g=f] bij_betw_the_inv_into f_the_inv_into_f_bij_betw[of f] bij_betw_imp_inj_on the_inv_into_f_f)

lemma measurable_isomorphic_map_comp:
  assumes "measurable_isomorphic_map M N f" and "measurable_isomorphic_map N L g"
  shows "measurable_isomorphic_map M L (g \<circ> f)"
proof -
  obtain f' g' where
  [measurable]: "f' \<in> N \<rightarrow>\<^sub>M M"     and hf:"\<And>x. x\<in>space M \<Longrightarrow> f' (f x) = x" "\<And>x. x\<in>space N \<Longrightarrow> f (f' x) = x"
  and [measurable]: "g' \<in> L \<rightarrow>\<^sub>M N" and hg:"\<And>x. x\<in>space N \<Longrightarrow> g' (g x) = x" "\<And>x. x\<in>space L \<Longrightarrow> g (g' x) = x"
    using measurable_isomorphic_mapD'[OF assms(1)] measurable_isomorphic_mapD'[OF assms(2)] by metis
  have [measurable]: "f \<in> M \<rightarrow>\<^sub>M N" "g \<in> N \<rightarrow>\<^sub>M L"
    using assms by(auto simp: measurable_isomorphic_map_def)
  from hf hg measurable_space[OF \<open>f \<in> M \<rightarrow>\<^sub>M N\<close>] measurable_space[OF \<open>g' \<in> L \<rightarrow>\<^sub>M N\<close>] show ?thesis
    by(auto intro!: measurable_isomorphic_map_byWitness[where g="f'\<circ>g'"])
qed

definition measurable_isomorphic::"['a measure, 'b measure] \<Rightarrow> bool" (infixr \<open>measurable'_isomorphic\<close> 50) where
"M measurable_isomorphic N \<longleftrightarrow> (\<exists>f. measurable_isomorphic_map M N f)"

lemma measurable_isomorphic_sets_cong:
  assumes "sets M = sets M'" "sets N = sets N'"
  shows "M measurable_isomorphic N  \<longleftrightarrow> M' measurable_isomorphic N'"
  using measurable_isomorphic_map_sets_cong[OF assms]
  by(auto simp: measurable_isomorphic_def)

lemma measurable_isomorphicD:
  assumes "M measurable_isomorphic N"
  shows "\<exists>f g. f \<in> M \<rightarrow>\<^sub>M N \<and> g \<in> N \<rightarrow>\<^sub>M M \<and> (\<forall>x\<in>space M. g (f x) = x) \<and> (\<forall>y\<in>space N. f (g y) = y) \<and> (\<forall>A\<in>sets M. f ` A \<in> sets N) \<and> (\<forall>A\<in>sets N. g ` A \<in> sets M)"
  using assms measurable_isomorphic_mapD'[of M N]
  by (metis (mono_tags, lifting) measurable_isomorphic_def)

lemma measurable_isomorphic_cardinality_eq:
  assumes "M measurable_isomorphic N"
  shows "space M \<approx> space N"
  by (meson assms eqpoll_def measurable_isomorphic_def measurable_isomorphic_map_def)

lemma measurable_isomorphic_count_spaces: "count_space A measurable_isomorphic count_space B \<longleftrightarrow> A \<approx> B"
proof
  assume "A \<approx> B"
  then obtain f where f:"bij_betw f A B"
    by(auto simp: eqpoll_def)
  then show "count_space A measurable_isomorphic count_space B"
    by(auto simp: measurable_isomorphic_def measurable_isomorphic_map_def bij_betw_def the_inv_into_into intro!: exI[where x=f])
qed(use measurable_isomorphic_cardinality_eq in fastforce)

lemma measurable_isomorphic_byWitness:
  assumes "f \<in> M \<rightarrow>\<^sub>M N" "\<And>x. x\<in>space M \<Longrightarrow> g (f x) = x"
      and "g \<in> N \<rightarrow>\<^sub>M M" "\<And>y. y\<in>space N \<Longrightarrow> f (g y) = y"
    shows "M measurable_isomorphic N"
  by(auto simp: measurable_isomorphic_def assms intro!: exI[where x = f] measurable_isomorphic_map_byWitness[where g=g])

lemma measurable_isomorphic_refl:
  "M measurable_isomorphic M"
  by(auto intro!: measurable_isomorphic_byWitness[where f=id and g=id])

lemma measurable_isomorphic_sym:
  assumes "M measurable_isomorphic N"
  shows "N measurable_isomorphic M"
  using assms measurable_isomorphic_map_inv[of M N]
  by(auto simp: measurable_isomorphic_def)

lemma measurable_isomorphic_trans:
  assumes "M measurable_isomorphic N" and "N measurable_isomorphic L"
  shows "M measurable_isomorphic L"
  using assms measurable_isomorphic_map_comp[of M N _ L]
  by(auto simp: measurable_isomorphic_def)

lemma measurable_isomorphic_empty:
  assumes "space M = {}" "space N = {}"
  shows "M measurable_isomorphic N"
  using assms by(auto intro!: measurable_isomorphic_byWitness[where f=undefined and g=undefined] simp: measurable_empty_iff)

lemma measurable_isomorphic_empty1:
  assumes "space M = {}" "M measurable_isomorphic N"
  shows "space N = {}"
  using measurable_isomorphicD[OF assms(2)] by(auto simp: measurable_empty_iff[OF assms(1)])

lemma measurable_ismorphic_empty2:
  assumes "space N = {}" "M measurable_isomorphic N"
  shows "space M = {}"
  using measurable_isomorphic_sym[OF assms(2)] assms(1)
  by(simp add: measurable_isomorphic_empty1)

lemma measurable_lift_product:
  assumes "\<And>i. i \<in> I \<Longrightarrow> f i \<in> (M i) \<rightarrow>\<^sub>M (N i)"
  shows "(\<lambda>x i. if i \<in> I then f i (x i) else undefined) \<in> (\<Pi>\<^sub>M i\<in>I. M i) \<rightarrow>\<^sub>M (\<Pi>\<^sub>M i\<in>I. N i)"
  using measurable_space[OF assms]
  by(auto intro!: measurable_PiM_single' simp: assms measurable_PiM_component_rev space_PiM PiE_iff)

lemma measurable_isomorphic_map_lift_product:
  assumes "\<And>i. i \<in> I \<Longrightarrow> measurable_isomorphic_map (M i) (N i) (h i)"
  shows "measurable_isomorphic_map (\<Pi>\<^sub>M i\<in>I. M i) (\<Pi>\<^sub>M i\<in>I. N i) (\<lambda>x i. if i \<in> I then h i (x i) else undefined)"
proof -
  obtain h' where
   "\<And>i. i \<in> I \<Longrightarrow> h' i \<in> (N i) \<rightarrow>\<^sub>M (M i)" "\<And>i x. i \<in> I \<Longrightarrow> x\<in>space (M i) \<Longrightarrow> h' i (h i x) = x" "\<And>i x. i \<in> I \<Longrightarrow> x\<in>space (N i) \<Longrightarrow> h i (h' i x) = x"
    using measurable_isomorphic_mapD'(3)[OF assms] by metis
  thus ?thesis
    by(auto intro!: measurable_isomorphic_map_byWitness[OF measurable_lift_product[of I h M N,OF measurable_isomorphic_mapD'(2)[OF assms]] measurable_lift_product[of I h' N M,OF \<open>\<And>i. i \<in> I \<Longrightarrow> h' i \<in> (N i) \<rightarrow>\<^sub>M (M i)\<close>]]
              simp: space_PiM PiE_iff extensional_def)
qed

lemma measurable_isomorphic_lift_product:
  assumes "\<And>i. i \<in> I \<Longrightarrow> (M i) measurable_isomorphic (N i)"
  shows "(\<Pi>\<^sub>M i\<in>I. M i) measurable_isomorphic  (\<Pi>\<^sub>M i\<in>I. N i)"
proof -
  obtain h where "\<And>i. i \<in> I \<Longrightarrow> measurable_isomorphic_map (M i) (N i) (h i)"
    using assms by(auto simp: measurable_isomorphic_def) metis
  thus ?thesis
    by(auto intro!: measurable_isomorphic_map_lift_product exI[where x="\<lambda>x i. if i \<in> I then h i (x i) else undefined"] simp: measurable_isomorphic_def)
qed

text \<open>\<^url>\<open>https://math24.net/cantor-schroder-bernstein-theorem.html\<close>\<close>
lemma Schroeder_Bernstein_measurable':
  assumes "f ` (space M) \<in> sets N" "g ` (space N) \<in> sets M"
      and "measurable_isomorphic_map M (restrict_space N (f ` (space M))) f" and "measurable_isomorphic_map N (restrict_space M (g ` (space N))) g"
    shows "\<exists>h. measurable_isomorphic_map M N h"
proof -
  have hset:"\<And>A. A \<in> sets M \<Longrightarrow> f ` A \<in> sets (restrict_space N (f ` space M))" 
            "\<And>A. A \<in> sets N \<Longrightarrow> g ` A \<in> sets (restrict_space M (g ` space N))" 
  and hfg[measurable]:"f \<in> M \<rightarrow>\<^sub>M restrict_space N (f ` space M)"
                      "g \<in> N \<rightarrow>\<^sub>M restrict_space M (g ` space N)"
    using measurable_isomorphic_mapD'(1,2)[OF assms(3)]  measurable_isomorphic_mapD'(1,2)[OF assms(4)] assms(1,2)
    by auto
  have hset2:"\<And>A. A \<in> sets M \<Longrightarrow> f ` A \<in> sets N" "\<And>A. A \<in> sets N \<Longrightarrow> g ` A \<in> sets M"
   and hfg2[measurable]: "f \<in> M \<rightarrow>\<^sub>M N" "g \<in> N \<rightarrow>\<^sub>M M"
    using sets.Int_space_eq2[OF assms(1)] sets.Int_space_eq2[OF assms(2)] sets_restrict_space_iff[of "f ` space M" N] sets_restrict_space_iff[of "g ` space N" M] hset
          measurable_restrict_space2_iff[of f M N] measurable_restrict_space2_iff[of g N M] hfg assms(1,2)
    by auto
  have bij1:"bij_betw f (space M) (f ` (space M))" "bij_betw g (space N) (g ` (space N))"
    using assms(3,4) by(auto simp: measurable_isomorphic_map_def space_restrict_space sets.Int_space_eq2[OF assms(1)] sets.Int_space_eq2[OF assms(2)])
  obtain f' g' where
  hfg1'[measurable]: "f' \<in> restrict_space N (f ` (space M)) \<rightarrow>\<^sub>M M" "g' \<in> restrict_space M (g ` (space N)) \<rightarrow>\<^sub>M N"
    and hfg':"\<And>x. x\<in>space M \<Longrightarrow> f' (f x) = x" "\<And>x. x\<in>f ` space M \<Longrightarrow> f (f' x) = x"
             "\<And>x. x\<in>space N \<Longrightarrow> g' (g x) = x" "\<And>x. x\<in>g ` space N \<Longrightarrow> g (g' x) = x"
             "bij_betw f' (f ` space M) (space M)" "bij_betw g' (g ` space N) (space N)"
    using measurable_isomorphic_mapD'(3)[OF assms(3)] measurable_isomorphic_mapD'(3)[OF assms(4)] sets.Int_space_eq2[OF assms(1)] sets.Int_space_eq2[OF assms(2)]
    by (metis space_restrict_space)

  have hgfA:"(g \<circ> f) ` A \<in> sets M" if "A \<in> sets M" for A
    using hset2(2)[OF hset2(1)[OF that]] by(simp add: image_comp)
  define An where "An \<equiv> (\<lambda>n. ((g \<circ> f)^^n) ` (space M - g ` (space N)))"
  define A where "A \<equiv> (\<Union>n\<in>UNIV. An n)"
  have "An n \<in> sets M" for n
  proof(induction n)
    case 0
    thus ?case
      using hset2[OF sets.top] by(simp add: An_def)
  next
    case ih:(Suc n)
    have "An (Suc n) = (g \<circ> f) ` (An n)"
      by(auto simp add: An_def)
    thus ?case
      using hgfA[OF ih] by simp
  qed
  hence Asets:"A \<in> sets M"
    by(simp add: A_def)
  have Acompl:"space M - A \<subseteq> g ` space N"
  proof -
    have "space M - A \<subseteq> space M - An 0"
      by(auto simp: A_def)
    also have "... \<subseteq> g ` space N"
      by(auto simp: An_def)
    finally show ?thesis .
  qed
  define h where "h \<equiv> (\<lambda>x. if x \<in> A \<union> (- space M) then f x else g' x)"
  define h' where "h' \<equiv> (\<lambda>x. if x \<in> f ` A then f' x else g x)"
  have xinA_iff:"x \<in> A \<longleftrightarrow> h x \<in> f ` A" if "x \<in> space M" for x
  proof
    assume "h x \<in> f ` A"
    show "x \<in> A"
    proof(rule ccontr)
      assume "x \<notin> A"
      then have "\<And>n. x \<notin> An n"
        by(auto simp: A_def)
      from this[of 0] have "x \<in> g ` (space N)"
        using that by(auto simp: An_def)
      have "g' x \<in> f ` A "
        using \<open>h x \<in> f ` A\<close> \<open>x \<notin> A\<close>
        by (simp add: h_def that)
      hence "g (g' x) \<in> (g \<circ> f) ` A"
        by auto
      hence "x \<in> (g \<circ> f) ` A"
        using \<open>x \<in> g ` (space N)\<close> by (simp add: hfg'(4))
      then obtain n where "x \<in> (g \<circ> f) ` (An n)"
        by(auto simp: A_def)
      hence "x \<in> An (Suc n)"
        by(auto simp: An_def)
      thus False
        using \<open>\<And>n. x \<notin> An n\<close> by simp
    qed
  qed(simp add: h_def)

  show ?thesis
  proof(intro exI[where x=h] measurable_isomorphic_map_byWitness[where g=h'])
    have "{x \<in> space M. x \<in> A \<union> (- space M)} \<in> sets M"
      using sets.Int_space_eq2[OF Asets] Asets by simp
    moreover have "f \<in> restrict_space M {x. x \<in> A \<union> - space M} \<rightarrow>\<^sub>M N"
      by (simp add: measurable_restrict_space1)
    moreover have "g' \<in> restrict_space M {x. x \<notin>  A \<union> (- space M)} \<rightarrow>\<^sub>M N"
    proof -
      have "sets (restrict_space (restrict_space M (g ` space N))  {x. x \<notin> A \<union> - space M}) = sets (restrict_space M (g ` space N \<inter>  {x. x \<notin> A \<union> - space M}))"
        by(simp add: sets_restrict_restrict_space)
      also have "... = sets (restrict_space M (g ` space N \<inter> {x. x \<in> space M - A}))"
        by (metis Compl_iff DiffE DiffI Un_iff)
      also have "... = sets (restrict_space M {x. x \<in> space M - A})"
        by (metis Acompl le_inf_iff mem_Collect_eq subsetI subset_antisym)
      also have "... = sets (restrict_space M {x. x \<notin>  A \<union> (- space M)})"
        by (metis Compl_iff DiffE DiffI Un_iff)
      finally have "sets (restrict_space (restrict_space M (g ` space N)) {x. x \<notin> A \<union> - space M}) = sets (restrict_space M {x. x \<notin> A \<union> - space M})" .
      from measurable_cong_sets[OF this refl] measurable_restrict_space1[OF hfg1'(2),of " {x. x \<notin> A \<union> - space M}"]
      show ?thesis by auto
    qed
    ultimately show "h \<in> M \<rightarrow>\<^sub>M N"
      by(simp add: h_def measurable_If_restrict_space_iff)
  next
    have "{x \<in> space N. x \<in> f ` A} \<in> sets N"
      using sets.Int_space_eq2[OF hset2(1)[OF Asets]] hset2(1)[OF Asets] by simp
    moreover have "f' \<in> restrict_space N {x. x \<in> f ` A} \<rightarrow>\<^sub>M M"
    proof -
      have "sets (restrict_space (restrict_space N (f ` space M)) {x. x \<in> f ` A}) = sets (restrict_space N (f ` space M \<inter> {x. x \<in> f ` A}))"
        by(simp add: sets_restrict_restrict_space)
      also have "... = sets (restrict_space N {x. x \<in> f ` A})"
      proof -
        have "f ` space M \<inter> {x. x \<in> f ` A} = {x. x \<in> f ` A}"
          using sets.sets_into_space[OF Asets] by auto
        thus ?thesis by simp
      qed
      finally have "sets (restrict_space (restrict_space N (f ` space M)) {x. x \<in> f ` A}) = sets (restrict_space N {x. x \<in> f ` A})" .
      from measurable_cong_sets[OF this refl] measurable_restrict_space1[OF hfg1'(1),of "{x. x \<in> f ` A}"]
      show ?thesis by auto
    qed
    moreover have "g \<in> restrict_space N {x. x \<notin> f ` A} \<rightarrow>\<^sub>M M"
      by (simp add: measurable_restrict_space1)
    ultimately show "h' \<in> N \<rightarrow>\<^sub>M M"
      by(simp add: h'_def measurable_If_restrict_space_iff)
  next
    fix x
    assume "x \<in> space M"
    then consider "x \<in> A" | "x \<in> space M - A" by auto
    thus "h' (h x) = x"
    proof cases
      case xa:2
      hence "h x \<notin> f ` A"
        using \<open>x \<in> space M\<close> xinA_iff by blast
      thus ?thesis
        using Acompl hfg'(4) xa by(auto simp add: h_def h'_def)
    qed(simp add: h_def h'_def \<open>x \<in> space M\<close> hfg'(1))
  next
    fix x
    assume "x \<in> space N"
    then consider "x \<in> f ` A" | "x \<in> space N -  f ` A" by auto
    thus "h (h' x) = x"
    proof cases
      case hx:1
      hence "x \<in> f ` (space M)"
        using image_mono[OF sets.sets_into_space[OF Asets],of f] by auto
      have "h' x = f' x"
        using hx by(simp add: h'_def)
      also have "... \<in> A"
        using hx sets.sets_into_space[OF Asets] hfg'(1) by auto
      finally show ?thesis
        using hfg'(2)[OF \<open>x \<in> f ` (space M)\<close>] hx by(auto simp: h_def h'_def)
    next
      case hx:2
      then have "h' x = g x"
        by(simp add: h'_def)
      also have "... \<notin> A"
      proof(rule ccontr)
        assume "\<not> g x \<notin> A"
        then have "g x \<in> A" by simp
        then obtain n where hg:"g x \<in> An n" by(auto simp: A_def)
        hence "0 < n" using hx by(auto simp: An_def)
        then obtain n' where [simp]:"n = Suc n'"
          using not0_implies_Suc by blast
        then have "g x \<in> g ` f `  An n'"
          using hg by(auto simp: An_def)
        hence "x \<in> f ` An n'"
          using inj_on_image_mem_iff[OF bij_betw_imp_inj_on[OF bij1(2)] \<open>x \<in> space N\<close>,of "f ` An n'"]
                sets.sets_into_space[OF \<open>An n' \<in> sets M\<close>] measurable_space[OF hfg2(1)] by auto
        also have "... \<subseteq> f ` A"
          by(auto simp: A_def)
        finally show False
          using hx by simp
      qed
      finally show ?thesis
        using hx hfg'(3)[OF \<open>x \<in> space N\<close>] measurable_space[OF hfg2(2) \<open>x \<in> space N\<close>]
        by(auto simp: h_def h'_def)
    qed
  qed
qed

lemma Schroeder_Bernstein_measurable:
  assumes "f \<in> M \<rightarrow>\<^sub>M N" "\<And>A. A \<in> sets M \<Longrightarrow> f ` A \<in> sets N" "inj_on f (space M)"
      and "g \<in> N \<rightarrow>\<^sub>M M" "\<And>A. A \<in> sets N \<Longrightarrow> g ` A \<in> sets M" "inj_on g (space N)"
    shows "\<exists>h. measurable_isomorphic_map M N h"
  using Schroeder_Bernstein_measurable'[OF assms(2)[OF sets.top] assms(5)[OF sets.top] measurable_isomorphic_map_restrict_space[OF assms(1-3)] measurable_isomorphic_map_restrict_space[OF assms(4-6)]]
  by simp

lemma measurable_isomorphic_from_embeddings:
  assumes "M measurable_isomorphic (restrict_space N B)" "N measurable_isomorphic (restrict_space M A)"
      and "A \<in> sets M" "B \<in> sets N"
    shows "M measurable_isomorphic N"
proof -
  obtain f g where fg:"measurable_isomorphic_map M (restrict_space N B) f" "measurable_isomorphic_map N (restrict_space M A) g"
    using assms(1,2) by(auto simp: measurable_isomorphic_def)
  have [simp]:"f ` space M = B" "g ` space N = A"
    using measurable_isomorphic_map_surj[OF fg(1)] measurable_isomorphic_map_surj[OF fg(2)] sets.sets_into_space[OF assms(3)] sets.sets_into_space[OF assms(4)]
    by(auto simp: space_restrict_space)
  obtain h where "measurable_isomorphic_map M N h"
    using Schroeder_Bernstein_measurable'[of f M N g] assms(3,4) fg by auto
  thus ?thesis
    by(auto simp: measurable_isomorphic_def)
qed

lemma measurable_isomorphic_antisym:
  assumes "B measurable_isomorphic (restrict_space C c)" "A measurable_isomorphic (restrict_space B b)"
      and "c \<in> sets C" "b \<in> sets B" "C measurable_isomorphic A" 
    shows "C measurable_isomorphic B"
  by(rule measurable_isomorphic_from_embeddings[OF measurable_isomorphic_trans[OF assms(5,2)] assms(1) assms(3,4)])

lemma countable_infinite_isomorphisc_to_nat_index:
  assumes "countable I" and "infinite I"
  shows "(\<Pi>\<^sub>M x\<in>I. M) measurable_isomorphic (\<Pi>\<^sub>M (x::nat)\<in>UNIV. M)"
proof(rule measurable_isomorphic_byWitness[where f="\<lambda>x n. x (from_nat_into I n)" and g="\<lambda>x. \<lambda>i\<in>I. x (to_nat_on I i)"])
  show "(\<lambda>x n. x (from_nat_into I n)) \<in> (\<Pi>\<^sub>M x\<in>I. M) \<rightarrow>\<^sub>M (\<Pi>\<^sub>M (x::nat)\<in>UNIV. M)"
    by(auto intro!: measurable_PiM_single' measurable_component_singleton[OF from_nat_into[OF infinite_imp_nonempty[OF assms(2)]]])
      (simp add: PiE_iff infinite_imp_nonempty space_PiM from_nat_into[OF infinite_imp_nonempty[OF assms(2)]])
next
  show "(\<lambda>x. \<lambda>i\<in>I. x (to_nat_on I i)) \<in> (\<Pi>\<^sub>M (x::nat)\<in>UNIV. M) \<rightarrow>\<^sub>M (\<Pi>\<^sub>M x\<in>I. M)"
    by(auto intro!: measurable_PiM_single')
next
  show "x \<in> space (\<Pi>\<^sub>M x\<in>I. M) \<Longrightarrow> (\<lambda>i\<in>I. x (from_nat_into I (to_nat_on I i))) = x" for x
    by (simp add: assms(1) restrict_ext space_PiM)
next
  show "y \<in> space (Pi\<^sub>M UNIV (\<lambda>x. M)) \<Longrightarrow> (\<lambda>n. (\<lambda>i\<in>I. y (to_nat_on I i)) (from_nat_into I n)) = y" for y
    by (simp add: assms(1) assms(2) from_nat_into infinite_imp_nonempty)
qed

lemma PiM_PiM_isomorphic_to_PiM:
 "(\<Pi>\<^sub>M i\<in>I. \<Pi>\<^sub>M j\<in>J. M i j) measurable_isomorphic (\<Pi>\<^sub>M (i,j)\<in>I\<times>J. M i j)"
proof(rule measurable_isomorphic_byWitness[where f="\<lambda>x (i,j). if (i,j) \<in> I \<times> J then x i j else undefined" and g="\<lambda>x i j. if i \<notin> I then undefined j else if j \<notin> J then undefined else x (i,j)"])
  have [simp]: "(\<lambda>\<omega>. \<omega> a b) \<in> (\<Pi>\<^sub>M i\<in>I. \<Pi>\<^sub>M j\<in>J. M i j) \<rightarrow>\<^sub>M M a b" if "a \<in> I" "b \<in> J" for a b
    using measurable_component_singleton[OF that(1),of "\<lambda>i.  \<Pi>\<^sub>M j\<in>J. M i j"] measurable_component_singleton[OF that(2),of "M a"]
    by auto
  show "(\<lambda>x (i, j). if (i, j) \<in> I \<times> J then x i j else undefined) \<in> (\<Pi>\<^sub>M i\<in>I. \<Pi>\<^sub>M j\<in>J. M i j) \<rightarrow>\<^sub>M (\<Pi>\<^sub>M (i,j)\<in>I\<times>J. M i j)"
    apply(rule measurable_PiM_single')
     apply auto[1]
    apply(auto simp: PiE_def Pi_def space_PiM extensional_def;meson)
    done
next
  have [simp]: "(\<lambda>\<omega>. \<omega> (i, j))  \<in> Pi\<^sub>M (I \<times> J) (\<lambda>(i, j). M i j) \<rightarrow>\<^sub>M M i j" if "i \<in> I" "j \<in> J" for i j
    using measurable_component_singleton[of "(i,j)" "I \<times> J" "\<lambda>(i, j). M i j"] that by auto
  show "(\<lambda>x i j. if i \<notin> I then undefined j else if j \<notin> J then undefined else x (i, j)) \<in> (\<Pi>\<^sub>M (i,j)\<in>I\<times>J. M i j) \<rightarrow>\<^sub>M (\<Pi>\<^sub>M i\<in>I. \<Pi>\<^sub>M j\<in>J. M i j)"
    by(auto intro!: measurable_PiM_single') (simp_all add: PiE_iff space_PiM extensional_def)
next
  show "x \<in> space (\<Pi>\<^sub>M i\<in>I. \<Pi>\<^sub>M j\<in>J. M i j) \<Longrightarrow> (\<lambda>i j. if i \<notin> I then undefined j else if j \<notin> J then undefined else case (i, j) of (i, j) \<Rightarrow> if (i, j) \<in> I \<times> J then x i j else undefined) = x" for x
    by standard+ (auto simp: space_PiM PiE_def Pi_def extensional_def)
next
  show "y \<in> space (\<Pi>\<^sub>M (i,j)\<in>I\<times>J. M i j) \<Longrightarrow> (\<lambda>(i, j). if (i, j) \<in> I \<times> J then if i \<notin> I then undefined j else if j \<notin> J then undefined else y (i, j) else undefined) = y" for y
    by standard+ (auto simp: space_PiM PiE_def Pi_def extensional_def)
qed

lemma measurable_isomorphic_map_sigma_sets:
  assumes "sets M = sigma_sets (space M) U" "measurable_isomorphic_map M N f"
  shows "sets N = sigma_sets (space N) ((`) f ` U)"
proof -
  from measurable_isomorphic_mapD'[OF assms(2)]
  obtain g where h: "\<And>A. A \<in> sets M \<Longrightarrow> f ` A \<in> sets N" "f \<in> M \<rightarrow>\<^sub>M N" "bij_betw g (space N) (space M)" "g \<in> N \<rightarrow>\<^sub>M M" "\<And>x. x\<in>space M \<Longrightarrow> g (f x) = x" "\<And>x. x\<in>space N \<Longrightarrow> f (g x) = x" "\<And>A. A\<in>sets N \<Longrightarrow> g ` A \<in> sets M"
    by metis
  interpret s: sigma_algebra "space N"  "sigma_sets (space N) ((`) f ` U)"
    by(auto intro!: sigma_algebra_sigma_sets) (metis assms(1) h(2) measurable_space sets.sets_into_space sigma_sets_superset_generator subsetD)
  show ?thesis
  proof safe
    fix x
    assume "x \<in> sets N"
    from h(7)[OF this] assms(1)
    have "g ` x \<in> sigma_sets (space M) U" by simp
    hence "f ` (g ` x) \<in> sigma_sets (space N) ((`) f ` U)"
    proof induction
      case h:(Compl a)
      have "f ` (space M - a) = f ` (space M) - f ` a"
        by(rule inj_on_image_set_diff[where C="space M"], insert assms h) (auto simp: measurable_isomorphic_map_def bij_betw_def sets.sets_into_space)
      with h show ?case
        by (metis assms(2) measurable_isomorphic_map_surj s.Diff s.top) 
    qed (auto simp: image_UN)
    moreover have "f ` (g ` x) = x"
      using sets.sets_into_space[OF \<open>x \<in> sets N\<close>] h(6) by(fastforce simp: image_def)
    ultimately show "x \<in> sigma_sets (space N) ((`) f ` U)" by simp
  next
    interpret s': sigma_algebra "space M" "sigma_sets (space M) U"
      by(simp add: assms(1)[symmetric] sets.sigma_algebra_axioms)
    have 1:"\<And>x. x \<in> U \<Longrightarrow> x \<subseteq> space M"
      by (simp add: s'.sets_into_space)
    fix x
    assume assm:"x \<in> sigma_sets (space N) ((`) f ` U)"
    then show "x \<in> sets N"
      by induction (auto simp: assms(1) h(1))
  qed
qed

subsubsection \<open>Borel Spaces Genereted from Abstract Topologies\<close>
definition borel_of :: "'a topology \<Rightarrow> 'a measure" where
"borel_of X \<equiv> sigma (topspace X) {U. openin X U}"

lemma emeasure_borel_of: "emeasure (borel_of X) A = 0"
  by (simp add: borel_of_def emeasure_sigma)

lemma borel_of_euclidean: "borel_of euclidean = borel"
  by(simp add: borel_of_def borel_def)

lemma space_borel_of: "space (borel_of X) = topspace X"
  by(simp add: space_measure_of_conv borel_of_def)

lemma sets_borel_of: "sets (borel_of X) = sigma_sets (topspace X) {U. openin X U}"
  by (simp add: subset_Pow_Union topspace_def borel_of_def)

lemma sets_borel_of_closed: "sets (borel_of X) = sigma_sets (topspace X) {U. closedin X U}"
  unfolding sets_borel_of
proof(safe intro!: sigma_sets_eqI)
  fix a
  assume a:"openin X a"
  have "topspace X - (topspace X - a) \<in> sigma_sets (topspace X) {U. closedin X U}"
    by(rule sigma_sets.Compl) (use a in auto)
  thus "a \<in> sigma_sets (topspace X) {U. closedin X U}"
    using openin_subset[OF a] by (simp add: Diff_Diff_Int inf.absorb_iff2) 
next
  fix b
  assume b:"closedin X b"
  have "topspace X - (topspace X - b) \<in> sigma_sets (topspace X) {U. openin X U}"
    by(rule sigma_sets.Compl) (use b in auto)
  thus "b \<in> sigma_sets (topspace X) {U. openin X U}"
    using closedin_subset[OF b] by (simp add: Diff_Diff_Int inf.absorb_iff2) 
qed

lemma borel_of_open:
  assumes "openin X U"
  shows "U \<in> sets (borel_of X)"
  using assms by (simp add: subset_Pow_Union topspace_def borel_of_def)

lemma borel_of_closed:
  assumes "closedin X U"
  shows "U \<in> sets (borel_of X)"
  using assms sigma_sets.Compl[of "topspace X - U" "topspace X"]
  by (simp add: closedin_def double_diff sets_borel_of)

lemma(in Metric_space) nbh_sets[measurable]: "(\<Union>a\<in>A. mball a e) \<in> sets (borel_of mtopology)"
  by(auto intro!: borel_of_open openin_clauses(3))

lemma borel_of_gdelta_in:
  assumes "gdelta_in X U"
  shows "U \<in> sets (borel_of X)"
  using gdelta_inD[OF assms] borel_of_open
  by(auto intro!: sets.countable_INT'[of _ id,simplified])

lemma borel_of_subtopology:
 "borel_of (subtopology X U) = restrict_space (borel_of X) U"
proof(rule measure_eqI)
  show "sets (borel_of (subtopology X U)) = sets (restrict_space (borel_of X) U)"
    unfolding restrict_space_eq_vimage_algebra' sets_vimage_algebra sets_borel_of topspace_subtopology space_borel_of Int_commute[of U]
  proof(rule sigma_sets_eqI)
    fix a
    assume "a \<in> Collect (openin (subtopology X U))"
    then obtain T where "openin X T" "a = T \<inter> U"
      by(auto simp: openin_subtopology)
    show "a \<in> sigma_sets (topspace X \<inter> U) {(\<lambda>x. x) -` A \<inter> (topspace X \<inter> U) |A. A \<in> sigma_sets (topspace X) (Collect (openin X))}"
      using openin_subset[OF \<open>openin X T\<close>] \<open>a = T \<inter> U\<close> by(auto intro!: exI[where x=T] \<open>openin X T\<close>)
  next
    fix b
    assume "b \<in> {(\<lambda>x. x) -` A \<inter> (topspace X \<inter> U) |A. A \<in> sigma_sets (topspace X) (Collect (openin X))}"
    then obtain T where ht:"b = T \<inter> (topspace X \<inter> U)" "T \<in> sigma_sets (topspace X) (Collect (openin X))"
      by auto
    hence "b = T \<inter> U"
    proof -
      have "T \<subseteq> topspace X"
        by(rule sigma_sets_into_sp[OF _ ht(2)]) (simp add: subset_Pow_Union topspace_def)
      thus ?thesis
        by(auto simp: ht(1))
    qed
    with ht(2) show "b \<in> sigma_sets (topspace X \<inter> U) (Collect (openin (subtopology X U)))"
    proof(induction arbitrary: b U)
      case (Basic a)
      then show ?case
        by(auto simp: openin_subtopology)
    next
      case Empty
      then show ?case by simp
    next
      case ih:(Compl a)
      then show ?case
        by (simp add: Diff_Int_distrib2 sigma_sets.Compl)
    next
      case (Union a)
      then show ?case
        by (metis UN_extend_simps(4) sigma_sets.Union)
    qed
  qed
qed(simp add: emeasure_borel_of restrict_space_def emeasure_measure_of_conv)

lemma sets_borel_of_discrete_topology: "sets (borel_of (discrete_topology I)) = sets (count_space I)"
  by (metis Pow_UNIV UNIV_eq_I borel_of_open borel_of_subtopology inf.absorb_iff2 openin_discrete_topology sets_count_space sets_restrict_space sets_restrict_space_count_space subtopology_discrete_topology top_greatest)

lemma continuous_map_measurable:
  assumes "continuous_map X Y f"
  shows "f \<in> borel_of X \<rightarrow>\<^sub>M borel_of Y"
proof(rule measurable_sigma_sets[OF sets_borel_of[of Y]])
  show "{U. openin Y U} \<subseteq> Pow (topspace Y)"
    by (simp add: subset_Pow_Union topspace_def)
next
  show "f \<in> space (borel_of X) \<rightarrow> topspace Y"
    using continuous_map_image_subset_topspace[OF assms]
    by(auto simp: space_borel_of)
next
  fix U
  assume "U \<in> {U. openin Y U}"
  then have "openin X (f -` U \<inter> topspace X)"
    using continuous_map[of X Y f] assms by auto
  thus "f -` U \<inter> space (borel_of X) \<in> sets (borel_of X)"
    by(simp add: space_borel_of sets_borel_of)
qed

lemma upper_semicontinuous_map_measurable:
  fixes f :: "'a \<Rightarrow> 'b :: {linorder_topology, second_countable_topology}"
  assumes "upper_semicontinuous_map X f"
  shows "f \<in> borel_measurable (borel_of X)"
  using assms by(auto intro!: borel_measurableI_less borel_of_open simp: space_borel_of upper_semicontinuous_map_def)

lemma lower_semicontinuous_map_measurable:
  fixes f :: "'a \<Rightarrow> 'b :: {linorder_topology, second_countable_topology}"
  assumes "lower_semicontinuous_map X f"
  shows "f \<in> borel_measurable (borel_of X)"
  using assms by(auto intro!: borel_measurableI_greater borel_of_open simp: space_borel_of lower_semicontinuous_map_def)

lemma open_map_preserves_sets:
  assumes "open_map S T f" "inj_on f (topspace S)" "A \<in> sets (borel_of S)"
  shows "f ` A \<in> sets (borel_of T)"
  using assms(3)[simplified sets_borel_of]
proof(induction)
  case (Basic a)
  with assms(1) show ?case
    by(auto simp: sets_borel_of open_map_def)
next
  case Empty
  show ?case by simp
next
  case (Compl a)
  moreover have "f ` (topspace S - a) = f ` (topspace S) - f ` a"
    by (metis Diff_subset assms(2) calculation(1) inj_on_image_set_diff sigma_sets_into_sp subset_Pow_Union topspace_def)
  moreover have "f ` (topspace S) \<in> sets (borel_of T)"
    by (meson assms(1) borel_of_open open_map_def openin_topspace)
  ultimately show ?case
    by auto
next
  case (Union a)
  then show ?case
    by (simp add: image_UN)
qed

lemma open_map_preserves_sets':
  assumes "open_map S (subtopology T (f ` (topspace S))) f" "inj_on f (topspace S)" "f ` (topspace S) \<in> sets (borel_of T)" "A \<in> sets (borel_of S)"
  shows "f ` A \<in> sets (borel_of T)"
  using assms(4)[simplified sets_borel_of]
proof(induction)
  case (Basic a)
  then have "openin (subtopology T (f ` (topspace S))) (f ` a)"
    using assms(1) by(auto simp: open_map_def)
  hence "f ` a \<in> sets (borel_of (subtopology T (f ` (topspace S))))"
    by(simp add: sets_borel_of)
  hence "f ` a \<in> sets (restrict_space (borel_of T) (f ` (topspace S)))"
    by(simp add: borel_of_subtopology)
  thus ?case
    by (metis sets_restrict_space_iff assms(3) sets.Int_space_eq2)
next
  case Empty
  show ?case by simp
next
  case (Compl a)
  moreover have "f ` (topspace S - a) = f ` (topspace S) - f ` a"
    by (metis Diff_subset assms(2) calculation(1) inj_on_image_set_diff sigma_sets_into_sp subset_Pow_Union topspace_def)
  ultimately show ?case
    using assms(3) by auto
next
  case (Union a)
  then show ?case
    by (simp add: image_UN)
qed


text \<open> Abstract topology version of @{thm second_countable_borel_measurable}. \<close>
lemma borel_of_second_countable':
  assumes "second_countable S" and "subbase_in S \<U>"
  shows "borel_of S = sigma (topspace S) \<U>"
  unfolding borel_of_def
proof(rule sigma_eqI)
  show "{U. openin S U} \<subseteq> Pow (topspace S)"
    by (simp add: subset_Pow_Union topspace_def)
next
  show "\<U> \<subseteq> Pow (topspace S)"
    using subbase_in_subset[OF assms(2)] by auto
next
  interpret s: sigma_algebra "topspace S" "sigma_sets (topspace S) \<U>"
    using subbase_in_subset[OF assms(2)] by(auto intro!: sigma_algebra_sigma_sets)
  obtain \<O> where ho: "countable \<O>" "base_in S \<O>"
    using assms(1) by(auto simp: second_countable_base_in)
  show "sigma_sets (topspace S) {U. openin S U} = sigma_sets (topspace S) \<U>"
  proof(rule sigma_sets_eqI)
    fix U
    assume "U \<in> {U. openin S U}"
    then have "generate_topology_on \<U> U"
      using assms(2) by(simp add: subbase_in_def openin_topology_generated_by_iff)
    thus "U \<in> sigma_sets (topspace S) \<U>"
    proof induction
      case (UN K)
      with ho(2) obtain V where hv:
       "\<And>k. k \<in> K \<Longrightarrow> V k \<subseteq> \<O>" "\<And>k. k \<in> K \<Longrightarrow> \<Union> (V k) = k"
        by(simp add: base_in_def openin_topology_generated_by_iff[symmetric] assms(2)[simplified subbase_in_def,symmetric]) metis
      define \<U>k where "\<U>k = (\<Union>k\<in>K. V k)"
      have 0:"countable \<U>k"
        using hv by(auto intro!: countable_subset[OF _ ho(1)] simp: \<U>k_def)
      have "\<Union> \<U>k = (\<Union>A\<in>\<U>k. A)" by auto
      also have "... = \<Union> K"
        unfolding \<U>k_def UN_simps by(simp add: hv(2))
      finally have 1:"\<Union> \<U>k = \<Union> K" .
      have "\<forall>b\<in>\<U>k. \<exists>k\<in>K. b \<subseteq> k"
        using hv by (auto simp: \<U>k_def)
      then obtain V' where hv': "\<And>b. b \<in> \<U>k \<Longrightarrow> V' b \<in> K" and "\<And>b. b \<in> \<U>k \<Longrightarrow> b \<subseteq> V' b"
        by metis
      then have "(\<Union>b\<in>\<U>k. V' b) \<subseteq> \<Union>K" "\<Union>\<U>k \<subseteq> (\<Union>b\<in>\<U>k. V' b)"
        by auto
      then have "\<Union>K = (\<Union>b\<in>\<U>k. V' b)"
        unfolding 1 by auto
      also have "\<dots> \<in> sigma_sets (topspace S) \<U>"
        using hv' UN by(auto intro!: s.countable_UN' simp: 0)
      finally show "\<Union>K \<in> sigma_sets (topspace S) \<U>" .
    qed auto
  next
    fix U
    assume "U \<in> \<U>"
    from assms(2)[simplified subbase_in_def] openin_topology_generated_by_iff generate_topology_on.Basis[OF this]
    show "U \<in> sigma_sets (topspace S) {U. openin S U}"
      by auto
  qed
qed

text \<open> Abstract topology version @{thm borel_prod}.\<close>
lemma borel_of_prod:
  assumes "second_countable S" and "second_countable S'"
  shows "borel_of S \<Otimes>\<^sub>M borel_of S' = borel_of (prod_topology S S')"
proof -
  have "borel_of S \<Otimes>\<^sub>M borel_of S' = sigma (topspace S \<times> topspace S') {a \<times> b |a b. a \<in> {a. openin S a} \<and> b \<in> {b. openin S' b}}"
  proof -
    obtain \<O> \<O>' where ho:
    "countable \<O>" "base_in S \<O>" "countable \<O>'" "base_in S' \<O>'"
      using assms by(auto simp: second_countable_base_in)
    show ?thesis
      unfolding borel_of_def
      apply(rule sigma_prod)
      using topology_generated_by_topspace[of \<O>,simplified base_is_subbase[OF ho(2),simplified subbase_in_def,symmetric]] topology_generated_by_topspace[of \<O>',simplified base_is_subbase[OF ho(4),simplified subbase_in_def,symmetric]]
              base_in_openin[OF ho(2)] base_in_openin[OF ho(4)]
      by(auto intro!: exI[where x=\<O>] exI[where x=\<O>'] simp: ho subset_Pow_Union topspace_def)
  qed
  also have "... = borel_of (prod_topology S S')"
    using borel_of_second_countable'[OF prod_topology_second_countable[OF assms],simplified subbase_in_def,OF prod_topology_generated_by_open]
    by simp
  finally show ?thesis .
qed

lemma product_borel_of_measurable:
  assumes "i \<in> I"
  shows "(\<lambda>x. x i) \<in> (borel_of (product_topology S I)) \<rightarrow>\<^sub>M borel_of (S i)"
  by(auto intro!: continuous_map_measurable simp: assms)


text \<open> Abstract topology version of @{thm sets_PiM_subset_borel} \<close>
lemma sets_PiM_subset_borel_of:
  "sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i)) \<subseteq> sets (borel_of (product_topology S I))"
proof -
  have *: "(\<Pi>\<^sub>E i\<in>I. X i) \<in> sets (borel_of (product_topology S I))" if [measurable]:"\<And>i. X i \<in> sets (borel_of (S i))" "finite {i. X i \<noteq> topspace (S i)}" for X
  proof -
    note [measurable] = product_borel_of_measurable
    define I' where "I' = {i. X i \<noteq> topspace (S i)} \<inter> I"
    have "finite I'" unfolding I'_def using that by simp
    have "(\<Pi>\<^sub>E i\<in>I. X i) = (\<Inter>i\<in>I'. (\<lambda>x. x i)-`(X i) \<inter> space (borel_of (product_topology S I))) \<inter> space (borel_of (product_topology S I))"
    proof(standard;standard)
      fix x
      assume "x \<in> Pi\<^sub>E I X"
      then show "x \<in> (\<Inter>i\<in>I'. (\<lambda>x. x i) -` X i \<inter> space (borel_of (product_topology S I))) \<inter> space (borel_of (product_topology S I))"
        using sets.sets_into_space[OF that(1)] by(auto simp: PiE_def I'_def Pi_def space_borel_of)
    next
      fix x
      assume 1:"x \<in> (\<Inter>i\<in>I'. (\<lambda>x. x i) -` X i \<inter> space (borel_of (product_topology S I))) \<inter> space (borel_of (product_topology S I))"
      have "x i \<in> X i" if hi:"i \<in> I" for i
      proof -
        consider "i \<in> I' \<and> I' \<noteq> {}" | "i \<notin> I' \<and> I' = {}" | "i \<notin> I' \<and> I' \<noteq> {}" by auto
        then show ?thesis
          apply cases
          using sets.sets_into_space[OF \<open>\<And>i. X i \<in> sets (borel_of (S i))\<close>] 1 that
          by(auto simp: space_borel_of I'_def)
      qed
      then show "x \<in> Pi\<^sub>E I X"
        using 1 by(auto simp: space_borel_of)
    qed
    also have "... \<in> sets (borel_of (product_topology S I))"
     using that \<open>finite I'\<close> by(auto simp: I'_def)
    finally show ?thesis .
  qed
  then have "{Pi\<^sub>E I X |X. (\<forall>i. X i \<in> sets (borel_of (S i))) \<and> finite {i. X i \<noteq> space (borel_of (S i))}} \<subseteq> sets (borel_of (product_topology S I))"
    by(auto simp: space_borel_of)
  show ?thesis unfolding sets_PiM_finite
    by(rule sets.sigma_sets_subset',fact) (simp add: borel_of_open[OF openin_topspace, of "product_topology S I",simplified] space_borel_of)
qed

text \<open> Abstract topology version of @{thm sets_PiM_equal_borel}.\<close>
lemma sets_PiM_equal_borel_of:
  assumes "countable I" and "\<And>i. i \<in> I \<Longrightarrow> second_countable (S i)"
  shows "sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i)) = sets (borel_of (product_topology S I))"
proof
  obtain K where hk:
  "countable K" "base_in (product_topology S I) K"
  "\<And>k. k \<in> K \<Longrightarrow> \<exists>X. (k = (\<Pi>\<^sub>E i\<in>I. X i)) \<and> (\<forall>i. openin (S i) (X i)) \<and> finite {i. X i \<noteq> topspace (S i)} \<and> {i. X i \<noteq> topspace (S i)} \<subseteq> I"
    using product_topology_countable_base_in[OF assms(1)] assms(2)
    by force
  have *:"k \<in> sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i))" if "k \<in> K" for k
  proof -
    obtain X where H: "k = (\<Pi>\<^sub>E i\<in>I. X i)" "\<And>i. openin (S i) (X i)" "finite {i. X i \<noteq> topspace (S i)}" "{i. X i \<noteq> topspace (S i)} \<subseteq> I"
      using hk(3)[OF \<open>k \<in> K\<close>] by blast
    show ?thesis unfolding H(1) sets_PiM_finite
      using borel_of_open[OF H(2)] H(3) by(auto simp: space_borel_of)
  qed
  have **: "U \<in> sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i))" if "openin (product_topology S I) U" for U
  proof -
    obtain B where "B \<subseteq> K" "U = (\<Union>B)"
      using \<open>openin (product_topology S I) U\<close> \<open>base_in (product_topology S I) K\<close> by (metis base_in_def)
    have "countable B" using \<open>B \<subseteq> K\<close> \<open>countable K\<close> countable_subset by blast
    moreover have "k \<in> sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i))" if "k \<in> B" for k
      using \<open>B \<subseteq> K\<close> * that by auto
    ultimately show ?thesis unfolding \<open>U = (\<Union>B)\<close> by auto
  qed
  have "sigma_sets (topspace (product_topology S I)) {U. openin (product_topology S I) U} \<subseteq> sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i))"
    apply (rule sets.sigma_sets_subset') using ** by(auto intro!: sets_PiM_I_countable[OF assms(1)] simp: borel_of_open[OF openin_topspace])
  thus " sets (borel_of (product_topology S I)) \<subseteq> sets (\<Pi>\<^sub>M i\<in>I. borel_of (S i))"
    by (simp add: subset_Pow_Union topspace_def borel_of_def) 
qed(rule sets_PiM_subset_borel_of)

lemma homeomorphic_map_borel_isomorphic:
  assumes "homeomorphic_map X Y f"
  shows "measurable_isomorphic_map (borel_of X) (borel_of Y) f"
proof -
  obtain g where "homeomorphic_maps X Y f g"
    using assms by(auto simp: homeomorphic_map_maps)
  hence "continuous_map X Y f" "continuous_map Y X g"
        "\<And>x. x \<in> topspace X \<Longrightarrow> g (f x) = x"
        "\<And>y. y \<in> topspace Y \<Longrightarrow> f (g y) = y"
    by(auto simp: homeomorphic_maps_def)
  thus ?thesis
    by(auto intro!: measurable_isomorphic_map_byWitness dest: continuous_map_measurable simp: space_borel_of)
qed

lemma homeomorphic_space_measurable_isomorphic:
  assumes "S homeomorphic_space T"
  shows "borel_of S measurable_isomorphic borel_of T"
  using homeomorphic_map_borel_isomorphic[of S T] assms by(auto simp: measurable_isomorphic_def homeomorphic_space)

lemma measurable_isomorphic_borel_map:
  assumes "sets M = sets (borel_of S)" and f: "measurable_isomorphic_map M N f"
  shows "\<exists>S'. homeomorphic_map S S' f \<and> sets N = sets (borel_of S')"
proof -
  obtain g where fg:"f \<in> M \<rightarrow>\<^sub>M N" "g \<in> N \<rightarrow>\<^sub>M M" "\<And>x. x\<in>space M \<Longrightarrow> g (f x) = x" "\<And>y. y\<in>space N \<Longrightarrow> f (g y) = y" "\<And>A. A\<in>sets M \<Longrightarrow> f ` A \<in> sets N" "\<And>A. A\<in>sets N \<Longrightarrow> g ` A \<in> sets M" "bij_betw g (space N) (space M)"
    using measurable_isomorphic_mapD'[OF f] by metis
  have g:"measurable_isomorphic_map N M g"
    by(auto intro!: measurable_isomorphic_map_byWitness fg)
  have g':"bij_betw g (space N) (topspace S)"
    using fg(7) sets_eq_imp_space_eq[OF assms(1)] by(auto simp: space_borel_of)
  show ?thesis
  proof(intro exI[where x="pullback_topology (space N) g S"] conjI)
    have [simp]: "{U. openin (pullback_topology (space N) g S) U} = (`) f ` {U. openin S U}"
      unfolding openin_pullback_topology'[OF g']
    proof safe
      fix u
      assume u:"openin S u"
      then have 1:"u \<subseteq> space M"
        by(simp add: sets_eq_imp_space_eq[OF assms(1)] space_borel_of openin_subset)
      with fg(3) have "g ` f ` u = u"
        by(fastforce simp: image_def)
      with u show "openin S (g ` f ` u)" by simp
      fix x
      assume "x \<in> u"
      with 1 fg(1) show "f x \<in> space N" by(auto simp: measurable_space)
    next
      fix u
      assume "openin S (g ` u)" "u \<subseteq> space N"
      with fg(4) show "u \<in> (`) f ` {U. openin S U}"
        by(auto simp: image_def intro!: exI[where x="g ` u"]) (metis in_mono)
    qed
    have [simp]:"g -` topspace S \<inter> space N = space N"
      using bij_betw_imp_surj_on g' by blast
    show "sets N = sets (borel_of (pullback_topology (space N) g S))"
      by(auto simp: sets_borel_of topspace_pullback_topology intro!: measurable_isomorphic_map_sigma_sets[OF assms(1)[simplified sets_borel_of space_borel_of[symmetric] sets_eq_imp_space_eq[OF assms(1),symmetric]] f])
  next
    show "homeomorphic_map S (pullback_topology (space N) g S) f"
    proof(rule homeomorphic_maps_imp_map[where g=g])
      obtain f' where f':"homeomorphic_maps (pullback_topology (space N) g S) S g f'"
        using topology_from_bij(1)[OF g'] homeomorphic_map_maps by blast
      have f'2:"f' y = f y" if y:"y \<in> topspace S" for y
      proof -
        have [simp]:"g -` topspace S \<inter> space N = space N"
          using bij_betw_imp_surj_on g' by blast
        obtain x where "x \<in> space N" "y = g x"
          using g' y by(auto simp: bij_betw_def image_def)
        thus ?thesis
          using fg(4) f' by(auto simp: homeomorphic_maps_def topspace_pullback_topology)
      qed
      thus "homeomorphic_maps S (pullback_topology (space N) g S) f g"
        by(auto intro!: homeomorphic_maps_eq[OF f'] simp: homeomorphic_maps_sym[of S])
    qed
  qed
qed

lemma measurable_isomorphic_borels:
  assumes "sets M = sets (borel_of S)" "M measurable_isomorphic N"
  shows "\<exists>S'. S homeomorphic_space S' \<and> sets N = sets (borel_of S')"
  using measurable_isomorphic_borel_map[OF assms(1)] assms(2) homeomorphic_map_maps
  by(fastforce simp: measurable_isomorphic_def homeomorphic_space_def )

end