theory Nonground_Selection_Function
  imports
    Nonground_Clause_Generic
    Selection_Function
begin

context nonground_clause_generic
begin

definition is_select_grounding :: "'a select \<Rightarrow> 'g select \<Rightarrow> bool" where
  "is_select_grounding select select\<^sub>G \<equiv> \<forall>C\<^sub>G. \<exists>C \<gamma>.
    clause.is_ground (C \<cdot> \<gamma>) \<and>
    C\<^sub>G = clause.to_ground (C \<cdot> \<gamma>) \<and>
    select\<^sub>G C\<^sub>G = clause.to_ground ((select C) \<cdot> \<gamma>)"

end

locale nonground_selection_function =
  nonground_clause_generic where atom_to_ground = atom_to_ground +
  selection_function select
for 
  select :: "'a clause \<Rightarrow> 'a clause" and
  atom_to_ground :: "'a \<Rightarrow> 'g"
begin

abbreviation is_grounding :: "'g select \<Rightarrow> bool" where
  "is_grounding select\<^sub>G \<equiv> is_select_grounding select select\<^sub>G"

definition select\<^sub>G\<^sub>s where
  "select\<^sub>G\<^sub>s = { select\<^sub>G. is_grounding select\<^sub>G }"

definition select\<^sub>G_simple where
  "select\<^sub>G_simple C = clause.to_ground (select (clause.from_ground C))"

lemma select\<^sub>G_simple: "is_grounding select\<^sub>G_simple"
  unfolding is_select_grounding_def select\<^sub>G_simple_def
  by (metis clause.from_ground_inverse clause.ground_is_ground clause.subst_id_subst)

lemma select_is_ground:
  assumes "clause.is_ground C"
  shows "clause.is_ground (select C)"
  using select_subset sub_ground_clause assms
  by metis

lemma is_ground_in_selection:
  assumes "l \<in># select (clause.from_ground C)"
  shows "literal.is_ground l"
  using assms clause.sub_in_ground_is_ground select_subset
  by blast

lemma ground_literal_in_selection:
  assumes "clause.is_ground C" "l\<^sub>G \<in># clause.to_ground C"
  shows "literal.from_ground l\<^sub>G \<in># C"
  using assms
  by (metis clause.to_ground_inverse clause.ground_sub_in_ground)

lemma select_ground_subst:
  assumes "clause.is_ground (C \<cdot> \<gamma>)"
  shows "clause.is_ground (select C \<cdot> \<gamma>)"
  using assms
  by (metis image_mset_subseteq_mono select_subset sub_ground_clause clause.subst_def)

lemma select_neg_subst:
  assumes "l \<in># select C \<cdot> \<gamma>"
  shows "is_neg l"
  using assms subst_neg_stable select_negative_literals
  unfolding clause.subst_def
  by blast

lemma select_vars_subset: "\<And>C. clause.vars (select C) \<subseteq> clause.vars C"
  by (simp add: clause_submset_vars_clause_subset select_subset)

end

end
