chapter \<open>Generated by Lem from \<open>num.lem\<close>.\<close>

theory "Lem_num" 

imports
  Main
  "Lem_bool"
  "Lem_basic_classes"
  "HOL-Library.Word"
  "Complex_Main"

begin 



\<comment> \<open>\<open>open import Bool Basic_classes\<close>\<close>
\<comment> \<open>\<open>open import {isabelle} `HOL-Library.Word` `Complex_Main`\<close>\<close>
\<comment> \<open>\<open>open import {hol} `integerTheory` `intReduce` `wordsTheory` `wordsLib` `ratTheory` `realTheory` `intrealTheory` `transcTheory`\<close>\<close>
\<comment> \<open>\<open>open import {coq} `Coq.Numbers.BinNums` `Coq.ZArith.BinInt` `Coq.ZArith.Zpower` `Coq.ZArith.Zdiv` `Coq.ZArith.Zmax` `Coq.Numbers.Natural.Peano.NPeano` `Coq.QArith.Qabs` `Coq.QArith.Qminmax` `Coq.QArith.Qround` `Coq.Reals.ROrderedType` `Coq.Reals.Rbase` `Coq.Reals.Rfunctions`\<close>\<close> 

\<comment> \<open>\<open>class inline ( Numeral 'a ) 
  val fromNumeral : numeral -> 'a 
end\<close>\<close>

\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Syntactic type-classes for common operations                               \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> Typeclasses can be used as a mean to overload constants like "+", "-", etc \<close>\<close>

record 'a NumNegate_class= 
 
  numNegate_method ::" 'a \<Rightarrow> 'a " 



record 'a NumAbs_class= 
 
  abs_method ::" 'a \<Rightarrow> 'a " 



record 'a NumAdd_class= 
 
  numAdd_method ::" 'a \<Rightarrow> 'a \<Rightarrow> 'a "



record 'a NumMinus_class= 
 
  numMinus_method ::" 'a \<Rightarrow> 'a \<Rightarrow> 'a "



record 'a NumMult_class= 
 
  numMult_method ::" 'a \<Rightarrow> 'a \<Rightarrow> 'a "



record 'a NumPow_class= 
 
  numPow_method ::" 'a \<Rightarrow> nat \<Rightarrow> 'a "



record 'a NumDivision_class= 
 
  numDivision_method ::" 'a \<Rightarrow> 'a \<Rightarrow> 'a "



record 'a NumIntegerDivision_class= 
 
  div_method ::" 'a \<Rightarrow> 'a \<Rightarrow> 'a "




record 'a NumRemainder_class= 
 
  mod_method ::" 'a \<Rightarrow> 'a \<Rightarrow> 'a "



record 'a NumSucc_class= 
 
  succ_method ::" 'a \<Rightarrow> 'a "



record 'a NumPred_class= 
 
  pred_method ::" 'a \<Rightarrow> 'a "

 


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> natural                 \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> unbounded size natural numbers \<close>\<close>
\<comment> \<open>\<open>type natural\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> int                     \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> bounded size integers with uncertain length \<close>\<close>

\<comment> \<open>\<open>type int\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> integer                 \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> unbounded size integers \<close>\<close>

\<comment> \<open>\<open>type integer\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> bint                    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> TODO the bounded ints are only partially implemented, use with care. \<close>\<close>

\<comment> \<open>\<open> 32 bit integers \<close>\<close>
\<comment> \<open>\<open>type int32\<close>\<close> 

\<comment> \<open>\<open> 64 bit integers \<close>\<close>
\<comment> \<open>\<open>type int64\<close>\<close> 


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> rational                \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> unbounded size and precision rational numbers \<close>\<close>

\<comment> \<open>\<open>type rational\<close>\<close> \<comment> \<open>\<open> ???: better type for this in HOL? \<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> real                    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> real numbers \<close>\<close>
\<comment> \<open>\<open> Note that for OCaml, this is mapped to floats with 64 bits. \<close>\<close>

\<comment> \<open>\<open>type real\<close>\<close> \<comment> \<open>\<open> ???: better type for this in HOL? \<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> double                  \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> double precision floating point (64 bits) \<close>\<close>

\<comment> \<open>\<open>type float64\<close>\<close> \<comment> \<open>\<open> ???: better type for this in HOL? \<close>\<close>

\<comment> \<open>\<open>type float32\<close>\<close> \<comment> \<open>\<open> ???: better type for this in HOL? \<close>\<close>


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Binding the standard operations for the number types                       \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> nat                     \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val natFromNumeral : numeral -> nat\<close>\<close>

\<comment> \<open>\<open>val natEq : nat -> nat -> bool\<close>\<close>

\<comment> \<open>\<open>val natLess : nat -> nat -> bool\<close>\<close>
\<comment> \<open>\<open>val natLessEqual : nat -> nat -> bool\<close>\<close>
\<comment> \<open>\<open>val natGreater : nat -> nat -> bool\<close>\<close>
\<comment> \<open>\<open>val natGreaterEqual : nat -> nat -> bool\<close>\<close>

\<comment> \<open>\<open>val natCompare : nat -> nat -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_nat_dict  :: "(nat)Ord_class "  where 
     " instance_Basic_classes_Ord_nat_dict = ((|

  compare_method = (genericCompare (<) (=)),

  isLess_method = (<),

  isLessEqual_method = (\<le>),

  isGreater_method = (>),

  isGreaterEqual_method = (\<ge>)|) )"


\<comment> \<open>\<open>val natAdd : nat -> nat -> nat\<close>\<close>

definition instance_Num_NumAdd_nat_dict  :: "(nat)NumAdd_class "  where 
     " instance_Num_NumAdd_nat_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val natMinus : nat -> nat -> nat\<close>\<close>

definition instance_Num_NumMinus_nat_dict  :: "(nat)NumMinus_class "  where 
     " instance_Num_NumMinus_nat_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val natSucc : nat -> nat\<close>\<close>
\<comment> \<open>\<open>let natSucc n=  (Instance_Num_NumAdd_nat.+) n 1\<close>\<close>
definition instance_Num_NumSucc_nat_dict  :: "(nat)NumSucc_class "  where 
     " instance_Num_NumSucc_nat_dict = ((|

  succ_method = Suc |) )"


\<comment> \<open>\<open>val natPred : nat -> nat\<close>\<close>
definition instance_Num_NumPred_nat_dict  :: "(nat)NumPred_class "  where 
     " instance_Num_NumPred_nat_dict = ((|

  pred_method = (\<lambda> n. n -( 1 :: nat))|) )"


\<comment> \<open>\<open>val natMult : nat -> nat -> nat\<close>\<close>

definition instance_Num_NumMult_nat_dict  :: "(nat)NumMult_class "  where 
     " instance_Num_NumMult_nat_dict = ((|

  numMult_method = (*)|) )"


\<comment> \<open>\<open>val natDiv : nat -> nat -> nat\<close>\<close>

definition instance_Num_NumIntegerDivision_nat_dict  :: "(nat)NumIntegerDivision_class "  where 
     " instance_Num_NumIntegerDivision_nat_dict = ((|

  div_method = (div)|) )"


definition instance_Num_NumDivision_nat_dict  :: "(nat)NumDivision_class "  where 
     " instance_Num_NumDivision_nat_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val natMod : nat -> nat -> nat\<close>\<close>

definition instance_Num_NumRemainder_nat_dict  :: "(nat)NumRemainder_class "  where 
     " instance_Num_NumRemainder_nat_dict = ((|

  mod_method = (mod)|) )"



\<comment> \<open>\<open>val gen_pow_aux : forall 'a. ('a -> 'a -> 'a) -> 'a -> 'a -> nat -> 'a\<close>\<close>
fun  gen_pow_aux  :: "('a \<Rightarrow> 'a \<Rightarrow> 'a)\<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> nat \<Rightarrow> 'a "  where 
     " gen_pow_aux (mul :: 'a \<Rightarrow> 'a \<Rightarrow> 'a) (a :: 'a) (b :: 'a) (e :: nat) = (
   (case  e of
       0 => a \<comment> \<open>\<open> cannot happen, call discipline guarentees e >= 1 \<close>\<close>
     | (Suc 0) => mul a b
     | (  (Suc(Suc e'))) => (let e'' = (e div( 2 :: nat)) in
                   (let a' = (if (e mod( 2 :: nat)) =( 0 :: nat) then a else mul a b) in
                   gen_pow_aux mul a' (mul b b) e''))
   ))"

       
definition gen_pow  :: " 'a \<Rightarrow>('a \<Rightarrow> 'a \<Rightarrow> 'a)\<Rightarrow> 'a \<Rightarrow> nat \<Rightarrow> 'a "  where 
     " gen_pow (one :: 'a) (mul :: 'a \<Rightarrow> 'a \<Rightarrow> 'a) (b :: 'a) (e :: nat) = ( 
  if e <( 0 :: nat) then one else 
  if (e =( 0 :: nat)) then one else gen_pow_aux mul one b e )"


\<comment> \<open>\<open>val natPow : nat -> nat -> nat\<close>\<close>

definition instance_Num_NumPow_nat_dict  :: "(nat)NumPow_class "  where 
     " instance_Num_NumPow_nat_dict = ((|

  numPow_method = (^)|) )"


\<comment> \<open>\<open>val natMin : nat -> nat -> nat\<close>\<close>

\<comment> \<open>\<open>val natMax : nat -> nat -> nat\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_nat_dict  :: "(nat)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_nat_dict = ((|

  max_method = max,

  min_method = min |) )"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> natural                 \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val naturalFromNumeral : numeral -> natural\<close>\<close>

\<comment> \<open>\<open>val naturalEq : natural -> natural -> bool\<close>\<close>

\<comment> \<open>\<open>val naturalLess : natural -> natural -> bool\<close>\<close>
\<comment> \<open>\<open>val naturalLessEqual : natural -> natural -> bool\<close>\<close>
\<comment> \<open>\<open>val naturalGreater : natural -> natural -> bool\<close>\<close>
\<comment> \<open>\<open>val naturalGreaterEqual : natural -> natural -> bool\<close>\<close>

\<comment> \<open>\<open>val naturalCompare : natural -> natural -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_natural_dict  :: "(nat)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_natural_dict = ((|

  compare_method = (genericCompare (<) (=)),

  isLess_method = (<),

  isLessEqual_method = (\<le>),

  isGreater_method = (>),

  isGreaterEqual_method = (\<ge>)|) )"


\<comment> \<open>\<open>val naturalAdd : natural -> natural -> natural\<close>\<close>

definition instance_Num_NumAdd_Num_natural_dict  :: "(nat)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_natural_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val naturalMinus : natural -> natural -> natural\<close>\<close>

definition instance_Num_NumMinus_Num_natural_dict  :: "(nat)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_natural_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val naturalSucc : natural -> natural\<close>\<close>
\<comment> \<open>\<open>let naturalSucc n=  (Instance_Num_NumAdd_Num_natural.+) n 1\<close>\<close>
definition instance_Num_NumSucc_Num_natural_dict  :: "(nat)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_natural_dict = ((|

  succ_method = Suc |) )"


\<comment> \<open>\<open>val naturalPred : natural -> natural\<close>\<close>
definition instance_Num_NumPred_Num_natural_dict  :: "(nat)NumPred_class "  where 
     " instance_Num_NumPred_Num_natural_dict = ((|

  pred_method = (\<lambda> n. n -( 1 :: nat))|) )"


\<comment> \<open>\<open>val naturalMult : natural -> natural -> natural\<close>\<close>

definition instance_Num_NumMult_Num_natural_dict  :: "(nat)NumMult_class "  where 
     " instance_Num_NumMult_Num_natural_dict = ((|

  numMult_method = (*)|) )"



\<comment> \<open>\<open>val naturalPow : natural -> nat -> natural\<close>\<close>

definition instance_Num_NumPow_Num_natural_dict  :: "(nat)NumPow_class "  where 
     " instance_Num_NumPow_Num_natural_dict = ((|

  numPow_method = (^)|) )"


\<comment> \<open>\<open>val naturalDiv : natural -> natural -> natural\<close>\<close>

definition instance_Num_NumIntegerDivision_Num_natural_dict  :: "(nat)NumIntegerDivision_class "  where 
     " instance_Num_NumIntegerDivision_Num_natural_dict = ((|

  div_method = (div)|) )"


definition instance_Num_NumDivision_Num_natural_dict  :: "(nat)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_natural_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val naturalMod : natural -> natural -> natural\<close>\<close>

definition instance_Num_NumRemainder_Num_natural_dict  :: "(nat)NumRemainder_class "  where 
     " instance_Num_NumRemainder_Num_natural_dict = ((|

  mod_method = (mod)|) )"


\<comment> \<open>\<open>val naturalMin : natural -> natural -> natural\<close>\<close>

\<comment> \<open>\<open>val naturalMax : natural -> natural -> natural\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_natural_dict  :: "(nat)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_natural_dict = ((|

  max_method = max,

  min_method = min |) )"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> int                     \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val intFromNumeral : numeral -> int\<close>\<close>

\<comment> \<open>\<open>val intEq : int -> int -> bool\<close>\<close>

\<comment> \<open>\<open>val intLess : int -> int -> bool\<close>\<close>
\<comment> \<open>\<open>val intLessEqual : int -> int -> bool\<close>\<close>
\<comment> \<open>\<open>val intGreater : int -> int -> bool\<close>\<close>
\<comment> \<open>\<open>val intGreaterEqual : int -> int -> bool\<close>\<close>

\<comment> \<open>\<open>val intCompare : int -> int -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_int_dict  :: "(int)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_int_dict = ((|

  compare_method = (genericCompare (<) (=)),

  isLess_method = (<),

  isLessEqual_method = (\<le>),

  isGreater_method = (>),

  isGreaterEqual_method = (\<ge>)|) )"


\<comment> \<open>\<open>val intNegate : int -> int\<close>\<close>

definition instance_Num_NumNegate_Num_int_dict  :: "(int)NumNegate_class "  where 
     " instance_Num_NumNegate_Num_int_dict = ((|

  numNegate_method = (\<lambda> i. - i)|) )"


\<comment> \<open>\<open>val intAbs : int -> int\<close>\<close> \<comment> \<open>\<open> TODO: check \<close>\<close>

definition instance_Num_NumAbs_Num_int_dict  :: "(int)NumAbs_class "  where 
     " instance_Num_NumAbs_Num_int_dict = ((|

  abs_method = abs |) )"


\<comment> \<open>\<open>val intAdd : int -> int -> int\<close>\<close>

definition instance_Num_NumAdd_Num_int_dict  :: "(int)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_int_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val intMinus : int -> int -> int\<close>\<close>

definition instance_Num_NumMinus_Num_int_dict  :: "(int)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_int_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val intSucc : int -> int\<close>\<close>
definition instance_Num_NumSucc_Num_int_dict  :: "(int)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_int_dict = ((|

  succ_method = (\<lambda> n. n +( 1 :: int))|) )"


\<comment> \<open>\<open>val intPred : int -> int\<close>\<close>
definition instance_Num_NumPred_Num_int_dict  :: "(int)NumPred_class "  where 
     " instance_Num_NumPred_Num_int_dict = ((|

  pred_method = (\<lambda> n. n -( 1 :: int))|) )"


\<comment> \<open>\<open>val intMult : int -> int -> int\<close>\<close>

definition instance_Num_NumMult_Num_int_dict  :: "(int)NumMult_class "  where 
     " instance_Num_NumMult_Num_int_dict = ((|

  numMult_method = (*)|) )"



\<comment> \<open>\<open>val intPow : int -> nat -> int\<close>\<close>

definition instance_Num_NumPow_Num_int_dict  :: "(int)NumPow_class "  where 
     " instance_Num_NumPow_Num_int_dict = ((|

  numPow_method = (^)|) )"


\<comment> \<open>\<open>val intDiv : int -> int -> int\<close>\<close>

definition instance_Num_NumIntegerDivision_Num_int_dict  :: "(int)NumIntegerDivision_class "  where 
     " instance_Num_NumIntegerDivision_Num_int_dict = ((|

  div_method = (div)|) )"


definition instance_Num_NumDivision_Num_int_dict  :: "(int)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_int_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val intMod : int -> int -> int\<close>\<close>

definition instance_Num_NumRemainder_Num_int_dict  :: "(int)NumRemainder_class "  where 
     " instance_Num_NumRemainder_Num_int_dict = ((|

  mod_method = (mod)|) )"


\<comment> \<open>\<open>val intMin : int -> int -> int\<close>\<close>

\<comment> \<open>\<open>val intMax : int -> int -> int\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_int_dict  :: "(int)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_int_dict = ((|

  max_method = max,

  min_method = min |) )"


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> int32                   \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open>val int32FromNumeral : numeral -> int32\<close>\<close>

\<comment> \<open>\<open>val int32Eq : int32 -> int32 -> bool\<close>\<close>

\<comment> \<open>\<open>val int32Less : int32 -> int32 -> bool\<close>\<close>
\<comment> \<open>\<open>val int32LessEqual : int32 -> int32 -> bool\<close>\<close>
\<comment> \<open>\<open>val int32Greater : int32 -> int32 -> bool\<close>\<close>
\<comment> \<open>\<open>val int32GreaterEqual : int32 -> int32 -> bool\<close>\<close>

\<comment> \<open>\<open>val int32Compare : int32 -> int32 -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_int32_dict  :: "( 32 word)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_int32_dict = ((|

  compare_method = (genericCompare word_sless (=)),

  isLess_method = word_sless,

  isLessEqual_method = word_sle,

  isGreater_method = (\<lambda> x y. word_sless y x),

  isGreaterEqual_method = (\<lambda> x y. word_sle y x)|) )"


\<comment> \<open>\<open>val int32Negate : int32 -> int32\<close>\<close>

definition instance_Num_NumNegate_Num_int32_dict  :: "( 32 word)NumNegate_class "  where 
     " instance_Num_NumNegate_Num_int32_dict = ((|

  numNegate_method = (\<lambda> i. - i)|) )"


\<comment> \<open>\<open>val int32Abs : int32 -> int32\<close>\<close>
definition int32Abs  :: " 32 word \<Rightarrow> 32 word "  where 
     " int32Abs i = ( (if word_sle(((word_of_int 0) ::  32 word)) i then i else - i))"


definition instance_Num_NumAbs_Num_int32_dict  :: "( 32 word)NumAbs_class "  where 
     " instance_Num_NumAbs_Num_int32_dict = ((|

  abs_method = int32Abs |) )"



\<comment> \<open>\<open>val int32Add : int32 -> int32 -> int32\<close>\<close>

definition instance_Num_NumAdd_Num_int32_dict  :: "( 32 word)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_int32_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val int32Minus : int32 -> int32 -> int32\<close>\<close>

definition instance_Num_NumMinus_Num_int32_dict  :: "( 32 word)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_int32_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val int32Succ : int32 -> int32\<close>\<close>

definition instance_Num_NumSucc_Num_int32_dict  :: "( 32 word)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_int32_dict = ((|

  succ_method = (\<lambda> n. n +((word_of_int 1) ::  32 word))|) )"


\<comment> \<open>\<open>val int32Pred : int32 -> int32\<close>\<close>
definition instance_Num_NumPred_Num_int32_dict  :: "( 32 word)NumPred_class "  where 
     " instance_Num_NumPred_Num_int32_dict = ((|

  pred_method = (\<lambda> n. n -((word_of_int 1) ::  32 word))|) )"


\<comment> \<open>\<open>val int32Mult : int32 -> int32 -> int32\<close>\<close>

definition instance_Num_NumMult_Num_int32_dict  :: "( 32 word)NumMult_class "  where 
     " instance_Num_NumMult_Num_int32_dict = ((|

  numMult_method = (*)|) )"



\<comment> \<open>\<open>val int32Pow : int32 -> nat -> int32\<close>\<close>

definition instance_Num_NumPow_Num_int32_dict  :: "( 32 word)NumPow_class "  where 
     " instance_Num_NumPow_Num_int32_dict = ((|

  numPow_method = (^)|) )"


\<comment> \<open>\<open>val int32Div : int32 -> int32 -> int32\<close>\<close>

definition instance_Num_NumIntegerDivision_Num_int32_dict  :: "( 32 word)NumIntegerDivision_class "  where 
     " instance_Num_NumIntegerDivision_Num_int32_dict = ((|

  div_method = (div)|) )"


definition instance_Num_NumDivision_Num_int32_dict  :: "( 32 word)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_int32_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val int32Mod : int32 -> int32 -> int32\<close>\<close>

definition instance_Num_NumRemainder_Num_int32_dict  :: "( 32 word)NumRemainder_class "  where 
     " instance_Num_NumRemainder_Num_int32_dict = ((|

  mod_method = (mod)|) )"


\<comment> \<open>\<open>val int32Min : int32 -> int32 -> int32\<close>\<close>

\<comment> \<open>\<open>val int32Max : int32 -> int32 -> int32\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_int32_dict  :: "( 32 word)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_int32_dict = ((|

  max_method = ((\<lambda> x y. if (word_sle y x) then x else y)),

  min_method = ((\<lambda> x y. if (word_sle x y) then x else y))|) )"




\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> int64                   \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open>val int64FromNumeral : numeral -> int64\<close>\<close>

\<comment> \<open>\<open>val int64Eq : int64 -> int64 -> bool\<close>\<close>

\<comment> \<open>\<open>val int64Less : int64 -> int64 -> bool\<close>\<close>
\<comment> \<open>\<open>val int64LessEqual : int64 -> int64 -> bool\<close>\<close>
\<comment> \<open>\<open>val int64Greater : int64 -> int64 -> bool\<close>\<close>
\<comment> \<open>\<open>val int64GreaterEqual : int64 -> int64 -> bool\<close>\<close>

\<comment> \<open>\<open>val int64Compare : int64 -> int64 -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_int64_dict  :: "( 64 word)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_int64_dict = ((|

  compare_method = (genericCompare word_sless (=)),

  isLess_method = word_sless,

  isLessEqual_method = word_sle,

  isGreater_method = (\<lambda> x y. word_sless y x),

  isGreaterEqual_method = (\<lambda> x y. word_sle y x)|) )"


\<comment> \<open>\<open>val int64Negate : int64 -> int64\<close>\<close>

definition instance_Num_NumNegate_Num_int64_dict  :: "( 64 word)NumNegate_class "  where 
     " instance_Num_NumNegate_Num_int64_dict = ((|

  numNegate_method = (\<lambda> i. - i)|) )"


\<comment> \<open>\<open>val int64Abs : int64 -> int64\<close>\<close>
definition int64Abs  :: " 64 word \<Rightarrow> 64 word "  where 
     " int64Abs i = ( (if word_sle(((word_of_int 0) ::  64 word)) i then i else - i))"


definition instance_Num_NumAbs_Num_int64_dict  :: "( 64 word)NumAbs_class "  where 
     " instance_Num_NumAbs_Num_int64_dict = ((|

  abs_method = int64Abs |) )"



\<comment> \<open>\<open>val int64Add : int64 -> int64 -> int64\<close>\<close>

definition instance_Num_NumAdd_Num_int64_dict  :: "( 64 word)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_int64_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val int64Minus : int64 -> int64 -> int64\<close>\<close>

definition instance_Num_NumMinus_Num_int64_dict  :: "( 64 word)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_int64_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val int64Succ : int64 -> int64\<close>\<close>

definition instance_Num_NumSucc_Num_int64_dict  :: "( 64 word)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_int64_dict = ((|

  succ_method = (\<lambda> n. n +((word_of_int 1) ::  64 word))|) )"


\<comment> \<open>\<open>val int64Pred : int64 -> int64\<close>\<close>
definition instance_Num_NumPred_Num_int64_dict  :: "( 64 word)NumPred_class "  where 
     " instance_Num_NumPred_Num_int64_dict = ((|

  pred_method = (\<lambda> n. n -((word_of_int 1) ::  64 word))|) )"


\<comment> \<open>\<open>val int64Mult : int64 -> int64 -> int64\<close>\<close>

definition instance_Num_NumMult_Num_int64_dict  :: "( 64 word)NumMult_class "  where 
     " instance_Num_NumMult_Num_int64_dict = ((|

  numMult_method = (*)|) )"



\<comment> \<open>\<open>val int64Pow : int64 -> nat -> int64\<close>\<close>

definition instance_Num_NumPow_Num_int64_dict  :: "( 64 word)NumPow_class "  where 
     " instance_Num_NumPow_Num_int64_dict = ((|

  numPow_method = (^)|) )"


\<comment> \<open>\<open>val int64Div : int64 -> int64 -> int64\<close>\<close>

definition instance_Num_NumIntegerDivision_Num_int64_dict  :: "( 64 word)NumIntegerDivision_class "  where 
     " instance_Num_NumIntegerDivision_Num_int64_dict = ((|

  div_method = (div)|) )"


definition instance_Num_NumDivision_Num_int64_dict  :: "( 64 word)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_int64_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val int64Mod : int64 -> int64 -> int64\<close>\<close>

definition instance_Num_NumRemainder_Num_int64_dict  :: "( 64 word)NumRemainder_class "  where 
     " instance_Num_NumRemainder_Num_int64_dict = ((|

  mod_method = (mod)|) )"


\<comment> \<open>\<open>val int64Min : int64 -> int64 -> int64\<close>\<close>

\<comment> \<open>\<open>val int64Max : int64 -> int64 -> int64\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_int64_dict  :: "( 64 word)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_int64_dict = ((|

  max_method = ((\<lambda> x y. if (word_sle y x) then x else y)),

  min_method = ((\<lambda> x y. if (word_sle x y) then x else y))|) )"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> integer                 \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val integerFromNumeral : numeral -> integer\<close>\<close>

\<comment> \<open>\<open>val integerFromNat : nat -> integer\<close>\<close> \<comment> \<open>\<open> TODO: check \<close>\<close>

\<comment> \<open>\<open>val integerEq : integer -> integer -> bool\<close>\<close>

\<comment> \<open>\<open>val integerLess : integer -> integer -> bool\<close>\<close>
\<comment> \<open>\<open>val integerLessEqual : integer -> integer -> bool\<close>\<close>
\<comment> \<open>\<open>val integerGreater : integer -> integer -> bool\<close>\<close>
\<comment> \<open>\<open>val integerGreaterEqual : integer -> integer -> bool\<close>\<close>

\<comment> \<open>\<open>val integerCompare : integer -> integer -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_integer_dict  :: "(int)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_integer_dict = ((|

  compare_method = (genericCompare (<) (=)),

  isLess_method = (<),

  isLessEqual_method = (\<le>),

  isGreater_method = (>),

  isGreaterEqual_method = (\<ge>)|) )"


\<comment> \<open>\<open>val integerNegate : integer -> integer\<close>\<close>

definition instance_Num_NumNegate_Num_integer_dict  :: "(int)NumNegate_class "  where 
     " instance_Num_NumNegate_Num_integer_dict = ((|

  numNegate_method = (\<lambda> i. - i)|) )"


\<comment> \<open>\<open>val integerAbs : integer -> integer\<close>\<close> \<comment> \<open>\<open> TODO: check \<close>\<close>

definition instance_Num_NumAbs_Num_integer_dict  :: "(int)NumAbs_class "  where 
     " instance_Num_NumAbs_Num_integer_dict = ((|

  abs_method = abs |) )"


\<comment> \<open>\<open>val integerAdd : integer -> integer -> integer\<close>\<close>

definition instance_Num_NumAdd_Num_integer_dict  :: "(int)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_integer_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val integerMinus : integer -> integer -> integer\<close>\<close>

definition instance_Num_NumMinus_Num_integer_dict  :: "(int)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_integer_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val integerSucc : integer -> integer\<close>\<close>
definition instance_Num_NumSucc_Num_integer_dict  :: "(int)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_integer_dict = ((|

  succ_method = (\<lambda> n. n +( 1 :: int))|) )"


\<comment> \<open>\<open>val integerPred : integer -> integer\<close>\<close>
definition instance_Num_NumPred_Num_integer_dict  :: "(int)NumPred_class "  where 
     " instance_Num_NumPred_Num_integer_dict = ((|

  pred_method = (\<lambda> n. n -( 1 :: int))|) )"


\<comment> \<open>\<open>val integerMult : integer -> integer -> integer\<close>\<close>

definition instance_Num_NumMult_Num_integer_dict  :: "(int)NumMult_class "  where 
     " instance_Num_NumMult_Num_integer_dict = ((|

  numMult_method = (*)|) )"



\<comment> \<open>\<open>val integerPow : integer -> nat -> integer\<close>\<close>

definition instance_Num_NumPow_Num_integer_dict  :: "(int)NumPow_class "  where 
     " instance_Num_NumPow_Num_integer_dict = ((|

  numPow_method = (^)|) )"


\<comment> \<open>\<open>val integerDiv : integer -> integer -> integer\<close>\<close>

definition instance_Num_NumIntegerDivision_Num_integer_dict  :: "(int)NumIntegerDivision_class "  where 
     " instance_Num_NumIntegerDivision_Num_integer_dict = ((|

  div_method = (div)|) )"


definition instance_Num_NumDivision_Num_integer_dict  :: "(int)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_integer_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val integerMod : integer -> integer -> integer\<close>\<close>

definition instance_Num_NumRemainder_Num_integer_dict  :: "(int)NumRemainder_class "  where 
     " instance_Num_NumRemainder_Num_integer_dict = ((|

  mod_method = (mod)|) )"


\<comment> \<open>\<open>val integerMin : integer -> integer -> integer\<close>\<close>

\<comment> \<open>\<open>val integerMax : integer -> integer -> integer\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_integer_dict  :: "(int)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_integer_dict = ((|

  max_method = max,

  min_method = min |) )"




\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> rational                \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val rationalFromNumeral : numeral -> rational\<close>\<close>

\<comment> \<open>\<open>val rationalFromInt : int -> rational\<close>\<close>

\<comment> \<open>\<open>val rationalFromInteger : integer -> rational\<close>\<close>

\<comment> \<open>\<open>val rationalEq : rational -> rational -> bool\<close>\<close>

\<comment> \<open>\<open>val rationalLess : rational -> rational -> bool\<close>\<close>
\<comment> \<open>\<open>val rationalLessEqual : rational -> rational -> bool\<close>\<close>
\<comment> \<open>\<open>val rationalGreater : rational -> rational -> bool\<close>\<close>
\<comment> \<open>\<open>val rationalGreaterEqual : rational -> rational -> bool\<close>\<close>

\<comment> \<open>\<open>val rationalCompare : rational -> rational -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_rational_dict  :: "(rat)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_rational_dict = ((|

  compare_method = (genericCompare (<) (=)),

  isLess_method = (<),

  isLessEqual_method = (\<le>),

  isGreater_method = (>),

  isGreaterEqual_method = (\<ge>)|) )"


\<comment> \<open>\<open>val rationalAdd : rational -> rational -> rational\<close>\<close>

definition instance_Num_NumAdd_Num_rational_dict  :: "(rat)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_rational_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val rationalMinus : rational -> rational -> rational\<close>\<close>

definition instance_Num_NumMinus_Num_rational_dict  :: "(rat)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_rational_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val rationalNegate : rational -> rational\<close>\<close>

definition instance_Num_NumNegate_Num_rational_dict  :: "(rat)NumNegate_class "  where 
     " instance_Num_NumNegate_Num_rational_dict = ((|

  numNegate_method = (\<lambda> i. - i)|) )"


\<comment> \<open>\<open>val rationalAbs : rational -> rational\<close>\<close>

definition instance_Num_NumAbs_Num_rational_dict  :: "(rat)NumAbs_class "  where 
     " instance_Num_NumAbs_Num_rational_dict = ((|

  abs_method = abs |) )"


\<comment> \<open>\<open>val rationalSucc : rational -> rational\<close>\<close>
definition instance_Num_NumSucc_Num_rational_dict  :: "(rat)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_rational_dict = ((|

  succ_method = (\<lambda> n. n +(Fract ( 1 :: int) (1 :: int)))|) )"


\<comment> \<open>\<open>val rationalPred : rational -> rational\<close>\<close>
definition instance_Num_NumPred_Num_rational_dict  :: "(rat)NumPred_class "  where 
     " instance_Num_NumPred_Num_rational_dict = ((|

  pred_method = (\<lambda> n. n -(Fract ( 1 :: int) (1 :: int)))|) )"


\<comment> \<open>\<open>val rationalMult : rational -> rational -> rational\<close>\<close>

definition instance_Num_NumMult_Num_rational_dict  :: "(rat)NumMult_class "  where 
     " instance_Num_NumMult_Num_rational_dict = ((|

  numMult_method = (*)|) )"


\<comment> \<open>\<open>val rationalDiv : rational -> rational -> rational\<close>\<close>

definition instance_Num_NumDivision_Num_rational_dict  :: "(rat)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_rational_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val rationalFromFrac : int -> int -> rational\<close>\<close>
\<comment> \<open>\<open>let rationalFromFrac n d=  (Instance_Num_NumDivision_Num_rational./) (rationalFromInt n) (rationalFromInt d)\<close>\<close>

\<comment> \<open>\<open>val rationalNumerator : rational -> integer\<close>\<close>  \<comment> \<open>\<open> TODO: test \<close>\<close>

\<comment> \<open>\<open>val rationalDenominator : rational -> integer\<close>\<close>  \<comment> \<open>\<open> TODO: test \<close>\<close>

\<comment> \<open>\<open>val rationalPowInteger : rational -> integer -> rational\<close>\<close>
fun  rationalPowInteger  :: " rat \<Rightarrow> int \<Rightarrow> rat "  where 
     " rationalPowInteger b e = (
  if e =( 0 :: int) then(Fract ( 1 :: int) (1 :: int)) else
  if e >( 0 :: int) then rationalPowInteger b (e -( 1 :: int)) * b else
  rationalPowInteger b (e +( 1 :: int)) div b )"


\<comment> \<open>\<open>val rationalPowNat : rational -> nat -> rational\<close>\<close>
\<comment> \<open>\<open>let rationalPowNat r e=  rationalPowInteger r (integerFromNat e)\<close>\<close>

definition instance_Num_NumPow_Num_rational_dict  :: "(rat)NumPow_class "  where 
     " instance_Num_NumPow_Num_rational_dict = ((|

  numPow_method = power |) )"


\<comment> \<open>\<open>val rationalMin : rational -> rational -> rational\<close>\<close>

\<comment> \<open>\<open>val rationalMax : rational -> rational -> rational\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_rational_dict  :: "(rat)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_rational_dict = ((|

  max_method = max,

  min_method = min |) )"




\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> real                    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val realFromNumeral : numeral -> real\<close>\<close>

\<comment> \<open>\<open>val realFromInteger : integer -> real\<close>\<close>

\<comment> \<open>\<open>val realEq : real -> real -> bool\<close>\<close>

\<comment> \<open>\<open>val realLess : real -> real -> bool\<close>\<close>
\<comment> \<open>\<open>val realLessEqual : real -> real -> bool\<close>\<close>
\<comment> \<open>\<open>val realGreater : real -> real -> bool\<close>\<close>
\<comment> \<open>\<open>val realGreaterEqual : real -> real -> bool\<close>\<close>

\<comment> \<open>\<open>val realCompare : real -> real -> ordering\<close>\<close>

definition instance_Basic_classes_Ord_Num_real_dict  :: "(real)Ord_class "  where 
     " instance_Basic_classes_Ord_Num_real_dict = ((|

  compare_method = (genericCompare (<) (=)),

  isLess_method = (<),

  isLessEqual_method = (\<le>),

  isGreater_method = (>),

  isGreaterEqual_method = (\<ge>)|) )"


\<comment> \<open>\<open>val realAdd : real -> real -> real\<close>\<close>

definition instance_Num_NumAdd_Num_real_dict  :: "(real)NumAdd_class "  where 
     " instance_Num_NumAdd_Num_real_dict = ((|

  numAdd_method = (+)|) )"


\<comment> \<open>\<open>val realMinus : real -> real -> real\<close>\<close>

definition instance_Num_NumMinus_Num_real_dict  :: "(real)NumMinus_class "  where 
     " instance_Num_NumMinus_Num_real_dict = ((|

  numMinus_method = (-)|) )"


\<comment> \<open>\<open>val realNegate : real -> real\<close>\<close>

definition instance_Num_NumNegate_Num_real_dict  :: "(real)NumNegate_class "  where 
     " instance_Num_NumNegate_Num_real_dict = ((|

  numNegate_method = (\<lambda> i. - i)|) )"


\<comment> \<open>\<open>val realAbs : real -> real\<close>\<close>

definition instance_Num_NumAbs_Num_real_dict  :: "(real)NumAbs_class "  where 
     " instance_Num_NumAbs_Num_real_dict = ((|

  abs_method = abs |) )"


\<comment> \<open>\<open>val realSucc : real -> real\<close>\<close>
definition instance_Num_NumSucc_Num_real_dict  :: "(real)NumSucc_class "  where 
     " instance_Num_NumSucc_Num_real_dict = ((|

  succ_method = (\<lambda> n. n +( 1 :: real))|) )"


\<comment> \<open>\<open>val realPred : real -> real\<close>\<close>
definition instance_Num_NumPred_Num_real_dict  :: "(real)NumPred_class "  where 
     " instance_Num_NumPred_Num_real_dict = ((|

  pred_method = (\<lambda> n. n -( 1 :: real))|) )"


\<comment> \<open>\<open>val realMult : real -> real -> real\<close>\<close>

definition instance_Num_NumMult_Num_real_dict  :: "(real)NumMult_class "  where 
     " instance_Num_NumMult_Num_real_dict = ((|

  numMult_method = (*)|) )"


\<comment> \<open>\<open>val realDiv : real -> real -> real\<close>\<close>

definition instance_Num_NumDivision_Num_real_dict  :: "(real)NumDivision_class "  where 
     " instance_Num_NumDivision_Num_real_dict = ((|

  numDivision_method = (div)|) )"


\<comment> \<open>\<open>val realFromFrac : integer -> integer -> real\<close>\<close>
definition realFromFrac  :: " int \<Rightarrow> int \<Rightarrow> real "  where 
     " realFromFrac n d = ( ((real_of_int n)) div ((real_of_int d)))"


\<comment> \<open>\<open>val realPowInteger : real -> integer -> real\<close>\<close>
fun  realPowInteger  :: " real \<Rightarrow> int \<Rightarrow> real "  where 
     " realPowInteger b e = (
  if e =( 0 :: int) then( 1 :: real) else
  if e >( 0 :: int) then realPowInteger b (e -( 1 :: int)) * b else
  realPowInteger b (e +( 1 :: int)) div b )"


\<comment> \<open>\<open>val realPowNat : real -> nat -> real\<close>\<close>
\<comment> \<open>\<open>let realPowNat r e=  realPowInteger r (integerFromNat e)\<close>\<close>

definition instance_Num_NumPow_Num_real_dict  :: "(real)NumPow_class "  where 
     " instance_Num_NumPow_Num_real_dict = ((|

  numPow_method = power |) )"


\<comment> \<open>\<open>val realSqrt : real -> real\<close>\<close>

\<comment> \<open>\<open>val realMin : real -> real -> real\<close>\<close>

\<comment> \<open>\<open>val realMax : real -> real -> real\<close>\<close>

definition instance_Basic_classes_OrdMaxMin_Num_real_dict  :: "(real)OrdMaxMin_class "  where 
     " instance_Basic_classes_OrdMaxMin_Num_real_dict = ((|

  max_method = max,

  min_method = min |) )"


\<comment> \<open>\<open>val realCeiling : real -> integer\<close>\<close>

\<comment> \<open>\<open>val realFloor : real -> integer\<close>\<close>


\<comment> \<open>\<open>val integerSqrt : integer -> integer\<close>\<close>
definition integerSqrt  :: " int \<Rightarrow> int "  where 
     " integerSqrt i = ( floor (sqrt ((real_of_int i))))"


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Translation between number types                                           \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> integerFrom... \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val integerFromInt : int -> integer\<close>\<close>

\<comment> \<open>\<open>val integerFromNatural : natural -> integer\<close>\<close>


\<comment> \<open>\<open>val integerFromInt32 : int32 -> integer\<close>\<close>


\<comment> \<open>\<open>val integerFromInt64 : int64 -> integer\<close>\<close>


\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> naturalFrom... \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val naturalFromNat : nat -> natural\<close>\<close>

\<comment> \<open>\<open>val naturalFromInteger : integer -> natural\<close>\<close>


\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> intFrom ...    \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val intFromInteger : integer -> int\<close>\<close>

\<comment> \<open>\<open>val intFromNat : nat -> int\<close>\<close>


\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> natFrom ...    \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val natFromNatural : natural -> nat\<close>\<close>

\<comment> \<open>\<open>val natFromInt : int -> nat\<close>\<close>


\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> int32From ...  \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val int32FromNat : nat -> int32\<close>\<close>

\<comment> \<open>\<open>val int32FromNatural : natural -> int32\<close>\<close>

\<comment> \<open>\<open>val int32FromInteger : integer -> int32\<close>\<close>
\<comment> \<open>\<open>let int32FromInteger i=  (
  let abs_int32 = int32FromNatural (naturalFromInteger i) in
  if ((Instance_Basic_classes_Ord_Num_integer.<) i 0) then (Instance_Num_NumNegate_Num_int32.~ abs_int32) else abs_int32 
)\<close>\<close>

\<comment> \<open>\<open>val int32FromInt : int -> int32\<close>\<close>
\<comment> \<open>\<open>let int32FromInt i=  int32FromInteger (integerFromInt i)\<close>\<close>


\<comment> \<open>\<open>val int32FromInt64 : int64 -> int32\<close>\<close>
\<comment> \<open>\<open>let int32FromInt64 i=  int32FromInteger (integerFromInt64 i)\<close>\<close>




\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> int64From ...  \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val int64FromNat : nat -> int64\<close>\<close>

\<comment> \<open>\<open>val int64FromNatural : natural -> int64\<close>\<close>

\<comment> \<open>\<open>val int64FromInteger : integer -> int64\<close>\<close>
\<comment> \<open>\<open>let int64FromInteger i=  (
  let abs_int64 = int64FromNatural (naturalFromInteger i) in
  if ((Instance_Basic_classes_Ord_Num_integer.<) i 0) then (Instance_Num_NumNegate_Num_int64.~ abs_int64) else abs_int64 
)\<close>\<close>

\<comment> \<open>\<open>val int64FromInt : int -> int64\<close>\<close>
\<comment> \<open>\<open>let int64FromInt i=  int64FromInteger (integerFromInt i)\<close>\<close>


\<comment> \<open>\<open>val int64FromInt32 : int32 -> int64\<close>\<close>
\<comment> \<open>\<open>let int64FromInt32 i=  int64FromInteger (integerFromInt32 i)\<close>\<close>


\<comment> \<open>\<open>****************\<close>\<close>
\<comment> \<open>\<open> what's missing \<close>\<close>
\<comment> \<open>\<open>****************\<close>\<close>

\<comment> \<open>\<open>val naturalFromInt : int -> natural\<close>\<close>
\<comment> \<open>\<open>val naturalFromInt32 : int32 -> natural\<close>\<close>
\<comment> \<open>\<open>val naturalFromInt64 : int64 -> natural\<close>\<close>


\<comment> \<open>\<open>val intFromNatural : natural -> int\<close>\<close>
\<comment> \<open>\<open>val intFromInt32 : int32 -> int\<close>\<close>
\<comment> \<open>\<open>val intFromInt64 : int64 -> int\<close>\<close>

\<comment> \<open>\<open>val natFromInteger : integer -> nat\<close>\<close>
\<comment> \<open>\<open>val natFromInt32 : int32 -> nat\<close>\<close>
\<comment> \<open>\<open>val natFromInt64 : int64 -> nat\<close>\<close>
end
