chapter \<open>Generated by Lem from \<open>map_extra.lem\<close>.\<close>

theory "Lem_map_extra" 

imports
  Main
  "Lem_bool"
  "Lem_basic_classes"
  "Lem_function"
  "Lem_assert_extra"
  "Lem_maybe"
  "Lem_list"
  "Lem_num"
  "Lem_set"
  "Lem_map"

begin 



\<comment> \<open>\<open>open import Bool Basic_classes Function Assert_extra Maybe List Num Set Map\<close>\<close>

\<comment> \<open>\<open> -------------------------------------------------------------------------- \<close>\<close>
\<comment> \<open>\<open> find                                                                       \<close>\<close>
\<comment> \<open>\<open> -------------------------------------------------------------------------- \<close>\<close>

\<comment> \<open>\<open>val find : forall 'k 'v. MapKeyType 'k => 'k -> map 'k 'v -> 'v\<close>\<close>
\<comment> \<open>\<open>let find k m=  match (lookup k m) with Just x -> x | Nothing -> failwith "Map_extra.find" end\<close>\<close>



\<comment> \<open>\<open> -------------------------------------------------------------------------- \<close>\<close>
\<comment> \<open>\<open> from sets / domain / range                                                 \<close>\<close>
\<comment> \<open>\<open> -------------------------------------------------------------------------- \<close>\<close>


\<comment> \<open>\<open>val fromSet : forall 'k 'v. MapKeyType 'k => ('k -> 'v) -> set 'k -> map 'k 'v\<close>\<close>
definition fromSet  :: "('k \<Rightarrow> 'v)\<Rightarrow> 'k set \<Rightarrow>('k,'v)Map.map "  where 
     " fromSet f s = ( Finite_Set.fold (\<lambda> k m .  map_update k (f k) m) Map.empty s )"


\<comment> \<open>\<open>
assert fromSet_0: (fromSet succ (Set.empty : set nat) = Map.empty)
assert fromSet_1: (fromSet succ {(2:nat); 3; 4}) = Map.fromList [(2,3); (3, 4); (4, 5)]
\<close>\<close>

\<comment> \<open>\<open> -------------------------------------------------------------------------- \<close>\<close>
\<comment> \<open>\<open> fold                                                                       \<close>\<close>
\<comment> \<open>\<open> -------------------------------------------------------------------------- \<close>\<close>

\<comment> \<open>\<open>val fold : forall 'k 'v 'r. MapKeyType 'k, SetType 'k, SetType 'v => ('k -> 'v -> 'r -> 'r) -> map 'k 'v -> 'r -> 'r\<close>\<close>
definition fold  :: "('k \<Rightarrow> 'v \<Rightarrow> 'r \<Rightarrow> 'r)\<Rightarrow>('k,'v)Map.map \<Rightarrow> 'r \<Rightarrow> 'r "  where 
     " fold f m v = ( Finite_Set.fold ( \<lambda>x .  
  (case  x of (k, v) => \<lambda> r .  f k v r )) v (map_to_set m))"


\<comment> \<open>\<open>
assert fold_1: (fold (fun k v a -> (a+k)) (Map.fromList [((2:nat),(3:nat)); (3, 4); (4, 5)]) 0 = 9)
assert fold_2: (fold (fun k v a -> (a+v)) (Map.fromList [((2:nat),(3:nat)); (3, 4); (4, 5)]) 0 = 12)
\<close>\<close>

\<comment> \<open>\<open>val toList: forall 'k 'v. MapKeyType 'k => map 'k 'v -> list ('k * 'v)\<close>\<close>
\<comment> \<open>\<open> declare compile_message toList = "Map_extra.toList is only defined for the ocaml, isabelle and coq backend" \<close>\<close>

\<comment> \<open>\<open> more 'map' functions \<close>\<close>

\<comment> \<open>\<open> TODO: this function is in map_extra rather than map just for implementation reasons \<close>\<close>
\<comment> \<open>\<open>val mapMaybe : forall 'a 'b 'c. MapKeyType 'a => ('a -> 'b -> maybe 'c) -> map 'a 'b -> map 'a 'c\<close>\<close>
\<comment> \<open>\<open> OLD: TODO: mapMaybe depends on toList that is not defined for hol and isabelle \<close>\<close>
definition option_map  :: "('a \<Rightarrow> 'b \<Rightarrow> 'c option)\<Rightarrow>('a,'b)Map.map \<Rightarrow>('a,'c)Map.map "  where 
     " option_map f m = (
  List.foldl
    (\<lambda> m' .  \<lambda>x .  
  (case  x of
      (k, v) =>
  (case  f k v of   None => m' | Some v' => map_update k v' m' )
  ))
    Map.empty
    (list_of_set (LemExtraDefs.map_to_set m)))"


end
