(*  Title:        Notions of Communication for C2KA
    Author:       Maxime Buyse <maxime.buyse at polytechnique.edu>, 2019
    Maintainers:  Maxime Buyse <maxime.buyse at polytechnique.edu> and Jason Jaskolka <jason.jaskolka at carleton.ca>
*)

section \<open>Notions of Communication for \CCKAabbrv \label{sec:communication}\<close>

text \<open>
Distributed systems contain a significant number of interactions among their constituent agents. Any interaction, 
direct or indirect, of an agent with its neighbouring agents can be understood as a \emph{communication}~\<^cite>\<open>"Milner1989aa"\<close>. 
Therefore, any potential for communication between two system agents can be characterized by the existence of a communication 
path allowing for the transfer of data or control from one agent to another. Potential for communication allows system
agents to have an \emph{influence} over each other. The study of agent influence allows for the 
determination of the overall structure of the distributed system of which the agents comprise. A full treatment of the potential 
for communication within distributed systems specified using \CCKAabbrv has been given in~\<^cite>\<open>"Jaskolka2015ab"\<close> 
and~\<^cite>\<open>"Jaskolka2014ac"\<close> and is highlighted below.

Consider a distributed system with~$\Agent{A}, \Agent{B} \in \A$ such that~$\Agent{A} \neq \Agent{B}$. We write~$\agent{A}{a}$ 
where~$\Agent{A}$ is the name given to the agent and~$a \in \CKAset$ is the agent behaviour. For~$\agent{A}{a}$ and~$\agent{B}{b}$, 
we write~$\Agent{A+B}$ to denote the agent~$\bigA{a+b}$. In a sense, we extend the operators on behaviours of~$\CKAset$ to their 
corresponding agents. 

Communication via stimuli from agent~$\Agent{A}$ to agent~$\Agent{B}$ is said to have taken place only when 
a stimulus generated by~$\Agent{A}$ \emph{influences} (i.e., causes an observable change in, directly or indirectly) the behaviour 
of~$\Agent{B}$. Note that it is possible that more than one agent is influenced by the generation of the same stimulus by another 
agent in the system. Formally, we say that agent~$\agent{A}{a}$ has the \emph{potential for direct communication via stimuli} with 
agent~$\agent{B}{b}$ (denoted by~$\STIMcommD{\Agent{A}}{\Agent{B}}$) if and only 
if~$\biglnotation{\exists}{s,t}{s,t \in \STIMbasic \nAnd t \STIMle \lOut{a}{s} }{\lAct{b}{t} \neq b}$ where~$\STIMbasic$ is the 
set of all basic stimuli. A stimulus is called \emph{basic} if it is indivisible with regard to the sequential composition 
operator~$\STIMdot$ of a stimulus structure. Similarly, we say that agent~$\Agent{A}$ has the \emph{potential for communication 
via stimuli with agent~$\Agent{B}$ using at most~$n$ basic stimuli} (denoted by~$\STIMcommN{\Agent{A}}{\Agent{B}}{n}$) if and only 
if~$\biglnotation{\exists}{\Agent{C}}{\Agent{C} \in \A \nAnd \Agent{C} \neq \Agent{A} \nAnd \Agent{C} \neq \Agent{B}}{\STIMcommN{\Agent{A}}{\Agent{C}}{(n-1)} \nAnd \STIMcommD{\Agent{C}}{\Agent{B}}}$. 
More generally, we say that agent~$\Agent{A}$ has the \emph{potential for communication via stimuli} with agent~$\Agent{B}$ 
(denoted by~$\STIMcomm{\Agent{A}}{\Agent{B}}$) if and only if~$\biglnotation{\exists}{n}{n \ge 1}{\STIMcommN{\Agent{A}}{\Agent{B}}{n}}$. 
When~$\STIMcomm{\Agent{A}}{\Agent{B}}$, there is a sequence of stimuli of arbitrary length which allows for the transfer of data or 
control from agent~$\Agent{A}$ to agent~$\Agent{B}$ in the system. To simplify the Isabelle theory, we do not implement 
the potential for communication using at most~$n$ basic stimuli. Instead, we give the definition of potential for direct communication 
via stimuli and the fact that~$\STIMcommD{\Agent{A}}{\Agent{B}} \Longrightarrow \STIMcomm{\Agent{A}}{\Agent{B}}$ as axioms because 
these are the only properties that we use about potential for communication via stimuli.

Communication via shared environments from agent~$\Agent{A}$ to agent~$\Agent{B}$ (denoted by~$\ENVcomm{\Agent{A}}{\Agent{B}}$) is 
said to have taken place only when~$\Agent{A}$ has the ability to alter an element of the environment that it shares with~$\Agent{B}$ 
such that~$\Agent{B}$ is able to observe the alteration that was made. Formally, we say that agent~$\agent{A}{a}$ has the 
\emph{potential for direct communication via shared environments} with agent~$\agent{B}{b}$ (denoted by~$\ENVcommD{\Agent{A}}{\Agent{B}}$) 
if and only if~$\dep{b}{a}$ where~$\depOp$ is a given dependence relation. More generally, agent~$\Agent{A}$ has the 
\emph{potential for communication via shared environments} with agent~$\Agent{B}$ (denoted by~$\ENVcomm{\Agent{A}}{\Agent{B}}$) if and 
only if~$\depTC{b}{a}$ where~$\depOpTC$ is the transitive closure of the given dependence relation. This means that if two agents respect 
the given dependence relation, then there is a potential for communication via shared environments.
\<close>

theory Communication_C2KA
  imports Topology_C2KA
begin

text \<open>
The locale \emph{communication-c2ka} extends \emph{topology-c2ka} to include aspects of potential for communication 
among distributed system agents.
\<close>

locale communication_c2ka = topology_c2ka +
  fixes dcs :: "'a::cka \<Rightarrow> 'a::cka \<Rightarrow> bool" (infix \<open>\<rightarrow>\<^sub>\<S>\<close> 50)
  and pcs :: "'a::cka \<Rightarrow> 'a::cka \<Rightarrow> bool" (infix \<open>\<rightarrow>\<^sub>\<S>\<^sup>+\<close> 50)
  and dce :: "'a::cka \<Rightarrow> 'a::cka \<Rightarrow> bool" (infix \<open>\<rightarrow>\<^sub>\<E>\<close> 50)
  and pce :: "'a::cka \<Rightarrow> 'a::cka \<Rightarrow> bool" (infix \<open>\<rightarrow>\<^sub>\<E>\<^sup>+\<close> 50)
  and pdc :: "'a::cka \<Rightarrow> 'a::cka \<Rightarrow> bool" (infix \<open>\<leadsto>\<close> 50)
  and pfc :: "'a::cka \<Rightarrow> 'a::cka \<Rightarrow> bool" (infix \<open>\<leadsto>\<^sup>+\<close> 50)
  and stimuli_connected :: "'a set \<Rightarrow> bool"
  and universally_influential :: "'a::cka \<times> 'a set \<Rightarrow> bool"
  assumes dcs_def: "a \<rightarrow>\<^sub>\<S> b \<longleftrightarrow> 
  (\<exists> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,a) \<and> t \<circ> b \<noteq> b)"
  and pdc_def: "a \<leadsto> b \<longleftrightarrow> (a \<rightarrow>\<^sub>\<S> b \<or> a \<rightarrow>\<^sub>\<E> b)"
  and zero_dce: "\<not>(0 \<rightarrow>\<^sub>\<E> a)"
  and one_dce: "\<not>(1 \<rightarrow>\<^sub>\<E> a)"
  and dce_zero: "\<not>(a \<rightarrow>\<^sub>\<E> 0)"
  and dce_one: "\<not>(a \<rightarrow>\<^sub>\<E> 1)"
  and sum_dce: "(A + B \<rightarrow>\<^sub>\<E> C) \<longleftrightarrow> (A \<rightarrow>\<^sub>\<E> C \<or> B \<rightarrow>\<^sub>\<E> C)"
  and dce_sum: "(A \<rightarrow>\<^sub>\<E> B + C) \<longleftrightarrow> (A \<rightarrow>\<^sub>\<E> B \<or> A \<rightarrow>\<^sub>\<E> C)"
  and dcs_pcs: "A \<rightarrow>\<^sub>\<S> B \<Longrightarrow> A \<rightarrow>\<^sub>\<S>\<^sup>+ B"
  and stimuli_connected_def: "stimuli_connected(\<C>) \<longleftrightarrow> 
(\<forall> X\<^sub>1 X\<^sub>2. X\<^sub>1 \<inter> X\<^sub>2 = {} \<and> X\<^sub>1 \<union> X\<^sub>2 = \<C> \<and> X\<^sub>1 \<noteq> {} \<and> X\<^sub>2 \<noteq> {} \<longrightarrow> 
(\<exists> A B. A \<in> X\<^sub>1 \<and> B \<in> X\<^sub>2 \<and> (A \<rightarrow>\<^sub>\<S>\<^sup>+ B \<or> B \<rightarrow>\<^sub>\<S>\<^sup>+ A)))"
  and universally_influential_def: "universally_influential(A,\<C>) \<longleftrightarrow>
A \<in> \<C> \<and> (\<forall> B. B \<in> \<C> \<and> B \<noteq> A \<longrightarrow> A \<rightarrow>\<^sub>\<S>\<^sup>+ B)"
begin

subsection \<open>Stimuli-Connected Systems \& Universally Influential Agents \label{sub:stimuli_connected_universally_influential}\<close>

text \<open>
Two subsets~$X_1$ and~$X_2$ of~$\A$ form a partition of~$\A$ if and only if~$X_1 \cap X_2 = \STbot$ and~$X_1 \cup X_2 = \A$. A distributed system 
of agents~$\A$ is called \emph{stimuli-connected} if and only if for every~$X_1$ and~$X_2$ nonempty that form a partition of~$\A$, we 
have~$\lnotation{\exists}{\Agent{A},\Agent{B}}{\Agent{A} \in X_1 \nAnd \Agent{B} \in X_2}{\STIMcomm{\Agent{A}}{\Agent{B}} \Ors \STIMcomm{\Agent{B}}{\Agent{A}}}$. 
Otherwise,~$\A$ is called \emph{stimuli-disconnected}. In a stimuli-connected system, every agent is a participant, either as the source or sink, 
of at least one direct communication via stimuli.
\<close>

text \<open>
An agent~$\Agent{A} \in \A$ is called \emph{universally influential} if and only 
if~$\biglnotation{\forall}{\Agent{B}}{\Agent{B} \in \A \STdiff \set{\Agent{A}}}{\STIMcomm{\Agent{A}}{\Agent{B}}}$. 
A universally influential agent is able to generate some stimuli that influences the behaviour, either directly or 
indirectly, of each other agent in the system. 
\<close>

text \<open>
Lemma \emph{universally-influential-stimuli-connected} shows that the existence of a universally influential agent yields a stimuli-connected system. 
\<close>

lemma universally_influential_stimuli_connected: 
"(\<exists> A. universally_influential(A,\<C>)) \<longrightarrow> stimuli_connected(\<C>)"
  unfolding universally_influential_def stimuli_connected_def
proof (intro allI impI)
  fix X\<^sub>1 X\<^sub>2
  show "(\<exists>A. A \<in> \<C> \<and> (\<forall>B. B \<in> \<C> \<and> B \<noteq> A \<longrightarrow> A \<rightarrow>\<^sub>\<S>\<^sup>+ B)) \<Longrightarrow>
X\<^sub>1 \<inter> X\<^sub>2 = {} \<and> X\<^sub>1 \<union> X\<^sub>2 = \<C> \<and> X\<^sub>1 \<noteq> {} \<and> X\<^sub>2 \<noteq> {} \<Longrightarrow> 
(\<exists> A B. A \<in> X\<^sub>1 \<and> B \<in> X\<^sub>2 \<and> (A \<rightarrow>\<^sub>\<S>\<^sup>+ B \<or> B \<rightarrow>\<^sub>\<S>\<^sup>+ A))"
  proof -
    assume "(\<exists>A. A \<in> \<C> \<and> (\<forall>B. B \<in> \<C> \<and> B \<noteq> A \<longrightarrow> A \<rightarrow>\<^sub>\<S>\<^sup>+ B))"
    from this obtain A where Aui: "A \<in> \<C> \<and> (\<forall>B. B \<in> \<C> \<and> B \<noteq> A \<longrightarrow> 
A \<rightarrow>\<^sub>\<S>\<^sup>+ B)" by auto
    show "X\<^sub>1 \<inter> X\<^sub>2 = {} \<and> X\<^sub>1 \<union> X\<^sub>2 = \<C> \<and> X\<^sub>1 \<noteq> {} \<and> X\<^sub>2 \<noteq> {} \<Longrightarrow>
(\<exists>A B. A \<in> X\<^sub>1 \<and> B \<in> X\<^sub>2 \<and> (A \<rightarrow>\<^sub>\<S>\<^sup>+ B \<or> B \<rightarrow>\<^sub>\<S>\<^sup>+ A))"
    proof -
      assume partition:"X\<^sub>1 \<inter> X\<^sub>2 = {} \<and> X\<^sub>1 \<union> X\<^sub>2 = \<C> \<and> X\<^sub>1 \<noteq> {} \<and> X\<^sub>2 \<noteq> {}"
      show "(\<exists>A B. A \<in> X\<^sub>1 \<and> B \<in> X\<^sub>2 \<and> (A \<rightarrow>\<^sub>\<S>\<^sup>+ B \<or> B \<rightarrow>\<^sub>\<S>\<^sup>+ A))"
      proof cases 
        assume in1: "A \<in> X\<^sub>1"
        from partition obtain B where in2: "B \<in> X\<^sub>2" by auto
        have "A = B \<Longrightarrow> False"
        proof -
          assume "A = B"
          hence "A \<in> X\<^sub>2" by (simp add: in2)
          moreover have "A \<in> X\<^sub>1" by (rule in1)
          ultimately have "A \<in> X\<^sub>1 \<inter> X\<^sub>2" by simp
          hence "A \<in> {}" by (simp add: partition)
          thus "False" by simp
        qed
        hence "A \<noteq> B" by auto
        moreover have "B \<in> \<C>" 
        proof -
          from partition have "\<C> = X\<^sub>1 \<union> X\<^sub>2" by auto
          hence "X\<^sub>2 \<subseteq> \<C>" by simp
          thus ?thesis by (auto simp add: in2)
        qed
        ultimately have "A \<rightarrow>\<^sub>\<S>\<^sup>+ B" by (auto simp add: Aui in2)
        thus ?thesis 
          by (rule_tac x="A" in exI, rule_tac x="B" in exI, simp add: in1 in2)
      next
        assume notin1: "A \<notin> X\<^sub>1"
        moreover have "A \<in> \<C>" by (simp add: Aui)
        moreover have "X\<^sub>1 \<union> X\<^sub>2 = \<C>" by (simp add: partition)
        ultimately have in2: "A \<in> X\<^sub>2" by auto
        from partition obtain B where in1: "B \<in> X\<^sub>1" by auto
        have "B = A \<Longrightarrow> False"
        proof -
          assume "B = A"
          hence "B \<in> X\<^sub>2" by (simp add: in2)
          moreover have "B \<in> X\<^sub>1" by (rule in1)
          ultimately have "B \<in> X\<^sub>1 \<inter> X\<^sub>2" by simp
          hence "B \<in> {}" by (simp add: partition)
          thus "False" by simp
        qed
        hence "B \<noteq> A" by auto
        moreover have "B \<in> \<C>" 
        proof -
          from partition have "\<C> = X\<^sub>1 \<union> X\<^sub>2" by auto
          hence "X\<^sub>1 \<subseteq> \<C>" by simp
          thus ?thesis by (auto simp add: in1)
        qed
        ultimately have "A \<rightarrow>\<^sub>\<S>\<^sup>+ B" by (auto simp add: Aui in2)
        thus ?thesis 
          by (rule_tac x="B" in exI, rule_tac x="A" in exI, simp add: in1 in2)
      qed
    qed
  qed
qed

text \<open>
Lemma \emph{fixed-no-stimcomm} shows that no agent has the potential for communication via stimuli with an agent that has a fixed point behaviour.
\<close>

lemma fixed_no_stimcomm: "fixed(A) \<longrightarrow> (\<forall> B. \<not>(B \<rightarrow>\<^sub>\<S> A))"
  unfolding fixed_def 
proof (rule impI)
  assume hyp: "\<forall>s. s \<noteq> \<dd> \<longrightarrow> s \<circ> A = A"
  have "\<exists> B. B \<rightarrow>\<^sub>\<S> A \<Longrightarrow> False"
  proof -
    assume "\<exists> B. B \<rightarrow>\<^sub>\<S> A"
    then obtain B where "B \<rightarrow>\<^sub>\<S> A" by auto
    hence "\<exists> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,B) \<and> t \<circ> A \<noteq> A" 
      by (simp only: dcs_def)
    then obtain s t where st: "s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,B) \<and> t \<circ> A \<noteq> A" 
      by auto
    hence "t \<noteq> \<dd>" by (auto simp only: zero_not_basic)
    hence "t \<circ> A = A" by (simp add: hyp)
    thus False by (auto simp add: st)
  qed
  thus "(\<forall> B. \<not>(B \<rightarrow>\<^sub>\<S> A))" by auto
qed

subsection \<open>Preserving the Potential for Communication under Non-Determinism \label{sub:non_determinism}\<close>

subsubsection \<open>Potential for Communication via Stimuli \label{ssub:pfc_stim}\<close>

text \<open>
The following results show how the potential for communication via stimuli can be preserved when non-determinism is introduced among agents. 
Specifically, Lemma \emph{source-nondet-stimcomm} states that when non-determinism is added at the source of a potential communication path via stimuli, the potential 
for communication via stimuli is always preserved. On the other hand, Lemma \emph{sink-nondet-stimcomm} states that when non-determinism is added at the sink of a 
potential communication path via stimuli, the potential for communication is preserved only if there does not exist any basic stimulus that is 
generated by the source that influences agent~$\Agent{B}$ and agent~$\Agent{C}$ to behave as a sub-behaviour of agent~$\Agent{B + C}$. This 
condition ensures that agent~$\Agent{B + C}$ cannot have a fixed point behaviour.
\<close>

lemma source_nondet_stimcomm: "(B \<rightarrow>\<^sub>\<S> C) \<Longrightarrow> ((A + B) \<rightarrow>\<^sub>\<S> C)"
proof -
  assume "B \<rightarrow>\<^sub>\<S> C"
  then obtain s t where st: "s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,B) \<and> t \<circ> C \<noteq> C" 
    by (auto simp only: dcs_def)
  show "(A + B) \<rightarrow>\<^sub>\<S> C"
    unfolding dcs_def 
    by (rule_tac x="s" in exI, rule_tac x="t" in exI, auto simp add: st inf_add_S_left)
qed

lemma comm_source_nondet_stimcomm: "(B \<rightarrow>\<^sub>\<S> C) \<Longrightarrow> ((B + A) \<rightarrow>\<^sub>\<S> C)"
  by (simp add: source_nondet_stimcomm algebra_simps)

lemma sink_sum_stimcomm: "(\<exists> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> 
\<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C)) \<Longrightarrow> (A \<rightarrow>\<^sub>\<S> B + C)"
proof -
  assume "\<exists> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> 
\<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C)"
  then obtain s t where st: "s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> 
\<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C)" by auto
  have "t \<circ> (B + C) = B + C \<Longrightarrow> False"
  proof -
    assume fixbc: "t \<circ> (B + C) = B + C"
    have "t \<circ> B  \<le>\<^sub>\<K> t \<circ> (B + C)"
      by (simp, rule inf_add_K_right)
    moreover have "t \<circ> C  \<le>\<^sub>\<K> t \<circ> (B + C)"
      by (simp, rule inf_add_K_left)
    ultimately have "t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C" 
      by (simp only: fixbc)
    thus False by (simp only: st) 
  qed
  thus "A \<rightarrow>\<^sub>\<S> B + C"
    unfolding dcs_def
    by (rule_tac x="s" in exI, rule_tac x="t" in exI, auto simp only: st)
qed

lemma sink_nondet_stimcomm: "A \<rightarrow>\<^sub>\<S> B \<Longrightarrow> (\<forall> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) 
\<longrightarrow> \<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C)) \<Longrightarrow> (A \<rightarrow>\<^sub>\<S> B + C)"
proof (rule sink_sum_stimcomm)
  assume h1: "A \<rightarrow>\<^sub>\<S> B"
  assume h2: "(\<forall> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<longrightarrow> 
\<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C))"
  show "\<exists> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> 
\<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C)"
  proof -
    from h1 obtain s t where "s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> t \<circ> B \<noteq> B"
      by (auto simp only: dcs_def)
    from this h2 have "s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> 
\<not>(t \<circ> B \<le>\<^sub>\<K> B + C \<and> t \<circ> C \<le>\<^sub>\<K> B + C)" by auto
    thus ?thesis
      by (rule_tac x="s" in exI, rule_tac x="t" in exI, auto)
  qed
qed

subsubsection \<open>Potential for Communication via Shared Environments \label{ssub:pfc_env}\<close>

text \<open>
Lemmas \emph{source-nondet-envcomm} and \emph{sink-nondet-envcomm} show how the potential for communication via shared environments is preserved when non-determinism is 
introduced at the source or the sink of a potential communication path via shared environments.
\<close>

lemma source_nondet_envcomm: "B \<rightarrow>\<^sub>\<E> C \<Longrightarrow> (A + B) \<rightarrow>\<^sub>\<E> C"
  by (simp add: sum_dce)

lemma sink_nondet_envcomm: "A \<rightarrow>\<^sub>\<E> B \<Longrightarrow> A \<rightarrow>\<^sub>\<E> (B + C)"
  by (simp add: dce_sum)

 
subsection \<open>Preserving the Potential for Communication with Agent Behaviour Modifications\label{sub:preservation}\<close>

text \<open>
The following results identify the conditions constraining the modifications that can be made to the source or sink agent involved in a direct potential for communication to 
preserve the communication in a distributed system. In this way, it demonstrates the conditions under which a modification to an agent behaviour can be made while maintaining 
the communicating behaviour of the agents in the system.

Specifically, Lemma \emph{sink-seq-stimcomm} shows how the sequential composition of an additional behaviour on the left of a sink agent will not affect the potential for communication 
provided that every stimulus that is generated by the source agent either does not fix the behaviour of the first component of the sequential composition, or causes the 
first component of the sequential composition to generate a stimulus that does not fix the behaviour of the second component of the sequential composition. Alternatively, 
Lemma \emph{nondet-right-source-communication} shows how non-determinism added on the right of a source agent will not affect the potential for communication provided that 
the non-deterministic behaviours can be influenced by the source agent to stop being a sub-behaviour of the non-deterministic behaviour.
\<close>


lemma sink_seq_stimcomm: "A \<rightarrow>\<^sub>\<S> B 
\<Longrightarrow> \<forall> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<longrightarrow> \<lambda>(t,C) = t \<Longrightarrow> A;C \<rightarrow>\<^sub>\<S> B"
proof -
  assume "A \<rightarrow>\<^sub>\<S> B"
  then obtain s t where st: "s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<and> t \<circ> B \<noteq> B" 
    unfolding dcs_def by auto
  assume "\<forall> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) \<longrightarrow> \<lambda>(t,C) = t"
  from this st have tfix: "\<lambda>(t,C) = t" by auto
  have "\<lambda>(t,C) \<le>\<^sub>\<S>  \<lambda>(\<lambda>(s,A),C)" by (simp add: inf_S_next_stimulus st)
  hence "t \<le>\<^sub>\<S> \<lambda> (\<lambda> (s, A), C)" by (simp add: tfix)
  thus "A;C \<rightarrow>\<^sub>\<S> B" 
    unfolding dcs_def
    by (rule_tac x="s" in exI, rule_tac x="t" in exI, simp add: st)
qed

lemma nondet_right_source_communication: "A \<leadsto> C \<and> C \<leadsto> B \<Longrightarrow> (\<forall> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) 
\<longrightarrow> \<not>(t \<circ> C \<le>\<^sub>\<K> C + D \<and> t \<circ> D \<le>\<^sub>\<K> C + D)) \<Longrightarrow> A \<leadsto> C+D \<and> C+D \<leadsto> B"
proof -
  assume h1:"A \<leadsto> C \<and> C \<leadsto> B"
  assume h2:"(\<forall> s t. s \<in> \<S>\<^sub>a \<and> t \<in> \<S>\<^sub>a \<and> t \<le>\<^sub>\<S> \<lambda>(s,A) 
\<longrightarrow> \<not>(t \<circ> C \<le>\<^sub>\<K> C + D \<and> t \<circ> D \<le>\<^sub>\<K> C + D))"
  from h2 have hs: "A \<rightarrow>\<^sub>\<S> C \<Longrightarrow> A \<rightarrow>\<^sub>\<S> C+D" 
    by (auto simp add: sink_nondet_stimcomm)
  have "A \<leadsto> C \<Longrightarrow> A \<leadsto> C+D"
    unfolding pdc_def
    using dce_sum hs by blast
  moreover have "C \<leadsto> B \<Longrightarrow> C + D \<leadsto> B"
    unfolding pdc_def
    using comm_source_nondet_stimcomm sum_dce by blast
  ultimately show "A \<leadsto> C+D \<and> C+D \<leadsto> B"
    by (simp add: h1)
qed

end

end
