chapter \<open>Generated by Lem from \<open>semantics/alt_semantics/proofs/bigSmallInvariants.lem\<close>.\<close>

theory "BigSmallInvariants" 

imports
  Main
  "HOL-Library.Datatype_Records"
  "LEM.Lem_pervasives"
  "Lib"
  "Namespace"
  "Ast"
  "SemanticPrimitives"
  "SmallStep"
  "BigStep"

begin 

\<comment> \<open>\<open>open import Pervasives\<close>\<close>
\<comment> \<open>\<open>open import Lib\<close>\<close>
\<comment> \<open>\<open>open import Namespace\<close>\<close>
\<comment> \<open>\<open>open import Ast\<close>\<close>
\<comment> \<open>\<open>open import SemanticPrimitives\<close>\<close>
\<comment> \<open>\<open>open import SmallStep\<close>\<close>
\<comment> \<open>\<open>open import BigStep\<close>\<close>

\<comment> \<open>\<open> ------ Auxiliary relations for proving big/small step equivalence ------ \<close>\<close>

inductive
evaluate_ctxt  :: "(v)sem_env \<Rightarrow> 'ffi state \<Rightarrow> ctxt_frame \<Rightarrow> v \<Rightarrow> 'ffi state*((v),(v))result \<Rightarrow> bool "  where

"raise" : " \<And> env s v1.

evaluate_ctxt env s (Craise () ) v1 (s, Rerr (Rraise v1))"

|

"handle" : " \<And> env s v1 pes.

evaluate_ctxt env s (Chandle ()  pes) v1 (s, Rval v1)"

|

"app1" : " \<And> env e v1 vs1 vs2 es env' bv s1 s2.
evaluate_list False env s1 es (s2, Rval vs2) \<and>
((do_opapp ((List.rev vs2 @ [v1]) @ vs1) = Some (env',e)) \<and>
evaluate False env' s2 e bv)
==>
evaluate_ctxt env s1 (Capp Opapp vs1 ()  es) v1 bv "

|

"app2" : " \<And> env v1 vs1 vs2 es s1 s2.
evaluate_list False env s1 es (s2, Rval vs2) \<and>
(do_opapp ((List.rev vs2 @ [v1]) @ vs1) = None)
==>
evaluate_ctxt env s1 (Capp Opapp vs1 ()  es) v1 (s2, Rerr (Rabort Rtype_error))"

|

"app3" : " \<And> env op0 v1 vs1 vs2 es res s1 s2 new_refs new_ffi.
(op0 \<noteq> Opapp) \<and>
(evaluate_list False env s1 es (s2, Rval vs2) \<and>
(do_app ((refs   s2),(ffi   s2)) op0 ((List.rev vs2 @ [v1]) @ vs1) = Some ((new_refs, new_ffi) ,res)))
==>
evaluate_ctxt env s1 (Capp op0 vs1 ()  es) v1 (( s2 (| ffi := new_ffi, refs := new_refs |)), res)"

|

"app4" : " \<And> env op0 v1 vs1 vs2 es s1 s2.
(op0 \<noteq> Opapp) \<and>
(evaluate_list False env s1 es (s2, Rval vs2) \<and>
(do_app ((refs   s2),(ffi   s2)) op0 ((List.rev vs2 @ [v1]) @ vs1) = None))
==>
evaluate_ctxt env s1 (Capp op0 vs1 ()  es) v1 (s2, Rerr (Rabort Rtype_error))"

|

"app5" : " \<And> env op0 es vs v1 err s s'.
evaluate_list False env s es (s', Rerr err)
==>
evaluate_ctxt env s (Capp op0 vs ()  es) v1 (s', Rerr err)"

|

"log1" : " \<And> env op0 e2 v1 e' bv s.
(do_log op0 v1 e2 = Some (Exp e')) \<and>
evaluate False env s e' bv
==>
evaluate_ctxt env s (Clog op0 ()  e2) v1 bv "

|

"log2" : " \<And> env op0 e2 v1 v' s.
do_log op0 v1 e2 = Some (Val v')
==>
evaluate_ctxt env s (Clog op0 ()  e2) v1 (s, Rval v')"

|

"log3" : " \<And> env op0 e2 v1 s.
(do_log op0 v1 e2 = None)
==>
evaluate_ctxt env s (Clog op0 ()  e2) v1 (s, Rerr (Rabort Rtype_error))"

|
"if1" : " \<And> env e2 e3 v1 e' bv s.
(do_if v1 e2 e3 = Some e') \<and>
evaluate False env s e' bv
==>
evaluate_ctxt env s (Cif ()  e2 e3) v1 bv "

|

"if2" : " \<And> env e2 e3 v1 s.
do_if v1 e2 e3 = None
==>
evaluate_ctxt env s (Cif ()  e2 e3) v1 (s, Rerr (Rabort Rtype_error))"

|

"mat" : " \<And> env pes v1 bv s err_v.
evaluate_match False env s v1 pes err_v bv
==>
evaluate_ctxt env s (Cmat ()  pes err_v) v1 bv "

|

"lt" : " \<And> env n e2 v1 bv s.
evaluate False ( env (| v := (nsOptBind n v1(v   env)) |)) s e2 bv
==>
evaluate_ctxt env s (Clet n ()  e2) v1 bv "

|

"con1" : " \<And> env cn es vs v1 vs' s1 s2 v'.
do_con_check(c   env) cn ((List.length vs + List.length es) +( 1 :: nat)) \<and>
((build_conv(c   env) cn ((List.rev vs' @ [v1]) @ vs) = Some v') \<and>
evaluate_list False env s1 es (s2, Rval vs'))
==>
evaluate_ctxt env s1 (Ccon cn vs ()  es) v1 (s2, Rval v')"

|

"con2" : " \<And> env cn es vs v1 s.
\<not> (do_con_check(c   env) cn ((List.length vs + List.length es) +( 1 :: nat)))
==>
evaluate_ctxt env s (Ccon cn vs ()  es) v1 (s, Rerr (Rabort Rtype_error))"

|

"con3" : " \<And> env cn es vs v1 err s s'.
do_con_check(c   env) cn ((List.length vs + List.length es) +( 1 :: nat)) \<and>
evaluate_list False env s es (s', Rerr err)
==>
evaluate_ctxt env s (Ccon cn vs ()  es) v1 (s', Rerr err)"

|

"tannot" : " \<And> env v1 s t0.

evaluate_ctxt env s (Ctannot ()  t0) v1 (s, Rval v1)"

|

"lannot" : " \<And> env v1 s l.

evaluate_ctxt env s (Clannot ()  l) v1 (s, Rval v1)"

inductive
evaluate_ctxts  :: " 'ffi state \<Rightarrow>(ctxt)list \<Rightarrow>((v),(v))result \<Rightarrow> 'ffi state*((v),(v))result \<Rightarrow> bool "  where

"empty" : " \<And> res s.

evaluate_ctxts s [] res (s, res)"

|

"cons_val" : " \<And> c1 cs env v1 res bv s1 s2.
evaluate_ctxt env s1 c1 v1 (s2, res) \<and>
evaluate_ctxts s2 cs res bv
==>
evaluate_ctxts s1 ((c1,env)# cs) (Rval v1) bv "

|

"cons_err" : " \<And> c1 cs env err s bv.
evaluate_ctxts s cs (Rerr err) bv \<and>
(((\<forall> pes.  c1 \<noteq> Chandle ()  pes)) \<or>
 ((\<forall> v1.  err \<noteq> Rraise v1)))
==>
evaluate_ctxts s ((c1,env)# cs) (Rerr err) bv "

|

"cons_handle" : " \<And> cs env s s' res1 res2 pes v1.
evaluate_match False env s v1 pes v1 (s', res1) \<and>
evaluate_ctxts s' cs res1 res2
==>
evaluate_ctxts s ((Chandle ()  pes,env)# cs) (Rerr (Rraise v1)) res2 "

inductive
evaluate_state  :: " 'ffi small_state \<Rightarrow> 'ffi state*((v),(v))result \<Rightarrow> bool "  where

"exp" : " \<And> env e c1 res bv ffi0 refs0 st.
evaluate False env  (| clock =(( 0 :: nat)), refs = refs0, ffi = ffi0, defined_types = ({}), defined_mods = 
 ({})  |) e (st, res) \<and>
evaluate_ctxts st c1 res bv
==>
evaluate_state (env, (refs0, ffi0), Exp e, c1) bv "

|

"vl" : " \<And> env ffi0 refs0 v1 c1 bv.
evaluate_ctxts  (| clock =(( 0 :: nat)), refs = refs0, ffi = ffi0, defined_types = ({}), defined_mods = 
 ({})  |) c1 (Rval v1) bv
==>
evaluate_state (env, (refs0, ffi0), Val v1, c1) bv "
end
