theory Semantics
  imports Broadcast_Chain Broadcast_Frame
begin

text \<open>This file is a (heavily modified) variant of the theory {\it Psi\_Calculi.Semantics}
from~\cite{DBLP:journals/afp/Bengtson12}. The nominal datatypes {\it ('a,'b,'c) residual} and
{\it 'a action} have been extended with constructors for broadcast input and output. This leads to
a different semantics.\<close>

nominal_datatype ('a, 'b, 'c) boundOutput =
  BOut "'a::fs_name" "('a, 'b::fs_name, 'c::fs_name) psi" (\<open>_ \<prec>'' _\<close> [110, 110] 110)
  | BStep "\<guillemotleft>name\<guillemotright> ('a, 'b, 'c) boundOutput"                (\<open>\<lparr>\<nu>_\<rparr>_\<close> [110, 110] 110)

primrec BOresChain :: "name list \<Rightarrow> ('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput \<Rightarrow>
                      ('a, 'b, 'c) boundOutput"
  where
    Base: "BOresChain [] B = B"
  | Step: "BOresChain (x#xs) B = \<lparr>\<nu>x\<rparr>(BOresChain xs B)"

abbreviation
  BOresChainJudge (\<open>\<lparr>\<nu>*_\<rparr>_\<close> [80, 80] 80) where "\<lparr>\<nu>*xvec\<rparr>B \<equiv> BOresChain xvec B"

lemma BOresChainEqvt[eqvt]:
  fixes perm :: "name prm"
    and lst  :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"

shows "perm \<bullet> (\<lparr>\<nu>*xvec\<rparr>B) = \<lparr>\<nu>*(perm \<bullet> xvec)\<rparr>(perm \<bullet> B)"
  by(induct xvec) auto

lemma BOresChainSimps[simp]:
  fixes xvec :: "name list"
    and N    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and N'   :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and B    :: "('a, 'b, 'c) boundOutput"
    and B'    :: "('a, 'b, 'c) boundOutput"

shows "(\<lparr>\<nu>*xvec\<rparr>N \<prec>' P = N' \<prec>' P') = (xvec = [] \<and> N = N' \<and> P = P')"
  and "(N' \<prec>' P' = \<lparr>\<nu>*xvec\<rparr>N \<prec>' P) = (xvec = [] \<and> N = N' \<and> P = P')"
  and "(N' \<prec>' P' = N \<prec>' P) = (N = N' \<and> P = P')"
  and "(\<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*xvec\<rparr>B') = (B = B')"
  by(induct xvec) (auto simp add: boundOutput.inject alpha)

lemma outputFresh[simp]:
  fixes Xs   :: "name set"
    and xvec :: "name list"
    and N    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"

shows "(Xs \<sharp>* (N \<prec>' P)) = ((Xs \<sharp>* N) \<and> (Xs \<sharp>* P))"
  and "(xvec \<sharp>* (N \<prec>' P)) = ((xvec \<sharp>* N) \<and> (xvec \<sharp>* P))"
  by(auto simp add: fresh_star_def)

lemma boundOutputFresh:
  fixes x    :: name
    and xvec :: "name list"
    and B   :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"

shows "(x \<sharp> (\<lparr>\<nu>*xvec\<rparr>B)) = (x \<in> set xvec \<or> x \<sharp> B)"
  by (induct xvec) (simp_all add: abs_fresh)

lemma boundOutputFreshSet:
  fixes Xs   :: "name set"
    and xvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and yvec :: "name list"
    and x    :: name

shows "Xs \<sharp>* (\<lparr>\<nu>*xvec\<rparr>B) = (\<forall>x\<in>Xs. x \<in> set xvec \<or> x \<sharp> B)"
  and "yvec \<sharp>* (\<lparr>\<nu>*xvec\<rparr>B) = (\<forall>x\<in>(set yvec). x \<in> set xvec \<or> x \<sharp> B)"
  and "Xs \<sharp>* (\<lparr>\<nu>x\<rparr>B) = Xs \<sharp>* [x].B"
  and "xvec \<sharp>* (\<lparr>\<nu>x\<rparr>B) = xvec \<sharp>* [x].B"
  by(simp add: fresh_star_def boundOutputFresh)+

lemma BOresChainSupp:
  fixes xvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"

shows "(supp(\<lparr>\<nu>*xvec\<rparr>B)::name set) = (supp B) - (supp xvec)"
  by(induct xvec)
    (auto simp add: boundOutput.supp supp_list_nil supp_list_cons abs_supp supp_atm)

lemma boundOutputFreshSimps[simp]:
  fixes Xs   :: "name set"
    and xvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and yvec :: "name list"
    and x    :: name

shows "Xs \<sharp>* xvec \<Longrightarrow> (Xs \<sharp>* (\<lparr>\<nu>*xvec\<rparr>B)) = (Xs \<sharp>* B)"
  and "yvec \<sharp>* xvec \<Longrightarrow> yvec \<sharp>* (\<lparr>\<nu>*xvec\<rparr>B) = yvec \<sharp>* B"
  and "xvec \<sharp>* (\<lparr>\<nu>*xvec\<rparr>B)"
  and "x \<sharp> xvec \<Longrightarrow> x \<sharp> \<lparr>\<nu>*xvec\<rparr>B = x \<sharp> B"
     apply(simp add: boundOutputFreshSet) apply(force simp add: fresh_star_def name_list_supp fresh_def)
    apply(simp add: boundOutputFreshSet) apply(force simp add: fresh_star_def name_list_supp fresh_def)
   apply(simp add: boundOutputFreshSet)
  by(simp add: BOresChainSupp fresh_def)

lemma boundOutputChainAlpha:
  fixes p    :: "name prm"
    and xvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and yvec :: "name list"

assumes xvecFreshB: "(p \<bullet> xvec) \<sharp>* B"
  and   S: "set p \<subseteq> set xvec \<times> set (p \<bullet> xvec)"
  and   "(set xvec) \<subseteq> (set yvec)"

shows "(\<lparr>\<nu>*yvec\<rparr>B) = (\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>(p \<bullet> B))"
proof -
  note pt_name_inst at_name_inst S
  moreover from \<open>(set xvec) \<subseteq> (set yvec)\<close> have "set xvec \<sharp>* (\<lparr>\<nu>*yvec\<rparr>B)"
    by(force simp add: boundOutputFreshSet)
  moreover from xvecFreshB \<open>(set xvec) \<subseteq> (set yvec)\<close> have "set (p \<bullet> xvec) \<sharp>* (\<lparr>\<nu>*yvec\<rparr>B)"
    by (simp add: boundOutputFreshSet) (simp add: fresh_star_def)
  ultimately have "(\<lparr>\<nu>*yvec\<rparr>B) = p \<bullet> (\<lparr>\<nu>*yvec\<rparr>B)"
    by (rule pt_freshs_freshs [symmetric])
  then show ?thesis by(simp add: eqvts)
qed

lemma boundOutputChainAlpha':
  fixes p    :: "name prm"
    and xvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and yvec :: "name list"
    and zvec :: "name list"

assumes xvecFreshB: "xvec \<sharp>* B"
  and   S: "set p \<subseteq> set xvec \<times> set yvec"
  and   "yvec \<sharp>* (\<lparr>\<nu>*zvec\<rparr>B)"

shows "(\<lparr>\<nu>*zvec\<rparr>B) = (\<lparr>\<nu>*(p \<bullet> zvec)\<rparr>(p \<bullet> B))"
proof -
  note pt_name_inst at_name_inst S \<open>yvec \<sharp>* (\<lparr>\<nu>*zvec\<rparr>B)\<close>
  moreover from xvecFreshB have "set (xvec) \<sharp>* (\<lparr>\<nu>*zvec\<rparr>B)"
    by (simp add: boundOutputFreshSet) (simp add: fresh_star_def)
  ultimately have "(\<lparr>\<nu>*zvec\<rparr>B) = p \<bullet> (\<lparr>\<nu>*zvec\<rparr>B)"
    by(auto intro: pt_freshs_freshs [symmetric])
  then show ?thesis by(simp add: eqvts)
qed

lemma boundOutputChainAlpha'':
  fixes p    :: "name prm"
    and xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"

assumes "(p \<bullet> xvec) \<sharp>* M"
  and   "(p \<bullet> xvec) \<sharp>* P"
  and    "set p \<subseteq> set xvec \<times> set (p \<bullet> xvec)"
  and   "(set xvec) \<subseteq> (set yvec)"

shows "(\<lparr>\<nu>*yvec\<rparr>M \<prec>' P) = (\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>(p \<bullet> M) \<prec>' (p \<bullet> P))"
  using assms
  by(subst boundOutputChainAlpha) auto

lemma boundOutputChainSwap:
  fixes x    :: name
    and y    :: name
    and N    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and xvec :: "name list"

assumes "y \<sharp> N"
  and   "y \<sharp> P"
  and   "x \<in> (set xvec)"

shows "\<lparr>\<nu>*xvec\<rparr>N \<prec>' P = \<lparr>\<nu>*([(x, y)] \<bullet> xvec)\<rparr>([(x ,y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> P)"
proof(cases "x=y")
  assume "x=y"
  then show ?thesis by simp
next
  assume "x \<noteq> y"
  with assms show ?thesis
    by(auto simp add: calc_atm intro: boundOutputChainAlpha''[where xvec="[x]"])
qed

lemma alphaBoundOutput:
  fixes x  :: name
    and y  :: name
    and B  :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"

assumes "y \<sharp> B"

shows "\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> B)"
  using assms
  by(auto simp add: boundOutput.inject alpha fresh_left calc_atm)

lemma boundOutputEqFresh:
  fixes B :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and C :: "('a, 'b, 'c) boundOutput"
    and x :: name
    and y :: name

assumes "\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>y\<rparr>C"
  and   "x \<sharp> B"

shows "y \<sharp> C"
  using assms
  by(auto simp add: boundOutput.inject alpha fresh_left calc_atm)

lemma boundOutputEqSupp:
  fixes B :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and C :: "('a, 'b, 'c) boundOutput"
    and x :: name
    and y :: name

assumes "\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>y\<rparr>C"
  and   "x \<in> supp B"

shows "y \<in> supp C"
  using assms
  apply(clarsimp simp add: boundOutput.inject alpha fresh_left calc_atm)
  apply(drule pt_set_bij2[where pi="[(x, y)]", OF pt_name_inst, OF at_name_inst])
  by(auto simp add: eqvts calc_atm)

lemma boundOutputChainEq:
  fixes xvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and yvec :: "name list"
    and B'   :: "('a, 'b, 'c) boundOutput"

assumes "\<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*yvec\<rparr>B'"
  and   "xvec \<sharp>* yvec"
  and   "length xvec = length yvec"

shows "\<exists>p. (set p) \<subseteq> (set xvec) \<times> set (yvec) \<and> distinctPerm p \<and>  B = p \<bullet> B' \<and> (set (map fst p)) \<subseteq> (supp B) \<and> xvec \<sharp>* B' \<and> yvec \<sharp>* B"
proof -
  obtain n where "n = length xvec" by auto
  with assms show ?thesis
  proof(induct n arbitrary: xvec yvec B B')
    case(0 xvec yvec B B')
    have Eq: "\<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*yvec\<rparr>B'" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with \<open>length xvec = length yvec\<close> have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec B B')
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*yvec\<rparr>B'\<close> \<open>xvec = x # xvec'\<close> \<open>length xvec = length yvec\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>B = \<lparr>\<nu>*(y#yvec')\<rparr>B'"
      and "yvec = y#yvec'" and "length xvec' = length yvec'"
      by(cases yvec) auto
    then have EQ: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>B) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>B')"
      by simp
    from \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>xvec \<sharp>* yvec\<close>
    have "x \<noteq> y" and "xvec' \<sharp>* yvec'" and "x \<sharp> yvec'" and "y \<sharp> xvec'"
      by auto
    have IH: "\<And>xvec yvec B B'. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>(B::('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput) = \<lparr>\<nu>*yvec\<rparr>B'; xvec \<sharp>* yvec; length xvec = length yvec; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>p. (set p) \<subseteq> (set xvec) \<times> (set yvec) \<and> distinctPerm p \<and>  B = p \<bullet> B' \<and> set(map fst p) \<subseteq> supp B \<and> xvec \<sharp>* B' \<and> yvec \<sharp>* B"
      by fact
    from EQ \<open>x \<noteq> y\<close> have EQ': "\<lparr>\<nu>*xvec'\<rparr>B = ([(x, y)] \<bullet> (\<lparr>\<nu>*yvec'\<rparr>B'))"
      and xFreshB': "x \<sharp> (\<lparr>\<nu>*yvec'\<rparr>B')"
      and yFreshB: "y \<sharp> (\<lparr>\<nu>*xvec'\<rparr>B)"
      by(metis boundOutput.inject alpha)+
    from xFreshB' \<open>x \<sharp> yvec'\<close> have "x \<sharp> B'"
      by(auto simp add: boundOutputFresh) (simp add: fresh_def name_list_supp)+
    from yFreshB \<open>y \<sharp> xvec'\<close> have "y \<sharp> B"
      by(auto simp add: boundOutputFresh) (simp add: fresh_def name_list_supp)+
    show ?case
    proof(cases "x \<sharp> \<lparr>\<nu>*xvec'\<rparr>B")
      assume xFreshB: "x \<sharp> \<lparr>\<nu>*xvec'\<rparr>B"
      with EQ have yFreshB': "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>B'"
        by(rule boundOutputEqFresh)
      with xFreshB' EQ' have "\<lparr>\<nu>*xvec'\<rparr>B = \<lparr>\<nu>*yvec'\<rparr>B'"
        by(simp)
      with \<open>xvec' \<sharp>* yvec'\<close> \<open>length xvec' = length yvec'\<close> \<open>length xvec' = n\<close> IH
      obtain p where S: "(set p) \<subseteq> (set xvec') \<times> (set yvec')" and "distinctPerm p" and "B = p \<bullet> B'"
        and "set(map fst p) \<subseteq> supp B" and "xvec' \<sharp>* B'"  and "yvec' \<sharp>* B"
        by blast
      from S have "(set p) \<subseteq> set(x#xvec') \<times> set(y#yvec')" by auto
      moreover note \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>distinctPerm p\<close> \<open>B = p \<bullet> B'\<close>
        \<open>xvec' \<sharp>* B'\<close> \<open>x \<sharp> B'\<close> \<open>x \<sharp> B'\<close> \<open>yvec' \<sharp>* B\<close> \<open>y \<sharp> B\<close> \<open>set(map fst p) \<subseteq> supp B\<close>

      ultimately show ?case by auto
    next
      assume "\<not>(x \<sharp> \<lparr>\<nu>*xvec'\<rparr>B)"
      then have xSuppB: "x \<in> supp(\<lparr>\<nu>*xvec'\<rparr>B)"
        by(simp add: fresh_def)
      with EQ have ySuppB': "y \<in> supp (\<lparr>\<nu>*yvec'\<rparr>B')"
        by(rule boundOutputEqSupp)
      then have "y \<sharp> yvec'"
        by(induct yvec') (auto simp add: boundOutput.supp abs_supp)
      with \<open>x \<sharp> yvec'\<close> EQ' have "\<lparr>\<nu>*xvec'\<rparr>B = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> B')"
        by(simp add: eqvts)
      with  \<open>xvec' \<sharp>* yvec'\<close> \<open>length xvec' = length yvec'\<close> \<open>length xvec' = n\<close> IH
      obtain p where S: "(set p) \<subseteq> (set xvec') \<times> (set yvec')" and "distinctPerm p" and "B = p \<bullet> [(x, y)] \<bullet> B'"
        and "set(map fst p) \<subseteq> supp B" and "xvec' \<sharp>* ([(x, y)] \<bullet> B')" and "yvec' \<sharp>* B"
        by blast

      from xSuppB have "x \<sharp> xvec'"
        by(induct xvec') (auto simp add: boundOutput.supp abs_supp)
      with \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> xvec'\<close> \<open>y \<sharp> yvec'\<close> S have "x \<sharp> p" and "y \<sharp> p"
         apply(induct p)
        by(auto simp add: name_list_supp) (auto simp add: fresh_def)
      from S have "(set ((x, y)#p)) \<subseteq> (set(x#xvec')) \<times> (set(y#yvec'))"
        by force
      moreover from \<open>x \<noteq> y\<close> \<open>x \<sharp> p\<close> \<open>y \<sharp> p\<close> S \<open>distinctPerm p\<close>
      have "distinctPerm((x,y)#p)" by simp
      moreover from \<open>B = p \<bullet> [(x, y)] \<bullet> B'\<close> \<open>x \<sharp> p\<close> \<open>y \<sharp> p\<close> have "B = [(x, y)] \<bullet> p \<bullet> B'"
        by(subst perm_compose) simp
      then have "B = ((x, y)#p) \<bullet> B'" by simp
      moreover from \<open>xvec' \<sharp>* ([(x, y)] \<bullet> B')\<close> have "([(x, y)] \<bullet> xvec') \<sharp>* ([(x, y)] \<bullet> [(x, y)] \<bullet> B')"
        by(simp only: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>x \<sharp> xvec'\<close> \<open>y \<sharp> xvec'\<close> \<open>x \<sharp> B'\<close> have "(x#xvec') \<sharp>* B'" by simp
      moreover from \<open>y \<sharp> B\<close> \<open>yvec' \<sharp>* B\<close> have "(y#yvec') \<sharp>* B" by simp
      moreover from \<open>set(map fst p) \<subseteq> supp B\<close> xSuppB \<open>x \<sharp> xvec'\<close>
      have "set(map fst ((x, y)#p)) \<subseteq> supp B"
        by(simp add: BOresChainSupp)
      ultimately show ?case using \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close>
        by metis
    qed
  qed
qed

lemma boundOutputChainEqLength:
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: "'a::fs_name"
    and Q    :: "('a, 'b::fs_name, 'c::fs_name) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"

shows "length xvec = length yvec"
proof -
  obtain n where "n = length xvec" by auto
  with assms show ?thesis
  proof(induct n arbitrary: xvec yvec M P N Q)
    case(0 xvec yvec M P N Q)
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q\<close> have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case by simp
  next
    case(Suc n xvec yvec M P N Q)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' Q"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have EQ: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q)"
      by simp
    have IH: "\<And>xvec yvec M P N Q. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q::('a, 'b, 'c) psi); n = length xvec\<rbrakk> \<Longrightarrow> length xvec = length yvec"
      by fact
    show ?case
    proof(cases "x = y")
      assume "x = y"
      with EQ have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P  = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(simp add: alpha boundOutput.inject)
      with IH \<open>length xvec' = n\<close> have "length xvec' = length yvec'"
        by blast
      with \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close>
      show ?case by simp
    next
      assume "x \<noteq> y"
      with EQ have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = [(x, y)] \<bullet> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(simp add: alpha boundOutput.inject)
      then have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
        by(simp add: eqvts)
      with IH \<open>length xvec' = n\<close> have "length xvec' = length ([(x, y)] \<bullet> yvec')"
        by blast
      then have "length xvec' = length yvec'"
        by simp
      with \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close>
      show ?case by simp
    qed
  qed
qed

lemma boundOutputChainEq':
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  and   "xvec \<sharp>* yvec"

shows "\<exists>p. (set p) \<subseteq> (set xvec) \<times> set (yvec) \<and> distinctPerm p \<and>  M = p \<bullet> N \<and>  P = p \<bullet> Q \<and> xvec \<sharp>* N \<and> xvec \<sharp>* Q \<and> yvec \<sharp>* M \<and> yvec \<sharp>* P"
  using assms boundOutputChainEq boundOutputChainEqLength by fastforce

lemma boundOutputChainEq'':
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  and   "xvec \<sharp>* yvec"
  and   "distinct xvec"
  and   "distinct yvec"

obtains p where "(set p) \<subseteq> (set xvec) \<times> set (p \<bullet> xvec)" and "distinctPerm p" and "yvec = p \<bullet> xvec" and "N = p \<bullet> M" and "Q = p \<bullet> P" and "xvec \<sharp>* N" and "xvec \<sharp>* Q" and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* P"
proof -

  assume "\<And>p. \<lbrakk>set p \<subseteq> set xvec \<times> set (p \<bullet> xvec); distinctPerm p; yvec = p \<bullet> xvec; N = p \<bullet> M; Q = p \<bullet> P; xvec \<sharp>* N; xvec \<sharp>* Q; (p \<bullet> xvec) \<sharp>* M; (p \<bullet> xvec) \<sharp>* P\<rbrakk> \<Longrightarrow> thesis"

  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>p. (set p) \<subseteq> (set xvec) \<times> set (yvec) \<and> distinctPerm p \<and>  yvec = p \<bullet> xvec \<and> N = p \<bullet> M \<and> Q = p \<bullet> P \<and> xvec \<sharp>* N \<and> xvec \<sharp>* Q \<and> (p \<bullet> xvec) \<sharp>* M \<and> (p \<bullet> xvec) \<sharp>* P"
  proof(induct n arbitrary: xvec yvec M P N Q)
    case(0 xvec yvec M P N Q)
    have Eq: "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with Eq have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec M P N Q)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' Q"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have EQ: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q)"
      by simp
    from \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>xvec \<sharp>* yvec\<close>
    have "x \<noteq> y" and "xvec' \<sharp>* yvec'" and "x \<sharp> yvec'" and "y \<sharp> xvec'"
      by auto
    from \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> have "x \<sharp> xvec'" and "y \<sharp> yvec'" and "distinct xvec'" and "distinct yvec'"
      by simp+
    have IH: "\<And>xvec yvec M P N Q. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>(M::'a) \<prec>' (P::('a, 'b, 'c) psi) = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q; xvec \<sharp>* yvec; distinct xvec; distinct yvec; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>p. (set p) \<subseteq> (set xvec) \<times> (set yvec) \<and> distinctPerm p \<and>  yvec = p \<bullet> xvec \<and> N = p \<bullet> M \<and> Q = p \<bullet> P \<and> xvec \<sharp>* N \<and> xvec \<sharp>* Q \<and> (p \<bullet> xvec) \<sharp>* M \<and> (p \<bullet> xvec) \<sharp>* P"
      by fact
    from EQ \<open>x \<noteq> y\<close>  \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> yvec'\<close> \<open>y \<sharp> xvec'\<close> \<open>x \<sharp> xvec'\<close> have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)" and "x \<sharp> N" and "x \<sharp> Q" and "y \<sharp> M" and "y \<sharp> P"
          apply -
          apply(simp add: boundOutput.inject alpha eqvts)
         apply(simp add: boundOutput.inject alpha eqvts)
        apply(simp add: boundOutput.inject alpha eqvts)
      by(simp add: boundOutput.inject alpha' eqvts)+
    with \<open>xvec' \<sharp>* yvec'\<close> \<open>distinct xvec'\<close> \<open>distinct yvec'\<close> \<open>length xvec' = n\<close> IH
    obtain p where S: "(set p) \<subseteq> (set xvec') \<times> (set yvec')" and "distinctPerm p" and "yvec' = p \<bullet> xvec'" and "([(x, y)] \<bullet> N) = p \<bullet> M" and "([(x, y)] \<bullet> Q) = p \<bullet> P" and "xvec' \<sharp>* ([(x, y)] \<bullet> N)" and "xvec' \<sharp>* ([(x, y)] \<bullet> Q)" and "yvec' \<sharp>* M" and "yvec' \<sharp>* P"
      by metis
    from S have "set((x, y)#p) \<subseteq> set(x#xvec') \<times> set(y#yvec')" by auto
    moreover from \<open>x \<sharp> xvec'\<close> \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> xvec'\<close> \<open>y \<sharp> yvec'\<close> S have "x \<sharp> p" and "y \<sharp> p"
       apply(induct p)
      by(auto simp add: fresh_prod name_list_supp) (auto simp add: fresh_def)

    with S \<open>distinctPerm p\<close> \<open>x \<noteq> y\<close> have "distinctPerm((x, y)#p)" by auto
    moreover from \<open>yvec' = p \<bullet> xvec'\<close> \<open>x \<sharp> p\<close> \<open>y \<sharp> p\<close> \<open>x \<sharp> xvec'\<close> \<open>y \<sharp> xvec'\<close> have "(y#yvec') = ((x, y)#p) \<bullet> (x#xvec')"
      by(simp add: eqvts calc_atm perm_compose freshChainSimps)
    moreover from \<open>([(x, y)] \<bullet> N) = p \<bullet> M\<close>
    have "([(x, y)] \<bullet> [(x, y)] \<bullet> N) = [(x, y)] \<bullet> p \<bullet> M"
      by(simp add: pt_bij)
    then have "N = ((x, y)#p) \<bullet> M" by simp
    moreover from \<open>([(x, y)] \<bullet> Q) = p \<bullet> P\<close>
    have "([(x, y)] \<bullet> [(x, y)] \<bullet> Q) = [(x, y)] \<bullet> p \<bullet> P"
      by(simp add: pt_bij)
    then have "Q = ((x, y)#p) \<bullet> P" by simp
    moreover from \<open>xvec' \<sharp>* ([(x, y)] \<bullet> N)\<close> have "([(x, y)] \<bullet> xvec') \<sharp>* ([(x, y)] \<bullet> [(x, y)] \<bullet> N)"
      by(subst fresh_star_bij)
    with \<open>x \<sharp> xvec'\<close> \<open>y \<sharp> xvec'\<close> have "xvec' \<sharp>* N" by simp
    with \<open>x \<sharp> N\<close> have "(x#xvec') \<sharp>* N" by simp
    moreover from \<open>xvec' \<sharp>* ([(x, y)] \<bullet> Q)\<close> have "([(x, y)] \<bullet> xvec') \<sharp>* ([(x, y)] \<bullet> [(x, y)] \<bullet> Q)"
      by(subst fresh_star_bij)
    with \<open>x \<sharp> xvec'\<close> \<open>y \<sharp> xvec'\<close> have "xvec' \<sharp>* Q" by simp
    with \<open>x \<sharp> Q\<close> have "(x#xvec') \<sharp>* Q" by simp
    moreover from \<open>y \<sharp> M\<close> \<open>yvec' \<sharp>* M\<close> have "(y#yvec') \<sharp>* M" by simp
    moreover from \<open>y \<sharp> P\<close> \<open>yvec' \<sharp>* P\<close> have "(y#yvec') \<sharp>* P" by simp
    ultimately show ?case using \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close>
      by metis
  qed
  ultimately show ?thesis by blast
qed

lemma boundOutputEqSupp':
  fixes x    :: name
    and xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and y    :: name
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a, 'b, 'c) psi"

assumes Eq: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec\<rparr>N \<prec>' Q)"
  and   "x \<noteq> y"
  and   "x \<sharp> yvec"
  and   "x \<sharp> xvec"
  and   "y \<sharp> xvec"
  and   "y \<sharp> yvec"
  and   "xvec \<sharp>* yvec"
  and   "x \<in> supp M"

shows "y \<in> supp N"
proof -
  from Eq \<open>x \<noteq> y\<close> \<open>x \<sharp> yvec\<close> \<open>y \<sharp> yvec\<close> have "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
    by(simp add: boundOutput.inject alpha eqvts)
  then obtain p where S: "set p \<subseteq> set xvec \<times> set yvec" and "M = p \<bullet> [(x, y)] \<bullet> N" and "distinctPerm p" using \<open>xvec \<sharp>* yvec\<close>
    by(blast dest: boundOutputChainEq')
  with \<open>x \<in> supp M\<close> have "x \<in> supp(p \<bullet> [(x, y)] \<bullet> N)" by simp
  then have "(p \<bullet> x) \<in> p \<bullet> supp(p \<bullet> [(x, y)] \<bullet> N)"
    by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> S \<open>distinctPerm p\<close> have "x \<in> supp([(x, y)] \<bullet> N)"
    by(simp add: eqvts)
  then have "([(x, y)] \<bullet> x) \<in> ([(x, y)] \<bullet> (supp([(x, y)] \<bullet> N)))"
    by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>x \<noteq> y\<close> show ?thesis by(simp add: calc_atm eqvts)
qed

lemma boundOutputChainOpenIH:
  fixes xvec :: "name list"
    and x    :: name
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"
    and yvec :: "name list"
    and y    :: name
    and B'   :: "('a, 'b, 'c) boundOutput"

assumes Eq: "\<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>x\<rparr>B) = \<lparr>\<nu>*yvec\<rparr>(\<lparr>\<nu>y\<rparr>B')"
  and   L: "length xvec = length yvec"
  and   xFreshB': "x \<sharp> B'"
  and   xFreshxvec: "x \<sharp> xvec"
  and   xFreshyvec: "x \<sharp> yvec"

shows "\<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*yvec\<rparr>([(x, y)] \<bullet> B')"
  using assms
proof(induct n=="length xvec" arbitrary: xvec yvec y B' rule: nat.induct)
  case(zero xvec yvec y B')
  have "0 = length xvec" and "length xvec = length yvec" by fact+
  moreover have "\<lparr>\<nu>*xvec\<rparr>\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>*yvec\<rparr>\<lparr>\<nu>y\<rparr>B'" by fact
  ultimately show ?case by(auto simp add: boundOutput.inject alpha)
next
  case(Suc n xvec yvec y B')
  have L: "length xvec = length yvec" and "Suc n = length xvec" by fact+
  then obtain x' xvec' y' yvec' where xEq: "xvec = x'#xvec'" and yEq: "yvec = y'#yvec'"
    and L': "length xvec' = length yvec'"
    by(cases xvec, auto, cases yvec, auto)
  have xFreshB': "x \<sharp> B'" by fact
  have "x \<sharp> xvec" and "x \<sharp> yvec" by fact+
  with xEq yEq have xineqx': "x \<noteq> x'" and xFreshxvec': "x \<sharp> xvec'"
    and xineqy': "x \<noteq> y'" and xFreshyvec': "x \<sharp> yvec'"
    by simp+
  have "\<lparr>\<nu>*xvec\<rparr>\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>*yvec\<rparr>\<lparr>\<nu>y\<rparr>B'" by fact
  with xEq yEq have Eq: "\<lparr>\<nu>x'\<rparr>(\<lparr>\<nu>*xvec'\<rparr>\<lparr>\<nu>x\<rparr>B) = \<lparr>\<nu>y'\<rparr>(\<lparr>\<nu>*yvec'\<rparr>\<lparr>\<nu>y\<rparr>B')" by simp
  have IH: "\<And>xvec yvec y B'.
            \<lbrakk>n = length xvec; \<lparr>\<nu>*xvec\<rparr>\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>*yvec\<rparr>\<lparr>\<nu>y\<rparr>B'; length xvec = length yvec; x \<sharp> B'; x \<sharp> xvec; x \<sharp> yvec\<rbrakk>
            \<Longrightarrow> \<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*yvec\<rparr>([(x, y)] \<bullet> B')" by fact
  have "Suc n = length xvec" by fact
  with xEq have L'': "n = length xvec'" by simp
  have "\<lparr>\<nu>x'\<rparr>(\<lparr>\<nu>*xvec'\<rparr>B) = \<lparr>\<nu>y'\<rparr>(\<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> B'))"
  proof(cases "x'=y'")
    assume x'eqy': "x' = y'"
    with Eq have "\<lparr>\<nu>*xvec'\<rparr>\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>*yvec'\<rparr>\<lparr>\<nu>y\<rparr>B'" by(simp add: boundOutput.inject alpha)
    then have "\<lparr>\<nu>*xvec'\<rparr>B = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> B')" using L' xFreshB' xFreshxvec' xFreshyvec' L'' by(metis IH)
    with x'eqy' show ?thesis by(simp add: boundOutput.inject alpha)
  next
    assume x'ineqy': "x' \<noteq> y'"
    with Eq have Eq': "\<lparr>\<nu>*xvec'\<rparr>\<lparr>\<nu>x\<rparr>B = \<lparr>\<nu>*([(x', y')] \<bullet> yvec')\<rparr>\<lparr>\<nu>([(x', y')] \<bullet> y)\<rparr>([(x', y')] \<bullet> B')"
      and x'FreshB': "x' \<sharp> \<lparr>\<nu>*yvec'\<rparr>\<lparr>\<nu>y\<rparr>B'"
      by(simp add: boundOutput.inject alpha eqvts)+
    from L' have "length xvec' = length ([(x', y')] \<bullet> yvec')" by simp
    moreover from xineqx' xineqy' xFreshB' have "x \<sharp> [(x', y')] \<bullet> B'" by(simp add: fresh_left calc_atm)
    moreover from xineqx' xineqy' xFreshyvec' have "x \<sharp> [(x', y')] \<bullet> yvec'" by(simp add: fresh_left calc_atm)
    ultimately have "\<lparr>\<nu>*xvec'\<rparr>B = \<lparr>\<nu>*([(x', y')] \<bullet> yvec')\<rparr>([(x, ([(x', y')] \<bullet> y))] \<bullet> [(x', y')] \<bullet> B')" using Eq' xFreshxvec' L''
      by(metis IH)
    moreover from x'FreshB' have "x' \<sharp> \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> B')"
    proof(cases "x' \<sharp> yvec'")
      assume "x' \<sharp> yvec'"
      with x'FreshB' have x'FreshB': "x' \<sharp> \<lparr>\<nu>y\<rparr>B'"
        by(simp add: fresh_def BOresChainSupp)
      show ?thesis
      proof(cases "x'=y")
        assume x'eqy: "x' = y"
        show ?thesis
        proof(cases "x=y")
          assume "x=y"
          with xFreshB' x'eqy show ?thesis by(simp add: BOresChainSupp fresh_def)
        next
          assume "x \<noteq> y"
          with \<open>x \<sharp> B'\<close> have "y \<sharp> [(x, y)] \<bullet> B'" by(simp add: fresh_left calc_atm)
          with x'eqy show ?thesis by(simp add: BOresChainSupp fresh_def)
        qed
      next
        assume x'ineqy: "x' \<noteq> y"
        with x'FreshB' have "x' \<sharp> B'" by(simp add: abs_fresh)
        with xineqx' x'ineqy have "x' \<sharp> ([(x, y)] \<bullet> B')" by(simp add: fresh_left calc_atm)
        then show ?thesis by(simp add: BOresChainSupp fresh_def)
      qed
    next
      assume "\<not>x' \<sharp> yvec'"
      then show ?thesis by(simp add: BOresChainSupp fresh_def)
    qed
    ultimately show ?thesis using x'ineqy' xineqx' xineqy'
      apply(simp add: boundOutput.inject alpha eqvts)
      apply(subst perm_compose[of "[(x', y')]"])
      by(simp add: calc_atm)
  qed
  with xEq yEq show ?case by simp
qed

lemma boundOutputPar1Dest:
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)"
  and   "xvec \<sharp>* R"
  and   "yvec \<sharp>* R"

obtains T where "P = T \<parallel> R" and "\<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
proof -
  assume "\<And>T. \<lbrakk>P = T \<parallel> R; \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q\<rbrakk> \<Longrightarrow> thesis"
  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>T. P = T \<parallel> R \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  proof(induct n arbitrary: xvec yvec M N P Q R)
    case(0 xvec yvec M N P Q R)
    have Eq: "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with Eq have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec M N P Q R)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' (Q \<parallel> R)"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have EQ: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R))"
      by simp
    from \<open>xvec \<sharp>* R\<close> \<open>yvec \<sharp>* R\<close> \<open>xvec = x#xvec'\<close> \<open>yvec = y#yvec'\<close>
    have "x \<sharp> R" and "xvec' \<sharp>* R" and "y \<sharp> R" and "yvec' \<sharp>* R" by auto
    have IH: "\<And>xvec yvec M N P Q R. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>M \<prec>' (P::('a, 'b, 'c) psi) = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R); xvec \<sharp>* R; yvec \<sharp>* R; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>T. P = T \<parallel> R \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
      by fact
    show ?case
    proof(cases "x = y")
      assume "x = y"
      with EQ have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by(simp add: boundOutput.inject alpha)
      with \<open>xvec' \<sharp>* R\<close> \<open>yvec' \<sharp>* R\<close> \<open>length xvec' = n\<close>
      obtain T where "P = T \<parallel> R" and "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(auto dest: IH)
      with \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>x=y\<close> show ?case
        by(force simp add: boundOutput.inject alpha)
    next
      assume "x \<noteq> y"
      with EQ \<open>x \<sharp> R\<close> \<open>y \<sharp> R\<close>
      have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' (([(x, y)] \<bullet> Q) \<parallel> R)"
        and xFreshQR: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by(simp add: boundOutput.inject alpha eqvts)+
      moreover from \<open>yvec' \<sharp>* R\<close> have "([(x, y)] \<bullet> yvec') \<sharp>* ([(x, y)] \<bullet> R)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>x \<sharp> R\<close> \<open>y \<sharp> R\<close> have "([(x, y)] \<bullet> yvec') \<sharp>* R" by simp
      moreover note \<open>xvec' \<sharp>* R\<close> \<open>length xvec' = n\<close>
      ultimately obtain T where "P = T \<parallel> R" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
        by(auto dest: IH)

      from A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T) = \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q))"
        by(simp add: boundOutput.inject alpha)
      moreover from xFreshQR have "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(force simp add: boundOutputFresh)
      ultimately show ?thesis using \<open>P = T \<parallel> R\<close> \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> xFreshQR
        by(force simp add: alphaBoundOutput name_swap eqvts)
    qed
  qed
  ultimately show ?thesis
    by blast
qed

lemma boundOutputPar1Dest':
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)"
  and   "xvec \<sharp>* yvec"

obtains T p where "set p \<subseteq> set xvec \<times> set yvec" and "P = T \<parallel> (p \<bullet> R)" and "\<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
proof -
  assume "\<And>p T. \<lbrakk>set p \<subseteq> set xvec \<times> set yvec; P = T \<parallel> (p \<bullet> R); \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q\<rbrakk> \<Longrightarrow> thesis"
  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>p T. set p \<subseteq> set xvec \<times> set yvec \<and> P = T \<parallel> (p \<bullet> R) \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  proof(induct n arbitrary: xvec yvec M N P Q R)
    case(0 xvec yvec M N P Q R)
    have Eq: "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with Eq have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec M N P Q R)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' (Q \<parallel> R)"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have Eq: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R))"
      by simp
    from \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>xvec \<sharp>* yvec\<close> have "x \<noteq> y" and "x \<sharp> yvec'" and "y \<sharp> xvec'" and "xvec' \<sharp>* yvec'"
      by auto
    from Eq \<open>x \<noteq> y\<close> have Eq': "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = [(x, y)] \<bullet> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
      and xFreshQR: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
      by(simp add: boundOutput.inject alpha)+
    have IH: "\<And>xvec yvec M N P Q R. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>M \<prec>' (P::('a, 'b, 'c) psi) = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R);  xvec \<sharp>* yvec; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>p T. set p \<subseteq> set xvec \<times> set yvec \<and> P = T \<parallel> (p \<bullet> R) \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
      by fact
    show ?case
    proof(cases "x \<sharp> \<lparr>\<nu>*xvec'\<rparr>M \<prec>' P")
      assume "x \<sharp> \<lparr>\<nu>*xvec'\<rparr>M \<prec>' P"
      with Eq have yFreshQR: "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by(rule boundOutputEqFresh)
      with Eq' xFreshQR have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by simp
      with \<open>xvec' \<sharp>* yvec'\<close> \<open>length xvec' = n\<close>
      obtain p T where S: "set p \<subseteq> set xvec' \<times> set yvec'" and "P = T \<parallel> (p \<bullet> R)" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(auto dest: IH)
      from yFreshQR xFreshQR have yFreshQ: "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q" and xFreshQ: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(force simp add: BOresChainSupp fresh_def boundOutput.supp psi.supp)+
      then have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q)" by (subst alphaBoundOutput) simp+
      with A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q)" by simp
      with \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> S \<open>P = T \<parallel> (p \<bullet> R)\<close> show ?case
        by auto
    next
      assume "\<not>(x \<sharp> \<lparr>\<nu>*xvec'\<rparr>M \<prec>' P)"
      then have "x \<in> supp(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P)" by(simp add: fresh_def)
      with Eq have "y \<in> supp(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R))"
        by(rule boundOutputEqSupp)
      then have "y \<sharp> yvec'" by(simp add: BOresChainSupp fresh_def)
      with Eq' \<open>x \<sharp> yvec'\<close> have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' (([(x, y)] \<bullet> Q) \<parallel> ([(x, y)] \<bullet> R))"
        by(simp add: eqvts)
      moreover note \<open>xvec' \<sharp>* yvec'\<close> \<open>length xvec' = n\<close>
      ultimately obtain p T where S: "set p \<subseteq> set xvec' \<times> set yvec'" and "P = T \<parallel> (p \<bullet> [(x, y)] \<bullet> R)" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
        by(auto dest: IH)

      from S have "set(p@[(x, y)]) \<subseteq> set(x#xvec') \<times> set(y#yvec')" by auto
      moreover from \<open>P = T \<parallel> (p \<bullet> [(x, y)] \<bullet> R)\<close>  have "P = T \<parallel> ((p @ [(x, y)]) \<bullet> R)"
        by(simp add: pt2[OF pt_name_inst])
      moreover from xFreshQR have xFreshQ: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(force simp add: BOresChainSupp fresh_def boundOutput.supp psi.supp)+
      with \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> yvec'\<close> \<open>x \<noteq> y\<close> have "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
        by(simp add: fresh_left calc_atm)
      with \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> yvec'\<close> have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q)"
        by(subst alphaBoundOutput) (assumption | simp add: eqvts)+
      with  A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q)" by simp
      ultimately show ?thesis using \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close>
        by - (rule exI[where x="p@[(x, y)]"], force)
    qed
  qed
  ultimately show ?thesis
    by blast
qed

lemma boundOutputPar2Dest:
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)"
  and   "xvec \<sharp>* Q"
  and   "yvec \<sharp>* Q"

obtains T where "P = Q \<parallel> T" and "\<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R"
proof -
  assume "\<And>T. \<lbrakk>P = Q \<parallel> T; \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R\<rbrakk> \<Longrightarrow> thesis"
  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>T. P = Q \<parallel> T \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R"
  proof(induct n arbitrary: xvec yvec M N P Q R)
    case(0 xvec yvec M N P Q R)
    have Eq: "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with Eq have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec M N P Q R)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' (Q \<parallel> R)"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have EQ: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R))"
      by simp
    from \<open>xvec \<sharp>* Q\<close> \<open>yvec \<sharp>* Q\<close> \<open>xvec = x#xvec'\<close> \<open>yvec = y#yvec'\<close>
    have "x \<sharp> Q" and "xvec' \<sharp>* Q" and "y \<sharp> Q" and "yvec' \<sharp>* Q" by auto
    have IH: "\<And>xvec yvec M N P Q R. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>M \<prec>' (P::('a, 'b, 'c) psi) = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R); xvec \<sharp>* Q; yvec \<sharp>* Q; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>T. P = Q \<parallel> T \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R"
      by fact
    show ?case
    proof(cases "x = y")
      assume "x = y"
      with EQ have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by(simp add: boundOutput.inject alpha)
      with \<open>xvec' \<sharp>* Q\<close> \<open>yvec' \<sharp>* Q\<close> \<open>length xvec' = n\<close>
      obtain T where "P = Q \<parallel> T" and "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' R"
        by(auto dest: IH)
      with \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>x=y\<close> show ?case
        by(force simp add: boundOutput.inject alpha)
    next
      assume "x \<noteq> y"
      with EQ \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close>
      have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' (Q \<parallel> ([(x, y)] \<bullet> R))"
        and xFreshQR: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by(simp add: boundOutput.inject alpha eqvts)+
      moreover from \<open>yvec' \<sharp>* Q\<close> have "([(x, y)] \<bullet> yvec') \<sharp>* ([(x, y)] \<bullet> Q)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> have "([(x, y)] \<bullet> yvec') \<sharp>* Q" by simp
      moreover note \<open>xvec' \<sharp>* Q\<close> \<open>length xvec' = n\<close>
      ultimately obtain T where "P = Q \<parallel> T" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> R)"
        by(auto dest: IH)

      from A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T) = \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> R))"
        by(simp add: boundOutput.inject alpha)
      moreover from xFreshQR have "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' R"
        by(force simp add: boundOutputFresh)
      ultimately show ?thesis using \<open>P = Q \<parallel> T\<close> \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> xFreshQR
        by(force simp add: alphaBoundOutput name_swap eqvts)
    qed
  qed
  ultimately show ?thesis
    by blast
qed

lemma boundOutputPar2Dest':
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and Q    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)"
  and   "xvec \<sharp>* yvec"

obtains T p where "set p \<subseteq> set xvec \<times> set yvec" and "P = (p \<bullet> Q) \<parallel> T" and "\<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R"
proof -
  assume "\<And>p T. \<lbrakk>set p \<subseteq> set xvec \<times> set yvec; P = (p \<bullet> Q) \<parallel> T; \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R\<rbrakk> \<Longrightarrow> thesis"
  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>p T. set p \<subseteq> set xvec \<times> set yvec \<and> P = (p \<bullet> Q) \<parallel> T \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R"
  proof(induct n arbitrary: xvec yvec M N P Q R)
    case(0 xvec yvec M N P Q R)
    have Eq: "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with Eq have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec M N P Q R)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R)\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' (Q \<parallel> R)"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have Eq: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R))"
      by simp
    from \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>xvec \<sharp>* yvec\<close> have "x \<noteq> y" and "x \<sharp> yvec'" and "y \<sharp> xvec'" and "xvec' \<sharp>* yvec'"
      by auto
    from Eq \<open>x \<noteq> y\<close> have Eq': "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = [(x, y)] \<bullet> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
      and xFreshQR: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
      by(simp add: boundOutput.inject alpha)+
    have IH: "\<And>xvec yvec M N P Q R. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>M \<prec>' (P::('a, 'b, 'c) psi) = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (Q \<parallel> R);  xvec \<sharp>* yvec; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>p T. set p \<subseteq> set xvec \<times> set yvec \<and> P = (p \<bullet> Q) \<parallel> T \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec\<rparr>N \<prec>' R"
      by fact
    show ?case
    proof(cases "x \<sharp> \<lparr>\<nu>*xvec'\<rparr>M \<prec>' P")
      assume "x \<sharp> \<lparr>\<nu>*xvec'\<rparr>M \<prec>' P"
      with Eq have yFreshQR: "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by(rule boundOutputEqFresh)
      with Eq' xFreshQR have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R)"
        by simp
      with \<open>xvec' \<sharp>* yvec'\<close> \<open>length xvec' = n\<close>
      obtain p T where S: "set p \<subseteq> set xvec' \<times> set yvec'" and "P = (p \<bullet> Q) \<parallel> T" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' R"
        by(auto dest: IH)
      from yFreshQR xFreshQR have yFreshR: "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' R" and xFreshQ: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' R"
        by(force simp add: BOresChainSupp fresh_def boundOutput.supp psi.supp)+
      then have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' R) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' R)" by (subst alphaBoundOutput) simp+
      with A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' R)" by simp
      with \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> S \<open>P = (p \<bullet> Q) \<parallel> T\<close> show ?case
        by auto
    next
      assume "\<not>(x \<sharp> \<lparr>\<nu>*xvec'\<rparr>M \<prec>' P)"
      then have "x \<in> supp(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P)" by(simp add: fresh_def)
      with Eq have "y \<in> supp(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' (Q \<parallel> R))"
        by(rule boundOutputEqSupp)
      then have "y \<sharp> yvec'" by(simp add: BOresChainSupp fresh_def)
      with Eq' \<open>x \<sharp> yvec'\<close> have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' (([(x, y)] \<bullet> Q) \<parallel> ([(x, y)] \<bullet> R))"
        by(simp add: eqvts)
      moreover note \<open>xvec' \<sharp>* yvec'\<close> \<open>length xvec' = n\<close>
      ultimately obtain p T where S: "set p \<subseteq> set xvec' \<times> set yvec'" and "P = (p \<bullet> [(x, y)] \<bullet> Q) \<parallel> T" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T = \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> R)"
        by(auto dest: IH)

      from S have "set(p@[(x, y)]) \<subseteq> set(x#xvec') \<times> set(y#yvec')" by auto
      moreover from \<open>P = (p \<bullet> [(x, y)] \<bullet> Q) \<parallel> T\<close>  have "P = ((p @ [(x, y)]) \<bullet> Q) \<parallel> T"
        by(simp add: pt2[OF pt_name_inst])
      moreover from xFreshQR have xFreshR: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' R"
        by(force simp add: BOresChainSupp fresh_def boundOutput.supp psi.supp)+
      with \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> yvec'\<close> \<open>x \<noteq> y\<close> have "y \<sharp> \<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> R)"
        by(simp add: fresh_left calc_atm)
      with \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> yvec'\<close> have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*yvec'\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> R)) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' R)"
        by(subst alphaBoundOutput) (assumption | simp add: eqvts)+
      with  A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' T) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' R)" by simp
      ultimately show ?thesis using \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close>
        by(force intro!: exI[where x="p@[(x, y)]"])
    qed
  qed
  ultimately show ?thesis
    by blast
qed

lemma boundOutputApp:
  fixes xvec :: "name list"
    and yvec :: "name list"
    and B    :: "('a::fs_name, 'b::fs_name, 'c::fs_name) boundOutput"

shows "\<lparr>\<nu>*(xvec@yvec)\<rparr>B = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>*yvec\<rparr>B)"
  by(induct xvec) auto

lemma openInjectAux:
  fixes xvec1 :: "name list"
    and x     :: name
    and xvec2 :: "name list"
    and yvec  :: "name list"

assumes "length(xvec1@x#xvec2) = length yvec"

shows "\<exists>yvec1 y yvec2. yvec = yvec1@y#yvec2 \<and> length xvec1 = length yvec1 \<and> length xvec2 = length yvec2"
  apply(rule exI[where x="take (length xvec1) yvec"])
  apply(rule exI[where x="yvec ! length xvec1"])
  apply(rule exI[where x="drop (length xvec1+1) yvec"])
  using assms by(auto simp add: id_take_nth_drop)

lemma boundOutputOpenDest:
  fixes yvec  :: "name list"
    and M     :: "'a::fs_name"
    and P     :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and xvec1 :: "name list"
    and x     :: name
    and xvec2 :: "name list"
    and N     :: 'a
    and Q     :: "('a, 'b, 'c) psi"

assumes Eq: "\<lparr>\<nu>*(xvec1@x#xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  and   "x \<sharp> xvec1"
  and   "x \<sharp> yvec"
  and   "x \<sharp> N"
  and   "x \<sharp> Q"
  and   "distinct yvec"


obtains yvec1 y yvec2 where "yvec=yvec1@y#yvec2" and "length xvec1 = length yvec1" and "length xvec2 = length yvec2"
  and "\<lparr>\<nu>*(xvec1@xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*(yvec1@yvec2)\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
proof -
  assume Ass: "\<And>yvec1 y yvec2.
        \<lbrakk>yvec = yvec1 @ y # yvec2; length xvec1 = length yvec1; length xvec2 = length yvec2;
         \<lparr>\<nu>*(xvec1 @ xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*(yvec1 @ yvec2)\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)\<rbrakk>
        \<Longrightarrow> thesis"
  from Eq have "length(xvec1@x#xvec2) = length yvec" by(rule boundOutputChainEqLength)
  then obtain yvec1 y yvec2 where A: "yvec = yvec1@y#yvec2" and "length xvec1 = length yvec1"
    and "length xvec2 = length yvec2"
    by(metis openInjectAux sym)

  from \<open>distinct yvec\<close> A have "y \<sharp> yvec2" by simp
  from A \<open>x \<sharp> yvec\<close> have "x \<sharp> yvec2" and "x \<sharp> yvec1"  by simp+
  with Eq \<open>length xvec1 = length yvec1\<close> \<open>x \<sharp> N\<close> \<open>x \<sharp> Q\<close> \<open>y \<sharp> yvec2\<close> \<open>x \<sharp> xvec1\<close> A
  have "\<lparr>\<nu>*(xvec1@xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*(yvec1@yvec2)\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
    by(force dest: boundOutputChainOpenIH simp add: boundOutputApp BOresChainSupp fresh_def boundOutput.supp eqvts)
  with \<open>length xvec1 = length yvec1\<close> \<open>length xvec2 = length yvec2\<close> A Ass show ?thesis
    by blast
qed

lemma boundOutputOpenDest':
  fixes yvec  :: "name list"
    and M     :: "'a::fs_name"
    and P     :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and xvec1 :: "name list"
    and x     :: name
    and xvec2 :: "name list"
    and N     :: 'a
    and Q     :: "('a, 'b, 'c) psi"

assumes Eq: "\<lparr>\<nu>*(xvec1@x#xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  and   "x \<sharp> xvec1"
  and   "x \<sharp> yvec"
  and   "x \<sharp> N"
  and   "x \<sharp> Q"


obtains yvec1 y yvec2 where "yvec=yvec1@y#yvec2" and "length xvec1 = length yvec1" and "length xvec2 = length yvec2"
  and "\<lparr>\<nu>*(xvec1@xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*(yvec1@[(x, y)] \<bullet> yvec2)\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
proof -
  assume Ass: "\<And>yvec1 y yvec2.
        \<lbrakk>yvec = yvec1 @ y # yvec2; length xvec1 = length yvec1; length xvec2 = length yvec2;
         \<lparr>\<nu>*(xvec1 @ xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*(yvec1 @ ([(x, y)] \<bullet> yvec2))\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)\<rbrakk>
        \<Longrightarrow> thesis"
  from Eq have "length(xvec1@x#xvec2) = length yvec" by(rule boundOutputChainEqLength)
  then obtain yvec1 y yvec2 where A: "yvec = yvec1@y#yvec2" and "length xvec1 = length yvec1"
    and "length xvec2 = length yvec2"
    by(metis openInjectAux sym)

  from A \<open>x \<sharp> yvec\<close> have "x \<sharp> yvec2" and "x \<sharp> yvec1"  by simp+
  with Eq \<open>length xvec1 = length yvec1\<close> \<open>x \<sharp> N\<close> \<open>x \<sharp> Q\<close> \<open>x \<sharp> xvec1\<close> A
  have "\<lparr>\<nu>*(xvec1@xvec2)\<rparr>M \<prec>' P = \<lparr>\<nu>*(yvec1@([(x, y)] \<bullet> yvec2))\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
    by(force dest: boundOutputChainOpenIH simp add: boundOutputApp BOresChainSupp fresh_def boundOutput.supp eqvts)
  with \<open>length xvec1 = length yvec1\<close> \<open>length xvec2 = length yvec2\<close> A Ass show ?thesis
    by blast
qed

lemma boundOutputScopeDest:
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and yvec :: "name list"
    and N    :: 'a
    and x    :: name
    and Q    :: "('a, 'b, 'c) psi"

assumes "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q"
  and   "z \<sharp> xvec"
  and   "z \<sharp> yvec"

obtains R where "P = \<lparr>\<nu>z\<rparr>R" and "\<lparr>\<nu>*xvec\<rparr>M \<prec>' R = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
proof -
  assume "\<And>R. \<lbrakk>P = \<lparr>\<nu>z\<rparr>R; \<lparr>\<nu>*xvec\<rparr>M \<prec>' R = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q\<rbrakk> \<Longrightarrow> thesis"
  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>R. P = \<lparr>\<nu>z\<rparr>R \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' R = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
  proof(induct n arbitrary: xvec yvec M N P Q z)
    case(0 xvec yvec M N P Q z)
    have Eq: "\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q" by fact
    from \<open>0 = length xvec\<close> have "xvec = []" by auto
    moreover with Eq have "yvec = []"
      by(cases yvec) auto
    ultimately show ?case using Eq
      by(simp add: boundOutput.inject)
  next
    case(Suc n xvec yvec M N P Q z)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>\<lparr>\<nu>*xvec\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec\<rparr>N \<prec>' (\<lparr>\<nu>z\<rparr>Q)\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "\<lparr>\<nu>*(x#xvec')\<rparr>M \<prec>' P = \<lparr>\<nu>*(y#yvec')\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q"
      and "yvec = y#yvec'"
      by(cases yvec) auto
    then have EQ: "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P) = \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*yvec'\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q)"
      by simp
    from \<open>z \<sharp> xvec\<close> \<open>z \<sharp> yvec\<close> \<open>xvec = x#xvec'\<close> \<open>yvec = y#yvec'\<close>
    have "z \<noteq> x" and "z \<noteq> y" and "z \<sharp> xvec'" and "z \<sharp> yvec'"
      by simp+
    have IH: "\<And>xvec yvec M N P Q z. \<lbrakk>\<lparr>\<nu>*xvec\<rparr>M \<prec>' (P::('a, 'b, 'c) psi) = \<lparr>\<nu>*yvec\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q; z \<sharp> xvec; z \<sharp> yvec; n = length xvec\<rbrakk> \<Longrightarrow> \<exists>R. P = \<lparr>\<nu>z\<rparr>R \<and> \<lparr>\<nu>*xvec\<rparr>M \<prec>' R = \<lparr>\<nu>*yvec\<rparr>N \<prec>' Q"
      by fact
    show ?case
    proof(cases "x = y")
      assume "x = y"
      with EQ have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q"
        by(simp add: boundOutput.inject alpha)
      with \<open>z \<sharp> xvec'\<close> \<open>z \<sharp> yvec'\<close> \<open>length xvec' = n\<close>
      obtain R where "P = \<lparr>\<nu>z\<rparr>R" and "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' R = \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(auto dest: IH)
      with \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>x=y\<close> show ?case
        by(force simp add: boundOutput.inject alpha)
    next
      assume "x \<noteq> y"
      with EQ \<open>z \<noteq> x\<close> \<open>z \<noteq> y\<close>
      have "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' P = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' \<lparr>\<nu>z\<rparr>([(x, y)] \<bullet> Q)"
        and xFreshzQ: "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' \<lparr>\<nu>z\<rparr>Q"
        by(simp add: boundOutput.inject alpha eqvts)+
      moreover from \<open>z \<noteq> x\<close> \<open>z \<noteq> y\<close> \<open>z \<sharp> yvec'\<close> \<open>x \<noteq> y\<close> have "z \<sharp> ([(x, y)] \<bullet> yvec')"
        by(simp add: fresh_left calc_atm)
      moreover note \<open>z \<sharp> xvec'\<close> \<open>length xvec' = n\<close>
      ultimately obtain R where "P = \<lparr>\<nu>z\<rparr>R" and A: "\<lparr>\<nu>*xvec'\<rparr>M \<prec>' R = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q)"
        by(auto dest: IH)

      from A have "\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec'\<rparr>M \<prec>' R) = \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> N) \<prec>' ([(x, y)] \<bullet> Q))"
        by(simp add: boundOutput.inject alpha)
      moreover from xFreshzQ \<open>z \<noteq> x\<close> have "x \<sharp> \<lparr>\<nu>*yvec'\<rparr>N \<prec>' Q"
        by(simp add: boundOutputFresh abs_fresh)
      ultimately show ?thesis using \<open>P = \<lparr>\<nu>z\<rparr>R\<close> \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> xFreshzQ
        by(force simp add: alphaBoundOutput name_swap eqvts)
    qed
  qed
  ultimately show ?thesis
    by blast
qed

nominal_datatype ('a, 'b, 'c) residual =
  RIn "'a::fs_name" 'a "('a, 'b::fs_name, 'c::fs_name) psi"
  | RBrIn "'a::fs_name" 'a "('a, 'b::fs_name, 'c::fs_name) psi"
  | ROut 'a "('a, 'b, 'c) boundOutput"
  | RBrOut 'a "('a, 'b, 'c) boundOutput"
  | RTau "('a, 'b, 'c) psi"

nominal_datatype 'a action = In "'a::fs_name" 'a        (\<open>_\<lparr>_\<rparr>\<close> [90, 90] 90)
  | BrIn "'a::fs_name" 'a              (\<open>\<questiondown>_\<lparr>_\<rparr>\<close> [90, 90] 90)
  | Out "'a::fs_name" "name list" 'a   (\<open>_\<lparr>\<nu>*_\<rparr>\<langle>_\<rangle>\<close> [90, 90, 90] 90)
  | BrOut "'a::fs_name" "name list" 'a (\<open>\<exclamdown>_\<lparr>\<nu>*_\<rparr>\<langle>_\<rangle>\<close> [90, 90, 90] 90)
  | Tau                                (\<open>\<tau>\<close> 90)

nominal_primrec bn :: "('a::fs_name) action \<Rightarrow> name list"
  where
    "bn (M\<lparr>N\<rparr>) = []"
  | "bn (\<questiondown>M\<lparr>N\<rparr>) = []"
  | "bn (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) = xvec"
  | "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) = xvec"
  | "bn (\<tau>) = []"
  by(rule TrueI)+

lemma bnEqvt[eqvt]:
  fixes p :: "name prm"
    and \<alpha> :: "('a::fs_name) action"

shows "(p \<bullet> bn \<alpha>) = bn(p \<bullet> \<alpha>)"
  by(nominal_induct \<alpha> rule: action.strong_induct) auto

nominal_primrec create_residual :: "('a::fs_name) action \<Rightarrow> ('a, 'b::fs_name, 'c::fs_name) psi \<Rightarrow> ('a, 'b, 'c) residual" (\<open>_ \<prec> _\<close> [80, 80] 80)
  where
    "(M\<lparr>N\<rparr>) \<prec> P = RIn M N P"
  | "(\<questiondown>M\<lparr>N\<rparr>) \<prec> P = RBrIn M N P"
  | "M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P = ROut M (\<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
  | "(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<prec> P = RBrOut M (\<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
  | "\<tau> \<prec> P = (RTau P)"
  by(rule TrueI)+

nominal_primrec subject :: "('a::fs_name) action \<Rightarrow> 'a option"
  where
    "subject (M\<lparr>N\<rparr>) = Some M"
  | "subject (\<questiondown>M\<lparr>N\<rparr>) = Some M"
  | "subject (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) = Some M"
  | "subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) = Some M"
  | "subject (\<tau>) = None"
  by(rule TrueI)+

nominal_primrec object :: "('a::fs_name) action \<Rightarrow> 'a option"
  where
    "object (M\<lparr>N\<rparr>) = Some N"
  | "object (\<questiondown>M\<lparr>N\<rparr>) = Some N"
  | "object (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) = Some N"
  | "object (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) = Some N"
  | "object (\<tau>) = None"
  by(rule TrueI)+

lemma optionFreshChain[simp]:
  fixes xvec :: "name list"
    and X    :: "name set"

shows "xvec \<sharp>* (Some x) = xvec \<sharp>* x"
  and "X \<sharp>* (Some x) = X \<sharp>* x"
  and "xvec \<sharp>* None"
  and "X \<sharp>* None"
  by(auto simp add: fresh_star_def fresh_some fresh_none)

lemmas [simp] = fresh_some fresh_none

lemma actionFresh[simp]:
  fixes x :: name
    and \<alpha> :: "('a::fs_name) action"

shows "(x \<sharp> \<alpha>)  = (x \<sharp> (subject \<alpha>) \<and> x \<sharp> (bn \<alpha>) \<and> x \<sharp> (object \<alpha>))"
  by(nominal_induct \<alpha> rule: action.strong_induct) auto

lemma actionFreshChain[simp]:
  fixes X    :: "name set"
    and \<alpha>    :: "('a::fs_name) action"
    and xvec :: "name list"

shows "(X \<sharp>* \<alpha>) = (X \<sharp>* (subject \<alpha>) \<and> X \<sharp>* (bn \<alpha>) \<and> X \<sharp>* (object \<alpha>))"
  and "(xvec \<sharp>* \<alpha>) = (xvec \<sharp>* (subject \<alpha>) \<and> xvec \<sharp>* (bn \<alpha>) \<and> xvec \<sharp>* (object \<alpha>))"
  by(auto simp add: fresh_star_def)

lemma subjectEqvt[eqvt]:
  fixes p :: "name prm"
    and \<alpha> :: "('a::fs_name) action"

shows "(p \<bullet> subject \<alpha>) = subject(p \<bullet> \<alpha>)"
  by(nominal_induct \<alpha> rule: action.strong_induct) auto

lemma okjectEqvt[eqvt]:
  fixes p :: "name prm"
    and \<alpha> :: "('a::fs_name) action"

shows "(p \<bullet> object \<alpha>) = object(p \<bullet> \<alpha>)"
  by(nominal_induct \<alpha> rule: action.strong_induct) auto

lemma create_residualEqvt[eqvt]:
  fixes p :: "name prm"
    and \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"

shows "(p \<bullet> (\<alpha> \<prec> P)) = (p \<bullet> \<alpha>) \<prec> (p \<bullet> P)"
  by(nominal_induct \<alpha> rule: action.strong_induct)
    (auto simp add: eqvts)

lemma residualFresh:
  fixes x :: name
    and \<alpha> :: "'a::fs_name action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"

shows "(x \<sharp> (\<alpha> \<prec> P)) = (x \<sharp> (subject \<alpha>) \<and> (x \<in> (set(bn(\<alpha>))) \<or> (x \<sharp> object(\<alpha>) \<and> x \<sharp> P)))"
  by(nominal_induct \<alpha> rule: action.strong_induct)
    (auto simp add: fresh_some fresh_none boundOutputFresh)

lemma residualFresh2[simp]:
  fixes x :: name
    and \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"

assumes "x \<sharp> \<alpha>"
  and   "x \<sharp> P"

shows "x \<sharp> \<alpha> \<prec> P"
  using assms
  by(nominal_induct \<alpha> rule: action.strong_induct) auto

lemma residualFreshChain2[simp]:
  fixes xvec :: "name list"
    and X    :: "name set"
    and \<alpha>    :: "('a::fs_name) action"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"

shows "\<lbrakk>xvec \<sharp>* \<alpha>; xvec \<sharp>* P\<rbrakk> \<Longrightarrow> xvec \<sharp>* (\<alpha> \<prec> P)"
  and "\<lbrakk>X \<sharp>* \<alpha>; X \<sharp>* P\<rbrakk> \<Longrightarrow> X \<sharp>* (\<alpha> \<prec> P)"
  by(auto simp add: fresh_star_def)

lemma residualFreshSimp[simp]:
  fixes x :: name
    and M :: "'a::fs_name"
    and N :: 'a
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"


shows "x \<sharp> (M\<lparr>N\<rparr> \<prec> P) = (x \<sharp> M \<and> x \<sharp> N \<and> x \<sharp> P)"
  and "x \<sharp> (\<questiondown> M\<lparr>N\<rparr> \<prec> P) = (x \<sharp> M \<and> x \<sharp> N \<and> x \<sharp> P)"
  and "x \<sharp> (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P) = (x \<sharp> M \<and> x \<sharp> (\<lparr>\<nu>*xvec\<rparr>(N \<prec>' P)))"
  and "x \<sharp> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P) = (x \<sharp> M \<and> x \<sharp> (\<lparr>\<nu>*xvec\<rparr>(N \<prec>' P)))"
  and "x \<sharp> (\<tau> \<prec> P) = (x \<sharp> P)"
  by(auto simp add: residualFresh)

lemma residualInject':

shows "(\<alpha> \<prec> P = RIn M N Q) = (P = Q \<and> \<alpha> = M\<lparr>N\<rparr>)"
  and "(\<alpha> \<prec> P = RBrIn M N Q) = (P = Q \<and> \<alpha> = \<questiondown>M\<lparr>N\<rparr>)"
  and "(\<alpha> \<prec> P = ROut M B) = (\<exists>xvec N. \<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
  and "(\<alpha> \<prec> P = RBrOut M B) = (\<exists>xvec N. \<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
  and "(\<alpha> \<prec> P = RTau Q) = (\<alpha> = \<tau> \<and> P = Q)"
  and "(RIn M N Q = \<alpha> \<prec> P) = (P = Q \<and> \<alpha> = M\<lparr>N\<rparr>)"
  and "(RBrIn M N Q = \<alpha> \<prec> P) = (P = Q \<and> \<alpha> = \<questiondown>M\<lparr>N\<rparr>)"
  and "(ROut M B = \<alpha> \<prec> P) = (\<exists>xvec N. \<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
  and "(RBrOut M B = \<alpha> \<prec> P) = (\<exists>xvec N. \<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
  and "(RTau Q = \<alpha> \<prec> P) = (\<alpha> = \<tau> \<and> P = Q)"
proof -
  show "(\<alpha> \<prec> P = RIn M N Q) = (P = Q \<and> \<alpha> = M\<lparr>N\<rparr>)"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(\<alpha> \<prec> P = RBrIn M N Q) = (P = Q \<and> \<alpha> = \<questiondown>M\<lparr>N\<rparr>)"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(\<alpha> \<prec> P = ROut M B) = (\<exists>xvec N. \<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(\<alpha> \<prec> P = RBrOut M B) = (\<exists>xvec N. \<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show  "(\<alpha> \<prec> P = RTau Q) = (\<alpha> = \<tau> \<and> P = Q)"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(RIn M N Q = \<alpha> \<prec> P) = (P = Q \<and> \<alpha> = M\<lparr>N\<rparr>)"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(RBrIn M N Q = \<alpha> \<prec> P) = (P = Q \<and> \<alpha> = \<questiondown>M\<lparr>N\<rparr>)"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(ROut M B = \<alpha> \<prec> P) = (\<exists>xvec N. \<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show "(RBrOut M B = \<alpha> \<prec> P) = (\<exists>xvec N. \<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<and> B = \<lparr>\<nu>*xvec\<rparr>(N \<prec>' P))"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
next
  show  "(RTau Q = \<alpha> \<prec> P) = (\<alpha> = \<tau> \<and> P = Q)"
    by(nominal_induct \<alpha> rule: action.strong_induct)
      (auto simp add: residual.inject action.inject)
qed

lemma residualFreshChainSimp[simp]:
  fixes xvec :: "name list"
    and X    :: "name set"
    and M    :: "'a::fs_name"
    and N    :: 'a
    and yvec :: "name list"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"

shows "xvec \<sharp>* (M\<lparr>N\<rparr> \<prec> P) = (xvec \<sharp>* M \<and> xvec \<sharp>* N \<and> xvec \<sharp>* P)"
  and "xvec \<sharp>* (\<questiondown>M\<lparr>N\<rparr> \<prec> P) = (xvec \<sharp>* M \<and> xvec \<sharp>* N \<and> xvec \<sharp>* P)"
  and "xvec \<sharp>* (M\<lparr>\<nu>*yvec\<rparr>\<langle>N\<rangle> \<prec> P) = (xvec \<sharp>* M \<and> xvec \<sharp>* (\<lparr>\<nu>*yvec\<rparr>(N \<prec>' P)))"
  and "xvec \<sharp>* (\<exclamdown>M\<lparr>\<nu>*yvec\<rparr>\<langle>N\<rangle> \<prec> P) = (xvec \<sharp>* M \<and> xvec \<sharp>* (\<lparr>\<nu>*yvec\<rparr>(N \<prec>' P)))"
  and "xvec \<sharp>* (\<tau> \<prec> P) = (xvec \<sharp>* P)"
  and "X \<sharp>* (M\<lparr>N\<rparr> \<prec> P) = (X \<sharp>* M \<and> X \<sharp>* N \<and> X \<sharp>* P)"
  and "X \<sharp>* (\<questiondown>M\<lparr>N\<rparr> \<prec> P) = (X \<sharp>* M \<and> X \<sharp>* N \<and> X \<sharp>* P)"
  and "X \<sharp>* (M\<lparr>\<nu>*yvec\<rparr>\<langle>N\<rangle> \<prec> P) = (X \<sharp>* M \<and> X \<sharp>* (\<lparr>\<nu>*yvec\<rparr>(N \<prec>' P)))"
  and "X \<sharp>* (\<exclamdown>M\<lparr>\<nu>*yvec\<rparr>\<langle>N\<rangle> \<prec> P) = (X \<sharp>* M \<and> X \<sharp>* (\<lparr>\<nu>*yvec\<rparr>(N \<prec>' P)))"
  and "X \<sharp>* (\<tau> \<prec> P) = (X \<sharp>* P)"
  by(auto simp add: fresh_star_def)

lemma residualFreshChainSimp2[simp]:
  fixes xvec :: "name list"
    and X    :: "name set"
    and M    :: "'a::fs_name"
    and N    :: 'a
    and yvec :: "name list"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"

shows "xvec \<sharp>* (RIn M N P) = (xvec \<sharp>* M \<and> xvec \<sharp>* N \<and> xvec \<sharp>* P)"
  and "xvec \<sharp>* (RBrIn M N P) = (xvec \<sharp>* M \<and> xvec \<sharp>* N \<and> xvec \<sharp>* P)"
  and "xvec \<sharp>* (ROut M B) = (xvec \<sharp>* M \<and> xvec \<sharp>* B)"
  and "xvec \<sharp>* (RBrOut M B) = (xvec \<sharp>* M \<and> xvec \<sharp>* B)"
  and "xvec \<sharp>* (RTau P) = (xvec \<sharp>* P)"
  and "X \<sharp>* (RIn M N P) = (X \<sharp>* M \<and> X \<sharp>* N \<and> X \<sharp>* P)"
  and "X \<sharp>* (RBrIn M N P) = (X \<sharp>* M \<and> X \<sharp>* N \<and> X \<sharp>* P)"
  and "X \<sharp>* (ROut M B) = (X \<sharp>* M \<and> X \<sharp>* B)"
  and "X \<sharp>* (RBrOut M B) = (X \<sharp>* M \<and> X \<sharp>* B)"
  and "X \<sharp>* (RTau P) = (X \<sharp>* P)"
  by(auto simp add: fresh_star_def)

lemma freshResidual3[dest]:
  fixes x :: name
    and \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"

assumes "x \<sharp> bn \<alpha>"
  and   "x \<sharp> \<alpha> \<prec> P"

shows "x \<sharp> \<alpha>" and "x \<sharp> P"
  using assms
  by(nominal_induct rule: action.strong_induct) auto

lemma freshResidualChain3[dest]:
  fixes xvec :: "name list"
    and \<alpha>    :: "('a::fs_name) action"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"

assumes "xvec \<sharp>* (\<alpha> \<prec> P)"
  and   "xvec \<sharp>* bn \<alpha>"

shows "xvec \<sharp>* \<alpha>" and "xvec \<sharp>* P"
  using assms
  by(nominal_induct rule: action.strong_induct) auto

lemma freshResidual4[dest]:
  fixes x :: name
    and \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"

assumes "x \<sharp> \<alpha> \<prec> P"

shows "x \<sharp> subject \<alpha>"
  using assms
  by(nominal_induct rule: action.strong_induct) auto

lemma freshResidualChain4[dest]:
  fixes xvec :: "name list"
    and \<alpha>    :: "('a::fs_name) action"
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"

assumes "xvec \<sharp>* (\<alpha> \<prec> P)"

shows "xvec \<sharp>* subject \<alpha>"
  using assms
  by(nominal_induct rule: action.strong_induct) auto

lemma alphaOutputResidual:
  fixes M    :: "'a::fs_name"
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and p    :: "name prm"

assumes "(p \<bullet> xvec) \<sharp>* N"
  and   "(p \<bullet> xvec) \<sharp>* P"
  and   "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)"
  and   "set xvec \<subseteq> set yvec"

shows "M\<lparr>\<nu>*yvec\<rparr>\<langle>N\<rangle> \<prec> P = M\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P)"
  and "\<exclamdown>M\<lparr>\<nu>*yvec\<rparr>\<langle>N\<rangle> \<prec> P = \<exclamdown>M\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P)"
  using assms
  by(simp add: boundOutputChainAlpha'')+

lemmas[simp del] = create_residual.simps

lemma residualInject'':

assumes "bn \<alpha> = bn \<beta>"

shows "(\<alpha> \<prec> P = \<beta> \<prec> Q) = (\<alpha> = \<beta> \<and> P = Q)"
  using assms
  by(nominal_induct \<alpha> rule: action.strong_induct)
    (force simp add: residual.inject create_residual.simps residualInject' action.inject boundOutput.inject)+

lemmas residualInject = residual.inject create_residual.simps residualInject' residualInject''

lemma bnFreshResidual[simp]:
  fixes \<alpha> :: "('a::fs_name) action"

shows "(bn \<alpha>) \<sharp>* (\<alpha> \<prec> P) = bn \<alpha> \<sharp>* (subject \<alpha>)"
  by(nominal_induct \<alpha> rule: action.strong_induct)
    (auto simp add: residualFresh fresh_some fresh_star_def)

lemma actionCases[case_names cInput cBrInput cOutput cBrOutput cTau]:
  fixes \<alpha> :: "('a::fs_name) action"

assumes "\<And>M N. \<alpha> = M\<lparr>N\<rparr> \<Longrightarrow> Prop"
  and   "\<And>M N. \<alpha> = \<questiondown>M\<lparr>N\<rparr> \<Longrightarrow> Prop"
  and   "\<And>M xvec N. \<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<Longrightarrow> Prop"
  and   "\<And>M xvec N. \<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<Longrightarrow> Prop"
  and   "\<alpha> = \<tau> \<Longrightarrow> Prop"

shows Prop
  using assms
  by(nominal_induct \<alpha> rule: action.strong_induct) auto

lemma actionPar1Dest:
  fixes \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and \<beta> :: "('a::fs_name) action"
    and Q :: "('a, 'b, 'c) psi"
    and R :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> (Q \<parallel> R)"
  and   "bn \<alpha> \<sharp>* bn \<beta>"

obtains T p where "set p \<subseteq> set(bn \<alpha>) \<times> set(bn \<beta>)" and "P = T \<parallel> (p \<bullet> R)" and "\<alpha> \<prec> T = \<beta> \<prec> Q"
  using assms
  by(cases rule: actionCases[where \<alpha>=\<alpha>])
    (force simp add: residualInject dest: boundOutputPar1Dest')+

lemma actionPar2Dest:
  fixes \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and \<beta> :: "('a::fs_name) action"
    and Q :: "('a, 'b, 'c) psi"
    and R :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> (Q \<parallel> R)"
  and   "bn \<alpha> \<sharp>* bn \<beta>"

obtains T p where "set p \<subseteq> set(bn \<alpha>) \<times> set(bn \<beta>)" and "P = (p \<bullet> Q) \<parallel> T" and "\<alpha> \<prec> T = \<beta> \<prec> R"
  using assms
  by(cases rule: actionCases[where \<alpha>=\<alpha>])
    (force simp add: simp add: residualInject dest: boundOutputPar2Dest')+

lemma actionScopeDest:
  fixes \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"
  fixes \<beta> :: "('a::fs_name) action"
    and x :: name
    and Q :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> \<lparr>\<nu>x\<rparr>Q"
  and   "x \<sharp> bn \<alpha>"
  and   "x \<sharp> bn \<beta>"

obtains R where "P = \<lparr>\<nu>x\<rparr>R" and "\<alpha> \<prec> R = \<beta> \<prec> Q"
  using assms boundOutputScopeDest
  by(cases rule: actionCases[where \<alpha>=\<alpha>]) (force simp add: residualInject)+

lemma emptyFreshName:
  fixes x :: name
    and M :: "'a::fs_name"

assumes "supp M = ({}::name set)"

shows "x \<sharp> M"
  using assms
  by(auto simp add: fresh_def)

lemma emptyFresh:
  fixes xvec :: "name list"
    and M    :: "'a::fs_name"

assumes "supp M = ({}::name set)"

shows "xvec \<sharp>* M"
  using assms by (induct xvec, auto simp add: emptyFreshName)

lemma permEmptyEq:
  fixes p :: "name prm"
    and M :: "'a::fs_name"

assumes suppE: "supp M = ({}::name set)"

shows "(p \<bullet> M) = M"
proof(induct p)
  case Nil
  then show ?case by simp
next
  case(Cons a p)
  have "p \<bullet> M = M" by(rule Cons)
  then have "([a] \<bullet> p \<bullet> M) = [a] \<bullet> M" by simp
  then have "((a#p) \<bullet> M) = [a] \<bullet> M"
    by(simp add: pt2[OF pt_name_inst, symmetric])
  then show ?case using suppE perm_fresh_fresh
    by(cases a) (simp add: fresh_def)
qed

abbreviation
  outputJudge (\<open>_\<langle>_\<rangle>\<close> [110, 110] 110) where "M\<langle>N\<rangle> \<equiv> M\<lparr>\<nu>*([])\<rparr>\<langle>N\<rangle>"

abbreviation
  brOutputJudge (\<open>\<exclamdown>_\<langle>_\<rangle>\<close> [110, 110] 110) where "\<exclamdown>M\<langle>N\<rangle> \<equiv> \<exclamdown>M\<lparr>\<nu>*([])\<rparr>\<langle>N\<rangle>"

declare [[unify_trace_bound=100]]

locale env = substPsi substTerm substAssert substCond +
  assertion SCompose' SImp' SBottom' SChanEq' SOutCon' SInCon'
  for substTerm :: "('a::fs_name) \<Rightarrow> name list \<Rightarrow> 'a::fs_name list \<Rightarrow> 'a"
    and substAssert :: "('b::fs_name) \<Rightarrow> name list \<Rightarrow> 'a::fs_name list \<Rightarrow> 'b"
    and substCond :: "('c::fs_name) \<Rightarrow> name list \<Rightarrow> 'a::fs_name list \<Rightarrow> 'c"
    and SCompose'  :: "'b \<Rightarrow> 'b \<Rightarrow> 'b"
    and SImp'      :: "'b \<Rightarrow> 'c \<Rightarrow> bool"
    and SBottom'   :: 'b
    and SChanEq'   :: "'a \<Rightarrow> 'a \<Rightarrow> 'c"
    and SOutCon'   :: "'a \<Rightarrow> 'a \<Rightarrow> 'c"
    and SInCon'    :: "'a \<Rightarrow> 'a \<Rightarrow> 'c"
begin
notation SCompose' (infixr \<open>\<otimes>\<close> 90)
notation SImp' (\<open>_ \<turnstile> _\<close> [85, 85] 85)
notation FrameImp (\<open>_ \<turnstile>\<^sub>F _\<close> [85, 85] 85)
abbreviation
  FBottomJudge (\<open>\<bottom>\<^sub>F\<close> 90) where "\<bottom>\<^sub>F \<equiv> (FAssert SBottom')"
notation SChanEq' (\<open>_ \<leftrightarrow> _\<close> [90, 90] 90)
notation SOutCon' (\<open>_ \<preceq> _\<close> [90, 90] 90)
notation SInCon' (\<open>_ \<succeq> _\<close> [90, 90] 90)
notation substTerm (\<open>_[_::=_]\<close> [100, 100, 100] 100)
notation subs (\<open>_[_::=_]\<close> [100, 100, 100] 100)
notation AssertionStatEq (\<open>_ \<simeq> _\<close> [80, 80] 80)
notation FrameStatEq (\<open>_ \<simeq>\<^sub>F _\<close> [80, 80] 80)
notation SBottom' (\<open>\<one>\<close> 190)
abbreviation insertAssertion' (\<open>insertAssertion\<close>) where "insertAssertion' \<equiv> assertionAux.insertAssertion (\<otimes>)"

inductive semantics :: "'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> ('a, 'b, 'c) residual \<Rightarrow> bool"
  (\<open>_ \<rhd> _ \<longmapsto> _\<close> [50, 50, 50] 50)
  where
    cInput:  "\<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N; xvec \<sharp>* Tvec;
            length xvec = length Tvec;
            xvec \<sharp>* \<Psi>; xvec \<sharp>* M; xvec \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec]"
  | cBrInput:"\<lbrakk>\<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N; xvec \<sharp>* Tvec;
            length xvec = length Tvec;
            xvec \<sharp>* \<Psi>; xvec \<sharp>* M; xvec \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> \<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec]"
  | Output: "\<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> M\<langle>N\<rangle>.P \<longmapsto> K\<langle>N\<rangle> \<prec> P"
  | BrOutput: "\<lbrakk>\<Psi> \<turnstile> M \<preceq> K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> M\<langle>N\<rangle>.P \<longmapsto> \<exclamdown>K\<langle>N\<rangle> \<prec> P"
  | Case:   "\<lbrakk>\<Psi> \<rhd> P \<longmapsto> Rs; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> Cases Cs \<longmapsto> Rs"
  | cPar1:   "\<lbrakk>(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<alpha> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
             A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* P'; distinct(bn \<alpha>);
             bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* \<Psi>\<^sub>Q; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* (subject \<alpha>)\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> (P' \<parallel> Q)"
  | cPar2:   "\<lbrakk>(\<Psi> \<otimes> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* Q'; distinct(bn \<alpha>);
             bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* (subject \<alpha>)\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> (P \<parallel> Q')"
  | cComm1:   "\<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
             A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
             A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec;
             A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
             A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec; distinct xvec;
             xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
             xvec \<sharp>* Q; xvec \<sharp>* K\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto> \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')"
  | cComm2:   "\<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
             A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
             A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec;
             A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
             A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec; distinct xvec;
             xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
             xvec \<sharp>* Q; xvec \<sharp>* K\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto> \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')"
  | cBrMerge: "\<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
             A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
             A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;
             A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
             A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
             A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')"
    (* Removed: A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* K; *)
  | cBrComm1:  "\<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
             A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
             A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec;
             A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
             A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
             A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec; distinct xvec;
             xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
             xvec \<sharp>* Q; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')"
  | cBrComm2:  "\<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
             A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
             A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec;
             A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
             A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
             A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec; distinct xvec;
             xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
             xvec \<sharp>* Q; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
             \<Psi> \<rhd> P \<parallel> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')"
  | cBrClose: "\<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
            x \<in> supp M;
            distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P;
            xvec \<sharp>* M;
            x \<sharp> \<Psi>; x \<sharp> xvec\<rbrakk> \<Longrightarrow>
            \<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto> \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')"
  | cOpen:    "\<lbrakk>\<Psi> \<rhd> P \<longmapsto> M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; x \<sharp> xvec; x \<sharp> yvec; x \<sharp> M; x \<sharp> \<Psi>;
              distinct xvec; distinct yvec;
              xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* yvec; yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M\<rbrakk> \<Longrightarrow>
              \<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto> M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
  | cBrOpen:    "\<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; x \<sharp> xvec; x \<sharp> yvec; x \<sharp> M; x \<sharp> \<Psi>;
              distinct xvec; distinct yvec;
              xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* yvec; yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M\<rbrakk> \<Longrightarrow>
              \<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
  | cScope:  "\<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; x \<sharp> \<Psi>; x \<sharp> \<alpha>; bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* (subject \<alpha>); distinct(bn \<alpha>)\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> (\<lparr>\<nu>x\<rparr>P')"
  | Bang:    "\<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto> Rs; guarded P\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> !P \<longmapsto> Rs"

abbreviation
  semanticsBottomJudge (\<open>_ \<longmapsto> _\<close> [50, 50] 50) where "P \<longmapsto> Rs \<equiv> \<one> \<rhd> P \<longmapsto> Rs"

equivariance env.semantics

nominal_inductive2 env.semantics
  avoids cInput: "set xvec"
  | cBrInput: "set xvec"
  | cPar1: "set A\<^sub>Q \<union> set(bn \<alpha>)"
  | cPar2: "set A\<^sub>P \<union> set(bn \<alpha>)"
  | cComm1: "set A\<^sub>P \<union> set A\<^sub>Q \<union> set xvec"
  | cComm2: "set A\<^sub>P \<union> set A\<^sub>Q \<union> set xvec"
  | cBrMerge: "set A\<^sub>P \<union> set A\<^sub>Q"
  | cBrComm1: "set A\<^sub>P \<union> set A\<^sub>Q \<union> set xvec"
  | cBrComm2: "set A\<^sub>P \<union> set A\<^sub>Q \<union> set xvec"
  | cBrClose: "{x} \<union> set xvec"
  | cOpen:  "{x} \<union> set xvec \<union> set yvec"
  | cBrOpen:  "{x} \<union> set xvec \<union> set yvec"
  | cScope: "{x} \<union> set(bn \<alpha>)"
                      apply -
                      apply(force intro: substTerm.subst4Chain subst4Chain simp add: abs_fresh residualFresh)+
                apply(force intro: substTerm.subst4Chain subst4Chain simp add: abs_fresh residualFresh boundOutputFresh boundOutputFreshSet fresh_star_def resChainFresh)+
  done

lemma nilTrans1:
  fixes \<Psi>   :: 'b
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> \<zero> \<longmapsto> M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P"

shows "False"
  using assms
  apply -
  by (ind_cases "\<Psi> \<rhd> \<zero> \<longmapsto> M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P")

lemma nilTrans1':
  fixes \<Psi>   :: 'b
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> \<zero> \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P"

shows "False"
  using assms
  apply -
  by (ind_cases "\<Psi> \<rhd> \<zero> \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P")

lemma nilTrans2:
  fixes \<Psi>   :: 'b
    and Rs   :: "('a, 'b, 'c) residual"

assumes "\<Psi> \<rhd> \<zero> \<longmapsto> Rs"

shows "False"
  using assms
  apply(cases rule: semantics.cases)
  by(auto simp add: residualInject)+

lemma nilTrans3:
  fixes \<Psi>   :: 'b
    and M    :: 'a
    and M'   :: 'a
    and xvec :: "name list"
    and yvec :: "name list"
    and N    :: 'a
    and N'   :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and P'   :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> M'\<lparr>\<nu>*yvec\<rparr>\<langle>N'\<rangle> \<prec> P'"

shows "False"
  using assms
  apply -
  by(ind_cases "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> M'\<lparr>\<nu>*yvec\<rparr>\<langle>N'\<rangle> \<prec> P'") (auto simp add: residualInject)

lemma nilTrans3':
  fixes \<Psi>   :: 'b
    and M    :: 'a
    and M'   :: 'a
    and xvec :: "name list"
    and yvec :: "name list"
    and N    :: 'a
    and N'   :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and P'   :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> \<exclamdown>M'\<lparr>\<nu>*yvec\<rparr>\<langle>N'\<rangle> \<prec> P'"

shows "False"
  using assms
  apply -
  by(ind_cases "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> \<exclamdown>M'\<lparr>\<nu>*yvec\<rparr>\<langle>N'\<rangle> \<prec> P'") (auto simp add: residualInject)

lemma nilTrans4:
  fixes \<Psi>   :: 'b
    and Rs   :: "('a, 'b, 'c) residual"

assumes "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<tau> \<prec> P'"

shows "False"
  using assms
  apply(cases rule: semantics.cases)
  by(auto simp add: residualInject)+

lemma nilTrans5:
  fixes \<Psi>    :: 'b
  fixes \<Psi>'   :: 'b
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> \<lbrace>\<Psi>'\<rbrace> \<longmapsto> M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P"

shows "False"
  using assms
  apply -
  by(ind_cases "\<Psi> \<rhd> \<lbrace>\<Psi>'\<rbrace> \<longmapsto> M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P")

lemma nilTrans5':
  fixes \<Psi>    :: 'b
  fixes \<Psi>'   :: 'b
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> \<lbrace>\<Psi>'\<rbrace> \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P"

shows "False"
  using assms
  apply -
  by(ind_cases "\<Psi> \<rhd> \<lbrace>\<Psi>'\<rbrace> \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P")

lemma nilTrans6:
  fixes \<Psi>   :: 'b
    and Rs   :: "('a, 'b, 'c) residual"

assumes "\<Psi> \<rhd> \<lbrace>\<Psi>'\<rbrace> \<longmapsto> Rs"

shows "False"
  using assms
  apply(cases rule: semantics.cases)
  by(auto simp add: residualInject)+

lemma nilTrans[dest]:
  fixes \<Psi>   :: 'b
    and Rs   :: "('a, 'b, 'c) residual"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and K    :: 'a
    and yvec :: "name list"
    and N'   :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and CsP  :: "('c \<times>  ('a, 'b, 'c) psi) list"
    and \<Psi>'   :: 'b

shows "\<Psi> \<rhd> \<zero> \<longmapsto> Rs \<Longrightarrow> False"
  and "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>K\<lparr>\<nu>*yvec\<rparr>\<langle>N'\<rangle> \<prec> P' \<Longrightarrow> False"
  and "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<exclamdown>K\<lparr>\<nu>*yvec\<rparr>\<langle>N'\<rangle> \<prec> P' \<Longrightarrow> False"
  and "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<tau> \<prec> P' \<Longrightarrow> False"
  and "\<Psi> \<rhd> M\<langle>N\<rangle>.P \<longmapsto>K\<lparr>N'\<rparr> \<prec> P' \<Longrightarrow> False"
  and "\<Psi> \<rhd> M\<langle>N\<rangle>.P \<longmapsto>\<questiondown>K\<lparr>N'\<rparr> \<prec> P' \<Longrightarrow> False"
  and "\<Psi> \<rhd> M\<langle>N\<rangle>.P \<longmapsto>\<tau> \<prec> P' \<Longrightarrow> False"
  and "\<Psi> \<rhd> \<lbrace>\<Psi>'\<rbrace> \<longmapsto> Rs \<Longrightarrow> False"
         apply -
         apply(rule nilTrans2)
         apply assumption
        apply(cases rule: semantics.cases) apply(force simp add: residualInject)+
       apply(cases rule: semantics.cases) apply(force simp add: residualInject)+
      apply(rule nilTrans4)
      apply assumption
     apply(cases rule: semantics.cases) apply(force simp add: residualInject)+
    apply(cases rule: semantics.cases) apply(force simp add: residualInject)+
   apply(cases rule: semantics.cases) apply(force simp add: residualInject)+
  apply(rule nilTrans6)
  by assumption

lemma residualEq:
  fixes \<alpha> :: "'a action"
    and P :: "('a, 'b, 'c) psi"
    and \<beta> :: "'a action"
    and Q :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> Q"
  and   "bn \<alpha> \<sharp>* (bn \<beta>)"
  and   "distinct(bn \<alpha>)"
  and   "distinct(bn \<beta>)"
  and   "bn \<alpha> \<sharp>* (\<alpha> \<prec> P)"
  and   "bn \<beta> \<sharp>* (\<beta> \<prec> Q)"

obtains p where "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" and "distinctPerm p" and "\<beta> = p \<bullet> \<alpha>" and "Q = p \<bullet> P" and "bn \<alpha> \<sharp>* \<beta>" and "bn \<alpha> \<sharp>* Q" and "bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>" and "bn(p \<bullet> \<alpha>) \<sharp>* P"
  using assms
proof(nominal_induct \<alpha> rule: action.strong_induct)
  case(In M N)
  then show ?case by(simp add: residualInject)
next
  case(BrIn M N)
  then show ?case by(simp add: residualInject)
next
  case(Out M xvec N)
  then show ?case
    using boundOutputChainEq'' by(force simp add: residualInject)
next
  case(BrOut M xvec N)
  then show ?case
    using boundOutputChainEq'' by(force simp add: residualInject)
next
  case Tau
  then show ?case by(simp add: residualInject)
qed

lemma semanticsInduct[consumes 3, case_names cAlpha cInput cBrInput cOutput cBrOutput cCase cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2 cBrClose cOpen cBrOpen cScope cBang]:
  fixes \<Psi>      :: 'b
    and P      :: "('a, 'b, 'c) psi"
    and \<alpha>      :: "'a action"
    and P'     :: "('a, 'b, 'c) psi"
    and Prop   :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                'a action \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> bool"
    and C      :: "'f::fs_name"

assumes "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "bn \<alpha> \<sharp>* (subject \<alpha>)"
  and   "distinct(bn \<alpha>)"
  and   rAlpha: "\<And>\<Psi> P \<alpha> P' p C. \<lbrakk>bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* (subject \<alpha>);
                                    bn \<alpha> \<sharp>* C; bn \<alpha> \<sharp>* (bn(p \<bullet> \<alpha>));
                                    set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>)); distinctPerm p;
                                    (bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>; (bn(p \<bullet> \<alpha>)) \<sharp>* P'; Prop C \<Psi> P \<alpha> P'\<rbrakk> \<Longrightarrow>
                                     Prop C \<Psi> P (p \<bullet> \<alpha>) (p \<bullet> P')"
  and   rInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              (K\<lparr>(N[xvec::=Tvec])\<rparr>) (P[xvec::=Tvec])"
  and   rBrInput:"\<And>\<Psi> K M xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              (\<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr>) (P[xvec::=Tvec])"
  and   rOutput: "\<And>\<Psi> M K N P C. \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K\<rbrakk> \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) (K\<langle>N\<rangle>) P"
  and   rBrOutput:"\<And>\<Psi> M K N P C. \<lbrakk>\<Psi> \<turnstile> M \<preceq> K\<rbrakk> \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) (\<exclamdown>K\<langle>N\<rangle>) P"
  and   rCase: "\<And>\<Psi> P \<alpha> P' \<phi> Cs C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; \<And>C. Prop C \<Psi> P \<alpha> P'; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                                      Prop C \<Psi> (Cases Cs) \<alpha> P'"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P \<alpha> P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P \<alpha> P';
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C; distinct(bn \<alpha>); bn \<alpha> \<sharp>* Q;
                    bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* \<Psi>\<^sub>Q; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) \<alpha> (P' \<parallel> Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q \<alpha> Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q \<alpha> Q';
                    A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C; distinct(bn \<alpha>); bn \<alpha> \<sharp>* Q;
                    bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) \<alpha> (P \<parallel> Q')"
  and   rComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>N\<rparr>) P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>N\<rparr>) Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rBrMerge: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<questiondown>M\<lparr>N\<rparr>) P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr>) Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<questiondown>M\<lparr>N\<rparr>) (P' \<parallel> Q')"
  and   rBrComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<questiondown>M\<lparr>N\<rparr>) P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
  and   rBrComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr>) Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
  and   rBrClose: "\<And>\<Psi> P M xvec N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                     \<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P';
                     x \<in> supp M;
                     distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P;
                     xvec \<sharp>* M;
                     x \<sharp> \<Psi>; x \<sharp> xvec\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau>) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"
  and   rOpen:  "\<And>\<Psi> P M xvec yvec N P' x C.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; \<And>C. Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P';
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> yvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;  distinct xvec; distinct yvec;
                    yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; yvec \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) P'"
  and   rBrOpen: "\<And>\<Psi> P M xvec yvec N P' x C.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; \<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P';
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> yvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;  distinct xvec; distinct yvec;
                    yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; yvec \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) P'"
  and   rScope: "\<And>\<Psi> P \<alpha> P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; \<And>C. Prop C \<Psi> P \<alpha> P';
                    x \<sharp> \<Psi>; x \<sharp> \<alpha>; bn \<alpha> \<sharp>* \<Psi>;
                    bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* (subject \<alpha>); x \<sharp> C; bn \<alpha> \<sharp>* C; distinct(bn \<alpha>)\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) \<alpha> (\<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P \<alpha> P' C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<alpha> \<prec> P'; guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) \<alpha> P'\<rbrakk> \<Longrightarrow>
                      Prop C \<Psi> (!P) \<alpha> P'"

shows "Prop C \<Psi> P \<alpha> P'"
  using \<open>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> \<open>bn \<alpha> \<sharp>* (subject \<alpha>)\<close> \<open>distinct(bn \<alpha>)\<close>
proof(nominal_induct x3=="\<alpha> \<prec> P'" avoiding: \<alpha> C arbitrary: P' rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P \<alpha> C P')
  then show ?case by(force intro: rInput simp add: residualInject)
next
  case(cBrInput \<Psi> M K xvec N Tvec P \<alpha> C P')
  then show ?case
    by(force simp add: rBrInput residualInject)
next
  case(Output \<Psi> M K N P \<alpha> C P')
  then show ?case by(force intro: rOutput simp add: residualInject)
next
  case(BrOutput \<Psi> M K N P \<alpha> C P')
  then show ?case by(force intro: rBrOutput simp add: residualInject)
next
  case(Case \<Psi> P \<phi> Cs \<alpha> C P')
  then show ?case by(auto intro: rCase)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q \<alpha>' C P'')
  note \<open>\<alpha> \<prec> (P' \<parallel> Q) = \<alpha>' \<prec> P''\<close>
  moreover from \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> have "bn \<alpha> \<sharp>* (bn \<alpha>')" by auto
  moreover note \<open>distinct (bn \<alpha>)\<close> \<open>distinct(bn \<alpha>')\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha>' \<sharp>* subject \<alpha>'\<close>
  have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P' \<parallel> Q)" and "bn \<alpha>' \<sharp>* (\<alpha>' \<prec> P'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn \<alpha>)) \<times> (set(bn(p \<bullet> \<alpha>)))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha>' = p \<bullet> \<alpha>" and P'eq: "P'' = p \<bullet> (P' \<parallel> Q)" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* (P' \<parallel> Q)"
    by(rule residualEq)

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>distinct A\<^sub>Q\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close>
  have "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P \<alpha> P'" by(metis cPar1)
  moreover note \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
    \<open>bn \<alpha> \<sharp>* Q\<close> \<open>distinct(bn \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) \<alpha> (P' \<parallel> Q)"
    by(metis rPar1)

  with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* bn \<alpha>'\<close> S \<open>distinctPerm p\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* (P' \<parallel> Q)\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
  have "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> \<alpha>) (p \<bullet> (P' \<parallel> Q))"
    by - (rule rAlpha, auto)
  with \<alpha>Eq P'eq \<open>distinctPerm p\<close> show ?case by simp
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P \<alpha>' C Q'')
  note \<open>\<alpha> \<prec> (P \<parallel> Q') = \<alpha>' \<prec> Q''\<close>
  moreover from \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> have "bn \<alpha> \<sharp>* (bn \<alpha>')" by auto
  moreover note \<open>distinct (bn \<alpha>)\<close> \<open>distinct(bn \<alpha>')\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha>' \<sharp>* subject \<alpha>'\<close>
  have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P \<parallel> Q')" and "bn \<alpha>' \<sharp>* (\<alpha>' \<prec> Q'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn \<alpha>)) \<times> (set(bn(p \<bullet> \<alpha>)))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha>' = p \<bullet> \<alpha>" and Q'eq: "Q'' = p \<bullet> (P \<parallel> Q')" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* (P \<parallel> Q')"
    by(rule residualEq)

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close>
  have "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q \<alpha> Q'" by(auto intro: cPar2)

  moreover note \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>bn \<alpha> \<sharp>* Q\<close> \<open>distinct(bn \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) \<alpha> (P \<parallel> Q')"
    by(metis rPar2)
  with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* (bn \<alpha>')\<close> S \<open>distinctPerm p\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* (P \<parallel> Q')\<close>
  have "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> \<alpha>) (p \<bullet> (P \<parallel> Q'))"
    by - (rule rAlpha, auto)
  with \<alpha>Eq Q'eq \<open>distinctPerm p\<close> show ?case by simp
next
  case(cComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q \<alpha> C P'')
  then have "Prop C \<Psi> (P \<parallel> Q) (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
    by(fastforce intro: rComm1)
  then show ?case using \<open>\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q') = \<alpha> \<prec> P''\<close>
    by(simp add: residualInject)
next
  case(cComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q \<alpha> C P'')
  then have "Prop C \<Psi> (P \<parallel> Q) (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
    by(fastforce intro: rComm2)
  then show ?case using \<open>\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q') = \<alpha> \<prec> P''\<close>
    by(simp add: residualInject)
next
  case (cBrMerge \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q \<alpha> C P'')
  then show ?case by(simp add: rBrMerge residualInject)
next
  case(cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q \<alpha> C P'')
  from cBrComm1 \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>xvec \<sharp>* M\<close> have "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
    by(fastforce intro: rBrComm1)

  note \<open>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (bn \<alpha>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>distinct (bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q')" by simp
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<times> (set(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha> = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" and P'eq: "P'' = p \<bullet> (P' \<parallel> Q')" and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)"
    and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')"
    by(rule residualEq)

  from \<open>xvec \<sharp>* \<Psi>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* \<Psi>" by simp
  moreover from \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (P \<parallel> Q)" by simp
  moreover from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>xvec \<sharp>* C\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* C" by simp
  moreover from \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* bn (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>(set p) \<subseteq> (set(bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<times> (set(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))))\<close>
  moreover note \<open>distinctPerm p\<close>
  moreover note \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close>
  moreover note \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')\<close>
  moreover note \<open>Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')\<close>

  ultimately have propEqvt: "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) (p \<bullet> (P' \<parallel> Q'))" by(rule rAlpha)

  then show ?case by (simp add: \<alpha>Eq P'eq propEqvt)
next
  case(cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q \<alpha> C P'')
  from cBrComm2 \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>xvec \<sharp>* M\<close> have "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
    by(fastforce intro: rBrComm2)

  note \<open>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (bn \<alpha>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>distinct (bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q')" by simp
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<times> (set(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha> = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" and P'eq: "P'' = p \<bullet> (P' \<parallel> Q')" and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)"
    and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')"
    by(rule residualEq)

  from \<open>xvec \<sharp>* \<Psi>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* \<Psi>" by simp
  moreover from \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (P \<parallel> Q)" by simp
  moreover from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>xvec \<sharp>* C\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* C" by simp
  moreover from \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* bn (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>(set p) \<subseteq> (set(bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<times> (set(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))))\<close>
  moreover note \<open>distinctPerm p\<close>
  moreover note \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close>
  moreover note \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')\<close>
  moreover note \<open>Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')\<close>

  ultimately have propEqvt: "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) (p \<bullet> (P' \<parallel> Q'))" by(rule rAlpha)

  then show ?case by (simp add: \<alpha>Eq P'eq propEqvt)
next
  case (cBrClose \<Psi> P M xvec N P' x \<alpha> C P'')
  then have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau>) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"
    by(fastforce intro: rBrClose)
  then show ?case using \<open>\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P') = \<alpha> \<prec> P''\<close>
    by(simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec yvec N P' x \<alpha> C P'')
  note \<open>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close> have "(xvec@x#yvec) \<sharp>* (bn \<alpha>)"
    by auto
  moreover from \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  have "distinct(xvec@x#yvec)"
    by(auto simp add: fresh_star_def) (simp add: fresh_def name_list_supp)
  moreover note \<open>distinct(bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@x#yvec) \<sharp>* M" by auto
  then have "(xvec@x#yvec) \<sharp>* (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P')" by auto
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(xvec@x#yvec)) \<times> (set(p \<bullet> (xvec@x#yvec)))" and "distinctPerm p"
    and \<alpha>eq: "\<alpha> = (p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>" and P'eq: "P'' = (p \<bullet> P')"
    and A: "(xvec@x#yvec) \<sharp>* ((p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>)"
    and B: "(p \<bullet> (xvec@x#yvec)) \<sharp>* (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>)"
    and C: "(p \<bullet> (xvec@x#yvec)) \<sharp>* P'"
    by - (rule residualEq, (assumption | simp)+)
  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>x \<in> (supp N)\<close>

  moreover {
    fix C
    from \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@yvec) \<sharp>* M" by simp
    moreover from \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec \<sharp>* yvec\<close> have "distinct(xvec@yvec)"
      by auto (simp add: fresh_star_def name_list_supp fresh_def)
    ultimately have "Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P'" by(fastforce intro: cOpen)
  }

  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close> \<open>yvec \<sharp>* M\<close> \<open>yvec \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) P'"
    by(metis rOpen)

  with \<open>xvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* C\<close>  S \<open>distinctPerm p\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> A B C
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (p \<bullet> (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>)) (p \<bullet> P')"
    apply -
    apply(rule rAlpha[where \<alpha>="M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>"];clarsimp)
    by (meson abs_fresh(1) abs_fresh_list_star' freshChainAppend freshSets(5) psiFreshVec(5))
  with \<alpha>eq P'eq show ?case by simp
next
  case(cBrOpen \<Psi> P M xvec yvec N P' x \<alpha> C P'')
  note \<open>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close> have "(xvec@x#yvec) \<sharp>* (bn \<alpha>)"
    by auto
  moreover from \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  have "distinct(xvec@x#yvec)"
    by(clarsimp simp add: fresh_star_def; safe; simp add: fresh_def name_list_supp)
  moreover note \<open>distinct(bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@x#yvec) \<sharp>* M" by auto
  then have "(xvec@x#yvec) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P')" by auto
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(xvec@x#yvec)) \<times> (set(p \<bullet> (xvec@x#yvec)))" and "distinctPerm p"
    and \<alpha>eq: "\<alpha> = \<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>" and P'eq: "P'' = (p \<bullet> P')"
    and A: "(xvec@x#yvec) \<sharp>* (\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>)"
    and B: "(p \<bullet> (xvec@x#yvec)) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>)"
    and C: "(p \<bullet> (xvec@x#yvec)) \<sharp>* P'"
    apply -
    by(rule residualEq) (assumption|simp)+
  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>x \<in> (supp N)\<close>

  moreover {
    fix C
    from \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@yvec) \<sharp>* M" by simp
    moreover from \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec \<sharp>* yvec\<close> have "distinct(xvec@yvec)"
      by auto (simp add: fresh_star_def name_list_supp fresh_def)
    ultimately have "Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P'" by(fastforce intro: cBrOpen)
  }

  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close> \<open>yvec \<sharp>* M\<close> \<open>yvec \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) P'"
    by(metis rBrOpen)

  with \<open>xvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* C\<close>  S \<open>distinctPerm p\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> A B C
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>)) (p \<bullet> P')"
    apply -
    apply(rule rAlpha[where \<alpha>="\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>"]; clarsimp)
    by (meson abs_fresh(1) abs_fresh_list_star' freshChainAppend freshSets(5) psiFreshVec(5))
  with \<alpha>eq P'eq show ?case by simp
next
  case(cScope \<Psi> P \<alpha> P' x \<alpha>' C P'')
  note \<open>\<alpha> \<prec> (\<lparr>\<nu>x\<rparr>P') = \<alpha>' \<prec> P''\<close>
  moreover from \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> have "bn \<alpha> \<sharp>* (bn \<alpha>')" by auto
  moreover note \<open>distinct (bn \<alpha>)\<close> \<open>distinct(bn \<alpha>')\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha>' \<sharp>* subject \<alpha>'\<close>
  have "bn \<alpha> \<sharp>* (\<alpha> \<prec> \<lparr>\<nu>x\<rparr>P')" and "bn \<alpha>' \<sharp>* (\<alpha>' \<prec> P'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn \<alpha>)) \<times> (set(bn(p \<bullet> \<alpha>)))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha>' = p \<bullet> \<alpha>" and P'eq: "P'' = p \<bullet> (\<lparr>\<nu>x\<rparr>P')" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* (\<lparr>\<nu>x\<rparr>P')"
    by(rule residualEq)

  note \<open>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close>
  have "\<And>C. Prop C \<Psi> P \<alpha> P'" by(fastforce intro: cScope)

  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>
    \<open>x \<sharp> C\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>distinct(bn \<alpha>)\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) \<alpha> (\<lparr>\<nu>x\<rparr>P')"
    by(rule rScope)
  with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>x \<sharp> \<alpha>\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* (bn \<alpha>')\<close> S \<open>distinctPerm p\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* (\<lparr>\<nu>x\<rparr>P')\<close>
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (p \<bullet> \<alpha>) (p \<bullet> (\<lparr>\<nu>x\<rparr>P'))"
    by(fastforce intro: rAlpha)
  with \<alpha>Eq P'eq \<open>distinctPerm p\<close> show ?case by simp
next
  case(Bang \<Psi> P \<alpha> C P')
  then show ?case by(fastforce intro: rBang)
qed

lemma outputInduct[consumes 1, case_names cOutput cCase cPar1 cPar2 cOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> ('a, 'b, 'c) boundOutput \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes "\<Psi> \<rhd> P \<longmapsto>ROut M B"
  and   rOutput: "\<And>\<Psi> M K N P C. \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K\<rbrakk> \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) K (N \<prec>' P)"
  and   rCase: "\<And>\<Psi> P M B \<phi> Cs C.
                  \<lbrakk>\<Psi> \<rhd> P \<longmapsto>(ROut M B); \<And>C. Prop C \<Psi> P M B; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (Cases Cs) M B"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N  P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P');
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C; xvec \<sharp>* Q;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q))"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M xvec N  Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q');
                    A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M;
                    A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C; xvec \<sharp>* P;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* Q; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P \<parallel> Q'))"
  and   rOpen:  "\<And>\<Psi> P M xvec yvec N P' x C.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*(xvec@yvec)\<rparr>N \<prec>' P');
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> yvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* yvec; yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; yvec \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*(xvec@x#yvec)\<rparr>N \<prec>' P')"
  and   rScope: "\<And>\<Psi> P M xvec N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P');
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> N; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;
                    x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' \<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P M B C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>(ROut M B); guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) M B\<rbrakk> \<Longrightarrow>
                      Prop C \<Psi> (!P) M B"
shows "Prop C \<Psi> P M B"
  using \<open>\<Psi> \<rhd> P \<longmapsto>(ROut M B)\<close>
proof(nominal_induct \<Psi> P Rs=="(ROut M B)" avoiding: C arbitrary: B rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P C)
  then show ?case by(simp add: residualInject)
next
  case cBrInput
  then show ?case by(simp add: residualInject)
next
  case(Output \<Psi> M K N P C)
  then show ?case by(force simp add: residualInject intro: rOutput)
next
  case(BrOutput \<Psi> M N P C)
  then show ?case by(simp add: residualInject)
next
  case(Case \<Psi> P \<phi> Cs C B)
  then show ?case by(force intro: rCase)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q C)
  then show ?case by(force intro: rPar1 simp add: residualInject)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P C)
  then show ?case by(force intro: rPar2 simp add: residualInject)
next
  case cComm1
  then show ?case by(simp add: residualInject)
next
  case cComm2
  then show ?case by(simp add: residualInject)
next
  case cBrMerge
  then show ?case by(simp add: residualInject)
next
  case (cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C B)
  then show ?case by(simp add: residualInject)
next
  case (cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C B)
  then show ?case by(simp add: residualInject)
next
  case(cBrClose \<Psi> P M xvec N P' C B)
  then show ?case by(simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec yvec N P' x C B)
  then show ?case by(force intro: rOpen simp add: residualInject)
next
  case cBrOpen
  then show ?case by(simp add: residualInject)
next
  case(cScope \<Psi> P M \<alpha> P' x C)
  then show ?case by(force intro: rScope simp add: residualInject)
next
  case(Bang \<Psi> P C B)
  then show ?case by(force intro: rBang)
qed

lemma brOutputInduct[consumes 1, case_names cBrOutput cCase cPar1 cPar2 cBrComm1 cBrComm2 cBrOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> ('a, 'b, 'c) boundOutput \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes "\<Psi> \<rhd> P \<longmapsto>RBrOut M B"
  and   rBrOutput: "\<And>\<Psi> M K N P C. \<lbrakk>\<Psi> \<turnstile> M \<preceq> K\<rbrakk> \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) K (N \<prec>' P)"
  and   rCase: "\<And>\<Psi> P M B \<phi> Cs C.
                  \<lbrakk>\<Psi> \<rhd> P \<longmapsto>(RBrOut M B); \<And>C. Prop C \<Psi> P M B; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (Cases Cs) M B"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N  P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P');
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C; xvec \<sharp>* Q;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q))"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M xvec N  Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q');
                    A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M;
                    A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C; xvec \<sharp>* P;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* Q; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P \<parallel> Q'))"
  and   rBrComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q');
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q'))" (* Removed: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>N\<rparr> \<prec> P');" *)
  and   rBrComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P');
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q'))" (* Removed: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>N\<rparr>) Q';" *)
  and   rBrOpen:  "\<And>\<Psi> P M xvec yvec N P' x C.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*(xvec@yvec)\<rparr>N \<prec>' P');
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> yvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* yvec; yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; yvec \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*(xvec@x#yvec)\<rparr>N \<prec>' P')"
  and   rScope: "\<And>\<Psi> P M xvec N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P');
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> N; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;
                    x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' \<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P M B C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>(RBrOut M B); guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) M B\<rbrakk> \<Longrightarrow>
                      Prop C \<Psi> (!P) M B"
shows "Prop C \<Psi> P M B"
  using \<open>\<Psi> \<rhd> P \<longmapsto>(RBrOut M B)\<close>
proof(nominal_induct \<Psi> P Rs=="(RBrOut M B)" avoiding: C arbitrary: B rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P C)
  then show ?case by(simp add: residualInject)
next
  case cBrInput
  then show ?case by(simp add: residualInject)
next
  case(Output \<Psi> M K N P C)
  then show ?case by(simp add: residualInject)
next
  case(BrOutput \<Psi> M N P C)
  then show ?case by(auto simp add: residualInject intro: rBrOutput)
next
  case(Case \<Psi> P \<phi> Cs C B)
  then show ?case by(force intro: rCase)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q C)
  then show ?case by(force intro: rPar1 simp add: residualInject)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P C)
  then show ?case by(force intro: rPar2 simp add: residualInject)
next
  case cComm1
  then show ?case by(simp add: residualInject)
next
  case cComm2
  then show ?case by(simp add: residualInject)
next
  case cBrMerge
  then show ?case by(simp add: residualInject)
next
  case (cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C B)
  then show ?case by(force intro: rBrComm1 simp add: residualInject)
next
  case (cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C B)
  then show ?case by(force intro: rBrComm2 simp add: residualInject)
next
  case(cBrClose \<Psi> P M xvec N P' C B)
  then show ?case by(simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec yvec N P' x C B)
  then show ?case by(simp add: residualInject)
next
  case(cBrOpen \<Psi> P M xvec yvec N P' x C B)
  then show ?case by(force intro: rBrOpen simp add: residualInject)
next
  case(cScope \<Psi> P M \<alpha> P' x C)
  then show ?case by(force intro: rScope simp add: residualInject)
next
  case(Bang \<Psi> P C B)
  then show ?case by(force intro: rBang)
qed

lemma boundOutputBindObject:
  fixes \<Psi>   :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and yvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   "distinct(bn \<alpha>)"
  and   "y \<in> set(bn \<alpha>)"

shows "y \<in> supp(object \<alpha>)"
  using assms
proof(nominal_induct avoiding: P' arbitrary: y rule: semanticsInduct)
  case(cAlpha \<Psi> P \<alpha> P' p P'' y)
  from \<open>y \<in> set(bn(p \<bullet> \<alpha>))\<close> have "(p \<bullet> y) \<in> (p \<bullet> set(bn(p \<bullet> \<alpha>)))"
    by(rule pt_set_bij2[OF pt_name_inst, OF at_name_inst])
  then have "(p \<bullet> y) \<in> set(bn \<alpha>)" using \<open>distinctPerm p\<close>
    by(simp add: eqvts)
  then have "(p \<bullet> y) \<in> supp(object \<alpha>)" by(rule cAlpha)
  then have "(p \<bullet> p \<bullet> y) \<in> (p \<bullet> supp(object \<alpha>))"
    by(rule pt_set_bij2[OF pt_name_inst, OF at_name_inst])
  then show ?case using \<open>distinctPerm p\<close>
    by(simp add: eqvts)
next
  case cInput
  then show ?case by simp
next
  case cBrInput
  then show ?case by simp
next
  case cOutput
  then show ?case by simp
next
  case cBrOutput
  then show ?case by simp
next
  case cCase
  then show ?case by simp
next
  case cPar1
  then show ?case by simp
next
  case cPar2
  then show ?case by simp
next
  case cComm1
  then show ?case by simp
next
  case cComm2
  then show ?case by simp
next
  case cBrMerge
  then show ?case by simp
next
  case cBrComm1
  then show ?case by simp
next
  case cBrComm2
  then show ?case by simp
next
  case cBrClose
  then show ?case by simp
next
  case cOpen
  then show ?case by(auto simp add: supp_list_cons supp_list_append supp_atm supp_some)
next
  case cBrOpen
  then show ?case by(auto simp add: supp_list_cons supp_list_append supp_atm supp_some)
next
  case cScope
  then show ?case by simp
next
  case cBang
  then show ?case by simp
qed

lemma alphaBoundOutputChain':
  fixes yvec :: "name list"
    and xvec :: "name list"
    and B    :: "('a, 'b, 'c) boundOutput"

assumes "length xvec = length yvec"
  and   "yvec \<sharp>* B"
  and   "yvec \<sharp>* xvec"
  and   "distinct yvec"

shows "\<lparr>\<nu>*xvec\<rparr>B = \<lparr>\<nu>*yvec\<rparr>([xvec yvec] \<bullet>\<^sub>v B)"
  using assms
proof(induct rule: composePermInduct)
  case cBase
  show ?case by simp
next
  case(cStep x xvec y yvec)
  then show ?case
    by (auto simp add: alphaBoundOutput[of y] eqvts)
qed

lemma alphaBoundOutputChain'':
  fixes yvec :: "name list"
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"

assumes "length xvec = length yvec"
  and   "yvec \<sharp>* N"
  and   "yvec \<sharp>* P"
  and   "yvec \<sharp>* xvec"
  and   "distinct yvec"

shows "\<lparr>\<nu>*xvec\<rparr>(N \<prec>' P) = \<lparr>\<nu>*yvec\<rparr>(([xvec yvec] \<bullet>\<^sub>v N) \<prec>' ([xvec yvec] \<bullet>\<^sub>v P))"
proof -
  from assms have "\<lparr>\<nu>*xvec\<rparr>(N \<prec>' P) = \<lparr>\<nu>*yvec\<rparr>([xvec yvec] \<bullet>\<^sub>v (N \<prec>' P))"
    by(simp add: alphaBoundOutputChain')
  then show ?thesis by simp
qed

lemma alphaDistinct:
  fixes xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and yvec :: "name list"
    and M    :: 'a
    and Q    :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> Q"
  and   "distinct(bn \<alpha>)"
  and   "\<And>x. x \<in> set(bn \<alpha>) \<Longrightarrow> x \<in> supp(object \<alpha>)"
  and   "bn \<alpha> \<sharp>* bn \<beta>"
  and   "bn \<alpha> \<sharp>* (object \<beta>)"
  and   "bn \<alpha> \<sharp>* Q"

shows "distinct(bn \<beta>)"
  using assms
proof -
  {
    fix xvec M yvec N
    assume Eq: "\<lparr>\<nu>*xvec\<rparr>N \<prec>' P = \<lparr>\<nu>*yvec\<rparr>M \<prec>' Q"
    assume "distinct xvec" and "xvec \<sharp>* M" and "xvec \<sharp>* yvec" and "xvec \<sharp>* Q"
    assume Mem: "\<And>x. x \<in> set xvec \<Longrightarrow> x \<in> (supp N)"
    have "distinct yvec"
    proof -
      from Eq have "length xvec = length yvec"
        by(rule boundOutputChainEqLength)
      with Eq \<open>distinct xvec\<close> \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* Q\<close> Mem show ?thesis
      proof(induct n=="length xvec" arbitrary: xvec yvec M Q rule: nat.induct)
        case(zero xvec yvec M Q)
        then show ?case by simp
      next
        case(Suc n xvec yvec M Q)
        have L: "length xvec = length yvec" and "Suc n = length xvec" by fact+
        then obtain x xvec' y yvec' where xEq: "xvec = x#xvec'" and yEq: "yvec = y#yvec'"
          and L': "length xvec' = length yvec'"
          by(cases xvec, auto, cases yvec, auto)
        have xvecFreshyvec: "xvec \<sharp>* yvec" and xvecDist: "distinct xvec" by fact+
        with xEq yEq have xineqy: "x \<noteq> y" and xvec'Freshyvec': "xvec' \<sharp>* yvec'"
          and xvec'Dist: "distinct xvec'" and xFreshxvec': "x \<sharp> xvec'"
          and xFreshyvec': "x \<sharp> yvec'" and yFreshxvec': "y \<sharp> xvec'"
          by auto
        have Eq: "\<lparr>\<nu>*xvec\<rparr>N \<prec>' P = \<lparr>\<nu>*yvec\<rparr>M \<prec>' Q" by fact
        with xEq yEq xineqy have Eq': "\<lparr>\<nu>*xvec'\<rparr>N \<prec>' P = \<lparr>\<nu>*([(x, y)] \<bullet> yvec')\<rparr>([(x, y)] \<bullet> M) \<prec>' ([(x, y)] \<bullet> Q)"
          by(simp add: boundOutput.inject alpha eqvts)
        moreover have Mem:"\<And>x. x \<in> set xvec \<Longrightarrow> x \<in> supp N" by fact
        with xEq have "\<And>x. x \<in> set xvec' \<Longrightarrow> x \<in> supp N" by simp
        moreover have "xvec \<sharp>* M" by fact
        with xEq xFreshxvec' yFreshxvec' have "xvec' \<sharp>* ([(x, y)] \<bullet> M)" by simp
        moreover have xvecFreshQ: "xvec \<sharp>* Q" by fact
        with xEq xFreshxvec' yFreshxvec' have "xvec' \<sharp>* ([(x, y)] \<bullet> Q)" by simp
        moreover have "Suc n = length xvec" by fact
        with xEq have "n = length xvec'" by simp
        moreover from xvec'Freshyvec' xFreshxvec' yFreshxvec' have "xvec' \<sharp>* ([(x, y)] \<bullet> yvec')"
          by simp
        moreover from L' have "length xvec' = length([(x, y)] \<bullet> yvec')" by simp
        ultimately have "distinct([(x, y)] \<bullet> yvec')" using xvec'Dist
          apply -
          apply(rule Suc)
          by(assumption | simp)+
        then have "distinct yvec'" by simp
        from Mem xEq have xSuppN: "x \<in> supp N" by simp
        from L \<open>distinct xvec\<close> \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* Q\<close>
        have "\<lparr>\<nu>*yvec\<rparr>M \<prec>' Q = \<lparr>\<nu>*xvec\<rparr>([yvec xvec] \<bullet>\<^sub>v M) \<prec>' ([yvec xvec] \<bullet>\<^sub>v Q)"
          by(simp add: alphaBoundOutputChain'')
        with Eq have "N = [yvec xvec] \<bullet>\<^sub>v M" by simp
        with xEq yEq have "N = [(y, x)] \<bullet> [yvec' xvec'] \<bullet>\<^sub>v M"
          by simp
        with xSuppN have ySuppM: "y \<in> supp([yvec' xvec'] \<bullet>\<^sub>v M)"
          by(force simp add: calc_atm eqvts name_swap
                   dest: pt_set_bij2[where pi="[(x, y)]",OF pt_name_inst, OF at_name_inst])
        have "y \<sharp> yvec'"
        proof -
          {
            assume "y \<in> supp yvec'"
            then have "y \<in> set yvec'"
              by(induct yvec') (auto simp add: supp_list_nil supp_list_cons supp_atm)
            moreover from \<open>xvec \<sharp>* M\<close> xEq xFreshxvec' have "xvec' \<sharp>* M" by simp
            ultimately have "y \<sharp> [yvec' xvec'] \<bullet>\<^sub>v  M" using L' xvec'Freshyvec' xvec'Dist
              by(force intro: freshChainPerm)
            with ySuppM have "False" by(simp add: fresh_def)
          }
          then show ?thesis
            by(simp add: fresh_def, rule notI)
        qed
        with \<open>distinct yvec'\<close> yEq show ?case by simp
      qed
    qed
  } note res = this
  show ?thesis
    apply(rule actionCases[where \<alpha>=\<alpha>])
    using assms res
    by(auto simp add: residualInject supp_some)
qed

lemma boundOutputDistinct:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"

shows "distinct(bn \<alpha>)"
  using assms
proof(nominal_induct \<Psi> P x3=="\<alpha> \<prec> P'" avoiding: \<alpha> P' rule: semantics.strong_induct)
  case cPar1
  then show ?case
    by(force intro: alphaDistinct boundOutputBindObject)
next
  case cPar2
  then show ?case
    by(force intro: alphaDistinct boundOutputBindObject)
next
  case (cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q \<alpha> P'')
  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  ultimately have someX: "\<And> x. x \<in> set (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) \<Longrightarrow> x \<in> supp (object (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))"
    by (drule boundOutputBindObject) (assumption)

  note \<open>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q' = \<alpha> \<prec> P''\<close>
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>\<And>x. x \<in> set (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) \<Longrightarrow> x \<in> supp (object (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* bn \<alpha>" by simp
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* object \<alpha>" by simp
  moreover from \<open>xvec \<sharp>* P''\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* P''" by simp
  ultimately show ?case
    by(rule alphaDistinct)
next
  case (cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q \<alpha> P'')
  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  ultimately have someX: "\<And> x. x \<in> set (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) \<Longrightarrow> x \<in> supp (object (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))"
    by (drule boundOutputBindObject) (assumption)

  note \<open>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q' = \<alpha> \<prec> P''\<close>
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>\<And>x. x \<in> set (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) \<Longrightarrow> x \<in> supp (object (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* bn \<alpha>" by simp
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* object \<alpha>" by simp
  moreover from \<open>xvec \<sharp>* P''\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* P''" by simp
  ultimately show ?case
    by(rule alphaDistinct)
next
  case(cBrClose \<Psi> P M xvec N P' \<alpha> P'')
  then show ?case by(simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec yvec N P' x \<alpha> P'')
  note \<open>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  have "distinct(bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"
    by auto (simp add: fresh_star_def fresh_def name_list_supp)
  moreover {
    fix y
    from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>x \<in> supp N\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> \<Psi>\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* yvec\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close> \<open>yvec \<sharp>* M\<close>
    have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'" by(rule semantics.cOpen)
    moreover moreover from \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>yvec \<sharp>* M\<close>
    have "bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* (subject(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"
      by simp
    moreover note \<open>distinct(bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))\<close>
    moreover assume "y \<in> set(bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"

    ultimately have "y \<in> supp(object(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"
      by(metis boundOutputBindObject)
  }
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close>
  have "bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* bn \<alpha>" and "bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* object \<alpha>" by simp+
  moreover from \<open>xvec \<sharp>* P''\<close> \<open>x \<sharp> P''\<close> \<open>yvec \<sharp>* P''\<close>
  have "bn(M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* P''" by simp
  ultimately show ?case by(rule alphaDistinct)
next
  case(cBrOpen \<Psi> P M xvec yvec N P' x \<alpha> P'')
  note \<open>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  have "distinct(bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"
    by auto (simp add: fresh_star_def fresh_def name_list_supp)
  moreover {
    fix y
    from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>x \<in> supp N\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> \<Psi>\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* yvec\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close> \<open>yvec \<sharp>* M\<close>
    have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'" by(rule semantics.cBrOpen)
    moreover moreover from \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>yvec \<sharp>* M\<close>
    have "bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* (subject(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"
      by simp
    moreover note \<open>distinct(bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))\<close>
    moreover assume "y \<in> set(bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"

    ultimately have "y \<in> supp(object(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>))"
      by(metis boundOutputBindObject)
  }
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close>
  have "bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* bn \<alpha>" and "bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* object \<alpha>" by simp+
  moreover from \<open>xvec \<sharp>* P''\<close> \<open>x \<sharp> P''\<close> \<open>yvec \<sharp>* P''\<close>
  have "bn(\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>) \<sharp>* P''" by simp
  ultimately show ?case by(rule alphaDistinct)
next
  case cScope
  then show ?case
    by - (rule alphaDistinct, auto intro: boundOutputBindObject)
qed (simp_all add: residualInject)

lemma inputDistinct:
  fixes \<Psi>   :: 'b
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and Rs   :: "('a, 'b, 'c) residual"

assumes "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto> Rs"

shows "distinct xvec"
  using assms
  by(nominal_induct \<Psi> P=="M\<lparr>\<lambda>*xvec N\<rparr>.P" Rs avoiding: xvec N P rule: semantics.strong_induct)
    (auto simp add: psi.inject intro: alphaInputDistinct)

lemma outputInduct'[consumes 2, case_names cAlpha cOutput cCase cPar1 cPar2 cOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and yvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> name list \<Rightarrow> 'a \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   rAlpha: "\<And>\<Psi> P M xvec N P' p C. \<lbrakk>xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;  xvec \<sharp>* C; xvec \<sharp>* (p \<bullet> xvec);
                                           set p \<subseteq> set xvec \<times> set(p \<bullet> xvec); distinctPerm p;
                                           (p \<bullet> xvec) \<sharp>* N; (p \<bullet> xvec) \<sharp>* P'; Prop C \<Psi> P M xvec N P'\<rbrakk> \<Longrightarrow>
                                           Prop C \<Psi> P M (p \<bullet> xvec) (p \<bullet> N) (p \<bullet> P')"
  and   rOutput: "\<And>\<Psi> M K N P C. \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K\<rbrakk> \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) K ([]) N P"
  and   rCase: "\<And>\<Psi> P M xvec N P' \<phi> Cs C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C \<Psi> P M xvec N P'; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                                             Prop C \<Psi> (Cases Cs) M xvec N P'"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N  P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M xvec N P';
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C; xvec \<sharp>* Q;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M xvec N (P' \<parallel> Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M xvec N  Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>;  distinct A\<^sub>P;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M xvec N Q';
                    A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M;
                    A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C; xvec \<sharp>* Q;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M xvec N (P \<parallel> Q')"
  and   rOpen:  "\<And>\<Psi> P M xvec yvec N P' x C.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; \<And>C. Prop C \<Psi> P M (xvec@yvec) N P';
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> yvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;
                    yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; yvec \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (xvec@x#yvec) N P'"
  and   rScope: "\<And>\<Psi> P M xvec N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C \<Psi> P M xvec N P';
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> N; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* P; xvec \<sharp>* M; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M xvec N (\<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P M xvec N P' C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) M xvec N P'\<rbrakk> \<Longrightarrow>
                      Prop C \<Psi> (!P) M xvec N P'"
shows "Prop C \<Psi> P M xvec N P'"
proof -
  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "distinct(bn(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))"
    by(rule boundOutputDistinct)
  ultimately show ?thesis
  proof(nominal_induct \<Psi> P \<alpha>=="M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" P' avoiding: C arbitrary: M xvec N rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p C M xvec N)
    from \<open>(p \<bullet> \<alpha>) = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "(p \<bullet> p \<bullet> \<alpha>) = p \<bullet> (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)"
      by(simp add: fresh_bij)
    with \<open>distinctPerm p\<close> have A: "\<alpha> = (p \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle>"
      by(simp add: eqvts)
    with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha> \<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* bn(p \<bullet> \<alpha>)\<close> \<open>distinctPerm p\<close>
    have "(p \<bullet> xvec) \<sharp>* \<Psi>" and  "(p \<bullet> xvec) \<sharp>* P" and  "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" and  "(p \<bullet> xvec) \<sharp>* C" and  "(p \<bullet> xvec) \<sharp>* (p \<bullet> p \<bullet> xvec)"
      by auto
    moreover from A \<open>set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))\<close> \<open>distinctPerm p\<close>
    have S: "set p \<subseteq> set(p \<bullet> xvec) \<times> set(p \<bullet> p \<bullet> xvec)" by simp
    moreover note \<open>distinctPerm p\<close>
    moreover from A \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* P'\<close>
    have "(p \<bullet> p \<bullet> xvec) \<sharp>* (p \<bullet> N)" and "(p \<bullet> p \<bullet> xvec) \<sharp>* P'" by simp+
    moreover from A have "Prop C \<Psi> P (p \<bullet> M) (p \<bullet> xvec) (p \<bullet> N) P'"
      by(rule cAlpha)
    ultimately have "Prop C \<Psi> P (p \<bullet> M) (p \<bullet> p \<bullet> xvec) (p \<bullet> p \<bullet> N) (p \<bullet> P')"
      by(rule rAlpha)
    moreover from A \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" by simp
    then have "xvec \<sharp>* M" by(simp add: fresh_star_bij)
    from A \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>distinctPerm p\<close> have "xvec \<sharp>* (p \<bullet> M)" by simp
    then have "(p \<bullet> xvec) \<sharp>* (p \<bullet> p \<bullet> M)" by(simp add: fresh_star_bij)
    with \<open>distinctPerm p\<close> have "(p \<bullet> xvec) \<sharp>* M" by simp
    with \<open>xvec \<sharp>* M\<close> S \<open>distinctPerm p\<close> have  "(p \<bullet> M) = M" by simp
    ultimately show ?case using S \<open>distinctPerm p\<close> by simp
  next
    case cInput
    then show ?case by(simp add: residualInject)
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by(force dest: rOutput simp add: action.inject)
  next
    case cBrOutput
    then show ?case by simp
  next
    case cCase
    then show ?case by(force intro: rCase)
  next
    case cPar1
    then show ?case by(force intro: rPar1)
  next
    case cPar2
    then show ?case by(force intro: rPar2)
  next
    case cComm1
    then show ?case by(simp add: action.inject)
  next
    case cComm2
    then show ?case by(simp add: action.inject)
  next
    case cBrMerge
    then show ?case by(simp add: action.inject)
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case cOpen
    then show ?case by(auto intro: rOpen simp add: action.inject)
  next
    case cBrOpen
    then show ?case by simp
  next
    case cScope
    then show ?case by(auto intro: rScope)
  next
    case cBang
    then show ?case by(auto intro: rBang)
  qed
qed

lemma brOutputInduct'[consumes 2, case_names cAlpha cBrOutput cCase cPar1 cPar2 cBrComm1 cBrComm2 cBrOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and yvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> name list \<Rightarrow> 'a \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   rAlpha: "\<And>\<Psi> P M xvec N P' p C. \<lbrakk>xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;  xvec \<sharp>* C; xvec \<sharp>* (p \<bullet> xvec);
                                           set p \<subseteq> set xvec \<times> set(p \<bullet> xvec); distinctPerm p;
                                           (p \<bullet> xvec) \<sharp>* N; (p \<bullet> xvec) \<sharp>* P'; Prop C \<Psi> P M xvec N P'\<rbrakk> \<Longrightarrow>
                                           Prop C \<Psi> P M (p \<bullet> xvec) (p \<bullet> N) (p \<bullet> P')"
  and   rBrOutput: "\<And>\<Psi> M K N P C. \<lbrakk>\<Psi> \<turnstile> M \<preceq> K\<rbrakk> \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) K ([]) N P"
  and   rCase: "\<And>\<Psi> P M xvec N P' \<phi> Cs C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C \<Psi> P M xvec N P'; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                                             Prop C \<Psi> (Cases Cs) M xvec N P'"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N  P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M xvec N P';
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C; xvec \<sharp>* Q;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M xvec N (P' \<parallel> Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M xvec N  Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>;  distinct A\<^sub>P;
                    \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M xvec N Q';
                    A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M;
                    A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C; xvec \<sharp>* Q;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M xvec N (P \<parallel> Q')"
  and   rBrComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M xvec N Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M xvec N (P' \<parallel> Q')" (* Removed: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>N\<rparr> \<prec> P');" *)
  and   rBrComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M xvec N P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; distinct xvec;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M xvec N (P' \<parallel> Q')" (* Removed: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>N\<rparr>) Q';" *)
  and   rOpen:  "\<And>\<Psi> P M xvec yvec N P' x C.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; \<And>C. Prop C \<Psi> P M (xvec@yvec) N P';
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> yvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M;
                    yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; yvec \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (xvec@x#yvec) N P'"
  and   rScope: "\<And>\<Psi> P M xvec N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; \<And>C. Prop C \<Psi> P M xvec N P';
                    x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> N; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* P; xvec \<sharp>* M; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M xvec N (\<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P M xvec N P' C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) M xvec N P'\<rbrakk> \<Longrightarrow>
                      Prop C \<Psi> (!P) M xvec N P'"
shows "Prop C \<Psi> P M xvec N P'"
proof -
  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "distinct(bn(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))"
    by(rule boundOutputDistinct)
  ultimately show ?thesis
  proof(nominal_induct \<Psi> P \<alpha>=="\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" P' avoiding: C arbitrary: M xvec N rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p C M xvec N)
    from \<open>(p \<bullet> \<alpha>) = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "(p \<bullet> p \<bullet> \<alpha>) = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)"
      by(simp add: fresh_bij)
    with \<open>distinctPerm p\<close> have A: "\<alpha> = \<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle>"
      by(simp add: eqvts)
    with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha> \<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* bn(p \<bullet> \<alpha>)\<close> \<open>distinctPerm p\<close>
    have "(p \<bullet> xvec) \<sharp>* \<Psi>" and  "(p \<bullet> xvec) \<sharp>* P" and  "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" and  "(p \<bullet> xvec) \<sharp>* C" and  "(p \<bullet> xvec) \<sharp>* (p \<bullet> p \<bullet> xvec)"
      by auto
    moreover from A \<open>set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))\<close> \<open>distinctPerm p\<close>
    have S: "set p \<subseteq> set(p \<bullet> xvec) \<times> set(p \<bullet> p \<bullet> xvec)" by simp
    moreover note \<open>distinctPerm p\<close>
    moreover from A \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* P'\<close>
    have "(p \<bullet> p \<bullet> xvec) \<sharp>* (p \<bullet> N)" and "(p \<bullet> p \<bullet> xvec) \<sharp>* P'" by simp+
    moreover from A have "Prop C \<Psi> P (p \<bullet> M) (p \<bullet> xvec) (p \<bullet> N) P'"
      by(rule cAlpha)
    ultimately have "Prop C \<Psi> P (p \<bullet> M) (p \<bullet> p \<bullet> xvec) (p \<bullet> p \<bullet> N) (p \<bullet> P')"
      by(rule rAlpha)
    moreover from A \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" by simp
    then have "xvec \<sharp>* M" by(simp add: fresh_star_bij)
    from A \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>distinctPerm p\<close> have "xvec \<sharp>* (p \<bullet> M)" by simp
    then have "(p \<bullet> xvec) \<sharp>* (p \<bullet> p \<bullet> M)" by(simp add: fresh_star_bij)
    with \<open>distinctPerm p\<close> have "(p \<bullet> xvec) \<sharp>* M" by simp
    with \<open>xvec \<sharp>* M\<close> S \<open>distinctPerm p\<close> have  "(p \<bullet> M) = M" by simp
    ultimately show ?case using S \<open>distinctPerm p\<close> by simp
  next
    case cInput
    then show ?case by(simp add: residualInject)
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by simp
  next
    case cBrOutput
    then show ?case by(simp add: rBrOutput action.inject)
  next
    case cCase
    then show ?case by(force intro: rCase)
  next
    case cPar1
    then show ?case by(force intro: rPar1)
  next
    case cPar2
    then show ?case by(force intro: rPar2)
  next
    case cComm1
    then show ?case by(simp add: action.inject)
  next
    case cComm2
    then show ?case by(simp add: action.inject)
  next
    case cBrMerge
    then show ?case by(simp add: action.inject)
  next
    case cBrComm1
    then show ?case
      by(auto intro: rBrComm1 simp add: action.inject)
  next
    case cBrComm2
    then show ?case
      by(auto intro: rBrComm2 simp add: action.inject)
  next
    case cBrClose
    then show ?case by simp
  next
    case cOpen
    then show ?case by simp
  next
    case cBrOpen
    then show ?case by(auto intro: rOpen simp add: action.inject)
  next
    case cScope
    then show ?case by(auto intro: rScope)
  next
    case cBang
    then show ?case by(auto intro: rBang)
  qed
qed

lemma inputInduct[consumes 1, case_names cInput cCase cPar1 cPar2 cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> 'a \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   rInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              K (N[xvec::=Tvec]) (P[xvec::=Tvec])"
  and   rCase: "\<And>\<Psi> P M N P' \<phi> Cs C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C \<Psi> P M N P'; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                                        Prop C \<Psi> (Cases Cs) M N P'"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M N P'; distinct A\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N;
                   A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P' \<parallel> Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>N\<rparr> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M N Q'; distinct A\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N;
                   A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P \<parallel> Q')"
  and   rScope: "\<And>\<Psi> P M N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C \<Psi> P M N P'; x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> N; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M N (\<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P M N P' C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) M N P'\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) M N P'"
shows "Prop C \<Psi> P M N P'"
  using Trans
proof(nominal_induct \<Psi> P Rs=="M\<lparr>N\<rparr> \<prec> P'" avoiding: C arbitrary: P' rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P C)
  then show ?case
    by(force intro: rInput simp add: residualInject action.inject)
next
  case(cBrInput \<Psi> M K xvec N Tvec P C)
  then show ?case
    by (simp add: residualInject)
next
  case(Output \<Psi> M K N P C)
  then show ?case by(simp add: residualInject)
next
  case BrOutput
  then show ?case by(simp add: residualInject)
next
  case(Case \<Psi> P \<phi> CS C P')
  then show ?case by(force intro: rCase)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q C P'')
  then show ?case by(force intro: rPar1 simp add: residualInject)
next
  case(cPar2 \<Psi> \<Psi>P Q \<alpha> Q' xvec P C Q'')
  then show ?case by(force intro: rPar2 simp add: residualInject)
next
  case(cComm1 \<Psi> \<Psi>Q P M N P' xvec \<Psi>P Q K zvec Q' yvec C PQ)
  then show ?case by(simp add: residualInject)
next
  case(cComm2 \<Psi> \<Psi>Q P M zvec N P' xvec \<Psi>P Q K yvec Q' C PQ)
  then show ?case by(simp add: residualInject)
next
  case cBrMerge
  then show ?case by(simp add: residualInject)
next
  case cBrComm1
  then show ?case by(simp add: residualInject)
next
  case cBrComm2
  then show ?case by(simp add: residualInject)
next
  case(cBrClose \<Psi> P M xvec N P' C P'')
  then show ?case by(simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec N P' x yvec C P'')
  then show ?case by(simp add: residualInject)
next
  case(cBrOpen \<Psi> P M xvec N P' x yvec C P'')
  then show ?case by(simp add: residualInject)
next
  case(cScope \<Psi> P \<alpha> P' x C P'')
  then show ?case by(force intro: rScope simp add: residualInject)
next
  case(Bang \<Psi> P C P')
  then show ?case by(force intro: rBang)
qed

lemma brInputInduct[consumes 1, case_names cBrInput cCase cPar1 cPar2 cBrMerge cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> 'a \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   rBrInput: "\<And>\<Psi> K M xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              K (N[xvec::=Tvec]) (P[xvec::=Tvec])"
  and   rCase: "\<And>\<Psi> P M N P' \<phi> Cs C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C \<Psi> P M N P'; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                                        Prop C \<Psi> (Cases Cs) M N P'"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M N P'; distinct A\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N;
                   A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P' \<parallel> Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M N Q'; distinct A\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N;
                   A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P \<parallel> Q')"
  and   rBrMerge: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M N P';
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M N Q';
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M N (P' \<parallel> Q')"
  and   rScope: "\<And>\<Psi> P M N P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C \<Psi> P M N P'; x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> N; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M N (\<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P M N P' C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) M N P'\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) M N P'"
shows "Prop C \<Psi> P M N P'"
  using Trans
proof(nominal_induct \<Psi> P Rs=="\<questiondown>M\<lparr>N\<rparr> \<prec> P'" avoiding: C arbitrary: P' rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P C)
  then show ?case by (simp add: residualInject)
next
  case(cBrInput \<Psi> K M xvec N Tvec P C)
  then show ?case
    by(auto intro: rBrInput simp add: residualInject action.inject)
next
  case(Output \<Psi> M K N P C)
  then show ?case by(simp add: residualInject)
next
  case BrOutput
  then show ?case by(simp add: residualInject)
next
  case(Case \<Psi> P \<phi> CS C P')
  then show ?case by(force intro: rCase)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q C P'')
  then show ?case by(force intro: rPar1 simp add: residualInject)
next
  case(cPar2 \<Psi> \<Psi>P Q \<alpha> Q' xvec P C Q'')
  then show ?case by(force intro: rPar2 simp add: residualInject)
next
  case(cComm1 \<Psi> \<Psi>Q P M N P' xvec \<Psi>P Q K zvec Q' yvec C PQ)
  then show ?case by(simp add: residualInject)
next
  case(cComm2 \<Psi> \<Psi>Q P M zvec N P' xvec \<Psi>P Q K yvec Q' C PQ)
  then show ?case by(simp add: residualInject)
next
  case cBrMerge
  then show ?case by(auto intro: rBrMerge simp add: residualInject action.inject)
next
  case cBrComm1
  then show ?case by(simp add: residualInject)
next
  case cBrComm2
  then show ?case by(simp add: residualInject)
next
  case(cBrClose \<Psi> P M xvec N P' C P'')
  then show ?case by(simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec N P' x yvec C P'')
  then show ?case by(simp add: residualInject)
next
  case(cBrOpen \<Psi> P M xvec N P' x yvec C P'')
  then show ?case by(simp add: residualInject)
next
  case(cScope \<Psi> P \<alpha> P' x C P'')
  then show ?case by(force intro: rScope simp add: residualInject)
next
  case(Bang \<Psi> P C P')
  then show ?case by(force intro: rBang)
qed

lemma tauInduct[consumes 1, case_names cCase cPar1 cPar2 cComm1 cComm2 cBrClose cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and Rs   :: "('a, 'b, 'c) residual"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 ('a, 'b, 'c) psi \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'"
  and   rCase: "\<And>\<Psi> P P' \<phi> Cs C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'; \<And>C. Prop C \<Psi> P P'; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow>
                                    Prop C \<Psi> (Cases Cs) P'"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P P' A\<^sub>Q Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<tau> \<prec> P'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P P';
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>;
                   A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) (P' \<parallel> Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q Q' A\<^sub>P P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<tau> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q Q';
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>;
                   A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) (P \<parallel> Q')"
  and   rComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';  extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rBrClose: "\<And>\<Psi> P M xvec N P' A\<^sub>P \<Psi>\<^sub>P x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                     x \<in> supp M;
                     distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P;
                     xvec \<sharp>* M;
                     x \<sharp> \<Psi>; x \<sharp> xvec\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"
  and   rScope: "\<And>\<Psi> P P' x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'; \<And>C. Prop C \<Psi> P P'; x \<sharp> \<Psi>; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<lparr>\<nu>x\<rparr>P')"
  and   rBang:    "\<And>\<Psi> P P' C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<tau> \<prec> P'; guarded P; \<And>C. Prop C \<Psi> (P \<parallel> !P) P'\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) P'"
shows "Prop C \<Psi> P P'"
  using Trans
proof(nominal_induct \<Psi> P Rs=="\<tau> \<prec> P'" avoiding: C arbitrary: P' rule: semantics.strong_induct)
  case(cInput M K xvec N Tvec P C)
  then show ?case by(simp add: residualInject)
next
  case cBrInput
  then show ?case by(simp add: residualInject)
next
  case(Output \<Psi> M K N P C)
  then show ?case by(simp add: residualInject)
next
  case BrOutput
  then show ?case by(simp add: residualInject)
next
  case(Case \<Psi> P \<phi> Cs C P')
  then show ?case by(force intro: rCase simp add: residualInject)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' A\<^sub>Q Q C P'')
  then show ?case by(force intro: rPar1 simp add: residualInject)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q \<alpha> Q' A\<^sub>P P C Q'')
  then show ?case by(force intro: rPar2 simp add: residualInject)
next
  case(cComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C PQ)
  then show ?case by(force intro: rComm1 simp add: residualInject)
next
  case(cComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>P Q' A\<^sub>Q C PQ)
  then show ?case by(force intro: rComm2 simp add: residualInject)
next
  case cBrMerge
  then show ?case by(simp add: residualInject)
next
  case cBrComm1
  then show ?case by(simp add: residualInject)
next
  case cBrComm2
  then show ?case by(simp add: residualInject)
next
  case cBrClose
  then show ?case by(force intro: rBrClose simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec N P' x yvec C P'')
  then show ?case by(simp add: residualInject)
next
  case(cBrOpen \<Psi> P M xvec N P' x yvec C P'')
  then show ?case by(simp add: residualInject)
next
  case(cScope \<Psi> P \<alpha> P' x C P'')
  then show ?case by(force intro: rScope simp add: residualInject)
next
  case(Bang \<Psi> P C P')
  then show ?case by(force intro: rBang simp add: residualInject)
qed

lemma semanticsFrameInduct[consumes 3, case_names cAlpha cInput cBrInput cOutput cBrOutput cCase cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2 cBrClose cOpen cBrOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and Rs   :: "('a, 'b, 'c) residual"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P   :: 'b
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 ('a, 'b, 'c) residual \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto> Rs"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   rAlpha: "\<And>\<Psi> P A\<^sub>P \<Psi>\<^sub>P p Rs C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* Rs; A\<^sub>P \<sharp>* C;
                                         set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P); distinctPerm p;
                                          Prop C \<Psi> P Rs A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P Rs (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              (K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> (P[xvec::=Tvec])) ([]) (\<one>)"
  and   rBrInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              (\<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> (P[xvec::=Tvec])) ([]) (\<one>)"
  and   rOutput: "\<And>\<Psi> M K N P C. \<Psi> \<turnstile> M \<leftrightarrow> K \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) (K\<langle>N\<rangle> \<prec> P) ([]) (\<one>)"
  and   rBrOutput: "\<And>\<Psi> M K N P C. \<Psi> \<turnstile> M \<preceq> K \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) (\<exclamdown>K\<langle>N\<rangle> \<prec> P) ([]) (\<one>)"
  and   rCase: "\<And>\<Psi> P Rs \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto> Rs; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P Rs A\<^sub>P \<Psi>\<^sub>P;
                                            (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                            A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Rs; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) Rs ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P \<alpha> P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<alpha> \<prec> P') A\<^sub>P \<Psi>\<^sub>P; distinct(bn \<alpha>);
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) (\<alpha> \<prec> (P' \<parallel> Q)) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q \<alpha> Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<alpha> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q; distinct(bn \<alpha>);
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) (\<alpha> \<prec> (P \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P ((M\<lparr>N\<rparr>) \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>N\<rparr> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrMerge: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<questiondown>M\<lparr>N\<rparr> \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q;
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrComm1:"\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P ((\<questiondown>M\<lparr>N\<rparr>) \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrComm2:"\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrClose: "\<And>\<Psi> P M xvec N P' A\<^sub>P \<Psi>\<^sub>P x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                     x \<in> supp M;
                     \<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                     extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                     A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* xvec;
                     distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;
                     xvec \<sharp>* M;
                     x \<sharp> \<Psi>; x \<sharp> xvec; x \<sharp> A\<^sub>P;
                     A\<^sub>P \<sharp>* C; xvec \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau> \<prec> (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))) (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rOpen: "\<And>\<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P; x \<in> supp N; x \<sharp> \<Psi>; x \<sharp> M;
                     x \<sharp> A\<^sub>P; x \<sharp> xvec; x \<sharp> yvec; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* yvec; xvec \<sharp>* yvec; distinct xvec; distinct yvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P; yvec \<sharp>* \<Psi>\<^sub>P;
                     yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C; yvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBrOpen: "\<And>\<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P; x \<in> supp N; x \<sharp> \<Psi>; x \<sharp> M;
                     x \<sharp> A\<^sub>P; x \<sharp> xvec; x \<sharp> yvec; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* yvec; xvec \<sharp>* yvec; distinct xvec; distinct yvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P; yvec \<sharp>* \<Psi>\<^sub>P;
                     yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C; yvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rScope: "\<And>\<Psi> P \<alpha> P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P (\<alpha> \<prec> P') A\<^sub>P \<Psi>\<^sub>P;
                     x \<sharp> \<Psi>; x \<sharp> \<alpha>; x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;
                     A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; distinct(bn \<alpha>);
                     bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P;
                     A\<^sub>P \<sharp>* C; x \<sharp> C; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<alpha> \<prec> (\<lparr>\<nu>x\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P Rs A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto> Rs; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) Rs A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; supp \<Psi>\<^sub>P = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Rs; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) Rs ([]) (\<one>)"
shows "Prop C \<Psi> P Rs A\<^sub>P \<Psi>\<^sub>P"
  using Trans FrP \<open>distinct A\<^sub>P\<close>
proof(nominal_induct  avoiding: A\<^sub>P \<Psi>\<^sub>P C rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P A\<^sub>P \<Psi>\<^sub>P C)
  from \<open>extractFrame (M\<lparr>\<lambda>*xvec N\<rparr>.P) = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>
  have "A\<^sub>P = []" and "\<Psi>\<^sub>P = \<one>"
    by auto
  with \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* K\<close> \<open>xvec \<sharp>* C\<close>
  show ?case by(blast intro: rInput)
next
  case(cBrInput \<Psi> K M xvec N Tvec P A\<^sub>P \<Psi>\<^sub>P C)
  from \<open>extractFrame (M\<lparr>\<lambda>*xvec N\<rparr>.P) = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>
  have "A\<^sub>P = []" and "\<Psi>\<^sub>P = \<one>"
    by auto
  with \<open>\<Psi> \<turnstile> K \<succeq> M\<close> \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* K\<close> \<open>xvec \<sharp>* C\<close>
  show ?case by(blast intro: rBrInput)
next
  case(Output \<Psi> M K N P A\<^sub>P \<Psi>\<^sub>P)
  from \<open>extractFrame (M\<langle>N\<rangle>.P) = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>
  have "A\<^sub>P = []" and "\<Psi>\<^sub>P = \<one>"
    by auto
  with \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> show ?case
    by(blast intro: rOutput)
next
  case(BrOutput \<Psi> M K N P A\<^sub>P \<Psi>\<^sub>P)
  from \<open>extractFrame (M\<langle>N\<rangle>.P) = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>
  have "A\<^sub>P = []" and "\<Psi>\<^sub>P = \<one>"
    by auto
  with \<open>\<Psi> \<turnstile> M \<preceq> K\<close> show ?case
    by(blast intro: rBrOutput)
next
  case(Case \<Psi> P Rs \<phi> Cs A\<^sub>c\<^sub>P \<Psi>\<^sub>c\<^sub>P C)
  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    and "A\<^sub>P \<sharp>* (\<Psi>, P, Rs, C)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* Rs" and "A\<^sub>P \<sharp>* C"
    by simp+
  note \<open>\<Psi> \<rhd> P \<longmapsto> Rs\<close> FrP \<open>distinct A\<^sub>P\<close>
  moreover from FrP \<open>distinct A\<^sub>P\<close> \<open>\<And>A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P Rs A\<^sub>P \<Psi>\<^sub>P\<close>
  have "\<And>C. Prop C \<Psi> P Rs A\<^sub>P \<Psi>\<^sub>P" by simp
  moreover note \<open>(\<phi>, P) \<in> set Cs\<close> \<open>\<Psi> \<turnstile> \<phi>\<close> \<open>guarded P\<close>
  moreover from \<open>guarded P\<close> FrP have "\<Psi>\<^sub>P \<simeq> \<one>" and "supp \<Psi>\<^sub>P = ({}::name set)" by(metis guardedStatEq)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Rs\<close> \<open>A\<^sub>P \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (Cases Cs) Rs ([]) (\<one>)"
    by(rule rCase)
  then show ?case using \<open>extractFrame(Cases Cs) = \<langle>A\<^sub>c\<^sub>P, \<Psi>\<^sub>c\<^sub>P\<rangle>\<close> by simp
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    "A\<^sub>P \<sharp>* (P, Q, \<Psi>, \<alpha>, P', A\<^sub>Q, A\<^sub>P\<^sub>Q, C, \<Psi>\<^sub>Q)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* Q" and "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* \<alpha>" and "A\<^sub>P \<sharp>* P'"
    and "A\<^sub>P \<sharp>* A\<^sub>Q" and "A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q" and "A\<^sub>P \<sharp>* C" and "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by simp+

  have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

  from \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> FrP have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)

  from \<open>bn \<alpha> \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> FrP have "bn \<alpha> \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)

  from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> FrP FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  moreover from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  ultimately obtain p where S: "set p \<subseteq> set(A\<^sub>P@A\<^sub>Q) \<times> set((p \<bullet> A\<^sub>P)@(p \<bullet> A\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = (p \<bullet> A\<^sub>P)@(p \<bullet> A\<^sub>Q)"
    using \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
    apply -
    apply(rule frameChainEq')
    by (assumption | simp add: eqvts)+
  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close> FrQ \<open>distinct A\<^sub>Q\<close>

  moreover from FrP \<open>distinct A\<^sub>P\<close> \<open>\<And>A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P\<rbrakk> \<Longrightarrow> Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<alpha> \<prec> P') A\<^sub>P \<Psi>\<^sub>P\<close>
  have "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<alpha> \<prec> P') A\<^sub>P \<Psi>\<^sub>P" by simp

  moreover note \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close>
    \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>distinct(bn \<alpha>)\<close>
    \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close>  \<open>bn \<alpha> \<sharp>* Q\<close>  \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>  \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close>  \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<alpha> \<prec> (P' \<parallel> Q)) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rPar1)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
    S \<open>distinctPerm p\<close> Aeq
  have "Prop C \<Psi> (P \<parallel> Q) (\<alpha> \<prec> (P' \<parallel> Q)) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    apply -
    apply(rule rAlpha)
    by(assumption | simp add: eqvts)+
  with \<Psi>eq Aeq show ?case by(simp add: eqvts)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  obtain A\<^sub>Q \<Psi>\<^sub>Q where FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q"
    "A\<^sub>Q \<sharp>* (P, Q, \<Psi>, \<alpha>, Q', A\<^sub>P, A\<^sub>P\<^sub>Q, C, \<Psi>\<^sub>P)"
    by(rule freshFrame)
  then have "A\<^sub>Q \<sharp>* P" and "A\<^sub>Q \<sharp>* Q" and "A\<^sub>Q \<sharp>* \<Psi>" and "A\<^sub>Q \<sharp>* \<alpha>" and "A\<^sub>Q \<sharp>* Q'"
    and "A\<^sub>Q \<sharp>* A\<^sub>P" and "A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q" and "A\<^sub>Q \<sharp>* C" and "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by simp+

  from \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<close> have "A\<^sub>P \<sharp>* A\<^sub>Q" by simp
  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact

  from \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<close> FrQ have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by(force dest: extractFrameFreshChain)
  from \<open>bn \<alpha> \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> FrQ have "bn \<alpha> \<sharp>* \<Psi>\<^sub>Q"
    by(force dest: extractFrameFreshChain)

  from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> FrP FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  moreover from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  ultimately obtain p where S: "(set p \<subseteq> (set(A\<^sub>P@A\<^sub>Q)) \<times> (set A\<^sub>P\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = ((p \<bullet> A\<^sub>P)@(p \<bullet> A\<^sub>Q))"
    using \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
    apply -
    apply(rule frameChainEq')
    by(assumption | simp add: eqvts)+

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> FrP \<open>distinct A\<^sub>P\<close> FrQ \<open>distinct A\<^sub>Q\<close>

  moreover from FrQ \<open>distinct A\<^sub>Q\<close> \<open>\<And>A\<^sub>Q \<Psi>\<^sub>Q C. \<lbrakk>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q\<rbrakk> \<Longrightarrow> Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<alpha> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q\<close>
  have "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<alpha> \<prec> Q') A\<^sub>Q \<Psi>\<^sub>Q" by simp

  moreover note \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close>
    \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>distinct(bn \<alpha>)\<close>
    \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close>  \<open>bn \<alpha> \<sharp>* Q\<close>  \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>  \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close>  \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<alpha> \<prec> (P \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rPar2)

  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
    S \<open>distinctPerm p\<close> Aeq
  have "Prop C \<Psi> (P \<parallel> Q) (\<alpha> \<prec> (P \<parallel> Q')) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    apply -
    apply(rule rAlpha)
    by(assumption | simp add: eqvts)+
  with \<Psi>eq Aeq show ?case by(simp add: eqvts)
next
  case(cComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  from cComm1 have  "Prop C \<Psi> (P \<parallel> Q) (\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rComm1)
  moreover from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  with \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct(A\<^sub>P@A\<^sub>Q)\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
  obtain p where S: "(set p \<subseteq> (set(A\<^sub>P@A\<^sub>Q)) \<times> (set A\<^sub>P\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = p \<bullet> (A\<^sub>P@A\<^sub>Q)"
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* xvec\<close>
    \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    by(fastforce simp add: rAlpha)
  with \<Psi>eq Aeq show ?case by simp
next
  case(cComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  from cComm2 have  "Prop C \<Psi> (P \<parallel> Q) (\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rComm2)
  moreover from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  with \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct(A\<^sub>P@A\<^sub>Q)\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
  obtain p where S: "(set p \<subseteq> (set(A\<^sub>P@A\<^sub>Q)) \<times> (set A\<^sub>P\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = p \<bullet> (A\<^sub>P@A\<^sub>Q)"
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* xvec\<close>
    \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    by(fastforce intro: rAlpha)
  with \<Psi>eq Aeq show ?case by simp
next
  case(cBrMerge \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  from cBrMerge have "Prop C \<Psi> (P \<parallel> Q) (\<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(fastforce intro!: rBrMerge)
  moreover from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  with \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct(A\<^sub>P@A\<^sub>Q)\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
  obtain p where S: "(set p \<subseteq> (set(A\<^sub>P@A\<^sub>Q)) \<times> (set A\<^sub>P\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = p \<bullet> (A\<^sub>P@A\<^sub>Q)"
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close>
    \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    by(fastforce intro: rAlpha)
  with \<Psi>eq Aeq show ?case by simp
next
  case(cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  from cBrComm1 have  "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rBrComm1)
  moreover from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  with \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct(A\<^sub>P@A\<^sub>Q)\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
  obtain p where S: "(set p \<subseteq> (set(A\<^sub>P@A\<^sub>Q)) \<times> (set A\<^sub>P\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = p \<bullet> (A\<^sub>P@A\<^sub>Q)"
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* xvec\<close>
    \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    by(fastforce intro: rAlpha)
  with \<Psi>eq Aeq show ?case by simp
next
  case(cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q A\<^sub>P\<^sub>Q \<Psi>\<^sub>P\<^sub>Q C)
  from \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "distinct(A\<^sub>P@A\<^sub>Q)"
    by(auto simp add: fresh_star_def fresh_def name_list_supp)
  from cBrComm2 have "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rBrComm2)
  moreover from \<open>extractFrame(P \<parallel> Q) = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  have "\<langle>(A\<^sub>P@A\<^sub>Q), (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)\<rangle> = \<langle>A\<^sub>P\<^sub>Q, \<Psi>\<^sub>P\<^sub>Q\<rangle>"
    by simp
  with \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>distinct(A\<^sub>P@A\<^sub>Q)\<close> \<open>distinct A\<^sub>P\<^sub>Q\<close>
  obtain p where S: "(set p \<subseteq> (set(A\<^sub>P@A\<^sub>Q)) \<times> (set A\<^sub>P\<^sub>Q))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P\<^sub>Q = p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" and Aeq: "A\<^sub>P\<^sub>Q = p \<bullet> (A\<^sub>P@A\<^sub>Q)"
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* xvec\<close>
    \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* A\<^sub>P\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')) (p \<bullet> (A\<^sub>P@A\<^sub>Q)) (p \<bullet> (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q))"
    by(fastforce intro: rAlpha)
  with \<Psi>eq Aeq show ?case by simp
next
  case(cBrClose \<Psi> P M xvec N P' x A\<^sub>P' \<Psi>\<^sub>P' C)
  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    and "A\<^sub>P \<sharp>* (\<Psi>, P, M, xvec, N, P', A\<^sub>P', \<Psi>\<^sub>P', C, x)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* M" and "A\<^sub>P \<sharp>* xvec" and "A\<^sub>P \<sharp>* N" and "A\<^sub>P \<sharp>* P'"
    and "A\<^sub>P \<sharp>* A\<^sub>P'" and "A\<^sub>P \<sharp>* \<Psi>\<^sub>P'" and "A\<^sub>P \<sharp>* C" and "x \<sharp> A\<^sub>P"
    by simp+
  from FrP \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>xvec \<sharp>* P\<close> have "xvec \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)
  from \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>x \<sharp> A\<^sub>P\<close>
  have "A\<^sub>P \<sharp>* (\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))" by simp
  from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>extractFrame (\<lparr>\<nu>x\<rparr>P) = \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>\<close>
  have "\<langle>(x#A\<^sub>P), \<Psi>\<^sub>P\<rangle> = \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>" by simp
  with \<open>A\<^sub>P \<sharp>* A\<^sub>P'\<close> \<open>x \<sharp> A\<^sub>P'\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>P'\<close>
  obtain p where S: "(set p \<subseteq> (set (x#A\<^sub>P)) \<times> (set A\<^sub>P'))"  and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>P' = p \<bullet> \<Psi>\<^sub>P" and Aeq: "A\<^sub>P' = p \<bullet> (x#A\<^sub>P)"
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+

  from \<open>x \<sharp> A\<^sub>P'\<close> Aeq have "x \<sharp> (p \<bullet> (x#A\<^sub>P))" by simp
  moreover from S Aeq \<open>distinct A\<^sub>P'\<close> \<open>x \<sharp> A\<^sub>P'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>P'\<close> have "(p \<bullet> x) \<sharp> A\<^sub>P"
    by simp
  from cBrClose FrP \<open>distinct A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>P'\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>P'\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>xvec \<sharp>* C\<close> \<open>x \<sharp> C\<close>
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(force intro: rBrClose)

  moreover from Aeq \<open>A\<^sub>P \<sharp>* A\<^sub>P'\<close> have "A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P)" by simp
  moreover from Aeq \<open>(set p \<subseteq> (set (x#A\<^sub>P)) \<times> (set A\<^sub>P'))\<close>
  have "(set p \<subseteq> (set (x#A\<^sub>P)) \<times> (set (p \<bullet> (x#A\<^sub>P))))" by simp
  moreover from \<open>A\<^sub>P \<sharp>* P\<close> \<open>x \<sharp> A\<^sub>P\<close> have "A\<^sub>P \<sharp>* (\<lparr>\<nu>x\<rparr>P)" by simp
  moreover from S \<open>x \<sharp> A\<^sub>P'\<close> have "p \<bullet> x \<noteq> x"
    using Aeq by fastforce
  moreover from \<open>x \<sharp> A\<^sub>P'\<close> Aeq have "x \<sharp> p \<bullet> A\<^sub>P" by simp
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* (\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>distinctPerm p\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> C\<close> \<open>(p \<bullet> x) \<sharp> A\<^sub>P\<close>
  ultimately
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')) (p \<bullet> (x#A\<^sub>P)) (p \<bullet> \<Psi>\<^sub>P)"
    by(fastforce intro!: rAlpha simp add: abs_fresh)
  with \<Psi>eq Aeq show ?case by simp
next
  case(cOpen \<Psi> P M xvec yvec N P' x A\<^sub>x\<^sub>P \<Psi>\<^sub>x\<^sub>P C)
  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    and "A\<^sub>P \<sharp>* (\<Psi>, P, M, xvec, yvec, N, P', A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P, C, x)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* M" and "A\<^sub>P \<sharp>* xvec"and "A\<^sub>P \<sharp>* yvec" and "A\<^sub>P \<sharp>* N" and "A\<^sub>P \<sharp>* P'"
    and "A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P" and "A\<^sub>P \<sharp>* \<Psi>\<^sub>x\<^sub>P" and "A\<^sub>P \<sharp>* C" and "x \<sharp> A\<^sub>P"
    by simp+

  from \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> FrP have "xvec \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)
  from \<open>yvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> FrP have "yvec \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)

  from \<open>extractFrame(\<lparr>\<nu>x\<rparr>P) = \<langle>A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P\<rangle>\<close> FrP
  have "\<langle>(x#A\<^sub>P), \<Psi>\<^sub>P\<rangle> = \<langle>A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P\<rangle>"
    by simp
  moreover from \<open>x \<sharp> A\<^sub>P\<close> \<open>distinct A\<^sub>P\<close> have "distinct(x#A\<^sub>P)" by simp
  ultimately obtain p where S: "set p \<subseteq> set (x#A\<^sub>P) \<times> set (p \<bullet> (x#A\<^sub>P))" and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>x\<^sub>P = p \<bullet> \<Psi>\<^sub>P" and Aeq: "A\<^sub>x\<^sub>P = (p \<bullet> x)#(p \<bullet> A\<^sub>P)"
    using \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close>\<open>x \<sharp> A\<^sub>x\<^sub>P\<close> \<open>distinct A\<^sub>x\<^sub>P\<close>
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+

  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close>
  moreover from FrP \<open>distinct A\<^sub>P\<close> \<open>\<And>A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P\<close>
  have "\<And>C. Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P" by simp
  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<in> supp N\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close>
    \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close>  \<open>xvec \<sharp>* M\<close>  \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close>  \<open>yvec \<sharp>* M\<close>  \<open>yvec \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>yvec \<sharp>* C\<close> \<open>xvec \<sharp>* yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(metis rOpen)

  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> A\<^sub>x\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close> \<open>x \<sharp> A\<^sub>P\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> C\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> Aeq
    S \<open>distinctPerm p\<close>
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P') (p \<bullet> (x#A\<^sub>P)) (p \<bullet> \<Psi>\<^sub>P)"
    apply -
    apply(rule rAlpha[where A\<^sub>P="x#A\<^sub>P"])
    by(assumption | simp add: abs_fresh fresh_star_def boundOutputFresh)+
  with \<Psi>eq Aeq show ?case by(simp add: eqvts)
next
  case(cBrOpen \<Psi> P M xvec yvec N P' x A\<^sub>x\<^sub>P \<Psi>\<^sub>x\<^sub>P C)
  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    and "A\<^sub>P \<sharp>* (\<Psi>, P, M, xvec, yvec, N, P', A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P, C, x)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* M" and "A\<^sub>P \<sharp>* xvec"and "A\<^sub>P \<sharp>* yvec" and "A\<^sub>P \<sharp>* N" and "A\<^sub>P \<sharp>* P'"
    and "A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P" and "A\<^sub>P \<sharp>* \<Psi>\<^sub>x\<^sub>P" and "A\<^sub>P \<sharp>* C" and "x \<sharp> A\<^sub>P"
    by simp+

  from \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> FrP have "xvec \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)
  from \<open>yvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> FrP have "yvec \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)

  from \<open>extractFrame(\<lparr>\<nu>x\<rparr>P) = \<langle>A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P\<rangle>\<close> FrP
  have "\<langle>(x#A\<^sub>P), \<Psi>\<^sub>P\<rangle> = \<langle>A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P\<rangle>"
    by simp
  moreover from \<open>x \<sharp> A\<^sub>P\<close> \<open>distinct A\<^sub>P\<close> have "distinct(x#A\<^sub>P)" by simp
  ultimately obtain p where S: "set p \<subseteq> set (x#A\<^sub>P) \<times> set (p \<bullet> (x#A\<^sub>P))" and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>x\<^sub>P = p \<bullet> \<Psi>\<^sub>P" and Aeq: "A\<^sub>x\<^sub>P = (p \<bullet> x)#(p \<bullet> A\<^sub>P)"
    using \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close>\<open>x \<sharp> A\<^sub>x\<^sub>P\<close> \<open>distinct A\<^sub>x\<^sub>P\<close>
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+

  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close>
  moreover from FrP \<open>distinct A\<^sub>P\<close> \<open>\<And>A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P\<close>
  have "\<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P') A\<^sub>P \<Psi>\<^sub>P" by simp
  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<in> supp N\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close>
    \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close>  \<open>xvec \<sharp>* M\<close>  \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close>  \<open>yvec \<sharp>* M\<close>  \<open>yvec \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>yvec \<sharp>* C\<close> \<open>xvec \<sharp>* yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(metis rBrOpen)

  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> A\<^sub>x\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close> \<open>x \<sharp> A\<^sub>P\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> C\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> Aeq
    S \<open>distinctPerm p\<close>
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P') (p \<bullet> (x#A\<^sub>P)) (p \<bullet> \<Psi>\<^sub>P)"
    apply -
    apply(rule rAlpha[where A\<^sub>P="x#A\<^sub>P"])
    by(assumption | simp add: abs_fresh fresh_star_def boundOutputFresh)+
  with \<Psi>eq Aeq show ?case by(simp add: eqvts)
next
  case(cScope \<Psi> P \<alpha> P' x A\<^sub>x\<^sub>P \<Psi>\<^sub>x\<^sub>P C)
  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    and "A\<^sub>P \<sharp>* (\<Psi>, P, \<alpha>, P', A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P, C, x)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* \<alpha>" and "A\<^sub>P \<sharp>* P'"
    and "A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P" and "A\<^sub>P \<sharp>* \<Psi>\<^sub>x\<^sub>P" and "A\<^sub>P \<sharp>* C" and "x \<sharp> A\<^sub>P"
    by simp+

  from \<open>bn \<alpha> \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> FrP have "bn \<alpha> \<sharp>* \<Psi>\<^sub>P"
    by(force dest: extractFrameFreshChain)

  from \<open>extractFrame(\<lparr>\<nu>x\<rparr>P) = \<langle>A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P\<rangle>\<close> FrP
  have "\<langle>(x#A\<^sub>P), \<Psi>\<^sub>P\<rangle> = \<langle>A\<^sub>x\<^sub>P, \<Psi>\<^sub>x\<^sub>P\<rangle>"
    by simp
  moreover from \<open>x \<sharp> A\<^sub>P\<close> \<open>distinct A\<^sub>P\<close> have "distinct(x#A\<^sub>P)" by simp
  ultimately obtain p where S: "set p \<subseteq> set (x#A\<^sub>P) \<times> set (p \<bullet> (x#A\<^sub>P))" and "distinctPerm p"
    and \<Psi>eq: "\<Psi>\<^sub>x\<^sub>P = p \<bullet> \<Psi>\<^sub>P" and Aeq: "A\<^sub>x\<^sub>P = (p \<bullet> x)#(p \<bullet> A\<^sub>P)"
    using \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close>\<open>x \<sharp> A\<^sub>x\<^sub>P\<close> \<open>distinct A\<^sub>x\<^sub>P\<close>
    apply -
    apply(rule frameChainEq')
    by(assumption | simp)+

  note \<open>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close>
  moreover from FrP \<open>distinct A\<^sub>P\<close> \<open>\<And>A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P (\<alpha> \<prec> P') A\<^sub>P \<Psi>\<^sub>P\<close>
  have "\<And>C. Prop C \<Psi> P (\<alpha> \<prec> P') A\<^sub>P \<Psi>\<^sub>P" by simp
  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>distinct(bn \<alpha>)\<close>
    \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close>  \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>  \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>bn \<alpha> \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<alpha> \<prec> (\<lparr>\<nu>x\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(metis rScope)

  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>x \<sharp> A\<^sub>x\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>x\<^sub>P\<close> \<open>x \<sharp> A\<^sub>P\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> C\<close> Aeq
    S \<open>distinctPerm p\<close>
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<alpha> \<prec> (\<lparr>\<nu>x\<rparr>P')) (p \<bullet> (x#A\<^sub>P)) (p \<bullet> \<Psi>\<^sub>P)"
    apply -
    apply(rule rAlpha[where A\<^sub>P="x#A\<^sub>P"])
    by(assumption | simp add: abs_fresh fresh_star_def)+
  with \<Psi>eq Aeq show ?case by(simp add: eqvts)
next
  case(Bang \<Psi> P Rs A\<^sub>b\<^sub>P \<Psi>\<^sub>b\<^sub>P C)

  obtain A\<^sub>P \<Psi>\<^sub>P where FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P"
    and "A\<^sub>P \<sharp>* (\<Psi>, P, Rs, C)"
    by(rule freshFrame)
  then have "A\<^sub>P \<sharp>* \<Psi>" and "A\<^sub>P \<sharp>* P" and "A\<^sub>P \<sharp>* Rs" and "A\<^sub>P \<sharp>* C"
    by simp+

  note \<open>\<Psi> \<rhd> P \<parallel> !P \<longmapsto> Rs\<close> \<open>guarded P\<close> FrP \<open>distinct A\<^sub>P\<close>
  moreover from FrP have "extractFrame (P \<parallel> !P) = \<langle>A\<^sub>P, \<Psi>\<^sub>P \<otimes> \<one>\<rangle>"
    by simp
  with \<open>distinct A\<^sub>P\<close> \<open>\<And>A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>extractFrame (P \<parallel> !P) = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> (P \<parallel> !P) Rs A\<^sub>P \<Psi>\<^sub>P\<close>
  have "\<And>C. Prop C \<Psi> (P \<parallel> !P) Rs A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>)" by simp
  moreover from \<open>guarded P\<close> FrP have "\<Psi>\<^sub>P \<simeq> \<one>" and "supp \<Psi>\<^sub>P = ({}::name set)" by(metis guardedStatEq)+
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Rs\<close> \<open>A\<^sub>P \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (!P) Rs ([]) (\<one>)"
    by(rule rBang)
  then show ?case using \<open>extractFrame(!P) = \<langle>A\<^sub>b\<^sub>P, \<Psi>\<^sub>b\<^sub>P\<rangle>\<close> by simp
qed

lemma semanticsFrameInduct'[consumes 5, case_names cAlpha cFrameAlpha cInput cBrInput cOutput cBrOutput cCase cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2 cBrClose cOpen cBrOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and Rs   :: "('a, 'b, 'c) residual"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P   :: 'b
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> 'a action \<Rightarrow>
                 ('a, 'b, 'c) psi \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   "distinct(bn \<alpha>)"
  and   rAlpha: "\<And>\<Psi> P \<alpha> P' p A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P;
                                           bn \<alpha> \<sharp>* C; bn \<alpha> \<sharp>* (p \<bullet> \<alpha>); A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C;
                                           set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>)); distinctPerm p;
                                           bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>; (bn(p \<bullet> \<alpha>)) \<sharp>* P'; Prop C \<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow>
                                           Prop C \<Psi> P (p \<bullet> \<alpha>) (p \<bullet> P') A\<^sub>P \<Psi>\<^sub>P"
  and   rFrameAlpha: "\<And>\<Psi> P A\<^sub>P \<Psi>\<^sub>P p \<alpha> P' C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C;
                                                set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P); distinctPerm p; A\<^sub>P \<sharp>* subject \<alpha>;
                                                Prop C \<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P \<alpha> P' (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              (K\<lparr>(N[xvec::=Tvec])\<rparr>) (P[xvec::=Tvec]) ([]) (\<one>)"
  and   rBrInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              (\<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr>) (P[xvec::=Tvec]) ([]) (\<one>)"
  and   rOutput: "\<And>\<Psi> M K N P C. \<Psi> \<turnstile> M \<leftrightarrow> K \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) (K\<langle>N\<rangle>) P ([]) (\<one>)"
  and   rBrOutput: "\<And>\<Psi> M K N P C. \<Psi> \<turnstile> M \<preceq> K \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) (\<exclamdown>K\<langle>N\<rangle>) P ([]) (\<one>)"
  and   rCase: "\<And>\<Psi> P \<alpha> P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P;
                                            (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                            A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) \<alpha> P' ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P \<alpha> P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) \<alpha> (P' \<parallel> Q) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q \<alpha> Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q \<alpha> Q' A\<^sub>Q \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) \<alpha> (P \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>N\<rparr>) P' A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) Q' A\<^sub>Q \<Psi>\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>N\<rparr>) Q' A\<^sub>Q \<Psi>\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrMerge: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<questiondown>M\<lparr>N\<rparr>) P' A\<^sub>P \<Psi>\<^sub>P;
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr>) Q' A\<^sub>Q \<Psi>\<^sub>Q;
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<questiondown>M\<lparr>N\<rparr>) (P' \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrComm1:"\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<questiondown>M\<lparr>N\<rparr>) P' A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    distinct xvec;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) Q' A\<^sub>Q \<Psi>\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrComm2:"\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr>) Q' A\<^sub>Q \<Psi>\<^sub>Q;
                    distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrClose: "\<And>\<Psi> P M xvec N P' A\<^sub>P \<Psi>\<^sub>P x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                     x \<in> supp M;
                     \<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P;
                     extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                     A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* xvec;
                     distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;
                     xvec \<sharp>* M;
                     x \<sharp> \<Psi>; x \<sharp> xvec; x \<sharp> A\<^sub>P;
                     A\<^sub>P \<sharp>* C; xvec \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau>) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rOpen: "\<And>\<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P y C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P; x \<in> supp N; x \<sharp> \<Psi>; x \<sharp> M;
                     x \<sharp> A\<^sub>P; x \<sharp> xvec; x \<sharp> yvec; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* yvec; xvec \<sharp>* yvec; distinct xvec; distinct yvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P;
                     yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C; yvec \<sharp>* C;
                     y \<noteq> x; y \<sharp> \<Psi>; y \<sharp> P; y \<sharp> M; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> N; y \<sharp> P'; y \<sharp> A\<^sub>P; y \<sharp> \<Psi>\<^sub>P; y \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>) ([(x, y)] \<bullet> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBrOpen: "\<And>\<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P y C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P; x \<in> supp N; x \<sharp> \<Psi>; x \<sharp> M;
                     x \<sharp> A\<^sub>P; x \<sharp> xvec; x \<sharp> yvec; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* yvec; xvec \<sharp>* yvec; distinct xvec; distinct yvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P;
                     yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C; yvec \<sharp>* C;
                     y \<noteq> x; y \<sharp> \<Psi>; y \<sharp> P; y \<sharp> M; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> N; y \<sharp> P'; y \<sharp> A\<^sub>P; y \<sharp> \<Psi>\<^sub>P; y \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>) ([(x, y)] \<bullet> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rScope: "\<And>\<Psi> P \<alpha> P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P;
                     x \<sharp> \<Psi>; x \<sharp> \<alpha>; x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;
                     A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P';
                     bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P;
                     A\<^sub>P \<sharp>* C; x \<sharp> C; bn \<alpha> \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) \<alpha> (\<lparr>\<nu>x\<rparr>P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<alpha> \<prec> P'; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) \<alpha> P' A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; supp \<Psi>\<^sub>P = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) \<alpha> P' ([]) (\<one>)"
shows "Prop C \<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P"
  using Trans FrP \<open>distinct A\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close>
proof(nominal_induct \<Psi> P Rs=="\<alpha> \<prec> P'" A\<^sub>P \<Psi>\<^sub>P avoiding: C \<alpha> P' rule: semanticsFrameInduct)
  case cAlpha
  then show ?case using rFrameAlpha
    by auto
next
  case cInput
  then show ?case using rInput
    by(auto simp add: residualInject)
next
  case cBrInput
  then show ?case using rBrInput
    by(auto simp add: residualInject)
next
  case cOutput
  then show ?case using rOutput
    by(auto simp add: residualInject)
next
  case cBrOutput
  then show ?case using rBrOutput
    by(auto simp add: residualInject)
next
  case cCase
  then show ?case using rCase
    by(auto simp add: residualInject)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P \<alpha> P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C \<alpha>' P'')
  note \<open>\<alpha> \<prec> (P' \<parallel> Q) = \<alpha>' \<prec> P''\<close>
  moreover from \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> have "bn \<alpha> \<sharp>* (bn \<alpha>')" by auto
  moreover note \<open>distinct (bn \<alpha>)\<close> \<open>distinct(bn \<alpha>')\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha>' \<sharp>* subject \<alpha>'\<close>
  have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P' \<parallel> Q)" and "bn \<alpha>' \<sharp>* (\<alpha>' \<prec> P'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn \<alpha>)) \<times> (set(bn(p \<bullet> \<alpha>)))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha>' = p \<bullet> \<alpha>" and P'eq: "P'' = p \<bullet> (P' \<parallel> Q)" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* (P' \<parallel> Q)"
    by(rule residualEq)

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>distinct A\<^sub>Q\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close>
  have "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P" by(fastforce intro: cPar1)

  moreover note \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>bn \<alpha> \<sharp>* Q\<close> \<open>distinct(bn \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close>
    \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) \<alpha> (P' \<parallel> Q) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(metis rPar1)
  with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* (bn \<alpha>')\<close> S \<open>distinctPerm p\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* (P' \<parallel> Q)\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>'\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>'\<close> \<alpha>Eq \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
  have "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> \<alpha>) (p \<bullet> (P' \<parallel> Q)) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(fastforce intro!: rAlpha)
  with \<alpha>Eq P'eq \<open>distinctPerm p\<close> show ?case by simp
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q \<alpha> Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C \<alpha>' Q'')
  note \<open>\<alpha> \<prec> (P \<parallel> Q') = \<alpha>' \<prec> Q''\<close>
  moreover from \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> have "bn \<alpha> \<sharp>* (bn \<alpha>')" by auto
  moreover note \<open>distinct (bn \<alpha>)\<close> \<open>distinct(bn \<alpha>')\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha>' \<sharp>* subject \<alpha>'\<close>
  have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P \<parallel> Q')" and "bn \<alpha>' \<sharp>* (\<alpha>' \<prec> Q'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn \<alpha>)) \<times> (set(bn(p \<bullet> \<alpha>)))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha>' = p \<bullet> \<alpha>" and Q'eq: "Q'' = p \<bullet> (P \<parallel> Q')" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* (P \<parallel> Q')"
    by(rule residualEq)

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close>
  have "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q \<alpha> Q' A\<^sub>Q \<Psi>\<^sub>Q" by(fastforce intro!: cPar2)

  moreover note \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>bn \<alpha> \<sharp>* Q\<close> \<open>distinct(bn \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close>
    \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close>
  ultimately have "Prop C \<Psi> (P \<parallel> Q) \<alpha> (P \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(fastforce intro!: rPar2)
  with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* (bn \<alpha>')\<close> S \<open>distinctPerm p\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* (P \<parallel> Q')\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>'\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>'\<close> \<alpha>Eq \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close>
  have "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> \<alpha>) (p \<bullet> (P \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(fastforce intro!: rAlpha)
  with \<alpha>Eq Q'eq \<open>distinctPerm p\<close> show ?case by simp
next
  case(cComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C \<alpha> P'')
  then show ?case using rComm1
    apply -
    apply(drule meta_spec[where x="M\<lparr>N\<rparr>"])
    apply(drule meta_spec[where x="K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>"])
    by(auto simp add: residualInject)
next
  case(cComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q C \<alpha> Q'')
  then show ?case using rComm2
    apply -
    apply(drule meta_spec[where x="M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>"])
    apply(drule meta_spec[where x="K\<lparr>N\<rparr>"])
    by(auto simp add: residualInject)
next
  case(cBrMerge \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C \<alpha> P'')
  then show ?case using rBrMerge
    apply -
    apply(drule meta_spec[where x="\<questiondown>M\<lparr>N\<rparr>"])
    apply(drule meta_spec[where x="\<questiondown>M\<lparr>N\<rparr>"])
    by(auto simp add: residualInject)
next
  case(cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C \<alpha> P'')
  have "bn (\<questiondown>M\<lparr>N\<rparr>) \<sharp>* subject (\<questiondown>M\<lparr>N\<rparr>)" by simp
  moreover have "distinct (bn (\<questiondown>M\<lparr>N\<rparr>))" by simp
  moreover have "\<questiondown>M\<lparr>N\<rparr> \<prec> P' = \<questiondown>M\<lparr>N\<rparr> \<prec> P'" by simp
  moreover note cBrComm1
  ultimately have inProp: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<questiondown>M\<lparr>N\<rparr>) P' A\<^sub>P \<Psi>\<^sub>P" by simp

  note \<open>xvec \<sharp>* M\<close> \<open>distinct xvec\<close> cBrComm1
  then have outProp: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) Q' A\<^sub>Q \<Psi>\<^sub>Q" by simp

  note inProp outProp cBrComm1
  then have bigProp: "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q') (A\<^sub>P @ A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" by (simp add: rBrComm1)

  note \<open>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q') = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (bn \<alpha>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover note \<open>distinct(bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>
  have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q')" and "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<times> (set(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha> = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" and P'eq: "P'' = p \<bullet> (P' \<parallel> Q')"
    and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')"
    by(rule residualEq) simp

  from \<open>xvec \<sharp>* \<Psi>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* \<Psi>" by simp
  moreover from \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (P \<parallel> Q)" by simp
  moreover note \<open>xvec \<sharp>* M\<close>
  moreover from \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>Q\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" by auto
  moreover from \<open>xvec \<sharp>* C\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* C" by simp
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<alpha>Eq have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* \<Psi>" by simp
  moreover from \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* P\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* (P \<parallel> Q)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* \<alpha>" by simp
  moreover from \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* (P' \<parallel> Q')" by simp
  moreover from \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* C" by simp
  moreover note S \<open>distinctPerm p\<close> \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close>
    \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')\<close> bigProp
    \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* N\<close>

  ultimately have "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) (p \<bullet> (P' \<parallel> Q')) (A\<^sub>P @ A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(fastforce intro!: rAlpha)
  then show ?case using \<alpha>Eq P'eq by simp
next
  case(cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C \<alpha> Q'')
  have "bn (\<questiondown>M\<lparr>N\<rparr>) \<sharp>* subject (\<questiondown>M\<lparr>N\<rparr>)" by simp
  moreover have "distinct (bn (\<questiondown>M\<lparr>N\<rparr>))" by simp
  moreover have "\<questiondown>M\<lparr>N\<rparr> \<prec> Q' = \<questiondown>M\<lparr>N\<rparr> \<prec> Q'" by simp
  moreover note cBrComm2
  ultimately have inProp: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (\<questiondown>M\<lparr>N\<rparr>) Q' A\<^sub>Q \<Psi>\<^sub>Q" by simp

  from \<open>xvec \<sharp>* M\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover have "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
  moreover note cBrComm2
  ultimately have outProp: "\<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P" by simp

  note inProp outProp cBrComm2
  then have bigProp: "Prop C \<Psi> (P \<parallel> Q) (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q') (A\<^sub>P @ A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" by (simp add: rBrComm2)

  note \<open>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q') = \<alpha> \<prec> Q''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (bn \<alpha>)" by simp
  moreover note \<open>distinct (bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover from \<open>bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>
  have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q')" and "bn \<alpha> \<sharp>* (\<alpha> \<prec> Q'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<times> (set(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha> = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" and P'eq: "Q'' = p \<bullet> (P' \<parallel> Q')" and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)"
    and "(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')"
    by(rule residualEq)

  from \<open>xvec \<sharp>* \<Psi>\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* \<Psi>" by simp
  moreover from \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (P \<parallel> Q)" by simp
  moreover note \<open>bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close>
  moreover from \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>Q\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" by auto
  moreover from \<open>xvec \<sharp>* C\<close> have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* C" by simp
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<alpha>Eq have "bn (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* \<Psi>" by simp
  moreover from \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* P\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* (P \<parallel> Q)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* \<alpha>" by simp
  moreover from \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* (P' \<parallel> Q')" by simp
  moreover from \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> have "(A\<^sub>P @ A\<^sub>Q) \<sharp>* C" by simp
  moreover note S \<open>distinctPerm p\<close> \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)\<close>
    \<open>(bn(p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))) \<sharp>* (P' \<parallel> Q')\<close> bigProp
    \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* N\<close>

  ultimately have "Prop C \<Psi> (P \<parallel> Q) (p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) (p \<bullet> (P' \<parallel> Q')) (A\<^sub>P @ A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
    by(fastforce intro!: rAlpha)
  then show ?case using \<alpha>Eq P'eq by simp
next
  case(cBrClose \<Psi> P M xvec N P' A\<^sub>P \<Psi>\<^sub>P x C \<alpha> P'')
  note \<open>\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P') = \<alpha> \<prec> P''\<close>
  moreover have "bn (\<tau>) \<sharp>* (bn \<alpha>)" by simp
  moreover have "distinct (bn (\<tau>))" by simp
  moreover note \<open>distinct (bn \<alpha>)\<close>
  moreover have "(bn (\<tau>) \<sharp>* (\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')))" by simp
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn (\<tau>))) \<times> (set(bn(p \<bullet> (\<tau>))))"
    and \<alpha>Eq: "\<alpha> = p \<bullet> (\<tau>)" and P'eq: "P'' = p \<bullet> (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"
    and "bn (\<tau>) \<sharp>* \<alpha>" and "bn (\<tau>) \<sharp>* P''"
    and "(bn(p \<bullet> (\<tau>))) \<sharp>* (\<tau>)" and "(bn(p \<bullet> (\<tau>))) \<sharp>* (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"
    by(rule residualEq) simp
  moreover from cBrClose have "\<And>C. Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P" by simp
  moreover with cBrClose have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<tau>) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(simp add: rBrClose)
  with S have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (p \<bullet> \<tau>) (p \<bullet> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P" by simp
  then show ?case using \<alpha>Eq P'eq
    by simp
next
  case(cOpen \<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P C \<alpha> P'')
  note \<open>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close> have "(xvec@x#yvec) \<sharp>* (bn \<alpha>)"
    by auto
  moreover from \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  have "distinct(xvec@x#yvec)"
    by(auto simp add: fresh_star_def) (simp add: fresh_def name_list_supp)
  moreover note \<open>distinct(bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@x#yvec) \<sharp>* M" by auto
  then have "(xvec@x#yvec) \<sharp>* (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P')" by auto
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(xvec@x#yvec)) \<times> (set(p \<bullet> (xvec@x#yvec)))" and "distinctPerm p"
    and \<alpha>eq: "\<alpha> = (p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>" and P'eq: "P'' = (p \<bullet> P')"
    and A: "(xvec@x#yvec) \<sharp>* ((p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>)"
    and B: "(p \<bullet> (xvec@x#yvec)) \<sharp>* (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>)"
    and C: "(p \<bullet> (xvec@x#yvec)) \<sharp>* P'"
    apply -
    apply(rule residualEq)
    by(assumption | simp)+

  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>x \<in> (supp N)\<close>

  moreover {
    fix C
    from \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@yvec) \<sharp>* M" by simp
    moreover from \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec \<sharp>* yvec\<close> have "distinct(xvec@yvec)"
      by (auto simp add: fresh_star_def name_list_supp fresh_def)
    ultimately have "Prop C \<Psi> P (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P" using \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* N\<close>
      by(fastforce intro!: cOpen)
  }
  moreover obtain y::name where "y \<sharp> \<Psi>" and "y \<noteq> x" and "y \<sharp> P" and "y \<sharp> xvec" and "y \<sharp> yvec" and "y \<sharp> \<alpha>" and "y \<sharp> P'" and "y \<sharp> A\<^sub>P" and "y \<sharp> \<Psi>\<^sub>P" and "y \<sharp> M" and "y \<sharp> N" and "y \<sharp> C" and "y \<sharp> p"
    by(generate_fresh "name") auto
  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close> \<open>yvec \<sharp>* M\<close> \<open>yvec \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
    \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>) ([(x, y)] \<bullet> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(metis rOpen)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> M) = [(x, y)] \<bullet> p \<bullet> M"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> M\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq \<open>y \<sharp> p\<close> \<open>x \<sharp> M\<close> have D: "(([(x, y)] \<bullet> p) \<bullet> M) = p \<bullet> M"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> xvec) = [(x, y)] \<bullet> p \<bullet> xvec"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> xvec\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq \<open>y \<sharp> p\<close> \<open>x \<sharp> xvec\<close> have E: "(([(x, y)] \<bullet> p) \<bullet> xvec) = p \<bullet> xvec"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> yvec) = [(x, y)] \<bullet> p \<bullet> yvec"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> yvec\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq \<open>y \<sharp> p\<close> \<open>x \<sharp> yvec\<close> have F: "(([(x, y)] \<bullet> p) \<bullet> yvec) = p \<bullet> yvec"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> x) = [(x, y)] \<bullet> p \<bullet> x"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<noteq> x\<close> \<open>y \<sharp> p\<close> have G: "(([(x, y)] \<bullet> p) \<bullet> y) = p \<bullet> x"
    apply(simp add: freshChainSimps calc_atm)
    apply(subgoal_tac "y \<noteq> p \<bullet> x")
     apply(clarsimp)
    using A \<alpha>eq
     apply(simp add: eqvts)
    apply(subst fresh_atm[symmetric])
    apply(simp only: freshChainSimps)
    by simp
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> N) = [(x, y)] \<bullet> p \<bullet> N"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> N\<close> \<open>x \<sharp> \<alpha>\<close> \<open>y \<sharp> p\<close> \<alpha>eq have H: "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> N) = p \<bullet> N"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> P') = [(x, y)] \<bullet> p \<bullet> P'"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> P'\<close> \<open>x \<sharp> P''\<close> \<open>y \<sharp> p\<close> P'eq have I: "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> P') = p \<bullet> P'"
    by(auto simp add: eqvts freshChainSimps)
  from \<open>y \<sharp> p\<close> \<open>y \<noteq> x\<close> have "y \<noteq> p \<bullet> x"
    apply(subst fresh_atm[symmetric])
    apply(simp only: freshChainSimps)
    by simp
  moreover from S have "([(x, y)] \<bullet> set p) \<subseteq> [(x, y)] \<bullet> (set(xvec@x#yvec) \<times> set(p \<bullet> (xvec@x#yvec)))"
    by(simp)
  with \<open>y \<noteq> p \<bullet> x\<close> \<open>(([(x, y)] \<bullet> p) \<bullet> y) = p \<bullet> x\<close> \<open>x \<sharp> xvec\<close> \<open>y \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>y \<sharp> yvec\<close> \<open>y \<sharp> p\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq have
    "set([(x, y)] \<bullet> p) \<subseteq> set(xvec@y#yvec) \<times> set(([(x, y)] \<bullet> p) \<bullet> (xvec@y#yvec))"
    by(simp add: eqvts calc_atm perm_compose)
  moreover note \<open>xvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* C\<close>  S \<open>distinctPerm p\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>yvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>x \<sharp> \<Psi>\<close>
    \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    A B C  \<alpha>eq \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>y \<sharp> \<Psi>\<close> \<open>y \<noteq> x\<close> \<open>y \<sharp> P\<close> \<open>y \<sharp> M\<close> \<open>y \<sharp> \<Psi>\<^sub>P\<close> \<open>y \<sharp> C\<close> \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close> \<open>y \<sharp> \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>y \<sharp> A\<^sub>P\<close> \<open>y \<sharp> N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>y \<sharp> P'\<close> \<open>A\<^sub>P \<sharp>* C\<close> P'eq
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (([(x, y)] \<bullet> p) \<bullet> (M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>)) (([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    apply -
    apply(rule rAlpha[where \<alpha>="M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>"])
                   apply(assumption | simp)+
              apply(simp add: eqvts)
             apply(assumption | simp add: abs_fresh)+
           apply(simp add: fresh_left calc_atm)
          apply(assumption | simp)+
          apply(simp add: fresh_left calc_atm)
         apply(assumption | simp)+
    by(simp add: eqvts fresh_left)+
  with \<alpha>eq P'eq D E F G H I show ?case
    by(simp add: eqvts)
next
  case(cBrOpen \<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P C \<alpha> P'')
  note \<open>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' = \<alpha> \<prec> P''\<close>
  moreover from \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close> have "(xvec@x#yvec) \<sharp>* (bn \<alpha>)"
    by auto
  moreover from \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
  have "distinct(xvec@x#yvec)"
    by(auto simp add: fresh_star_def) (simp add: fresh_def name_list_supp)
  moreover note \<open>distinct(bn \<alpha>)\<close>
  moreover from \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@x#yvec) \<sharp>* M" by auto
  then have "(xvec@x#yvec) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P')" by auto
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> P'')" by simp
  ultimately obtain p where S: "(set p) \<subseteq> (set(xvec@x#yvec)) \<times> (set(p \<bullet> (xvec@x#yvec)))" and "distinctPerm p"
    and \<alpha>eq: "\<alpha> = \<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>" and P'eq: "P'' = (p \<bullet> P')"
    and A: "(xvec@x#yvec) \<sharp>* (\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> (xvec@x#yvec))\<rparr>\<langle>(p \<bullet> N)\<rangle>)"
    and B: "(p \<bullet> (xvec@x#yvec)) \<sharp>* (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle>)"
    and C: "(p \<bullet> (xvec@x#yvec)) \<sharp>* P'"
    apply -
    apply(rule residualEq)
    by(assumption | simp)+

  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>x \<in> (supp N)\<close>

  moreover {
    fix C
    from \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close> have "(xvec@yvec) \<sharp>* M" by simp
    moreover from \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec \<sharp>* yvec\<close> have "distinct(xvec@yvec)"
      by auto (simp add: fresh_star_def name_list_supp fresh_def)
    ultimately have "Prop C \<Psi> P (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle>) P' A\<^sub>P \<Psi>\<^sub>P" using \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* N\<close>
      by(fastforce intro!: cBrOpen)
  }
  moreover obtain y::name where "y \<sharp> \<Psi>" and "y \<noteq> x" and "y \<sharp> P" and "y \<sharp> xvec" and "y \<sharp> yvec" and "y \<sharp> \<alpha>" and "y \<sharp> P'" and "y \<sharp> A\<^sub>P" and "y \<sharp> \<Psi>\<^sub>P" and "y \<sharp> M" and "y \<sharp> N" and "y \<sharp> C" and "y \<sharp> p"
    by(generate_fresh "name") auto
  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* P\<close> \<open>yvec \<sharp>* M\<close> \<open>yvec \<sharp>* C\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>distinct xvec\<close> \<open>distinct yvec\<close>
    \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<exclamdown>M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>) ([(x, y)] \<bullet> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(metis rBrOpen)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> M) = [(x, y)] \<bullet> p \<bullet> M"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> M\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq \<open>y \<sharp> p\<close> \<open>x \<sharp> M\<close> have D: "(([(x, y)] \<bullet> p) \<bullet> M) = p \<bullet> M"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> xvec) = [(x, y)] \<bullet> p \<bullet> xvec"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> xvec\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq \<open>y \<sharp> p\<close> \<open>x \<sharp> xvec\<close> have E: "(([(x, y)] \<bullet> p) \<bullet> xvec) = p \<bullet> xvec"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> yvec) = [(x, y)] \<bullet> p \<bullet> yvec"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> yvec\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq \<open>y \<sharp> p\<close> \<open>x \<sharp> yvec\<close> have F: "(([(x, y)] \<bullet> p) \<bullet> yvec) = p \<bullet> yvec"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> x) = [(x, y)] \<bullet> p \<bullet> x"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<noteq> x\<close> \<open>y \<sharp> p\<close> have G: "(([(x, y)] \<bullet> p) \<bullet> y) = p \<bullet> x"
    apply(simp add: freshChainSimps calc_atm)
    apply(subgoal_tac "y \<noteq> p \<bullet> x")
     apply(clarsimp)
    using A \<alpha>eq
     apply(simp add: eqvts)
    apply(subst fresh_atm[symmetric])
    apply(simp only: freshChainSimps)
    by simp
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> N) = [(x, y)] \<bullet> p \<bullet> N"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> N\<close> \<open>x \<sharp> \<alpha>\<close> \<open>y \<sharp> p\<close> \<alpha>eq have H: "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> N) = p \<bullet> N"
    by(auto simp add: eqvts freshChainSimps)
  moreover have "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> P') = [(x, y)] \<bullet> p \<bullet> P'"
    by(subst perm_compose[symmetric]) simp
  with \<open>y \<sharp> P'\<close> \<open>x \<sharp> P''\<close> \<open>y \<sharp> p\<close> P'eq have I: "(([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> P') = p \<bullet> P'"
    by(auto simp add: eqvts freshChainSimps)
  from \<open>y \<sharp> p\<close> \<open>y \<noteq> x\<close> have "y \<noteq> p \<bullet> x"
    apply(subst fresh_atm[symmetric])
    apply(simp only: freshChainSimps)
    by simp
  moreover from S have "([(x, y)] \<bullet> set p) \<subseteq> [(x, y)] \<bullet> (set(xvec@x#yvec) \<times> set(p \<bullet> (xvec@x#yvec)))"
    by(simp)
  with \<open>y \<noteq> p \<bullet> x\<close> \<open>(([(x, y)] \<bullet> p) \<bullet> y) = p \<bullet> x\<close> \<open>x \<sharp> xvec\<close> \<open>y \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>y \<sharp> yvec\<close> \<open>y \<sharp> p\<close> \<open>x \<sharp> \<alpha>\<close> \<alpha>eq have
    "set([(x, y)] \<bullet> p) \<subseteq> set(xvec@y#yvec) \<times> set(([(x, y)] \<bullet> p) \<bullet> (xvec@y#yvec))"
    by(simp add: eqvts calc_atm perm_compose)
  moreover note \<open>xvec \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>xvec \<sharp>* M\<close> \<open>yvec \<sharp>* M\<close>
    \<open>yvec \<sharp>* C\<close>  S \<open>distinctPerm p\<close> \<open>x \<sharp> C\<close> \<open>xvec \<sharp>* C\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>yvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>x \<sharp> \<Psi>\<close>
    \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    A B C  \<alpha>eq \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>y \<sharp> \<Psi>\<close> \<open>y \<noteq> x\<close> \<open>y \<sharp> P\<close> \<open>y \<sharp> M\<close> \<open>y \<sharp> \<Psi>\<^sub>P\<close> \<open>y \<sharp> C\<close> \<open>xvec \<sharp>* \<alpha>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>yvec \<sharp>* \<alpha>\<close> \<open>y \<sharp> \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>y \<sharp> A\<^sub>P\<close> \<open>y \<sharp> N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>y \<sharp> P'\<close> \<open>A\<^sub>P \<sharp>* C\<close> P'eq
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (([(x, y)] \<bullet> p) \<bullet> (\<exclamdown>M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>)) (([(x, y)] \<bullet> p) \<bullet> [(x, y)] \<bullet> P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    apply -
    apply(rule rAlpha[where \<alpha>="\<exclamdown>M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle>"])
                   apply(assumption | simp)+  (* slow proof step *)
              apply(simp add: eqvts)
             apply(assumption | simp add: abs_fresh)+
           apply(simp add: fresh_left calc_atm)
          apply(assumption | simp)+
          apply(simp add: fresh_left calc_atm)
         apply(assumption | simp)+
    by(simp add: eqvts fresh_left)+
  with \<alpha>eq P'eq D E F G H I show ?case
    by(simp add: eqvts)
next
  case(cScope \<Psi> P \<alpha> P' x A\<^sub>P \<Psi>\<^sub>P C \<alpha>' P'')
  note \<open>\<alpha> \<prec> (\<lparr>\<nu>x\<rparr>P') = \<alpha>' \<prec> P''\<close>
  moreover from \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> have "bn \<alpha> \<sharp>* (bn \<alpha>')" by auto
  moreover note \<open>distinct (bn \<alpha>)\<close> \<open>distinct(bn \<alpha>')\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha>' \<sharp>* subject \<alpha>'\<close>
  have "bn \<alpha> \<sharp>* (\<alpha> \<prec> \<lparr>\<nu>x\<rparr>P')" and "bn \<alpha>' \<sharp>* (\<alpha>' \<prec> P'')" by simp+
  ultimately obtain p where S: "(set p) \<subseteq> (set(bn \<alpha>)) \<times> (set(bn(p \<bullet> \<alpha>)))" and "distinctPerm p"
    and \<alpha>Eq: "\<alpha>' = p \<bullet> \<alpha>" and P'eq: "P'' = p \<bullet> (\<lparr>\<nu>x\<rparr>P')" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* (\<lparr>\<nu>x\<rparr>P')"
    by(rule residualEq)

  note \<open>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close>
  moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinct(bn \<alpha>)\<close>
  have "\<And>C. Prop C \<Psi> P \<alpha> P' A\<^sub>P \<Psi>\<^sub>P" by(fastforce intro!: cScope)

  moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>x \<sharp> C\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>distinct(bn \<alpha>)\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>
    \<open>distinct A\<^sub>P\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* C\<close>
  ultimately have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) \<alpha> (\<lparr>\<nu>x\<rparr>P') (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(metis rScope)
  with \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>x \<sharp> \<alpha>\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn \<alpha> \<sharp>* C\<close> \<open>bn \<alpha> \<sharp>* (bn \<alpha>')\<close> S \<open>distinctPerm p\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* (\<lparr>\<nu>x\<rparr>P')\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>'\<close> \<alpha>Eq \<open>x \<sharp> \<alpha>'\<close> \<open>bn \<alpha> \<sharp>* \<Psi>\<^sub>P\<close> \<open>bn \<alpha> \<sharp>* \<alpha>'\<close> \<open>x \<sharp> \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>x \<sharp> A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>x \<sharp> C\<close> \<open>A\<^sub>P \<sharp>* C\<close>
  have "Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (p \<bullet> \<alpha>) (p \<bullet> (\<lparr>\<nu>x\<rparr>P'))  (x#A\<^sub>P) \<Psi>\<^sub>P"
    by(fastforce intro!: rAlpha simp add: abs_fresh)
  with \<alpha>Eq P'eq \<open>distinctPerm p\<close> show ?case by simp
next
  case(cBang \<Psi> P A\<^sub>P \<Psi>\<^sub>P C \<alpha> P')
  then show ?case by(fastforce intro!: rBang)
qed

lemma inputFrameInduct[consumes 3, case_names cAlpha cInput cCase cPar1 cPar2 cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> 'a \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   rAlpha: "\<And>\<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P p C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* C;
                                            set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P); distinctPerm p;
                                             Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P M N P' (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              K (N[xvec::=Tvec]) (P[xvec::=Tvec]) ([]) (\<one>)"
  and   rCase: "\<And>\<Psi> P M N P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P;
                                              (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                              A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) M N P' ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M N P' A\<^sub>P \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P' \<parallel> Q) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>N\<rparr> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M N Q' A\<^sub>Q \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rScope: "\<And>\<Psi> P M N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P; x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> N;
                     x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M N (\<lparr>\<nu>x\<rparr>P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>;  distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) M N P' A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) M N P' ([]) (\<one>)"
shows "Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P"
  using Trans FrP \<open>distinct A\<^sub>P\<close>
proof(nominal_induct \<Psi> P Rs=="M\<lparr>N\<rparr> \<prec> P'" A\<^sub>P \<Psi>\<^sub>P avoiding: C arbitrary: P' rule: semanticsFrameInduct)
  case cAlpha
  then show ?case by (simp add: rAlpha)
next
  case cInput
  then show ?case by(auto simp add: rInput residualInject)
next
  case cBrInput
  then show ?case by(simp add: residualInject)
next
  case cOutput
  then show ?case by(simp add: residualInject)
next
  case cBrOutput
  then show ?case by(simp add: residualInject)
next
  case cCase
  then show ?case by(simp add: rCase residualInject)
next
  case cPar1
  then show ?case by(auto simp add: rPar1 residualInject)
next
  case cPar2
  then show ?case by(auto simp add: rPar2 residualInject)
next
  case cComm1
  then show ?case by(simp add: residualInject)
next
  case cComm2
  then show ?case by(simp add: residualInject)
next
  case cBrMerge
  then show ?case by(simp add: residualInject)
next
  case cBrComm1
  then show ?case by(simp add: residualInject)
next
  case cBrComm2
  then show ?case by(simp add: residualInject)
next
  case cBrClose
  then show ?case by(simp add: residualInject)
next
  case cOpen
  then show ?case by(simp add: residualInject)
next
  case cBrOpen
  then show ?case by(simp add: residualInject)
next
  case cScope
  then show ?case by(auto simp add: rScope residualInject)
next
  case cBang
  then show ?case by(simp add: rBang residualInject)
qed

lemma brinputFrameInduct[consumes 3, case_names cAlpha cBrInput cCase cPar1 cPar2 cBrMerge cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> 'a \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   rAlpha: "\<And>\<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P p C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* C;
                                            set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P); distinctPerm p;
                                             Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P M N P' (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rBrInput: "\<And>\<Psi> M K xvec N Tvec P C.
                   \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N;
                    length xvec = length Tvec; xvec \<sharp>* \<Psi>;
                    xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (M\<lparr>\<lambda>*xvec N\<rparr>.P)
                              K (N[xvec::=Tvec]) (P[xvec::=Tvec]) ([]) (\<one>)"
  and   rCase: "\<And>\<Psi> P M N P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P;
                                              (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                              A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) M N P' ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M N P' A\<^sub>P \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P' \<parallel> Q) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M N Q' A\<^sub>Q \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M N (P \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrMerge: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M N P' A\<^sub>P \<Psi>\<^sub>P;
                    extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M N Q' A\<^sub>Q \<Psi>\<^sub>Q;
                    extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M N (P' \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rScope: "\<And>\<Psi> P M N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P; x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> N;
                     x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M N (\<lparr>\<nu>x\<rparr>P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>;  distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) M N P' A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) M N P' ([]) (\<one>)"
shows "Prop C \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P"
  using Trans FrP \<open>distinct A\<^sub>P\<close>
proof(nominal_induct \<Psi> P Rs=="\<questiondown>M\<lparr>N\<rparr> \<prec> P'" A\<^sub>P \<Psi>\<^sub>P avoiding: C arbitrary: P' rule: semanticsFrameInduct)
  case cAlpha
  then show ?case by (simp add: rAlpha)
next
  case cInput
  then show ?case by(simp add: residualInject)
next
  case cBrInput
  then show ?case by(auto simp add: rBrInput residualInject)
next
  case cOutput
  then show ?case by(simp add: residualInject)
next
  case cBrOutput
  then show ?case by(simp add: residualInject)
next
  case cCase
  then show ?case by(simp add: rCase residualInject)
next
  case cPar1
  then show ?case by(auto simp add: rPar1 residualInject)
next
  case cPar2
  then show ?case by(auto simp add: rPar2 residualInject)
next
  case cComm1
  then show ?case by(simp add: residualInject)
next
  case cComm2
  then show ?case by(simp add: residualInject)
next
  case cBrMerge
  then show ?case by(auto simp add: rBrMerge residualInject)
next
  case cBrComm1
  then show ?case by(simp add: residualInject)
next
  case cBrComm2
  then show ?case by(simp add: residualInject)
next
  case cBrClose
  then show ?case by(simp add: residualInject)
next
  case cOpen
  then show ?case by(simp add: residualInject)
next
  case cBrOpen
  then show ?case by(simp add: residualInject)
next
  case cScope
  then show ?case by(auto simp add: rScope residualInject)
next
  case cBang
  then show ?case by(simp add: rBang residualInject)
qed

lemma outputFrameInduct[consumes 3, case_names cAlpha cOutput cCase cPar1 cPar2 cOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P   :: 'b
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> ('a, 'b, 'c) boundOutput \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>ROut M B"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   rAlpha: "\<And>\<Psi> P M A\<^sub>P \<Psi>\<^sub>P p B C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* B; A\<^sub>P \<sharp>* C;
                                         set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P); distinctPerm p;
                                          Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P M B (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rOutput: "\<And>\<Psi> M K N P C. \<Psi> \<turnstile> M \<leftrightarrow> K \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) K (N \<prec>' P) ([]) (\<one>)"
  and   rCase: "\<And>\<Psi> P M B \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>(ROut M B); extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P;
                                            (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                            A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* B; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) M B ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M;  A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q)) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M xvec N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q') A\<^sub>Q \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rOpen: "\<And>\<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*(xvec@yvec)\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P; x \<in> supp N; x \<sharp> \<Psi>; x \<sharp> M;
                     x \<sharp> A\<^sub>P; x \<sharp> xvec; x \<sharp> yvec; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* yvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P;
                     yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C; yvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*(xvec@x#yvec)\<rparr>N \<prec>' P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rScope: "\<And>\<Psi> P M xvec N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P;
                     x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> N; x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;
                     A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* xvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P;
                     A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (\<lparr>\<nu>x\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P M B A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>ROut M B; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) M B A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; supp \<Psi>\<^sub>P = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) M B ([]) (\<one>)"
shows "Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P"
proof -
  {
    fix B
    assume "\<Psi> \<rhd> P \<longmapsto>ROut M B"
    then have "Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P" using FrP \<open>distinct A\<^sub>P\<close>
    proof(nominal_induct \<Psi> P Rs=="ROut M B" A\<^sub>P \<Psi>\<^sub>P avoiding: C arbitrary: B rule: semanticsFrameInduct)
      case cAlpha
      then show ?case by(auto intro: rAlpha)
    next
      case cInput
      then show ?case by(simp add: residualInject)
    next
      case cBrInput
      then show ?case by(simp add: residualInject)
    next
      case cOutput
      then show ?case by(force intro: rOutput simp add: residualInject)
    next
      case cBrOutput
      then show ?case by(simp add: residualInject)
    next
      case cCase
      then show ?case by(force intro: rCase simp add: residualInject)
    next
      case cPar1
      then show ?case
        by(auto intro!: rPar1 simp add: residualInject)
    next
      case cPar2
      then show ?case
        by(auto intro!: rPar2 simp add: residualInject)
    next
      case cComm1
      then show ?case by(simp add: residualInject)
    next
      case cComm2
      then show ?case by(simp add: residualInject)
    next
      case cBrMerge
      then show ?case by(simp add: residualInject)
    next
      case cBrComm1
      then show ?case by(simp add: residualInject)
    next
      case cBrComm2
      then show ?case by(simp add: residualInject)
    next
      case cBrClose
      then show ?case by(simp add: residualInject)
    next
      case cOpen
      then show ?case by(auto intro: rOpen simp add: residualInject)
    next
      case cBrOpen
      then show ?case by(simp add: residualInject)
    next
      case cScope
      then show ?case by(force intro: rScope simp add: residualInject)
    next
      case cBang
      then show ?case by(force intro: rBang simp add: residualInject)
    qed
  }
  with Trans show ?thesis by(simp add: residualInject)
qed

lemma broutputFrameInduct[consumes 3, case_names cAlpha cBrOutput cCase cPar1 cPar2 cBrComm1 cBrComm2 cBrOpen cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P   :: 'b
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 'a \<Rightarrow> ('a, 'b, 'c) boundOutput \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>RBrOut M B"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   rAlpha: "\<And>\<Psi> P M A\<^sub>P \<Psi>\<^sub>P p B C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* B; A\<^sub>P \<sharp>* C;
                                         set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P); distinctPerm p;
                                          Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P M B (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rBrOutput: "\<And>\<Psi> M K N P C. \<Psi> \<turnstile> M \<preceq> K \<Longrightarrow> Prop C \<Psi> (M\<langle>N\<rangle>.P) K (N \<prec>' P) ([]) (\<one>)"
  and   rCase: "\<And>\<Psi> P M B \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>(RBrOut M B); extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P;
                                            (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                            A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* B; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) M B ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M;  A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q)) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q M xvec N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q') A\<^sub>Q \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrComm1:"\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    distinct xvec;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q') A\<^sub>Q \<Psi>\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" (* Not applicable: \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P (M\<lparr>N\<rparr>) P' A\<^sub>P \<Psi>\<^sub>P; *)
  and   rBrComm2:"\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P;
                    xvec \<sharp>* Q; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C;
                    A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)" (* Not applicable: \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q (K\<lparr>N\<rparr>) Q' A\<^sub>Q \<Psi>\<^sub>Q; *)
  and   rBrOpen: "\<And>\<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*(xvec@yvec)\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P; x \<in> supp N; x \<sharp> \<Psi>; x \<sharp> M;
                     x \<sharp> A\<^sub>P; x \<sharp> xvec; x \<sharp> yvec; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* yvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P;
                     yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C; yvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*(xvec@x#yvec)\<rparr>N \<prec>' P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rScope: "\<And>\<Psi> P M xvec N P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P') A\<^sub>P \<Psi>\<^sub>P;
                     x \<sharp> \<Psi>; x \<sharp> M; x \<sharp> xvec; x \<sharp> N; x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;
                     A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* xvec;
                     xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* \<Psi>\<^sub>P;
                     A\<^sub>P \<sharp>* C; x \<sharp> C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' (\<lparr>\<nu>x\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P M B A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>RBrOut M B; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) M B A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; supp \<Psi>\<^sub>P = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) M B ([]) (\<one>)"
shows "Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P"
proof -
  {
    fix B
    assume "\<Psi> \<rhd> P \<longmapsto>RBrOut M B"
    then have "Prop C \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P" using FrP \<open>distinct A\<^sub>P\<close>
    proof(nominal_induct \<Psi> P Rs=="RBrOut M B" A\<^sub>P \<Psi>\<^sub>P avoiding: C arbitrary: B rule: semanticsFrameInduct)
      case cAlpha
      then show ?case by(auto intro: rAlpha)
    next
      case cInput
      then show ?case by(simp add: residualInject)
    next
      case cBrInput
      then show ?case by(simp add: residualInject)
    next
      case cOutput
      then show ?case by(simp add: residualInject)
    next
      case cBrOutput
      then show ?case by(force intro: rBrOutput simp add: residualInject)
    next
      case cCase
      then show ?case by(force intro: rCase simp add: residualInject)
    next
      case cPar1
      then show ?case by(auto intro!: rPar1 simp add: residualInject)
    next
      case cPar2
      then show ?case by(auto intro!: rPar2 simp add: residualInject)
    next
      case cComm1
      then show ?case by(simp add: residualInject)
    next
      case cComm2
      then show ?case by(simp add: residualInject)
    next
      case cBrMerge
      then show ?case by(simp add: residualInject)
    next
      case cBrComm1
      then show ?case by(auto intro: rBrComm1 simp add: residualInject)
    next
      case cBrComm2
      then show ?case by(auto intro: rBrComm2 simp add: residualInject)
    next
      case cBrClose
      then show ?case by(simp add: residualInject)
    next
      case cOpen
      then show ?case by(simp add: residualInject)
    next
      case cBrOpen
      then show ?case by(auto intro: rBrOpen simp add: residualInject)
    next
      case cScope
      then show ?case by(force intro: rScope simp add: residualInject)
    next
      case cBang
      then show ?case by(force intro: rBang simp add: residualInject)
    qed
  }
  with Trans show ?thesis by(simp add: residualInject)
qed

lemma tauFrameInduct[consumes 3, case_names cAlpha cCase cPar1 cPar2 cComm1 cComm2 cBrClose cScope cBang]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and P'   :: "('a, 'b, 'c) psi"
    and Prop :: "'f::fs_name \<Rightarrow> 'b \<Rightarrow> ('a, 'b, 'c) psi \<Rightarrow>
                 ('a, 'b, 'c) psi \<Rightarrow> name list \<Rightarrow> 'b \<Rightarrow> bool"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'"
  and   FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   rAlpha: "\<And>\<Psi> P P' A\<^sub>P \<Psi>\<^sub>P p C. \<lbrakk>A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* (p \<bullet> A\<^sub>P); A\<^sub>P \<sharp>* C;
                                        set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P); distinctPerm p;
                                         Prop C \<Psi> P P' A\<^sub>P \<Psi>\<^sub>P\<rbrakk> \<Longrightarrow> Prop C \<Psi> P P' (p \<bullet> A\<^sub>P) (p \<bullet> \<Psi>\<^sub>P)"
  and   rCase: "\<And>\<Psi> P P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P C. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P; \<And>C. Prop C \<Psi> P P' A\<^sub>P \<Psi>\<^sub>P;
                                          (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P;  \<Psi>\<^sub>P \<simeq> \<one>; (supp \<Psi>\<^sub>P) = ({}::name set);
                                          A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (Cases Cs) P' ([]) (\<one>)"
  and   rPar1: "\<And>\<Psi> \<Psi>\<^sub>Q P P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<tau> \<prec> P';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>Q) P P' A\<^sub>P \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) (P' \<parallel> Q) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rPar2: "\<And>\<Psi> \<Psi>\<^sub>P Q Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<tau> \<prec> Q';
                   extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                   extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                   \<And>C. Prop C (\<Psi> \<otimes> \<Psi>\<^sub>P) Q Q' A\<^sub>Q \<Psi>\<^sub>Q;
                   A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;
                   A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                   A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                   Prop C \<Psi> (P \<parallel> Q) (P \<parallel> Q') (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rComm1: "\<And>\<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rComm2: "\<And>\<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q C.
                   \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* Q';
                    A\<^sub>Q \<sharp>* xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M;
                    xvec \<sharp>* Q; xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop C \<Psi> (P \<parallel> Q) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')) (A\<^sub>P@A\<^sub>Q) (\<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)"
  and   rBrClose: "\<And>\<Psi> P M xvec N P' A\<^sub>P \<Psi>\<^sub>P x C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                     x \<in> supp M;
                     extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                     A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* xvec;
                     distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;
                     xvec \<sharp>* M;
                     x \<sharp> \<Psi>; x \<sharp> xvec; x \<sharp> A\<^sub>P;
                     A\<^sub>P \<sharp>* C; xvec \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')) (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rScope: "\<And>\<Psi> P P' x A\<^sub>P \<Psi>\<^sub>P C.
                    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<And>C. Prop C \<Psi> P P' A\<^sub>P \<Psi>\<^sub>P; x \<sharp> \<Psi>;
                     x \<sharp> A\<^sub>P; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* P';
                     A\<^sub>P \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow>
                     Prop C \<Psi> (\<lparr>\<nu>x\<rparr>P) (\<lparr>\<nu>x\<rparr>P') (x#A\<^sub>P) \<Psi>\<^sub>P"
  and   rBang:    "\<And>\<Psi> P P' A\<^sub>P \<Psi>\<^sub>P C.
                     \<lbrakk>\<Psi> \<rhd> P \<parallel> !P \<longmapsto>\<tau> \<prec> P'; guarded P; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>;  distinct A\<^sub>P;
                      \<And>C. Prop C \<Psi> (P \<parallel> !P) P' A\<^sub>P (\<Psi>\<^sub>P \<otimes> \<one>); \<Psi>\<^sub>P \<simeq> \<one>; supp \<Psi>\<^sub>P = ({}::name set);
                      A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop C \<Psi> (!P) P' ([]) (\<one>)"
shows "Prop C \<Psi> P P' A\<^sub>P \<Psi>\<^sub>P"
  using Trans FrP \<open>distinct A\<^sub>P\<close>
proof(nominal_induct \<Psi> P Rs=="\<tau> \<prec> P'" A\<^sub>P \<Psi>\<^sub>P avoiding: C arbitrary: P' rule: semanticsFrameInduct)
  case cAlpha
  then show ?case by(force intro: rAlpha simp add: residualInject)
next
  case cInput
  then show ?case by(simp add: residualInject)
next
  case cBrInput
  then show ?case by(simp add: residualInject)
next
  case cOutput
  then show ?case by(simp add: residualInject)
next
  case cBrOutput
  then show ?case by(simp add: residualInject)
next
  case cCase
  then show ?case by(force intro: rCase simp add: residualInject)
next
  case cPar1
  then show ?case by(force intro: rPar1 simp add: residualInject)
next
  case cPar2
  then show ?case by(force intro: rPar2 simp add: residualInject)
next
  case cComm1
  then show ?case by(force intro: rComm1 simp add: residualInject)
next
  case cComm2
  then show ?case by(force intro: rComm2 simp add: residualInject)
next
  case cBrMerge
  then show ?case by(simp add: residualInject)
next
  case cBrComm1
  then show ?case by(simp add: residualInject)
next
  case cBrComm2
  then show ?case by(simp add: residualInject)
next
  case cBrClose
  then show ?case by(force intro: rBrClose simp add: residualInject)
next
  case cOpen
  then show ?case by(simp add: residualInject)
next
  case cBrOpen
  then show ?case by(simp add: residualInject)
next
  case cScope
  then show ?case by(force intro: rScope simp add: residualInject)
next
  case cBang
  then show ?case by(force intro: rBang simp add: residualInject)
qed

lemma inputFreshDerivative:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "x \<sharp> N"

shows "x \<sharp> P'"
proof -
  have "bn(M\<lparr>N\<rparr>) \<sharp>* subject(M\<lparr>N\<rparr>)" and "distinct(bn(M\<lparr>N\<rparr>))" by simp+
  with \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> show ?thesis using \<open>x \<sharp> P\<close> \<open>x \<sharp> N\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="M\<lparr>N\<rparr>" P' avoiding: x rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p x)
    then show ?case by simp
  next
    case(cInput \<Psi> M' K xvec N' Tvec P x)
    from \<open>K\<lparr>(N'[xvec::=Tvec])\<rparr> = M\<lparr>N\<rparr>\<close> have "M = K" and NeqN': "N = N'[xvec::=Tvec]" by(simp add: action.inject)+
    note \<open>length xvec = length Tvec\<close> \<open>distinct xvec\<close> then
    moreover have "x \<sharp> Tvec" using \<open>set xvec \<subseteq> supp N'\<close> \<open>x \<sharp> N\<close> NeqN'
      by(blast intro: substTerm.subst3)
    moreover from \<open>xvec \<sharp>* x\<close> \<open>x \<sharp> M'\<lparr>\<lambda>*xvec N'\<rparr>.P\<close>
    have "x \<sharp> P" by(simp add: inputChainFresh) (simp add: name_list_supp fresh_def)
    ultimately show ?case using \<open>xvec \<sharp>* x\<close> by auto
  next
    case cBrInput
    then show ?case by simp
  next
    case(cOutput \<Psi> M  K N P x)
    then show ?case by simp
  next
    case cBrOutput
    then show ?case by simp
  next
    case(cCase \<Psi> P P' \<phi> Cs x)
    then show ?case by(induct Cs, auto)
  next
    case(cPar1 \<Psi> \<Psi>\<^sub>Q P P' xvec Q x)
    then show ?case by simp
  next
    case(cPar2 \<Psi> \<Psi>\<^sub>P Q Q' xvec P x)
    then show ?case by simp
  next
    case(cComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q x)
    then show ?case by simp
  next
    case(cComm2 \<Psi> \<Psi>\<^sub>Q P M xwec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q x)
    then show ?case by simp
  next
    case cBrMerge
    then show ?case by simp
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case(cOpen \<Psi> P M xvec yvec N P' x y)
    then show ?case by simp
  next
    case(cBrOpen \<Psi> P M xvec yvec N P' x y)
    then show ?case by simp
  next
    case(cScope \<Psi> P P' x y)
    then show ?case by(simp add: abs_fresh)
  next
    case(cBang \<Psi> P P' x)
    then show ?case by simp
  qed
qed

lemma brinputFreshDerivative:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "x \<sharp> N"

shows "x \<sharp> P'"
proof -
  have "bn(\<questiondown>M\<lparr>N\<rparr>) \<sharp>* subject(\<questiondown>M\<lparr>N\<rparr>)" and "distinct(bn(\<questiondown>M\<lparr>N\<rparr>))" by simp+
  with \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> show ?thesis using \<open>x \<sharp> P\<close> \<open>x \<sharp> N\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="\<questiondown>M\<lparr>N\<rparr>" P' avoiding: x rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p x)
    then show ?case by simp
  next
    case(cInput \<Psi> M' K xvec N' Tvec P x)
    then show ?case by simp
  next
    case(cBrInput \<Psi> M' K xvec N' Tvec P x)
    from \<open>\<questiondown>M'\<lparr>(N'[xvec::=Tvec])\<rparr> = \<questiondown>M\<lparr>N\<rparr>\<close> have "M' = M" and NeqN': "N = N'[xvec::=Tvec]" by(simp add: action.inject)+
    note \<open>length xvec = length Tvec\<close> \<open>distinct xvec\<close> then
    moreover have "x \<sharp> Tvec" using \<open>set xvec \<subseteq> supp N'\<close> \<open>x \<sharp> N\<close> NeqN'
      by(blast intro: substTerm.subst3)
    moreover from \<open>xvec \<sharp>* x\<close> \<open>x \<sharp> K\<lparr>\<lambda>*xvec N'\<rparr>.P\<close>
    have "x \<sharp> P" by(simp add: inputChainFresh) (simp add: name_list_supp fresh_def)
    ultimately show ?case using \<open>xvec \<sharp>* x\<close> by auto
  next
    case(cOutput \<Psi> M  K N P x)
    then show ?case by simp
  next
    case cBrOutput
    then show ?case by simp
  next
    case(cCase \<Psi> P P' \<phi> Cs x)
    then show ?case by(induct Cs, auto)
  next
    case(cPar1 \<Psi> \<Psi>\<^sub>Q P P' xvec Q x)
    then show ?case by simp
  next
    case(cPar2 \<Psi> \<Psi>\<^sub>P Q Q' xvec P x)
    then show ?case by simp
  next
    case(cComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q x)
    then show ?case by simp
  next
    case(cComm2 \<Psi> \<Psi>\<^sub>Q P M xwec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q x)
    then show ?case by simp
  next
    case cBrMerge
    then show ?case by simp
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case(cOpen \<Psi> P M xvec yvec N P' x y)
    then show ?case by simp
  next
    case(cBrOpen \<Psi> P M xvec yvec N P' x y)
    then show ?case by simp
  next
    case(cScope \<Psi> P P' x y)
    then show ?case by(simp add: abs_fresh)
  next
    case(cBang \<Psi> P P' x)
    then show ?case by simp
  qed
qed

lemma inputFreshChainDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and xvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "xvec \<sharp>* P"
  and   "xvec \<sharp>* N"

shows "xvec \<sharp>* P'"
  using assms
  by(induct xvec)
    (auto intro: inputFreshDerivative)

lemma brinputFreshChainDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and xvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "xvec \<sharp>* P"
  and   "xvec \<sharp>* N"

shows "xvec \<sharp>* P'"
  using assms
  by(induct xvec)
    (auto intro: brinputFreshDerivative)

lemma outputFreshDerivativeN:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "x \<sharp> P"
  and   "x \<sharp> xvec"

shows "x \<sharp> N"
proof -
  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct(bn(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  ultimately show freshN: "x \<sharp> N" using \<open>x \<sharp> P\<close> \<open>x \<sharp> xvec\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" P' avoiding: x arbitrary: M xvec N rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p x M xvec N)
    have S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" by fact
    from \<open>(p \<bullet> \<alpha>) = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "(p \<bullet> p \<bullet> \<alpha>) = p \<bullet> (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by(simp add: fresh_star_bij)
    with \<open>distinctPerm p\<close> have "\<alpha>  = (p \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle>" by simp
    moreover from \<open>(p \<bullet> \<alpha>) = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>x \<sharp> xvec\<close> have "x \<sharp> (bn(p \<bullet> \<alpha>))" by simp
    with \<open>(bn \<alpha>) \<sharp>* x\<close> \<open>x \<sharp> xvec\<close> S have "x \<sharp> (p \<bullet> xvec)"
      by(fastforce dest: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst, where pi=p and x=xvec])
    ultimately have "x \<sharp> (p \<bullet> N)" using \<open>x \<sharp> P\<close> by(metis cAlpha)
    then have "(p \<bullet> x) \<sharp> (p \<bullet> p \<bullet> N)" by(simp add: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst])
    with \<open>distinctPerm p\<close> \<open>bn(\<alpha>) \<sharp>* x\<close> \<open>x \<sharp> (bn(p \<bullet> \<alpha>))\<close>S show ?case by simp
  next
    case cInput
    then show ?case by simp
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by(simp add: action.inject)
  next
    case cBrOutput
    then show ?case by(simp add: action.inject)
  next
    case (cCase \<Psi> P P' \<phi> Cs x M xvec N)
    then show ?case by(auto simp add: action.inject dest: memFresh)
  next
    case cPar1
    then show ?case by simp
  next
    case cPar2
    then show ?case by simp
  next
    case cComm1
    then show ?case by simp
  next
    case cComm2
    then show ?case by simp
  next
    case cBrMerge
    then show ?case by simp
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case(cOpen \<Psi> P M xvec yvec N P' x y M' zvec N')
    from \<open>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> = M'\<lparr>\<nu>*zvec\<rparr>\<langle>N'\<rangle>\<close> have "zvec = xvec@x#yvec" and "N = N'"
      by(simp add: action.inject)+
    from \<open>y \<sharp> \<lparr>\<nu>x\<rparr>P\<close> \<open>x \<sharp> y\<close>  have "y \<sharp> P" by(simp add: abs_fresh)
    moreover from \<open>y \<sharp> zvec\<close> \<open>zvec = xvec@x#yvec\<close>have "y \<sharp> (xvec@yvec)"
      by simp
    ultimately have "y \<sharp> N" by(fastforce intro!: cOpen)
    with \<open>N = N'\<close> show ?case by simp
  next
    case cBrOpen
    then show ?case by simp
  next
    case cScope
    then show ?case by(auto simp add: abs_fresh)
  next
    case cBang
    then show ?case by simp
  qed
qed

lemma broutputFreshDerivativeN:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "x \<sharp> P"
  and   "x \<sharp> xvec"

shows "x \<sharp> N"
proof -
  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct(bn(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  ultimately show freshN: "x \<sharp> N" using \<open>x \<sharp> P\<close> \<open>x \<sharp> xvec\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" P' avoiding: x arbitrary: M xvec N rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p x M xvec N)
    have S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" by fact
    from \<open>(p \<bullet> \<alpha>) = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "(p \<bullet> p \<bullet> \<alpha>) = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by(simp add: fresh_star_bij)
    with \<open>distinctPerm p\<close> have "\<alpha>  = \<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle>" by simp
    moreover from \<open>(p \<bullet> \<alpha>) = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>x \<sharp> xvec\<close> have "x \<sharp> (bn(p \<bullet> \<alpha>))" by simp
    with \<open>(bn \<alpha>) \<sharp>* x\<close> \<open>x \<sharp> xvec\<close> S have "x \<sharp> (p \<bullet> xvec)"
      by(fastforce dest: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst, where pi=p and x=xvec])
    ultimately have "x \<sharp> (p \<bullet> N)" using \<open>x \<sharp> P\<close> by(metis cAlpha)
    then have "(p \<bullet> x) \<sharp> (p \<bullet> p \<bullet> N)" by(simp add: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst])
    with \<open>distinctPerm p\<close> \<open>bn(\<alpha>) \<sharp>* x\<close> \<open>x \<sharp> (bn(p \<bullet> \<alpha>))\<close>S show ?case by simp
  next
    case cInput
    then show ?case by simp
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by(simp add: action.inject)
  next
    case cBrOutput
    then show ?case by(simp add: action.inject)
  next
    case cCase
    then show ?case by(auto simp add: action.inject dest: memFresh)
  next
    case cPar1
    then show ?case by simp
  next
    case cPar2
    then show ?case by simp
  next
    case cComm1
    then show ?case by simp
  next
    case cComm2
    then show ?case by simp
  next
    case cBrMerge
    then show ?case by simp
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case(cOpen \<Psi> P M xvec yvec N P' x y M' zvec N')
    then show ?case by simp
  next
    case(cBrOpen \<Psi> P M xvec yvec N P' x y M' zvec N')
    from \<open>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> = \<exclamdown>M'\<lparr>\<nu>*zvec\<rparr>\<langle>N'\<rangle>\<close> have "zvec = xvec@x#yvec" and "N = N'"
      by(simp add: action.inject)+
    from \<open>y \<sharp> \<lparr>\<nu>x\<rparr>P\<close> \<open>x \<sharp> y\<close>  have "y \<sharp> P" by(simp add: abs_fresh)
    moreover from \<open>y \<sharp> zvec\<close> \<open>zvec = xvec@x#yvec\<close>have "y \<sharp> (xvec@yvec)"
      by simp
    ultimately have "y \<sharp> N" by(fastforce intro!: cBrOpen)
    with \<open>N = N'\<close> show ?case by simp
  next
    case cScope
    then show ?case by(auto simp add: abs_fresh)
  next
    case cBang
    then show ?case by simp
  qed
qed

lemma outputFreshDerivativeP:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "x \<sharp> P"
  and   "x \<sharp> xvec"

shows   "x \<sharp> P'"
proof -
  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct(bn(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  ultimately show "x \<sharp> P'" using \<open>x \<sharp> P\<close> \<open>x \<sharp> xvec\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" P' avoiding: x arbitrary: M xvec N rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p x M xvec N)
    have S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" by fact
    from \<open>(p \<bullet> \<alpha>) = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "(p \<bullet> p \<bullet> \<alpha>) = p \<bullet> (M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by(simp add: fresh_star_bij)
    with \<open>distinctPerm p\<close> have "\<alpha>  = (p \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle>" by simp
    moreover from \<open>(p \<bullet> \<alpha>) = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>x \<sharp> xvec\<close> have "x \<sharp> (bn(p \<bullet> \<alpha>))" by simp
    with \<open>(bn \<alpha>) \<sharp>* x\<close> \<open>x \<sharp> xvec\<close> S have "x \<sharp> (p \<bullet> xvec)"
      by(fastforce dest: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst, where pi=p and x=xvec])
    ultimately have "x \<sharp> P'" using \<open>x \<sharp> P\<close> by(metis cAlpha)
    then have "(p \<bullet> x) \<sharp> (p \<bullet> P')" by(simp add: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst])
    with \<open>distinctPerm p\<close> \<open>bn(\<alpha>) \<sharp>* x\<close> \<open>x \<sharp> (bn(p \<bullet> \<alpha>))\<close>S show ?case by simp
  next
    case cInput
    then show ?case by simp
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by(simp add: action.inject)
  next
    case cBrOutput
    then show ?case by(simp add: action.inject)
  next
    case cCase
    then show ?case by(auto simp add: action.inject dest: memFresh)
  next
    case cPar1
    then show ?case by simp
  next
    case cPar2
    then show ?case by simp
  next
    case cComm1
    then show ?case by simp
  next
    case cComm2
    then show ?case by simp
  next
    case cBrMerge
    then show ?case by simp
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case(cOpen \<Psi> P M xvec yvec N P' x y M' zvec N')
    from \<open>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> = M'\<lparr>\<nu>*zvec\<rparr>\<langle>N'\<rangle>\<close> have "zvec = xvec@x#yvec"
      by(simp add: action.inject)
    from \<open>y \<sharp> \<lparr>\<nu>x\<rparr>P\<close> \<open>x \<sharp> y\<close>  have "y \<sharp> P" by(simp add: abs_fresh)
    moreover from \<open>y \<sharp> zvec\<close> \<open>zvec = xvec@x#yvec\<close>have "y \<sharp> (xvec@yvec)"
      by simp
    ultimately show "y \<sharp> P'"
      by(fastforce intro!: cOpen)
  next
    case cBrOpen
    then show ?case by simp
  next
    case cScope
    then show ?case by(auto simp add: abs_fresh)
  next
    case cBang
    then show ?case by simp
  qed
qed

lemma broutputFreshDerivativeP:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "x \<sharp> P"
  and   "x \<sharp> xvec"

shows   "x \<sharp> P'"
proof -
  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>xvec \<sharp>* M\<close> have "bn(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) \<sharp>* subject(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by simp
  moreover from \<open>distinct xvec\<close> have "distinct(bn(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>))" by simp
  ultimately show "x \<sharp> P'" using \<open>x \<sharp> P\<close> \<open>x \<sharp> xvec\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" P' avoiding: x arbitrary: M xvec N rule: semanticsInduct)
    case(cAlpha \<Psi> P \<alpha> P' p x M xvec N)
    have S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" by fact
    from \<open>(p \<bullet> \<alpha>) = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "(p \<bullet> p \<bullet> \<alpha>) = p \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)" by(simp add: fresh_star_bij)
    with \<open>distinctPerm p\<close> have "\<alpha>  = \<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle>" by simp
    moreover from \<open>(p \<bullet> \<alpha>) = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>x \<sharp> xvec\<close> have "x \<sharp> (bn(p \<bullet> \<alpha>))" by simp
    with \<open>(bn \<alpha>) \<sharp>* x\<close> \<open>x \<sharp> xvec\<close> S have "x \<sharp> (p \<bullet> xvec)"
      by(fastforce dest: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst, where pi=p and x=xvec])
    ultimately have "x \<sharp> P'" using \<open>x \<sharp> P\<close> by(metis cAlpha)
    then have "(p \<bullet> x) \<sharp> (p \<bullet> P')" by(simp add: pt_fresh_bij1[OF pt_name_inst, OF at_name_inst])
    with \<open>distinctPerm p\<close> \<open>bn(\<alpha>) \<sharp>* x\<close> \<open>x \<sharp> (bn(p \<bullet> \<alpha>))\<close>S show ?case by simp
  next
    case cInput
    then show ?case by simp
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by(simp add: action.inject)
  next
    case cBrOutput
    then show ?case by(simp add: action.inject)
  next
    case cCase
    then show ?case by(auto simp add: action.inject dest: memFresh)
  next
    case cPar1
    then show ?case by simp
  next
    case cPar2
    then show ?case by simp
  next
    case cComm1
    then show ?case by simp
  next
    case cComm2
    then show ?case by simp
  next
    case cBrMerge
    then show ?case by simp
  next
    case (cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q x M' zvec N')
    from \<open>x \<sharp> (P \<parallel> Q)\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+

    from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> \<open>xvec \<sharp>* M\<close> \<open>distinct xvec\<close> \<open>x \<sharp> Q\<close> \<open>xvec \<sharp>* x\<close>
    have "x \<sharp> N" by(simp add: broutputFreshDerivativeN)

    with \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>x \<sharp> P\<close> have "x \<sharp> P'" by(simp add: brinputFreshDerivative)

    then show ?case using cBrComm1 by simp
  next
    case (cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q x M' zvec N')
    from \<open>x \<sharp> (P \<parallel> Q)\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+

    from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>xvec \<sharp>* M\<close> \<open>distinct xvec\<close> \<open>x \<sharp> P\<close> \<open>xvec \<sharp>* x\<close>
    have "x \<sharp> N" by(simp add: broutputFreshDerivativeN)

    with \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close> \<open>x \<sharp> Q\<close> have "x \<sharp> Q'" by(simp add: brinputFreshDerivative)

    then show ?case using cBrComm2 by simp
  next
    case cBrClose
    then show ?case by simp
  next
    case cOpen
    then show ?case by simp
  next
    case(cBrOpen \<Psi> P M xvec yvec N P' x y M' zvec N')
    from \<open>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> = \<exclamdown>M'\<lparr>\<nu>*zvec\<rparr>\<langle>N'\<rangle>\<close> have "zvec = xvec@x#yvec"
      by(simp add: action.inject)
    from \<open>y \<sharp> \<lparr>\<nu>x\<rparr>P\<close> \<open>x \<sharp> y\<close>  have "y \<sharp> P" by(simp add: abs_fresh)
    moreover from \<open>y \<sharp> zvec\<close> \<open>zvec = xvec@x#yvec\<close>have "y \<sharp> (xvec@yvec)"
      by simp
    ultimately show "y \<sharp> P'"
      by(fastforce intro: cBrOpen)
  next
    case cScope
    then show ?case by(auto simp add: abs_fresh)
  next
    case cBang
    then show ?case by simp
  qed
qed

lemma outputFreshDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "x \<sharp> P"
  and   "x \<sharp> xvec"

shows   "x \<sharp> N"
  and   "x \<sharp> P'"
  using assms
  by(auto simp add: outputFreshDerivativeN outputFreshDerivativeP)

lemma broutputFreshDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "x \<sharp> P"
  and   "x \<sharp> xvec"

shows   "x \<sharp> N"
  and   "x \<sharp> P'"
  using assms
  by(auto simp add: broutputFreshDerivativeN broutputFreshDerivativeP)

lemma outputFreshChainDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and yvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "yvec \<sharp>* P"
  and   "yvec \<sharp>* xvec"

shows "yvec \<sharp>* N"
  and "yvec \<sharp>* P'"
  using assms
  by(induct yvec) (auto intro: outputFreshDerivative)

lemma broutputFreshChainDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and yvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "distinct xvec"
  and   "yvec \<sharp>* P"
  and   "yvec \<sharp>* xvec"

shows "yvec \<sharp>* N"
  and "yvec \<sharp>* P'"
  using assms
  by(induct yvec) (auto intro: broutputFreshDerivative)

lemma tauFreshDerivative:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'"
  and   "x \<sharp> P"

shows "x \<sharp> P'"
proof -
  have "bn(\<tau>) \<sharp>* subject(\<tau>)" and "distinct(bn(\<tau>))" by simp+
  with \<open>\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'\<close> show ?thesis using \<open>x \<sharp> P\<close>
  proof(nominal_induct \<Psi> P \<alpha>=="(\<tau>::('a action))" P' avoiding: x rule: semanticsInduct)
    case cAlpha
    then show ?case by simp
  next
    case cInput
    then show ?case by simp
  next
    case cBrInput
    then show ?case by simp
  next
    case cOutput
    then show ?case by simp
  next
    case cBrOutput
    then show ?case by simp
  next
    case cCase
    then show ?case by(auto dest: memFresh)
  next
    case cPar1
    then show ?case by simp
  next
    case cPar2
    then show ?case by simp
  next
    case cComm1
    then show ?case
      by(auto dest: inputFreshDerivative outputFreshDerivative simp add: resChainFresh)
  next
    case cComm2
    then show ?case
      by(auto dest: inputFreshDerivative outputFreshDerivative simp add: resChainFresh)
  next
    case cBrMerge
    then show ?case by simp
  next
    case cBrComm1
    then show ?case by simp
  next
    case cBrComm2
    then show ?case by simp
  next
    case cBrClose
    then show ?case
      by(auto dest: brinputFreshDerivative broutputFreshDerivative simp add: resChainFresh abs_fresh)
  next
    case cOpen
    then show ?case by simp
  next
    case cBrOpen
    then show ?case by simp
  next
    case cScope
    then show ?case by(simp add: abs_fresh)
  next
    case cBang
    then show ?case by simp
  qed
qed

lemma tauFreshChainDerivative:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and xvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<tau> \<prec> P'"
  and   "xvec \<sharp>* P"

shows "xvec \<sharp>* P'"
  using assms
  by(induct xvec) (auto intro: tauFreshDerivative)

lemma freeFreshDerivative:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and \<alpha>  :: "'a action"
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   "distinct(bn \<alpha>)"
  and   "x \<sharp> \<alpha>"
  and   "x \<sharp> P"

shows   "x \<sharp> P'"
  using assms
  apply -
  by(rule actionCases[where \<alpha>=\<alpha>])
    (auto intro: inputFreshDerivative brinputFreshDerivative
      tauFreshDerivative
      outputFreshDerivative broutputFreshDerivative)

lemma freeFreshChainDerivative:
  fixes \<Psi>     :: 'b
    and P     :: "('a, 'b, 'c) psi"
    and \<alpha>     :: "'a action"
    and P'    :: "('a, 'b, 'c) psi"
    and xvec  :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   "distinct(bn \<alpha>)"
  and   "xvec \<sharp>* P"
  and   "xvec \<sharp>* \<alpha>"

shows   "xvec \<sharp>* P'"
  using assms
  by(auto intro: freeFreshDerivative simp add: fresh_star_def)

lemma Input:
  fixes \<Psi>    :: 'b
    and M    :: 'a
    and K    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and Tvec :: "'a list"

assumes "\<Psi> \<turnstile> M \<leftrightarrow> K"
  and   "distinct xvec"
  and   "set xvec \<subseteq> supp N"
  and   "length xvec = length Tvec"

shows "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>K\<lparr>N[xvec::=Tvec]\<rparr> \<prec> P[xvec::=Tvec]"
proof -
  obtain p where xvecFreshPsi: "((p::name prm) \<bullet> (xvec::name list)) \<sharp>* \<Psi>"
    and xvecFreshM: "(p \<bullet> xvec) \<sharp>* M"
    and xvecFreshN: "(p \<bullet> xvec) \<sharp>* N"
    and xvecFreshK: "(p \<bullet> xvec) \<sharp>* K"
    and xvecFreshTvec: "(p \<bullet> xvec) \<sharp>* Tvec"
    and xvecFreshP: "(p \<bullet> xvec) \<sharp>* P"
    and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))"
    and dp: "distinctPerm p"
    apply -
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, M, K, N, P, Tvec)"])
      (auto simp add: eqvts fresh_star_prod)
  note \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(p \<bullet> xvec)"
    by simp
  moreover from \<open>(set xvec) \<subseteq> (supp N)\<close> have "(p \<bullet> (set xvec)) \<subseteq> (p \<bullet> (supp N))"
    by simp
  then have "set(p \<bullet> xvec) \<subseteq> supp(p \<bullet> N)"
    by(simp add: eqvts)
  moreover from \<open>length xvec = length Tvec\<close> have "length(p \<bullet> xvec) = length Tvec"
    by simp
  ultimately have "\<Psi> \<rhd> M\<lparr>\<lambda>*(p \<bullet> xvec) (p \<bullet> N)\<rparr>.(p \<bullet> P) \<longmapsto>K\<lparr>(p \<bullet> N)[(p \<bullet> xvec)::=Tvec]\<rparr> \<prec> (p \<bullet> P)[(p \<bullet> xvec)::=Tvec]"
    using xvecFreshPsi xvecFreshM xvecFreshK xvecFreshTvec
    by(metis cInput)
  then show ?thesis using xvecFreshN xvecFreshP S \<open>length xvec = length Tvec\<close> dp
    by(auto simp add: inputChainAlpha' substTerm.renaming renaming)
qed

lemma BrInput:
  fixes \<Psi>    :: 'b
    and M    :: 'a
    and K    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and Tvec :: "'a list"

assumes "\<Psi> \<turnstile> K \<succeq> M"
  and   "distinct xvec"
  and   "set xvec \<subseteq> supp N"
  and   "length xvec = length Tvec"

shows "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<questiondown>K\<lparr>N[xvec::=Tvec]\<rparr> \<prec> P[xvec::=Tvec]"
proof -
  obtain p where xvecFreshPsi: "((p::name prm) \<bullet> (xvec::name list)) \<sharp>* \<Psi>"
    and xvecFreshM: "(p \<bullet> xvec) \<sharp>* M"
    and xvecFreshN: "(p \<bullet> xvec) \<sharp>* N"
    and xvecFreshK: "(p \<bullet> xvec) \<sharp>* K"
    and xvecFreshTvec: "(p \<bullet> xvec) \<sharp>* Tvec"
    and xvecFreshP: "(p \<bullet> xvec) \<sharp>* P"
    and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))"
    and dp: "distinctPerm p"
    apply -
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, M, K, N, P, Tvec)"])
      (auto simp add: eqvts fresh_star_prod)
  note \<open>\<Psi> \<turnstile> K \<succeq> M\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(p \<bullet> xvec)"
    by simp
  moreover from \<open>(set xvec) \<subseteq> (supp N)\<close> have "(p \<bullet> (set xvec)) \<subseteq> (p \<bullet> (supp N))"
    by simp
  then have "set(p \<bullet> xvec) \<subseteq> supp(p \<bullet> N)"
    by(simp add: eqvts)
  moreover from \<open>length xvec = length Tvec\<close> have "length(p \<bullet> xvec) = length Tvec"
    by simp
  ultimately have "\<Psi> \<rhd> M\<lparr>\<lambda>*(p \<bullet> xvec) (p \<bullet> N)\<rparr>.(p \<bullet> P) \<longmapsto>\<questiondown>K\<lparr>(p \<bullet> N)[(p \<bullet> xvec)::=Tvec]\<rparr> \<prec> (p \<bullet> P)[(p \<bullet> xvec)::=Tvec]"
    using xvecFreshPsi xvecFreshM xvecFreshK xvecFreshTvec
    by(metis cBrInput)
  then show ?thesis using xvecFreshN xvecFreshP S \<open>length xvec = length Tvec\<close> dp
    by(auto simp add: inputChainAlpha' substTerm.renaming renaming)
qed

lemma residualAlpha:
  fixes p :: "name prm"
    and \<alpha> :: "'a action"
    and P :: "('a, 'b, 'c) psi"

assumes "bn(p \<bullet> \<alpha>) \<sharp>* object  \<alpha>"
  and   "bn(p \<bullet> \<alpha>) \<sharp>* P"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   "bn(p \<bullet> \<alpha>) \<sharp>* subject \<alpha>"
  and   "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))"

shows "\<alpha> \<prec> P = (p \<bullet> \<alpha>) \<prec> (p \<bullet> P)"
  using assms
  apply -
  apply(rule actionCases[where \<alpha>=\<alpha>])
      apply(simp only: eqvts bn.simps)
      apply simp
     apply(simp only: eqvts bn.simps)
     apply simp
    apply simp
    apply(simp add: boundOutputChainAlpha'' residualInject)
   apply simp
   apply(simp add: boundOutputChainAlpha'' residualInject)
  by simp

lemma Par1:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>Q   :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>Q   :: "name list"
    and Q    :: "('a, 'b, 'c) psi"

assumes Trans: "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
  and   "bn \<alpha> \<sharp>* Q"
  and   "A\<^sub>Q \<sharp>* \<Psi>"
  and   "A\<^sub>Q \<sharp>* P"
  and   "A\<^sub>Q \<sharp>* \<alpha>"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> (P' \<parallel> Q)"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>Q   :: 'b
      and P    :: "('a, 'b, 'c) psi"
      and \<alpha>    :: "'a action"
      and P'   :: "('a, 'b, 'c) psi"
      and A\<^sub>Q   :: "name list"
      and Q    :: "('a, 'b, 'c) psi"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
      and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and   "bn \<alpha> \<sharp>* Q"
      and   "bn \<alpha> \<sharp>* subject \<alpha>"
      and   "A\<^sub>Q \<sharp>* \<Psi>"
      and   "A\<^sub>Q \<sharp>* P"
      and   "A\<^sub>Q \<sharp>* \<alpha>"
      and   "distinct A\<^sub>Q"

    have  "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> (P' \<parallel> Q)"
    proof -
      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> have "distinct(bn \<alpha>)" by(rule boundOutputDistinct)
      obtain q::"name prm" where "bn(q \<bullet> \<alpha>) \<sharp>* \<Psi>" and "bn(q \<bullet> \<alpha>) \<sharp>* P" and "bn(q \<bullet> \<alpha>) \<sharp>* Q" and "bn(q \<bullet> \<alpha>) \<sharp>* \<alpha>"
        and "bn(q \<bullet> \<alpha>) \<sharp>* A\<^sub>Q" and "bn(q \<bullet> \<alpha>) \<sharp>* P'" and "bn(q \<bullet> \<alpha>) \<sharp>* \<Psi>\<^sub>Q"
        and Sq: "(set q) \<subseteq> (set (bn \<alpha>)) \<times> (set(bn(q \<bullet> \<alpha>)))"
        apply -
        by(rule name_list_avoiding[where xvec="bn \<alpha>" and c="(\<Psi>, P, Q, \<alpha>, A\<^sub>Q, \<Psi>\<^sub>Q, P')"]) (auto simp add: eqvts)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>Q) \<sharp>* P" and "(p \<bullet> A\<^sub>Q) \<sharp>* Q" and "(p \<bullet> A\<^sub>Q) \<sharp>* \<alpha>"
        and "(p \<bullet> A\<^sub>Q) \<sharp>* \<alpha>" and "(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)" and "(p \<bullet> A\<^sub>Q) \<sharp>* P'"
        and "(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> P')" and "(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q" and Sp: "(set p) \<subseteq> (set A\<^sub>Q) \<times> (set(p \<bullet> A\<^sub>Q))"
        apply -
        by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, \<alpha>, bn \<alpha>, q \<bullet> \<alpha>, P', (q \<bullet> P'), \<Psi>\<^sub>Q)"]) auto
      from \<open>distinct(bn \<alpha>)\<close> have "distinct(bn(q \<bullet> \<alpha>))"
        by - (rule actionCases[where \<alpha>=\<alpha>], auto simp add: eqvts)
      from \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* A\<^sub>Q\<close> Sq have "A\<^sub>Q \<sharp>* (q \<bullet> \<alpha>)"
        apply -
        apply(rule actionCases[where \<alpha>=\<alpha>])
            apply(simp only: bn.simps eqvts, simp)
           apply(simp only: bn.simps eqvts, simp)
          apply(simp add: freshChainSimps)
         apply(simp add: freshChainSimps)
        by simp
      from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "(q \<bullet> (bn \<alpha>)) \<sharp>* (q \<bullet> (subject \<alpha>))"
        by(simp add: fresh_star_bij)
      then have "bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)" by(simp add: eqvts)
      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* P'\<close> \<open>bn \<alpha> \<sharp>* (subject \<alpha>)\<close> Sq
      have Trans: "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> P')"
        by(force simp add: residualAlpha)
      then have "A\<^sub>Q \<sharp>* (q \<bullet> P')" using  \<open>bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* (q \<bullet> \<alpha>)\<close>
        by(auto intro: freeFreshChainDerivative)
      from Trans have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> (p \<bullet> P) \<longmapsto>p \<bullet> ((q \<bullet> \<alpha>) \<prec> (q \<bullet> P'))"
        by(rule semantics.eqvt)
      with \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* (q \<bullet> \<alpha>)\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)\<close> \<open>A\<^sub>Q \<sharp>* (q \<bullet> P')\<close>
        \<open>(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> P')\<close> Sp
      have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> P')" by(simp add: eqvts)
      moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close> Sp have  "extractFrame Q = \<langle>(p \<bullet> A\<^sub>Q), (p \<bullet> \<Psi>\<^sub>Q)\<rangle>"
        by(simp add: frameChainAlpha' eqvts)
      moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<^sub>Q\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)\<close> Sp
      have "(bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshAlphaPerm)
      moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(p \<bullet> A\<^sub>Q)" by simp
      ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>(q \<bullet> \<alpha>) \<prec> ((q \<bullet> P') \<parallel> Q)"
        using \<open>(p \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)\<close>
          \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> P')\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P\<close>
          \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* (subject (q \<bullet> \<alpha>))\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close>
        by(metis cPar1)

      then show ?thesis using \<open>bn(q \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* P'\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* Q\<close> Sq
        by(force simp add: residualAlpha)
    qed
  }
  note Goal = this
  from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close>
  obtain A\<^sub>Q' where FrQ: "extractFrame Q = \<langle>A\<^sub>Q', \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q'" and "A\<^sub>Q' \<sharp>* \<Psi>" and "A\<^sub>Q' \<sharp>* P" and "A\<^sub>Q' \<sharp>* \<alpha>"
    apply -
    by(rule distinctFrame[where C="(\<Psi>, P, \<alpha>)"]) auto
  show ?thesis
  proof(induct rule: actionCases[where \<alpha>=\<alpha>])
    case(cInput M N)
    from Trans FrQ \<open>A\<^sub>Q' \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q' \<sharp>* P\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> \<open>distinct A\<^sub>Q'\<close> \<open>bn \<alpha> \<sharp>* Q\<close>
    show ?case using \<open>\<alpha> = M\<lparr>N\<rparr>\<close> by(force intro: Goal)
  next
    case(cBrInput M N)
    from Trans FrQ \<open>A\<^sub>Q' \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q' \<sharp>* P\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> \<open>distinct A\<^sub>Q'\<close> \<open>bn \<alpha> \<sharp>* Q\<close>
    show ?case using \<open>\<alpha> = \<questiondown>M\<lparr>N\<rparr>\<close> by(force intro: Goal)
  next
    case cTau
    from Trans FrQ \<open>A\<^sub>Q' \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q' \<sharp>* P\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> \<open>distinct A\<^sub>Q'\<close> \<open>bn \<alpha> \<sharp>* Q\<close>
    show ?case using \<open>\<alpha> = \<tau>\<close> by(force intro: Goal)
  next
    case(cOutput M xvec N)
    from \<open>\<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> \<open>bn \<alpha> \<sharp>* Q\<close> have "xvec \<sharp>* A\<^sub>Q'" and "xvec \<sharp>* Q"
      by simp+
    obtain p where "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* P'" and "(p \<bullet> xvec) \<sharp>* Q"
      and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* A\<^sub>Q'"
      and S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)"
      apply -
      by(rule name_list_avoiding[where xvec=xvec and c="(N, P', Q, M, A\<^sub>Q')"]) auto
    from Trans \<open>\<alpha>=M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> S
    have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    moreover from \<open>xvec \<sharp>* A\<^sub>Q'\<close> \<open>(p \<bullet> xvec) \<sharp>* A\<^sub>Q'\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> S
    have "A\<^sub>Q' \<sharp>* (p \<bullet> \<alpha>)" by(simp add: freshChainSimps del: actionFreshChain)
    ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P') \<parallel> Q"
      using FrQ \<open>A\<^sub>Q' \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q' \<sharp>* P\<close> \<open>distinct A\<^sub>Q'\<close> \<open>(p \<bullet> xvec) \<sharp>* Q\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close>
        \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>\<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
      by(force intro: Goal)
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> \<open>(p \<bullet> xvec) \<sharp>* Q\<close> \<open>xvec \<sharp>* Q\<close> S \<open>\<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
    show ?case
      by(simp add: boundOutputChainAlpha'' eqvts create_residual.simps)
  next
    case(cBrOutput M xvec N)
    from \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> \<open>bn \<alpha> \<sharp>* Q\<close> have "xvec \<sharp>* A\<^sub>Q'" and "xvec \<sharp>* Q"
      by simp+
    obtain p where "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* P'" and "(p \<bullet> xvec) \<sharp>* Q"
      and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* A\<^sub>Q'"
      and S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)"
      by(rule name_list_avoiding[where xvec=xvec and c="(N, P', Q, M, A\<^sub>Q')"]) auto
    from Trans \<open>\<alpha>=\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> S
    have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    moreover from \<open>xvec \<sharp>* A\<^sub>Q'\<close> \<open>(p \<bullet> xvec) \<sharp>* A\<^sub>Q'\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close> S
    have "A\<^sub>Q' \<sharp>* (p \<bullet> \<alpha>)" by(simp add: freshChainSimps del: actionFreshChain)
    ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P') \<parallel> Q"
      using FrQ \<open>A\<^sub>Q' \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q' \<sharp>* P\<close> \<open>distinct A\<^sub>Q'\<close> \<open>(p \<bullet> xvec) \<sharp>* Q\<close> \<open>A\<^sub>Q' \<sharp>* \<alpha>\<close>
        \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
      by(force intro: Goal)
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> \<open>(p \<bullet> xvec) \<sharp>* Q\<close> \<open>xvec \<sharp>* Q\<close> S \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
    show ?case
      by(simp add: boundOutputChainAlpha'' eqvts create_residual.simps)
  qed
qed

lemma Par2:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>P   :: 'b
    and Q    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and Q'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and P    :: "('a, 'b, 'c) psi"

assumes Trans: "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "bn \<alpha> \<sharp>* P"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* Q"
  and   "A\<^sub>P \<sharp>* \<alpha>"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> (P \<parallel> Q')"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>P   :: 'b
      and Q    :: "('a, 'b, 'c) psi"
      and \<alpha>    :: "'a action"
      and Q'   :: "('a, 'b, 'c) psi"
      and A\<^sub>P   :: "name list"
      and P    :: "('a, 'b, 'c) psi"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'"
      and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and   "bn \<alpha> \<sharp>* P"
      and   "bn \<alpha> \<sharp>* subject \<alpha>"
      and   "A\<^sub>P \<sharp>* \<Psi>"
      and   "A\<^sub>P \<sharp>* Q"
      and   "A\<^sub>P \<sharp>* \<alpha>"
      and   "distinct A\<^sub>P"

    have  "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> (P \<parallel> Q')"
    proof -
      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> have "distinct(bn \<alpha>)" by(rule boundOutputDistinct)
      obtain q::"name prm" where "bn(q \<bullet> \<alpha>) \<sharp>* \<Psi>" and "bn(q \<bullet> \<alpha>) \<sharp>* P" and "bn(q \<bullet> \<alpha>) \<sharp>* Q" and "bn(q \<bullet> \<alpha>) \<sharp>* \<alpha>"
        and "bn(q \<bullet> \<alpha>) \<sharp>* A\<^sub>P" and "bn(q \<bullet> \<alpha>) \<sharp>* Q'" and "bn(q \<bullet> \<alpha>) \<sharp>* \<Psi>\<^sub>P"
        and Sq: "(set q) \<subseteq> (set (bn \<alpha>)) \<times> (set(bn(q \<bullet> \<alpha>)))"
        by(rule name_list_avoiding[where xvec="bn \<alpha>" and c="(\<Psi>, P, Q, \<alpha>, A\<^sub>P, \<Psi>\<^sub>P, Q')"]) (auto simp add: eqvts)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>"
        and "(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>" and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> Q')" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P"
        and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
        by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, \<alpha>, q \<bullet> \<alpha>, Q', (q \<bullet> Q'), \<Psi>\<^sub>P)"]) auto
      from \<open>distinct(bn \<alpha>)\<close> have "distinct(bn(q \<bullet> \<alpha>))"
        apply -
        by(rule actionCases[where \<alpha>=\<alpha>]) (auto simp add: eqvts)
      from \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* A\<^sub>P\<close> Sq have "A\<^sub>P \<sharp>* (q \<bullet> \<alpha>)"
        apply -
        apply(rule actionCases[where \<alpha>=\<alpha>])
            apply(simp only: bn.simps eqvts, simp)
           apply(simp only: bn.simps eqvts, simp)
          apply(simp add: freshChainSimps)
         apply(simp add: freshChainSimps)
        by simp
      from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "(q \<bullet> (bn \<alpha>)) \<sharp>* (q \<bullet> (subject \<alpha>))"
        by(simp add: fresh_star_bij)
      then have "bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)" by(simp add: eqvts)
      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* Q'\<close> \<open>bn \<alpha> \<sharp>* (subject \<alpha>)\<close> Sq
      have Trans: "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> Q')"
        by(force simp add: residualAlpha)
      then have "A\<^sub>P \<sharp>* (q \<bullet> Q')" using  \<open>bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* (q \<bullet> \<alpha>)\<close>
        by(auto intro: freeFreshChainDerivative)
      from Trans have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> (p \<bullet> Q) \<longmapsto>p \<bullet> ((q \<bullet> \<alpha>) \<prec> (q \<bullet> Q'))"
        by(rule semantics.eqvt)
      with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* (q \<bullet> \<alpha>)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)\<close> \<open>A\<^sub>P \<sharp>* (q \<bullet> Q')\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> Q')\<close> Sp
      have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> Q')" by(simp add: eqvts)
      moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close> Sp have  "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
        by(simp add: frameChainAlpha' eqvts)
      moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)\<close> Sp
      have "(bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshAlphaPerm)
      moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)" by simp
      ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>(q \<bullet> \<alpha>) \<prec> (P \<parallel> (q \<bullet> Q'))"
        using \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)\<close>
          \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> Q')\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P\<close>
          \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* (subject (q \<bullet> \<alpha>))\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close>
        by(metis cPar2)

      then show ?thesis using \<open>bn(q \<bullet> \<alpha>) \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* Q'\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* P\<close> Sq
        by(force simp add: residualAlpha)
    qed
  }
  note Goal = this
  from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close>
  obtain A\<^sub>P' where FrP: "extractFrame P = \<langle>A\<^sub>P', \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P'" and "A\<^sub>P' \<sharp>* \<Psi>" and "A\<^sub>P' \<sharp>* Q" and "A\<^sub>P' \<sharp>* \<alpha>"
    apply -
    by(rule distinctFrame[where C="(\<Psi>, Q, \<alpha>)"]) auto
  show ?thesis
  proof(induct rule: actionCases[where \<alpha>=\<alpha>])
    case(cInput M N)
    from Trans FrP \<open>A\<^sub>P' \<sharp>* \<Psi>\<close> \<open>A\<^sub>P' \<sharp>* Q\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> \<open>distinct A\<^sub>P'\<close> \<open>bn \<alpha> \<sharp>* P\<close>
    show ?case using \<open>\<alpha> = M\<lparr>N\<rparr>\<close> by(force intro: Goal)
  next
    case(cBrInput M N)
    from Trans FrP \<open>A\<^sub>P' \<sharp>* \<Psi>\<close> \<open>A\<^sub>P' \<sharp>* Q\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> \<open>distinct A\<^sub>P'\<close> \<open>bn \<alpha> \<sharp>* P\<close>
    show ?case using \<open>\<alpha> = \<questiondown>M\<lparr>N\<rparr>\<close> by(force intro: Goal)
  next
    case cTau
    from Trans FrP \<open>A\<^sub>P' \<sharp>* \<Psi>\<close> \<open>A\<^sub>P' \<sharp>* Q\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> \<open>distinct A\<^sub>P'\<close> \<open>bn \<alpha> \<sharp>* P\<close>
    show ?case using \<open>\<alpha> = \<tau>\<close> by(force intro: Goal)
  next
    case(cOutput M xvec N)
    from \<open>\<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> \<open>bn \<alpha> \<sharp>* P\<close> have "xvec \<sharp>* A\<^sub>P'" and "xvec \<sharp>* P"
      by simp+
    obtain p where "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* Q'" and "(p \<bullet> xvec) \<sharp>* P"
      and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* A\<^sub>P'"
      and S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)"
      by(rule name_list_avoiding[where xvec=xvec and c="(N, Q', P, M, A\<^sub>P')"]) auto
    from Trans \<open>\<alpha>=M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'" by simp
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* Q'\<close> S
    have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> Q')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    moreover from \<open>xvec \<sharp>* A\<^sub>P'\<close> \<open>(p \<bullet> xvec) \<sharp>* A\<^sub>P'\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> S
    have "A\<^sub>P' \<sharp>* (p \<bullet> \<alpha>)" by(simp add: freshChainSimps del: actionFreshChain)
    ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> P \<parallel> (p \<bullet> Q')"
      using FrP \<open>A\<^sub>P' \<sharp>* \<Psi>\<close> \<open>A\<^sub>P' \<sharp>* Q\<close> \<open>distinct A\<^sub>P'\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close>
        \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>\<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
      by(force intro: Goal)
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* Q'\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>xvec \<sharp>* P\<close> S \<open>\<alpha> = M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
    show ?case
      by(simp add: boundOutputChainAlpha'' eqvts create_residual.simps)
  next
    case(cBrOutput M xvec N)
    from \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> \<open>bn \<alpha> \<sharp>* P\<close> have "xvec \<sharp>* A\<^sub>P'" and "xvec \<sharp>* P"
      by simp+
    obtain p where "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* Q'" and "(p \<bullet> xvec) \<sharp>* P"
      and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* A\<^sub>P'"
      and S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)"
      by(rule name_list_avoiding[where xvec=xvec and c="(N, Q', P, M, A\<^sub>P')"]) auto
    from Trans \<open>\<alpha>=\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'" by simp
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* Q'\<close> S
    have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> Q')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    moreover from \<open>xvec \<sharp>* A\<^sub>P'\<close> \<open>(p \<bullet> xvec) \<sharp>* A\<^sub>P'\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> S
    have "A\<^sub>P' \<sharp>* (p \<bullet> \<alpha>)" by(simp add: freshChainSimps del: actionFreshChain)
    ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> P \<parallel> (p \<bullet> Q')"
      using FrP \<open>A\<^sub>P' \<sharp>* \<Psi>\<close> \<open>A\<^sub>P' \<sharp>* Q\<close> \<open>distinct A\<^sub>P'\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>A\<^sub>P' \<sharp>* \<alpha>\<close>
        \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
      by(force intro: Goal)
    with \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* Q'\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>xvec \<sharp>* P\<close> S \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close>
    show ?case
      by(simp add: boundOutputChainAlpha'' eqvts create_residual.simps)
  qed
qed

lemma Open:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and yvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "x \<in> supp N"
  and   "x \<sharp> \<Psi>"
  and   "x \<sharp> M"
  and   "x \<sharp> xvec"
  and   "x \<sharp> yvec"

shows "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from Trans have "distinct(xvec@yvec)" by(force dest: boundOutputDistinct)
  then have "xvec \<sharp>* yvec" by(induct xvec) auto

  obtain p where "(p \<bullet> yvec) \<sharp>* \<Psi>" and "(p \<bullet> yvec) \<sharp>* P"  and "(p \<bullet> yvec) \<sharp>* M"
    and "(p \<bullet> yvec) \<sharp>* yvec" and "(p \<bullet> yvec) \<sharp>* N" and "(p \<bullet> yvec) \<sharp>* P'"
    and "x \<sharp> (p \<bullet> yvec)" and "(p \<bullet> yvec) \<sharp>* xvec"
    and Sp: "(set p) \<subseteq> (set yvec) \<times> (set(p \<bullet> yvec))"
    by(rule name_list_avoiding[where xvec=yvec and c="(\<Psi>, P, M, xvec, yvec, N, P', x)"])
      (auto simp add: eqvts fresh_star_prod)
  obtain q where "(q \<bullet> xvec) \<sharp>* \<Psi>" and "(q \<bullet> xvec) \<sharp>* P"  and "(q \<bullet> xvec) \<sharp>* M"
    and "(q \<bullet> xvec) \<sharp>* xvec" and "(q \<bullet> xvec) \<sharp>* N" and "(q \<bullet> xvec) \<sharp>* P'"
    and "x \<sharp> (q \<bullet> xvec)" and "(q \<bullet> xvec) \<sharp>* yvec"
    and "(q \<bullet> xvec) \<sharp>* p" and "(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)"
    and Sq: "(set q) \<subseteq> (set xvec) \<times> (set(q \<bullet> xvec))"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, xvec, yvec, p \<bullet> yvec, N, P', x, p)"])
      (auto simp add: eqvts fresh_star_prod)

  note \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>(p \<bullet> yvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
  have "((p@q) \<bullet> (xvec @ yvec)) \<sharp>* N"
    apply(simp only: eqvts)
    apply(simp only: pt2[OF pt_name_inst])
    by simp
  moreover from \<open>(p \<bullet> yvec) \<sharp>* P'\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
  have "((p@q) \<bullet> (xvec @ yvec)) \<sharp>* P'" by(simp del: freshAlphaPerm add: eqvts pt2[OF pt_name_inst])
  moreover from Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
  have Spq: "set(p@q) \<subseteq> set(xvec@yvec) \<times> set((p@q) \<bullet> (xvec@yvec))"
    by(simp add: pt2[OF pt_name_inst] eqvts) blast
  ultimately have "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*((p@q) \<bullet> (xvec@yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    apply(simp add: create_residual.simps)
    by(erule rev_mp) (subst boundOutputChainAlpha, auto)

  with  Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
  have "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    by(simp add: eqvts pt2[OF pt_name_inst] del: freshAlphaPerm)
  moreover from \<open>x \<in> supp N\<close> have "((p@q) \<bullet> x) \<in> (p@q) \<bullet> (supp N)"
    by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> Sp Sq
  have "x \<in> supp((p@q)\<bullet> N)" by(simp add: eqvts pt2[OF pt_name_inst])
  moreover from \<open>distinct(xvec@yvec)\<close> have "distinct(q \<bullet> xvec)" and "distinct(p \<bullet> yvec)"
    by auto
  moreover note \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> \<Psi>\<close>
    \<open>(q \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> xvec) \<sharp>* P\<close> \<open>(q \<bullet> xvec) \<sharp>* M\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close>
    \<open>(p \<bullet> yvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> yvec) \<sharp>* P\<close> \<open>(p \<bullet> yvec) \<sharp>* M\<close> \<open>distinct(q \<bullet> xvec)\<close>
  ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*((q \<bullet> xvec)@x#(p \<bullet> yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    by(metis cOpen)
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close>
    \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
  have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*((p@q) \<bullet> (xvec@x#yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    by(simp add: eqvts pt2[OF pt_name_inst] del: freshAlphaPerm)
  then show ?thesis using \<open>((p@q) \<bullet> (xvec @ yvec)) \<sharp>* N\<close> \<open>((p@q) \<bullet> (xvec @ yvec)) \<sharp>* P'\<close> Spq
    apply(simp add: create_residual.simps)
    by(erule rev_mp) (subst boundOutputChainAlpha, auto)
qed

lemma BrOpen:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and yvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "x \<in> supp N"
  and   "x \<sharp> \<Psi>"
  and   "x \<sharp> M"
  and   "x \<sharp> xvec"
  and   "x \<sharp> yvec"

shows "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from Trans have "distinct(xvec@yvec)" by(force dest: boundOutputDistinct)
  then have "xvec \<sharp>* yvec" by(induct xvec) auto

  obtain p where "(p \<bullet> yvec) \<sharp>* \<Psi>" and "(p \<bullet> yvec) \<sharp>* P"  and "(p \<bullet> yvec) \<sharp>* M"
    and "(p \<bullet> yvec) \<sharp>* yvec" and "(p \<bullet> yvec) \<sharp>* N" and "(p \<bullet> yvec) \<sharp>* P'"
    and "x \<sharp> (p \<bullet> yvec)" and "(p \<bullet> yvec) \<sharp>* xvec"
    and Sp: "(set p) \<subseteq> (set yvec) \<times> (set(p \<bullet> yvec))"
    by(rule name_list_avoiding[where xvec=yvec and c="(\<Psi>, P, M, xvec, yvec, N, P', x)"])
      (auto simp add: eqvts fresh_star_prod)
  obtain q where "(q \<bullet> xvec) \<sharp>* \<Psi>" and "(q \<bullet> xvec) \<sharp>* P"  and "(q \<bullet> xvec) \<sharp>* M"
    and "(q \<bullet> xvec) \<sharp>* xvec" and "(q \<bullet> xvec) \<sharp>* N" and "(q \<bullet> xvec) \<sharp>* P'"
    and "x \<sharp> (q \<bullet> xvec)" and "(q \<bullet> xvec) \<sharp>* yvec"
    and "(q \<bullet> xvec) \<sharp>* p" and "(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)"
    and Sq: "(set q) \<subseteq> (set xvec) \<times> (set(q \<bullet> xvec))"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, xvec, yvec, p \<bullet> yvec, N, P', x, p)"])
      (auto simp add: eqvts fresh_star_prod)

  note \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  moreover from \<open>(p \<bullet> yvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
  have "((p@q) \<bullet> (xvec @ yvec)) \<sharp>* N"
    apply(simp only: eqvts)
    apply(simp only: pt2[OF pt_name_inst])
    by simp
  moreover from \<open>(p \<bullet> yvec) \<sharp>* P'\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
  have "((p@q) \<bullet> (xvec @ yvec)) \<sharp>* P'" by(simp del: freshAlphaPerm add: eqvts pt2[OF pt_name_inst])
  moreover from Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
  have Spq: "set(p@q) \<subseteq> set(xvec@yvec) \<times> set((p@q) \<bullet> (xvec@yvec))"
    by(simp add: pt2[OF pt_name_inst] eqvts) blast
  ultimately have "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((p@q) \<bullet> (xvec@yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    apply(simp add: create_residual.simps)
    by(erule rev_mp) (subst boundOutputChainAlpha, auto)

  with  Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
  have "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    by(simp add: eqvts pt2[OF pt_name_inst] del: freshAlphaPerm)
  moreover from \<open>x \<in> supp N\<close> have "((p@q) \<bullet> x) \<in> (p@q) \<bullet> (supp N)"
    by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> Sp Sq
  have "x \<in> supp((p@q)\<bullet> N)" by(simp add: eqvts pt2[OF pt_name_inst])
  moreover from \<open>distinct(xvec@yvec)\<close> have "distinct(q \<bullet> xvec)" and "distinct(p \<bullet> yvec)"
    by auto
  moreover note \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> \<Psi>\<close>
    \<open>(q \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> xvec) \<sharp>* P\<close> \<open>(q \<bullet> xvec) \<sharp>* M\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close>
    \<open>(p \<bullet> yvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> yvec) \<sharp>* P\<close> \<open>(p \<bullet> yvec) \<sharp>* M\<close> \<open>distinct(q \<bullet> xvec)\<close>
  ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((q \<bullet> xvec)@x#(p \<bullet> yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    by(metis cBrOpen)
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close>
    \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
  have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((p@q) \<bullet> (xvec@x#yvec))\<rparr>\<langle>((p@q) \<bullet> N)\<rangle> \<prec> ((p@q) \<bullet> P')"
    by(simp add: eqvts pt2[OF pt_name_inst] del: freshAlphaPerm)
  then show ?thesis using \<open>((p@q) \<bullet> (xvec @ yvec)) \<sharp>* N\<close> \<open>((p@q) \<bullet> (xvec @ yvec)) \<sharp>* P'\<close> Spq
    apply(simp add: create_residual.simps)
    by(erule rev_mp) (subst boundOutputChainAlpha, auto)
qed

lemma Scope:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "x \<sharp> \<Psi>"
  and   "x \<sharp> \<alpha>"

shows "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> \<lparr>\<nu>x\<rparr>P'"
proof -
  {
    fix \<Psi> P M xvec N P' x

    assume "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
      and  "(x::name) \<sharp> \<Psi>"
      and  "x \<sharp> M"
      and  "x \<sharp> xvec"
      and  "x \<sharp> N"

    obtain p::"name prm" where "(p \<bullet> xvec) \<sharp>* \<Psi>" and "(p \<bullet> xvec) \<sharp>* P" and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* xvec"
      and "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* P'" and "x \<sharp> (p \<bullet> xvec)"
      and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))"
      by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, xvec, N, P', x)"])
        (auto simp add: eqvts fresh_star_prod)
    from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> S
    have "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    moreover then have "distinct(p \<bullet> xvec)" by(force dest: boundOutputDistinct)
    moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> (p \<bullet> xvec)\<close>
    moreover from \<open>x \<sharp> xvec\<close> \<open>x \<sharp> p \<bullet> xvec\<close> \<open>x \<sharp> N\<close> S have "x \<sharp> (p \<bullet> N)"
      by(simp add: fresh_left del: freshAlphaSwap)
    ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> \<lparr>\<nu>x\<rparr>(p \<bullet> P')" using \<open>(p \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* M\<close>
      by(force intro: cScope)
    moreover from \<open>x \<sharp> xvec\<close> \<open>x \<sharp> p \<bullet> xvec\<close> S have "p \<bullet> x = x" by simp
    ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> (\<lparr>\<nu>x\<rparr>P'))" by simp
    moreover from \<open>(p \<bullet> xvec) \<sharp>* P'\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> (p \<bullet> xvec)\<close> have "(p \<bullet> xvec) \<sharp>* \<lparr>\<nu>x\<rparr>P'"
      by(simp add: abs_fresh_star)
    ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> \<lparr>\<nu>x\<rparr>P'" using \<open>(p \<bullet> xvec) \<sharp>* N\<close> S
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
  }
  then have
    (* This is simply for naming purposes, as we have two raw proof blocks. *)
    outputCase: "\<And>\<Psi> P M xvec N P' x.
    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
    (x::name) \<sharp> \<Psi>;
    x \<sharp> M;
    x \<sharp> xvec;
    x \<sharp> N\<rbrakk> \<Longrightarrow>
    \<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> \<lparr>\<nu>x\<rparr>P'" by simp

  {
    fix \<Psi> P M xvec N P' x

    assume "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
      and  "(x::name) \<sharp> \<Psi>"
      and  "x \<sharp> M"
      and  "x \<sharp> xvec"
      and  "x \<sharp> N"

    obtain p::"name prm" where "(p \<bullet> xvec) \<sharp>* \<Psi>" and "(p \<bullet> xvec) \<sharp>* P" and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* xvec"
      and "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* P'" and "x \<sharp> (p \<bullet> xvec)"
      and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))"
      by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, xvec, N, P', x)"])
        (auto simp add: eqvts fresh_star_prod)
    from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> S
    have "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    moreover then have "distinct(p \<bullet> xvec)" by(force dest: boundOutputDistinct)
    moreover note \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> (p \<bullet> xvec)\<close>
    moreover from \<open>x \<sharp> xvec\<close> \<open>x \<sharp> p \<bullet> xvec\<close> \<open>x \<sharp> N\<close> S have "x \<sharp> (p \<bullet> N)"
      by(simp add: fresh_left del: freshAlphaSwap)
    ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> \<lparr>\<nu>x\<rparr>(p \<bullet> P')" using \<open>(p \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* M\<close>
      by(force simp add: cScope)
    moreover from \<open>x \<sharp> xvec\<close> \<open>x \<sharp> p \<bullet> xvec\<close> S have "p \<bullet> x = x" by simp
    ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> (\<lparr>\<nu>x\<rparr>P'))" by simp
    moreover from \<open>(p \<bullet> xvec) \<sharp>* P'\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> (p \<bullet> xvec)\<close> have "(p \<bullet> xvec) \<sharp>* \<lparr>\<nu>x\<rparr>P'"
      by(simp add: abs_fresh_star)
    ultimately have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> \<lparr>\<nu>x\<rparr>P'" using \<open>(p \<bullet> xvec) \<sharp>* N\<close> S
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
  }
  then have
    (* This is simply for naming purposes, as we have two raw proof blocks. *)
    broutputCase: "\<And>\<Psi> P M xvec N P' x.
    \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
    (x::name) \<sharp> \<Psi>;
    x \<sharp> M;
    x \<sharp> xvec;
    x \<sharp> N\<rbrakk> \<Longrightarrow>
    \<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> \<lparr>\<nu>x\<rparr>P'" by simp

  show ?thesis
  proof(induct rule: actionCases[where \<alpha>=\<alpha>])
    case(cInput M N)
    with assms show ?case by(force intro: cScope)
  next
    case(cBrInput M N)
    with assms show ?case by(force intro: cScope)
  next
    case(cOutput M xvec N)
    with assms show ?case by(force intro: outputCase)
  next
    case(cBrOutput M xvec N)
    with assms show ?case by(force intro: broutputCase)
  next
    case cTau
    with assms show ?case by(force intro: cScope)
  qed
qed

lemma inputSwapFrameSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name
    and y  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "y \<sharp> P"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto> ([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
  using assms
proof(nominal_induct avoiding: x y rule: inputInduct)
  case(cInput \<Psi> M K xvec N Tvec P x y)
  from \<open>x \<sharp> M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> have "x \<sharp> M" by simp
  from \<open>y \<sharp> M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> have "y \<sharp> M" by simp
  from \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> M) \<leftrightarrow> ([(x, y)] \<bullet> K)"
    by(rule chanEqClosed)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close>  have "([(x, y)] \<bullet> \<Psi>) \<turnstile> M \<leftrightarrow> ([(x, y)] \<bullet> K)"
    by(simp)
  then show ?case using \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    by(rule Input)
next
  case(cCase \<Psi> P M N P' \<phi> Cs x y)
  from \<open>x \<sharp> Cases Cs\<close> \<open>y \<sharp> Cases Cs\<close> \<open>(\<phi>, P) \<in> set Cs\<close> have "x \<sharp> \<phi>" and "x \<sharp> P" and "y \<sharp> \<phi>" and "y \<sharp> P"
    by(auto dest: memFresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> have "([(x ,y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto> ([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by(rule cCase)
  moreover note \<open>(\<phi>, P) \<in> set Cs\<close>
  moreover from \<open>\<Psi> \<turnstile> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> \<phi>)" by(rule statClosed)
  with \<open>x \<sharp> \<phi>\<close> \<open>y \<sharp> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> \<phi>" by simp
  ultimately show ?case using \<open>guarded P\<close> by(rule Case)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> (extractFrame Q)) = ([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>)"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "\<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle> = extractFrame Q"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
    by(force intro!: Par1)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> Q; y \<sharp> Q\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> (extractFrame P)) = ([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>)"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "\<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle> = extractFrame P"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    by(force intro: Par2)
next
  case(cScope \<Psi> P M N P' z x y)
  from \<open>x \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> x\<close> have "x \<sharp> P" by(simp add: abs_fresh)
  from \<open>y \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> y\<close> have "y \<sharp> P" by(simp add: abs_fresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by simp
  moreover with \<open>z \<sharp> \<Psi>\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> \<Psi>"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> \<Psi>" by simp
  moreover with \<open>z \<sharp> M\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> M"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> M" by simp
  ultimately show ?case using \<open>z \<sharp> N\<close>
    by(force intro!: Scope)
next
  case(cBang \<Psi> P M N P' x y)
  then show ?case by(force intro: Bang)
qed

lemma brinputSwapFrameSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name
    and y  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "y \<sharp> P"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
  using assms
proof(nominal_induct avoiding: x y rule: brInputInduct)
  case(cBrInput \<Psi> K M xvec N Tvec P x y)
  from \<open>x \<sharp> M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> have "x \<sharp> M" by simp
  from \<open>y \<sharp> M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> have "y \<sharp> M" by simp
  from \<open>\<Psi> \<turnstile> K \<succeq> M\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> K) \<succeq> ([(x, y)] \<bullet> M)"
    by(rule chanInConClosed)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> K) \<succeq> M"
    by(simp)
  then show ?case using \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    by(rule BrInput)
next
  case(cCase \<Psi> P M N P' \<phi> Cs x y)
  from \<open>x \<sharp> Cases Cs\<close> \<open>y \<sharp> Cases Cs\<close> \<open>(\<phi>, P) \<in> set Cs\<close> have "x \<sharp> \<phi>" and "x \<sharp> P" and "y \<sharp> \<phi>" and "y \<sharp> P"
    by(auto dest: memFresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> have "([(x ,y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by(rule cCase)
  moreover note \<open>(\<phi>, P) \<in> set Cs\<close>
  moreover from \<open>\<Psi> \<turnstile> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> \<phi>)" by(rule statClosed)
  with \<open>x \<sharp> \<phi>\<close> \<open>y \<sharp> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> \<phi>" by simp
  ultimately show ?case using \<open>guarded P\<close> by(rule Case)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> (extractFrame Q)) = ([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>)"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "\<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle> = extractFrame Q"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
    by(force intro!: Par1)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> Q; y \<sharp> Q\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> (extractFrame P)) = ([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>)"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "\<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle> = extractFrame P"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    by(force intro!: Par2)
next
  case (cBrMerge \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+

  from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> (extractFrame P)) = ([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>)"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "extractFrame P = \<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: eqvts)

  from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> (extractFrame Q)) = ([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>)"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "extractFrame Q = \<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: eqvts)

  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(simp add: eqvts)
  moreover from \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> Q; y \<sharp> Q\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'"
    by(simp add: eqvts)
  moreover note \<open>extractFrame P = \<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle>\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle>\<close>

  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp

  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp

  moreover note \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
    \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close>
  ultimately show ?case
    by(force intro!: semantics.cBrMerge)
next
  case(cScope \<Psi> P M N P' z x y)
  from \<open>x \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> x\<close> have "x \<sharp> P" by(simp add: abs_fresh)
  from \<open>y \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> y\<close> have "y \<sharp> P" by(simp add: abs_fresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by simp
  moreover with \<open>z \<sharp> \<Psi>\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> \<Psi>"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> \<Psi>" by simp
  moreover with \<open>z \<sharp> M\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> M"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> M" by simp
  ultimately show ?case using \<open>z \<sharp> N\<close>
    by(force intro: Scope)
next
  case(cBang \<Psi> P M N P' x y)
  then show ?case by(force intro: Bang)
qed

lemma inputPermFrameSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and p  :: "name prm"
    and Xs :: "name set"
    and Ys :: "name set"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   S: "set p \<subseteq> Xs \<times> Ys"
  and   "Xs \<sharp>* P"
  and   "Ys \<sharp>* P"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto> (p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
  using S
proof(induct p)
  case Nil
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close>
  show ?case by simp
next
  case(Cons a p)
  from \<open>set(a#p) \<subseteq> Xs \<times> Ys\<close> have "set p \<subseteq> Xs \<times> Ys" by auto
  with \<open>set p \<subseteq> Xs \<times> Ys \<Longrightarrow> (p \<bullet> \<Psi>) \<rhd> P \<longmapsto> (p \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have Trans: "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto> (p \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by simp
  from \<open>set(a#p) \<subseteq> Xs \<times> Ys\<close> show ?case
  proof(cases a)
    case (Pair x y)
    then have "x \<in> Xs" and "y \<in> Ys"
      using \<open>set(a#p) \<subseteq> Xs \<times> Ys\<close> by auto
    with \<open>Xs \<sharp>* P\<close> \<open>Ys \<sharp>* P\<close> have "x \<sharp> P" and "y \<sharp> P"
      by(auto simp add: fresh_star_def)
    with Trans have "([(x, y)] \<bullet> p \<bullet> \<Psi>) \<rhd> P \<longmapsto> ([(x, y)] \<bullet> p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
      by(rule inputSwapFrameSubject)
    then show ?thesis
      using Pair by simp
  qed
qed

lemma brinputPermFrameSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and p  :: "name prm"
    and Xs :: "name set"
    and Ys :: "name set"

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   S: "set p \<subseteq> Xs \<times> Ys"
  and   "Xs \<sharp>* P"
  and   "Ys \<sharp>* P"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
  using S
proof(induct p)
  case Nil
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close>
  show ?case by simp
next
  case(Cons a p)
  from \<open>set(a#p) \<subseteq> Xs \<times> Ys\<close> have "set p \<subseteq> Xs \<times> Ys" by auto
  with \<open>set p \<subseteq> Xs \<times> Ys \<Longrightarrow> (p \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'\<close>
  have Trans: "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by simp
  from \<open>set(a#p) \<subseteq> Xs \<times> Ys\<close> show ?case
  proof(cases a)
    case (Pair x y)
    then have "x \<in> Xs" and "y \<in> Ys"
      using \<open>set(a#p) \<subseteq> Xs \<times> Ys\<close> by auto
    with \<open>Xs \<sharp>* P\<close> \<open>Ys \<sharp>* P\<close> have "x \<sharp> P" and "y \<sharp> P"
      by(auto simp add: fresh_star_def)
    with Trans have "([(x, y)] \<bullet> p \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>([(x, y)] \<bullet> p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
      by(rule brinputSwapFrameSubject)
    then show ?thesis
      using Pair by simp
  qed
qed

lemma inputSwapSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name
    and y  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> \<Psi>"
  and   "y \<sharp> \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto> ([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule inputSwapFrameSubject)
  with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> show ?thesis
    by simp
qed

lemma brinputSwapSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name
    and y  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> \<Psi>"
  and   "y \<sharp> \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto> \<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule brinputSwapFrameSubject)
  with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> show ?thesis
    by simp
qed

lemma inputPermSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and p  :: "name prm"
    and Xs :: "name set"
    and Ys :: "name set"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   S: "set p \<subseteq> Xs \<times> Ys"
  and   "Xs \<sharp>* P"
  and   "Ys \<sharp>* P"
  and   "Xs \<sharp>* \<Psi>"
  and   "Ys \<sharp>* \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto> (p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> S \<open>Xs \<sharp>* P\<close> \<open>Ys \<sharp>* P\<close>
  have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule inputPermFrameSubject)
  with \<open>Xs \<sharp>* \<Psi>\<close> \<open>Ys \<sharp>* \<Psi>\<close> S show ?thesis
    by simp
qed

lemma brinputPermSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and p  :: "name prm"
    and Xs :: "name set"
    and Ys :: "name set"

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   S: "set p \<subseteq> Xs \<times> Ys"
  and   "Xs \<sharp>* P"
  and   "Ys \<sharp>* P"
  and   "Xs \<sharp>* \<Psi>"
  and   "Ys \<sharp>* \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto> \<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> S \<open>Xs \<sharp>* P\<close> \<open>Ys \<sharp>* P\<close>
  have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule brinputPermFrameSubject)
  with \<open>Xs \<sharp>* \<Psi>\<close> \<open>Ys \<sharp>* \<Psi>\<close> S show ?thesis
    by simp
qed

lemma inputSwapFrame:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name
    and y  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> M"
  and   "y \<sharp> M"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto> M\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule inputSwapFrameSubject)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> show ?thesis
    by simp
qed

lemma brinputSwapFrame:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and x  :: name
    and y  :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> M"
  and   "y \<sharp> M"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule brinputSwapFrameSubject)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> show ?thesis
    by simp
qed

lemma inputPermFrame:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and p  :: "name prm"
    and Xs :: "name set"
    and Ys :: "name set"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   S: "set p \<subseteq> Xs \<times> Ys"
  and   "Xs \<sharp>* P"
  and   "Ys \<sharp>* P"
  and   "Xs \<sharp>* M"
  and   "Ys \<sharp>* M"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto> M\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> S \<open>Xs \<sharp>* P\<close> \<open>Ys \<sharp>* P\<close>
  have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule inputPermFrameSubject)
  with \<open>Xs \<sharp>* M\<close> \<open>Ys \<sharp>* M\<close> S show ?thesis
    by simp
qed

lemma brinputPermFrame:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and p  :: "name prm"
    and Xs :: "name set"
    and Ys :: "name set"

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   S: "set p \<subseteq> Xs \<times> Ys"
  and   "Xs \<sharp>* P"
  and   "Ys \<sharp>* P"
  and   "Xs \<sharp>* M"
  and   "Ys \<sharp>* M"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> S \<open>Xs \<sharp>* P\<close> \<open>Ys \<sharp>* P\<close>
  have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule brinputPermFrameSubject)
  with \<open>Xs \<sharp>* M\<close> \<open>Ys \<sharp>* M\<close> S show ?thesis
    by simp
qed

lemma inputAlpha:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and p    :: "name prm"
    and xvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "set p \<subseteq> (set xvec) \<times> (set (p \<bullet> xvec))"
  and   "distinctPerm p"
  and   "xvec \<sharp>* P"
  and   "(p \<bullet> xvec) \<sharp>* P"

shows "\<Psi> \<rhd> P \<longmapsto>M\<lparr>(p \<bullet> N)\<rparr> \<prec> (p \<bullet> P')"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>set p \<subseteq> (set xvec) \<times> (set (p \<bullet> xvec))\<close> \<open>xvec \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close>
  have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by - (rule inputPermFrameSubject, auto)
  then have "(p \<bullet> p \<bullet> \<Psi>) \<rhd> (p \<bullet> P) \<longmapsto>(p \<bullet> ((p \<bullet> M)\<lparr>N\<rparr> \<prec> P'))" by(rule eqvts)
  with \<open>distinctPerm p\<close> \<open>xvec \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>set p \<subseteq> (set xvec) \<times> (set (p \<bullet> xvec))\<close>
  show ?thesis by(simp add: eqvts)
qed

lemma brinputAlpha:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and p    :: "name prm"
    and xvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "set p \<subseteq> (set xvec) \<times> (set (p \<bullet> xvec))"
  and   "distinctPerm p"
  and   "xvec \<sharp>* P"
  and   "(p \<bullet> xvec) \<sharp>* P"

shows "\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>(p \<bullet> N)\<rparr> \<prec> (p \<bullet> P')"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>set p \<subseteq> (set xvec) \<times> (set (p \<bullet> xvec))\<close> \<open>xvec \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close>
  have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'" by - (rule brinputPermFrameSubject, auto)
  then have "(p \<bullet> p \<bullet> \<Psi>) \<rhd> (p \<bullet> P) \<longmapsto> (p \<bullet> (\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> P'))" by(rule eqvts)
  with \<open>distinctPerm p\<close> \<open>xvec \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>set p \<subseteq> (set xvec) \<times> (set (p \<bullet> xvec))\<close>
  show ?thesis by(simp add: eqvts)
qed

lemma frameFresh[dest]:
  fixes x  :: name
    and A\<^sub>F :: "name list"
    and \<Psi>\<^sub>F :: 'b

assumes "x \<sharp> A\<^sub>F"
  and   "x \<sharp> \<langle>A\<^sub>F, \<Psi>\<^sub>F\<rangle>"

shows "x \<sharp> \<Psi>\<^sub>F"
  using assms
  by(simp add: frameResChainFresh) (simp add: fresh_def name_list_supp)

lemma outputSwapFrameSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and x    :: name
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "x \<sharp> P"
  and   "y \<sharp> P"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  using assms
proof(nominal_induct avoiding: x y rule: outputInduct')
  case cAlpha
  then show ?case by(simp add: create_residual.simps boundOutputChainAlpha'')
next
  case(cOutput \<Psi> M K N P x y)
  from \<open>x \<sharp> M\<langle>N\<rangle>.P\<close> have "x \<sharp> M" by simp
  from \<open>y \<sharp> M\<langle>N\<rangle>.P\<close> have "y \<sharp> M" by simp
  from \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> M) \<leftrightarrow> ([(x, y)] \<bullet> K)"
    by(rule chanEqClosed)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close>  have "([(x, y)] \<bullet> \<Psi>) \<turnstile> M \<leftrightarrow> ([(x, y)] \<bullet> K)"
    by(simp)
  then show ?case by(rule Output)
next
  case(cCase \<Psi> P M xvec N P' \<phi> Cs x y)
  from \<open>x \<sharp> Cases Cs\<close> \<open>y \<sharp> Cases Cs\<close> \<open>(\<phi>, P) \<in> set Cs\<close> have "x \<sharp> \<phi>" and "x \<sharp> P" and "y \<sharp> \<phi>" and "y \<sharp> P"
    by(auto dest: memFresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> have "([(x ,y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by(rule cCase)
  moreover note \<open>(\<phi>, P) \<in> set Cs\<close>
  moreover from \<open>\<Psi> \<turnstile> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> \<phi>)" by(rule statClosed)
  with \<open>x \<sharp> \<phi>\<close> \<open>y \<sharp> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> \<phi>" by simp
  ultimately show ?case using \<open>guarded P\<close> by(rule Case)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>Q Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>) = ([(x, y)] \<bullet> (extractFrame Q))"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "\<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle> = extractFrame Q"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>xvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close>
    by(force intro: Par1)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M xvec N Q' A\<^sub>P P x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> Q; y \<sharp> Q\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>) = ([(x, y)] \<bullet> (extractFrame P))"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "\<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle> = extractFrame P"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* xvec\<close>
    by(force intro: Par2)
next
  case(cOpen \<Psi> P M xvec yvec N P' z x y)
  from \<open>x \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> x\<close> have "x \<sharp> P" by(simp add: abs_fresh)
  from \<open>y \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> y\<close> have "y \<sharp> P" by(simp add: abs_fresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
  moreover with \<open>z \<sharp> \<Psi>\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> \<Psi>"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> \<Psi>" by simp
  moreover with \<open>z \<sharp> M\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> M"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> M" by simp
  ultimately show ?case using \<open>z \<in> supp N\<close> \<open>z \<sharp> xvec\<close> \<open>z \<sharp> yvec\<close>
    by(force intro!: Open)
next
  case(cScope \<Psi> P M xvec N P' z x y)
  from \<open>x \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> x\<close> have "x \<sharp> P" by(simp add: abs_fresh)
  from \<open>y \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> y\<close> have "y \<sharp> P" by(simp add: abs_fresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
  moreover with \<open>z \<sharp> \<Psi>\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> \<Psi>"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> \<Psi>" by simp
  moreover with \<open>z \<sharp> M\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> M"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> M" by simp
  ultimately show ?case using \<open>z \<sharp> N\<close> \<open>z \<sharp> xvec\<close>
    by(force intro!: Scope)
next
  case(cBang \<Psi> P M B x y)
  then show ?case by(force intro: Bang)
qed

lemma broutputSwapFrameSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and x    :: name
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "x \<sharp> P"
  and   "y \<sharp> P"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  using assms
proof(nominal_induct avoiding: x y rule: brOutputInduct')
  case cAlpha
  then show ?case by(simp add: create_residual.simps boundOutputChainAlpha'')
next
  case(cBrOutput \<Psi> M K N P x y)
  from \<open>x \<sharp> M\<langle>N\<rangle>.P\<close> have "x \<sharp> M" by simp
  from \<open>y \<sharp> M\<langle>N\<rangle>.P\<close> have "y \<sharp> M" by simp
  from \<open>\<Psi> \<turnstile> M \<preceq> K\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> M) \<preceq> ([(x, y)] \<bullet> K)"
    by(rule chanOutConClosed)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close>  have "([(x, y)] \<bullet> \<Psi>) \<turnstile> M \<preceq> ([(x, y)] \<bullet> K)"
    by(simp)
  then show ?case by(rule BrOutput)
next
  case(cCase \<Psi> P M xvec N P' \<phi> Cs x y)
  from \<open>x \<sharp> Cases Cs\<close> \<open>y \<sharp> Cases Cs\<close> \<open>(\<phi>, P) \<in> set Cs\<close> have "x \<sharp> \<phi>" and "x \<sharp> P" and "y \<sharp> \<phi>" and "y \<sharp> P"
    by(auto dest: memFresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> have "([(x ,y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by(rule cCase)
  moreover note \<open>(\<phi>, P) \<in> set Cs\<close>
  moreover from \<open>\<Psi> \<turnstile> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> ([(x, y)] \<bullet> \<phi>)" by(rule statClosed)
  with \<open>x \<sharp> \<phi>\<close> \<open>y \<sharp> \<phi>\<close> have "([(x, y)] \<bullet> \<Psi>) \<turnstile> \<phi>" by simp
  ultimately show ?case using \<open>guarded P\<close> by(rule Case)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>Q Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>) = ([(x, y)] \<bullet> (extractFrame Q))"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "\<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle> = extractFrame Q"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>xvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close>
    by(force intro: Par1)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M xvec N Q' A\<^sub>P P x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+
  from \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> Q; y \<sharp> Q\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>) = ([(x, y)] \<bullet> (extractFrame P))"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "\<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle> = extractFrame P"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp
  ultimately show ?case using \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* xvec\<close>
    by(force intro: Par2)
next
  case(cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+

  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(rule brinputSwapFrameSubject)
  then have permIn: "(([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> P'"
    by(simp add: eqvts)
  moreover from \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> Q; y \<sharp> Q\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close>
  have permOut: "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>) = ([(x, y)] \<bullet> (extractFrame P))"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "extractFrame P = \<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: eqvts)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>) = ([(x, y)] \<bullet> (extractFrame Q))"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "extractFrame Q = \<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp
  moreover from \<open>xvec \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>xvec \<sharp>* \<Psi>\<^sub>Q\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)" by simp
  moreover from \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)" by simp
  moreover from \<open>xvec \<sharp>* M\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> M)" by simp

  moreover note \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close>
    \<open>distinct xvec\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close>
  ultimately show ?case
    by(simp add: semantics.cBrComm1)
next
  case(cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q x y)
  from \<open>x \<sharp> P \<parallel> Q\<close> have "x \<sharp> P" and "x \<sharp> Q" by simp+
  from \<open>y \<sharp> P \<parallel> Q\<close> have "y \<sharp> P" and "y \<sharp> Q" by simp+

  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close> \<open>x \<sharp> Q\<close> \<open>y \<sharp> Q\<close>
  have "([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'"
    by(rule brinputSwapFrameSubject)
  then have permIn: "(([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>([(x, y)] \<bullet> M)\<lparr>N\<rparr> \<prec> Q'"
    by(simp add: eqvts)
  moreover from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have permOut: "([(x, y)] \<bullet> \<Psi>) \<otimes> ([(x, y)] \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>) = ([(x, y)] \<bullet> (extractFrame P))"
    by simp
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>x \<sharp> P\<close> \<open>A\<^sub>P \<sharp>* y\<close> \<open>y \<sharp> P\<close> have "extractFrame P = \<langle>A\<^sub>P, ([(x, y)] \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: eqvts)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> have "([(x, y)] \<bullet> \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>) = ([(x, y)] \<bullet> (extractFrame Q))"
    by simp
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>x \<sharp> Q\<close> \<open>A\<^sub>Q \<sharp>* y\<close> \<open>y \<sharp> Q\<close> have "extractFrame Q = \<langle>A\<^sub>Q, ([(x, y)] \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: eqvts)
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)" by simp
  moreover from \<open>A\<^sub>P \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>P) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>P \<sharp>* x\<close> \<open>A\<^sub>P \<sharp>* y\<close> have "A\<^sub>P \<sharp>* ([(x, y)] \<bullet> M)" by simp
  moreover from \<open>A\<^sub>Q \<sharp>* M\<close> have "([(x, y)] \<bullet> A\<^sub>Q) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>A\<^sub>Q \<sharp>* x\<close> \<open>A\<^sub>Q \<sharp>* y\<close> have "A\<^sub>Q \<sharp>* ([(x, y)] \<bullet> M)" by simp
  moreover from \<open>xvec \<sharp>* \<Psi>\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> \<Psi>)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> \<Psi>)" by simp
  moreover from \<open>xvec \<sharp>* \<Psi>\<^sub>Q\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>Q)" by simp
  moreover from \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> \<Psi>\<^sub>P)" by simp
  moreover from \<open>xvec \<sharp>* M\<close> have "([(x, y)] \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> M)"
    by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>xvec \<sharp>* x\<close> \<open>xvec \<sharp>* y\<close> have "xvec \<sharp>* ([(x, y)] \<bullet> M)" by simp

  moreover note \<open>distinct A\<^sub>P\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
    \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close>
    \<open>distinct xvec\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close>
  ultimately show ?case
    by(simp add: semantics.cBrComm2)
next
  case(cBrOpen \<Psi> P M xvec yvec N P' z x y)
  from \<open>x \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> x\<close> have "x \<sharp> P" by(simp add: abs_fresh)
  from \<open>y \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> y\<close> have "y \<sharp> P" by(simp add: abs_fresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
  moreover with \<open>z \<sharp> \<Psi>\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> \<Psi>"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> \<Psi>" by simp
  moreover with \<open>z \<sharp> M\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> M"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> M" by simp
  ultimately show ?case using \<open>z \<in> supp N\<close> \<open>z \<sharp> xvec\<close> \<open>z \<sharp> yvec\<close>
    by(force intro: BrOpen)
next
  case(cScope \<Psi> P M xvec N P' z x y)
  from \<open>x \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> x\<close> have "x \<sharp> P" by(simp add: abs_fresh)
  from \<open>y \<sharp> \<lparr>\<nu>z\<rparr>P\<close> \<open>z \<sharp> y\<close> have "y \<sharp> P" by(simp add: abs_fresh)
  from \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close> \<open>\<And>x y. \<lbrakk>x \<sharp> P; y \<sharp> P\<rbrakk> \<Longrightarrow> ([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by simp
  moreover with \<open>z \<sharp> \<Psi>\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> \<Psi>"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> \<Psi>" by simp
  moreover with \<open>z \<sharp> M\<close> have "([(x, y)] \<bullet> z) \<sharp> [(x, y)] \<bullet> M"
    by(simp add: pt_fresh_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>z \<sharp> x\<close> \<open>z \<sharp> y\<close> have "z \<sharp> [(x, y)] \<bullet> M" by simp
  ultimately show ?case using \<open>z \<sharp> N\<close> \<open>z \<sharp> xvec\<close>
    by(force intro: Scope)
next
  case(cBang \<Psi> P M B x y)
  then show ?case by(force intro: Bang)
qed

lemma outputPermFrameSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and p    :: "name prm"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   S: "set p \<subseteq> set yvec \<times> set zvec"
  and   "yvec \<sharp>* P"
  and   "zvec \<sharp>* P"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  {
    fix xvec N P' Xs YS
    assume "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" and "xvec \<sharp>* M" and "xvec \<sharp>* yvec" and "xvec \<sharp>* zvec"
    have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" using S
    proof(induct p)
      case Nil
      from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
      show ?case by simp
    next
      case(Cons a p)
      from \<open>set(a#p) \<subseteq> set yvec \<times> set zvec\<close> have "set p \<subseteq> set yvec \<times> set zvec" by auto
      then have Trans: "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by(rule Cons)
      show ?case
      proof(cases a)
        case (Pair x y)
        note Trans
        moreover from \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* zvec\<close> \<open>set p \<subseteq> set yvec \<times> set zvec\<close> \<open>xvec \<sharp>* M\<close> have "xvec \<sharp>* (p \<bullet> M)"
          by(simp add: freshChainSimps)
        moreover have "x \<in> set yvec" and "y \<in> set zvec"
          using \<open>set (a # p) \<subseteq> set yvec \<times> set zvec\<close> Pair by auto
        with \<open>yvec \<sharp>* P\<close> \<open>zvec \<sharp>* P\<close> have "x \<sharp> P" and "y \<sharp> P"
          by(auto simp add: fresh_star_def)
        ultimately have "([(x, y)] \<bullet> p \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
          by(rule outputSwapFrameSubject)
        then show ?thesis
          using Pair by simp
      qed
    qed
  }
  note Goal = this
  obtain q::"name prm" where "(q \<bullet> xvec) \<sharp>* yvec" and "(q \<bullet> xvec) \<sharp>* zvec" and "(q \<bullet> xvec) \<sharp>* xvec"
    and "(q \<bullet> xvec) \<sharp>* N" and "(q \<bullet> xvec) \<sharp>* P'" and "(q \<bullet> xvec) \<sharp>* M"
    and Sq: "(set q) \<subseteq> (set xvec) \<times> (set(q \<bullet> xvec))"
    by(rule name_list_avoiding[where xvec=xvec and c="(P, xvec, yvec, zvec, N, M, P')"]) auto
  with \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(q \<bullet> xvec)\<rparr>\<langle>(q \<bullet> N)\<rangle> \<prec> (q \<bullet> P')"
    by(simp add: boundOutputChainAlpha'' residualInject)
  then have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*(q \<bullet> xvec)\<rparr>\<langle>(q \<bullet> N)\<rangle> \<prec> (q \<bullet> P')"
    using \<open>(q \<bullet> xvec) \<sharp>* M\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* zvec\<close>
    by(rule Goal)
  with \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> Sq show ?thesis
    by(simp add: boundOutputChainAlpha'' residualInject)
qed

lemma broutputPermFrameSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and p    :: "name prm"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   S: "set p \<subseteq> set yvec \<times> set zvec"
  and   "yvec \<sharp>* P"
  and   "zvec \<sharp>* P"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  {
    fix xvec N P' Xs YS
    assume "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" and "xvec \<sharp>* M" and "xvec \<sharp>* yvec" and "xvec \<sharp>* zvec"
    have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" using S
    proof(induct p)
      case Nil
      from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
      show ?case by simp
    next
      case(Cons a p)
      from \<open>set(a#p) \<subseteq> set yvec \<times> set zvec\<close> have "set p \<subseteq> set yvec \<times> set zvec" by auto
      then have Trans: "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by(rule Cons)
      show ?case
      proof(cases a)
        case (Pair x y)
        note Trans
        moreover from \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* zvec\<close> \<open>set p \<subseteq> set yvec \<times> set zvec\<close> \<open>xvec \<sharp>* M\<close> have "xvec \<sharp>* (p \<bullet> M)"
          by(simp add: freshChainSimps)
        moreover have "x \<in> set yvec" and "y \<in> set zvec"
          using \<open>set (a # p) \<subseteq> set yvec \<times> set zvec\<close> Pair by auto
        with \<open>yvec \<sharp>* P\<close> \<open>zvec \<sharp>* P\<close> have "x \<sharp> P" and "y \<sharp> P"
          by(auto simp add: fresh_star_def)
        ultimately have "([(x, y)] \<bullet> p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
          by(rule broutputSwapFrameSubject)
        then show ?thesis
          using Pair by simp
      qed
    qed
  }
  note Goal = this
  obtain q::"name prm" where "(q \<bullet> xvec) \<sharp>* yvec" and "(q \<bullet> xvec) \<sharp>* zvec" and "(q \<bullet> xvec) \<sharp>* xvec"
    and "(q \<bullet> xvec) \<sharp>* N" and "(q \<bullet> xvec) \<sharp>* P'" and "(q \<bullet> xvec) \<sharp>* M"
    and Sq: "(set q) \<subseteq> (set xvec) \<times> (set(q \<bullet> xvec))"
    by(rule name_list_avoiding[where xvec=xvec and c="(P, xvec, yvec, zvec, N, M, P')"]) auto
  with \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(q \<bullet> xvec)\<rparr>\<langle>(q \<bullet> N)\<rangle> \<prec> (q \<bullet> P')"
    by(simp add: boundOutputChainAlpha'' residualInject)
  then have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(q \<bullet> xvec)\<rparr>\<langle>(q \<bullet> N)\<rangle> \<prec> (q \<bullet> P')"
    using \<open>(q \<bullet> xvec) \<sharp>* M\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* zvec\<close>
    by(rule Goal)
  with \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> Sq show ?thesis
    by(simp add: boundOutputChainAlpha'' residualInject)
qed

lemma outputSwapSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and x    :: name
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> \<Psi>"
  and   "y \<sharp> \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(rule outputSwapFrameSubject)
  with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> show ?thesis
    by simp
qed

lemma broutputSwapSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and x    :: name
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> \<Psi>"
  and   "y \<sharp> \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(rule broutputSwapFrameSubject)
  with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> show ?thesis
    by simp
qed

lemma outputPermSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and p    :: "name prm"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   S: "set p \<subseteq> set yvec \<times> set zvec"
  and   "yvec \<sharp>* P"
  and   "zvec \<sharp>* P"
  and   "yvec \<sharp>* \<Psi>"
  and   "zvec \<sharp>* \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from assms have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(metis outputPermFrameSubject)
  with S \<open>yvec \<sharp>* \<Psi>\<close> \<open>zvec \<sharp>* \<Psi>\<close> show ?thesis
    by simp
qed

lemma broutputPermSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and p    :: "name prm"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   S: "set p \<subseteq> set yvec \<times> set zvec"
  and   "yvec \<sharp>* P"
  and   "zvec \<sharp>* P"
  and   "yvec \<sharp>* \<Psi>"
  and   "zvec \<sharp>* \<Psi>"

shows "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from assms have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(metis broutputPermFrameSubject)
  with S \<open>yvec \<sharp>* \<Psi>\<close> \<open>zvec \<sharp>* \<Psi>\<close> show ?thesis
    by simp
qed

lemma outputSwapFrame:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and x    :: name
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> M"
  and   "y \<sharp> M"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(rule outputSwapFrameSubject)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> show ?thesis
    by simp
qed

lemma broutputSwapFrame:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and x    :: name
    and y    :: name

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "xvec \<sharp>* M"
  and   "x \<sharp> P"
  and   "y \<sharp> P"
  and   "x \<sharp> M"
  and   "y \<sharp> M"

shows "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>xvec \<sharp>* M\<close> \<open>x \<sharp> P\<close> \<open>y \<sharp> P\<close>
  have "([(x, y)] \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(rule broutputSwapFrameSubject)
  with \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> show ?thesis
    by simp
qed

lemma outputPermFrame:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and p    :: "name prm"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   S: "set p \<subseteq> set yvec \<times> set zvec"
  and   "yvec \<sharp>* P"
  and   "zvec \<sharp>* P"
  and   "yvec \<sharp>* M"
  and   "zvec \<sharp>* M"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from assms have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(metis outputPermFrameSubject)
  with S \<open>yvec \<sharp>* M\<close> \<open>zvec \<sharp>* M\<close> show ?thesis
    by simp
qed

lemma broutputPermFrame:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and B    :: "('a, 'b, 'c) boundOutput"
    and p    :: "name prm"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   S: "set p \<subseteq> set yvec \<times> set zvec"
  and   "yvec \<sharp>* P"
  and   "zvec \<sharp>* P"
  and   "yvec \<sharp>* M"
  and   "zvec \<sharp>* M"

shows "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
proof -
  from assms have "(p \<bullet> \<Psi>) \<rhd> P \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
    by(metis broutputPermFrameSubject)
  with S \<open>yvec \<sharp>* M\<close> \<open>zvec \<sharp>* M\<close> show ?thesis
    by simp
qed

lemma Comm1:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>Q  :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P  :: 'b
    and Q    :: "('a, 'b, 'c) psi"
    and K    :: 'a
    and xvec :: "name list"
    and Q'   :: "('a, 'b, 'c) psi"
    and A\<^sub>Q   :: "name list"

assumes "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
  and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* Q"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* A\<^sub>Q"
  and   "A\<^sub>Q \<sharp>* \<Psi>"
  and   "A\<^sub>Q \<sharp>* P"
  and   "A\<^sub>Q \<sharp>* Q"
  and   "A\<^sub>Q \<sharp>* K"
  and   "xvec \<sharp>* P"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>Q  :: 'b
      and P    :: "('a, 'b, 'c) psi"
      and M    :: 'a
      and N    :: 'a
      and P'   :: "('a, 'b, 'c) psi"
      and A\<^sub>P   :: "name list"
      and \<Psi>\<^sub>P  :: 'b
      and Q    :: "('a, 'b, 'c) psi"
      and K    :: 'a
      and xvec :: "name list"
      and Q'   :: "('a, 'b, 'c) psi"
      and A\<^sub>Q   :: "name list"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
      and  "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and  "distinct A\<^sub>P"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
      and  "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and  "distinct A\<^sub>Q"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K"
      and  "A\<^sub>P \<sharp>* \<Psi>"
      and  "A\<^sub>P \<sharp>* P"
      and  "A\<^sub>P \<sharp>* Q"
      and  "A\<^sub>P \<sharp>* M"
      and  "A\<^sub>P \<sharp>* A\<^sub>Q"
      and  "A\<^sub>Q \<sharp>* \<Psi>"
      and  "A\<^sub>Q \<sharp>* P"
      and  "A\<^sub>Q \<sharp>* Q"
      and  "A\<^sub>Q \<sharp>* K"
      and  "xvec \<sharp>* P"

    have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')"
    proof -

      obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
        and "(r \<bullet> xvec) \<sharp>* K" and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
        and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
        and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
        by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, K, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* K"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q"
        and Sq: "set q \<subseteq> set A\<^sub>Q \<times> set(q \<bullet> A\<^sub>Q)"
        by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, K, r \<bullet> N, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
        by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, r \<bullet> N, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)
      have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
      have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

      from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
        by(force dest: extractFrameFreshChain)
      from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
        by(force dest: extractFrameFreshChain)
      from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> A\<^sub>P)"
        by(simp add: freshChainSimps)

      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> Sr \<open>distinctPerm r\<close> \<open>xvec \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* P\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')"
        by(rule inputAlpha)
      then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
        by - (rule inputPermFrameSubject, (assumption | simp)+)
      then have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)

      moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
      have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

      moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')"
        by(simp add: boundOutputChainAlpha'' create_residual.simps)
      then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* K\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(r \<bullet> xvec) \<sharp>* (p \<bullet> A\<^sub>P)\<close>
        by(fastforce intro: outputPermFrameSubject)
      then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      moreover then have "distinct(r \<bullet> xvec)" by(force dest: boundOutputDistinct)
      moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
      have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

      moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(p \<bullet> q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)) \<turnstile> (p \<bullet> q \<bullet> M) \<leftrightarrow> (p \<bullet> q \<bullet> K)"
        by(metis chanEqClosed)
      with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close>
        \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>A\<^sub>Q \<sharp>* K\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close>  Sp Sq
      have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<turnstile> (q \<bullet> M) \<leftrightarrow> (p \<bullet> K)" by(simp add: eqvts freshChainSimps)
      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close>
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> M)"
        by(simp add: freshChainSimps)
      moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)\<close>\<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close>
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> K)"
        by(simp add: freshChainSimps)
      moreover note  \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> M)"
        by(simp add: freshChainSimps)
      moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* K\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> K)"
        by(simp add: freshChainSimps)
      ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<tau> \<prec> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>((r \<bullet> P') \<parallel> (r \<bullet> Q'))"
        by - (rule cComm1)
      with \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> Sr
      show ?thesis
        by(subst resChainAlpha) auto
    qed
  }
  note Goal = this
  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close>
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>P' where "extractFrame P = \<langle>A\<^sub>P', \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P'" and "A\<^sub>P' \<sharp>* \<Psi>" and "A\<^sub>P' \<sharp>* P" and "A\<^sub>P' \<sharp>* Q" and "A\<^sub>P' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>Q)"], auto)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>A\<^sub>P' \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>Q' where "extractFrame Q = \<langle>A\<^sub>Q', \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q'" and "A\<^sub>Q' \<sharp>* \<Psi>" and "A\<^sub>Q' \<sharp>* P" and "A\<^sub>Q' \<sharp>* Q" and "A\<^sub>Q' \<sharp>* K" and "A\<^sub>P' \<sharp>* A\<^sub>Q'"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, K, A\<^sub>P')"], auto)
  ultimately show ?thesis using \<open>xvec \<sharp>* P\<close>
    by(metis Goal)
qed

lemma Comm2:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>Q  :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P  :: 'b
    and Q    :: "('a, 'b, 'c) psi"
    and K    :: 'a
    and Q'   :: "('a, 'b, 'c) psi"
    and A\<^sub>Q   :: "name list"

assumes "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'"
  and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* Q"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* A\<^sub>Q"
  and   "A\<^sub>Q \<sharp>* \<Psi>"
  and   "A\<^sub>Q \<sharp>* P"
  and   "A\<^sub>Q \<sharp>* Q"
  and   "A\<^sub>Q \<sharp>* K"
  and   "xvec \<sharp>* Q"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>Q  :: 'b
      and P    :: "('a, 'b, 'c) psi"
      and M    :: 'a
      and xvec :: "name list"
      and N    :: 'a
      and P'   :: "('a, 'b, 'c) psi"
      and A\<^sub>P   :: "name list"
      and \<Psi>\<^sub>P  :: 'b
      and Q    :: "('a, 'b, 'c) psi"
      and K    :: 'a
      and Q'   :: "('a, 'b, 'c) psi"
      and A\<^sub>Q   :: "name list"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
      and  "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and  "distinct A\<^sub>P"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'"
      and  "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and  "distinct A\<^sub>Q"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K"
      and  "A\<^sub>P \<sharp>* \<Psi>"
      and  "A\<^sub>P \<sharp>* P"
      and  "A\<^sub>P \<sharp>* Q"
      and  "A\<^sub>P \<sharp>* M"
      and  "A\<^sub>P \<sharp>* A\<^sub>Q"
      and  "A\<^sub>Q \<sharp>* \<Psi>"
      and  "A\<^sub>Q \<sharp>* P"
      and  "A\<^sub>Q \<sharp>* Q"
      and  "A\<^sub>Q \<sharp>* K"
      and  "xvec \<sharp>* Q"

    have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')"
    proof -

      obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
        and "(r \<bullet> xvec) \<sharp>* K" and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
        and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
        and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
        by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, K, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* K"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q"
        and Sq: "set q \<subseteq> set A\<^sub>Q \<times> set(q \<bullet> A\<^sub>Q)"
        by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, K, r \<bullet> N, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
        by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, r \<bullet> N, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)

      have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
      have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

      from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
        by(auto dest: extractFrameFreshChain)
      from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
        by(auto dest: extractFrameFreshChain)

      from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> A\<^sub>Q)"
        by(simp add: freshChainSimps)

      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')"
        by(simp add: boundOutputChainAlpha'' create_residual.simps)
      then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(r \<bullet> xvec) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        by(fastforce intro: outputPermFrameSubject)
      then have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      moreover then have "distinct(r \<bullet> xvec)" by(force dest: boundOutputDistinct)

      moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
      have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

      moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'\<close> Sr \<open>distinctPerm r\<close> \<open>xvec \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')"
        by(rule inputAlpha)
      then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
        by - (rule inputPermFrameSubject, (assumption | simp)+)
      then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)

      moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
      have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

      moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(p \<bullet> q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)) \<turnstile> (p \<bullet> q \<bullet> M) \<leftrightarrow> (p \<bullet> q \<bullet> K)"
        by(metis chanEqClosed)
      with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close>
        \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>A\<^sub>Q \<sharp>* K\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close>  Sp Sq
      have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<turnstile> (q \<bullet> M) \<leftrightarrow> (p \<bullet> K)"
        by(simp add: eqvts freshChainSimps)
      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close>
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> M)"
        by(simp add: freshChainSimps)
      moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)\<close>\<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close>
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> K)"
        by(simp add: freshChainSimps)
      moreover note  \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> M)"
        by(simp add: freshChainSimps)
      moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* K\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> K)"
        by(simp add: freshChainSimps)
      ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<tau> \<prec> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>((r \<bullet> P') \<parallel> (r \<bullet> Q'))"
        by - (rule cComm2)
      with \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> Sr
      show ?thesis
        by(subst resChainAlpha) auto
    qed
  }
  note Goal = this
  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close>
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>P' where "extractFrame P = \<langle>A\<^sub>P', \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P'" and "A\<^sub>P' \<sharp>* \<Psi>" and "A\<^sub>P' \<sharp>* P" and "A\<^sub>P' \<sharp>* Q" and "A\<^sub>P' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>Q)"], auto)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>A\<^sub>P' \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>Q' where "extractFrame Q = \<langle>A\<^sub>Q', \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q'" and "A\<^sub>Q' \<sharp>* \<Psi>" and "A\<^sub>Q' \<sharp>* P" and "A\<^sub>Q' \<sharp>* Q" and "A\<^sub>Q' \<sharp>* K" and "A\<^sub>P' \<sharp>* A\<^sub>Q'"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, K, A\<^sub>P')"], auto)
  ultimately show ?thesis using \<open>xvec \<sharp>* Q\<close>
    by(metis Goal)
qed

lemma BrMerge:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>Q  :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P  :: 'b
    and Q    :: "('a, 'b, 'c) psi"
    and Q'   :: "('a, 'b, 'c) psi"
    and A\<^sub>Q   :: "name list"

assumes "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
  and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* Q"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* A\<^sub>Q"
  and   "A\<^sub>Q \<sharp>* \<Psi>"
  and   "A\<^sub>Q \<sharp>* P"
  and   "A\<^sub>Q \<sharp>* Q"
  and   "A\<^sub>Q \<sharp>* M"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>Q  :: 'b
      and P    :: "('a, 'b, 'c) psi"
      and M    :: 'a
      and N    :: 'a
      and P'   :: "('a, 'b, 'c) psi"
      and A\<^sub>P   :: "name list"
      and \<Psi>\<^sub>P  :: 'b
      and Q    :: "('a, 'b, 'c) psi"
      and Q'   :: "('a, 'b, 'c) psi"
      and A\<^sub>Q   :: "name list"
      and svec :: "name list"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
      and  "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and  "distinct A\<^sub>P"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
      and  "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and  "distinct A\<^sub>Q"
      and  "A\<^sub>P \<sharp>* \<Psi>"
      and  "A\<^sub>P \<sharp>* P"
      and  "A\<^sub>P \<sharp>* Q"
      and  "A\<^sub>P \<sharp>* M"
      and  "A\<^sub>P \<sharp>* A\<^sub>Q"
      and  "A\<^sub>Q \<sharp>* \<Psi>"
      and  "A\<^sub>Q \<sharp>* P"
      and  "A\<^sub>Q \<sharp>* Q"
      and  "A\<^sub>Q \<sharp>* M"

    have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')"
    proof -
      obtain q::"name prm" where "(q \<bullet> (A\<^sub>Q::name list)) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* M"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* N" and "(q \<bullet> A\<^sub>Q) \<sharp>* P'" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q'"
        and Sq: "set q \<subseteq> set A\<^sub>Q \<times> set(q \<bullet> A\<^sub>Q)"
        and "distinctPerm q"
        by(rule name_list_avoiding[where c="(\<Psi>, P, M, N, P', Q', Q, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P)"])
          (auto simp add: eqvts fresh_star_prod)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P"
        and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
        and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
        and "(p \<bullet> A\<^sub>P) \<sharp>* N" and "(p \<bullet> A\<^sub>P) \<sharp>* P'" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'"
        and Sp: "set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P)"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)"
        by(rule name_list_avoiding[where c="(\<Psi>, P, N, P', Q', Q, M, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P)"])
          (auto simp add: eqvts fresh_star_prod)

      have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
      have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

      from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
        by(force dest: extractFrameFreshChain)
      from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
        by(force dest: extractFrameFreshChain)

      from Sq \<open>A\<^sub>Q \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
      have "(q \<bullet> M) = M"
        by simp
      from Sp \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
      have "(p \<bullet> M) = M"
        by simp

      from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)" by simp
      moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp
      moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
      have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
      have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
        by(simp add: frameChainAlpha)

      moreover have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>N\<rparr> \<prec> P'" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close>
        by - (rule brinputPermFrameSubject, (assumption | simp)+)
      then have "(\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>N\<rparr> \<prec> P'" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      with \<open>(q \<bullet> M) = M\<close> have PTrans: "(\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
        by simp

      moreover have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> Q'" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close>
        by - (rule brinputPermFrameSubject, (assumption | simp)+)
      then have "(\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> Q'" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      with \<open>(p \<bullet> M) = M\<close> have PTrans: "(\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
        by simp
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)

      moreover note
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* N\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
        \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* N\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P'\<close>
        \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q'\<close>
      ultimately show ?thesis
        by(simp add: cBrMerge)
    qed
  }
  note Goal = this

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close>
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>P' where "extractFrame P = \<langle>A\<^sub>P', \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P'" and "A\<^sub>P' \<sharp>* \<Psi>" and "A\<^sub>P' \<sharp>* P" and "A\<^sub>P' \<sharp>* Q" and "A\<^sub>P' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>Q)"], auto)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P' \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>Q' where "extractFrame Q = \<langle>A\<^sub>Q', \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q'" and "A\<^sub>Q' \<sharp>* \<Psi>" and "A\<^sub>Q' \<sharp>* P" and "A\<^sub>Q' \<sharp>* Q" and "A\<^sub>Q' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q'"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>P')"], auto)
  ultimately show ?thesis
    by(metis Goal)
qed

lemma BrComm1:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>Q  :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P  :: 'b
    and Q    :: "('a, 'b, 'c) psi"
    and xvec :: "name list"
    and Q'   :: "('a, 'b, 'c) psi"
    and A\<^sub>Q   :: "name list"

assumes "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
  and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* Q"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* A\<^sub>Q"
  and   "A\<^sub>Q \<sharp>* \<Psi>"
  and   "A\<^sub>Q \<sharp>* P"
  and   "A\<^sub>Q \<sharp>* Q"
  and   "A\<^sub>Q \<sharp>* M"
  and   "xvec \<sharp>* P"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>Q  :: 'b
      and P    :: "('a, 'b, 'c) psi"
      and M    :: 'a
      and N    :: 'a
      and P'   :: "('a, 'b, 'c) psi"
      and A\<^sub>P   :: "name list"
      and \<Psi>\<^sub>P  :: 'b
      and Q    :: "('a, 'b, 'c) psi"
      and xvec :: "name list"
      and Q'   :: "('a, 'b, 'c) psi"
      and A\<^sub>Q   :: "name list"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
      and  "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and  "distinct A\<^sub>P"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'"
      and  "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and  "distinct A\<^sub>Q"
      and  "A\<^sub>P \<sharp>* \<Psi>"
      and  "A\<^sub>P \<sharp>* P"
      and  "A\<^sub>P \<sharp>* Q"
      and  "A\<^sub>P \<sharp>* M"
      and  "A\<^sub>P \<sharp>* A\<^sub>Q"
      and  "A\<^sub>Q \<sharp>* \<Psi>"
      and  "A\<^sub>Q \<sharp>* P"
      and  "A\<^sub>Q \<sharp>* Q"
      and  "A\<^sub>Q \<sharp>* M"
      and  "xvec \<sharp>* P"

    have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')"
    proof -
      obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
        and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
        and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
        and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
        by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* M"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q"
        and Sq: "set q \<subseteq> set A\<^sub>Q \<times> set(q \<bullet> A\<^sub>Q)"
        by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, M, r \<bullet> N, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
        by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, r \<bullet> N, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)

      have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
      have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

      from Sp \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
      have "(p \<bullet> M) = M"
        by simp
      from Sq \<open>A\<^sub>Q \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
      have "(q \<bullet> M) = M"
        by simp

      from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
        by(auto dest: extractFrameFreshChain)
      from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
        by(auto dest: extractFrameFreshChain)
      from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> A\<^sub>P)"
        by(simp add: freshChainSimps)

      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> Sr \<open>distinctPerm r\<close> \<open>xvec \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* P\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')"
        by(rule brinputAlpha)
      then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
        by - (rule brinputPermFrameSubject, (assumption | simp)+)
      then have "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      with \<open>(q \<bullet> M) = M\<close> have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" by simp

      moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
      have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)" by simp

      moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')"
        by(simp add: boundOutputChainAlpha'' create_residual.simps)
      then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(r \<bullet> xvec) \<sharp>* (p \<bullet> A\<^sub>P)\<close>
        by(fastforce intro: broutputPermFrameSubject)
      then have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      with \<open>(p \<bullet> M) = M\<close> have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" by simp
      moreover then have "distinct(r \<bullet> xvec)" by(force dest: boundOutputDistinct)
      moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
      have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
      moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)\<close>\<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
      moreover note  \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
      moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
      ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> ((r \<bullet> P') \<parallel> (r \<bullet> Q'))"
        by - (rule cBrComm1)
      then have permuted: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> (P' \<parallel> Q'))" by simp
      note \<open>(r \<bullet> xvec) \<sharp>* N\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close>
      have "(r \<bullet> xvec) \<sharp>* (P' \<parallel> Q')" by simp
      moreover note Sr
      moreover have "set xvec \<subseteq> set xvec" by simp
      ultimately have "\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q') = \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> N) \<prec>' (r \<bullet> (P' \<parallel> Q'))"
        by(rule boundOutputChainAlpha'')
      then have "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q') = \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> (P' \<parallel> Q'))"
        by(simp only: create_residual.simps)
      with permuted show ?thesis
        by simp
    qed
  }
  note Goal = this

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close>
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>P' where "extractFrame P = \<langle>A\<^sub>P', \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P'" and "A\<^sub>P' \<sharp>* \<Psi>" and "A\<^sub>P' \<sharp>* P" and "A\<^sub>P' \<sharp>* Q" and "A\<^sub>P' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>Q)"], auto)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P' \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>Q' where "extractFrame Q = \<langle>A\<^sub>Q', \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q'" and "A\<^sub>Q' \<sharp>* \<Psi>" and "A\<^sub>Q' \<sharp>* P" and "A\<^sub>Q' \<sharp>* Q" and "A\<^sub>Q' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q'"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>P')"], auto)
  ultimately show ?thesis using \<open>xvec \<sharp>* P\<close>
    by(metis Goal)
qed

lemma BrComm2:
  fixes \<Psi>    :: 'b
    and \<Psi>\<^sub>Q  :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P  :: 'b
    and Q    :: "('a, 'b, 'c) psi"
    and Q'   :: "('a, 'b, 'c) psi"
    and A\<^sub>Q   :: "name list"

assumes "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
  and   "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* Q"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* A\<^sub>Q"
  and   "A\<^sub>Q \<sharp>* \<Psi>"
  and   "A\<^sub>Q \<sharp>* P"
  and   "A\<^sub>Q \<sharp>* Q"
  and   "A\<^sub>Q \<sharp>* M"
  and   "xvec \<sharp>* Q"

shows "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')"
proof -
  {
    fix \<Psi>    :: 'b
      and \<Psi>\<^sub>Q  :: 'b
      and P    :: "('a, 'b, 'c) psi"
      and M    :: 'a
      and xvec :: "name list"
      and N    :: 'a
      and P'   :: "('a, 'b, 'c) psi"
      and A\<^sub>P   :: "name list"
      and \<Psi>\<^sub>P  :: 'b
      and Q    :: "('a, 'b, 'c) psi"
      and Q'   :: "('a, 'b, 'c) psi"
      and A\<^sub>Q   :: "name list"

    assume "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
      and  "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and  "distinct A\<^sub>P"
      and  "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
      and  "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and  "distinct A\<^sub>Q"
      and  "A\<^sub>P \<sharp>* \<Psi>"
      and  "A\<^sub>P \<sharp>* P"
      and  "A\<^sub>P \<sharp>* Q"
      and  "A\<^sub>P \<sharp>* M"
      and  "A\<^sub>P \<sharp>* A\<^sub>Q"
      and  "A\<^sub>Q \<sharp>* \<Psi>"
      and  "A\<^sub>Q \<sharp>* P"
      and  "A\<^sub>Q \<sharp>* Q"
      and  "A\<^sub>Q \<sharp>* M"
      and  "xvec \<sharp>* Q"

    have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')"
    proof -
      obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
        and "(r \<bullet> xvec) \<sharp>* M" and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
        and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
        and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
        by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* M"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
        and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q"
        and Sq: "set q \<subseteq> set A\<^sub>Q \<times> set(q \<bullet> A\<^sub>Q)"
        by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, M, r \<bullet> N, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)
      obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
        and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
        by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, r \<bullet> N, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, r \<bullet> Q', r \<bullet> P')"])
          (auto simp add: eqvts fresh_star_prod)

      have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
      have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

      from Sp \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
      have "(p \<bullet> M) = M"
        by simp
      from Sq \<open>A\<^sub>Q \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
      have "(q \<bullet> M) = M"
        by simp

      from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
        by(auto dest: extractFrameFreshChain)
      from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
        by(auto dest: extractFrameFreshChain)
      from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> A\<^sub>Q)"
        by(simp add: freshChainSimps)

      from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')"
        by(simp add: boundOutputChainAlpha'' create_residual.simps)
      then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<exclamdown>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(r \<bullet> xvec) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        by(fastforce intro: broutputPermFrameSubject)
      then have "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<exclamdown>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      with \<open>(q \<bullet> M) = M\<close> have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" by simp
      moreover then have "distinct(r \<bullet> xvec)" by(force dest: boundOutputDistinct)

      moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
      have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

      moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close> Sr \<open>distinctPerm r\<close> \<open>xvec \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
      have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')"
        by(rule brinputAlpha)
      then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
        by - (rule brinputPermFrameSubject, (assumption | simp)+)
      then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
        by(simp add: eqvts)
      with \<open>(p \<bullet> M) = M\<close> have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" by simp

      moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
      have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
        by(simp add: frameChainAlpha)
      moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
      moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
      moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
        \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
      moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)\<close>\<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
      moreover note  \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
        by(simp add: freshChainSimps)
      moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
        by(simp add: freshChainSimps)
      moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
      moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
      ultimately have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> ((r \<bullet> P') \<parallel> (r \<bullet> Q'))"
        by - (rule cBrComm2)
      then have permuted: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> (P' \<parallel> Q'))" by simp
      note \<open>(r \<bullet> xvec) \<sharp>* N\<close>
      moreover from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close>
      have "(r \<bullet> xvec) \<sharp>* (P' \<parallel> Q')" by simp
      moreover note Sr
      moreover have "set xvec \<subseteq> set xvec" by simp
      ultimately have "\<lparr>\<nu>*xvec\<rparr>N \<prec>' (P' \<parallel> Q') = \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> N) \<prec>' (r \<bullet> (P' \<parallel> Q'))"
        by(rule boundOutputChainAlpha'')
      then have "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q') = \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> (P' \<parallel> Q'))"
        by(simp only: create_residual.simps)
      with permuted show ?thesis
        by simp
    qed
  }
  note Goal = this

  note \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close>
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>P' where "extractFrame P = \<langle>A\<^sub>P', \<Psi>\<^sub>P\<rangle>" and "distinct A\<^sub>P'" and "A\<^sub>P' \<sharp>* \<Psi>" and "A\<^sub>P' \<sharp>* P" and "A\<^sub>P' \<sharp>* Q" and "A\<^sub>P' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>Q)"], auto)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>P' \<sharp>* A\<^sub>Q\<close>
  obtain A\<^sub>Q' where "extractFrame Q = \<langle>A\<^sub>Q', \<Psi>\<^sub>Q\<rangle>" and "distinct A\<^sub>Q'" and "A\<^sub>Q' \<sharp>* \<Psi>" and "A\<^sub>Q' \<sharp>* P" and "A\<^sub>Q' \<sharp>* Q" and "A\<^sub>Q' \<sharp>* M" and "A\<^sub>P' \<sharp>* A\<^sub>Q'"
    by - (rule distinctFrame[where C="(\<Psi>, P, Q, M, A\<^sub>P')"], auto)
  ultimately show ?thesis using \<open>xvec \<sharp>* Q\<close>
    by(metis Goal)
qed

lemma BrClose:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and x    :: name

assumes "\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "x \<in> supp M"
  and   "x \<sharp> \<Psi>"

shows "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto> \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')"
proof -
  obtain p where xvecFreshPsi: "((p::name prm) \<bullet> (xvec::name list)) \<sharp>* \<Psi>"
    and xvecFreshM: "(p \<bullet> xvec) \<sharp>* M"
    and xvecFreshN: "(p \<bullet> xvec) \<sharp>* N"
    and xvecFreshP: "(p \<bullet> xvec) \<sharp>* P"
    and xvecFreshP: "(p \<bullet> xvec) \<sharp>* P'"
    and xvecFrechx: "(p \<bullet> xvec) \<sharp>* x"
    and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))"
    and dp: "distinctPerm p"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, M, N, P, P', x)"])
      (auto simp add: eqvts fresh_star_prod)

  obtain y::name where "y \<sharp> P" and "y \<sharp> xvec" and "y \<noteq> x" and "y \<sharp> N"
    and "y \<sharp> (p \<bullet> xvec)" and "y \<sharp> (p \<bullet> P')"
    and "y \<sharp> M" and "y \<sharp> \<Psi>" and "y \<sharp> P'"
    by(generate_fresh "name") (auto simp add: freshChainSimps)

  from \<open>y \<sharp> (p \<bullet> xvec)\<close> \<open>y \<sharp> (p \<bullet> P')\<close>
  have yFreshRes: "y \<sharp> (\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>(p \<bullet> P'))"
    by(simp add: resChainFresh)

  from \<open>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> S
    \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close>
  have "\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P')"
    by(simp add: alphaOutputResidual)

  then have "[(x, y)] \<bullet> (\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P'))"
    by simp
  with \<open>(p \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (p \<bullet> xvec)\<close>
    \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close>
  have pretrans: "\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto> \<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>\<langle>([(x, y)] \<bullet> (p \<bullet> N))\<rangle> \<prec> ([(x, y)] \<bullet> (p \<bullet> P'))"
    by(simp add: eqvts)

  moreover from \<open>x \<in> supp M\<close> \<open>y \<sharp> M\<close>
  have "y \<in> supp ([(x, y)] \<bullet> M)"
    by (metis fresh_bij fresh_def swap_simps)

  moreover from pretrans
  have "distinct (p \<bullet> xvec)"
    by(force dest: boundOutputDistinct)

  moreover note \<open>(p \<bullet> xvec) \<sharp>* \<Psi>\<close>
  moreover from \<open>(p \<bullet> xvec) \<sharp>* P\<close> \<open>(p \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (p \<bullet> xvec)\<close>
  have "(p \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> P)" by simp
  moreover from \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>(p \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (p \<bullet> xvec)\<close>
  have "(p \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> M)" by simp
  moreover note \<open>y \<sharp> \<Psi>\<close> \<open>y \<sharp> (p \<bullet> xvec)\<close>

  ultimately have "\<Psi> \<rhd> \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> P) \<longmapsto> \<tau> \<prec> \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>([(x, y)] \<bullet> (p \<bullet> P')))"
    by(rule cBrClose)
  with \<open>(p \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (p \<bullet> xvec)\<close>
  have "\<Psi> \<rhd> \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> P) \<longmapsto> \<tau> \<prec> \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> (\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>(p \<bullet> P')))"
    by(simp add: eqvts)
  with yFreshRes \<open>y \<sharp> P\<close>
  have "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto> \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*(p \<bullet> xvec)\<rparr>(p \<bullet> P'))"
    by(simp add: alphaRes)

  with \<open>(p \<bullet> xvec) \<sharp>* P'\<close> S
  show ?thesis
    by(simp add: resChainAlpha)
qed

lemma semanticsCasesAux[consumes 1, case_names cInput cBrInput cOutput cBrOutput cCase cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2 cBrClose cOpen cBrOpen cScope cBang]:
  fixes cP  :: "('a, 'b, 'c) psi"
    and cRs :: "('a, 'b, 'c) residual"
    and C   :: "'f::fs_name"
    and x   :: name

assumes "\<Psi> \<rhd> cP \<longmapsto> cRs"
  and   rInput: "\<And>M K xvec N Tvec P. \<lbrakk>cP = M\<lparr>\<lambda>*xvec N\<rparr>.P;  cRs = K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec];
                                            \<Psi> \<turnstile> M \<leftrightarrow> K; distinct xvec; set xvec \<subseteq> supp N; length xvec=length Tvec;
                                            xvec \<sharp>* Tvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow> Prop"
  and   rBrInput: "\<And>M K xvec N Tvec P. \<lbrakk>cP = M\<lparr>\<lambda>*xvec N\<rparr>.P;  cRs = \<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec];
                                            \<Psi> \<turnstile> K \<succeq> M; distinct xvec; set xvec \<subseteq> supp N; length xvec=length Tvec;
                                            xvec \<sharp>* Tvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* M; xvec \<sharp>* K; xvec \<sharp>* C\<rbrakk> \<Longrightarrow> Prop"
  and   rOutput: "\<And>M K N P. \<lbrakk>cP = M\<langle>N\<rangle>.P; cRs = K\<langle>N\<rangle> \<prec> P; \<Psi> \<turnstile> M \<leftrightarrow> K\<rbrakk> \<Longrightarrow> Prop"
  and   rBrOutput: "\<And>M K N P. \<lbrakk>cP = M\<langle>N\<rangle>.P; cRs = \<exclamdown>K\<langle>N\<rangle> \<prec> P; \<Psi> \<turnstile> M \<preceq> K\<rbrakk> \<Longrightarrow> Prop"
  and   rCase: "\<And>Cs P \<phi>. \<lbrakk>cP = Cases Cs; \<Psi> \<rhd> P \<longmapsto> cRs; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow> Prop"

and  rPar1: "\<And>\<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q. \<lbrakk>cP = P \<parallel> Q; cRs = \<alpha> \<prec> (P' \<parallel> Q);
               (\<Psi> \<otimes> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto> (\<alpha> \<prec> P'); extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
               A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* C; A\<^sub>Q \<sharp>* P'; bn \<alpha> \<sharp>* \<Psi>; bn \<alpha>  \<sharp>* \<Psi>\<^sub>Q;
               bn \<alpha>  \<sharp>* Q; bn \<alpha>  \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* C; distinct(bn \<alpha>)\<rbrakk> \<Longrightarrow>
               Prop"
and   rPar2:   "\<And>\<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P. \<lbrakk>cP = P \<parallel> Q; cRs = \<alpha> \<prec> (P \<parallel> Q');
                      (\<Psi> \<otimes> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
             A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* C;
             A\<^sub>P \<sharp>* Q'; bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* \<Psi>\<^sub>P; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* Q; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* C; distinct(bn \<alpha>)\<rbrakk> \<Longrightarrow> Prop"
and   rComm1: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q.
                   \<lbrakk>cP = P \<parallel> Q; cRs = \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>P' \<parallel> Q';
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N;
                    A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* Q;
                    xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C; distinct xvec\<rbrakk> \<Longrightarrow> Prop"
and   rComm2: "\<And>\<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q.
                   \<lbrakk>cP = P \<parallel> Q; cRs = \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>P' \<parallel> Q';
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N;
                    A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* Q;
                    xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C; distinct xvec\<rbrakk> \<Longrightarrow> Prop"
and   rBrMerge: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q.
                    \<lbrakk>cP = (P \<parallel> Q); cRs = \<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q');
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* A\<^sub>Q;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* M; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow> Prop"
and   rBrComm1: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q.
                   \<lbrakk>cP = P \<parallel> Q; cRs = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q');
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;
                    A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* M;
                    A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C; distinct xvec\<rbrakk> \<Longrightarrow> Prop"
and   rBrComm2: "\<And>\<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q.
                   \<lbrakk>cP = P \<parallel> Q; cRs = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q');
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;
                    A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* M;
                    A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C; distinct xvec\<rbrakk> \<Longrightarrow> Prop"
and   rBrClose: "\<And>P M xvec N P' x.
                   \<lbrakk>cP = (\<lparr>\<nu>x\<rparr>P); cRs = \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P');
                    x \<in> supp M;
                    \<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                    distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P;
                    xvec \<sharp>* M;
                    x \<sharp> \<Psi>; x \<sharp> xvec;
                    xvec \<sharp>* C; x \<sharp> C\<rbrakk> \<Longrightarrow> Prop"
and  rOpen: "\<And>P M xvec yvec N P' x.
                \<lbrakk>cP = \<lparr>\<nu>x\<rparr>P; cRs = M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P';
                 \<Psi> \<rhd> P \<longmapsto> M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; x \<sharp> xvec; x \<sharp> yvec; x \<sharp> M; x \<sharp> \<Psi>; distinct xvec; distinct yvec;
                 xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* yvec; yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; xvec \<sharp>* C; x \<sharp> C; yvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                 Prop"
and  rBrOpen: "\<And>P M xvec yvec N P' x.
                \<lbrakk>cP = \<lparr>\<nu>x\<rparr>P; cRs = \<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P';
                 \<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; x \<in> supp N; x \<sharp> xvec; x \<sharp> yvec; x \<sharp> M; x \<sharp> \<Psi>; distinct xvec; distinct yvec;
                 xvec \<sharp>* \<Psi>; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* yvec; yvec \<sharp>* \<Psi>; yvec \<sharp>* P; yvec \<sharp>* M; xvec \<sharp>* C; x \<sharp> C; yvec \<sharp>* C\<rbrakk> \<Longrightarrow>
                 Prop"
and  rScope: "\<And>P \<alpha> P' x. \<lbrakk>cP = \<lparr>\<nu>x\<rparr>P; cRs = \<alpha> \<prec> \<lparr>\<nu>x\<rparr>P';
                                 \<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'; x \<sharp> \<Psi>; x \<sharp> \<alpha>; x \<sharp> C; bn \<alpha> \<sharp>* \<Psi>; bn \<alpha> \<sharp>* P; bn \<alpha> \<sharp>* subject \<alpha>; bn \<alpha> \<sharp>* C; distinct(bn \<alpha>)\<rbrakk> \<Longrightarrow> Prop"
and  rBang:  "\<And>P. \<lbrakk>cP = !P; \<Psi> \<rhd> P \<parallel> !P \<longmapsto> cRs; guarded P\<rbrakk> \<Longrightarrow> Prop"
shows Prop
  using \<open>\<Psi> \<rhd> cP \<longmapsto> cRs\<close>
proof(cases rule: semantics.cases)
  case(cInput M K xvec N Tvec P)
  obtain p::"name prm" where "(p \<bullet> xvec) \<sharp>* \<Psi>" and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* K"
    and "(p \<bullet> xvec) \<sharp>* Tvec" and "(p \<bullet> xvec) \<sharp>* P" and "(p \<bullet> xvec) \<sharp>* C"
    and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))" and "distinctPerm p"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, M, K, N, P, C, Tvec)"])
      (auto simp add: eqvts fresh_star_prod)
  from \<open>cP = M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> S
  have "cP = M\<lparr>\<lambda>*(p \<bullet> xvec) (p \<bullet> N)\<rparr>.(p \<bullet> P)"
    by(simp add: inputChainAlpha')
  moreover from \<open>cRs = K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec]\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> S \<open>length xvec = length Tvec\<close> \<open>distinctPerm p\<close>
  have "cRs = K\<lparr>((p \<bullet> N)[(p \<bullet> xvec)::=Tvec])\<rparr> \<prec> (p \<bullet> P)[(p \<bullet> xvec)::=Tvec]"
    by(auto simp add: substTerm.renaming renaming residualInject)

  moreover note \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(p \<bullet> xvec)"
    by simp
  moreover from \<open>(set xvec) \<subseteq> (supp N)\<close> have "(p \<bullet> (set xvec)) \<subseteq> (p \<bullet> (supp N))"
    by simp
  then have "set(p \<bullet> xvec) \<subseteq> supp(p \<bullet> N)"
    by(simp add: eqvts)
  moreover from \<open>length xvec = length Tvec\<close> have "length(p \<bullet> xvec) = length Tvec"
    by simp
  ultimately show ?thesis using \<open>(p \<bullet> xvec) \<sharp>* Tvec\<close> \<open>(p \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>(p \<bullet> xvec) \<sharp>* K\<close>
      \<open>(p \<bullet> xvec) \<sharp>* C\<close>
    by(rule rInput)
next
  case(cBrInput K M xvec N Tvec P)
  obtain p::"name prm" where "(p \<bullet> xvec) \<sharp>* \<Psi>" and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* K"
    and "(p \<bullet> xvec) \<sharp>* Tvec" and "(p \<bullet> xvec) \<sharp>* P" and "(p \<bullet> xvec) \<sharp>* C"
    and S: "(set p) \<subseteq> (set xvec) \<times> (set(p \<bullet> xvec))" and "distinctPerm p"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, M, K, N, P, C, Tvec)"])
      (auto simp add: eqvts fresh_star_prod)
  from \<open>cP = M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> S
  have "cP = M\<lparr>\<lambda>*(p \<bullet> xvec) (p \<bullet> N)\<rparr>.(p \<bullet> P)"
    by(simp add: inputChainAlpha')
  moreover from \<open>cRs = \<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec]\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> S \<open>length xvec = length Tvec\<close> \<open>distinctPerm p\<close>
  have "cRs = \<questiondown>K\<lparr>((p \<bullet> N)[(p \<bullet> xvec)::=Tvec])\<rparr> \<prec> (p \<bullet> P)[(p \<bullet> xvec)::=Tvec]"
    by(auto simp add: substTerm.renaming renaming residualInject)

  moreover note \<open>\<Psi> \<turnstile> K \<succeq> M\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(p \<bullet> xvec)"
    by simp
  moreover from \<open>(set xvec) \<subseteq> (supp N)\<close> have "(p \<bullet> (set xvec)) \<subseteq> (p \<bullet> (supp N))"
    by simp
  then have "set(p \<bullet> xvec) \<subseteq> supp(p \<bullet> N)"
    by(simp add: eqvts)
  moreover from \<open>length xvec = length Tvec\<close> have "length(p \<bullet> xvec) = length Tvec"
    by simp
  ultimately show ?thesis using \<open>(p \<bullet> xvec) \<sharp>* Tvec\<close> \<open>(p \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>(p \<bullet> xvec) \<sharp>* K\<close>
      \<open>(p \<bullet> xvec) \<sharp>* C\<close>
    by(simp add: rBrInput)
next
  case(Output M K N P)
  then show ?thesis by(rule rOutput)
next
  case(BrOutput M K N P)
  then show ?thesis by(rule rBrOutput)
next
  case(Case P \<phi> Cs)
  then show ?thesis by(rule rCase)
next
  case(cPar1 \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q)
  obtain q::"name prm" where "(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>" and "(bn(q \<bullet> \<alpha>)) \<sharp>* P" and "(bn(q \<bullet> \<alpha>)) \<sharp>* Q"
    and "(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>" and "(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>Q" and "(bn(q \<bullet> \<alpha>)) \<sharp>* P'" and "(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<^sub>Q"
    and "distinctPerm q"
    and "(bn(q \<bullet> \<alpha>)) \<sharp>* C" and Sq: "(set q) \<subseteq> set(bn \<alpha>) \<times> (set(bn(q \<bullet> \<alpha>)))"
    by(rule name_list_avoiding[where xvec="bn \<alpha>" and c="(\<Psi>, P, Q, \<alpha>, A\<^sub>Q, \<Psi>\<^sub>Q, P', C)"]) (auto simp add: eqvts)
  obtain p::"name prm" where "(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>Q) \<sharp>* P" and "(p \<bullet> A\<^sub>Q) \<sharp>* Q"
    and "(p \<bullet> A\<^sub>Q) \<sharp>* \<alpha>" and "(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)" and "(p \<bullet> A\<^sub>Q) \<sharp>* P'"
    and "(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> P')" and "(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>Q) \<sharp>* C"
    and Sp: "(set p) \<subseteq> (set A\<^sub>Q) \<times> (set(p \<bullet> A\<^sub>Q))" and "distinctPerm p"
    by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, \<alpha>, q \<bullet> \<alpha>, P', (q \<bullet> P'), \<Psi>\<^sub>Q, C)"]) auto
  from \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* A\<^sub>Q\<close> Sq \<open>distinctPerm q\<close> have "A\<^sub>Q \<sharp>* (q \<bullet> \<alpha>)"
    by(subst fresh_star_bij[symmetric, of _ _  q]) (simp add: eqvts)
  from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinctPerm q\<close> have "bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)"
    by(subst fresh_star_bij[symmetric, of _ _  q]) (simp add: eqvts)
  from \<open>distinct(bn \<alpha>)\<close> \<open>distinctPerm q\<close> have "distinct(bn(q \<bullet> \<alpha>))"
    by(subst distinctClosed[symmetric, of _ q]) (simp add: eqvts)
  note \<open>cP = P \<parallel> Q\<close>

  moreover from \<open>cRs = \<alpha> \<prec> (P' \<parallel> Q)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P'\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* Q\<close> Sq
  have "cRs = (q \<bullet> \<alpha>) \<prec> (q \<bullet> P') \<parallel> Q"
    by(force simp add: residualAlpha)
  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P'\<close> Sq
  have Trans: "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> P')"
    by(force simp add: residualAlpha)
  then have "A\<^sub>Q \<sharp>* (q \<bullet> P')" using \<open>bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* (q \<bullet> \<alpha>)\<close>
    by(force dest: freeFreshChainDerivative)

  from Trans have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> (p \<bullet> P) \<longmapsto>p \<bullet> ((q \<bullet> \<alpha>) \<prec> (q \<bullet> P'))"
    by(rule semantics.eqvt)
  with \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* (q \<bullet> \<alpha>)\<close> \<open>A\<^sub>Q \<sharp>* (q \<bullet> P')\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>Q\<close>  \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)\<close>
    \<open>(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* P\<close>  \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> P')\<close> Sp
  have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> P')" by(simp add: eqvts)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close> Sp have  "extractFrame Q = \<langle>(p \<bullet> A\<^sub>Q), (p \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: frameChainAlpha' eqvts)
  moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<^sub>Q\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)\<close> Sp have "(bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshAlphaPerm)
  moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(p \<bullet> A\<^sub>Q)" by simp
  ultimately show ?thesis
    using \<open>(p \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> \<alpha>)\<close>
      \<open>(p \<bullet> A\<^sub>Q) \<sharp>* (q \<bullet> P')\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P\<close>
      \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* C\<close> \<open>(p \<bullet> A\<^sub>Q) \<sharp>* C\<close> \<open>bn (q \<bullet> \<alpha>) \<sharp>* subject (q \<bullet> \<alpha>)\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close>
    by(metis rPar1)
next
  case(cPar2 \<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P)
  obtain q::"name prm" where "(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>" and "(bn(q \<bullet> \<alpha>)) \<sharp>* P" and "(bn(q \<bullet> \<alpha>)) \<sharp>* Q"
    and "(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>" and "(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>P" and "(bn(q \<bullet> \<alpha>)) \<sharp>* Q'" and "(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<^sub>P"
    and "distinctPerm q"
    and "(bn(q \<bullet> \<alpha>)) \<sharp>* C" and Sq: "(set q) \<subseteq> set(bn \<alpha>) \<times> (set(bn(q \<bullet> \<alpha>)))"
    by (rule name_list_avoiding[where xvec="bn \<alpha>" and c="(\<Psi>, P, Q, \<alpha>, A\<^sub>P, \<Psi>\<^sub>P, Q', C)"]) (auto simp add: eqvts)
  obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q"
    and "(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>" and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'"
    and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> Q')" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* C"
    and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))" and "distinctPerm p"
    by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, \<alpha>, q \<bullet> \<alpha>, Q', (q \<bullet> Q'), \<Psi>\<^sub>P, C)"]) auto
  from \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>bn(q \<bullet> \<alpha>) \<sharp>* A\<^sub>P\<close> Sq \<open>distinctPerm q\<close> have "A\<^sub>P \<sharp>* (q \<bullet> \<alpha>)"
    by(subst fresh_star_bij[symmetric, of _ _  q]) (simp add: eqvts)
  from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinctPerm q\<close> have "bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)"
    by(subst fresh_star_bij[symmetric, of _ _  q]) (simp add: eqvts)
  from \<open>distinct(bn \<alpha>)\<close> \<open>distinctPerm q\<close> have "distinct(bn(q \<bullet> \<alpha>))"
    by(subst distinctClosed[symmetric, of _ q]) (simp add: eqvts)
  note \<open>cP = P \<parallel> Q\<close>

  moreover from \<open>cRs = \<alpha> \<prec> (P \<parallel> Q')\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q'\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* P\<close> Sq
  have "cRs = (q \<bullet> \<alpha>) \<prec> P \<parallel>  (q \<bullet> Q')"
    by(force simp add: residualAlpha)
  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q'\<close> Sq
  have Trans: "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> Q')"
    by(force simp add: residualAlpha)
  then have "A\<^sub>P \<sharp>* (q \<bullet> Q')" using \<open>bn(q \<bullet> \<alpha>) \<sharp>* subject(q \<bullet> \<alpha>)\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* (q \<bullet> \<alpha>)\<close>
    by(auto dest: freeFreshChainDerivative)

  from Trans have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> (p \<bullet> Q) \<longmapsto>p \<bullet> ((q \<bullet> \<alpha>) \<prec> (q \<bullet> Q'))"
    by(rule semantics.eqvt)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* (q \<bullet> \<alpha>)\<close> \<open>A\<^sub>P \<sharp>* (q \<bullet> Q')\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>P\<close>  \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)\<close>
    \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>  \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> Q')\<close> Sp
  have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>(q \<bullet> \<alpha>) \<prec> (q \<bullet> Q')" by(simp add: eqvts)
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close> Sp have  "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: frameChainAlpha' eqvts)
  moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)\<close> Sp have "(bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshAlphaPerm)
  moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)" by simp
  ultimately show ?thesis
    using \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<alpha>)\<close>
      \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> Q')\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<Psi>\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* Q\<close> \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P\<close>
      \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* C\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> \<open>bn (q \<bullet> \<alpha>) \<sharp>* subject (q \<bullet> \<alpha>)\<close> \<open>distinct(bn(q \<bullet> \<alpha>))\<close>
    by(metis rPar2)
next
  case(cComm1 \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q)
  obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
    and "(r \<bullet> xvec) \<sharp>* K" and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* C" and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, K, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q', C)"])
      (auto simp add: eqvts)

  obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* K"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* N" and "(q \<bullet> A\<^sub>Q) \<sharp>* xvec" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q'" and "(q \<bullet> A\<^sub>Q) \<sharp>* P'"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and  "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* C" and Sq: "(set q) \<subseteq> (set A\<^sub>Q) \<times> (set(q \<bullet> A\<^sub>Q))"
    by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, K, N, xvec, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, Q', P', C)"]) clarsimp

  obtain p::"name prm"  where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
    and "(p \<bullet> A\<^sub>P) \<sharp>* N" and "(p \<bullet> A\<^sub>P) \<sharp>* xvec" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
    and "(p \<bullet> A\<^sub>P) \<sharp>* P'" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)"
    and "(p \<bullet> A\<^sub>P) \<sharp>* C" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
    by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, N, xvec, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, Q', P', C)"])
      (auto simp add: eqvts fresh_star_prod)

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
  have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

  from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by(auto dest: extractFrameFreshChain)
  from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by(auto dest: extractFrameFreshChain)
  note \<open>cP = P \<parallel> Q\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> have "(r \<bullet> xvec) \<sharp>* (P' \<parallel> Q')"
    by simp
  with \<open>cRs = \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')\<close> \<open>(r \<bullet> xvec) \<sharp>* N\<close> Sr
  have "cRs = \<tau> \<prec> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> (P' \<parallel> Q'))" by(simp add: resChainAlpha residualInject)
  then have "cRs = \<tau> \<prec> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>((r \<bullet> P') \<parallel> (r \<bullet> Q'))" by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> Sr \<open>distinctPerm r\<close> \<open>xvec \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')"
    by(rule inputAlpha)
  then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
    by - (rule inputPermFrameSubject, (assumption | simp)+)
  then have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
  have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')"
    by(simp add: boundOutputChainAlpha'' residualInject)
  then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* K\<close>\<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close>
    by(fastforce intro: outputPermFrameSubject)
  then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
  have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(p \<bullet> q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)) \<turnstile> (p \<bullet> q \<bullet> M) \<leftrightarrow> (p \<bullet> q \<bullet> K)"
    by(metis chanEqClosed)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
    \<open>A\<^sub>Q \<sharp>* K\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close>  Sp Sq
  have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<turnstile> (q \<bullet> M) \<leftrightarrow> (p \<bullet> K)"
    by(simp add: eqvts freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> M)"
    by(simp add: freshChainSimps)
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* N\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> K)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* N\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> M)"
    by(simp add: freshChainSimps)
  moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* K\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> K)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* C\<close> \<open>(r \<bullet> xvec) \<sharp>* C\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(r \<bullet> xvec)" by simp
  ultimately show ?thesis by(rule rComm1)
next
  case(cComm2 \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q)
  obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
    and "(r \<bullet> xvec) \<sharp>* K" and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* C" and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, K, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q', C)"])
      (auto simp add: eqvts)

  obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* K"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* N" and "(q \<bullet> A\<^sub>Q) \<sharp>* xvec" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q'" and "(q \<bullet> A\<^sub>Q) \<sharp>* P'"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and  "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* C" and Sq: "(set q) \<subseteq> (set A\<^sub>Q) \<times> (set(q \<bullet> A\<^sub>Q))"
    by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, K, N, xvec, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, Q', P', C)"]) clarsimp

  obtain p::"name prm"  where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
    and "(p \<bullet> A\<^sub>P) \<sharp>* N" and "(p \<bullet> A\<^sub>P) \<sharp>* xvec" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
    and "(p \<bullet> A\<^sub>P) \<sharp>* P'" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)"
    and "(p \<bullet> A\<^sub>P) \<sharp>* C" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
    by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, N, xvec, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, Q', P', C)"])
      (auto simp add: eqvts fresh_star_prod)

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
  have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

  from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by(auto dest: extractFrameFreshChain)
  from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by(auto dest: extractFrameFreshChain)

  note \<open>cP = P \<parallel> Q\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> have "(r \<bullet> xvec) \<sharp>* (P' \<parallel> Q')"
    by simp
  with \<open>cRs = \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q')\<close> \<open>(r \<bullet> xvec) \<sharp>* N\<close> Sr
  have "cRs = \<tau> \<prec> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> (P' \<parallel> Q'))" by(simp add: resChainAlpha residualInject)
  then have "cRs = \<tau> \<prec> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>((r \<bullet> P') \<parallel> (r \<bullet> Q'))"
    by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" by(simp add: boundOutputChainAlpha'' residualInject)
  then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close>
    by(fastforce intro: outputPermFrameSubject)
  then have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
  have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'\<close> Sr  \<open>distinctPerm r\<close> \<open>xvec \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" by(rule inputAlpha)
  then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
    by - (rule inputPermFrameSubject, (assumption | simp)+)
  then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>(p \<bullet> K)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
  have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(p \<bullet> q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q)) \<turnstile> (p \<bullet> q \<bullet> M) \<leftrightarrow> (p \<bullet> q \<bullet> K)"
    by(metis chanEqClosed)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close>
    \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close>
    \<open>A\<^sub>Q \<sharp>* K\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close>  Sp Sq
  have "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<turnstile> (q \<bullet> M) \<leftrightarrow> (p \<bullet> K)"
    by(simp add: eqvts freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> M)"
    by(simp add: freshChainSimps)
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* N\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> K)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* N\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> M)"
    by(simp add: freshChainSimps)
  moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* K\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> K)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* C\<close> \<open>(r \<bullet> xvec) \<sharp>* C\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(r \<bullet> xvec)" by simp
  ultimately show ?thesis by(rule rComm2)
next
  case(cBrMerge \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q)
  obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* M"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* N" and "(q \<bullet> A\<^sub>Q) \<sharp>* P'" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q'"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* C"
    and Sq: "set q \<subseteq> set A\<^sub>Q \<times> set(q \<bullet> A\<^sub>Q)"
    by(rule name_list_avoiding[where c="(\<Psi>, P, N, M, P', Q', Q, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, C)"])
      (auto simp add: eqvts fresh_star_prod emptyFresh)
  obtain p::"name prm" where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P"
    and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
    and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
    and "(p \<bullet> A\<^sub>P) \<sharp>* N" and "(p \<bullet> A\<^sub>P) \<sharp>* P'" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'"
    and "(p \<bullet> A\<^sub>P) \<sharp>* C"
    and Sp: "set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P)"
    and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)"
    by(rule name_list_avoiding[where c="(\<Psi>, P, N, P', Q', Q, M, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, C)"])
      (auto simp add: eqvts fresh_star_prod)

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
  have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

  from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by(auto dest: extractFrameFreshChain)
  from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by(auto dest: extractFrameFreshChain)

  from Sp \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
  have "(p \<bullet> M) = M"
    by simp
  from Sq \<open>A\<^sub>Q \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
  have "(q \<bullet> M) = M"
    by simp

  note \<open>cP = P \<parallel> Q\<close> \<open>cRs = \<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q')\<close>
  moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)" by simp
  moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp
  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
  have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
  have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: frameChainAlpha)

  moreover have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>N\<rparr> \<prec> P'" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close>
    by - (rule brinputPermFrameSubject, (assumption | simp)+)
  then have "(\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>N\<rparr> \<prec> P'" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
    by(simp add: eqvts)
  with \<open>(q \<bullet> M) = M\<close> have PTrans: "(\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'"
    by simp

  moreover have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> Q'" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close>
    by - (rule brinputPermFrameSubject, (assumption | simp)+)
  then have "(\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>N\<rparr> \<prec> Q'" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
    by(simp add: eqvts)
  with \<open>(p \<bullet> M) = M\<close> have PTrans: "(\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
    by simp
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)

  moreover note
    \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
    \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* N\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
    \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
    \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* N\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P'\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
    \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* C\<close>
  ultimately show ?thesis
    by(auto simp add: rBrMerge)
next
  case(cBrComm1 \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q)
  obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
    and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* C" and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q', C)"])
      (auto simp add: eqvts)

  obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* M"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* N" and "(q \<bullet> A\<^sub>Q) \<sharp>* xvec" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q'" and "(q \<bullet> A\<^sub>Q) \<sharp>* P'"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and  "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* C" and Sq: "(set q) \<subseteq> (set A\<^sub>Q) \<times> (set(q \<bullet> A\<^sub>Q))"
    by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, M, N, xvec, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, Q', P', C)"]) clarsimp

  obtain p::"name prm"  where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
    and "(p \<bullet> A\<^sub>P) \<sharp>* N" and "(p \<bullet> A\<^sub>P) \<sharp>* xvec" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
    and "(p \<bullet> A\<^sub>P) \<sharp>* P'" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)"
    and "(p \<bullet> A\<^sub>P) \<sharp>* C" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
    by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, N, xvec, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, Q', P', C)"])
      (auto simp add: eqvts fresh_star_prod)

  from Sp \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
  have "(p \<bullet> M) = M"
    by simp
  from Sq \<open>A\<^sub>Q \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
  have "(q \<bullet> M) = M"
    by simp
  from Sr \<open>xvec \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
  have "(r \<bullet> M) = M"
    by simp

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
  have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

  from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by(auto dest: extractFrameFreshChain)
  from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by(auto dest: extractFrameFreshChain)

  note \<open>cP = P \<parallel> Q\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> have "(r \<bullet> xvec) \<sharp>* (P' \<parallel> Q')"
    by simp
  with \<open>cRs = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')\<close> \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> \<open>xvec \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> Sr
  have "cRs = (r \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) \<prec> (r \<bullet> (P' \<parallel> Q'))"
    by (simp add: residualAlpha)
  with \<open>(r \<bullet> M) = M\<close> have "cRs = \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> ((r \<bullet> P') \<parallel> (r \<bullet> Q'))" by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> Sr \<open>distinctPerm r\<close> \<open>xvec \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')"
    by(rule brinputAlpha)
  then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<questiondown>(q \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
    by - (rule brinputPermFrameSubject, (assumption | simp)+)
  then have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> M) = M\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
  have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')"
    by(simp add: boundOutputChainAlpha'' residualInject)
  then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<exclamdown>(p \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close>
    by(fastforce intro: broutputPermFrameSubject)
  then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> M) = M\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
  have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* N\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* N\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
  moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* C\<close> \<open>(r \<bullet> xvec) \<sharp>* C\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(r \<bullet> xvec)" by simp
  ultimately show ?thesis by(simp add: rBrComm1)
next
  case(cBrComm2 \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q)
  obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* Q" and "(r \<bullet> xvec) \<sharp>* M"
    and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* A\<^sub>P" and "(r \<bullet> xvec) \<sharp>* A\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* Q'" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P" and "(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q"
    and "(r \<bullet> xvec) \<sharp>* C" and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, Q, M, N, A\<^sub>P, A\<^sub>Q, \<Psi>\<^sub>P, \<Psi>\<^sub>Q, P', Q', C)"])
      (auto simp add: eqvts)

  obtain q::"name prm" where "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>" and "(q \<bullet> A\<^sub>Q) \<sharp>* P" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* M"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* N" and "(q \<bullet> A\<^sub>Q) \<sharp>* xvec" and "(q \<bullet> A\<^sub>Q) \<sharp>* Q'" and "(q \<bullet> A\<^sub>Q) \<sharp>* P'"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P" and  "(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P" and "(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q" and "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)"
    and "(q \<bullet> A\<^sub>Q) \<sharp>* C" and Sq: "(set q) \<subseteq> (set A\<^sub>Q) \<times> (set(q \<bullet> A\<^sub>Q))"
    by(rule name_list_avoiding[where xvec=A\<^sub>Q and c="(\<Psi>, P, Q, N, M, xvec, r \<bullet> xvec, \<Psi>\<^sub>Q, A\<^sub>P, \<Psi>\<^sub>P, Q', P', C)"]) clarsimp

  obtain p::"name prm"  where "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>" and "(p \<bullet> A\<^sub>P) \<sharp>* P" and "(p \<bullet> A\<^sub>P) \<sharp>* Q" and "(p \<bullet> A\<^sub>P) \<sharp>* M"
    and "(p \<bullet> A\<^sub>P) \<sharp>* N" and "(p \<bullet> A\<^sub>P) \<sharp>* xvec" and "(p \<bullet> A\<^sub>P) \<sharp>* Q'" and "(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q"
    and "(p \<bullet> A\<^sub>P) \<sharp>* P'" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P" and "(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q" and "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)"
    and "(p \<bullet> A\<^sub>P) \<sharp>* C" and "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)" and Sp: "(set p) \<subseteq> (set A\<^sub>P) \<times> (set(p \<bullet> A\<^sub>P))"
    by(rule name_list_avoiding[where xvec=A\<^sub>P and c="(\<Psi>, P, Q, M, N, xvec, r \<bullet> xvec, A\<^sub>Q, q \<bullet> A\<^sub>Q, \<Psi>\<^sub>Q, \<Psi>\<^sub>P, Q', P', C)"])
      (auto simp add: eqvts fresh_star_prod)

  from Sp \<open>A\<^sub>P \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close>
  have "(p \<bullet> M) = M"
    by simp
  from Sq \<open>A\<^sub>Q \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
  have "(q \<bullet> M) = M"
    by simp
  from Sr \<open>xvec \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
  have "(r \<bullet> M) = M"
    by simp

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" by fact
  have FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>" by fact

  from \<open>A\<^sub>P \<sharp>* Q\<close> FrQ \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
    by(auto dest: extractFrameFreshChain)
  from \<open>A\<^sub>Q \<sharp>* P\<close> FrP \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> have "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
    by(auto dest: extractFrameFreshChain)

  note \<open>cP = P \<parallel> Q\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> have "(r \<bullet> xvec) \<sharp>* (P' \<parallel> Q')"
    by simp
  with \<open>cRs = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q')\<close> \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close> \<open>(r \<bullet> xvec) \<sharp>* Q'\<close> \<open>xvec \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> Sr
  have "cRs = (r \<bullet> (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>)) \<prec> (r \<bullet> (P' \<parallel> Q'))"
    by (simp add: residualAlpha)
  with \<open>(r \<bullet> M) = M\<close> have "cRs = \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> ((r \<bullet> P') \<parallel> (r \<bullet> Q'))" by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> Sr \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" by(simp add: boundOutputChainAlpha'' residualInject)
  then have "(q \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>Q)) \<rhd> P \<longmapsto>\<exclamdown>(q \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* P\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close> \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close>
    by(fastforce intro: broutputPermFrameSubject)
  then have PTrans: "\<Psi> \<otimes> (q \<bullet> \<Psi>\<^sub>Q) \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')" using Sq \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> M) = M\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close>  Sp \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>P\<close>
  have FrP: "extractFrame P = \<langle>(p \<bullet> A\<^sub>P), (p \<bullet> \<Psi>\<^sub>P)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>P\<close> have "distinct(p \<bullet> A\<^sub>P)"  by simp

  moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close> Sr  \<open>distinctPerm r\<close> \<open>xvec \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* Q\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" by(rule brinputAlpha)
  then have "(p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P)) \<rhd> Q \<longmapsto>\<questiondown>(p \<bullet> M)\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
    by - (rule brinputPermFrameSubject, (assumption | simp)+)
  then have QTrans: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>(r \<bullet> N)\<rparr> \<prec> (r \<bullet> Q')" using Sp \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> M) = M\<close>
    by(simp add: eqvts)

  moreover from \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close>  Sq \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>Q\<close>
  have FrQ: "extractFrame Q = \<langle>(q \<bullet> A\<^sub>Q), (q \<bullet> \<Psi>\<^sub>Q)\<rangle>"
    by(simp add: frameChainAlpha)
  moreover from \<open>distinct A\<^sub>Q\<close> have "distinct(q \<bullet> A\<^sub>Q)"  by simp

  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* P\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* N\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note  \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q\<close>
  moreover from \<open>(p \<bullet> A\<^sub>P) \<sharp>* xvec\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* Q'\<close> Sr have "(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* \<Psi>\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (q \<bullet> A\<^sub>Q)\<close> Sp Sq have "(q \<bullet> A\<^sub>Q) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* N\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> N)"
    by(simp add: freshChainSimps)
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* P'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> P')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q\<close>
  moreover from \<open>(q \<bullet> A\<^sub>Q) \<sharp>* xvec\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* Q'\<close> Sr have "(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> Q')"
    by(simp add: freshChainSimps)
  moreover note \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>P\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>P\<close> Sp have "(r \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>\<^sub>P)"
    by(simp add: freshChainSimps)
  moreover from \<open>(r \<bullet> xvec) \<sharp>* A\<^sub>Q\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<^sub>Q\<close> Sq have "(r \<bullet> xvec) \<sharp>* (q \<bullet> \<Psi>\<^sub>Q)"
    by(simp add: freshChainSimps)
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* M\<close>
  moreover note \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  moreover note \<open>(r \<bullet> xvec) \<sharp>* Q\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
  moreover note \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> \<open>(q \<bullet> A\<^sub>Q) \<sharp>* C\<close> \<open>(r \<bullet> xvec) \<sharp>* C\<close>
  moreover from \<open>distinct xvec\<close> have "distinct(r \<bullet> xvec)" by simp
  ultimately show ?thesis by(simp add: rBrComm2)
next
  case(cBrClose P M xvec N P' x)
  obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* M"
    and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* x"
    and "(r \<bullet> xvec) \<sharp>* C" and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, N, P', x, C)"])
      (auto simp add: eqvts)
  obtain y::name where "y \<sharp> P" and "y \<sharp> C" and "y \<sharp> xvec" and "y \<noteq> x" and "y \<sharp> N"
    and "y \<sharp> (r \<bullet> xvec)" and "y \<sharp> r" and "y \<sharp> M" and "y \<sharp> \<Psi>"
    and "y \<sharp> P'" and "y \<sharp> (r \<bullet> P')" and "y \<sharp> (r \<bullet> N)"
    by(generate_fresh "name") (auto simp add: freshChainSimps)
  from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>y \<sharp> P\<close> have cP_perm: "cP = \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> P)" by(simp add: alphaRes)
  from \<open>cRs = \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close> Sr
  have "cRs = \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> P'))" by(simp add: resChainAlpha)
  moreover from \<open>y \<sharp> (r \<bullet> P')\<close> have "y \<sharp> (\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> P'))" by(simp add: resChainFresh)
  ultimately have "cRs = \<tau> \<prec> \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> (\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> P')))" by(simp add: alphaRes)
  with \<open>(r \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (r \<bullet> xvec)\<close>
  have cRs_perm: "cRs = \<tau> \<prec> \<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>([(x, y)] \<bullet> (r \<bullet> P')))" by(simp add: eqvts)

  from \<open>x \<sharp> xvec\<close> \<open>(r \<bullet> xvec) \<sharp>* x\<close> Sr have "r \<bullet> x = x" by simp

  from \<open>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close>
    \<open>set r \<subseteq> set xvec \<times> set (r \<bullet> xvec)\<close>
  have "\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')"
    by(simp add: boundOutputChainAlpha'' create_residual.simps)
  then have "[(x, y)] \<bullet> (\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P'))"
    by(simp add: perm_bool)
  with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> \<open>(r \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (r \<bullet> xvec)\<close>
    \<open>y \<sharp> (r \<bullet> N)\<close>
  have trans_perm: "\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto> \<exclamdown>([(x, y)] \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>([(x, y)] \<bullet> (r \<bullet> N))\<rangle> \<prec> ([(x, y)] \<bullet> (r \<bullet> P'))"
    by(auto simp add: eqvts)

  note cP_perm cRs_perm
  moreover from \<open>x \<in> supp M\<close> have "y \<in> supp ([(x, y)] \<bullet> M)"
    by (metis fresh_bij fresh_def swap_simps)
  moreover note trans_perm
  moreover from \<open>distinct xvec\<close> \<open>distinctPerm r\<close> have "distinct (r \<bullet> xvec)"
    by simp
  moreover note \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close>
  moreover from \<open>(r \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* P\<close>
  have "(r \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> P)" by simp
  moreover from \<open>(r \<bullet> xvec) \<sharp>* x\<close> \<open>y \<sharp> (r \<bullet> xvec)\<close> \<open>(r \<bullet> xvec) \<sharp>* M\<close>
  have "(r \<bullet> xvec) \<sharp>* ([(x, y)] \<bullet> M)" by simp
  moreover note \<open>y \<sharp> \<Psi>\<close> \<open>y \<sharp> (r \<bullet> xvec)\<close>
    \<open>(r \<bullet> xvec) \<sharp>* C\<close> \<open>y \<sharp> C\<close>
  ultimately show ?thesis
    by(rule rBrClose)
next
  case(cOpen P M xvec yvec N P' x)
  from \<open>\<Psi> \<rhd> P \<longmapsto> M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>  have "distinct(xvec@yvec)" by(force dest: boundOutputDistinct)
  then have "xvec \<sharp>* yvec" by(induct xvec) auto
  obtain p where "(p \<bullet> yvec) \<sharp>* \<Psi>" and "(p \<bullet> yvec) \<sharp>* P"  and "(p \<bullet> yvec) \<sharp>* M"
    and "(p \<bullet> yvec) \<sharp>* yvec" and "(p \<bullet> yvec) \<sharp>* N" and "(p \<bullet> yvec) \<sharp>* P'"
    and "x \<sharp> (p \<bullet> yvec)" and "(p \<bullet> yvec) \<sharp>* xvec"
    and "(p \<bullet> yvec) \<sharp>* C" and Sp: "(set p) \<subseteq> (set yvec) \<times> (set(p \<bullet> yvec))"
    by(rule name_list_avoiding[where xvec=yvec and c="(\<Psi>, P, M, xvec, yvec, N, P', x, C)"])
      (auto simp add: eqvts fresh_star_prod)
  obtain q where "(q \<bullet> xvec) \<sharp>* \<Psi>" and "(q \<bullet> xvec) \<sharp>* P"  and "(q \<bullet> xvec) \<sharp>* M"
    and "(q \<bullet> xvec) \<sharp>* xvec" and "(q \<bullet> xvec) \<sharp>* N" and "(q \<bullet> xvec) \<sharp>* P'"
    and "x \<sharp> (q \<bullet> xvec)" and "(q \<bullet> xvec) \<sharp>* yvec"
    and "(q \<bullet> xvec) \<sharp>* p" and "(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)"
    and "(q \<bullet> xvec) \<sharp>* C" and Sq: "(set q) \<subseteq> (set xvec) \<times> (set(q \<bullet> xvec))"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, xvec, yvec, p \<bullet> yvec, N, P', x, p, C)"])
      (auto simp add: eqvts fresh_star_prod)
  obtain y::name where "y \<sharp> P" and "y \<sharp> C" and "y \<sharp> xvec" and "y \<sharp> yvec" and "y \<noteq> x" and "y \<sharp> N"
    and "y \<sharp> (q \<bullet> xvec)" and "y \<sharp> (p \<bullet> yvec)" and "y \<sharp> M" and "y \<sharp> \<Psi>" and "y \<sharp> P'"
    by(generate_fresh "name") (auto simp add: freshChainSimps)
  from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>y \<sharp> P\<close> have "cP = \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> P)" by(simp add: alphaRes)
  moreover have "cRs = M\<lparr>\<nu>*((q \<bullet> xvec)@y#(p \<bullet> yvec))\<rparr>\<langle>((q@(x, y)#p) \<bullet> N)\<rangle> \<prec> ((q@(x, y)#p) \<bullet> P')"
  proof -
    note \<open>cRs = M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
    moreover have "\<lparr>\<nu>*(xvec@x#yvec)\<rparr>N \<prec>' P' = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*yvec\<rparr>N \<prec>' P'))" by(simp add: boundOutputApp)
    moreover from \<open>(p \<bullet> yvec) \<sharp>* N\<close> \<open>(p \<bullet> yvec) \<sharp>* P'\<close> Sp have "\<dots> = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>(p \<bullet> N) \<prec>' (p \<bullet> P')))"
      by(simp add: boundOutputChainAlpha'')
    moreover with \<open>y \<sharp> N\<close> \<open>y \<sharp> P'\<close> \<open>y \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> yvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> Sp
    moreover have "\<dots> = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>(([(x, y)] \<bullet> p \<bullet> N) \<prec>' ([(x, y)] \<bullet> p \<bullet> P'))))"
      by(subst alphaBoundOutput[where y=y]) (simp add: freshChainSimps eqvts)+
    moreover then have "\<dots> = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>((((x, y)#p) \<bullet> N) \<prec>' (((x, y)#p) \<bullet> P'))))"
      by simp
    moreover from \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close>
      \<open>y \<sharp> xvec\<close> \<open>y \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> Sp Sq
    have "\<dots> = \<lparr>\<nu>*(q \<bullet> xvec)\<rparr>(\<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>((q \<bullet> ((x, y)#p) \<bullet> N) \<prec>' (q \<bullet> ((x, y)#p) \<bullet> P'))))"
      apply(subst boundOutputChainAlpha[where p=q and xvec=xvec and yvec="xvec"])
         defer
         apply assumption
        apply simp
       apply(simp add: eqvts)
      apply(simp add: eqvts)
      apply(simp add: boundOutputFreshSet(4))
      apply(rule conjI)
       apply(simp add: freshChainSimps)
      apply(simp add: freshChainSimps)
      done
    moreover then have "\<dots> = \<lparr>\<nu>*(q \<bullet> xvec@y#(p \<bullet> yvec))\<rparr>((q@(x, y)#p) \<bullet> N) \<prec>' ((q@(x, y)#p) \<bullet> P')"
      by(simp only: pt2[OF pt_name_inst] boundOutputApp BOresChain.simps)
    ultimately show ?thesis
      by(simp only: residualInject)
  qed
  moreover have "\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((q@(x, y)#p) \<bullet> N)\<rangle> \<prec> ((q@(x, y)#p) \<bullet> P')"
  proof -
    note\<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
    moreover from \<open>(p \<bullet> yvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
    have "((q@p) \<bullet> (xvec @ yvec)) \<sharp>* N" apply(simp only: eqvts) apply(simp only: pt2[OF pt_name_inst])
      by simp
    moreover from \<open>(p \<bullet> yvec) \<sharp>* P'\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
    have "((q@p) \<bullet> (xvec @ yvec)) \<sharp>* P'" by(simp del: freshAlphaPerm add: eqvts pt2[OF pt_name_inst])
    moreover from Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
    have Spq: "set(q@p) \<subseteq> set(xvec@yvec) \<times> set((q@p) \<bullet> (xvec@yvec))"
      by(simp add: pt2[OF pt_name_inst] eqvts) blast
    ultimately have "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*((q@p) \<bullet> (xvec@yvec))\<rparr>\<langle>((q@p) \<bullet> N)\<rangle> \<prec> ((q@p) \<bullet> P')"
      apply(simp only: residualInject)
      by(erule rev_mp) (subst boundOutputChainAlpha, auto)
    with  Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
    have "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((q@p) \<bullet> N)\<rangle> \<prec> ((q@p) \<bullet> P')"
      by(simp add: eqvts pt2[OF pt_name_inst] del: freshAlphaPerm)
    then have "([(x, y)] \<bullet> \<Psi>) \<rhd> ([(x, y)] \<bullet> P) \<longmapsto> [(x, y)] \<bullet> (M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((q@p) \<bullet> N)\<rangle> \<prec> ((q@p) \<bullet> P'))"
      by(rule semantics.eqvt)
    with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>y \<sharp> xvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>y \<sharp> (q \<bullet> xvec) \<close>\<open>x \<sharp> yvec\<close> \<open>y \<sharp> yvec\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> (p \<bullet> yvec)\<close> Sp Sq
    show ?thesis
      apply(simp add: eqvts pt2[OF pt_name_inst])
      by(subst perm_compose[of q], simp)+
  qed
  moreover from \<open>x \<in> supp N\<close> have "((q@(x, y)#p) \<bullet> x) \<in> ((q@(x, y)#p) \<bullet> (supp N))"
    by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> xvec\<close> \<open>y \<sharp> (q \<bullet> xvec)\<close> Sp Sq
  have "y \<in> supp((q@(x, y)#p)\<bullet> N)" by(simp add: pt2[OF pt_name_inst] calc_atm eqvts)
  moreover from \<open>distinct xvec\<close> have "distinct(q \<bullet> xvec)" by simp
  moreover from \<open>distinct yvec\<close> have "distinct(p \<bullet> yvec)" by simp
  moreover note \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> \<Psi>\<close>
    \<open>(q \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> xvec) \<sharp>* P\<close> \<open>(q \<bullet> xvec) \<sharp>* M\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close>
    \<open>(p \<bullet> yvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> yvec) \<sharp>* P\<close> \<open>(p \<bullet> yvec) \<sharp>* M\<close> \<open>y \<sharp> (q \<bullet> xvec)\<close> \<open>y \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> M\<close> \<open>y \<sharp> C\<close> \<open>y \<sharp> \<Psi>\<close>
    \<open>(p \<bullet> yvec) \<sharp>* C\<close> \<open>(q \<bullet> xvec) \<sharp>* C\<close>
  ultimately show Prop by - (rule rOpen, (assumption | simp)+)
next
  case(cBrOpen P M xvec yvec N P' x)
  from \<open>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>  have "distinct(xvec@yvec)" by(force dest: boundOutputDistinct)
  then have "xvec \<sharp>* yvec" by(induct xvec) auto
  obtain p where "(p \<bullet> yvec) \<sharp>* \<Psi>" and "(p \<bullet> yvec) \<sharp>* P"  and "(p \<bullet> yvec) \<sharp>* M"
    and "(p \<bullet> yvec) \<sharp>* yvec" and "(p \<bullet> yvec) \<sharp>* N" and "(p \<bullet> yvec) \<sharp>* P'"
    and "x \<sharp> (p \<bullet> yvec)" and "(p \<bullet> yvec) \<sharp>* xvec"
    and "(p \<bullet> yvec) \<sharp>* C" and Sp: "(set p) \<subseteq> (set yvec) \<times> (set(p \<bullet> yvec))"
    by(rule name_list_avoiding[where xvec=yvec and c="(\<Psi>, P, M, xvec, yvec, N, P', x, C)"])
      (auto simp add: eqvts fresh_star_prod)
  obtain q where "(q \<bullet> xvec) \<sharp>* \<Psi>" and "(q \<bullet> xvec) \<sharp>* P"  and "(q \<bullet> xvec) \<sharp>* M"
    and "(q \<bullet> xvec) \<sharp>* xvec" and "(q \<bullet> xvec) \<sharp>* N" and "(q \<bullet> xvec) \<sharp>* P'"
    and "x \<sharp> (q \<bullet> xvec)" and "(q \<bullet> xvec) \<sharp>* yvec"
    and "(q \<bullet> xvec) \<sharp>* p" and "(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)"
    and "(q \<bullet> xvec) \<sharp>* C" and Sq: "(set q) \<subseteq> (set xvec) \<times> (set(q \<bullet> xvec))"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, xvec, yvec, p \<bullet> yvec, N, P', x, p, C)"])
      (auto simp add: eqvts fresh_star_prod)
  obtain y::name where "y \<sharp> P" and "y \<sharp> C" and "y \<sharp> xvec" and "y \<sharp> yvec" and "y \<noteq> x" and "y \<sharp> N"
    and "y \<sharp> (q \<bullet> xvec)" and "y \<sharp> (p \<bullet> yvec)" and "y \<sharp> M" and "y \<sharp> \<Psi>" and "y \<sharp> P'"
    by(generate_fresh "name") (auto simp add: freshChainSimps)
  from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>y \<sharp> P\<close> have "cP = \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> P)" by(simp add: alphaRes)
  moreover have "cRs = \<exclamdown>M\<lparr>\<nu>*((q \<bullet> xvec)@y#(p \<bullet> yvec))\<rparr>\<langle>((q@(x, y)#p) \<bullet> N)\<rangle> \<prec> ((q@(x, y)#p) \<bullet> P')"
  proof -
    note \<open>cRs = \<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
    moreover have "\<lparr>\<nu>*(xvec@x#yvec)\<rparr>N \<prec>' P' = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*yvec\<rparr>N \<prec>' P'))" by(simp add: boundOutputApp)
    moreover from \<open>(p \<bullet> yvec) \<sharp>* N\<close> \<open>(p \<bullet> yvec) \<sharp>* P'\<close> Sp have "\<dots> = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>(p \<bullet> N) \<prec>' (p \<bullet> P')))"
      by(simp add: boundOutputChainAlpha'')
    moreover with \<open>y \<sharp> N\<close> \<open>y \<sharp> P'\<close> \<open>y \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> yvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> Sp
    moreover have "\<dots> = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>(([(x, y)] \<bullet> p \<bullet> N) \<prec>' ([(x, y)] \<bullet> p \<bullet> P'))))"
      by(subst alphaBoundOutput[where y=y]) (simp add: freshChainSimps eqvts)+
    moreover then have "\<dots> = \<lparr>\<nu>*xvec\<rparr>(\<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>((((x, y)#p) \<bullet> N) \<prec>' (((x, y)#p) \<bullet> P'))))"
      by simp
    moreover from \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close>
      \<open>y \<sharp> xvec\<close> \<open>y \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> Sp Sq
    have "\<dots> = \<lparr>\<nu>*(q \<bullet> xvec)\<rparr>(\<lparr>\<nu>y\<rparr>(\<lparr>\<nu>*(p \<bullet> yvec)\<rparr>((q \<bullet> ((x, y)#p) \<bullet> N) \<prec>' (q \<bullet> ((x, y)#p) \<bullet> P'))))"
      apply(subst boundOutputChainAlpha[where p=q and xvec=xvec and yvec="xvec"])
         defer
         apply assumption
        apply simp
       apply(simp add: eqvts)
      apply(simp add: eqvts)
      apply(simp add: boundOutputFreshSet(4))
      apply(rule conjI)
       apply(simp add: freshChainSimps)
      apply(simp add: freshChainSimps)
      done
    moreover then have "\<dots> = \<lparr>\<nu>*(q \<bullet> xvec@y#(p \<bullet> yvec))\<rparr>((q@(x, y)#p) \<bullet> N) \<prec>' ((q@(x, y)#p) \<bullet> P')"
      by(simp only: pt2[OF pt_name_inst] boundOutputApp BOresChain.simps)
    ultimately show ?thesis
      by(simp only: residualInject)
  qed
  moreover have "\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((q@(x, y)#p) \<bullet> N)\<rangle> \<prec> ((q@(x, y)#p) \<bullet> P')"
  proof -
    note\<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close>
    moreover from \<open>(p \<bullet> yvec) \<sharp>* N\<close> \<open>(q \<bullet> xvec) \<sharp>* N\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
    have "((q@p) \<bullet> (xvec @ yvec)) \<sharp>* N" apply(simp only: eqvts) apply(simp only: pt2[OF pt_name_inst])
      by simp
    moreover from \<open>(p \<bullet> yvec) \<sharp>* P'\<close> \<open>(q \<bullet> xvec) \<sharp>* P'\<close> \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close> Sp Sq
    have "((q@p) \<bullet> (xvec @ yvec)) \<sharp>* P'" by(simp del: freshAlphaPerm add: eqvts pt2[OF pt_name_inst])
    moreover from Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
    have Spq: "set(q@p) \<subseteq> set(xvec@yvec) \<times> set((q@p) \<bullet> (xvec@yvec))"
      by(simp add: pt2[OF pt_name_inst] eqvts) blast
    ultimately have "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((q@p) \<bullet> (xvec@yvec))\<rparr>\<langle>((q@p) \<bullet> N)\<rangle> \<prec> ((q@p) \<bullet> P')"
      apply(simp only: residualInject)
      by(erule rev_mp) (subst boundOutputChainAlpha, auto)
    with  Sp Sq \<open>xvec \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* yvec\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close> \<open>(p \<bullet> yvec) \<sharp>* xvec\<close>
    have "\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((q@p) \<bullet> N)\<rangle> \<prec> ((q@p) \<bullet> P')"
      by(simp add: eqvts pt2[OF pt_name_inst] del: freshAlphaPerm)
    then have "([(x, y)] \<bullet> \<Psi>) \<rhd> ([(x, y)] \<bullet> P) \<longmapsto> [(x, y)] \<bullet> (\<exclamdown>M\<lparr>\<nu>*((q \<bullet> xvec)@(p \<bullet> yvec))\<rparr>\<langle>((q@p) \<bullet> N)\<rangle> \<prec> ((q@p) \<bullet> P'))"
      by(rule semantics.eqvt)
    with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> \<open>x \<sharp> M\<close> \<open>y \<sharp> M\<close> \<open>x \<sharp> xvec\<close> \<open>y \<sharp> xvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>y \<sharp> (q \<bullet> xvec) \<close>\<open>x \<sharp> yvec\<close> \<open>y \<sharp> yvec\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> (p \<bullet> yvec)\<close> Sp Sq
    show ?thesis
      apply(simp add: eqvts pt2[OF pt_name_inst])
      by(subst perm_compose[of q], simp)+
  qed
  moreover from \<open>x \<in> supp N\<close> have "((q@(x, y)#p) \<bullet> x) \<in> ((q@(x, y)#p) \<bullet> (supp N))"
    by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
  with \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> xvec\<close> \<open>y \<sharp> (q \<bullet> xvec)\<close> Sp Sq
  have "y \<in> supp((q@(x, y)#p)\<bullet> N)" by(simp add: pt2[OF pt_name_inst] calc_atm eqvts)
  moreover from \<open>distinct xvec\<close> have "distinct(q \<bullet> xvec)" by simp
  moreover from \<open>distinct yvec\<close> have "distinct(p \<bullet> yvec)" by simp
  moreover note \<open>x \<sharp> (q \<bullet> xvec)\<close> \<open>x \<sharp> (p \<bullet> yvec)\<close> \<open>x \<sharp> M\<close> \<open>x \<sharp> \<Psi>\<close>
    \<open>(q \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(q \<bullet> xvec) \<sharp>* P\<close> \<open>(q \<bullet> xvec) \<sharp>* M\<close> \<open>(q \<bullet> xvec) \<sharp>* (p \<bullet> yvec)\<close>
    \<open>(p \<bullet> yvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> yvec) \<sharp>* P\<close> \<open>(p \<bullet> yvec) \<sharp>* M\<close> \<open>y \<sharp> (q \<bullet> xvec)\<close> \<open>y \<sharp> (p \<bullet> yvec)\<close> \<open>y \<sharp> M\<close> \<open>y \<sharp> C\<close> \<open>y \<sharp> \<Psi>\<close>
    \<open>(p \<bullet> yvec) \<sharp>* C\<close> \<open>(q \<bullet> xvec) \<sharp>* C\<close>
  ultimately show Prop by - (rule rBrOpen, (assumption | simp)+)
next
  case(cScope P \<alpha> P' x)
  obtain p::"name prm" where "(bn(p \<bullet> \<alpha>)) \<sharp>* \<Psi>" and "(bn(p \<bullet> \<alpha>)) \<sharp>* P"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>" and "(bn(p \<bullet> \<alpha>)) \<sharp>* P'" and "x \<sharp> bn(p \<bullet> \<alpha>)"
    and "distinctPerm p"
    and "(bn(p \<bullet> \<alpha>)) \<sharp>* C" and Sp: "(set p) \<subseteq> set(bn \<alpha>) \<times> (set(bn(p \<bullet> \<alpha>)))"
    by(rule name_list_avoiding[where xvec="bn \<alpha>" and c="(\<Psi>, P, \<alpha>, x, P', C)"]) (auto simp add: eqvts)
  obtain y::name where "y \<sharp> \<Psi>" and "y \<sharp> P" and "y \<sharp> (p \<bullet> P')" and "y \<sharp> (p \<bullet> \<alpha>)" and "y \<sharp> C"
    by(generate_fresh "name") (auto simp add: freshChainSimps simp del: actionFresh)
  from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>distinctPerm p\<close> have "bn(p \<bullet> \<alpha>) \<sharp>* subject(p \<bullet> \<alpha>)"
    by(subst fresh_star_bij[symmetric, of _ _  p]) (simp add: eqvts)
  from \<open>distinct(bn \<alpha>)\<close> \<open>distinctPerm p\<close> have "distinct(bn(p \<bullet> \<alpha>))"
    by(subst distinctClosed[symmetric, of _ p]) (simp add: eqvts)
  from \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> (bn(p \<bullet> \<alpha>))\<close> \<open>distinctPerm p\<close> Sp have "x \<sharp> (p \<bullet> \<alpha>)"
    by(subst fresh_bij[symmetric, of _ _ p]) (simp add: eqvts freshChainSimps)

  from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>y \<sharp> P\<close> have "cP = \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> P)" by(simp add: alphaRes)
  moreover from \<open>cRs = \<alpha> \<prec> \<lparr>\<nu>x\<rparr>P'\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> \<open>x \<sharp> bn(p \<bullet> \<alpha>)\<close> \<open>(bn(p \<bullet> \<alpha>)) \<sharp>* P'\<close> \<open>x \<sharp> \<alpha>\<close> Sp
  have "cRs = (p \<bullet> \<alpha>) \<prec> \<lparr>\<nu>x\<rparr>(p \<bullet> P')"
    by(force simp add: residualAlpha)
  with \<open>y \<sharp> (p \<bullet> P')\<close> have "cRs = (p \<bullet> \<alpha>) \<prec> \<lparr>\<nu>y\<rparr>([(x, y)] \<bullet> p \<bullet> P')"
    by(simp add: alphaRes)
  moreover from \<open>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> \<open>(bn(p \<bullet> \<alpha>)) \<sharp>* P'\<close> Sp
  have "\<Psi> \<rhd> P \<longmapsto>(p \<bullet> \<alpha>) \<prec> (p \<bullet> P')" by(force simp add: residualAlpha)
  then have"([(x, y)] \<bullet> \<Psi>) \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>[(x, y)] \<bullet> ((p \<bullet> \<alpha>) \<prec> (p \<bullet> P'))"
    by(rule eqvts)
  with \<open>x \<sharp> \<Psi>\<close> \<open>y \<sharp> \<Psi>\<close> \<open>y \<sharp> (p \<bullet> \<alpha>)\<close> \<open>x \<sharp> (p \<bullet> \<alpha>)\<close> Sp \<open>distinctPerm p\<close>
  have "\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>(p \<bullet> \<alpha>) \<prec> ([(x, y)] \<bullet> p \<bullet> P')"
    by(simp add: eqvts)
  moreover from \<open>bn(p \<bullet> \<alpha>) \<sharp>* P\<close> \<open>y \<sharp> (p \<bullet> \<alpha>)\<close> \<open>y \<sharp> P\<close> have "bn(p \<bullet> \<alpha>) \<sharp>* ([(x, y)] \<bullet> P)"
    by(auto simp add: fresh_star_def fresh_left calc_atm) (simp add: fresh_def name_list_supp)
  moreover from \<open>distinct(bn \<alpha>)\<close> have "distinct(p \<bullet> bn \<alpha>)" by simp
  then have "distinct(bn(p \<bullet> \<alpha>))" by(simp add: eqvts)
  ultimately show ?thesis
    using \<open>y \<sharp> \<Psi>\<close> \<open>y \<sharp> (p \<bullet> \<alpha>)\<close> \<open>y \<sharp> C\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* \<Psi>\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* subject(p \<bullet> \<alpha>)\<close> \<open>bn(p \<bullet> \<alpha>) \<sharp>* C\<close>
    by(metis rScope)
next
  case(Bang P)
  then show ?thesis by(metis rBang)
qed

nominal_primrec
  inputLength :: "('a::fs_name, 'b::fs_name, 'c::fs_name) psi \<Rightarrow> nat"
  and inputLength'  :: "('a::fs_name, 'b::fs_name, 'c::fs_name) input \<Rightarrow> nat"
  and inputLength'' :: "('a::fs_name, 'b::fs_name, 'c::fs_name) psiCase \<Rightarrow> nat"

where
  "inputLength (\<zero>) = 0"
| "inputLength (M\<langle>N\<rangle>.P) = 0"
| "inputLength (M\<lparr>I) = inputLength' I"
| "inputLength (Case C) = 0"
| "inputLength (P \<parallel> Q) = 0"
| "inputLength (\<lparr>\<nu>x\<rparr>P) = 0"
| "inputLength (\<lbrace>\<Psi>\<rbrace>) = 0"
| "inputLength (!P) = 0"

| "inputLength' (Trm M P) = 0"
| "inputLength' (\<nu> y I) = 1 + (inputLength' I)"

| "inputLength'' (\<bottom>\<^sub>c) = 0"
| "inputLength'' (\<box>\<Phi> \<Rightarrow> P C) = 0"
                      apply(finite_guess)+
                      apply(rule TrueI)+
  by(fresh_guess add: fresh_nat)+

nominal_primrec boundOutputLength :: "('a, 'b, 'c) boundOutput \<Rightarrow> nat"
  where
    "boundOutputLength (BOut M P) = 0"
  | "boundOutputLength (BStep x B) = (boundOutputLength B) + 1"
         apply(finite_guess)+
      apply(rule TrueI)+
  by(fresh_guess add: fresh_nat)+

nominal_primrec residualLength :: "('a, 'b, 'c) residual \<Rightarrow> nat"
  where
    "residualLength (RIn M N P) = 0"
  | "residualLength (RBrIn M N P) = 0"
  | "residualLength (ROut M B) = boundOutputLength B"
  | "residualLength (RBrOut M B) = boundOutputLength B"
  | "residualLength (RTau P) = 0"
  by(rule TrueI)+

lemma inputLengthProc[simp]:
  shows "inputLength(M\<lparr>\<lambda>*xvec N\<rparr>.P) = length xvec"
  by(induct xvec) auto

lemma boundOutputLengthSimp[simp]:
  shows "residualLength(M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P) = length xvec"
    and "residualLength(\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P) = length xvec"
  by(induct xvec) (auto simp add: residualInject)

lemma boundOuputLengthSimp2[simp]:
  shows "residualLength(\<alpha> \<prec> P) = length(bn \<alpha>)"
  by(nominal_induct \<alpha> rule: action.strong_induct, auto) (auto simp add: residualInject)

lemmas [simp del] = inputLength_inputLength'_inputLength''.simps residualLength.simps boundOutputLength.simps

lemma constructPerm:
  fixes xvec :: "name list"
    and yvec :: "name list"

assumes "length xvec = length yvec"
  and   "xvec \<sharp>* yvec"
  and   "distinct xvec"
  and   "distinct yvec"

obtains p where "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)" and "distinctPerm p" and "yvec = p \<bullet> xvec"
proof -
  assume "\<And>p. \<lbrakk>set p \<subseteq> set xvec \<times> set (p \<bullet> xvec); distinctPerm p; yvec = p \<bullet> xvec\<rbrakk> \<Longrightarrow> thesis"
  moreover obtain n where "n = length xvec" by auto
  with assms have "\<exists>p. (set p) \<subseteq> (set xvec) \<times> set (yvec) \<and> distinctPerm p \<and>  yvec = p \<bullet> xvec"
  proof(induct n arbitrary: xvec yvec)
    case(0 xvec yvec)
    then show ?case by simp
  next
    case(Suc n xvec yvec)
    from \<open>Suc n = length xvec\<close>
    obtain x xvec' where "xvec = x#xvec'" and "length xvec' = n"
      by(cases xvec) auto
    from \<open>length xvec = length yvec\<close> \<open>xvec = x # xvec'\<close>
    obtain y yvec' where "length xvec' = length yvec'" and "yvec = y#yvec'"
      by(cases yvec) auto
    from \<open>xvec = x#xvec'\<close> \<open>yvec=y#yvec'\<close> \<open>xvec \<sharp>* yvec\<close>
    have "x \<noteq> y" and "xvec' \<sharp>* yvec'" and "x \<sharp> yvec'" and "y \<sharp> xvec'"
      by(auto simp add: fresh_list_cons)
    from \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close> have "x \<sharp> xvec'" and "y \<sharp> yvec'" and "distinct xvec'" and "distinct yvec'"
      by simp+
    from \<open>Suc n = length xvec\<close> \<open>xvec=x#xvec'\<close> have "n = length xvec'" by simp
    with \<open>length xvec' = length yvec'\<close> \<open>xvec' \<sharp>* yvec'\<close> \<open>distinct xvec'\<close> \<open>distinct yvec'\<close>
    obtain p where S: "set p \<subseteq> set xvec' \<times> set yvec'" and "distinctPerm p" and "yvec' = p \<bullet> xvec'"
      by - (drule Suc,auto)
    from S have "set((x, y)#p) \<subseteq> set(x#xvec') \<times> set(y#yvec')" by auto
    moreover from \<open>x \<sharp> xvec'\<close> \<open>x \<sharp> yvec'\<close> \<open>y \<sharp> xvec'\<close> \<open>y \<sharp> yvec'\<close> S have "x \<sharp> p" and "y \<sharp> p"
       apply(induct p)
      by(clarsimp simp add: fresh_list_nil fresh_list_cons fresh_prod name_list_supp; force simp add: fresh_def)+

    with S \<open>distinctPerm p\<close> \<open>x \<noteq> y\<close> have "distinctPerm((x, y)#p)" by auto
    moreover from \<open>yvec' = p \<bullet> xvec'\<close> \<open>x \<sharp> p\<close> \<open>y \<sharp> p\<close> \<open>x \<sharp> xvec'\<close> \<open>y \<sharp> xvec'\<close> have "(y#yvec') = ((x, y)#p) \<bullet> (x#xvec')"
      by(simp add: calc_atm freshChainSimps)
    ultimately show ?case using \<open>xvec=x#xvec'\<close> \<open>yvec=y#yvec'\<close>
      by blast
  qed
  ultimately show ?thesis by blast
qed

lemma distinctApend[simp]:
  fixes xvec :: "name list"
    and yvec :: "name list"

shows "(set xvec \<inter> set yvec = {}) = xvec \<sharp>* yvec"
  by(auto simp add: fresh_star_def name_list_supp fresh_def)

lemma lengthAux:
  fixes xvec :: "name list"
    and y    :: name
    and yvec :: "name list"

assumes "length xvec = length(y#yvec)"

obtains z zvec where "xvec = z#zvec" and "length zvec = length yvec"
  using assms
  by(induct xvec arbitrary: yvec y) auto

lemma lengthAux2:
  fixes xvec :: "name list"
    and yvec :: "name list"
    and zvec :: "name list"

assumes "length xvec = length(yvec@y#zvec)"

obtains xvec1 x xvec2 where "xvec=xvec1@x#xvec2" and "length xvec1 = length yvec" and "length xvec2 = length zvec"
proof -
  assume "\<And>xvec1 x xvec2.
        \<lbrakk>xvec = xvec1 @ x # xvec2; length xvec1 = length yvec;
         length xvec2 = length zvec\<rbrakk>
        \<Longrightarrow> thesis"
  moreover from assms have "\<exists>xvec1 x xvec2. xvec=xvec1@x#xvec2 \<and> length xvec1 = length yvec \<and> length xvec2 = length zvec"
    apply -
    apply(rule exI[where x="take (length yvec) xvec"])
    apply(rule exI[where x="hd(drop (length yvec) xvec)"])
    apply(rule exI[where x="tl(drop (length yvec) xvec)"])
    by auto
  ultimately show ?thesis by blast
qed

lemma semanticsCases[consumes 19, case_names cInput cBrInput cOutput cBrOutput cCase cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2 cBrClose cOpen cBrOpen cScope cBang]:
  fixes \<Psi>  :: 'b
    and cP  :: "('a, 'b, 'c) psi"
    and cRs :: "('a, 'b, 'c) residual"
    and C   :: "'f::fs_name"
    and x1   :: name
    and x2   :: name
    and x3   :: name
    and x4   :: name
    and xvec1 :: "name list"
    and xvec2 :: "name list"
    and xvec3 :: "name list"
    and xvec4 :: "name list"
    and xvec5 :: "name list"
    and xvec6 :: "name list"
    and xvec7 :: "name list"
    and xvec8 :: "name list"
    and xvec9 :: "name list"

assumes "\<Psi> \<rhd> cP \<longmapsto>cRs"
  and   "length xvec1 = inputLength cP" and "distinct xvec1"
  and   "length xvec6 = inputLength cP" and "distinct xvec6"
  and   "length xvec2 = residualLength cRs" and "distinct xvec2"
  and   "length xvec3 = residualLength cRs" and "distinct xvec3"
  and   "length xvec4 = residualLength cRs" and "distinct xvec4"
  and   "length xvec5 = residualLength cRs" and "distinct xvec5"
  and   "length xvec7 = residualLength cRs" and "distinct xvec7"
  and   "length xvec8 = residualLength cRs" and "distinct xvec8"
  and   "length xvec9 = residualLength cRs" and "distinct xvec9"
  and   rInput: "\<And>M K N Tvec P. (\<lbrakk>xvec1 \<sharp>* \<Psi>; xvec1 \<sharp>* cP; xvec1 \<sharp>* cRs\<rbrakk> \<Longrightarrow> cP = M\<lparr>\<lambda>*xvec1 N\<rparr>.P \<and>  cRs = K\<lparr>(N[xvec1::=Tvec])\<rparr> \<prec> P[xvec1::=Tvec] \<and>
                                            \<Psi> \<turnstile> M \<leftrightarrow> K \<and> distinct xvec1 \<and> set xvec1 \<subseteq> supp N \<and> length xvec1=length Tvec \<and>
                                            xvec1 \<sharp>* Tvec \<and> xvec1 \<sharp>* \<Psi> \<and> xvec1 \<sharp>* M \<and> xvec1 \<sharp>* K) \<Longrightarrow> Prop"
  and   rBrInput: "\<And>M K N Tvec P. (\<lbrakk>xvec6 \<sharp>* \<Psi>; xvec6 \<sharp>* cP; xvec6 \<sharp>* cRs\<rbrakk> \<Longrightarrow> cP = M\<lparr>\<lambda>*xvec6 N\<rparr>.P \<and>  cRs = \<questiondown>K\<lparr>(N[xvec6::=Tvec])\<rparr> \<prec> P[xvec6::=Tvec] \<and>
                                            \<Psi> \<turnstile> K \<succeq> M \<and> distinct xvec6 \<and> set xvec6 \<subseteq> supp N \<and> length xvec6=length Tvec \<and>
                                            xvec6 \<sharp>* Tvec \<and> xvec6 \<sharp>* \<Psi> \<and> xvec6 \<sharp>* M \<and> xvec6 \<sharp>* K) \<Longrightarrow> Prop"
  and   rOutput: "\<And>M K N P. \<lbrakk>cP = M\<langle>N\<rangle>.P; cRs = K\<langle>N\<rangle> \<prec> P; \<Psi> \<turnstile> M \<leftrightarrow> K\<rbrakk> \<Longrightarrow> Prop"
  and   rBrOutput: "\<And>M K N P. \<lbrakk>cP = M\<langle>N\<rangle>.P; cRs = \<exclamdown>K\<langle>N\<rangle> \<prec> P; \<Psi> \<turnstile> M \<preceq> K\<rbrakk> \<Longrightarrow> Prop"
  and   rCase: "\<And>Cs P \<phi>. \<lbrakk>cP = Cases Cs; \<Psi> \<rhd> P \<longmapsto>cRs; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow> Prop"
  and   rPar1: "\<And>\<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q. (\<lbrakk>xvec2 \<sharp>* \<Psi>; xvec2 \<sharp>* cP; xvec2 \<sharp>* cRs\<rbrakk> \<Longrightarrow>
                                         cP = P \<parallel> Q \<and> cRs = \<alpha> \<prec> (P' \<parallel> Q) \<and> xvec2 = bn \<alpha> \<and>
                                          \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P' \<and> extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and> distinct A\<^sub>Q \<and>
                                          A\<^sub>Q \<sharp>* P \<and> A\<^sub>Q \<sharp>* Q \<and> A\<^sub>Q \<sharp>* \<Psi> \<and> A\<^sub>Q \<sharp>* \<alpha> \<and> A\<^sub>Q \<sharp>* P' \<and> A\<^sub>Q \<sharp>* C) \<Longrightarrow> Prop"
  and   rPar2: "\<And>\<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P. (\<lbrakk>xvec3 \<sharp>* \<Psi>; xvec3 \<sharp>* cP; xvec3 \<sharp>* cRs\<rbrakk> \<Longrightarrow>
                                          cP = P \<parallel> Q \<and> cRs = \<alpha> \<prec> (P \<parallel> Q') \<and> xvec3 = bn \<alpha> \<and>
                                          \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q' \<and> extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and> distinct A\<^sub>P \<and>
                                          A\<^sub>P \<sharp>* P \<and> A\<^sub>P \<sharp>* Q \<and> A\<^sub>P \<sharp>* \<Psi> \<and> A\<^sub>P \<sharp>* \<alpha> \<and> A\<^sub>P \<sharp>* Q' \<and> A\<^sub>P \<sharp>* C) \<Longrightarrow> Prop"
  and   rComm1: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q.
                   \<lbrakk>cP = P \<parallel> Q; cRs = \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>P' \<parallel> Q';
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N;
                    A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* Q;
                    xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C; distinct xvec\<rbrakk> \<Longrightarrow> Prop"
  and   rComm2: "\<And>\<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q.
                   \<lbrakk>cP = P \<parallel> Q; cRs = \<tau> \<prec> \<lparr>\<nu>*xvec\<rparr>P' \<parallel> Q';
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N;
                    A\<^sub>P \<sharp>* P'; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* xvec; A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P;
                    A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* K; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* xvec;
                    xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* \<Psi>\<^sub>Q; xvec \<sharp>* P; xvec \<sharp>* M; xvec \<sharp>* Q;
                    xvec \<sharp>* K; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; xvec \<sharp>* C; distinct xvec\<rbrakk> \<Longrightarrow> Prop"
  and   rBrMerge: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q.
                    \<lbrakk>cP = (P \<parallel> Q); cRs = \<questiondown>M\<lparr>N\<rparr> \<prec> (P' \<parallel> Q');
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow> Prop"
  and   rBrComm1: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q.
                   (\<lbrakk>xvec7 \<sharp>* \<Psi>; xvec7 \<sharp>* cP; xvec7 \<sharp>* cRs\<rbrakk> \<Longrightarrow>
                    cP = P \<parallel> Q \<and> cRs = \<exclamdown>M\<lparr>\<nu>*xvec7\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q') \<and>
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P' \<and> extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and> distinct A\<^sub>P \<and>
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec7\<rparr>\<langle>N\<rangle> \<prec> Q' \<and> extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and> distinct A\<^sub>Q \<and>
                    A\<^sub>P \<sharp>* \<Psi> \<and> A\<^sub>P \<sharp>* \<Psi>\<^sub>Q \<and> A\<^sub>P \<sharp>* P \<and> A\<^sub>P \<sharp>* N \<and>
                    A\<^sub>P \<sharp>* P'\<and> A\<^sub>P \<sharp>* Q \<and> A\<^sub>P \<sharp>* Q' \<and> A\<^sub>P \<sharp>* A\<^sub>Q \<and> A\<^sub>P \<sharp>* xvec7 \<and> A\<^sub>Q \<sharp>* \<Psi> \<and> A\<^sub>Q \<sharp>* \<Psi>\<^sub>P \<and>
                    A\<^sub>Q \<sharp>* P \<and> A\<^sub>Q \<sharp>* N \<and> A\<^sub>Q \<sharp>* P' \<and> A\<^sub>Q \<sharp>* Q \<and> A\<^sub>Q \<sharp>* Q' \<and> A\<^sub>Q \<sharp>* xvec7 \<and>
                    xvec7 \<sharp>* \<Psi> \<and> xvec7 \<sharp>* \<Psi>\<^sub>P \<and> xvec7 \<sharp>* \<Psi>\<^sub>Q \<and> xvec7 \<sharp>* P \<and> xvec7 \<sharp>* Q \<and>
                    A\<^sub>P \<sharp>* M \<and> A\<^sub>Q \<sharp>* M \<and> xvec7 \<sharp>* M \<and>
                    A\<^sub>P \<sharp>* C \<and> A\<^sub>Q \<sharp>* C \<and> distinct xvec7) \<Longrightarrow> Prop"
  and   rBrComm2: "\<And>\<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q.
                   (\<lbrakk>xvec8 \<sharp>* \<Psi>; xvec8 \<sharp>* cP; xvec8 \<sharp>* cRs\<rbrakk> \<Longrightarrow>
                    cP = P \<parallel> Q \<and> cRs = \<exclamdown>M\<lparr>\<nu>*xvec8\<rparr>\<langle>N\<rangle> \<prec> (P' \<parallel> Q') \<and>
                    \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec8\<rparr>\<langle>N\<rangle> \<prec> P' \<and> extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and> distinct A\<^sub>P \<and>
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q' \<and> extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and> distinct A\<^sub>Q \<and>
                    A\<^sub>P \<sharp>* \<Psi> \<and> A\<^sub>P \<sharp>* \<Psi>\<^sub>Q \<and> A\<^sub>P \<sharp>* P \<and> A\<^sub>P \<sharp>* N \<and>
                    A\<^sub>P \<sharp>* P' \<and> A\<^sub>P \<sharp>* Q \<and> A\<^sub>P \<sharp>* Q' \<and> A\<^sub>P \<sharp>* A\<^sub>Q \<and> A\<^sub>P \<sharp>* xvec8 \<and> A\<^sub>Q \<sharp>* \<Psi> \<and> A\<^sub>Q \<sharp>* \<Psi>\<^sub>P \<and>
                    A\<^sub>Q \<sharp>* P \<and> A\<^sub>Q \<sharp>* N \<and> A\<^sub>Q \<sharp>* P' \<and> A\<^sub>Q \<sharp>* Q \<and> A\<^sub>Q \<sharp>* Q' \<and> A\<^sub>Q \<sharp>* xvec8 \<and>
                    xvec8 \<sharp>* \<Psi> \<and> xvec8 \<sharp>* \<Psi>\<^sub>P \<and> xvec8 \<sharp>* \<Psi>\<^sub>Q \<and> xvec8 \<sharp>* P \<and> xvec8 \<sharp>* Q \<and>
                    A\<^sub>P \<sharp>* M \<and> A\<^sub>Q \<sharp>* M \<and> xvec8 \<sharp>* M \<and>
                    A\<^sub>P \<sharp>* C \<and> A\<^sub>Q \<sharp>* C \<and> distinct xvec8) \<Longrightarrow> Prop"
  and   rBrClose: "\<And>P M N xvec P'.
                   (\<lbrakk>x3 \<sharp> \<Psi>; x3 \<sharp> cP; x3 \<sharp> cRs\<rbrakk> \<Longrightarrow>
                    cP = (\<lparr>\<nu>x3\<rparr>P) \<and> cRs = \<tau> \<prec> \<lparr>\<nu>x3\<rparr>(\<lparr>\<nu>*xvec\<rparr>P') \<and>
                    x3 \<in> supp M \<and>
                    \<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<and>
                    distinct xvec \<and> xvec \<sharp>* \<Psi> \<and> xvec \<sharp>* P \<and>
                    xvec \<sharp>* M \<and> xvec \<sharp>* C \<and>
                    x3 \<sharp> \<Psi> \<and> x3 \<sharp> xvec) \<Longrightarrow> Prop"
  and  rOpen:  "\<And>P M xvec y yvec N P'.
                   (\<lbrakk>xvec4 \<sharp>* \<Psi>; xvec4 \<sharp>* cP; xvec4 \<sharp>* cRs; x1 \<sharp> \<Psi>; x1 \<sharp> cP; x1 \<sharp> cRs; x1 \<sharp> xvec4\<rbrakk> \<Longrightarrow>
                    cP = \<lparr>\<nu>x1\<rparr>P \<and> cRs = M\<lparr>\<nu>*(xvec@x1#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' \<and> xvec4=xvec@y#yvec \<and>
                    \<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P' \<and> x1 \<in> supp N \<and> x1 \<sharp> xvec \<and> x1 \<sharp> yvec \<and>
                    distinct xvec \<and> distinct yvec \<and> xvec \<sharp>* \<Psi> \<and> xvec \<sharp>* P \<and> xvec \<sharp>* M \<and> xvec \<sharp>* yvec \<and>
                    yvec \<sharp>* \<Psi> \<and> yvec \<sharp>* P \<and> yvec \<sharp>* M) \<Longrightarrow> Prop"
  and  rBrOpen:  "\<And>P M xvec y yvec N P'.
                   (\<lbrakk>xvec9 \<sharp>* \<Psi>; xvec9 \<sharp>* cP; xvec9 \<sharp>* cRs; x4 \<sharp> \<Psi>; x4 \<sharp> cP; x4 \<sharp> cRs; x4 \<sharp> xvec9\<rbrakk> \<Longrightarrow>
                    cP = \<lparr>\<nu>x4\<rparr>P \<and> cRs = \<exclamdown>M\<lparr>\<nu>*(xvec@x4#yvec)\<rparr>\<langle>N\<rangle> \<prec> P' \<and> xvec9=xvec@y#yvec \<and>
                    \<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P' \<and> x4 \<in> supp N \<and> x4 \<sharp> xvec \<and> x4 \<sharp> yvec \<and>
                    distinct xvec \<and> distinct yvec \<and> xvec \<sharp>* \<Psi> \<and> xvec \<sharp>* P \<and> xvec \<sharp>* M \<and> xvec \<sharp>* yvec \<and>
                    yvec \<sharp>* \<Psi> \<and> yvec \<sharp>* P \<and> yvec \<sharp>* M) \<Longrightarrow> Prop"
  and   rScope: "\<And>P \<alpha> P'. (\<lbrakk>xvec5 \<sharp>* \<Psi>; xvec5 \<sharp>* cP; xvec5 \<sharp>* cRs; x2 \<sharp> \<Psi>; x2 \<sharp> cP; x2 \<sharp> cRs; x2 \<sharp> xvec5\<rbrakk> \<Longrightarrow>
                                 cP = \<lparr>\<nu>x2\<rparr>P \<and> cRs = \<alpha> \<prec> \<lparr>\<nu>x2\<rparr>P' \<and>  xvec5 = bn \<alpha> \<and>
                                 \<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P' \<and> x2 \<sharp> \<Psi> \<and> x2 \<sharp> \<alpha> \<and> bn \<alpha> \<sharp>* subject \<alpha> \<and> distinct(bn \<alpha>)) \<Longrightarrow> Prop"
  and  rBang:  "\<And>P. \<lbrakk>cP = !P;
                               \<Psi> \<rhd> P \<parallel> !P \<longmapsto>cRs; guarded P\<rbrakk> \<Longrightarrow> Prop"
shows Prop
  using \<open>\<Psi> \<rhd> cP \<longmapsto>cRs\<close>
proof(cases rule: semanticsCasesAux[where C="(xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)"])
  case(cInput M K xvec N Tvec P)
  have B: "cP = M\<lparr>\<lambda>*xvec N\<rparr>.P" and C: "cRs = K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> (P[xvec::=Tvec])"
    by fact+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* xvec1" by simp

  from \<open>length xvec1 = inputLength cP\<close> B have "length xvec1 = length xvec"
    by simp
  then obtain p where S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)" and "distinctPerm p" and "xvec1 = p \<bullet> xvec"
    using \<open>xvec \<sharp>* xvec1\<close> \<open>distinct xvec\<close> \<open>distinct xvec1\<close>
    by - (rule constructPerm[where xvec=xvec and yvec=xvec1], auto)
  show ?thesis
  proof(rule rInput[where M=M and K=K and N = "p \<bullet> N" and Tvec=Tvec and P="p \<bullet> P"])
    assume "xvec1 \<sharp>* \<Psi>" and "xvec1 \<sharp>* cP" and "xvec1 \<sharp>* cRs"
    from B \<open>xvec \<sharp>* xvec1\<close> \<open>xvec1 \<sharp>* cP\<close> have "xvec1 \<sharp>* N" and "xvec1 \<sharp>* P"
      by(auto simp add: fresh_star_def inputChainFresh name_list_supp) (auto simp add: fresh_def)
    moreover from \<open>cP = M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> S \<open>xvec1 \<sharp>* N\<close> \<open>xvec1 \<sharp>* P\<close> \<open>xvec1 = p \<bullet> xvec\<close>
    have "cP = M\<lparr>\<lambda>*xvec1 (p \<bullet> N)\<rparr>.(p \<bullet> P)"
      apply simp
      by(subst inputChainAlpha) auto
    moreover from \<open>cRs = K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec]\<close> S \<open>xvec1 \<sharp>* N\<close> \<open>xvec1 \<sharp>* P\<close> \<open>xvec1 = p \<bullet> xvec\<close> \<open>length xvec = length Tvec\<close> \<open>distinctPerm p\<close>
    have "cRs =  K\<lparr>((p \<bullet> N)[xvec1::=Tvec])\<rparr> \<prec> (p \<bullet> P)[xvec1::=Tvec]"
      by(simp add: renaming substTerm.renaming)
    moreover note \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close>
    moreover from \<open>distinct xvec\<close> \<open>xvec1 = p \<bullet> xvec\<close> have "distinct xvec1" by simp
    moreover from \<open>set xvec \<subseteq> supp N\<close> have "(p \<bullet> set xvec) \<subseteq> (p \<bullet> (supp N))"
      by(simp add: eqvts)
    with \<open>xvec1 = p \<bullet> xvec\<close> have "set xvec1 \<subseteq> supp(p \<bullet> N)" by(simp add: eqvts)
    moreover from \<open>length xvec = length Tvec\<close> \<open>xvec1 = p \<bullet> xvec\<close> have "length xvec1 = length Tvec"
      by simp

    moreover from \<open>xvec1 \<sharp>* cRs\<close> C \<open>length xvec = length Tvec\<close> \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close>
    have "(set xvec1) \<sharp>* Tvec"
      by - (rule substTerm.subst3Chain[where T=N], auto)
    then have "xvec1 \<sharp>* Tvec" by simp
    moreover from \<open>xvec \<sharp>* Tvec\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> Tvec)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* Tvec\<close> \<open>xvec1 \<sharp>* Tvec\<close> \<open>xvec1 = p \<bullet> xvec\<close> have "xvec1 \<sharp>* Tvec" by simp
    moreover note \<open>xvec1 \<sharp>* \<Psi>\<close>
    moreover from \<open>xvec \<sharp>* M\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* M\<close> \<open>xvec1 \<sharp>* cP\<close> B \<open>xvec1 = p \<bullet> xvec\<close> have "xvec1 \<sharp>* M" by simp
    moreover from \<open>xvec \<sharp>* K\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> K)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* K\<close> \<open>xvec1 \<sharp>* cRs\<close> C \<open>xvec1 = p \<bullet> xvec\<close> have "xvec1 \<sharp>* K" by simp
    ultimately show "cP = M\<lparr>\<lambda>*xvec1 p \<bullet> N\<rparr>.p \<bullet> P \<and> cRs = K\<lparr>(p \<bullet> N)[xvec1::=Tvec]\<rparr> \<prec> (p \<bullet> P)[xvec1::=Tvec] \<and>
      \<Psi> \<turnstile> M \<leftrightarrow> K \<and> distinct xvec1 \<and> set xvec1 \<subseteq> supp (p \<bullet> N) \<and> length xvec1 = length Tvec \<and>
      xvec1 \<sharp>* Tvec \<and> xvec1 \<sharp>* \<Psi> \<and> xvec1 \<sharp>* M \<and> xvec1 \<sharp>* K"
      by blast
  qed
next
  case(cBrInput M K xvec N Tvec P)
  have B: "cP = M\<lparr>\<lambda>*xvec N\<rparr>.P" and C: "cRs = \<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> (P[xvec::=Tvec])"
    by fact+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* xvec6" by simp

  from \<open>length xvec6 = inputLength cP\<close> B have "length xvec6 = length xvec"
    by simp
  then obtain p where S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)" and "distinctPerm p" and "xvec6 = p \<bullet> xvec"
    using \<open>xvec \<sharp>* xvec6\<close> \<open>distinct xvec\<close> \<open>distinct xvec6\<close>
    by - (rule constructPerm[where xvec=xvec and yvec=xvec6], auto)
  show ?thesis
  proof(rule rBrInput[where M=M and K=K and N = "p \<bullet> N" and Tvec=Tvec and P="p \<bullet> P"])
    assume "xvec6 \<sharp>* \<Psi>" and "xvec6 \<sharp>* cP" and "xvec6 \<sharp>* cRs"
    from B \<open>xvec \<sharp>* xvec6\<close> \<open>xvec6 \<sharp>* cP\<close> have "xvec6 \<sharp>* N" and "xvec6 \<sharp>* P"
      by(auto simp add: fresh_star_def inputChainFresh name_list_supp) (auto simp add: fresh_def)

    moreover from \<open>cP = M\<lparr>\<lambda>*xvec N\<rparr>.P\<close> S \<open>xvec6 \<sharp>* N\<close> \<open>xvec6 \<sharp>* P\<close> \<open>xvec6 = p \<bullet> xvec\<close>
    have "cP = M\<lparr>\<lambda>*xvec6 (p \<bullet> N)\<rparr>.(p \<bullet> P)"
      apply simp
      by(subst inputChainAlpha) auto
    moreover from \<open>cRs = \<questiondown>K\<lparr>(N[xvec::=Tvec])\<rparr> \<prec> P[xvec::=Tvec]\<close> S \<open>xvec6 \<sharp>* N\<close> \<open>xvec6 \<sharp>* P\<close> \<open>xvec6 = p \<bullet> xvec\<close> \<open>length xvec = length Tvec\<close> \<open>distinctPerm p\<close>
    have "cRs =  \<questiondown>K\<lparr>((p \<bullet> N)[xvec6::=Tvec])\<rparr> \<prec> (p \<bullet> P)[xvec6::=Tvec]"
      by(simp add: renaming substTerm.renaming)
    moreover note \<open>\<Psi> \<turnstile> K \<succeq> M\<close>
    moreover from \<open>distinct xvec\<close> \<open>xvec6 = p \<bullet> xvec\<close> have "distinct xvec6" by simp
    moreover from \<open>set xvec \<subseteq> supp N\<close> have "(p \<bullet> set xvec) \<subseteq> (p \<bullet> (supp N))"
      by(simp add: eqvts)
    with \<open>xvec6 = p \<bullet> xvec\<close> have "set xvec6 \<subseteq> supp(p \<bullet> N)" by(simp add: eqvts)
    moreover from \<open>length xvec = length Tvec\<close> \<open>xvec6 = p \<bullet> xvec\<close> have "length xvec6 = length Tvec"
      by simp

    moreover from \<open>xvec6 \<sharp>* cRs\<close> C \<open>length xvec = length Tvec\<close> \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close>
    have "(set xvec6) \<sharp>* Tvec"
      by - (rule substTerm.subst3Chain[where T=N], auto)
    then have "xvec6 \<sharp>* Tvec" by simp
    moreover from \<open>xvec \<sharp>* Tvec\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> Tvec)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* Tvec\<close> \<open>xvec6 \<sharp>* Tvec\<close> \<open>xvec6 = p \<bullet> xvec\<close> have "xvec6 \<sharp>* Tvec" by simp
    moreover note \<open>xvec6 \<sharp>* \<Psi>\<close>
    moreover from \<open>xvec \<sharp>* M\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* M\<close> \<open>xvec6 \<sharp>* cP\<close> B \<open>xvec6 = p \<bullet> xvec\<close> have "xvec6 \<sharp>* M" by simp
    moreover from \<open>xvec \<sharp>* K\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> K)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* K\<close> \<open>xvec6 \<sharp>* cRs\<close> C \<open>xvec6 = p \<bullet> xvec\<close> have "xvec6 \<sharp>* K" by simp
    ultimately show "cP = M\<lparr>\<lambda>*xvec6 p \<bullet> N\<rparr>.p \<bullet> P \<and>
      cRs = \<questiondown>K\<lparr>(p \<bullet> N)[xvec6::=Tvec]\<rparr> \<prec> (p \<bullet> P)[xvec6::=Tvec] \<and>
      \<Psi> \<turnstile> K \<succeq> M \<and> distinct xvec6 \<and> set xvec6 \<subseteq> supp (p \<bullet> N) \<and> length xvec6 = length Tvec \<and>
      xvec6 \<sharp>* Tvec \<and> xvec6 \<sharp>* \<Psi> \<and> xvec6 \<sharp>* M \<and> xvec6 \<sharp>* K" by blast
  qed
next
  case(cOutput M K N P)
  then show ?thesis by(rule rOutput)
next
  case(cBrOutput M N P)
  then show ?thesis by(rule rBrOutput)
next
  case(cCase Cs P \<phi>)
  then show ?thesis by(rule rCase)
next
  case(cPar1 \<Psi>\<^sub>Q P \<alpha> P' Q A\<^sub>Q)
  have B: "cP = P \<parallel> Q" and C: "cRs = \<alpha> \<prec> P' \<parallel> Q"
    by fact+
  from \<open>bn \<alpha> \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "bn \<alpha> \<sharp>* xvec2" by simp
  from \<open>A\<^sub>Q \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "A\<^sub>Q \<sharp>* xvec2" and "A\<^sub>Q \<sharp>* C" by simp+

  from \<open>length xvec2 = residualLength cRs\<close> C have "length xvec2 = length(bn \<alpha>)"
    by simp
  then obtain p where S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" and "distinctPerm p" and "xvec2= bn(p \<bullet> \<alpha>)"
    using \<open>bn \<alpha> \<sharp>* xvec2\<close> \<open>distinct(bn \<alpha>)\<close> \<open>distinct xvec2\<close>
    by - (rule constructPerm[where xvec="bn \<alpha>" and yvec=xvec2], auto simp add: eqvts)
  show ?thesis
  proof(rule rPar1[where P=P and Q=Q and \<alpha>="p \<bullet> \<alpha>" and P'="p \<bullet> P'" and A\<^sub>Q=A\<^sub>Q and \<Psi>\<^sub>Q=\<Psi>\<^sub>Q])
    assume "xvec2 \<sharp>* \<Psi>" and "xvec2 \<sharp>* cP" and "xvec2 \<sharp>* cRs"
    note \<open>cP = P \<parallel> Q\<close>
    moreover from C S \<open>bn \<alpha> \<sharp>* xvec2\<close> \<open>xvec2 \<sharp>* cRs\<close> \<open>xvec2 = bn(p \<bullet> \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>xvec2 \<sharp>* cP\<close> \<open>bn \<alpha> \<sharp>* Q\<close>
    have "cRs = (p \<bullet> \<alpha>) \<prec> (p \<bullet> P') \<parallel> Q"
      apply clarsimp
      by(subst residualAlpha[where p=p]) auto
    moreover note \<open>xvec2 = bn(p \<bullet> \<alpha>)\<close>
    moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> S B C S \<open>bn \<alpha> \<sharp>* xvec2\<close> \<open>xvec2 \<sharp>* cRs\<close> \<open>xvec2 = bn(p \<bullet> \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>xvec2 \<sharp>* cP\<close>
    have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>(p \<bullet> \<alpha>) \<prec> (p \<bullet> P')"
      by(subst residualAlpha[symmetric]) auto
    moreover note \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close>
    moreover from \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* xvec2\<close> S \<open>xvec2 = bn(p \<bullet> \<alpha>)\<close> \<open>distinctPerm p\<close> have "A\<^sub>Q \<sharp>* (p \<bullet> \<alpha>)"
      by(subst fresh_star_bij[symmetric, where pi=p]) simp
    moreover from \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* \<alpha>\<close> \<open>A\<^sub>Q \<sharp>* xvec2\<close> S \<open>xvec2 = bn(p \<bullet> \<alpha>)\<close> \<open>distinctPerm p\<close> have "A\<^sub>Q \<sharp>* (p \<bullet> P')"
      by(subst fresh_star_bij[symmetric, where pi=p]) simp
    moreover note \<open>A\<^sub>Q \<sharp>* C\<close>
    ultimately show "cP = P \<parallel> Q \<and> cRs = (p \<bullet> \<alpha>) \<prec> (p \<bullet> P') \<parallel> Q \<and> xvec2 = bn (p \<bullet> \<alpha>) \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> (p \<bullet> \<alpha>) \<prec> p \<bullet> P' \<and> extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and> distinct A\<^sub>Q \<and> A\<^sub>Q \<sharp>* P \<and>
      A\<^sub>Q \<sharp>* Q \<and> A\<^sub>Q \<sharp>* \<Psi> \<and> A\<^sub>Q \<sharp>* (p \<bullet> \<alpha>) \<and> A\<^sub>Q \<sharp>* (p \<bullet> P') \<and> A\<^sub>Q \<sharp>* C" by blast
  qed
next
  case(cPar2 \<Psi>\<^sub>P Q \<alpha> Q' P A\<^sub>P)
  have B: "cP = P \<parallel> Q" and C: "cRs = \<alpha> \<prec> P \<parallel> Q'"
    by fact+
  from \<open>bn \<alpha> \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "bn \<alpha> \<sharp>* xvec3" by simp
  from \<open>A\<^sub>P \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "A\<^sub>P \<sharp>* xvec3" and "A\<^sub>P \<sharp>* C" by simp+

  from \<open>length xvec3 = residualLength cRs\<close> C have "length xvec3 = length(bn \<alpha>)"
    by simp
  then obtain p where S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" and "distinctPerm p" and "xvec3 = bn(p \<bullet> \<alpha>)"
    using \<open>bn \<alpha> \<sharp>* xvec3\<close> \<open>distinct(bn \<alpha>)\<close> \<open>distinct xvec3\<close>
    by - (rule constructPerm[where xvec="bn \<alpha>" and yvec=xvec3], auto simp add: eqvts)
  show ?thesis
  proof(rule rPar2[where P=P and Q=Q and \<alpha>="p \<bullet> \<alpha>" and Q'="p \<bullet> Q'" and A\<^sub>P=A\<^sub>P and \<Psi>\<^sub>P=\<Psi>\<^sub>P])
    assume "xvec3 \<sharp>* \<Psi>" and "xvec3 \<sharp>* cP" and "xvec3 \<sharp>* cRs"
    note \<open>cP = P \<parallel> Q\<close>
    moreover from B C S \<open>bn \<alpha> \<sharp>* xvec3\<close> \<open>xvec3 \<sharp>* cRs\<close> \<open>xvec3 = bn(p \<bullet> \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>xvec3 \<sharp>* cP\<close> \<open>bn \<alpha> \<sharp>* P\<close>
    have "cRs = (p \<bullet> \<alpha>) \<prec> P \<parallel> (p \<bullet> Q')"
      apply clarsimp
      by(subst residualAlpha[where p=p]) auto
    moreover note \<open>xvec3 = bn(p \<bullet> \<alpha>)\<close>
    moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'\<close> S B C S \<open>bn \<alpha> \<sharp>* xvec3\<close> \<open>xvec3 \<sharp>* cRs\<close> \<open>xvec3 = bn(p \<bullet> \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>xvec3 \<sharp>* cP\<close>
    have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>(p \<bullet> \<alpha>) \<prec> (p \<bullet> Q')"
      by(subst residualAlpha[symmetric]) auto
    moreover note \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close>
    moreover from \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* xvec3\<close> S \<open>xvec3 = bn(p \<bullet> \<alpha>)\<close> \<open>distinctPerm p\<close> have "A\<^sub>P \<sharp>* (p \<bullet> \<alpha>)"
      by(subst fresh_star_bij[symmetric, where pi=p]) simp
    moreover from \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* xvec3\<close> S \<open>xvec3 = bn(p \<bullet> \<alpha>)\<close> \<open>distinctPerm p\<close> have "A\<^sub>P \<sharp>* (p \<bullet> Q')"
      by(subst fresh_star_bij[symmetric, where pi=p]) simp
    moreover note \<open>A\<^sub>P \<sharp>* C\<close>
    ultimately show "cP = P \<parallel> Q \<and> cRs = (p \<bullet> \<alpha>) \<prec> P \<parallel> (p \<bullet> Q') \<and> xvec3 = bn (p \<bullet> \<alpha>) \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> (p \<bullet> \<alpha>) \<prec> p \<bullet> Q' \<and>
      extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and> distinct A\<^sub>P \<and> A\<^sub>P \<sharp>* P \<and> A\<^sub>P \<sharp>* Q \<and> A\<^sub>P \<sharp>* \<Psi> \<and> A\<^sub>P \<sharp>* (p \<bullet> \<alpha>) \<and>
      A\<^sub>P \<sharp>* (p \<bullet> Q') \<and> A\<^sub>P \<sharp>* C" by blast
  qed
next
  case(cComm1 \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q K xvec Q' A\<^sub>Q)
  then show ?thesis by - (rule rComm1[where P=P and Q=Q], (assumption | simp)+)
next
  case(cComm2 \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q K Q' A\<^sub>Q)
  then show ?thesis by - (rule rComm2[where P=P and Q=Q], (assumption | simp)+)
next
  case(cBrMerge \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q)
  then show ?thesis by - (rule rBrMerge[where P=P and Q=Q], (assumption | simp)+)
next
  case(cBrComm1 \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q)
  have B: "cP = P \<parallel> Q" and C: "cRs = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
    by fact+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* xvec7" and "xvec \<sharp>* C" by simp+
  from \<open>A\<^sub>P \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "A\<^sub>P \<sharp>* xvec7" and "A\<^sub>P \<sharp>* C" by simp+
  from \<open>A\<^sub>Q \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "A\<^sub>Q \<sharp>* xvec7" and "A\<^sub>Q \<sharp>* C" by simp+

  from \<open>length xvec7 = residualLength cRs\<close> C have "length xvec7 = length xvec"
    by simp
  then obtain p where S: "set p \<subseteq> set xvec \<times> set (p \<bullet> xvec)" and "distinctPerm p" and "xvec7 = p \<bullet> xvec"
    using \<open>xvec \<sharp>* xvec7\<close> \<open>distinct xvec\<close> \<open>distinct xvec7\<close>
    by - (rule constructPerm[where xvec=xvec and yvec=xvec7], auto simp add: eqvts)
  show ?thesis
  proof(rule rBrComm1[where P=P and Q=Q and P'="p \<bullet> P'"
        and Q'="p \<bullet> Q'" and N="p \<bullet> N" and A\<^sub>P=A\<^sub>P and \<Psi>\<^sub>P=\<Psi>\<^sub>P and A\<^sub>Q=A\<^sub>Q and \<Psi>\<^sub>Q=\<Psi>\<^sub>Q and M=M])
    assume "xvec7 \<sharp>* \<Psi>" and "xvec7 \<sharp>* cP" and "xvec7 \<sharp>* cRs"
    from \<open>A\<^sub>Q \<sharp>* xvec7\<close> \<open>xvec7 = p \<bullet> xvec\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> xvec)" by simp
    from \<open>A\<^sub>P \<sharp>* xvec7\<close> \<open>xvec7 = p \<bullet> xvec\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> xvec)" by simp
    from \<open>xvec \<sharp>* M\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* M\<close> \<open>xvec7 \<sharp>* cRs\<close> C \<open>xvec7 = p \<bullet> xvec\<close> have "xvec7 \<sharp>* M" by simp

    note \<open>cP = P \<parallel> Q\<close>
    moreover from C S \<open>xvec \<sharp>* xvec7\<close> \<open>xvec7 \<sharp>* cRs\<close> \<open>xvec7 = p \<bullet> xvec\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec7 \<sharp>* cP\<close>
    have "cRs = \<exclamdown>M\<lparr>\<nu>*xvec7\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P') \<parallel> (p \<bullet> Q')"
      apply clarsimp
      by(subst residualAlpha[where p=p]) simp+

    moreover note \<open>xvec7 = p \<bullet> xvec\<close>
    moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'\<close> S B \<open>distinctPerm p\<close> \<open>xvec \<sharp>* xvec7\<close> \<open>xvec7 = p \<bullet> xvec\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec7 \<sharp>* cP\<close>
    have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>(p \<bullet> N)\<rparr> \<prec> p \<bullet> P'"
      by(simp add: brinputAlpha)

    moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> S B C \<open>xvec \<sharp>* xvec7\<close> \<open>xvec7 \<sharp>* cRs\<close> \<open>xvec7 = p \<bullet> xvec\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec7 \<sharp>* cP\<close> \<open>xvec7 \<sharp>* M\<close>
    have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec7\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> p \<bullet> Q'"
      by(auto simp add: residualAlpha)

    moreover note
      \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>distinct A\<^sub>Q\<close>
      \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* xvec7\<close>
      \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* xvec7\<close>

    moreover from S \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> N)"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>P \<sharp>* P'\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> P')"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>P \<sharp>* Q'\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> Q')"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> N)"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>Q \<sharp>* P'\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> P')"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> Q')"
      by(simp add: freshChainSimps)

    moreover note \<open>xvec7 \<sharp>* \<Psi>\<close>

    moreover from \<open>xvec7 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* xvec7\<close>
    have "xvec7 \<sharp>* \<Psi>\<^sub>P"
      by simp (metis extractFrameFreshChain freshFrameDest)

    moreover from \<open>xvec7 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* xvec7\<close>
    have "xvec7 \<sharp>* \<Psi>\<^sub>Q"
      by simp (metis extractFrameFreshChain freshFrameDest)

    moreover from \<open>xvec7 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> have "xvec7 \<sharp>* P" by simp
    moreover from \<open>xvec7 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> have "xvec7 \<sharp>* Q" by simp

    moreover note \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close>

    moreover note \<open>xvec7 \<sharp>* M\<close>

    moreover note \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>distinct xvec7\<close>

    ultimately show "cP = P \<parallel> Q \<and> cRs = \<exclamdown>M\<lparr>\<nu>*xvec7\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P') \<parallel> (p \<bullet> Q') \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>(p \<bullet> N)\<rparr> \<prec> p \<bullet> P' \<and> extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and> distinct A\<^sub>P \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec7\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> p \<bullet> Q' \<and> extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and> distinct A\<^sub>Q \<and>
      A\<^sub>P \<sharp>* \<Psi> \<and> A\<^sub>P \<sharp>* \<Psi>\<^sub>Q \<and> A\<^sub>P \<sharp>* P \<and> A\<^sub>P \<sharp>* (p \<bullet> N) \<and> A\<^sub>P \<sharp>* (p \<bullet> P') \<and> A\<^sub>P \<sharp>* Q \<and> A\<^sub>P \<sharp>* (p \<bullet> Q') \<and>
      A\<^sub>P \<sharp>* A\<^sub>Q \<and> A\<^sub>P \<sharp>* xvec7 \<and> A\<^sub>Q \<sharp>* \<Psi> \<and> A\<^sub>Q \<sharp>* \<Psi>\<^sub>P \<and> A\<^sub>Q \<sharp>* P \<and> A\<^sub>Q \<sharp>* (p \<bullet> N) \<and> A\<^sub>Q \<sharp>* (p \<bullet> P') \<and>
      A\<^sub>Q \<sharp>* Q \<and> A\<^sub>Q \<sharp>* (p \<bullet> Q') \<and> A\<^sub>Q \<sharp>* xvec7 \<and> xvec7 \<sharp>* \<Psi> \<and> xvec7 \<sharp>* \<Psi>\<^sub>P \<and> xvec7 \<sharp>* \<Psi>\<^sub>Q \<and> xvec7 \<sharp>* P \<and>
      xvec7 \<sharp>* Q \<and> A\<^sub>P \<sharp>* M \<and> A\<^sub>Q \<sharp>* M \<and> xvec7 \<sharp>* M \<and> A\<^sub>P \<sharp>* C \<and> A\<^sub>Q \<sharp>* C \<and> distinct xvec7" by blast
  qed
next
  case(cBrComm2 \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q)
  have B: "cP = P \<parallel> Q" and C: "cRs = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
    by fact+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* xvec8" and "xvec \<sharp>* C" by simp+
  from \<open>A\<^sub>P \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "A\<^sub>P \<sharp>* xvec8" and "A\<^sub>P \<sharp>* C" by simp+
  from \<open>A\<^sub>Q \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "A\<^sub>Q \<sharp>* xvec8" and "A\<^sub>Q \<sharp>* C" by simp+

  from \<open>length xvec8 = residualLength cRs\<close> C have "length xvec8 = length xvec"
    by simp
  then obtain p where S: "set p \<subseteq> set xvec \<times> set (p \<bullet> xvec)" and "distinctPerm p" and "xvec8 = p \<bullet> xvec"
    using \<open>xvec \<sharp>* xvec8\<close> \<open>distinct xvec\<close> \<open>distinct xvec8\<close>
    by - (rule constructPerm[where xvec=xvec and yvec=xvec8], auto simp add: eqvts)
  show ?thesis
  proof(rule rBrComm2[where P=P and Q=Q and P'="p \<bullet> P'"
        and Q'="p \<bullet> Q'" and N="p \<bullet> N" and A\<^sub>P=A\<^sub>P and \<Psi>\<^sub>P=\<Psi>\<^sub>P and A\<^sub>Q=A\<^sub>Q and \<Psi>\<^sub>Q=\<Psi>\<^sub>Q and M=M])
    assume "xvec8 \<sharp>* \<Psi>" and "xvec8 \<sharp>* cP" and "xvec8 \<sharp>* cRs"
    from \<open>A\<^sub>Q \<sharp>* xvec8\<close> \<open>xvec8 = p \<bullet> xvec\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> xvec)" by simp
    from \<open>A\<^sub>P \<sharp>* xvec8\<close> \<open>xvec8 = p \<bullet> xvec\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> xvec)" by simp
    from \<open>xvec \<sharp>* M\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> M)" by(simp add: fresh_star_bij)
    with S \<open>xvec \<sharp>* M\<close> \<open>xvec8 \<sharp>* cRs\<close> C \<open>xvec8 = p \<bullet> xvec\<close> have "xvec8 \<sharp>* M" by simp

    note \<open>cP = P \<parallel> Q\<close>
    moreover from C S \<open>xvec \<sharp>* xvec8\<close> \<open>xvec8 \<sharp>* cRs\<close> \<open>xvec8 = p \<bullet> xvec\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec8 \<sharp>* cP\<close>
    have "cRs = \<exclamdown>M\<lparr>\<nu>*xvec8\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P') \<parallel> (p \<bullet> Q')"
      apply clarsimp
      by(subst residualAlpha[where p=p]) simp+

    moreover note \<open>xvec8 = p \<bullet> xvec\<close>
    moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'\<close> S B \<open>distinctPerm p\<close> \<open>xvec \<sharp>* xvec8\<close> \<open>xvec8 = p \<bullet> xvec\<close> \<open>xvec \<sharp>* Q\<close> \<open>xvec8 \<sharp>* cP\<close>
    have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>(p \<bullet> N)\<rparr> \<prec> p \<bullet> Q'"
      by(simp add: brinputAlpha)

    moreover from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> S B C \<open>xvec \<sharp>* xvec8\<close> \<open>xvec8 \<sharp>* cRs\<close> \<open>xvec8 = p \<bullet> xvec\<close> \<open>xvec \<sharp>* M\<close> \<open>xvec8 \<sharp>* cP\<close> \<open>xvec8 \<sharp>* M\<close>
    have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec8\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> p \<bullet> P'"
      by(auto simp add: residualAlpha)

    moreover note
      \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>distinct A\<^sub>P\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>distinct A\<^sub>Q\<close>
      \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* xvec8\<close>
      \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* xvec8\<close>

    moreover from S \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> N)"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>P \<sharp>* P'\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> P')"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>P \<sharp>* Q'\<close>
    have "A\<^sub>P \<sharp>* (p \<bullet> Q')"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> N)"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>Q \<sharp>* P'\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> P')"
      by(simp add: freshChainSimps)
    moreover from S \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* (p \<bullet> xvec)\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close>
    have "A\<^sub>Q \<sharp>* (p \<bullet> Q')"
      by(simp add: freshChainSimps)

    moreover note \<open>xvec8 \<sharp>* \<Psi>\<close>

    moreover from \<open>xvec8 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* xvec8\<close>
    have "xvec8 \<sharp>* \<Psi>\<^sub>P"
      by simp (metis extractFrameFreshChain freshFrameDest)

    moreover from \<open>xvec8 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* xvec8\<close>
    have "xvec8 \<sharp>* \<Psi>\<^sub>Q"
      by simp (metis extractFrameFreshChain freshFrameDest)

    moreover from \<open>xvec8 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> have "xvec8 \<sharp>* P" by simp
    moreover from \<open>xvec8 \<sharp>* cP\<close> \<open>cP = P \<parallel> Q\<close> have "xvec8 \<sharp>* Q" by simp

    moreover note \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* M\<close>

    moreover note \<open>xvec8 \<sharp>* M\<close>

    moreover note \<open>A\<^sub>P \<sharp>* C\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>distinct xvec8\<close>

    ultimately show "cP = P \<parallel> Q \<and> cRs = \<exclamdown>M\<lparr>\<nu>*xvec8\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> (p \<bullet> P') \<parallel> (p \<bullet> Q') \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec8\<rparr>\<langle>(p \<bullet> N)\<rangle> \<prec> p \<bullet> P' \<and> extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and> distinct A\<^sub>P \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>(p \<bullet> N)\<rparr> \<prec> p \<bullet> Q' \<and> extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and> distinct A\<^sub>Q \<and>
      A\<^sub>P \<sharp>* \<Psi> \<and> A\<^sub>P \<sharp>* \<Psi>\<^sub>Q \<and> A\<^sub>P \<sharp>* P \<and> A\<^sub>P \<sharp>* (p \<bullet> N) \<and> A\<^sub>P \<sharp>* (p \<bullet> P') \<and> A\<^sub>P \<sharp>* Q \<and> A\<^sub>P \<sharp>* (p \<bullet> Q') \<and>
      A\<^sub>P \<sharp>* A\<^sub>Q \<and> A\<^sub>P \<sharp>* xvec8 \<and> A\<^sub>Q \<sharp>* \<Psi> \<and> A\<^sub>Q \<sharp>* \<Psi>\<^sub>P \<and> A\<^sub>Q \<sharp>* P \<and> A\<^sub>Q \<sharp>* (p \<bullet> N) \<and> A\<^sub>Q \<sharp>* (p \<bullet> P') \<and>
      A\<^sub>Q \<sharp>* Q \<and> A\<^sub>Q \<sharp>* (p \<bullet> Q') \<and> A\<^sub>Q \<sharp>* xvec8 \<and> xvec8 \<sharp>* \<Psi> \<and> xvec8 \<sharp>* \<Psi>\<^sub>P \<and> xvec8 \<sharp>* \<Psi>\<^sub>Q \<and> xvec8 \<sharp>* P \<and>
      xvec8 \<sharp>* Q \<and> A\<^sub>P \<sharp>* M \<and> A\<^sub>Q \<sharp>* M \<and> xvec8 \<sharp>* M \<and> A\<^sub>P \<sharp>* C \<and> A\<^sub>Q \<sharp>* C \<and> distinct xvec8" by blast
  qed
next
  case(cBrClose P M xvec N P' x)
  have B: "cP = \<lparr>\<nu>x\<rparr>P" and C: "cRs = \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P')"
    by fact+
  from \<open>x \<sharp> (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "x \<sharp> cP" and "x \<sharp> cRs" and "x \<noteq> x3" by simp+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* cP" and "xvec \<sharp>* cRs" and "x3 \<sharp> xvec" and "xvec \<sharp>* x3" by simp+

  obtain r::"name prm" where "(r \<bullet> xvec) \<sharp>* \<Psi>" and "(r \<bullet> xvec) \<sharp>* P" and "(r \<bullet> xvec) \<sharp>* M"
    and "(r \<bullet> xvec) \<sharp>* N" and "(r \<bullet> xvec) \<sharp>* P'" and "(r \<bullet> xvec) \<sharp>* x"
    and "(r \<bullet> xvec) \<sharp>* C" and "(r \<bullet> xvec) \<sharp>* x3"
    and "(r \<bullet> xvec) \<sharp>* ([(x, x3)] \<bullet> P)" and "(r \<bullet> xvec) \<sharp>* ([(x, x3)] \<bullet> M)"
    and Sr: "(set r) \<subseteq> (set xvec) \<times> (set(r \<bullet> xvec))" and "distinctPerm r"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, P, M, N, P', x, x3, ([(x, x3)] \<bullet> P), ([(x, x3)] \<bullet> P), C)"])
      (auto simp add: eqvts)
  from \<open>(r \<bullet> xvec) \<sharp>* x3\<close> have "x3 \<sharp> (r \<bullet> xvec)" by simp

  show ?thesis
  proof(rule rBrClose[where P="[(x, x3)] \<bullet> P" and M="[(x, x3)] \<bullet> M" and N="[(x, x3)] \<bullet> (r \<bullet> N)" and xvec="(r \<bullet> xvec)" and P'="[(x, x3)] \<bullet> (r \<bullet> P')"])
    assume "x3 \<sharp> \<Psi>" and "x3 \<sharp> cP" and "x3 \<sharp> cRs"
    with \<open>x3 \<sharp> xvec\<close> have "x3 \<notin> set xvec" by simp

    from \<open>x3 \<sharp> cRs\<close> C have "x3 \<sharp> (\<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))" by simp

    then have "x3 \<sharp> (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))" by simp
    with \<open>x \<noteq> x3\<close> have "x3 \<sharp> (\<lparr>\<nu>*xvec\<rparr>P')" by(simp add: psi.fresh abs_fresh)
    then have "(x3 \<in> set xvec) \<or> (x3 \<sharp> P')" by(simp add: resChainFresh)

    with \<open>x3 \<notin> set xvec\<close> have "x3 \<sharp> P'" by blast

    with \<open>x3 \<sharp> xvec\<close> \<open>x3 \<sharp> (r \<bullet> xvec)\<close> Sr have "x3 \<sharp> (r \<bullet> P')"
      by(simp add: freshChainSimps)

    from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>x3 \<sharp> cP\<close> \<open>x \<noteq> x3\<close> have cP_perm: "cP = \<lparr>\<nu>x3\<rparr>([(x, x3)] \<bullet> P)"
      by(simp add: alphaRes abs_fresh)
    from \<open>(r \<bullet> xvec) \<sharp>* P'\<close> Sr C
    have "cRs = \<tau> \<prec> \<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> P'))"
      by(simp add: resChainAlpha)
    moreover from \<open>x3 \<sharp> (r \<bullet> P')\<close>
    have "x3 \<sharp> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> P')"
      by(simp add: resChainFresh)
    ultimately have "cRs = \<tau> \<prec> \<lparr>\<nu>x3\<rparr>([(x, x3)] \<bullet> \<lparr>\<nu>*(r \<bullet> xvec)\<rparr>(r \<bullet> P'))" by(simp add: alphaRes)
    with \<open>(r \<bullet> xvec) \<sharp>* x\<close> \<open>(r \<bullet> xvec) \<sharp>* x3\<close>
    have cRs_perm: "cRs = \<tau> \<prec> \<lparr>\<nu>x3\<rparr>(\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>[(x, x3)] \<bullet> (r \<bullet> P'))"
      by(simp add: eqvts)

    from \<open>x \<in> supp M\<close>
    have supp_inc_perm: "x3 \<in> supp ([(x, x3)] \<bullet> M)"
      by (metis fresh_bij fresh_def swap_simps)

    from \<open>x \<sharp> xvec\<close> \<open>(r \<bullet> xvec) \<sharp>* x\<close> Sr have "r \<bullet> x = x" by simp

    from \<open>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> \<open>(r \<bullet> xvec) \<sharp>* N\<close> \<open>(r \<bullet> xvec) \<sharp>* P'\<close> Sr
    have "\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P')"
      by(simp add: boundOutputChainAlpha'' create_residual.simps)
    then have "[(x, x3)] \<bullet> (\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>(r \<bullet> N)\<rangle> \<prec> (r \<bullet> P'))"
      by(simp add: perm_bool)
    with \<open>x \<sharp> \<Psi>\<close> \<open>x3 \<sharp> \<Psi>\<close> \<open>(r \<bullet> xvec) \<sharp>* x\<close> \<open>x3 \<sharp> (r \<bullet> xvec)\<close>
    have trans_perm: "\<Psi> \<rhd> ([(x, x3)] \<bullet> P) \<longmapsto> \<exclamdown>([(x, x3)] \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>([(x, x3)] \<bullet> (r \<bullet> N))\<rangle> \<prec> ([(x, x3)] \<bullet> (r \<bullet> P'))"
      by(auto simp add: eqvts)

    from \<open>distinctPerm r\<close> \<open>distinct xvec\<close>
    have distinct_perm: "distinct (r \<bullet> xvec)" by simp

    note cP_perm cRs_perm supp_inc_perm trans_perm distinct_perm
      \<open>(r \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(r \<bullet> xvec) \<sharp>* ([(x, x3)] \<bullet> P)\<close> \<open>(r \<bullet> xvec) \<sharp>* ([(x, x3)] \<bullet> M)\<close>
      \<open>(r \<bullet> xvec) \<sharp>* C\<close> \<open>x3 \<sharp> \<Psi>\<close> \<open>x3 \<sharp> (r \<bullet> xvec)\<close>

    then show "cP = \<lparr>\<nu>x3\<rparr>([(x, x3)] \<bullet> P) \<and> cRs = \<tau> \<prec> \<lparr>\<nu>x3\<rparr>(\<lparr>\<nu>*r \<bullet> xvec\<rparr>[(x, x3)] \<bullet> r \<bullet> P') \<and>
      x3 \<in> supp ([(x, x3)] \<bullet> M) \<and>
      \<Psi> \<rhd> [(x, x3)] \<bullet> P \<longmapsto> \<exclamdown>([(x, x3)] \<bullet> M)\<lparr>\<nu>*(r \<bullet> xvec)\<rparr>\<langle>([(x, x3)] \<bullet> r \<bullet> N)\<rangle> \<prec> [(x, x3)] \<bullet> r \<bullet> P' \<and>
      distinct (r \<bullet> xvec) \<and> (r \<bullet> xvec) \<sharp>* \<Psi> \<and> (r \<bullet> xvec) \<sharp>* ([(x, x3)] \<bullet> P) \<and>
      (r \<bullet> xvec) \<sharp>* ([(x, x3)] \<bullet> M) \<and> (r \<bullet> xvec) \<sharp>* C \<and> x3 \<sharp> \<Psi> \<and> x3 \<sharp> r \<bullet> xvec"
      by simp
  qed
next
  case(cOpen P M xvec yvec N P' x)
  have B: "cP = \<lparr>\<nu>x\<rparr>P" and C: "cRs = M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
    by fact+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* xvec4" and "xvec \<sharp>* cP" and "xvec \<sharp>* cRs" and "x1 \<sharp> xvec" by simp+
  from \<open>x \<sharp> (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "x \<sharp> xvec4" and "x \<sharp> cP" and "x \<sharp> cRs" and "x \<noteq> x1" by simp+
  from \<open>yvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "yvec \<sharp>* xvec4" and "yvec \<sharp>* cP"  and "yvec \<sharp>* cRs" and "x1 \<sharp> yvec" by simp+

  from \<open>xvec \<sharp>* cRs\<close> \<open>x \<sharp> cRs\<close> \<open>yvec \<sharp>* cRs\<close> C have "(xvec@x#yvec) \<sharp>* M" by simp
  from \<open>xvec \<sharp>* \<Psi>\<close> \<open>x \<sharp> \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> have "(xvec@x#yvec) \<sharp>* \<Psi>" by simp
  from \<open>length xvec4 = residualLength cRs\<close> C obtain xvec' y yvec' where D: "xvec4 = xvec'@y#yvec'" and "length xvec' = length xvec" and "length yvec' = length yvec"
    by(auto intro: lengthAux2)
  with \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* xvec4\<close> \<open>yvec \<sharp>* xvec4\<close> \<open>x \<sharp> xvec4\<close> \<open>distinct xvec4\<close>
  have "distinct xvec'" and "distinct yvec'" and "xvec' \<sharp>* yvec'" and "x \<noteq> y" and "y \<sharp> xvec'" and "y \<sharp> yvec'"
    and "x \<sharp> xvec'" and "x \<sharp> yvec'" and "y \<sharp> xvec" and "y \<sharp> yvec" and "xvec \<sharp>* xvec'" and "yvec \<sharp>* yvec'"
    by auto
  from \<open>length xvec' = length xvec\<close> \<open>xvec \<sharp>* xvec'\<close> \<open>distinct xvec\<close> \<open>distinct xvec'\<close>
  obtain p where Sp: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)" and "distinctPerm p" and E: "xvec' = p \<bullet> xvec"
    by(metis constructPerm)
  from \<open>length yvec' = length yvec\<close> \<open>yvec \<sharp>* yvec'\<close> \<open>distinct yvec\<close> \<open>distinct yvec'\<close>
  obtain q where Sq: "set q \<subseteq> set yvec \<times> set(q \<bullet> yvec)" and "distinctPerm q" and F: "yvec' = q \<bullet> yvec"
    by(metis constructPerm)

  show ?thesis
  proof(rule rOpen[where P="([(x, x1)] \<bullet> P)" and xvec="p \<bullet> xvec" and y="y" and yvec="q \<bullet> yvec" and N="(p@(x1, x)#q) \<bullet> N" and P'="(p@(x1, x)#q) \<bullet> P'" and M=M])
    assume "xvec4 \<sharp>* \<Psi>" and "xvec4 \<sharp>* cP" and "xvec4 \<sharp>* cRs" and "x1 \<sharp> \<Psi>" and "x1 \<sharp> cP" and "x1 \<sharp> cRs" and "x1 \<sharp> xvec4"
    from \<open>xvec \<sharp>* xvec4\<close> \<open>x \<sharp> xvec4\<close> \<open>x1 \<sharp> xvec4\<close> \<open>yvec \<sharp>* xvec4\<close> D E F
    have "x \<noteq> y" and "x1 \<noteq> y" and "x1 \<sharp> p \<bullet> xvec" and "x1 \<sharp> q \<bullet> yvec" by simp+
    from \<open>xvec4 \<sharp>* cRs\<close> \<open>x1 \<sharp> cRs\<close> C have "xvec4 \<sharp>* M" and "x1 \<sharp> M" by simp+
    moreover from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>x \<sharp> cP\<close> \<open>x \<noteq> x1\<close> have "([(x, x1)] \<bullet> cP) = [(x, x1)] \<bullet> \<lparr>\<nu>x\<rparr>P"
      by simp
    with \<open>x \<sharp> cP\<close> \<open>x1 \<sharp> cP\<close> have "cP = \<lparr>\<nu>x1\<rparr>([(x, x1)] \<bullet> P)" by(simp add: eqvts calc_atm)
    moreover from C have "((p@(x1, x)#q) \<bullet> cRs) = (p@(x1, x)#q) \<bullet> (M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P')" by(simp add: fresh_star_bij)
    with Sp Sq \<open>xvec4 \<sharp>* cRs\<close> D E F \<open>xvec \<sharp>* cRs\<close> \<open>x \<sharp> cRs\<close> \<open>yvec \<sharp>* cRs\<close> \<open>xvec4 \<sharp>* M\<close> \<open>(xvec@x#yvec) \<sharp>* M\<close> \<open>xvec \<sharp>* xvec4\<close> \<open>x \<sharp> xvec4\<close> \<open>yvec \<sharp>* xvec4\<close> \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>y \<sharp> xvec'\<close> \<open>y \<sharp> yvec'\<close> \<open>xvec' \<sharp>* yvec'\<close> \<open>x1 \<sharp> xvec\<close> \<open>x1 \<sharp> yvec\<close> \<open>x1 \<noteq> y\<close> \<open>x1 \<sharp> xvec4\<close> \<open>x1 \<sharp> cRs\<close> \<open>x1 \<sharp> cRs\<close> \<open>x \<noteq> x1\<close> \<open>x1 \<sharp> M\<close>
    have "cRs = M\<lparr>\<nu>*((p \<bullet> xvec)@x1#(q \<bullet> yvec))\<rparr>\<langle>((p@(x1, x)#q) \<bullet> N)\<rangle> \<prec> ((p@(x1, x)#q) \<bullet> P')"
      by(simp add: eqvts pt2[OF pt_name_inst] calc_atm)
    moreover from D E F have "xvec4 = (p \<bullet> xvec)@y#(q \<bullet> yvec)" by simp
    moreover from \<open>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "((p@(x1, x)#q) \<bullet> \<Psi>) \<rhd> ((p@(x1, x)#q) \<bullet> P) \<longmapsto>((p@(x1, x)#q) \<bullet> (M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'))"
      by(intro eqvts)
    with Sp Sq B C D E F \<open>xvec4 \<sharp>* \<Psi>\<close> \<open>(xvec@x#yvec) \<sharp>* \<Psi>\<close> \<open>xvec4 \<sharp>* cRs\<close> \<open>x \<sharp> xvec4\<close> C D \<open>x \<sharp> cRs\<close> \<open>yvec \<sharp>* cRs\<close> \<open>xvec4 \<sharp>* M\<close> \<open>(xvec@x#yvec) \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>x1 \<sharp> cRs\<close> \<open>x \<noteq> x1\<close> \<open>x1 \<sharp> xvec\<close> \<open>x1 \<sharp> yvec\<close> \<open>xvec \<sharp>* xvec4\<close> \<open>yvec \<sharp>* xvec4\<close> \<open>x1 \<sharp> xvec4\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x1 \<sharp> \<Psi>\<close> \<open>xvec4 \<sharp>* cP\<close> \<open>xvec \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>xvec' \<sharp>* yvec'\<close> \<open>x1 \<sharp> xvec4\<close> \<open>xvec4 \<sharp>* cP\<close> \<open>yvec \<sharp>* xvec4\<close> \<open>xvec \<sharp>* xvec4\<close> \<open>x \<noteq> x1\<close> \<open>xvec \<sharp>* yvec\<close>
    have "\<Psi> \<rhd> ([(x, x1)] \<bullet> P) \<longmapsto>M\<lparr>\<nu>*((p \<bullet> xvec)@(q \<bullet> yvec))\<rparr>\<langle>((p@(x1, x)#q) \<bullet> N)\<rangle> \<prec> ((p@(x1, x)#q) \<bullet> P')"
      by(simp add: eqvts  pt_fresh_bij[OF pt_name_inst, OF at_name_inst] pt2[OF pt_name_inst] name_swap)

    moreover from \<open>x \<in> supp N\<close> have "((p@(x1, x)#q) \<bullet> x) \<in> ((p@(x1, x)#q) \<bullet> supp N)"
      by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
    then have "x1 \<in> supp((p@(x1, x)#q) \<bullet> N)"
      using \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x1 \<sharp> xvec\<close> \<open>x1 \<sharp> yvec\<close> \<open>x \<sharp> xvec4\<close> \<open>x1 \<sharp> xvec4\<close> \<open>xvec \<sharp>* xvec4\<close> \<open>yvec \<sharp>* xvec4\<close> \<open>xvec' \<sharp>* yvec'\<close> D E F Sp Sq \<open>x \<noteq> x1\<close>
      by(simp add: eqvts pt2[OF pt_name_inst] calc_atm)
    moreover from \<open>x1 \<sharp> xvec4\<close> D E F have "x1 \<sharp> (p \<bullet> xvec)" and "x1 \<sharp> (q \<bullet> yvec)" by simp+
    moreover from \<open>distinct xvec'\<close> \<open>distinct yvec'\<close> E F have "distinct(p \<bullet> xvec)" and "distinct(q \<bullet> yvec)" by simp+
    moreover from \<open>xvec' \<sharp>* yvec'\<close> E F have "(p \<bullet> xvec) \<sharp>* (q \<bullet> yvec)" by auto
    moreover from \<open>xvec \<sharp>* \<Psi>\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>)" by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
    with Sp D E \<open>xvec4 \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* \<Psi>\<close> have "(p \<bullet> xvec) \<sharp>* \<Psi>" by(simp add: eqvts)
    moreover from \<open>yvec \<sharp>* \<Psi>\<close> have "(p \<bullet> yvec) \<sharp>* (p \<bullet> \<Psi>)" by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
    with Sq D F \<open>xvec4 \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> have "(q \<bullet> yvec) \<sharp>* \<Psi>" by(simp add: eqvts)
    moreover from \<open>xvec4 \<sharp>* cP\<close> \<open>x \<sharp> xvec4\<close> \<open>x1 \<sharp> xvec4\<close> B D E F have "(p \<bullet> xvec) \<sharp>* ([(x, x1)] \<bullet> P)" and "(q \<bullet> yvec) \<sharp>* ([(x, x1)] \<bullet> P)"
      by simp+
    moreover from \<open>xvec4 \<sharp>* M\<close> C D E F have "(p \<bullet> xvec) \<sharp>* M" and "(q \<bullet> yvec) \<sharp>* M" by simp+
    ultimately show "cP = \<lparr>\<nu>x1\<rparr>([(x, x1)] \<bullet> P) \<and>
      cRs = M\<lparr>\<nu>*(p \<bullet> xvec @ x1 # q \<bullet> yvec)\<rparr>\<langle>((p @ (x1, x) # q) \<bullet> N)\<rangle> \<prec> (p @ (x1, x) # q) \<bullet> P' \<and>
      xvec4 = p \<bullet> xvec @ y # q \<bullet> yvec \<and>
      \<Psi> \<rhd> [(x, x1)] \<bullet> P \<longmapsto> M\<lparr>\<nu>*(p \<bullet> xvec @ q \<bullet> yvec)\<rparr>\<langle>((p @ (x1, x) # q) \<bullet> N)\<rangle> \<prec> (p @ (x1, x) # q) \<bullet> P' \<and>
      x1 \<in> supp ((p @ (x1, x) # q) \<bullet> N) \<and>
      x1 \<sharp> p \<bullet> xvec \<and>
      x1 \<sharp> q \<bullet> yvec \<and>
      distinct (p \<bullet> xvec) \<and>
      distinct (q \<bullet> yvec) \<and>
      (p \<bullet> xvec) \<sharp>* \<Psi> \<and>
      (p \<bullet> xvec) \<sharp>* ([(x, x1)] \<bullet> P) \<and>
      (p \<bullet> xvec) \<sharp>* M \<and>
      (p \<bullet> xvec) \<sharp>* (q \<bullet> yvec) \<and>
      (q \<bullet> yvec) \<sharp>* \<Psi> \<and>
      (q \<bullet> yvec) \<sharp>* ([(x, x1)] \<bullet> P) \<and>
      (q \<bullet> yvec) \<sharp>* M"
      by blast
  qed
next
  case(cBrOpen P M xvec yvec N P' x)
  have B: "cP = \<lparr>\<nu>x\<rparr>P" and C: "cRs = \<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P'"
    by fact+
  from \<open>xvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "xvec \<sharp>* xvec9" and "xvec \<sharp>* cP" and "xvec \<sharp>* cRs" and "x4 \<sharp> xvec" by simp+
  from \<open>x \<sharp> (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "x \<sharp> xvec9" and "x \<sharp> cP" and "x \<sharp> cRs" and "x \<noteq> x4" by simp+
  from \<open>yvec \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "yvec \<sharp>* xvec9" and "yvec \<sharp>* cP"  and "yvec \<sharp>* cRs" and "x4 \<sharp> yvec" by simp+

  from \<open>xvec \<sharp>* cRs\<close> \<open>x \<sharp> cRs\<close> \<open>yvec \<sharp>* cRs\<close> C have "(xvec@x#yvec) \<sharp>* M" by simp
  from \<open>xvec \<sharp>* \<Psi>\<close> \<open>x \<sharp> \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> have "(xvec@x#yvec) \<sharp>* \<Psi>" by simp
  from \<open>length xvec9 = residualLength cRs\<close> C obtain xvec' y yvec' where D: "xvec9 = xvec'@y#yvec'" and "length xvec' = length xvec" and "length yvec' = length yvec"
    by(auto intro: lengthAux2)
  with \<open>distinct xvec\<close> \<open>distinct yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>xvec \<sharp>* yvec\<close> \<open>xvec \<sharp>* xvec9\<close> \<open>yvec \<sharp>* xvec9\<close> \<open>x \<sharp> xvec9\<close> \<open>distinct xvec9\<close>
  have "distinct xvec'" and "distinct yvec'" and "xvec' \<sharp>* yvec'" and "x \<noteq> y" and "y \<sharp> xvec'" and "y \<sharp> yvec'"
    and "x \<sharp> xvec'" and "x \<sharp> yvec'" and "y \<sharp> xvec" and "y \<sharp> yvec" and "xvec \<sharp>* xvec'" and "yvec \<sharp>* yvec'"
    by auto
  from \<open>length xvec' = length xvec\<close> \<open>xvec \<sharp>* xvec'\<close> \<open>distinct xvec\<close> \<open>distinct xvec'\<close>
  obtain p where Sp: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)" and "distinctPerm p" and E: "xvec' = p \<bullet> xvec"
    by(metis constructPerm)
  from \<open>length yvec' = length yvec\<close> \<open>yvec \<sharp>* yvec'\<close> \<open>distinct yvec\<close> \<open>distinct yvec'\<close>
  obtain q where Sq: "set q \<subseteq> set yvec \<times> set(q \<bullet> yvec)" and "distinctPerm q" and F: "yvec' = q \<bullet> yvec"
    by(metis constructPerm)

  show ?thesis
  proof(rule rBrOpen[where P="([(x, x4)] \<bullet> P)" and xvec="p \<bullet> xvec" and y="y" and yvec="q \<bullet> yvec" and N="(p@(x4, x)#q) \<bullet> N" and P'="(p@(x4, x)#q) \<bullet> P'" and M=M])
    assume "xvec9 \<sharp>* \<Psi>" and "xvec9 \<sharp>* cP" and "xvec9 \<sharp>* cRs" and "x4 \<sharp> \<Psi>" and "x4 \<sharp> cP" and "x4 \<sharp> cRs" and "x4 \<sharp> xvec9"
    from \<open>xvec \<sharp>* xvec9\<close> \<open>x \<sharp> xvec9\<close> \<open>x4 \<sharp> xvec9\<close> \<open>yvec \<sharp>* xvec9\<close> D E F
    have "x \<noteq> y" and "x4 \<noteq> y" and "x4 \<sharp> p \<bullet> xvec" and "x4 \<sharp> q \<bullet> yvec" by simp+
    from \<open>xvec9 \<sharp>* cRs\<close> \<open>x4 \<sharp> cRs\<close> C have "xvec9 \<sharp>* M" and "x4 \<sharp> M" by simp+
    moreover from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>x \<sharp> cP\<close> \<open>x \<noteq> x4\<close> have "([(x, x4)] \<bullet> cP) = [(x, x4)] \<bullet> \<lparr>\<nu>x\<rparr>P"
      by simp
    with \<open>x \<sharp> cP\<close> \<open>x4 \<sharp> cP\<close> have "cP = \<lparr>\<nu>x4\<rparr>([(x, x4)] \<bullet> P)" by(simp add: eqvts calc_atm)
    moreover from C have "((p@(x4, x)#q) \<bullet> cRs) = (p@(x4, x)#q) \<bullet> (\<exclamdown>M\<lparr>\<nu>*(xvec@x#yvec)\<rparr>\<langle>N\<rangle> \<prec> P')" by(simp add: fresh_star_bij)
    with Sp Sq \<open>xvec9 \<sharp>* cRs\<close> D E F \<open>xvec \<sharp>* cRs\<close> \<open>x \<sharp> cRs\<close> \<open>yvec \<sharp>* cRs\<close> \<open>xvec9 \<sharp>* M\<close> \<open>(xvec@x#yvec) \<sharp>* M\<close> \<open>xvec \<sharp>* xvec9\<close> \<open>x \<sharp> xvec9\<close> \<open>yvec \<sharp>* xvec9\<close> \<open>xvec \<sharp>* yvec\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>y \<sharp> xvec'\<close> \<open>y \<sharp> yvec'\<close> \<open>xvec' \<sharp>* yvec'\<close> \<open>x4 \<sharp> xvec\<close> \<open>x4 \<sharp> yvec\<close> \<open>x4 \<noteq> y\<close> \<open>x4 \<sharp> xvec9\<close> \<open>x4 \<sharp> cRs\<close> \<open>x4 \<sharp> cRs\<close> \<open>x \<noteq> x4\<close> \<open>x4 \<sharp> M\<close>
    have "cRs = \<exclamdown>M\<lparr>\<nu>*((p \<bullet> xvec)@x4#(q \<bullet> yvec))\<rparr>\<langle>((p@(x4, x)#q) \<bullet> N)\<rangle> \<prec> ((p@(x4, x)#q) \<bullet> P')"
      by(simp add: eqvts pt2[OF pt_name_inst] calc_atm)
    moreover from D E F have "xvec9 = (p \<bullet> xvec)@y#(q \<bullet> yvec)" by simp
    moreover from \<open>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "((p@(x4, x)#q) \<bullet> \<Psi>) \<rhd> ((p@(x4, x)#q) \<bullet> P) \<longmapsto>((p@(x4, x)#q) \<bullet> (\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'))"
      by(intro eqvts)
    with Sp Sq B C D E F \<open>xvec9 \<sharp>* \<Psi>\<close> \<open>(xvec@x#yvec) \<sharp>* \<Psi>\<close> \<open>xvec9 \<sharp>* cRs\<close> \<open>x \<sharp> xvec9\<close> C D \<open>x \<sharp> cRs\<close> \<open>yvec \<sharp>* cRs\<close> \<open>xvec9 \<sharp>* M\<close> \<open>(xvec@x#yvec) \<sharp>* M\<close> \<open>x \<sharp> M\<close> \<open>x4 \<sharp> cRs\<close> \<open>x \<noteq> x4\<close> \<open>x4 \<sharp> xvec\<close> \<open>x4 \<sharp> yvec\<close> \<open>xvec \<sharp>* xvec9\<close> \<open>yvec \<sharp>* xvec9\<close> \<open>x4 \<sharp> xvec9\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x4 \<sharp> \<Psi>\<close> \<open>xvec9 \<sharp>* cP\<close> \<open>xvec \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>xvec' \<sharp>* yvec'\<close> \<open>x4 \<sharp> xvec9\<close> \<open>xvec9 \<sharp>* cP\<close> \<open>yvec \<sharp>* xvec9\<close> \<open>xvec \<sharp>* xvec9\<close> \<open>x \<noteq> x4\<close> \<open>xvec \<sharp>* yvec\<close>
    have "\<Psi> \<rhd> ([(x, x4)] \<bullet> P) \<longmapsto>\<exclamdown>M\<lparr>\<nu>*((p \<bullet> xvec)@(q \<bullet> yvec))\<rparr>\<langle>((p@(x4, x)#q) \<bullet> N)\<rangle> \<prec> ((p@(x4, x)#q) \<bullet> P')"
      by(simp add: eqvts  pt_fresh_bij[OF pt_name_inst, OF at_name_inst] pt2[OF pt_name_inst] name_swap)

    moreover from \<open>x \<in> supp N\<close> have "((p@(x4, x)#q) \<bullet> x) \<in> ((p@(x4, x)#q) \<bullet> supp N)"
      by(simp add: pt_set_bij[OF pt_name_inst, OF at_name_inst])
    then have "x4 \<in> supp((p@(x4, x)#q) \<bullet> N)"
      using \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> \<open>x4 \<sharp> xvec\<close> \<open>x4 \<sharp> yvec\<close> \<open>x \<sharp> xvec9\<close> \<open>x4 \<sharp> xvec9\<close> \<open>xvec \<sharp>* xvec9\<close> \<open>yvec \<sharp>* xvec9\<close> \<open>xvec' \<sharp>* yvec'\<close> D E F Sp Sq \<open>x \<noteq> x4\<close>
      by(simp add: eqvts pt2[OF pt_name_inst] calc_atm)
    moreover from \<open>x4 \<sharp> xvec9\<close> D E F have "x4 \<sharp> (p \<bullet> xvec)" and "x4 \<sharp> (q \<bullet> yvec)" by simp+
    moreover from \<open>distinct xvec'\<close> \<open>distinct yvec'\<close> E F have "distinct(p \<bullet> xvec)" and "distinct(q \<bullet> yvec)" by simp+
    moreover from \<open>xvec' \<sharp>* yvec'\<close> E F have "(p \<bullet> xvec) \<sharp>* (q \<bullet> yvec)" by auto
    moreover from \<open>xvec \<sharp>* \<Psi>\<close> have "(p \<bullet> xvec) \<sharp>* (p \<bullet> \<Psi>)" by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
    with Sp D E \<open>xvec9 \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* \<Psi>\<close> have "(p \<bullet> xvec) \<sharp>* \<Psi>" by(simp add: eqvts)
    moreover from \<open>yvec \<sharp>* \<Psi>\<close> have "(p \<bullet> yvec) \<sharp>* (p \<bullet> \<Psi>)" by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
    with Sq D F \<open>xvec9 \<sharp>* \<Psi>\<close> \<open>yvec \<sharp>* \<Psi>\<close> have "(q \<bullet> yvec) \<sharp>* \<Psi>" by(simp add: eqvts)
    moreover from \<open>xvec9 \<sharp>* cP\<close> \<open>x \<sharp> xvec9\<close> \<open>x4 \<sharp> xvec9\<close> B D E F have "(p \<bullet> xvec) \<sharp>* ([(x, x4)] \<bullet> P)" and "(q \<bullet> yvec) \<sharp>* ([(x, x4)] \<bullet> P)"
      by simp+
    moreover from \<open>xvec9 \<sharp>* M\<close> C D E F have "(p \<bullet> xvec) \<sharp>* M" and "(q \<bullet> yvec) \<sharp>* M" by simp+
    ultimately show "cP = \<lparr>\<nu>x4\<rparr>([(x, x4)] \<bullet> P) \<and>
      cRs = \<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec @ x4 # q \<bullet> yvec)\<rparr>\<langle>((p @ (x4, x) # q) \<bullet> N)\<rangle> \<prec> (p @ (x4, x) # q) \<bullet> P' \<and>
      xvec9 = p \<bullet> xvec @ y # q \<bullet> yvec \<and>
      \<Psi> \<rhd> [(x, x4)] \<bullet> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*(p \<bullet> xvec @ q \<bullet> yvec)\<rparr>\<langle>((p @ (x4, x) # q) \<bullet> N)\<rangle> \<prec> (p @ (x4, x) # q) \<bullet> P' \<and>
      x4 \<in> supp ((p @ (x4, x) # q) \<bullet> N) \<and>
      x4 \<sharp> p \<bullet> xvec \<and>
      x4 \<sharp> q \<bullet> yvec \<and>
      distinct (p \<bullet> xvec) \<and>
      distinct (q \<bullet> yvec) \<and>
      (p \<bullet> xvec) \<sharp>* \<Psi> \<and>
      (p \<bullet> xvec) \<sharp>* ([(x, x4)] \<bullet> P) \<and>
      (p \<bullet> xvec) \<sharp>* M \<and>
      (p \<bullet> xvec) \<sharp>* (q \<bullet> yvec) \<and>
      (q \<bullet> yvec) \<sharp>* \<Psi> \<and>
      (q \<bullet> yvec) \<sharp>* ([(x, x4)] \<bullet> P) \<and>
      (q \<bullet> yvec) \<sharp>* M"
      by blast
  qed
next
  case(cScope P \<alpha> P' x)
  have B: "cP = \<lparr>\<nu>x\<rparr>P" and C: "cRs = \<alpha> \<prec> \<lparr>\<nu>x\<rparr>P'"
    by fact+
  from \<open>bn \<alpha> \<sharp>* (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "bn \<alpha> \<sharp>* xvec5" and "x2 \<sharp> bn \<alpha>" by simp+
  from \<open>x \<sharp> (xvec1, xvec2, xvec3, xvec4, xvec5, xvec6, xvec7, xvec8, xvec9, x1, x2, x3, x4, cP, cRs, C)\<close> have "x \<sharp> xvec5" and "x \<noteq> x2" and "x \<sharp> cRs" by simp+

  from \<open>length xvec5 = residualLength cRs\<close> C have "length xvec5 = length(bn \<alpha>)"
    by simp
  then obtain p where S: "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" and "distinctPerm p" and "xvec5= bn(p \<bullet> \<alpha>)"
    using \<open>bn \<alpha> \<sharp>* xvec5\<close> \<open>distinct(bn \<alpha>)\<close> \<open>distinct xvec5\<close>
    by - (rule constructPerm[where xvec="bn \<alpha>" and yvec=xvec5], auto simp add: eqvts)
  show ?thesis
  proof(rule rScope[where P="[(x, x2)] \<bullet> P" and \<alpha>="[(x, x2)] \<bullet> p \<bullet> \<alpha>" and P'="[(x, x2)] \<bullet> p \<bullet> P'"])
    assume "xvec5 \<sharp>* \<Psi>" and "xvec5 \<sharp>* cP" and "xvec5 \<sharp>* cRs" and "x2 \<sharp> \<Psi>" and "x2 \<sharp> cP" and "x2 \<sharp> cRs" and "x2 \<sharp> xvec5"
    from \<open>x2 \<sharp> cRs\<close> C \<open>x2 \<sharp> bn \<alpha>\<close> \<open>x \<noteq> x2\<close> have "x2 \<sharp> \<alpha>" and "x2 \<sharp> P'" by(auto simp add: abs_fresh)
    moreover from \<open>cP = \<lparr>\<nu>x\<rparr>P\<close> \<open>x2 \<sharp> cP\<close> \<open>x \<noteq> x2\<close> have "cP = \<lparr>\<nu>x2\<rparr>([(x, x2)] \<bullet> P)"
      by(simp add: alphaRes abs_fresh)
    moreover from B C S \<open>bn \<alpha> \<sharp>* xvec5\<close> \<open>xvec5 \<sharp>* cRs\<close> \<open>xvec5 = bn(p \<bullet> \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>xvec5 \<sharp>* cP\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> xvec5\<close>
    have "cRs = (p \<bullet> \<alpha>) \<prec> \<lparr>\<nu>x\<rparr>(p \<bullet> P')"
      apply clarsimp
      by(subst residualAlpha[where p=p] alphaRes) (auto simp del: actionFresh)
    then have "([(x, x2)] \<bullet> cRs) = [(x, x2)] \<bullet> ((p \<bullet> \<alpha>) \<prec> \<lparr>\<nu>x\<rparr>(p \<bullet> P'))"
      by simp
    with \<open>x2 \<sharp> cRs\<close> \<open>x \<sharp> cRs\<close> have "cRs = ([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<prec> \<lparr>\<nu>x2\<rparr>([(x, x2)] \<bullet> p \<bullet> P')"
      by(simp add: eqvts calc_atm)
    moreover from \<open>xvec5= bn(p \<bullet> \<alpha>)\<close> have "([(x, x2)] \<bullet> xvec5) = ([(x, x2)] \<bullet> bn(p \<bullet> \<alpha>))"
      by simp
    with \<open>x \<sharp> xvec5\<close> \<open>x2 \<sharp> xvec5\<close> have "xvec5 = bn([(x, x2)] \<bullet> p \<bullet> \<alpha>)"
      by(simp add: eqvts)
    moreover from \<open>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<close> S B C S \<open>bn \<alpha> \<sharp>* xvec5\<close> \<open>xvec5 \<sharp>* cRs\<close> \<open>xvec5 = bn(p \<bullet> \<alpha>)\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>xvec5 \<sharp>* cP\<close> \<open>x \<sharp> xvec5\<close>
    have "\<Psi> \<rhd> P \<longmapsto>(p \<bullet> \<alpha>) \<prec> (p \<bullet> P')"
      by(subst residualAlpha[symmetric]) auto
    then have "([(x, x2)] \<bullet> \<Psi>) \<rhd> ([(x, x2)] \<bullet> P) \<longmapsto>([(x, x2)] \<bullet> ((p \<bullet> \<alpha>) \<prec> (p \<bullet> P')))"
      by(rule eqvt)
    with \<open>x \<sharp> \<Psi>\<close> \<open>x2 \<sharp> \<Psi>\<close> have "\<Psi> \<rhd> ([(x, x2)] \<bullet> P) \<longmapsto>([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<prec> ([(x, x2)] \<bullet> p \<bullet> P')"
      by(simp add: eqvts)
    moreover note \<open>x2 \<sharp> \<Psi>\<close>
    moreover from \<open>x \<sharp> \<alpha>\<close> \<open>x2 \<sharp> \<alpha>\<close> \<open>x \<sharp> xvec5\<close> \<open>x2 \<sharp> xvec5\<close> S \<open>x \<noteq> x2\<close> \<open>xvec5 = bn(p \<bullet> \<alpha>)\<close> have "x2 \<sharp> [(x, x2)] \<bullet> p \<bullet> \<alpha>"
      apply(subgoal_tac "x \<sharp> p \<and> x2 \<sharp> p")
       apply(simp add: perm_compose freshChainSimps del: actionFresh)
      by(auto dest: freshAlphaSwap)
    moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "([(x, x2)] \<bullet> p \<bullet> (bn \<alpha>)) \<sharp>* ([(x, x2)] \<bullet> p \<bullet> (subject \<alpha>))"
      by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
    then have "bn([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<sharp>* subject([(x, x2)] \<bullet> p \<bullet> \<alpha>)"
      by(simp add: eqvts)
    moreover from \<open>distinct(bn \<alpha>)\<close> have "distinct([(x, x2)] \<bullet> p \<bullet> (bn \<alpha>))" by simp
    then have "distinct(bn([(x, x2)] \<bullet> p \<bullet> \<alpha>))" by(simp add: eqvts)
    ultimately show "cP = \<lparr>\<nu>x2\<rparr>([(x, x2)] \<bullet> P) \<and>
      cRs = ([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<prec> \<lparr>\<nu>x2\<rparr>([(x, x2)] \<bullet> p \<bullet> P') \<and>
      xvec5 = bn ([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<and>
      \<Psi> \<rhd> [(x, x2)] \<bullet> P \<longmapsto> ([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<prec> [(x, x2)] \<bullet> p \<bullet> P' \<and>
      x2 \<sharp> \<Psi> \<and>
      x2 \<sharp> [(x, x2)] \<bullet> p \<bullet> \<alpha> \<and>
      bn ([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<sharp>* subject ([(x, x2)] \<bullet> p \<bullet> \<alpha>) \<and>
      distinct (bn ([(x, x2)] \<bullet> p \<bullet> \<alpha>))" by blast
  qed
next
  case(cBang P)
  then show ?thesis by(auto intro: rBang)
qed

lemma resResidEq:
  fixes xvec :: "name list"
    and P    :: "('a, 'b, 'c) psi"
    and Q    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and N    :: 'a
    and N'   :: 'a

assumes "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle> \<prec> Q"
  and   "xvec \<sharp>* M"

shows "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>"
  using assms
proof(induct xvec)
  case Nil
  then show ?case by(simp add: residualInject)
next
  case (Cons x xvec)
  from \<open>(x # xvec) \<sharp>* M\<close>
  have "x \<sharp> M" and "xvec \<sharp>* M" by simp+
  from \<open>\<exclamdown>M\<lparr>\<nu>*(x # xvec)\<rparr>\<langle>N\<rangle> \<prec> P = \<exclamdown>M\<lparr>\<nu>*(x # xvec)\<rparr>\<langle>N'\<rangle> \<prec> Q\<close> \<open>x \<sharp> M\<close>
  have "\<exclamdown>M\<lparr>\<nu>*(xvec)\<rparr>\<langle>N\<rangle> \<prec> P = \<exclamdown>M\<lparr>\<nu>*(xvec)\<rparr>\<langle>N'\<rangle> \<prec> Q"
    by (metis action.inject(4) assms(1) bn.simps(4) residualInject'')
  then have "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>" using \<open>xvec \<sharp>* M\<close>
    by(rule Cons(1))
  then show ?case
    by(simp add: action.inject)
qed

lemma parCases[consumes 5, case_names cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and Q    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and T    :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"
    and M    :: 'a
    and N    :: 'a

assumes Trans: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> T"
  and   "bn \<alpha> \<sharp>* \<Psi>"
  and   "bn \<alpha> \<sharp>* P"
  and   "bn \<alpha> \<sharp>* Q"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   rPar1: "\<And>P' A\<^sub>Q \<Psi>\<^sub>Q. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P';  extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                                  A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* P'; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow> Prop \<alpha> (P' \<parallel> Q)"
  and   rPar2: "\<And>Q' A\<^sub>P \<Psi>\<^sub>P. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q';  extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                                 A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop \<alpha> (P \<parallel> Q')"
  and   rComm1: "\<And>\<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P K xvec Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec; \<alpha> = \<tau>;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* M;  A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P;  A\<^sub>Q \<sharp>* K;  A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;  xvec \<sharp>* M;  xvec \<sharp>* K; xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q;  xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
            Prop (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rComm2: "\<And>\<Psi>\<^sub>Q M xvec N P' A\<^sub>P \<Psi>\<^sub>P K Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; distinct xvec; \<alpha> = \<tau>;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* M;  A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P;  A\<^sub>Q \<sharp>* K;  A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;  xvec \<sharp>* M;  xvec \<sharp>* K;  xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q;  xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
            Prop (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rBrMerge: "\<And>\<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; \<alpha> = \<questiondown>M\<lparr>N\<rparr>\<rbrakk> \<Longrightarrow>
                    Prop (\<questiondown>M\<lparr>N\<rparr>) (P' \<parallel> Q')"
  and   rBrComm1: "\<And>\<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P xvec Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            distinct xvec;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M; \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> = \<alpha>;
            xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* \<Psi>\<^sub>Q\<rbrakk> \<Longrightarrow>
            Prop (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
  and   rBrComm2: "\<And>\<Psi>\<^sub>Q M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            distinct xvec;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M; \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> = \<alpha>;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q\<rbrakk> \<Longrightarrow>
            Prop (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"

shows "Prop \<alpha> T"
proof -
  from Trans have "distinct(bn \<alpha>)" by(auto dest: boundOutputDistinct)
  have "length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)" by simp
  note Trans
  moreover have "length [] = inputLength(P \<parallel> Q)" and "distinct []"
    by(auto simp add: inputLength_inputLength'_inputLength''.simps)
  moreover have "length [] = inputLength(P \<parallel> Q)" and "distinct []"
    by(auto simp add: inputLength_inputLength'_inputLength''.simps)
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> T)\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover obtain x::name where "x \<sharp> \<Psi>" and "x \<sharp> P" and "x \<sharp> Q" and "x \<sharp> \<alpha>" and "x \<sharp> T"
    by(generate_fresh "name") auto
  ultimately show ?thesis using \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>
  proof(cases rule: semanticsCases[of _ _ _ _ _ _ _ _ _ _ _ _ _ C x x x x])
    case cInput
    then show ?thesis
      by(simp add: residualInject)
  next
    case cBrInput
    then show ?thesis
      by(simp add: residualInject)
  next
    case cOutput
    then show ?thesis
      by(simp add: residualInject)
  next
    case cBrOutput
    then show ?thesis
      by(simp add: residualInject)
  next
    case cCase
    then show ?thesis
      by(simp add: residualInject)
  next
    case (cPar1 \<Psi>\<^sub>Q P \<alpha>' P' Q A\<^sub>Q)
    then show ?thesis using assms
      by(force simp add: psi.inject residualInject residualInject' intro: rPar1)
  next
    case (cPar2 \<Psi>\<^sub>P Q \<alpha>' Q' P A\<^sub>P)
    then show ?thesis using assms
      by(force simp add: psi.inject residualInject residualInject' intro: rPar1)
  next
    case cComm1
    then show ?thesis using assms
      by(force simp add: psi.inject residualInject residualInject' intro: rComm1)
  next
    case cComm2
    then show ?thesis using assms
      by(force simp add: psi.inject residualInject residualInject' intro: rComm2)
  next
    case cBrMerge
    then show ?thesis using assms
      by(force simp add: psi.inject residualInject residualInject' intro: rBrMerge)
  next
    case (cBrComm1 \<Psi>\<^sub>Q P1 M N P' A\<^sub>P \<Psi>\<^sub>P Q1 Q' A\<^sub>Q)
    note \<open>bn \<alpha> \<sharp>* \<Psi>\<close>
    moreover from \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> have "bn \<alpha> \<sharp>* (P \<parallel> Q)" by simp
    moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> T)" by simp
    ultimately have all:
      "P \<parallel> Q = P1 \<parallel> Q1 \<and>
      \<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q' \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P1 \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P' \<and>
      extractFrame P1 = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and>
      distinct A\<^sub>P \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q1 \<longmapsto> \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> Q' \<and>
      extractFrame Q1 = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and>
      distinct A\<^sub>Q \<and>
      A\<^sub>P \<sharp>* \<Psi> \<and>
      A\<^sub>P \<sharp>* \<Psi>\<^sub>Q \<and>
      A\<^sub>P \<sharp>* P1 \<and>
      A\<^sub>P \<sharp>* N \<and>
      A\<^sub>P \<sharp>* P' \<and>
      A\<^sub>P \<sharp>* Q1 \<and>
      A\<^sub>P \<sharp>* Q' \<and>
      A\<^sub>P \<sharp>* A\<^sub>Q \<and>
      A\<^sub>P \<sharp>* bn \<alpha> \<and>
      A\<^sub>Q \<sharp>* \<Psi> \<and>
      A\<^sub>Q \<sharp>* \<Psi>\<^sub>P \<and>
      A\<^sub>Q \<sharp>* P1 \<and>
      A\<^sub>Q \<sharp>* N \<and>
      A\<^sub>Q \<sharp>* P' \<and>
      A\<^sub>Q \<sharp>* Q1 \<and>
      A\<^sub>Q \<sharp>* Q' \<and>
      A\<^sub>Q \<sharp>* bn \<alpha> \<and>
      bn \<alpha> \<sharp>* \<Psi> \<and>
      bn \<alpha> \<sharp>* \<Psi>\<^sub>P \<and>
      bn \<alpha> \<sharp>* \<Psi>\<^sub>Q \<and>
      bn \<alpha> \<sharp>* P1 \<and>
      bn \<alpha> \<sharp>* Q1 \<and>
      A\<^sub>P \<sharp>* M \<and> A\<^sub>Q \<sharp>* M \<and> bn \<alpha> \<sharp>* M \<and> A\<^sub>P \<sharp>* C \<and> A\<^sub>Q \<sharp>* C \<and> distinct (bn \<alpha>)"
      by(rule cBrComm1(1))

    from all have "bn \<alpha> \<sharp>* M" and "\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
      by simp+

    from \<open>\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'\<close> have "\<alpha> \<prec> T = RBrOut M (\<lparr>\<nu>*bn \<alpha>\<rparr>N \<prec>' (P' \<parallel> Q'))"
      by(simp add: residualInject)

    then obtain xvec N' where "\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>"
      by(auto simp add: residualInject)
    then have "bn \<alpha> = xvec" by simp
    from \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>\<close> \<open>\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'\<close> have resEq: "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
      by simp
    then have "\<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N'\<rangle> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'" using \<open>bn \<alpha> = xvec\<close>
      by simp
    then have "\<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N'\<rangle> = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle>" using \<open>bn \<alpha> \<sharp>* M\<close>
      by(rule resResidEq)
    with \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>\<close> have "\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" by simp

    moreover from all have "P \<parallel> Q = P1 \<parallel> Q1"
      and "\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
      and "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P1 \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'"
      and "extractFrame P1 = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and "distinct A\<^sub>P"
      and "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q1 \<longmapsto> \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> Q'"
      and "extractFrame Q1 = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and "distinct A\<^sub>Q"
      and "A\<^sub>P \<sharp>* \<Psi>"
      and "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
      and "A\<^sub>P \<sharp>* P1"
      and "A\<^sub>P \<sharp>* N"
      and "A\<^sub>P \<sharp>* P'"
      and "A\<^sub>P \<sharp>* Q1"
      and "A\<^sub>P \<sharp>* Q'"
      and "A\<^sub>P \<sharp>* A\<^sub>Q"
      and "A\<^sub>P \<sharp>* bn \<alpha>"
      and "A\<^sub>Q \<sharp>* \<Psi>"
      and "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
      and "A\<^sub>Q \<sharp>* P1"
      and "A\<^sub>Q \<sharp>* N"
      and "A\<^sub>Q \<sharp>* P'"
      and "A\<^sub>Q \<sharp>* Q1"
      and "A\<^sub>Q \<sharp>* Q'"
      and "A\<^sub>Q \<sharp>* bn \<alpha>"
      and "bn \<alpha> \<sharp>* \<Psi>"
      and "bn \<alpha> \<sharp>* \<Psi>\<^sub>P"
      and "bn \<alpha> \<sharp>* \<Psi>\<^sub>Q"
      and "bn \<alpha> \<sharp>* P1"
      and "bn \<alpha> \<sharp>* Q1"
      and "A\<^sub>P \<sharp>* M"
      and "A\<^sub>Q \<sharp>* M"
      and "bn \<alpha> \<sharp>* M"
      and "A\<^sub>P \<sharp>* C"
      and "A\<^sub>Q \<sharp>* C"
      and "distinct (bn \<alpha>)"
      by auto

    moreover then have "P = P1" and "Q = Q1"
      by(auto simp add: psi.inject)

    ultimately have "Prop (\<exclamdown>M\<lparr>\<nu>*(bn \<alpha>)\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
      by(force intro: rBrComm1)
    then show ?thesis using \<open>\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'\<close>[symmetric]
      by(force simp add: residualInject)
  next
    case (cBrComm2 \<Psi>\<^sub>Q P1 M N P' A\<^sub>P \<Psi>\<^sub>P Q1 Q' A\<^sub>Q)
    note \<open>bn \<alpha> \<sharp>* \<Psi>\<close>
    moreover from \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> have "bn \<alpha> \<sharp>* (P \<parallel> Q)" by simp
    moreover from \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> have "bn \<alpha> \<sharp>* (\<alpha> \<prec> T)" by simp
    ultimately have all:
      "P \<parallel> Q = P1 \<parallel> Q1 \<and>
      \<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q' \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P1 \<longmapsto> \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<and>
      extractFrame P1 = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle> \<and>
      distinct A\<^sub>P \<and>
      \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q1 \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q' \<and>
      extractFrame Q1 = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle> \<and>
      distinct A\<^sub>Q \<and>
      A\<^sub>P \<sharp>* \<Psi> \<and>
      A\<^sub>P \<sharp>* \<Psi>\<^sub>Q \<and>
      A\<^sub>P \<sharp>* P1 \<and>
      A\<^sub>P \<sharp>* N \<and>
      A\<^sub>P \<sharp>* P' \<and>
      A\<^sub>P \<sharp>* Q1 \<and>
      A\<^sub>P \<sharp>* Q' \<and>
      A\<^sub>P \<sharp>* A\<^sub>Q \<and>
      A\<^sub>P \<sharp>* bn \<alpha> \<and>
      A\<^sub>Q \<sharp>* \<Psi> \<and>
      A\<^sub>Q \<sharp>* \<Psi>\<^sub>P \<and>
      A\<^sub>Q \<sharp>* P1 \<and>
      A\<^sub>Q \<sharp>* N \<and>
      A\<^sub>Q \<sharp>* P' \<and>
      A\<^sub>Q \<sharp>* Q1 \<and>
      A\<^sub>Q \<sharp>* Q' \<and>
      A\<^sub>Q \<sharp>* bn \<alpha> \<and>
      bn \<alpha> \<sharp>* \<Psi> \<and>
      bn \<alpha> \<sharp>* \<Psi>\<^sub>P \<and>
      bn \<alpha> \<sharp>* \<Psi>\<^sub>Q \<and>
      bn \<alpha> \<sharp>* P1 \<and>
      bn \<alpha> \<sharp>* Q1 \<and>
      A\<^sub>P \<sharp>* M \<and> A\<^sub>Q \<sharp>* M \<and> bn \<alpha> \<sharp>* M \<and> A\<^sub>P \<sharp>* C \<and> A\<^sub>Q \<sharp>* C \<and> distinct (bn \<alpha>)"
      by(rule cBrComm2(1))

    from all have "bn \<alpha> \<sharp>* M" and "\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
      by simp+

    from \<open>\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'\<close> have "\<alpha> \<prec> T = RBrOut M (\<lparr>\<nu>*bn \<alpha>\<rparr>N \<prec>' (P' \<parallel> Q'))"
      by(simp add: residualInject)

    then obtain xvec N' where "\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>"
      by(auto simp add: residualInject)
    then have "bn \<alpha> = xvec" by simp
    from \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>\<close> \<open>\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'\<close> have resEq: "\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
      by simp
    then have "\<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N'\<rangle> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'" using \<open>bn \<alpha> = xvec\<close>
      by simp
    then have "\<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N'\<rangle> = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle>" using \<open>bn \<alpha> \<sharp>* M\<close>
      by(rule resResidEq)
    with \<open>\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N'\<rangle>\<close> have "\<alpha> = \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" by simp
    moreover from all have "P \<parallel> Q = P1 \<parallel> Q1"
      and "\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'"
      and "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P1 \<longmapsto> \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P'"
      and "extractFrame P1 = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
      and "distinct A\<^sub>P"
      and "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q1 \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'"
      and "extractFrame Q1 = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
      and "distinct A\<^sub>Q"
      and "A\<^sub>P \<sharp>* \<Psi>"
      and "A\<^sub>P \<sharp>* \<Psi>\<^sub>Q"
      and "A\<^sub>P \<sharp>* P1"
      and "A\<^sub>P \<sharp>* N"
      and "A\<^sub>P \<sharp>* P'"
      and "A\<^sub>P \<sharp>* Q1"
      and "A\<^sub>P \<sharp>* Q'"
      and "A\<^sub>P \<sharp>* A\<^sub>Q"
      and "A\<^sub>P \<sharp>* bn \<alpha>"
      and "A\<^sub>Q \<sharp>* \<Psi>"
      and "A\<^sub>Q \<sharp>* \<Psi>\<^sub>P"
      and "A\<^sub>Q \<sharp>* P1"
      and "A\<^sub>Q \<sharp>* N"
      and "A\<^sub>Q \<sharp>* P'"
      and "A\<^sub>Q \<sharp>* Q1"
      and "A\<^sub>Q \<sharp>* Q'"
      and "A\<^sub>Q \<sharp>* bn \<alpha>"
      and "bn \<alpha> \<sharp>* \<Psi>"
      and "bn \<alpha> \<sharp>* \<Psi>\<^sub>P"
      and "bn \<alpha> \<sharp>* \<Psi>\<^sub>Q"
      and "bn \<alpha> \<sharp>* P1"
      and "bn \<alpha> \<sharp>* Q1"
      and "A\<^sub>P \<sharp>* M"
      and "A\<^sub>Q \<sharp>* M"
      and "bn \<alpha> \<sharp>* M"
      and "A\<^sub>P \<sharp>* C"
      and "A\<^sub>Q \<sharp>* C"
      and "distinct (bn \<alpha>)"
      by auto

    moreover then have "P = P1" and "Q = Q1"
      by(auto simp add: psi.inject)

    ultimately have "Prop (\<exclamdown>M\<lparr>\<nu>*(bn \<alpha>)\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
      by(force intro: rBrComm2)
    then show ?thesis using \<open>\<alpha> \<prec> T = \<exclamdown>M\<lparr>\<nu>*bn \<alpha>\<rparr>\<langle>N\<rangle> \<prec> P' \<parallel> Q'\<close>[symmetric]
      by(force simp add: residualInject)
  next
    case cBrClose
    then show ?thesis using \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> P\<close> \<open>x \<sharp> Q\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> T\<close>
      by(simp add: residualInject)
  next
    case cOpen
    then show ?thesis using assms \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> P\<close> \<open>x \<sharp> Q\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> T\<close>
      by(simp add: residualInject)
  next
    case cBrOpen
    then show ?thesis using assms \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> P\<close> \<open>x \<sharp> Q\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> T\<close>
      by(simp add: residualInject)
  next
    case cScope
    then show ?thesis using assms \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> P\<close> \<open>x \<sharp> Q\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> T\<close>
      by(simp add: residualInject)
  next
    case cBang
    then show ?thesis
      by(simp add: residualInject)
  qed
qed

lemma parInputCases[consumes 1, case_names cPar1 cPar2]:
  fixes \<Psi> :: 'b
    and P :: "('a, 'b, 'c) psi"
    and Q :: "('a, 'b, 'c) psi"
    and M :: 'a
    and N :: 'a
    and R :: "('a, 'b, 'c) psi"
    and C :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>M\<lparr>N\<rparr> \<prec> R"
  and   rPar1: "\<And>P' A\<^sub>Q \<Psi>\<^sub>Q. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P';  extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                       A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow> Prop (P' \<parallel> Q)"
  and   rPar2: "\<And>Q' A\<^sub>P \<Psi>\<^sub>P. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>N\<rparr> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                       A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop (P \<parallel> Q')"
shows "Prop R"
proof -
  from Trans obtain \<alpha> where "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> R" and "bn \<alpha> \<sharp>* \<Psi>" and "bn \<alpha> \<sharp>* P" and "bn \<alpha> \<sharp>* Q" and "bn \<alpha> \<sharp>* subject \<alpha>" and "\<alpha> = M\<lparr>N\<rparr>" by auto
  then show ?thesis using rPar1 rPar2
    by(induct rule: parCases) (auto simp add: residualInject)
qed

lemma parBrInputCases[consumes 1, case_names cPar1 cPar2 cBrMerge]:
  fixes \<Psi> :: 'b
    and P :: "('a, 'b, 'c) psi"
    and Q :: "('a, 'b, 'c) psi"
    and M :: 'a
    and N :: 'a
    and R :: "('a, 'b, 'c) psi"
    and C :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> R"
  and   rPar1: "\<And>P' A\<^sub>Q \<Psi>\<^sub>Q. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P';  extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                       A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow> Prop (P' \<parallel> Q)"
  and   rPar2: "\<And>Q' A\<^sub>P \<Psi>\<^sub>P. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                       A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop (P \<parallel> Q')"
  and   rBrMerge: "\<And>\<Psi>\<^sub>Q P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow>
                    Prop (P' \<parallel> Q')"
shows "Prop R"
proof -
  from Trans obtain \<alpha> where "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> R" and "bn \<alpha> \<sharp>* \<Psi>" and "bn \<alpha> \<sharp>* P" and "bn \<alpha> \<sharp>* Q" and "bn \<alpha> \<sharp>* subject \<alpha>" and "\<alpha> = \<questiondown>M\<lparr>N\<rparr>" by auto
  then show ?thesis using rPar1 rPar2 rBrMerge
    by(induct rule: parCases) (auto simp add: residualInject action.inject)
qed

lemma parOutputCases[consumes 5, case_names cPar1 cPar2]:
  fixes \<Psi> :: 'b
    and P :: "('a, 'b, 'c) psi"
    and Q :: "('a, 'b, 'c) psi"
    and M :: 'a
    and xvec :: "name list"
    and N :: 'a
    and R :: "('a, 'b, 'c) psi"
    and C :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> R"
  and          "xvec \<sharp>* \<Psi>"
  and          "xvec \<sharp>* P"
  and          "xvec \<sharp>* Q"
  and          "xvec \<sharp>* M"
  and   rPar1: "\<And>P' A\<^sub>Q \<Psi>\<^sub>Q. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';  extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                       A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* C; A\<^sub>Q \<sharp>* xvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (P' \<parallel> Q)"
  and   rPar2: "\<And>Q' A\<^sub>P \<Psi>\<^sub>P. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                       A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* C; A\<^sub>P \<sharp>* xvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (P \<parallel> Q')"
shows "Prop R"
proof -
  from Trans have "distinct xvec" by(auto dest: boundOutputDistinct)
  obtain \<alpha> where "\<alpha>=M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" by simp
  with Trans \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close> \<open>xvec \<sharp>* M\<close>
  have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> R" and "bn \<alpha> \<sharp>* \<Psi>" and "bn \<alpha> \<sharp>* P" and "bn \<alpha> \<sharp>* Q" "bn \<alpha> \<sharp>* subject \<alpha>"
    by simp+
  then show ?thesis using \<open>\<alpha>=M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> rPar1 rPar2 \<open>distinct xvec\<close>
    by(induct rule: parCases[where C="(xvec, C)"]) (auto simp add: residualInject)
qed

lemma parBrOutputCases[consumes 5, case_names cPar1 cPar2 cBrComm1 cBrComm2]:
  fixes \<Psi> :: 'b
    and P :: "('a, 'b, 'c) psi"
    and Q :: "('a, 'b, 'c) psi"
    and M :: 'a
    and xvec :: "name list"
    and N :: 'a
    and R :: "('a, 'b, 'c) psi"
    and C :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> R"
  and          "xvec \<sharp>* \<Psi>"
  and          "xvec \<sharp>* P"
  and          "xvec \<sharp>* Q"
  and          "xvec \<sharp>* M"
  and   rPar1: "\<And>P' A\<^sub>Q \<Psi>\<^sub>Q. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';  extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                       A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* xvec; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* C; A\<^sub>Q \<sharp>* xvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (P' \<parallel> Q)"
  and   rPar2: "\<And>Q' A\<^sub>P \<Psi>\<^sub>P. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                       A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* xvec; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* C; A\<^sub>P \<sharp>* xvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (P \<parallel> Q')"
  and   rBrComm1: "\<And>\<Psi>\<^sub>Q P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            distinct xvec;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
            xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* \<Psi>\<^sub>Q\<rbrakk> \<Longrightarrow>
            Prop (P' \<parallel> Q')"
  and   rBrComm2: "\<And>\<Psi>\<^sub>Q P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            distinct xvec;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q\<rbrakk> \<Longrightarrow>
            Prop (P' \<parallel> Q')"
shows "Prop R"
proof -
  from Trans have "distinct xvec" by(auto dest: boundOutputDistinct)
  obtain \<alpha> where "\<alpha>=\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>" by simp
  with Trans \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* Q\<close> \<open>xvec \<sharp>* M\<close>
  have "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> R" and "bn \<alpha> \<sharp>* \<Psi>" and "bn \<alpha> \<sharp>* P" and "bn \<alpha> \<sharp>* Q" "bn \<alpha> \<sharp>* subject \<alpha>"
    by simp+
  then show ?thesis using \<open>\<alpha>=\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>\<close> rPar1 rPar2 rBrComm1 rBrComm2 \<open>distinct xvec\<close>
    by(induct rule: parCases[where C="(xvec, C)"]) (auto simp add: residualInject action.inject)
qed

lemma theEqvt[eqvt_force]:
  fixes p :: "name prm"
    and \<alpha> :: "'a action"

assumes "\<alpha> \<noteq> \<tau>"

shows "(p \<bullet> the(subject \<alpha>)) = the(p \<bullet> (subject \<alpha>))"
  using assms
  by(induct rule: actionCases[where \<alpha>=\<alpha>]) auto

lemma theSubjectFresh[simp]:
  fixes \<alpha> :: "'a action"
    and x :: name

assumes "\<alpha> \<noteq> \<tau>"

shows "x \<sharp> the(subject \<alpha>) = x \<sharp> subject \<alpha>"
  using assms
  by(cases rule: actionCases) auto

lemma theSubjectFreshChain[simp]:
  fixes \<alpha>    :: "'a action"
    and xvec :: "name list"

assumes "\<alpha> \<noteq> \<tau>"

shows "xvec \<sharp>* the(subject \<alpha>) = xvec \<sharp>* subject \<alpha>"
  using assms
  by(cases rule: actionCases) auto

lemma inputObtainPrefix:
  fixes \<Psi> :: 'b
    and P   :: "('a, 'b, 'c) psi"
    and P'  :: "('a, 'b, 'c) psi"
    and A\<^sub>P  :: "name list"
    and \<Psi>\<^sub>P :: 'b
    and N   :: 'a
    and K   :: 'a
    and B   :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   "B \<sharp>* P"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* B"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* K"

obtains M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
  using assms
proof(nominal_induct avoiding: B arbitrary: thesis rule: inputFrameInduct)
  case(cAlpha \<Psi> P K N P' A\<^sub>P \<Psi>\<^sub>P p B)
  then obtain M where subjEq: "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by(auto intro: cAlpha)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M\<close>
  have "p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M)" by simp
  with \<open>set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P)\<close>
    \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* K\<close>
  have permEq: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<turnstile> K \<leftrightarrow> (p \<bullet> M)" by(simp add: eqvts)
  from \<open>B \<sharp>* M\<close> have "p \<bullet> (B \<sharp>* M)" by simp
  with \<open>set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P)\<close>
    \<open>A\<^sub>P \<sharp>* B\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* B\<close>
  have permFresh: "B \<sharp>* (p \<bullet> M)" by(simp add: eqvts)

  show ?case using cAlpha permEq permFresh
    by auto
next
  case(cInput \<Psi> M K xvec N Tvec P B)
  from \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "\<Psi> \<otimes> \<one> \<turnstile> M \<leftrightarrow> K"
    by(blast intro: statEqEnt AssertionStatEqSym[OF Identity])
  then have "\<Psi> \<otimes> \<one> \<turnstile> K \<leftrightarrow> M" by(rule chanEqSym)
  moreover from \<open>B \<sharp>* (M\<lparr>\<lambda>*xvec N\<rparr>.P)\<close> have "B \<sharp>* M" by simp
  ultimately show ?case by(auto intro: cInput)
next
  case(cCase \<Psi> P K N P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P B)
  then obtain M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by - (rule cCase, auto dest: memFreshChain)
  with \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> show ?case by(blast intro: cCase statEqEnt compositionSym Identity)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P K N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P B)
  then obtain M where "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by (metis freshCompChain(1) psiFreshVec(4))
  then show ?case
    by(metis cPar1 statEqEnt Associativity Commutativity AssertionStatEqTrans Composition)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q K N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q B)
  then obtain M where "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by - (rule cPar2, auto)
  then show ?case by(metis cPar2 statEqEnt Associativity)
next
  case(cScope \<Psi> P K N P' x A\<^sub>P \<Psi>\<^sub>P B)
  then obtain M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by - (rule cScope, auto)
  then show ?case by(auto intro: cScope)
next
  case(cBang \<Psi> P K N P' A\<^sub>P \<Psi>\<^sub>P B)
  then obtain M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<one> \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by - (rule cBang, auto)
  with \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> show ?case by(metis cBang statEqEnt compositionSym Identity)
qed

lemma outputObtainPrefix:
  fixes \<Psi> :: 'b
    and P   :: "('a, 'b, 'c) psi"
    and P'  :: "('a, 'b, 'c) psi"
    and A\<^sub>P  :: "name list"
    and \<Psi>\<^sub>P :: 'b
    and N   :: 'a
    and K   :: 'a
    and xvec :: "name list"
    and B   :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto> ROut K (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P')"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   "xvec \<sharp>* K"
  and   "distinct xvec"
  and   "B \<sharp>* P"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* B"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* K"

obtains M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
  using assms
proof(nominal_induct avoiding: B xvec arbitrary: thesis rule: outputFrameInduct)
  case(cAlpha \<Psi> P K A\<^sub>P \<Psi>\<^sub>P p \<alpha> B xvec)
  then obtain M where subjEq: "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by(auto intro: cAlpha)

  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M\<close>
  have "p \<bullet> (\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M)" by simp

  with \<open>set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P)\<close>
    \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* K\<close>
  have permEq: "\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<turnstile> K \<leftrightarrow> (p \<bullet> M)" by(simp add: eqvts)

  from \<open>B \<sharp>* M\<close> have "p \<bullet> (B \<sharp>* M)" by simp
  with \<open>set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P)\<close>
    \<open>A\<^sub>P \<sharp>* B\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* B\<close>
  have permFresh: "B \<sharp>* (p \<bullet> M)" by(simp add: eqvts)

  show ?case using cAlpha permEq permFresh
    by auto
next
  case(cOutput \<Psi> M K N P B xvec)
  from \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "\<Psi> \<otimes> \<one> \<turnstile> M \<leftrightarrow> K"
    by(blast intro: statEqEnt AssertionStatEqSym[OF Identity])
  then have "\<Psi> \<otimes> \<one> \<turnstile> K \<leftrightarrow> M"
    by(rule chanEqSym)
  moreover from \<open>B \<sharp>* (M\<langle>N\<rangle>.P)\<close> have "B \<sharp>* M" by simp
  ultimately show ?case by(auto intro: cOutput)
next
  case(cCase \<Psi> P K P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P B xvec)
  then obtain M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by - (rule cCase, auto dest: memFreshChain)
  with \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> show ?case by(blast intro: cCase statEqEnt compositionSym Identity)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P K yvec N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P B xvec)
  then obtain M where "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by (metis freshCompChain(1) psiFreshVec(4))
  then show ?case by(metis cPar1 statEqEnt Associativity Commutativity AssertionStatEqTrans Composition)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q K yvec N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q B xvec)
  then obtain M where "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by (metis freshCompChain(1) psiFreshVec(4))
  then show ?case by(metis cPar2 statEqEnt Associativity)
next
  case(cOpen \<Psi> P M zvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P B xvec)
  then obtain K where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K" and "B \<sharp>* K"
    by (metis abs_fresh_list_star' psiFreshVec(5))
  then show ?case by(auto intro: cOpen)
next
  case(cScope \<Psi> P K yvec N P' x A\<^sub>P \<Psi>\<^sub>P B xvec)
  then obtain M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by (metis abs_fresh_list_star' psiFreshVec(5))
  then show ?case by(auto intro: cScope)
next
  case(cBang \<Psi> P K P' A\<^sub>P \<Psi>\<^sub>P B xvec)
  then obtain M where "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<one> \<turnstile> K \<leftrightarrow> M" and "B \<sharp>* M"
    by - (rule cBang, auto)
  with \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> show ?case by(metis cBang statEqEnt compositionSym Identity)
qed

lemma inputRenameSubject:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and M  :: 'a
    and N  :: 'a
    and P' :: "('a, 'b, 'c) psi"
    and A\<^sub>P :: "name list"
    and \<Psi>\<^sub>P :: 'b

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* K"

shows "\<Psi> \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'"
  using assms
proof(nominal_induct avoiding: K rule: inputFrameInduct)
  case(cAlpha \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P  p K)
  have S: "set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P)" by fact
  from \<open>\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<turnstile> M \<leftrightarrow> K\<close> have "(p \<bullet> (\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P))) \<turnstile> (p \<bullet> M) \<leftrightarrow> (p \<bullet> K)"
    by(rule chanEqClosed)
  with S \<open>distinctPerm p\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* K\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K" by(simp add: eqvts)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'\<close>
  show ?case by blast
next
  case(cInput \<Psi> M K xvec N Tvec P K')
  from \<open>\<Psi> \<otimes> \<one> \<turnstile> K \<leftrightarrow> K'\<close> have "\<Psi> \<turnstile> K \<leftrightarrow> K'"
    by(blast intro: statEqEnt Identity)
  with \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "\<Psi> \<turnstile> M \<leftrightarrow> K'"
    by(rule chanEqTrans)
  then show ?case using \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    by(rule Input)
next
  case(cCase \<Psi> P M N P' \<phi> Cs A\<^sub>P \<Psi>\<^sub>P K)
  from \<open>\<Psi> \<otimes> \<one> \<turnstile> M \<leftrightarrow> K\<close> \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K"
    by(blast intro: statEqEnt Identity compositionSym AssertionStatEqSym)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'\<close>
  have "\<Psi> \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'" by force
  then show ?case using \<open>(\<phi>, P) \<in> set Cs\<close> \<open>\<Psi> \<turnstile> \<phi>\<close> \<open>guarded P\<close> by(rule Case)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P K)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K"
    by(metis statEqEnt Associativity Composition AssertionStatEqTrans Commutativity)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* (\<Psi> \<otimes> \<Psi>\<^sub>Q); A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'" by force
  then show ?case using \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>A\<^sub>Q \<sharp>* N\<close>
    by(auto intro: Par1)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q K)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K"
    by(rule statEqEnt[OF AssertionStatEqSym[OF Associativity]])
  with \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; A\<^sub>Q \<sharp>* (\<Psi> \<otimes> \<Psi>\<^sub>P); A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'" by force
  then show ?case using \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* K\<close> \<open>A\<^sub>P \<sharp>* N\<close>
    by(auto intro: Par2)
next
  case(cScope \<Psi> P M N P' x A\<^sub>P \<Psi>\<^sub>P)
  then have "\<Psi> \<rhd> P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'" by force
  with \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> K\<close> \<open>x \<sharp> N\<close> show ?case
    by(auto intro: Scope)
next
  case(cBang \<Psi> P M N P' A\<^sub>P \<Psi>\<^sub>P K)
  from \<open>\<Psi> \<otimes> \<one> \<turnstile> M \<leftrightarrow> K\<close> \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<one> \<turnstile> M \<leftrightarrow> K"
    by(blast intro: statEqEnt Identity compositionSym AssertionStatEqSym)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<one> \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* (P \<parallel> !P); A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> P \<parallel> !P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'\<close>
  have "\<Psi> \<rhd> P \<parallel> !P \<longmapsto>K\<lparr>N\<rparr> \<prec> P'" by force
  then show ?case using \<open>guarded P\<close> by(rule Bang)
qed

lemma outputRenameSubject:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P   :: 'b

assumes "\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K"
  and   "A\<^sub>P \<sharp>* \<Psi>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* M"
  and   "A\<^sub>P \<sharp>* K"

shows "\<Psi> \<rhd> P \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'"
  using assms unfolding residualInject
proof(nominal_induct avoiding: K rule: outputFrameInduct)
  case(cAlpha \<Psi> P M A\<^sub>P \<Psi>\<^sub>P p B K)
  have S: "set p \<subseteq> set A\<^sub>P \<times> set(p \<bullet> A\<^sub>P)" by fact
  from \<open>\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P) \<turnstile> M \<leftrightarrow> K\<close> have "(p \<bullet> (\<Psi> \<otimes> (p \<bullet> \<Psi>\<^sub>P))) \<turnstile> (p \<bullet> M) \<leftrightarrow> (p \<bullet> K)"
    by(rule chanEqClosed)
  with S \<open>distinctPerm p\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* M\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* K\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K" by(simp add: eqvts)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
  show ?case by(blast intro: cAlpha)
next
  case(cOutput \<Psi> M K N P K')
  from \<open>\<Psi> \<otimes> \<one> \<turnstile> K \<leftrightarrow> K'\<close> have "\<Psi> \<turnstile> K \<leftrightarrow> K'"
    by(blast intro: statEqEnt Identity)
  with \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "\<Psi> \<turnstile> M \<leftrightarrow> K'"
    by(rule chanEqTrans)
  then show ?case using Output by(force simp add: residualInject)
next
  case(cCase \<Psi> P M B \<phi> Cs A\<^sub>P \<Psi>\<^sub>P K)
  from \<open>\<Psi> \<otimes> \<one> \<turnstile> M \<leftrightarrow> K\<close> \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K"
    by(blast intro: statEqEnt Identity compositionSym AssertionStatEqSym)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> P \<longmapsto>(ROut K B)\<close>
  have "\<Psi> \<rhd> P \<longmapsto>ROut K B" by force
  then show ?case using \<open>(\<phi>, P) \<in> set Cs\<close> \<open>\<Psi> \<turnstile> \<phi>\<close> \<open>guarded P\<close> by(rule Case)
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>Q Q A\<^sub>P \<Psi>\<^sub>P K)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K"
    by(metis statEqEnt Associativity Composition AssertionStatEqTrans Commutativity)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* (\<Psi> \<otimes> \<Psi>\<^sub>Q); A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>(ROut K (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P'))\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by(force simp add: residualInject)
  then show ?case using \<open>extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>\<close> \<open>xvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* K\<close>  \<open>A\<^sub>Q \<sharp>* xvec\<close>  \<open>A\<^sub>Q \<sharp>* N\<close> Par1[where \<alpha>="K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>"]
    by(auto simp add: residualInject)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M xvec N Q' A\<^sub>P P A\<^sub>Q \<Psi>\<^sub>Q K)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K\<close> have "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K"
    by(rule statEqEnt[OF AssertionStatEqSym[OF Associativity]])
  with \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M\<close> \<open>A\<^sub>Q \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; A\<^sub>Q \<sharp>* (\<Psi> \<otimes> \<Psi>\<^sub>P); A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* M; A\<^sub>Q \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>ROut K (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q')\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>ROut K (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q')" by force
  then show ?case using \<open>extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>\<close> \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* K\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* N\<close> Par2[where \<alpha>="K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>"]
    by(auto simp add: residualInject)
next
  case(cOpen \<Psi> P M xvec yvec N P' x A\<^sub>P \<Psi>\<^sub>P)
  then have "\<Psi> \<rhd> P \<longmapsto>K\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'" by(force simp add: residualInject)
  with \<open>x \<in> supp N\<close> \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> K\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> yvec\<close> Open show ?case
    by(auto simp add: residualInject)
next
  case(cScope \<Psi> P M xvec N P' x A\<^sub>P \<Psi>\<^sub>P)
  then have "\<Psi> \<rhd> P \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" by(force simp add: residualInject)
  with \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> K\<close> \<open>x \<sharp> xvec\<close> \<open>x \<sharp> N\<close> Scope[where \<alpha>="K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>"] show ?case
    by(auto simp add: residualInject)
next
  case(cBang \<Psi> P M B A\<^sub>P \<Psi>\<^sub>P K)
  from \<open>\<Psi> \<otimes> \<one> \<turnstile> M \<leftrightarrow> K\<close> \<open>\<Psi>\<^sub>P \<simeq> \<one>\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<one> \<turnstile> M \<leftrightarrow> K"
    by(blast intro: statEqEnt Identity compositionSym AssertionStatEqSym)
  with \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K\<close>
    \<open>\<And>K. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<one> \<turnstile> M \<leftrightarrow> K; A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* (P \<parallel> !P); A\<^sub>P \<sharp>* M; A\<^sub>P \<sharp>* K\<rbrakk> \<Longrightarrow> \<Psi> \<rhd> P \<parallel> !P \<longmapsto>ROut K B\<close>
  have "\<Psi> \<rhd> P \<parallel> !P \<longmapsto>ROut K B" by force
  then show ?case using \<open>guarded P\<close> by(rule Bang)
qed

lemma parCasesSubject[consumes 7, case_names cPar1 cPar2 cComm1 cComm2 cBrMerge cBrComm1 cBrComm2]:
  fixes \<Psi>    :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and Q    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and R    :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"
    and yvec :: "name list"

assumes Trans: "\<Psi> \<rhd> P \<parallel> Q \<longmapsto>\<alpha> \<prec> R"
  and          "bn \<alpha> \<sharp>* \<Psi>"
  and          "bn \<alpha> \<sharp>* P"
  and          "bn \<alpha> \<sharp>* Q"
  and          "bn \<alpha> \<sharp>* subject \<alpha>"
  and          "yvec \<sharp>* P"
  and          "yvec \<sharp>* Q"
  and   rPar1: "\<And>P' A\<^sub>Q \<Psi>\<^sub>Q. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<alpha> \<prec> P';  extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                       A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* \<alpha>; A\<^sub>Q \<sharp>* C\<rbrakk> \<Longrightarrow> Prop \<alpha> (P' \<parallel> Q)"
  and   rPar2: "\<And>Q' A\<^sub>P \<Psi>\<^sub>P. \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<alpha> \<prec> Q'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                       A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* \<alpha>; A\<^sub>P \<sharp>* C\<rbrakk> \<Longrightarrow> Prop \<alpha> (P \<parallel> Q')"
  and   rComm1: "\<And>\<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P K xvec Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; yvec \<sharp>* M; yvec \<sharp>* K; distinct xvec; \<alpha> = \<tau>;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* M;  A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P;  A\<^sub>Q \<sharp>* K;  A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;  xvec \<sharp>* M;  xvec \<sharp>* K; xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q;  xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
            Prop (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rComm2: "\<And>\<Psi>\<^sub>Q M xvec N P' A\<^sub>P \<Psi>\<^sub>P K Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K; yvec \<sharp>* M; yvec \<sharp>* K; distinct xvec; \<alpha> = \<tau>;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P;  A\<^sub>P \<sharp>* M;  A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P;  A\<^sub>Q \<sharp>* K;  A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P;  xvec \<sharp>* M;  xvec \<sharp>* K;  xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q;  xvec \<sharp>* C\<rbrakk> \<Longrightarrow>
            Prop (\<tau>) (\<lparr>\<nu>*xvec\<rparr>(P' \<parallel> Q'))"
  and   rBrMerge: "\<And>\<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
                    \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
                    \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> \<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
                    A\<^sub>P \<sharp>* \<Psi>; A\<^sub>P \<sharp>* \<Psi>\<^sub>Q; A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N; A\<^sub>P \<sharp>* P';
                    A\<^sub>P \<sharp>* Q; A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q; A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M;
                    A\<^sub>Q \<sharp>* \<Psi>; A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N; A\<^sub>Q \<sharp>* P';
                    A\<^sub>Q \<sharp>* Q; A\<^sub>Q \<sharp>* Q'; A\<^sub>P \<sharp>* C; A\<^sub>Q \<sharp>* C; \<alpha> = \<questiondown>M\<lparr>N\<rparr>\<rbrakk> \<Longrightarrow>
                    Prop (\<questiondown>M\<lparr>N\<rparr>) (P' \<parallel> Q')"
  and   rBrComm1: "\<And>\<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P xvec Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            distinct xvec;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M; \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> = \<alpha>;
            xvec \<sharp>* \<Psi>; xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* Q; xvec \<sharp>* \<Psi>\<^sub>Q\<rbrakk> \<Longrightarrow>
            Prop (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"
  and   rBrComm2: "\<And>\<Psi>\<^sub>Q M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q' A\<^sub>Q.
           \<lbrakk>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'; extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>; distinct A\<^sub>P;
            \<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> Q'; extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>; distinct A\<^sub>Q;
            distinct xvec;
            A\<^sub>P \<sharp>* \<Psi>;  A\<^sub>P \<sharp>* \<Psi>\<^sub>Q;  A\<^sub>P \<sharp>* P; A\<^sub>P \<sharp>* N;  A\<^sub>P \<sharp>* P';  A\<^sub>P \<sharp>* Q;  A\<^sub>P \<sharp>* xvec;  A\<^sub>P \<sharp>* Q'; A\<^sub>P \<sharp>* A\<^sub>Q;  A\<^sub>P \<sharp>* C;
            A\<^sub>Q \<sharp>* \<Psi>;  A\<^sub>Q \<sharp>* \<Psi>\<^sub>P; A\<^sub>Q \<sharp>* P; A\<^sub>Q \<sharp>* N;  A\<^sub>Q \<sharp>* P';  A\<^sub>Q \<sharp>* Q;  A\<^sub>Q \<sharp>* xvec;  A\<^sub>Q \<sharp>* Q'; A\<^sub>Q \<sharp>* C;
            A\<^sub>P \<sharp>* M; A\<^sub>Q \<sharp>* M; xvec \<sharp>* M; \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> = \<alpha>;
            xvec \<sharp>* \<Psi>;  xvec \<sharp>* \<Psi>\<^sub>P; xvec \<sharp>* P; xvec \<sharp>* Q;  xvec \<sharp>* \<Psi>\<^sub>Q\<rbrakk> \<Longrightarrow>
            Prop (\<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle>) (P' \<parallel> Q')"

shows "Prop \<alpha> R"
  using Trans \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* Q\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close>
proof(induct rule: parCases[where C="(C, yvec)"])
  case(cPar1 P' A\<^sub>Q \<Psi>\<^sub>Q)
  then show ?case by(auto intro: rPar1)
next
  case(cPar2 Q' A\<^sub>P \<Psi>\<^sub>P)
  then show ?case by(auto intro: rPar2)
next
  case(cComm1 \<Psi>\<^sub>Q M N P' A\<^sub>P \<Psi>\<^sub>P K xvec Q' A\<^sub>Q)
  from \<open>A\<^sub>P \<sharp>* (C, yvec)\<close> \<open>A\<^sub>Q \<sharp>* (C, yvec)\<close> \<open>xvec \<sharp>* (C, yvec)\<close>
  have "A\<^sub>P \<sharp>* C" and "A\<^sub>Q \<sharp>* C" and "xvec \<sharp>* C" and "A\<^sub>P \<sharp>* yvec" and "A\<^sub>Q \<sharp>* yvec" and "xvec \<sharp>* yvec"
    by simp+

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
    and MeqK: "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K" by fact+

  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close>
  obtain M' where MeqM': "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> M'" and "xvec \<sharp>* M'" and "yvec \<sharp>* M'" and "A\<^sub>Q \<sharp>* M'"
    by - (rule inputObtainPrefix[where B="xvec@yvec@A\<^sub>Q"], (assumption | force)+)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto> ROut K (\<lparr>\<nu>*xvec\<rparr>N \<prec>' Q')"
    by(simp add: residualInject)
  with FrQ \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>yvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* yvec\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>xvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>xvec \<sharp>* K\<close> \<open>distinct xvec\<close>
  obtain K' where KeqK': "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> K \<leftrightarrow> K'" and "xvec \<sharp>* K'" and "yvec \<sharp>* K'" and "A\<^sub>P \<sharp>* K'"
    by - (rule outputObtainPrefix[where B="xvec@yvec@A\<^sub>P"], (assumption | force | metis freshChainSym)+)

  from MeqK KeqK' have "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K'"
    by(metis statEqEnt Associativity Commutativity Composition chanEqTrans)
  with \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>K'\<lparr>N\<rparr> \<prec> P'" using \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K'\<close>
    by - (rule inputRenameSubject, (assumption | force)+)
  moreover note FrP \<open>distinct A\<^sub>P\<close>
  moreover from MeqK MeqM' have "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> K \<leftrightarrow> M'"
    by(metis statEqEnt Associativity Commutativity Composition chanEqTrans chanEqSym)
  with \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'\<close> FrQ \<open>distinct A\<^sub>Q\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M'\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> Q'" using \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>A\<^sub>Q \<sharp>* M'\<close>
    by - (rule outputRenameSubject, (assumption | force)+)
  moreover note FrQ \<open>distinct A\<^sub>Q\<close>
  moreover from MeqM' KeqK' MeqK have "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> K' \<leftrightarrow> M'"
    by(metis statEqEnt Associativity Commutativity Composition chanEqTrans chanEqSym)
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* K'\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M'\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>\<alpha> = \<tau>\<close>
    \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M'\<close> \<open>xvec \<sharp>* K'\<close> \<open>xvec \<sharp>* Q\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>Q\<close> \<open>xvec \<sharp>* C\<close> \<open>yvec \<sharp>* M'\<close> \<open>yvec \<sharp>* K'\<close> \<open>distinct xvec\<close>
  ultimately show ?case
    by(metis rComm1)
next
  case(cComm2 \<Psi>\<^sub>Q M xvec N P' A\<^sub>P \<Psi>\<^sub>P K Q' A\<^sub>Q)
  from \<open>A\<^sub>P \<sharp>* (C, yvec)\<close> \<open>A\<^sub>Q \<sharp>* (C, yvec)\<close> \<open>xvec \<sharp>* (C, yvec)\<close>
  have "A\<^sub>P \<sharp>* C" and "A\<^sub>Q \<sharp>* C" and "xvec \<sharp>* C" and "A\<^sub>P \<sharp>* yvec" and "A\<^sub>Q \<sharp>* yvec" and "xvec \<sharp>* yvec"
    by simp+

  have FrP: "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>" and FrQ: "extractFrame Q = \<langle>A\<^sub>Q, \<Psi>\<^sub>Q\<rangle>"
    and MeqK: "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> M \<leftrightarrow> K" by fact+

  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto> ROut M (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P')"
    by(simp add: residualInject)
  with FrP \<open>distinct A\<^sub>P\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>yvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* yvec\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>xvec \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>xvec \<sharp>* M\<close> \<open>distinct xvec\<close>
  obtain M' where MeqM': "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> M'" and "xvec \<sharp>* M'" and "yvec \<sharp>* M'" and "A\<^sub>Q \<sharp>* M'"
    by - (rule outputObtainPrefix[where B="xvec@yvec@A\<^sub>Q"], (assumption | force)+)
  from \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'\<close> FrQ \<open>distinct A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>yvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<close>
    \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>Q \<sharp>* yvec\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>xvec \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close>
  obtain K' where KeqK': "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> K \<leftrightarrow> K'" and "xvec \<sharp>* K'" and "yvec \<sharp>* K'" and "A\<^sub>P \<sharp>* K'"
    by - (rule inputObtainPrefix[where B="xvec@yvec@A\<^sub>P"], (assumption | force | metis freshChainSym)+)

  from MeqK KeqK' have "(\<Psi> \<otimes> \<Psi>\<^sub>Q) \<otimes> \<Psi>\<^sub>P \<turnstile> M \<leftrightarrow> K'"
    by(metis statEqEnt Associativity Commutativity Composition chanEqTrans)
  with \<open>\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'\<close> FrP \<open>distinct A\<^sub>P\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>Q \<rhd> P \<longmapsto>K'\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P'" using \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* M\<close> \<open>A\<^sub>P \<sharp>* K'\<close>
    by - (rule outputRenameSubject, (assumption | force)+)
  moreover note FrP \<open>distinct A\<^sub>P\<close>
  moreover from MeqK MeqM' have "(\<Psi> \<otimes> \<Psi>\<^sub>P) \<otimes> \<Psi>\<^sub>Q \<turnstile> K \<leftrightarrow> M'"
    by(metis statEqEnt Associativity Commutativity Composition chanEqTrans chanEqSym)
  with \<open>\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>K\<lparr>N\<rparr> \<prec> Q'\<close> FrQ \<open>distinct A\<^sub>Q\<close>
  have "\<Psi> \<otimes> \<Psi>\<^sub>P \<rhd> Q \<longmapsto>M'\<lparr>N\<rparr> \<prec> Q'" using \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* K\<close> \<open>A\<^sub>Q \<sharp>* M'\<close>
    by - (rule inputRenameSubject, (assumption | force)+)
  moreover note FrQ \<open>distinct A\<^sub>Q\<close>
  moreover from MeqM' KeqK' MeqK have "\<Psi> \<otimes> \<Psi>\<^sub>P \<otimes> \<Psi>\<^sub>Q \<turnstile> K' \<leftrightarrow> M'"
    by(metis statEqEnt Associativity Commutativity Composition chanEqTrans chanEqSym)
  moreover note \<open>A\<^sub>P \<sharp>* \<Psi>\<close> \<open>A\<^sub>P \<sharp>* \<Psi>\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* K'\<close> \<open>A\<^sub>P \<sharp>* N\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>A\<^sub>P \<sharp>* Q\<close> \<open>A\<^sub>P \<sharp>* xvec\<close> \<open>A\<^sub>P \<sharp>* Q'\<close> \<open>A\<^sub>P \<sharp>* A\<^sub>Q\<close> \<open>A\<^sub>P \<sharp>* C\<close>
    \<open>A\<^sub>Q \<sharp>* \<Psi>\<close> \<open>A\<^sub>Q \<sharp>* \<Psi>\<^sub>P\<close> \<open>A\<^sub>Q \<sharp>* Q\<close> \<open>A\<^sub>Q \<sharp>* M'\<close> \<open>A\<^sub>Q \<sharp>* N\<close> \<open>A\<^sub>Q \<sharp>* Q'\<close> \<open>A\<^sub>Q \<sharp>* P\<close> \<open>A\<^sub>Q \<sharp>* xvec\<close> \<open>A\<^sub>Q \<sharp>* P'\<close> \<open>A\<^sub>Q \<sharp>* C\<close> \<open>\<alpha> = \<tau>\<close>
    \<open>xvec \<sharp>* \<Psi>\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>P\<close> \<open>xvec \<sharp>* P\<close> \<open>xvec \<sharp>* M'\<close> \<open>xvec \<sharp>* K'\<close> \<open>xvec \<sharp>* Q\<close> \<open>xvec \<sharp>* \<Psi>\<^sub>Q\<close> \<open>xvec \<sharp>* C\<close> \<open>yvec \<sharp>* M'\<close> \<open>yvec \<sharp>* K'\<close> \<open>distinct xvec\<close>
  ultimately show ?case
    by(metis rComm2)
next
  case cBrMerge
  then show ?case by (simp add: rBrMerge)
next
  case cBrComm1
  then show ?case by (auto intro: rBrComm1)
next
  case cBrComm2
  then show ?case by (auto intro: rBrComm2)
qed

lemma inputCases[consumes 1, case_names cInput cBrInput]:
  fixes \<Psi>   :: 'b
    and M    :: 'a
    and xvec :: "name list"
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"

assumes Trans: "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<alpha> \<prec> P'"
  and   rInput: "\<And>K Tvec. \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; set xvec \<subseteq> supp N; length xvec = length Tvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (K\<lparr>N[xvec::=Tvec]\<rparr>) (P[xvec::=Tvec])"
  and   rBrInput: "\<And>K Tvec. \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; set xvec \<subseteq> supp N; length xvec = length Tvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (\<questiondown>K\<lparr>N[xvec::=Tvec]\<rparr>) (P[xvec::=Tvec])"

shows "Prop \<alpha> P'"
proof -
  {
    fix xvec N P
    assume Trans: "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<alpha> \<prec> P'"
      and "xvec \<sharp>* \<Psi>" and "xvec \<sharp>* M" and "xvec \<sharp>* \<alpha>" and "xvec \<sharp>* P'" and "distinct xvec"
      and rInput: "\<And>K Tvec. \<lbrakk>\<Psi> \<turnstile> M \<leftrightarrow> K; set xvec \<subseteq> supp N; length xvec = length Tvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (K\<lparr>N[xvec::=Tvec]\<rparr>) (P[xvec::=Tvec])"
      and rBrInput: "\<And>K Tvec. \<lbrakk>\<Psi> \<turnstile> K \<succeq> M; set xvec \<subseteq> supp N; length xvec = length Tvec; distinct xvec\<rbrakk> \<Longrightarrow> Prop (\<questiondown>K\<lparr>N[xvec::=Tvec]\<rparr>) (P[xvec::=Tvec])"

    from Trans have "bn \<alpha> = []"
      apply -
      by(ind_cases "\<Psi> \<rhd> M\<lparr>\<lambda>*xvec N\<rparr>.P \<longmapsto>\<alpha> \<prec> P'") (auto simp add: residualInject)
    from Trans have "distinct(bn \<alpha>)" by(auto dest: boundOutputDistinct)
    have "length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')" by simp
    note Trans
    moreover have "length xvec = inputLength(M\<lparr>\<lambda>*xvec N\<rparr>.P)" by auto
    moreover note \<open>distinct xvec\<close>
    moreover have "length xvec = inputLength(M\<lparr>\<lambda>*xvec N\<rparr>.P)" by auto
    moreover note \<open>distinct xvec\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
    moreover obtain x::name where "x \<sharp> \<Psi>" and "x \<sharp> P" and "x \<sharp> M" and "x \<sharp> xvec" and "x \<sharp> \<alpha>" and "x \<sharp> P'" and "x \<sharp> N"
      by(generate_fresh "name") auto
    ultimately have "Prop \<alpha> P'" using \<open>bn \<alpha> = []\<close> \<open>xvec \<sharp>* \<Psi>\<close>\<open>xvec \<sharp>* M\<close> \<open>xvec \<sharp>* \<alpha>\<close> \<open>xvec \<sharp>* P'\<close>
      apply(cases rule: semanticsCases[of _ _ _ _ _ _ _ _ _ _ _ _ _ C x x x x])
                      apply(force simp add: residualInject psi.inject rInput)
                     apply(force simp add: residualInject psi.inject rBrInput)
      by(auto simp add: residualInject psi.inject inputChainFresh)+
  }
  note Goal = this
  moreover obtain p :: "name prm" where "(p \<bullet> xvec) \<sharp>* \<Psi>" and "(p \<bullet> xvec) \<sharp>* M" and "(p \<bullet> xvec) \<sharp>* N" and "(p \<bullet> xvec) \<sharp>* P"
    and "(p \<bullet> xvec) \<sharp>* \<alpha>" and "(p \<bullet> xvec) \<sharp>* P'" and S: "set p \<subseteq> set xvec \<times> set(p \<bullet> xvec)"
    and "distinctPerm p"
    by(rule name_list_avoiding[where xvec=xvec and c="(\<Psi>, M, N, P, \<alpha>, P')"]) auto
  from Trans \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close> S have "\<Psi> \<rhd> M\<lparr>\<lambda>*(p \<bullet> xvec) (p \<bullet> N)\<rparr>.(p \<bullet> P) \<longmapsto>\<alpha> \<prec> P'"
    by(simp add: inputChainAlpha')
  moreover {
    fix K Tvec
    assume "\<Psi> \<turnstile> M \<leftrightarrow> K"
    moreover assume "set(p \<bullet> xvec) \<subseteq> supp(p \<bullet> N)"
    then have "(p \<bullet> set(p \<bullet> xvec)) \<subseteq> (p \<bullet> supp(p \<bullet> N))" by simp
    with \<open>distinctPerm p\<close> have "set xvec \<subseteq> supp N" by(simp add: eqvts)
    moreover assume "length(p \<bullet> xvec) = length(Tvec::'a list)"
    then have "length xvec = length Tvec" by simp
    moreover assume "distinct xvec"
    ultimately have "Prop (K\<lparr>N[xvec::=Tvec]\<rparr>) (P[xvec::=Tvec])"
      by(rule rInput)
    with \<open>length xvec = length Tvec\<close> S \<open>distinctPerm p\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close>
    have "Prop (K\<lparr>(p \<bullet> N)[(p \<bullet> xvec)::=Tvec]\<rparr>) ((p \<bullet> P)[(p \<bullet> xvec)::=Tvec])"
      by(simp add: renaming substTerm.renaming)
  }
  moreover {
    fix K Tvec
    assume "\<Psi> \<turnstile> K \<succeq> M"
    moreover assume "set(p \<bullet> xvec) \<subseteq> supp(p \<bullet> N)"
    then have "(p \<bullet> set(p \<bullet> xvec)) \<subseteq> (p \<bullet> supp(p \<bullet> N))" by simp
    with \<open>distinctPerm p\<close> have "set xvec \<subseteq> supp N" by(simp add: eqvts)
    moreover assume "length(p \<bullet> xvec) = length(Tvec::'a list)"
    then have "length xvec = length Tvec" by simp
    moreover assume "distinct xvec"
    ultimately have "Prop (\<questiondown>K\<lparr>N[xvec::=Tvec]\<rparr>) (P[xvec::=Tvec])"
      by(rule rBrInput)
    with \<open>length xvec = length Tvec\<close> S \<open>distinctPerm p\<close> \<open>(p \<bullet> xvec) \<sharp>* N\<close> \<open>(p \<bullet> xvec) \<sharp>* P\<close>
    have "Prop (\<questiondown>K\<lparr>(p \<bullet> N)[(p \<bullet> xvec)::=Tvec]\<rparr>) ((p \<bullet> P)[(p \<bullet> xvec)::=Tvec])"
      by(simp add: renaming substTerm.renaming)
  }
  moreover from Trans have "distinct xvec" by(rule inputDistinct)
  then have "distinct(p \<bullet> xvec)" by simp
  ultimately show ?thesis using \<open>(p \<bullet> xvec) \<sharp>* \<Psi>\<close> \<open>(p \<bullet> xvec) \<sharp>* M\<close> \<open>(p \<bullet> xvec) \<sharp>* \<alpha>\<close> \<open>(p \<bullet> xvec) \<sharp>* P'\<close> \<open>distinct xvec\<close>
    by(metis Goal)
qed

lemma outputCases[consumes 1, case_names cOutput cBrOutput]:
  fixes \<Psi> :: 'b
    and M  :: 'a
    and N  :: 'a
    and P  :: "('a, 'b, 'c) psi"
    and \<alpha>  :: "'a action"
    and P' :: "('a, 'b, 'c) psi"

assumes "\<Psi> \<rhd> M\<langle>N\<rangle>.P \<longmapsto>\<alpha> \<prec> P'"
  and   "\<And>K. \<Psi> \<turnstile> M \<leftrightarrow> K \<Longrightarrow> Prop (K\<langle>N\<rangle>) P"
  and   "\<And>K. \<Psi> \<turnstile> M \<preceq> K \<Longrightarrow> Prop (\<exclamdown>K\<langle>N\<rangle>) P"

shows "Prop \<alpha> P'"
  using assms
  by(cases rule: semantics.cases) (auto simp add: residualInject psi.inject)

lemma caseCases[consumes 1, case_names cCase]:
  fixes \<Psi> :: 'b
    and Cs :: "('c \<times> ('a, 'b, 'c) psi) list"
    and \<alpha>  :: "'a action"
    and P' :: "('a, 'b, 'c) psi"

assumes Trans: "\<Psi> \<rhd> (Cases Cs) \<longmapsto> Rs"
  and   rCase: "\<And>\<phi> P. \<lbrakk>\<Psi> \<rhd> P \<longmapsto> Rs; (\<phi>, P) \<in> set Cs; \<Psi> \<turnstile> \<phi>; guarded P\<rbrakk> \<Longrightarrow> Prop"

shows "Prop"
  using assms
  by(cases rule: semantics.cases) (auto simp add: residualInject psi.inject)

lemma resCases[consumes 7, case_names cOpen cBrOpen cRes cBrClose]:
  fixes \<Psi>    :: 'b
    and x    :: name
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> P'"
  and   "x \<sharp> \<Psi>"
  and   "x \<sharp> \<alpha>"
  and   "x \<sharp> P'"
  and   "bn \<alpha> \<sharp>* \<Psi>"
  and   "bn \<alpha> \<sharp>* P"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   rOpen: "\<And>M xvec yvec y N P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle> \<prec> ([(x, y)] \<bullet> P'); y \<in> supp N;
                                         x \<sharp> N; x \<sharp> P'; x \<noteq> y; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> M; distinct xvec; distinct yvec;
                                         xvec \<sharp>* \<Psi>; y \<sharp> \<Psi>; yvec \<sharp>* \<Psi>; xvec \<sharp>* P; y \<sharp> P; yvec \<sharp>* P; xvec \<sharp>* M; y \<sharp> M;
                                         yvec \<sharp>* M; xvec \<sharp>* yvec\<rbrakk> \<Longrightarrow>
                                         Prop (M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>N\<rangle>) P'"
  and   rBrOpen: "\<And>M xvec yvec y N P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>([(x, y)] \<bullet> N)\<rangle> \<prec> ([(x, y)] \<bullet> P'); y \<in> supp N;
                                         x \<sharp> N; x \<sharp> P'; x \<noteq> y; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> M; distinct xvec; distinct yvec;
                                         xvec \<sharp>* \<Psi>; y \<sharp> \<Psi>; yvec \<sharp>* \<Psi>; xvec \<sharp>* P; y \<sharp> P; yvec \<sharp>* P; xvec \<sharp>* M; y \<sharp> M;
                                         yvec \<sharp>* M; xvec \<sharp>* yvec\<rbrakk> \<Longrightarrow>
                                         Prop (\<exclamdown>M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>N\<rangle>) P'"
  and   rScope:  "\<And>P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<rbrakk> \<Longrightarrow> Prop \<alpha> (\<lparr>\<nu>x\<rparr>P')"
  and   rBrClose: "\<And>M xvec N P'.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                    x \<in> supp M;
                    distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P;
                    xvec \<sharp>* M;
                    x \<sharp> \<Psi>; x \<sharp> xvec;
                    xvec \<sharp>* C\<rbrakk> \<Longrightarrow> Prop (\<tau>) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"
shows "Prop \<alpha> P'"
proof -
  from Trans have "distinct(bn \<alpha>)"
    by(auto dest: boundOutputDistinct)
  note facts = \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> P'\<close> \<open>distinct(bn \<alpha>)\<close>
  have "length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')" by simp
  note Trans
  moreover have "length [] = inputLength(\<lparr>\<nu>x\<rparr>P)" and "distinct []"
    by(auto simp add: inputLength_inputLength'_inputLength''.simps)
  moreover have "length [] = inputLength(\<lparr>\<nu>x\<rparr>P)" and "distinct []"
    by(auto simp add: inputLength_inputLength'_inputLength''.simps)
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  ultimately show ?thesis using facts
  proof(cases rule: semanticsCases[of _ _ _ _ _ _ _ _ _ _ _ _ _ C x x x x])
    case (cOpen P M xvec y yvec N P')
    moreover then have "y \<in> supp ([(x, y)] \<bullet> N)" using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      apply(drule pt_set_bij2[where pi="[(x, y)]", where x=x, OF pt_name_inst, OF at_name_inst])
      by(auto simp add: calc_atm eqvts fresh_def)
    ultimately show ?thesis using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      by(rule rOpen) (auto simp add: residualInject boundOutputApp)
  next
    case (cBrOpen P M xvec y yvec N P')
    moreover then have "y \<in> supp ([(x, y)] \<bullet> N)" using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      apply(drule pt_set_bij2[where pi="[(x, y)]", where x=x, OF pt_name_inst, OF at_name_inst])
      by(auto simp add: calc_atm eqvts fresh_def)
    ultimately show ?thesis using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      by(rule rBrOpen) (auto simp add: residualInject boundOutputApp)
  next
  qed (auto simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts
            intro: rScope rBrClose)
qed

lemma resCases'[consumes 7, case_names cOpen cBrOpen cRes cBrClose]:
  fixes \<Psi>    :: 'b
    and x    :: name
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> P'"
  and   "x \<sharp> \<Psi>"
  and   "x \<sharp> \<alpha>"
  and   "x \<sharp> P'"
  and   "bn \<alpha> \<sharp>* \<Psi>"
  and   "bn \<alpha> \<sharp>* P"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   rOpen: "\<And>M xvec yvec y N P'. \<lbrakk>\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; y \<in> supp N;
                                         x \<sharp> N; x \<sharp> P'; x \<noteq> y; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> M; distinct xvec; distinct yvec;
                                         xvec \<sharp>* \<Psi>; y \<sharp> \<Psi>; yvec \<sharp>* \<Psi>; xvec \<sharp>* P; y \<sharp> P; yvec \<sharp>* P; xvec \<sharp>* M; y \<sharp> M;
                                         yvec \<sharp>* M; xvec \<sharp>* yvec\<rbrakk> \<Longrightarrow>
                                         Prop (M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>N\<rangle>) P'"
  and   rBrOpen: "\<And>M xvec yvec y N P'. \<lbrakk>\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>\<exclamdown>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; y \<in> supp N;
                                         x \<sharp> N; x \<sharp> P'; x \<noteq> y; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> M; distinct xvec; distinct yvec;
                                         xvec \<sharp>* \<Psi>; y \<sharp> \<Psi>; yvec \<sharp>* \<Psi>; xvec \<sharp>* P; y \<sharp> P; yvec \<sharp>* P; xvec \<sharp>* M; y \<sharp> M;
                                         yvec \<sharp>* M; xvec \<sharp>* yvec\<rbrakk> \<Longrightarrow>
                                         Prop (\<exclamdown>M\<lparr>\<nu>*(xvec@y#yvec)\<rparr>\<langle>N\<rangle>) P'"
  and   rScope:  "\<And>P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'\<rbrakk> \<Longrightarrow> Prop \<alpha> (\<lparr>\<nu>x\<rparr>P')"
  and   rBrClose: "\<And>M xvec N P'.
                   \<lbrakk>\<Psi> \<rhd> P \<longmapsto> \<exclamdown>M\<lparr>\<nu>*xvec\<rparr>\<langle>N\<rangle> \<prec> P';
                    x \<in> supp M;
                    distinct xvec; xvec \<sharp>* \<Psi>; xvec \<sharp>* P;
                    xvec \<sharp>* M;
                    x \<sharp> \<Psi>; x \<sharp> xvec;
                    xvec \<sharp>* C\<rbrakk> \<Longrightarrow> Prop (\<tau>) (\<lparr>\<nu>x\<rparr>(\<lparr>\<nu>*xvec\<rparr>P'))"

shows "Prop \<alpha> P'"
proof -
  from Trans have "distinct(bn \<alpha>)"
    by(auto dest: boundOutputDistinct)
  note facts = \<open>bn \<alpha> \<sharp>* \<Psi>\<close> \<open>bn \<alpha> \<sharp>* P\<close> \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>x \<sharp> \<Psi>\<close> \<open>x \<sharp> \<alpha>\<close> \<open>x \<sharp> P'\<close> \<open>distinct(bn \<alpha>)\<close>
  have "length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')"
    by simp
  note Trans
  moreover have "length [] = inputLength(\<lparr>\<nu>x\<rparr>P)" and "distinct []"
    by(auto simp add: inputLength_inputLength'_inputLength''.simps)
  moreover have "length [] = inputLength(\<lparr>\<nu>x\<rparr>P)" and "distinct []"
    by(auto simp add: inputLength_inputLength'_inputLength''.simps)
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  moreover note \<open>length(bn \<alpha>) = residualLength(\<alpha> \<prec> P')\<close> \<open>distinct(bn \<alpha>)\<close>
  ultimately show ?thesis using facts
  proof(cases rule: semanticsCases[of _ _ _ _ _ _ _ _ _ _ _ _ _ C x x x x])
    case (cOpen P M xvec y yvec N P')
    moreover then have "y \<in> supp ([(x, y)] \<bullet> N)" using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      apply(drule pt_set_bij2[where pi="[(x, y)]", OF pt_name_inst, OF at_name_inst])
      by(auto simp add: calc_atm eqvts fresh_def)
    ultimately show ?thesis using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      apply(rule rOpen) \<comment> \<open>20 subgoals\<close>
                         apply(drule semantics.eqvt[where pi="[(x, y)]"])
                         apply(auto simp add: eqvts residualInject boundOutputApp)
      done
  next
    case (cBrOpen P M xvec y yvec N P')
    moreover then have "y \<in> supp ([(x, y)] \<bullet> N)" using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      apply(drule pt_set_bij2[where pi="[(x, y)]", OF pt_name_inst, OF at_name_inst])
      by(auto simp add: calc_atm eqvts fresh_def)
    ultimately show ?thesis using facts
      apply(clarsimp simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts)
      apply(rule rBrOpen) \<comment> \<open>20 subgoals\<close>
                         apply(drule semantics.eqvt[where pi="[(x, y)]"])
                         apply(auto simp add: eqvts residualInject boundOutputApp)
      done
  qed (auto simp add: psi.inject alpha abs_fresh residualInject boundOutputApp boundOutput.inject eqvts
            intro: rScope rBrClose)
qed

lemma resInputCases'[consumes 4, case_names cRes]:
  fixes \<Psi>    :: 'b
    and x    :: name
    and M    :: 'a
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>N\<rparr> \<prec> R"
  and   2: "x \<sharp> \<Psi>"
  and   "x \<sharp> (M\<lparr>N\<rparr>)"
  and   4: "x \<sharp> R"
  and   rScope:  "\<And>P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>N\<rparr> \<prec> P'\<rbrakk> \<Longrightarrow> Prop (\<lparr>\<nu>x\<rparr>P')"

shows "Prop R"
proof -
  from Trans obtain \<alpha> where 1: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> R" and 5: "bn \<alpha> \<sharp>* \<Psi>" and 6: "bn \<alpha> \<sharp>* P" and 7: "bn \<alpha> \<sharp>* subject \<alpha>" and "\<alpha> = M\<lparr>N\<rparr>" by auto
  from \<open>x \<sharp> (M\<lparr>N\<rparr>)\<close> \<open>\<alpha> = (M\<lparr>N\<rparr>)\<close> have 3: "x \<sharp> \<alpha>" by simp
  show ?thesis using 1 2 3 4 5 6 7 \<open>\<alpha> = M\<lparr>N\<rparr>\<close> rScope
    by(induct rule: resCases') (auto simp add: residualInject)
qed

lemma resBrInputCases'[consumes 4, case_names cRes]:
  fixes \<Psi>    :: 'b
    and x    :: name
    and M    :: 'a
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> R"
  and   2: "x \<sharp> \<Psi>"
  and   "x \<sharp> (\<questiondown>M\<lparr>N\<rparr>)"
  and   4: "x \<sharp> R"
  and   rScope:  "\<And>P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>\<questiondown>M\<lparr>N\<rparr> \<prec> P'\<rbrakk> \<Longrightarrow> Prop (\<lparr>\<nu>x\<rparr>P')"

shows "Prop R"
proof -
  from Trans obtain \<alpha> where 1: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> R" and 5: "bn \<alpha> \<sharp>* \<Psi>" and 6: "bn \<alpha> \<sharp>* P" and 7: "bn \<alpha> \<sharp>* subject \<alpha>" and "\<alpha> = \<questiondown>M\<lparr>N\<rparr>" by auto
  from \<open>x \<sharp> (\<questiondown>M\<lparr>N\<rparr>)\<close> \<open>\<alpha> = (\<questiondown>M\<lparr>N\<rparr>)\<close> have 3: "x \<sharp> \<alpha>" by simp
  show ?thesis using 1 2 3 4 5 6 7 \<open>\<alpha> = \<questiondown>M\<lparr>N\<rparr>\<close> rScope
    by(induct rule: resCases') (auto simp add: residualInject)
qed

lemma resOutputCases'''[consumes 7, case_names cOpen cRes]:
  fixes \<Psi>    :: 'b
    and x    :: name
    and M    :: 'a
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle> \<prec> R"
  and   1: "x \<sharp> \<Psi>"
  and   "x \<sharp> (M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle>)"
  and   3: "x \<sharp> R"
  and   "(zvec1 @ zvec2) \<sharp>* \<Psi>"
  and   "(zvec1 @ zvec2) \<sharp>* P"
  and   "(zvec1 @ zvec2) \<sharp>* M"
  and   rOpen: "\<And>M xvec yvec y N P'. \<lbrakk>\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; y \<in> supp N;
                                         x \<sharp> N; x \<sharp> P'; x \<noteq> y; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> M; distinct xvec; distinct yvec;
                                         xvec \<sharp>* \<Psi>; y \<sharp> \<Psi>; yvec \<sharp>* \<Psi>; xvec \<sharp>* P; y \<sharp> P; yvec \<sharp>* P; xvec \<sharp>* M; y \<sharp> M;
                                         yvec \<sharp>* M; xvec \<sharp>* yvec\<rbrakk> \<Longrightarrow>
                                         Prop P'"
  and   rScope:  "\<And>P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle> \<prec> P'\<rbrakk> \<Longrightarrow> Prop (\<lparr>\<nu>x\<rparr>P')"

shows "Prop R"
proof -
  from Trans have "distinct (zvec1 @ zvec2)" by(auto dest: boundOutputDistinct)
  obtain \<alpha> where "\<alpha>=M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle>" by simp
  with Trans \<open>(zvec1 @ zvec2) \<sharp>* \<Psi>\<close> \<open>(zvec1 @ zvec2) \<sharp>* P\<close> \<open>(zvec1 @ zvec2) \<sharp>* M\<close>
  have \<alpha>Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> R" and 4: "bn \<alpha> \<sharp>* \<Psi>" and 5: "bn \<alpha> \<sharp>* P" and 6: "bn \<alpha> \<sharp>* subject \<alpha>"
    by simp+
  from \<open>x \<sharp> (M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle>)\<close> \<open>\<alpha>=M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle>\<close> have 2: "x \<sharp> \<alpha>" by simp
  show ?thesis using \<alpha>Trans 1 2 3 4 5 6 \<open>\<alpha>=M\<lparr>\<nu>*(zvec1 @ zvec2)\<rparr>\<langle>N\<rangle>\<close> rOpen rScope
  proof(induct rule: resCases'[where C="(zvec1, zvec2, C)"])
    case cBrOpen
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  next
    case cRes
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  next
    case cBrClose
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  next
    case(cOpen M' xvec yvec y N' P')
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  qed
qed

lemma resOutputCases''[consumes 7, case_names cOpen cRes]:
  fixes \<Psi>    :: 'b
    and x    :: name
    and z    :: name
    and M    :: 'a
    and N    :: 'a
    and P    :: "('a, 'b, 'c) psi"
    and R    :: "('a, 'b, 'c) psi"
    and C    :: "'f::fs_name"

assumes Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle> \<prec> R"
  and   1: "x \<sharp> \<Psi>"
  and   "x \<sharp> (M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle>)"
  and   3: "x \<sharp> R"
  and   "(zvec1@y#zvec2) \<sharp>* \<Psi>"
  and   "(zvec1@y#zvec2) \<sharp>* P"
  and   "(zvec1@y#zvec2) \<sharp>* M"
  and   rOpen: "\<And>M xvec yvec y N P'. \<lbrakk>\<Psi> \<rhd> ([(x, y)] \<bullet> P) \<longmapsto>M\<lparr>\<nu>*(xvec@yvec)\<rparr>\<langle>N\<rangle> \<prec> P'; y \<in> supp N;
                                         x \<sharp> N; x \<sharp> P'; x \<noteq> y; y \<sharp> xvec; y \<sharp> yvec; y \<sharp> M; distinct xvec; distinct yvec;
                                         xvec \<sharp>* \<Psi>; y \<sharp> \<Psi>; yvec \<sharp>* \<Psi>; xvec \<sharp>* P; y \<sharp> P; yvec \<sharp>* P; xvec \<sharp>* M; y \<sharp> M;
                                         yvec \<sharp>* M; xvec \<sharp>* yvec\<rbrakk> \<Longrightarrow>
                                         Prop P'"
  and   rScope:  "\<And>P'. \<lbrakk>\<Psi> \<rhd> P \<longmapsto>M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle> \<prec> P'\<rbrakk> \<Longrightarrow> Prop (\<lparr>\<nu>x\<rparr>P')"

shows "Prop R"
proof -
  from Trans have "distinct (zvec1@y#zvec2)" by(auto dest: boundOutputDistinct)
  obtain \<alpha> where "\<alpha>=M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle>" by simp
  with Trans \<open>(zvec1@y#zvec2) \<sharp>* \<Psi>\<close> \<open>(zvec1@y#zvec2) \<sharp>* P\<close> \<open>(zvec1@y#zvec2) \<sharp>* M\<close>
  have \<alpha>Trans: "\<Psi> \<rhd> \<lparr>\<nu>x\<rparr>P \<longmapsto>\<alpha> \<prec> R" and 4: "bn \<alpha> \<sharp>* \<Psi>" and 5: "bn \<alpha> \<sharp>* P" and 6: "bn \<alpha> \<sharp>* subject \<alpha>"
    by simp+
  from \<open>x \<sharp> (M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle>)\<close> \<open>\<alpha>=M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle>\<close> have 2: "x \<sharp> \<alpha>" by simp
  show ?thesis using \<alpha>Trans 1 2 3 4 5 6 \<open>\<alpha>=M\<lparr>\<nu>*(zvec1@y#zvec2)\<rparr>\<langle>N\<rangle>\<close> rOpen rScope
  proof(induct rule: resCases'[where C="(zvec1, zvec2, z, C)"])
    case cBrOpen
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  next
    case cRes
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  next
    case cBrClose
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  next
    case(cOpen M' xvec yvec y N' P')
    then show ?case
      by(auto simp add: residualInject boundOutputApp)
  qed
qed

abbreviation
  statImpJudge (\<open>_ \<hookrightarrow> _\<close> [80, 80] 80)
  where "\<Psi> \<hookrightarrow> \<Psi>' \<equiv> AssertionStatImp \<Psi> \<Psi>'"

lemma statEqTransition:
  fixes \<Psi>  :: 'b
    and P  :: "('a, 'b, 'c) psi"
    and Rs :: "('a, 'b, 'c) residual"
    and \<Psi>' :: 'b

assumes "\<Psi> \<rhd> P \<longmapsto> Rs"
  and   "\<Psi> \<simeq> \<Psi>'"

shows "\<Psi>' \<rhd> P \<longmapsto> Rs"
  using assms
proof(nominal_induct avoiding: \<Psi>' rule: semantics.strong_induct)
  case(cInput \<Psi> M K xvec N Tvec P \<Psi>')
  from \<open>\<Psi> \<simeq> \<Psi>'\<close> \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "\<Psi>' \<turnstile> M \<leftrightarrow> K"
    by(simp add: AssertionStatImp_def AssertionStatEq_def)
  then show ?case using \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    by(rule Input)
next
  case(cBrInput \<Psi> K M xvec N Tvec P \<Psi>')
  from \<open>\<Psi> \<simeq> \<Psi>'\<close> \<open>\<Psi> \<turnstile> K \<succeq> M\<close> have "\<Psi>' \<turnstile> K \<succeq> M"
    by(simp add: AssertionStatImp_def AssertionStatEq_def)
  then show ?case using \<open>distinct xvec\<close> \<open>set xvec \<subseteq> supp N\<close> \<open>length xvec = length Tvec\<close>
    by(rule BrInput)
next
  case(Output \<Psi> M K N P \<Psi>')
  from \<open>\<Psi> \<simeq> \<Psi>'\<close> \<open>\<Psi> \<turnstile> M \<leftrightarrow> K\<close> have "\<Psi>' \<turnstile> M \<leftrightarrow> K"
    by(simp add: AssertionStatImp_def AssertionStatEq_def)
  then show ?case by(rule semantics.Output)
next
  case(BrOutput \<Psi> M K N P \<Psi>')
  from \<open>\<Psi> \<simeq> \<Psi>'\<close> \<open>\<Psi> \<turnstile> M \<preceq> K\<close> have "\<Psi>' \<turnstile> M \<preceq> K"
    by(simp add: AssertionStatImp_def AssertionStatEq_def)
  then show ?case by(rule semantics.BrOutput)
next
  case(Case \<Psi> P Rs \<phi> Cs \<Psi>')
  then have "\<Psi>' \<rhd> P \<longmapsto> Rs" by(intro Case)
  moreover note \<open>(\<phi>, P) \<in> set Cs\<close>
  moreover from \<open>\<Psi> \<simeq> \<Psi>'\<close> \<open>\<Psi> \<turnstile> \<phi>\<close> have "\<Psi>' \<turnstile> \<phi>"
    by(simp add: AssertionStatImp_def AssertionStatEq_def)
  ultimately show ?case using \<open>guarded P\<close> by(rule semantics.Case)
next
  case(cPar1 \<Psi> \<Psi>Q P \<alpha> P' xvec Q \<Psi>')
  then show ?case
    by(intro Par1) (auto intro: Composition)
next
  case(cPar2 \<Psi> \<Psi>P Q \<alpha> Q' xvec P \<Psi>')
  then show ?case
    by(intro Par2) (auto intro: Composition)
next
  case(cComm1 \<Psi> \<Psi>Q P M N P' xvec \<Psi>P Q K zvec Q' yvec \<Psi>')
  then show ?case
    by(clarsimp, intro Comm1) (blast intro: Composition statEqEnt)+
next
  case(cComm2 \<Psi> \<Psi>Q P M zvec N P' xvec \<Psi>P Q K Q' yvec \<Psi>')
  then show ?case
    by(clarsimp, intro Comm2) (blast intro: Composition statEqEnt)+
next
  case(cBrMerge \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q \<Psi>')
  then show ?case
    by(clarsimp, intro BrMerge) (blast intro: Composition)+
next
  case(cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q \<Psi>')
  then show ?case
    by(clarsimp, intro BrComm1) (blast intro: Composition)+
next
  case(cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q \<Psi>')
  then show ?case
    by(clarsimp, intro BrComm2) (blast intro: Composition)+
next
  case(cBrClose \<Psi> P M xvec N P' x \<Psi>')
  then show ?case by(force intro: BrClose)
next
  case(cOpen \<Psi> P M xvec N P' x yvec \<Psi>')
  then show ?case by(force intro: Open)
next
  case(cBrOpen \<Psi> P M xvec N P' x yvec \<Psi>')
  then show ?case by(force intro: BrOpen)
next
  case(cScope \<Psi> P \<alpha> P' x \<Psi>')
  then show ?case by(force intro: Scope)
next
  case(Bang \<Psi> P Rs \<Psi>')
  then show ?case by(force intro: semantics.Bang)
qed

lemma brInputTermSupp:
  fixes \<Psi> :: "'b::fs_name"
    and P   :: "('a, 'b, ('c::fs_name)) psi"
    and P'  :: "('a, 'b, 'c) psi"
    and N   :: "'a::fs_name"
    and K   :: "'a::fs_name"

assumes "\<Psi> \<rhd> P \<longmapsto> \<questiondown>K\<lparr>N\<rparr> \<prec> P'"

shows "(supp K) \<subseteq> ((supp P)::name set)"
  using assms
proof(nominal_induct rule: brInputInduct)
  case(cBrInput \<Psi> K M xvec N Tvec P)
  from \<open>\<Psi> \<turnstile> K \<succeq> M\<close> have "(supp K) \<subseteq> ((supp M)::name set)"
    by(simp add: chanInConSupp)
  then show ?case
    by (metis Un_commute Un_upper2 psi.supp(3) subset_trans)
next
  case(cCase \<Psi> P M N P' \<phi> Cs)
  then have "supp M \<subseteq> ((supp P)::name set)"
    by simp
  from \<open>(\<phi>, P) \<in> set Cs\<close>
  have "{(\<phi>, P)} \<subseteq> set Cs"
    by simp
  moreover have "finite {(\<phi>, P)}" by simp
  moreover have "finite (set Cs)" by simp
  ultimately have "((supp {(\<phi>, P)})::name set) \<subseteq> ((supp (set Cs))::name set)"
    by(simp add: supp_subset)

  moreover have "supp {(\<phi>, P)} = ((supp (\<phi>, P))::name set)"
    by (meson supp_singleton)
  moreover have "supp P \<subseteq> supp (\<phi>, P)"
    by (metis Un_upper2 supp_prod)
  ultimately have "((supp P)::name set) \<subseteq> ((supp Cs)::name set)"
    by (auto simp add: supp_list_set)

  moreover have "((supp Cs)::name set) = ((supp (Cases Cs))::name set)"
    unfolding psi.supp
    apply(induct rule: psiCases.induct)
     apply(metis psiCase.supp(1) psiCases.simps(1) set_empty2 supp_list_nil)
    by simp (metis Un_assoc psiCase.supp(2) supp_list_cons supp_prod)

  ultimately have "((supp P)::name set) \<subseteq> ((supp (Cases Cs))::name set)"
    by simp

  with \<open>supp M \<subseteq> supp P\<close>
  show ?case by simp
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>Q Q)
  then have "((supp M)::name set) \<subseteq> ((supp P)::name set)"
    by auto
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M N Q' A\<^sub>P P)
  then have "((supp M)::name set) \<subseteq> ((supp Q)::name set)"
    by auto
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cBrMerge \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q)
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cScope \<Psi> P M N P' x)
  then have "((supp M)::name set) \<subseteq> ((supp P)::name set)"
    by simp
  then show ?case
    by(simp add: psi.supp) (metis abs_supp cScope.hyps fresh_def insert_Diff_single subset_insert_iff)
next
  case(cBang \<Psi> P M N P')
  then show ?case
    by(simp add: psi.supp)
qed

lemma brOutputTermSupp:
  fixes \<Psi> :: "'b::fs_name"
    and P   :: "('a, 'b, ('c::fs_name)) psi"
    and P'  :: "('a, 'b, 'c) psi"
    and N   :: "'a::fs_name"
    and K   :: "'a::fs_name"
    and xvec :: "name list"

assumes "\<Psi> \<rhd> P \<longmapsto> RBrOut K (\<lparr>\<nu>*xvec\<rparr>N \<prec>' P')"

shows "(supp K) \<subseteq> ((supp P)::name set)"
  using assms
proof(nominal_induct rule: brOutputInduct)
  case(cBrOutput \<Psi> M K N P)
  from \<open>\<Psi> \<turnstile> M \<preceq> K\<close> have "(supp K) \<subseteq> ((supp M)::name set)"
    by(simp add: chanOutConSupp)
  then show ?case
    by (metis Un_commute Un_upper2 psi.supp(2) subset_iff_psubset_eq subset_trans)
next
  case(cCase \<Psi> P M B \<phi> Cs)
  then have "supp M \<subseteq> ((supp P)::name set)"
    by simp
  from \<open>(\<phi>, P) \<in> set Cs\<close>
  have "{(\<phi>, P)} \<subseteq> set Cs"
    by simp
  moreover have "finite {(\<phi>, P)}" by simp
  moreover have "finite (set Cs)" by simp
  ultimately have "((supp {(\<phi>, P)})::name set) \<subseteq> ((supp (set Cs))::name set)"
    by(simp add: supp_subset)

  moreover have "supp {(\<phi>, P)} = ((supp (\<phi>, P))::name set)"
    by(meson supp_singleton)
  moreover have "supp P \<subseteq> supp (\<phi>, P)"
    by (metis Un_upper2 supp_prod)
  ultimately have "((supp P)::name set) \<subseteq> ((supp Cs)::name set)"
    by (auto simp add: supp_list_set)

  moreover have "((supp Cs)::name set) = ((supp (Cases Cs))::name set)"
    unfolding psi.supp
    apply(induct rule: psiCases.induct)
     apply(metis psiCase.supp(1) psiCases.simps(1) set_empty2 supp_list_nil)
    by simp (metis Un_assoc psiCase.supp(2) supp_list_cons supp_prod)

  ultimately have "((supp P)::name set) \<subseteq> ((supp (Cases Cs))::name set)"
    by simp

  with \<open>supp M \<subseteq> supp P\<close>
  show ?case by simp
next
  case(cPar1 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>Q Q)
  then have "((supp M)::name set) \<subseteq> ((supp P)::name set)"
    by auto
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cPar2 \<Psi> \<Psi>\<^sub>P Q M xvec N Q' A\<^sub>P P)
  then have "((supp M)::name set) \<subseteq> ((supp Q)::name set)"
    by auto
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cBrComm1 \<Psi> \<Psi>\<^sub>Q P M N P' A\<^sub>P \<Psi>\<^sub>P Q xvec Q' A\<^sub>Q)
  then have "((supp M)::name set) \<subseteq> ((supp Q)::name set)"
    by auto
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cBrComm2 \<Psi> \<Psi>\<^sub>Q P M xvec N P' A\<^sub>P \<Psi>\<^sub>P Q Q' A\<^sub>Q)
  then have "((supp M)::name set) \<subseteq> ((supp P)::name set)"
    by auto
  then show ?case
    by(auto simp add: psi.supp)
next
  case(cBrOpen \<Psi> P M xvec yvec N P' x)
  then have "((supp M)::name set) \<subseteq> ((supp P)::name set)"
    by simp
  with \<open>x \<sharp> M\<close>
  show ?case
    by(simp add: psi.supp) (metis abs_supp cBrOpen.hyps fresh_def insert_Diff_single subset_insert_iff)
next
  case(cScope \<Psi> P M xvec N P' x)
  then have "((supp M)::name set) \<subseteq> ((supp P)::name set)"
    by simp
  then show ?case
    by(simp add: psi.supp) (metis abs_supp cScope.hyps fresh_def insert_Diff_single subset_insert_iff)
next
  case cBang
  then show ?case
    by(simp add: psi.supp)
qed

lemma actionPar1Dest':
  fixes \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and \<beta> :: "('a::fs_name) action"
    and Q :: "('a, 'b, 'c) psi"
    and R :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> (Q \<parallel> R)"
  and   "bn \<alpha> \<sharp>* R"
  and   "bn \<beta> \<sharp>* R"

obtains T where "P = T \<parallel> R" and "\<alpha> \<prec> T = \<beta> \<prec> Q"
  using assms
  apply(cases rule: actionCases[where \<alpha>=\<alpha>])
      apply (metis residualInject'(1))
     apply (metis residualInject'(7))
    apply (smt (z3) bn.simps(3) boundOutputPar1Dest create_residual.simps(3) residualInject'(8))
   apply (smt (z3) bn.simps(4) boundOutputPar1Dest create_residual.simps(4) residualInject'(9))
  by (metis residualInject'(10))

lemma actionPar2Dest':
  fixes \<alpha> :: "('a::fs_name) action"
    and P :: "('a, 'b::fs_name, 'c::fs_name) psi"
    and \<beta> :: "('a::fs_name) action"
    and Q :: "('a, 'b, 'c) psi"
    and R :: "('a, 'b, 'c) psi"

assumes "\<alpha> \<prec> P = \<beta> \<prec> (Q \<parallel> R)"
  and   "bn \<alpha> \<sharp>* Q"
  and   "bn \<beta> \<sharp>* Q"

obtains T where "P = Q \<parallel> T" and "\<alpha> \<prec> T = \<beta> \<prec> R"
  using assms
  apply(cases rule: actionCases[where \<alpha>=\<alpha>])
      apply (metis residualInject'(1))
     apply (metis residualInject'(7))
    apply (smt (z3) bn.simps(3) boundOutputPar2Dest create_residual.simps(3) residualInject'(8))
   apply (smt (z3) bn.simps(4) boundOutputPar2Dest create_residual.simps(4) residualInject'(9))
  by (metis residualInject'(10))

lemma expandNonTauFrame:
  fixes \<Psi>   :: 'b
    and P    :: "('a, 'b, 'c) psi"
    and \<alpha>    :: "'a action"
    and P'   :: "('a, 'b, 'c) psi"
    and A\<^sub>P   :: "name list"
    and \<Psi>\<^sub>P  :: 'b
    and C    :: "'f::fs_name"
    and C'   :: "'g::fs_name"

assumes Trans: "\<Psi> \<rhd> P \<longmapsto>\<alpha> \<prec> P'"
  and   "extractFrame P = \<langle>A\<^sub>P, \<Psi>\<^sub>P\<rangle>"
  and   "distinct A\<^sub>P"
  and   "bn \<alpha> \<sharp>* subject \<alpha>"
  and   "A\<^sub>P \<sharp>* P"
  and   "A\<^sub>P \<sharp>* \<alpha>"
  and   "A\<^sub>P \<sharp>* C"
  and   "A\<^sub>P \<sharp>* C'"
  and   "bn \<alpha> \<sharp>* P"
  and   "bn \<alpha> \<sharp>* C'"
  and   "\<alpha> \<noteq> \<tau>"

obtains p \<Psi>' A\<^sub>P' \<Psi>\<^sub>P' where "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" and "(p \<bullet> \<Psi>\<^sub>P) \<otimes> \<Psi>' \<simeq> \<Psi>\<^sub>P'" and "distinctPerm p" and
  "extractFrame P' = \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>" and "A\<^sub>P' \<sharp>* P'" and "A\<^sub>P' \<sharp>* \<alpha>" and "A\<^sub>P' \<sharp>* (p \<bullet> \<alpha>)" and
  "A\<^sub>P' \<sharp>* C" and "(bn(p \<bullet> \<alpha>)) \<sharp>* C'" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>" and "(bn(p \<bullet> \<alpha>)) \<sharp>* P'" and "distinct A\<^sub>P'"
proof -
  assume A: "\<And>p \<Psi>' \<Psi>\<^sub>P' A\<^sub>P'.
        \<lbrakk>set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>)); (p \<bullet> \<Psi>\<^sub>P) \<otimes> \<Psi>' \<simeq> \<Psi>\<^sub>P'; distinctPerm p;
                              extractFrame P' = \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>; A\<^sub>P' \<sharp>* P'; A\<^sub>P' \<sharp>* \<alpha>; A\<^sub>P' \<sharp>* (p \<bullet> \<alpha>);
                              A\<^sub>P' \<sharp>* C; (bn(p \<bullet> \<alpha>)) \<sharp>* C'; (bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>; (bn(p \<bullet> \<alpha>)) \<sharp>* P'; distinct A\<^sub>P'\<rbrakk>
        \<Longrightarrow> thesis"

  from Trans have "distinct(bn \<alpha>)" by(auto dest: boundOutputDistinct)

  with Trans \<open>bn \<alpha> \<sharp>* subject \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> have "A\<^sub>P \<sharp>* P'"
    by(drule_tac freeFreshChainDerivative) auto

  {
    fix V :: "'a list"
      and W :: "('a action) list"
      and X :: "name list"
      and Y :: "'b list"
      and Z :: "('a, 'b, 'c) psi list"

    assume "bn \<alpha> \<sharp>* V" and "bn \<alpha> \<sharp>* W" and "bn \<alpha> \<sharp>* X" and "bn \<alpha> \<sharp>* Y" and "bn \<alpha> \<sharp>* Z" and "A\<^sub>P \<sharp>* V" and "A\<^sub>P \<sharp>* W" and "A\<^sub>P \<sharp>* X" and "A\<^sub>P \<sharp>* Y" and "A\<^sub>P \<sharp>* Z"

    with assms obtain p \<Psi>' A\<^sub>P' \<Psi>\<^sub>P' where "set p \<subseteq> set(bn \<alpha>) \<times> set(bn(p \<bullet> \<alpha>))" and "(p \<bullet> \<Psi>\<^sub>P) \<otimes> \<Psi>' \<simeq> \<Psi>\<^sub>P'" and "distinctPerm p"
      and "extractFrame P' = \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>" and "A\<^sub>P' \<sharp>* P'" and "A\<^sub>P' \<sharp>* \<alpha>" and "A\<^sub>P' \<sharp>* (p \<bullet> \<alpha>)"
      and "A\<^sub>P' \<sharp>* C" and "(bn(p \<bullet> \<alpha>)) \<sharp>* C'" and "(bn(p \<bullet> \<alpha>)) \<sharp>* \<alpha>" and "(bn(p \<bullet> \<alpha>)) \<sharp>* P'"
      and "A\<^sub>P' \<sharp>* V" and "A\<^sub>P' \<sharp>* W" and "A\<^sub>P' \<sharp>* X" and "A\<^sub>P' \<sharp>* Y" and "A\<^sub>P' \<sharp>* Z" and "distinct A\<^sub>P'"
      and "(bn(p \<bullet> \<alpha>)) \<sharp>* V" and "(bn(p \<bullet> \<alpha>)) \<sharp>* W" and "(bn(p \<bullet> \<alpha>)) \<sharp>* X" and "(bn(p \<bullet> \<alpha>)) \<sharp>* Y" and "(bn(p \<bullet> \<alpha>)) \<sharp>* Z"
      using \<open>A\<^sub>P \<sharp>* P'\<close> \<open>distinct(bn \<alpha>)\<close>
    proof(nominal_induct \<Psi> P Rs=="\<alpha> \<prec> P'" A\<^sub>P \<Psi>\<^sub>P avoiding: C C' \<alpha> P' V W X Y Z arbitrary: thesis rule: semanticsFrameInduct)
      case(cAlpha \<Psi> P A\<^sub>P \<Psi>\<^sub>P p C C' \<alpha> P' V W X Y Z)
      then obtain q \<Psi>' A\<^sub>P' \<Psi>\<^sub>P' where Sq: "set q \<subseteq> set(bn \<alpha>) \<times> set(bn(q \<bullet> \<alpha>))" and PeqP': "(q \<bullet> \<Psi>\<^sub>P) \<otimes> \<Psi>' \<simeq> \<Psi>\<^sub>P'" and "distinctPerm q"
        and FrP': "extractFrame P' = \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>" and "A\<^sub>P' \<sharp>* P'" and "A\<^sub>P' \<sharp>* \<alpha>" and "A\<^sub>P' \<sharp>* (q \<bullet> \<alpha>)"
        and "A\<^sub>P' \<sharp>* C" and "(bn(q \<bullet> \<alpha>)) \<sharp>* C'" and "(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>" and "(bn(q \<bullet> \<alpha>)) \<sharp>* P'"
        and "A\<^sub>P' \<sharp>* V" and "A\<^sub>P' \<sharp>* W" and "A\<^sub>P' \<sharp>* X" and "A\<^sub>P' \<sharp>* Y" and "A\<^sub>P' \<sharp>* Z" and "distinct A\<^sub>P'"
        and "(bn(q \<bullet> \<alpha>)) \<sharp>* V" and "(bn(q \<bullet> \<alpha>)) \<sharp>* W" and "(bn(q \<bullet> \<alpha>)) \<sharp>* X" and "(bn(q \<bullet> \<alpha>)) \<sharp>* Y" and "(bn(q \<bullet> \<alpha>)) \<sharp>* Z"
        by metis

      have Sp: "set p \<subseteq> set A\<^sub>P \<times> set (p \<bullet> A\<^sub>P)" by fact

      from Sq have "(p \<bullet> set q) \<subseteq> p \<bullet> (set(bn \<alpha>) \<times> set(bn(q \<bullet> \<alpha>)))"
        by(simp add: subsetClosed)
      then have "set(p \<bullet> q) \<subseteq> set(bn(p \<bullet> \<alpha>)) \<times> set(p \<bullet> bn(q \<bullet> \<alpha>))"
        by(simp add: eqvts)
      with \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> Sp have "set(p \<bullet> q) \<subseteq> set(bn \<alpha>) \<times> set(bn((p \<bullet> q) \<bullet> \<alpha>))"
        by(simp add: perm_compose bnEqvt[symmetric])
      moreover from PeqP' have "(p \<bullet> (q \<bullet> \<Psi>\<^sub>P) \<otimes> \<Psi>') \<simeq> (p \<bullet> \<Psi>\<^sub>P')"
        by(simp add: AssertionStatEqClosed)
      then have "((p \<bullet> q) \<bullet> p \<bullet> \<Psi>\<^sub>P) \<otimes> (p \<bullet> \<Psi>') \<simeq> (p \<bullet> \<Psi>\<^sub>P')"
        apply(subst perm_compose[symmetric])
        by(simp add: eqvts)
      moreover from \<open>distinctPerm q\<close> have "distinctPerm (p \<bullet> q)"
        by simp
      moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* C'\<close> have "(p \<bullet> bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> C')"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* C'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* C'\<close> Sp have "bn((p \<bullet> q) \<bullet> \<alpha>) \<sharp>* C'"
        by(simp add: perm_compose bnEqvt[symmetric])
      moreover from FrP' have "(p \<bullet> extractFrame P') = p \<bullet> \<langle>A\<^sub>P', \<Psi>\<^sub>P'\<rangle>" by simp
      with \<open>A\<^sub>P \<sharp>* P'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sp have "extractFrame P' = \<langle>p \<bullet> A\<^sub>P', p \<bullet> \<Psi>\<^sub>P'\<rangle>"
        by(simp add: eqvts)
      moreover from \<open>A\<^sub>P' \<sharp>* P'\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> P')"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* P'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sp have "(p \<bullet> A\<^sub>P') \<sharp>* P'" by simp
      moreover from \<open>A\<^sub>P' \<sharp>* \<alpha>\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> \<alpha>)"
        by(simp only: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> Sp have "(p \<bullet> A\<^sub>P') \<sharp>* \<alpha>" by simp
      moreover from \<open>A\<^sub>P' \<sharp>* C\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> C)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* C\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* C\<close> Sp have "(p \<bullet> A\<^sub>P') \<sharp>* C" by simp
      moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* \<alpha>\<close> have "(p \<bullet> bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> \<alpha>)"
        by(simp only: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> Sp have "bn((p \<bullet> q) \<bullet> \<alpha>) \<sharp>* \<alpha>"
        by(simp add: perm_compose eqvts)
      moreover from \<open>(bn(q \<bullet> \<alpha>)) \<sharp>* P'\<close> have "(p \<bullet> bn(q \<bullet> \<alpha>)) \<sharp>* (p \<bullet> P')"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> \<open>A\<^sub>P \<sharp>* P'\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* P'\<close> Sp have "bn((p \<bullet> q) \<bullet> \<alpha>) \<sharp>* P'"
        by(simp add: perm_compose eqvts)
      moreover from \<open>A\<^sub>P' \<sharp>* (q \<bullet> \<alpha>)\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> q \<bullet> \<alpha>)"
        by(simp only: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with Sp \<open>A\<^sub>P \<sharp>* \<alpha>\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* \<alpha>\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* ((p \<bullet> q) \<bullet> \<alpha>)"
        by(simp add: perm_compose)
      moreover from \<open>A\<^sub>P' \<sharp>* V\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> V)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* V\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* V\<close> Sp have "(p \<bullet> A\<^sub>P') \<sharp>* V" by simp
      moreover from \<open>A\<^sub>P' \<sharp>* W\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> W)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* W\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* W\<close> Sp have "(p \<bullet> A\<^sub>P') \<sharp>* W" by simp
      moreover from \<open>A\<^sub>P' \<sharp>* X\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> X)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* X\<close> \<open>(p \<bullet> A\<^sub>P) \<sharp>* X\<close> Sp have "(p \<bullet> A\<^sub>P') \<sharp>* X" by simp
      moreover from \<open>A\<^sub>P' \<sharp>* Y\<close> have "(p \<bullet> A\<^sub>P') \<sharp>* (p \<bullet> Y)"
        by(simp add: pt_fresh_star_bij[OF pt_name_inst, OF at_name_inst])
      with \<open>A\<^sub>P \<sharp>* Y\<close> \<open>(p \<bulle