(*
 * Copyright 2020, Data61, CSIRO (ABN 41 687 119 230)
 *
 * SPDX-License-Identifier: BSD-2-Clause
 *)

section "Additional Syntax for Word Bit Operations"

theory Word_Syntax
imports
  "HOL-Library.Word"
begin

text \<open>Additional bit and type syntax that forces word types.\<close>

context
  includes bit_operations_syntax
begin

abbreviation
  wordNOT  :: "'a::len word \<Rightarrow> 'a word"      (\<open>(\<open>open_block notation=\<open>prefix ~~\<close>\<close>~~ _)\<close> [70] 71)
where
  "~~ x == NOT x"

abbreviation
  wordAND  :: "'a::len word \<Rightarrow> 'a word \<Rightarrow> 'a word" (infixr \<open>&&\<close> 64)
where
  "a && b == a AND b"

abbreviation
  wordOR   :: "'a::len word \<Rightarrow> 'a word \<Rightarrow> 'a word" (infixr \<open>||\<close>  59)
where
  "a || b == a OR b"

abbreviation
  wordXOR  :: "'a::len word \<Rightarrow> 'a word \<Rightarrow> 'a word" (infixr \<open>xor\<close> 59)
where
  "a xor b == a XOR b"

end

end
