\<^marker>\<open>creator "Kevin Kappelmann"\<close>
section \<open>Monotone Function Relator\<close>
theory Monotone_Function_Relator
  imports
    Reflexive_Relator
begin

abbreviation "Mono_Dep_Fun_Rel (R :: 'a \<Rightarrow> 'a \<Rightarrow> bool) (S :: 'a \<Rightarrow> 'a \<Rightarrow> 'b \<Rightarrow> 'b \<Rightarrow> bool) \<equiv>
  ((x y \<Colon> R) \<Rrightarrow> S x y)\<^sup>\<oplus>"
abbreviation "Mono_Fun_Rel R S \<equiv> Mono_Dep_Fun_Rel R (\<lambda>_ _. S)"

open_bundle Mono_Dep_Fun_Rel_syntax 
begin
notation "Mono_Fun_Rel" (infixr \<open>\<Rrightarrow>\<oplus>\<close> 40)
syntax
  "_Mono_Dep_Fun_Rel_rel" :: "idt \<Rightarrow> idt \<Rightarrow> ('a \<Rightarrow> 'b \<Rightarrow> bool) \<Rightarrow> ('c \<Rightarrow> 'd \<Rightarrow> bool) \<Rightarrow>
    ('a \<Rightarrow> 'c) \<Rightarrow> ('b \<Rightarrow> 'd) \<Rightarrow> bool" (\<open>'(_/ _/ \<Colon>/ _') \<Rrightarrow>\<oplus> (_)\<close> [41, 41, 41, 40] 40)
  "_Mono_Dep_Fun_Rel_rel_if" :: "idt \<Rightarrow> idt \<Rightarrow> ('a \<Rightarrow> 'b \<Rightarrow> bool) \<Rightarrow> bool \<Rightarrow> ('c \<Rightarrow> 'd \<Rightarrow> bool) \<Rightarrow>
    ('a \<Rightarrow> 'c) \<Rightarrow> ('b \<Rightarrow> 'd) \<Rightarrow> bool" (\<open>'(_/ _/ \<Colon>/ _/ |/ _') \<Rrightarrow>\<oplus> (_)\<close> [41, 41, 41, 41, 40] 40)
end
syntax_consts
  "_Mono_Dep_Fun_Rel_rel" "_Mono_Dep_Fun_Rel_rel_if" \<rightleftharpoons> Mono_Dep_Fun_Rel
translations
  "(x y \<Colon> R) \<Rrightarrow>\<oplus> S" \<rightleftharpoons> "CONST Mono_Dep_Fun_Rel R (\<lambda>x y. S)"
  "(x y \<Colon> R | B) \<Rrightarrow>\<oplus> S" \<rightleftharpoons> "CONST Mono_Dep_Fun_Rel R (\<lambda>x y. CONST rel_if B S)"

locale Dep_Fun_Rel_orders =
  fixes L :: "'a \<Rightarrow> 'b \<Rightarrow> bool"
  and R :: "'a \<Rightarrow> 'b \<Rightarrow> 'c \<Rightarrow> 'd \<Rightarrow> bool"
begin

sublocale o : orders L "R a b" for a b .

notation L (infix \<open>\<le>\<^bsub>L\<^esub>\<close> 50)
notation o.ge_left (infix \<open>\<ge>\<^bsub>L\<^esub>\<close> 50)

notation R (\<open>(\<le>\<^bsub>R (_) (_)\<^esub>)\<close> 50)
abbreviation "right_infix c a b d \<equiv> (\<le>\<^bsub>R a b\<^esub>) c d"
notation right_infix (\<open>(_) \<le>\<^bsub>R (_) (_)\<^esub> (_)\<close> [51,51,51,51] 50)

notation o.ge_right (\<open>(\<ge>\<^bsub>R (_) (_)\<^esub>)\<close> 50)

abbreviation (input) "ge_right_infix d a b c \<equiv> (\<ge>\<^bsub>R a b\<^esub>) d c"
notation ge_right_infix (\<open>(_) \<ge>\<^bsub>R (_) (_)\<^esub> (_)\<close> [51,51,51,51] 50)

abbreviation (input) "DFR \<equiv> ((a b \<Colon> L) \<Rrightarrow> R a b)"

end

locale hom_Dep_Fun_Rel_orders = Dep_Fun_Rel_orders L R
  for L :: "'a \<Rightarrow> 'a \<Rightarrow> bool"
  and R :: "'a \<Rightarrow> 'a \<Rightarrow> 'b \<Rightarrow> 'b \<Rightarrow> bool"
begin

sublocale ho : hom_orders L "R a b" for a b .

lemma Mono_Dep_Fun_Refl_Rel_right_eq_Mono_Dep_Fun_if_le_if_reflexive_onI:
  assumes refl_L: "reflexive_on (in_field (\<le>\<^bsub>L\<^esub>)) (\<le>\<^bsub>L\<^esub>)"
  and "\<And>x1 x2. x1 \<le>\<^bsub>L\<^esub> x2 \<Longrightarrow> (\<le>\<^bsub>R x2 x2\<^esub>) \<le> (\<le>\<^bsub>R x1 x2\<^esub>)"
  and "\<And>x1 x2. x1 \<le>\<^bsub>L\<^esub> x2 \<Longrightarrow> (\<le>\<^bsub>R x1 x1\<^esub>) \<le> (\<le>\<^bsub>R x1 x2\<^esub>)"
  shows "((x y \<Colon> (\<le>\<^bsub>L\<^esub>)) \<Rrightarrow>\<oplus> (\<le>\<^bsub>R x y\<^esub>)\<^sup>\<oplus>) = ((x y \<Colon> (\<le>\<^bsub>L\<^esub>)) \<Rrightarrow>\<oplus> (\<le>\<^bsub>R x y\<^esub>))"
proof -
  {
    fix f g x1 x2
    assume "((x y \<Colon> (\<le>\<^bsub>L\<^esub>)) \<Rrightarrow> (\<le>\<^bsub>R x y\<^esub>)) f g" "x1 \<le>\<^bsub>L\<^esub> x1" "x1 \<le>\<^bsub>L\<^esub> x2"
    with assms have "f x1 \<le>\<^bsub>R x1 x2\<^esub> g x1" "f x2 \<le>\<^bsub>R x1 x2\<^esub> g x2" by blast+
  }
  with refl_L show ?thesis
    by (intro ext iffI Refl_RelI Dep_Fun_Rel_relI) (auto elim!: Refl_RelE)
qed

lemma Mono_Dep_Fun_Refl_Rel_right_eq_Mono_Dep_Fun_if_mono_if_reflexive_onI:
  assumes "reflexive_on (in_field (\<le>\<^bsub>L\<^esub>)) (\<le>\<^bsub>L\<^esub>)"
  and "((x1 x2 \<Colon> (\<ge>\<^bsub>L\<^esub>)) \<Rightarrow> (x3 x4 \<Colon> (\<le>\<^bsub>L\<^esub>) | x1 \<le>\<^bsub>L\<^esub> x3) \<Rrightarrow> (\<le>)) R"
  shows "((x y \<Colon> (\<le>\<^bsub>L\<^esub>)) \<Rrightarrow>\<oplus> (\<le>\<^bsub>R x y\<^esub>)\<^sup>\<oplus>) = ((x y \<Colon> (\<le>\<^bsub>L\<^esub>)) \<Rrightarrow>\<oplus> (\<le>\<^bsub>R x y\<^esub>))"
  using assms
  by (intro Mono_Dep_Fun_Refl_Rel_right_eq_Mono_Dep_Fun_if_le_if_reflexive_onI)
  (auto 6 0)

end

context hom_orders
begin

sublocale fro : hom_Dep_Fun_Rel_orders L "\<lambda>_ _. R" .

corollary Mono_Fun_Rel_Refl_Rel_right_eq_Mono_Fun_RelI:
  assumes "reflexive_on (in_field (\<le>\<^bsub>L\<^esub>)) (\<le>\<^bsub>L\<^esub>)"
  shows "((\<le>\<^bsub>L\<^esub>) \<Rrightarrow>\<oplus> (\<le>\<^bsub>R\<^esub>)\<^sup>\<oplus>) = ((\<le>\<^bsub>L\<^esub>) \<Rrightarrow>\<oplus> (\<le>\<^bsub>R\<^esub>))"
  using assms by (intro fro.Mono_Dep_Fun_Refl_Rel_right_eq_Mono_Dep_Fun_if_le_if_reflexive_onI)
  simp_all

end


end
