(*  Author:     Ata Keskin, TU München 
*)

theory Measure_Space_Supplement
  imports "HOL-Analysis.Measure_Space"
begin

section \<open>Supplementary Lemmas for Measure Spaces\<close>

subsection \<open>\<open>\<sigma>\<close>-Algebra Generated by a Family of Functions\<close>

definition family_vimage_algebra :: "'a set \<Rightarrow> ('a \<Rightarrow> 'b) set \<Rightarrow> 'b measure \<Rightarrow> 'a measure" where
  "family_vimage_algebra \<Omega> S M \<equiv> sigma \<Omega> (\<Union>f \<in> S. {f -` A \<inter> \<Omega> | A. A \<in> M})"

text \<open>For singleton \<^term>\<open>S\<close>, i.e. \<^term>\<open>S = {f}\<close> for some \<^term>\<open>f\<close>, the definition simplifies to that of \<^term>\<open>vimage_algebra\<close>.\<close>

lemma family_vimage_algebra_singleton: "family_vimage_algebra \<Omega> {f} M = vimage_algebra \<Omega> f M" unfolding family_vimage_algebra_def vimage_algebra_def by simp

lemma
  shows sets_family_vimage_algebra: "sets (family_vimage_algebra \<Omega> S M) = sigma_sets \<Omega> (\<Union>f \<in> S. {f -` A \<inter> \<Omega> | A. A \<in> M})" 
    and space_family_vimage_algebra[simp]: "space (family_vimage_algebra \<Omega> S M) = \<Omega>"
  by (auto simp add: family_vimage_algebra_def sets_measure_of_conv space_measure_of_conv)

lemma measurable_family_vimage_algebra:
  assumes "f \<in> S" "f \<in> \<Omega> \<rightarrow> space M"
  shows "f \<in> family_vimage_algebra \<Omega> S M \<rightarrow>\<^sub>M M"
  using assms by (intro measurableI, auto simp add: sets_family_vimage_algebra)

lemma measurable_family_vimage_algebra_singleton:
  assumes "f \<in> \<Omega> \<rightarrow> space M"
  shows "f \<in> family_vimage_algebra \<Omega> {f} M \<rightarrow>\<^sub>M M"
  using assms measurable_family_vimage_algebra by blast

text \<open>A collection of functions are measurable with respect to some \<open>\<sigma>\<close>-algebra \<^term>\<open>N\<close>, if and only if the \<open>\<sigma>\<close>-algebra they generate is contained in \<^term>\<open>N\<close>.\<close>
lemma measurable_family_iff_sets:
  shows "(S \<subseteq> N \<rightarrow>\<^sub>M M) \<longleftrightarrow> S \<subseteq> space N \<rightarrow> space M \<and> family_vimage_algebra (space N) S M \<subseteq> N"
proof (standard, goal_cases)
  case 1
  hence subset: "S \<subseteq> space N \<rightarrow> space M" using measurable_space by fast
  have "{f -` A \<inter> space N |A. A \<in> M} \<subseteq> N" if "f \<in> S" for f using measurable_iff_sets[unfolded family_vimage_algebra_singleton[symmetric], of f] 1 subset that by (fastforce simp add: sets_family_vimage_algebra)
  then show ?case unfolding sets_family_vimage_algebra using sets.sigma_algebra_axioms by (simp add: subset, intro sigma_algebra.sigma_sets_subset, blast+)
next
  case 2
  hence subset: "S \<subseteq> space N \<rightarrow> space M" by simp
  show ?case
  proof (standard, goal_cases)
    case (1 x)
    have "family_vimage_algebra (space N) {x} M \<subseteq> N" by (metis (no_types, lifting) 1 2 sets_family_vimage_algebra SUP_le_iff sigma_sets_le_sets_iff singletonD)
    thus ?case using measurable_iff_sets[unfolded family_vimage_algebra_singleton[symmetric]] subset[THEN subsetD, OF 1] by fast 
  qed
qed

lemma family_vimage_algebra_diff:
  shows "family_vimage_algebra \<Omega> S M = sigma \<Omega> (sets (family_vimage_algebra \<Omega> (S - I) M) \<union> family_vimage_algebra \<Omega> (S \<inter> I) M)"
  using sets.space_closed space_measure_of_conv 
  unfolding family_vimage_algebra_def sets_family_vimage_algebra
  by (intro sigma_eqI, blast, fastforce)
     (intro sigma_sets_eqI, blast, simp add: sets_measure_of_conv split: if_splits, 
      meson Diff_subset Sup_subset_mono in_mono inf_sup_ord(1) sigma_sets_subseteq subset_image_iff, fastforce+)

end