theory AbstractDenotational
imports HeapSemantics Terms
begin

subsubsection \<open>The denotational semantics for expressions\<close>

text \<open>
Because we need to define two semantics later on, we are abstract in the actual domain.
\<close>

locale semantic_domain =
  fixes Fn :: "('Value \<rightarrow> 'Value) \<rightarrow> ('Value::{pcpo_pt,pure})"
  fixes Fn_project :: "'Value \<rightarrow> ('Value \<rightarrow> 'Value)"
  fixes B :: "bool discr \<rightarrow> 'Value"
  fixes B_project :: "'Value \<rightarrow> 'Value \<rightarrow> 'Value \<rightarrow> 'Value"
  fixes tick :: "'Value \<rightarrow> 'Value"
begin

nominal_function
  ESem :: "exp \<Rightarrow> (var \<Rightarrow> 'Value) \<rightarrow> 'Value"
where (*
  Restrict \<rho> to avoid having to demand atom x \<sharp> \<rho> *)
 "ESem (Lam [x]. e) = (\<Lambda> \<rho>. tick\<cdot>(Fn\<cdot>(\<Lambda> v. ESem e\<cdot>((\<rho> f|` fv (Lam [x]. e))(x := v)))))" (*
  Do not use \<lbrakk> Var x \<rbrakk>\<^bsub>\<rho>\<^esub>  in the rule for App; it costs an additional
  resource and makes the adequacy proof difficult. *)
| "ESem (App e x) = (\<Lambda> \<rho>. tick\<cdot>(Fn_project\<cdot>(ESem e\<cdot>\<rho>)\<cdot>(\<rho> x)))"
| "ESem (Var x) = (\<Lambda> \<rho>. tick\<cdot>(\<rho> x))"
| "ESem (Let as body) = (\<Lambda> \<rho>. tick\<cdot>(ESem body\<cdot>(has_ESem.HSem ESem as\<cdot>(\<rho> f|` fv (Let as body)))))"
| "ESem (Bool b) = (\<Lambda> \<rho>. tick\<cdot>(B\<cdot>(Discr b)))"
| "ESem (scrut ? e1 : e2) = (\<Lambda> \<rho>. tick\<cdot>((B_project\<cdot>(ESem scrut\<cdot>\<rho>))\<cdot>(ESem e1\<cdot>\<rho>)\<cdot>(ESem e2\<cdot>\<rho>)))"
proof goal_cases
txt \<open>The following proofs discharge technical obligations generated by the Nominal package.\<close>

case 1 thus ?case
  unfolding eqvt_def ESem_graph_aux_def
  apply rule
  apply (perm_simp)
  apply (simp add: Abs_cfun_eqvt)
  apply (simp add: unpermute_def permute_pure)
  done
next
case (3 P x)
  thus ?case by (metis (poly_guards_query) exp_strong_exhaust)
next

case prems: (4 x e x' e')
  from prems(5)
  show ?case
  proof (rule eqvt_lam_case)
    fix \<pi> :: perm
    assume *: "supp (-\<pi>) \<sharp>* (fv (Lam [x]. e) :: var set)"
    { fix \<rho> v
      have "ESem_sumC (\<pi> \<bullet> e)\<cdot>((\<rho> f|` fv (Lam [x]. e))((\<pi> \<bullet> x) := v)) = - \<pi> \<bullet> ESem_sumC (\<pi> \<bullet> e)\<cdot>((\<rho> f|` fv (Lam [x]. e))((\<pi> \<bullet> x) := v))"
        by (simp add: permute_pure)
      also have "\<dots> = ESem_sumC e\<cdot>((- \<pi> \<bullet> (\<rho> f|` fv (Lam [x]. e)))(x := v))" by (simp add: pemute_minus_self eqvt_at_apply[OF prems(1)])
      also have "- \<pi> \<bullet> (\<rho> f|` fv (Lam [x]. e)) = (\<rho> f|` fv (Lam [x]. e))"  by (rule env_restr_perm'[OF *]) auto 
      finally have "ESem_sumC (\<pi> \<bullet> e)\<cdot>((\<rho> f|` fv (Lam [x]. e))((\<pi> \<bullet> x) := v)) = ESem_sumC e\<cdot>((\<rho> f|` fv (Lam [x]. e))(x := v))".
    }
    thus " (\<Lambda> \<rho>. tick\<cdot>(Fn\<cdot>(\<Lambda> v. ESem_sumC (\<pi> \<bullet> e)\<cdot>((\<rho> f|` fv (Lam [x]. e))(\<pi> \<bullet> x := v))))) = (\<Lambda> \<rho>. tick\<cdot>(Fn\<cdot>(\<Lambda> v. ESem_sumC e\<cdot>((\<rho> f|` fv (Lam [x]. e))(x := v)))))" by simp
  qed
next

case prems: (19 as body as' body')
  from prems(9)
  show ?case
  proof (rule eqvt_let_case)
    fix \<pi> :: perm
    assume *: "supp (-\<pi>) \<sharp>* (fv (Terms.Let as body) :: var set)"

    { fix \<rho>
      have "ESem_sumC (\<pi> \<bullet> body)\<cdot>(has_ESem.HSem ESem_sumC (\<pi> \<bullet> as)\<cdot>(\<rho> f|` fv (Terms.Let as body)))
         = - \<pi> \<bullet> ESem_sumC (\<pi> \<bullet> body)\<cdot>(has_ESem.HSem ESem_sumC (\<pi> \<bullet> as)\<cdot>(\<rho> f|` fv (Terms.Let as body)))"
         by (rule permute_pure[symmetric])
      also have "\<dots> = (- \<pi> \<bullet> ESem_sumC) body\<cdot>(has_ESem.HSem (- \<pi> \<bullet> ESem_sumC) as\<cdot>(- \<pi> \<bullet> \<rho> f|` fv (Terms.Let as body)))"
        by (simp add: pemute_minus_self)
      also have "(- \<pi> \<bullet> ESem_sumC) body = ESem_sumC body"
        by (rule eqvt_at_apply[OF \<open>eqvt_at ESem_sumC body\<close>])
      also have "has_ESem.HSem (- \<pi> \<bullet> ESem_sumC) as = has_ESem.HSem  ESem_sumC as"
        by (rule HSem_cong[OF eqvt_at_apply[OF prems(2)] refl])
      also have "- \<pi> \<bullet> \<rho> f|` fv (Let as body) = \<rho> f|` fv (Let as body)"
        by (rule env_restr_perm'[OF *], simp)
      finally have "ESem_sumC (\<pi> \<bullet> body)\<cdot>(has_ESem.HSem ESem_sumC (\<pi> \<bullet> as)\<cdot>(\<rho> f|` fv (Let as body))) = ESem_sumC body\<cdot>(has_ESem.HSem ESem_sumC as\<cdot>(\<rho> f|` fv (Let as body)))".
    }
    thus "(\<Lambda> \<rho>. tick\<cdot>(ESem_sumC (\<pi> \<bullet> body)\<cdot>(has_ESem.HSem ESem_sumC (\<pi> \<bullet> as)\<cdot>(\<rho> f|` fv (Let as body))))) =
         (\<Lambda> \<rho>. tick\<cdot>(ESem_sumC body\<cdot>(has_ESem.HSem ESem_sumC as\<cdot>(\<rho> f|` fv (Let as body)))))" by (simp only:)
  qed
qed auto
(* [eqvt] attributes do not survive instantiation, so we pass (no_eqvt) here. We don't need it
   anyways\<dots> *)
nominal_termination (in semantic_domain) (no_eqvt) by lexicographic_order

sublocale has_ESem ESem.

notation ESem_syn (\<open>\<lbrakk> _ \<rbrakk>\<^bsub>_\<^esub>\<close>  [60,60] 60)
notation EvalHeapSem_syn  (\<open>\<^bold>\<lbrakk> _ \<^bold>\<rbrakk>\<^bsub>_\<^esub>\<close>  [0,0] 110)
notation HSem_syn (\<open>\<lbrace>_\<rbrace>_\<close>  [60,60] 60)
abbreviation AHSem_bot (\<open>\<lbrace>_\<rbrace>\<close>  [60] 60) where "\<lbrace>\<Gamma>\<rbrace> \<equiv> \<lbrace>\<Gamma>\<rbrace>\<bottom>"

end
end

