(*
  File:      Elimination_Of_Repeated_Factors/ERF_Library.thy
  Authors:   Katharina Kreuzer (TU München)
             Manuel Eberl (University of Innsbruck)

  Some auxiliary facts, mostly about polynomials. Should probably
  be moved elsewhere (TODO).
*)
theory ERF_Library
imports
  Mason_Stothers.Mason_Stothers
  Berlekamp_Zassenhaus.Berlekamp_Type_Based
  Perfect_Fields.Perfect_Fields 
begin

(* TODO: some of these are probably unnecessary (Manuel) *)

hide_const (open) Formal_Power_Series.radical

section \<open>Auxiliary Lemmas\<close>
(* TODO: re-arrange placements! *)


text \<open>If all factors are monic, the product is monic as well (i.e.\ the normalization is itself).\<close>
lemma normalize_prod_monics:
  assumes "\<forall>x\<in>A. monic x"
  shows "normalize (\<Prod>x\<in>A. x^(e x)) = (\<Prod>x\<in>A. x^(e x))"
  by (simp add: assms monic_power monic_prod normalize_monic)

text \<open>All primes are monic.\<close>
lemma prime_monic:
  fixes p :: "'a :: {euclidean_ring_gcd,field} poly"
  assumes "p\<noteq>0" "prime p" shows "monic p"
  using normalize_prime[OF assms(2)] monic_normalize[OF assms(1)] by auto


text \<open>If we know the factorization of a polynomial, we can explicitly characterize the derivative 
of said polynomial.\<close>

lemma pderiv_exp_prod_monic: 
assumes "p = prod_mset fs" 
shows "pderiv p = (sum (\<lambda> fi. let ei = count fs fi in
    Polynomial.smult (of_nat ei) (pderiv fi) * fi^(ei-1) * prod (\<lambda> fj. fj^(count fs fj)) 
    ((set_mset fs) - {fi})) (set_mset fs))"
proof -
  have pderiv_fi: "pderiv (fi ^ count fs fi) = 
    Polynomial.smult (of_nat (count fs fi)) (pderiv fi * (fi ^ (count fs fi - Suc 0)))" 
    if "fi \<in># fs" for fi
  proof -
    obtain i where i: "Suc i = count fs fi" by (metis \<open>fi \<in># fs\<close> in_countE)
    show ?thesis unfolding i[symmetric] by (subst pderiv_power_Suc) (auto simp add: algebra_simps)
  qed
  show ?thesis unfolding assms prod_mset_multiplicity pderiv_prod sum_distrib_left Let_def
    by (rule sum.cong[OF refl]) (auto simp add: algebra_simps pderiv_fi)
qed


text \<open>Any element that divides a prime is either congruent to the prime (i.e.\ \<open>p dvd c\<close>) or 
a unit itself. Careful: This does not mean that $p=c$ since there could be another unit $u$ such 
that $p = u*c$.\<close>

lemma prime_factors_prime:
  assumes "c dvd p" "prime p"
  shows "is_unit c \<or> p dvd c"
  using assms unfolding normalization_semidom_class.prime_def
  by (meson prime_elemD2)


text \<open>A prime polynomial has degree greater than zero. This is clear since any polynomial of 
degree 0 is constant and thus also a unit.\<close>

lemma prime_degree_gt_zero:
  fixes p::"'a::{idom_divide,semidom_divide_unit_factor,field} poly"
  assumes "prime p"
  shows "degree p > 0"
  using assms by fastforce


text \<open>This lemma helps to reason that if a sum is zero, under some conditions we can follow that 
the summands must also be zero.\<close>
lemma one_summand_zero:
  fixes a2::"'a ::field poly"
  assumes "Polynomial.smult a1 a2 + b = 0""c dvd b" "\<not> c dvd a2"
  shows "a1 = 0"
  by (metis assms dvd_0_right dvd_add_triv_right_iff dvd_smult_cancel dvd_trans)


subsection \<open>Lemmas for the \<open>radical\<close> of polynomials\<close>


text \<open>Properties of the function \<open>radical\<close>. 
Note: The radical polynomial in algebra denotes something else. Here, \<open>radical\<close> denotes the 
square-free and monic part of a polynomial (i.e.\ the product of all prime factors). This notion
corresponds to radical ideals generated by square-free polynomials.\<close>


lemma squarefree_radical [intro]: "f \<noteq> 0 \<Longrightarrow> squarefree (radical f)"
  by (simp add: in_prime_factors_iff multiplicity_radical_prime squarefree_factorial_semiring')

(* TODO Move *)
lemma (in normalization_semidom_multiplicative) normalize_prod:
  "normalize (\<Prod>x\<in>A. f (x :: 'b) :: 'a) = (\<Prod>x\<in>A. normalize (f x))"
  by (induction A rule: infinite_finite_induct) (auto simp: normalize_mult)

(* TODO: maybe radical should be defined differently to always be normalized *)
lemma normalize_radical [simp]:
  fixes f :: "'a :: factorial_semiring_multiplicative"
  shows "normalize (radical f) = radical f"
  by (auto simp: radical_def normalize_prod in_prime_factors_iff normalize_prime intro!: prod.cong)

lemma radical_of_squarefree:
  assumes "squarefree f"
  shows   "normalize (radical f) = normalize f"
proof -
  from assms have [simp]: "f \<noteq> 0"
    by auto
  have "normalize (\<Prod>\<^sub># (prime_factorization f)) = normalize f"
    by (intro prod_mset_prime_factorization_weak) auto
  also have "prime_factorization f = mset_set (prime_factors f)"
    using assms
    by (intro multiset_eqI)
       (auto simp: count_prime_factorization count_mset_set' squarefree_factorial_semiring'
                   in_prime_factors_iff not_dvd_imp_multiplicity_0)
  also have "prod_mset (mset_set (prime_factors f)) = radical f"
    by (simp add: radical_def prod_unfold_prod_mset)
  finally show ?thesis
    by simp
qed




text \<open>A constant polynomial has no primes in its prime factorization and its radical is 1. \<close>

lemma prime_factorization_degree0:
  fixes f :: "'a :: {factorial_ring_gcd,semiring_gcd_mult_normalize,field} poly"
  assumes "degree f = 0"
  shows "prime_factorization f = {#}"
  by (simp add: assms prime_factorization_empty_iff)


lemma prime_factors_degree0:
  fixes f :: "'a :: {factorial_ring_gcd,semiring_gcd_mult_normalize,field} poly"
  assumes "degree f = 0" "f\<noteq>0"
  shows "prime_factors f = {}"
  using prime_factorization_degree0 assms by auto

lemma radical_degree0:
  fixes f :: "'a :: {factorial_ring_gcd,semiring_gcd_mult_normalize,field} poly"
  assumes "degree f = 0" "f\<noteq>0"
  shows "radical f = 1"
  by (simp add: assms is_unit_iff_degree)

text \<open>A polynomial is square-free iff its normalization is also square-free.\<close>

lemma squarefree_normalize:
  "squarefree f \<longleftrightarrow> squarefree (normalize f)"
  by (simp add: squarefree_def)

text \<open>Important: The zeros of a polynomial are also zeros of its \<open>radical\<close> and vice versa.\<close>

lemma same_zeros_radical: "(poly f a = 0) = (poly (radical f) a = 0)"
proof (cases "f = 0")
  case True show ?thesis unfolding True radical_def by auto
next
  case False
  have fin: "finite (prime_factors f)" by simp
  have f: "f = unit_factor f * prod_mset (prime_factorization f)"
    by (metis False in_prime_factors_imp_prime normalize_prime normalized_prod_msetI 
        prod_mset_prime_factorization_weak unit_factor_mult_normalize)
  have "poly (unit_factor f) a\<noteq>0" using False poly_zero by fastforce
  moreover have "((\<Prod>p\<in>#prime_factorization f. poly p a) = 0)=((\<Prod>k\<in>prime_factors f. poly k a) = 0)"
    by (subst prod_mset_zero_iff,subst prod_zero_iff[OF fin]) auto
  ultimately have "(poly f a = 0) = (poly (\<Prod>(prime_factors f)) a = 0)" 
    by (subst f, subst poly_prod, subst poly_mult, subst poly_hom.hom_prod_mset) auto
  then show ?thesis unfolding radical_def using False by auto
qed

subsection \<open>More on square-free polynomials\<close>

text \<open>We need to relate two different versions of the definition of a square-free polynomial
(i.e.\ the functions \<open>squarefree\<close> and \<open>square_free\<close>). Over fields, they differ only in their 
behavior at $0$.)\<close>

lemma squarefree_square_free:
  fixes x :: "'a :: {field} poly"
  assumes "x \<noteq> 0"
  shows "squarefree x = square_free x"
  using assms unfolding squarefree_def square_free_def proof (safe, goal_cases)
  case (1 q)
  have "q dvd 1" using 1(2,4) by (metis power2_eq_square)
  then have "degree q = 0" using poly_dvd_1[of q] by auto
  then show ?case using 1(3) by auto
next
  case (2 y)
  then have "degree y = 0" by (metis bot_nat_0.not_eq_extremum power2_eq_square)
  have "y\<noteq>0" using 2(2,4) by fastforce
  show ?case using is_unit_iff_degree[OF \<open>y\<noteq>0\<close>] \<open>degree y = 0\<close> by auto
qed

lemma (in comm_monoid_mult) prod_list_distinct_conv_prod_set:
  "distinct xs \<Longrightarrow> prod_list (map (f :: 'b \<Rightarrow> 'a) xs) = prod f (set xs)"
  by (simp add: local.prod.distinct_set_conv_list)

lemma (in comm_monoid_mult) interv_prod_list_conv_prod_set_nat:
  "prod_list (map (f :: nat \<Rightarrow> 'a) [m..<n]) = prod f (set [m..<n])"
  by (metis distinct_upt local.prod.distinct_set_conv_list)

lemma (in comm_monoid_mult) prod_list_prod_nth:
  "prod_list (xs :: 'a list) = (\<Prod> i = 0 ..< length xs. xs ! i)"
  using interv_prod_list_conv_prod_set_nat [of "(!) xs" 0 "length xs"] by (simp add: map_nth)

lemma squarefree_mult_imp_coprime [dest]:
  assumes "squarefree (x * y)"
  shows   "coprime x y"
proof (rule coprimeI)
  fix d assume "d dvd x" "d dvd y"
  hence "d ^ 2 dvd x * y"
    by (simp add: mult_dvd_mono power2_eq_square)
  thus "d dvd 1"
    using assms unfolding squarefree_def by blast
qed

end
