chapter \<open>Generated by Lem from \<open>relation.lem\<close>.\<close>

theory "Lem_relation" 

imports
  Main
  "Lem_bool"
  "Lem_basic_classes"
  "Lem_tuple"
  "Lem_set"
  "Lem_num"

begin 



\<comment> \<open>\<open>open import Bool Basic_classes Tuple Set Num\<close>\<close>
\<comment> \<open>\<open>open import {hol} `set_relationTheory`\<close>\<close>

\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> The type of relations                                                      \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

type_synonym( 'a, 'b) rel_pred =" 'a \<Rightarrow> 'b \<Rightarrow> bool "
type_synonym( 'a, 'b) rel_set =" ('a * 'b) set "

\<comment> \<open>\<open> Binary relations are usually represented as either
   sets of pairs (rel_set) or as curried functions (rel_pred). 
   
   The choice depends on taste and the backend. Lem should not take a 
   decision, but supports both representations. There is an abstract type
   pred, which can be converted to both representations. The representation
   of pred itself then depends on the backend. However, for the time beeing,
   let's implement relations as sets to get them working more quickly. \<close>\<close>

type_synonym( 'a, 'b) rel =" ('a, 'b) rel_set "

\<comment> \<open>\<open>val relToSet : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b -> rel_set 'a 'b\<close>\<close>
\<comment> \<open>\<open>val relFromSet : forall 'a 'b. SetType 'a, SetType 'b => rel_set 'a 'b -> rel 'a 'b\<close>\<close>

\<comment> \<open>\<open>val relEq : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b -> rel 'a 'b -> bool\<close>\<close>
definition relEq  :: "('a*'b)set \<Rightarrow>('a*'b)set \<Rightarrow> bool "  where 
     " relEq r1 r2 = ( (r1 = r2))"


\<comment> \<open>\<open>val relToPred : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a, Eq 'b => rel 'a 'b -> rel_pred 'a 'b\<close>\<close>
\<comment> \<open>\<open>val relFromPred : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a, Eq 'b => set 'a -> set 'b -> rel_pred 'a 'b -> rel 'a 'b\<close>\<close>

definition relToPred  :: "('a*'b)set \<Rightarrow> 'a \<Rightarrow> 'b \<Rightarrow> bool "  where 
     " relToPred r = ( (\<lambda> x y .  (x, y) \<in> r))"

definition relFromPred  :: " 'a set \<Rightarrow> 'b set \<Rightarrow>('a \<Rightarrow> 'b \<Rightarrow> bool)\<Rightarrow>('a*'b)set "  where 
     " relFromPred xs ys p = ( set_filter ( \<lambda>x .  
  (case  x of (x,y) => p x y )) (xs \<times> ys))"


 
\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Basic Operations                                                           \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> membership test         \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val inRel : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a, Eq 'b => 'a -> 'b -> rel 'a 'b -> bool\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> empty relation          \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relEmpty : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Insertion               \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relAdd : forall 'a 'b. SetType 'a, SetType 'b => 'a -> 'b -> rel 'a 'b -> rel 'a 'b\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Identity relation       \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relIdOn : forall 'a. SetType 'a, Eq 'a => set 'a -> rel 'a 'a\<close>\<close>
definition relIdOn  :: " 'a set \<Rightarrow>('a*'a)set "  where 
     " relIdOn s = ( relFromPred s s (=))"


\<comment> \<open>\<open>val relId : forall 'a. SetType 'a, Eq 'a => rel 'a 'a\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> relation union          \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relUnion : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b -> rel 'a 'b -> rel 'a 'b\<close>\<close> 

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> relation intersection   \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relIntersection : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a, Eq 'b => rel 'a 'b -> rel 'a 'b -> rel 'a 'b\<close>\<close> 

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Relation Composition    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relComp : forall 'a 'b 'c. SetType 'a, SetType 'b, SetType 'c, Eq 'a, Eq 'b => rel 'a 'b -> rel 'b 'c -> rel 'a 'c\<close>\<close>
\<comment> \<open>\<open>let relComp r1 r2=  relFromSet {(e1, e3) | forall ((e1,e2) IN (relToSet r1)) ((e2',e3) IN (relToSet r2)) | e2 = e2'}\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> restrict                \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relRestrict : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> rel 'a 'a\<close>\<close>
definition relRestrict  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow>('a*'a)set "  where 
     " relRestrict r s = ( ((let x2 = 
  ({}) in  Finite_Set.fold
   (\<lambda>a x2 .  Finite_Set.fold
                       (\<lambda>b x2 . 
                        if (a, b) \<in> r then Set.insert (a, b) x2 else x2)
                       x2 s) x2 s)))"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Converse                \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relConverse : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b -> rel 'b 'a\<close>\<close>
\<comment> \<open>\<open>let relConverse r=  relFromSet (Set.map swap (relToSet r))\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> domain                  \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relDomain : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b -> set 'a\<close>\<close>
\<comment> \<open>\<open>let relDomain r=  Set.map (fun x -> fst x) (relToSet r)\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> range                   \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relRange : forall 'a 'b. SetType 'a, SetType 'b => rel 'a 'b -> set 'b\<close>\<close>
\<comment> \<open>\<open>let relRange r=  Set.map (fun x -> snd x) (relToSet r)\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> field / definedOn       \<close>\<close>
\<comment> \<open>\<open>                         \<close>\<close>
\<comment> \<open>\<open> avoid the keyword field \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relDefinedOn : forall 'a. SetType 'a => rel 'a 'a -> set 'a\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> relOver                 \<close>\<close>
\<comment> \<open>\<open>                         \<close>\<close>
\<comment> \<open>\<open> avoid the keyword field \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val relOver : forall 'a. SetType 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition relOver  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " relOver r s = ( ((((Domain r) \<union> (Range r))) \<subseteq> s))"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> apply a relation        \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> Given a relation r and a set s, relApply r s applies s to r, i.e.
   it returns the set of all value reachable via r from a value in s.
   This operation can be seen as a generalisation of function application. \<close>\<close>
   
\<comment> \<open>\<open>val relApply : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a => rel 'a 'b -> set 'a -> set 'b\<close>\<close>
\<comment> \<open>\<open>let relApply r s=  { y | forall ((x, y) IN (relToSet r)) | x IN s }\<close>\<close>


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Properties                                                                 \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> subrel                  \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isSubrel : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a, Eq 'b => rel 'a 'b -> rel 'a 'b -> bool\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> reflexivity             \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isReflexiveOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isReflexiveOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isReflexiveOn r s = ( ((\<forall> e \<in> s.  (e, e) \<in> r)))"


\<comment> \<open>\<open>val isReflexive : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let ~{ocaml;coq} isReflexive r=  (forall e. inRel e e r)\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> irreflexivity           \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isIrreflexiveOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isIrreflexiveOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isIrreflexiveOn r s = ( ((\<forall> e \<in> s.  \<not> ((e, e) \<in> r))))"


\<comment> \<open>\<open>val isIrreflexive : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let isIrreflexive r=  (forall ((e1, e2) IN (relToSet r)). not (e1 = e2))\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> symmetry                \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isSymmetricOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isSymmetricOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isSymmetricOn r s = ( ((\<forall> e1 \<in> s. \<forall> e2 \<in> s.  ((e1, e2) \<in> r) \<longrightarrow> ((e2, e1) \<in> r))))"


\<comment> \<open>\<open>val isSymmetric : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let isSymmetric r=  (forall ((e1, e2) IN relToSet r). inRel e2 e1 r)\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> antisymmetry            \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isAntisymmetricOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isAntisymmetricOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isAntisymmetricOn r s = ( ((\<forall> e1 \<in> s. \<forall> e2 \<in> s.  ((e1, e2) \<in> r) \<longrightarrow> (((e2, e1) \<in> r) \<longrightarrow> (e1 = e2)))))"


\<comment> \<open>\<open>val isAntisymmetric : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let isAntisymmetric r=  (forall ((e1, e2) IN relToSet r). (inRel e2 e1 r) --> (e1 = e2))\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> transitivity            \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isTransitiveOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isTransitiveOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isTransitiveOn r s = ( ((\<forall> e1 \<in> s. \<forall> e2 \<in> s. \<forall> e3 \<in> s.  ((e1, e2) \<in> r) \<longrightarrow> (((e2, e3) \<in> r) \<longrightarrow> ((e1, e3) \<in> r)))))"


\<comment> \<open>\<open>val isTransitive : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let isTransitive r=  (forall ((e1, e2) IN relToSet r) (e3 IN relApply r {e2}). inRel e1 e3 r)\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> total                   \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isTotalOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isTotalOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isTotalOn r s = ( ((\<forall> e1 \<in> s. \<forall> e2 \<in> s.  ((e1, e2) \<in> r) \<or> ((e2, e1) \<in> r))))"



\<comment> \<open>\<open>val isTotal : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let ~{ocaml;coq} isTotal r=  (forall e1 e2. (inRel e1 e2 r) || (inRel e2 e1 r))\<close>\<close>

\<comment> \<open>\<open>val isTrichotomousOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isTrichotomousOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isTrichotomousOn r s = ( ((\<forall> e1 \<in> s. \<forall> e2 \<in> s.  ((e1, e2) \<in> r) \<or> ((e1 = e2) \<or> ((e2, e1) \<in> r)))))"


\<comment> \<open>\<open>val isTrichotomous : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isTrichotomous  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isTrichotomous r = ( ((\<forall> e1. \<forall> e2.  ((e1, e2) \<in> r) \<or> ((e1 = e2) \<or> ((e2, e1) \<in> r)))))"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> is_single_valued        \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isSingleValued : forall 'a 'b. SetType 'a, SetType 'b, Eq 'a, Eq 'b => rel 'a 'b -> bool\<close>\<close>
definition isSingleValued  :: "('a*'b)set \<Rightarrow> bool "  where 
     " isSingleValued r = ( ((\<forall> (e1, e2a) \<in> r. \<forall> e2b \<in> Image r {e1}.  e2a = e2b)))"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> equivalence relation    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isEquivalenceOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isEquivalenceOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isEquivalenceOn r s = ( isReflexiveOn r s \<and> (isSymmetricOn r s \<and> isTransitiveOn r s))"



\<comment> \<open>\<open>val isEquivalence : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isEquivalence  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isEquivalence r = ( refl r \<and> (sym r \<and> trans r))"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> well founded            \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isWellFounded : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isWellFounded  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isWellFounded r = ( ((\<forall> P.  ((\<forall> x.  ((\<forall> y.  ((y, x) \<in> r) \<longrightarrow> P x)) \<longrightarrow> P x)) \<longrightarrow> ((\<forall> x.  P x)))))"



\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Orders                                                                     \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> pre- or quasiorders     \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isPreorderOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isPreorderOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isPreorderOn r s = ( isReflexiveOn r s \<and> isTransitiveOn r s )"


\<comment> \<open>\<open>val isPreorder : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isPreorder  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isPreorder r = ( refl r \<and> trans r )"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> partial orders          \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isPartialOrderOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isPartialOrderOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isPartialOrderOn r s = ( isReflexiveOn r s \<and> (isTransitiveOn r s \<and> isAntisymmetricOn r s))"



\<comment> \<open>\<open>val isStrictPartialOrderOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isStrictPartialOrderOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isStrictPartialOrderOn r s = ( isIrreflexiveOn r s \<and> isTransitiveOn r s )"



\<comment> \<open>\<open>val isStrictPartialOrder : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isStrictPartialOrder  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isStrictPartialOrder r = ( irrefl r \<and> trans r )"


\<comment> \<open>\<open>val isPartialOrder : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isPartialOrder  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isPartialOrder r = ( refl r \<and> (trans r \<and> antisym r))"


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> total / linear orders   \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val isTotalOrderOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isTotalOrderOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isTotalOrderOn r s = ( isPartialOrderOn r s \<and> isTotalOn r s )"


\<comment> \<open>\<open>val isStrictTotalOrderOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> bool\<close>\<close>
definition isStrictTotalOrderOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " isStrictTotalOrderOn r s = ( isStrictPartialOrderOn r s \<and> isTrichotomousOn r s )"


\<comment> \<open>\<open>val isTotalOrder : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isTotalOrder  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isTotalOrder r = ( isPartialOrder r \<and> total r )"


\<comment> \<open>\<open>val isStrictTotalOrder : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> bool\<close>\<close>
definition isStrictTotalOrder  :: "('a*'a)set \<Rightarrow> bool "  where 
     " isStrictTotalOrder r = ( isStrictPartialOrder r \<and> isTrichotomous r )"




\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> closures                                                                   \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> transitive closure      \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val transitiveClosure : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> rel 'a 'a\<close>\<close>
\<comment> \<open>\<open>val transitiveClosureByEq  : forall 'a. ('a -> 'a -> bool) -> rel 'a 'a -> rel 'a 'a\<close>\<close>
\<comment> \<open>\<open>val transitiveClosureByCmp : forall 'a. ('a * 'a -> 'a * 'a -> ordering) -> rel 'a 'a -> rel 'a 'a\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> transitive closure step \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val transitiveClosureAdd : forall 'a. SetType 'a, Eq 'a => 'a -> 'a -> rel 'a 'a -> rel 'a 'a\<close>\<close>

definition transitiveClosureAdd  :: " 'a \<Rightarrow> 'a \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set "  where 
     " transitiveClosureAdd x y r = ( 
  (((((Set.insert (x,y) (r)))) \<union> ((((((let x2 = 
  ({}) in  Finite_Set.fold
   (\<lambda>z x2 .  if (y, z) \<in> r then Set.insert (x, z) x2 else x2) 
 x2 (Range r)))) \<union> (((let x2 = 
  ({}) in  Finite_Set.fold
   (\<lambda>z x2 .  if (z, x) \<in> r then Set.insert (z, y) x2 else x2) 
 x2 (Domain r))))))))))"



\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> reflexive closure                                                          \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open>val reflexiveTransitiveClosureOn : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> set 'a -> rel 'a 'a\<close>\<close>
definition reflexiveTransitiveClosureOn  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow>('a*'a)set "  where 
     " reflexiveTransitiveClosureOn r s = ( trancl (((r) \<union> ((relIdOn s)))))"



\<comment> \<open>\<open>val reflexiveTransitiveClosure : forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> rel 'a 'a\<close>\<close>
definition reflexiveTransitiveClosure  :: "('a*'a)set \<Rightarrow>('a*'a)set "  where 
     " reflexiveTransitiveClosure r = ( trancl (((r) \<union> (Id))))"




\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> inverse of closures                                                        \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> without transitve edges \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val withoutTransitiveEdges: forall 'a. SetType 'a, Eq 'a => rel 'a 'a -> rel 'a 'a\<close>\<close>
\<comment> \<open>\<open>let withoutTransitiveEdges r=
   let tc = transitiveClosure r in
  {(a, c) | forall ((a, c) IN r) 
  | forall (b IN relRange r). a <> b && b <> c --> not ((a, b) IN tc && (b, c) IN tc)}\<close>\<close>
end
