chapter \<open>Generated by Lem from \<open>list.lem\<close>.\<close>

theory "Lem_list" 

imports
  Main
  "Lem_bool"
  "Lem_maybe"
  "Lem_basic_classes"
  "Lem_function"
  "Lem_tuple"
  "Lem_num"
  "Lem"

begin 

 

\<comment> \<open>\<open>open import Bool Maybe Basic_classes Function Tuple Num\<close>\<close>

\<comment> \<open>\<open>open import {coq} `Coq.Lists.List`\<close>\<close>
\<comment> \<open>\<open>open import {isabelle} `$LIB_DIR/Lem`\<close>\<close>
\<comment> \<open>\<open>open import {hol} `lemTheory` `listTheory` `rich_listTheory` `sortingTheory`\<close>\<close>

\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Basic list functions                                                       \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> The type of lists as well as list literals like [], [1;2], ... are hardcoded. 
   Thus, we can directly dive into derived definitions. \<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> cons                    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val :: : forall 'a. 'a -> list 'a -> list 'a\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Emptyness check         \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val null : forall 'a. list 'a -> bool\<close>\<close>
\<comment> \<open>\<open>let null l=  match l with [] -> true | _ -> false end\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Length                  \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val length : forall 'a. list 'a -> nat\<close>\<close>
\<comment> \<open>\<open>let rec length l=
   match l with
    | [] -> 0
    | x :: xs -> (Instance_Num_NumAdd_nat.+) (length xs) 1
  end\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Equality                \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val listEqual : forall 'a. Eq 'a => list 'a -> list 'a -> bool\<close>\<close>
\<comment> \<open>\<open>val listEqualBy : forall 'a. ('a -> 'a -> bool) -> list 'a -> list 'a -> bool\<close>\<close>

fun  listEqualBy  :: "('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list \<Rightarrow> bool "  where 
     " listEqualBy eq ([]) ([]) = ( True )"
|" listEqualBy eq ([]) (_ # _) = ( False )"
|" listEqualBy eq (_ # _) ([]) = ( False )"
|" listEqualBy eq (x # xs) (y # ys) = ( (eq x y \<and> listEqualBy eq xs ys))"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> compare                 \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val lexicographicCompare : forall 'a. Ord 'a => list 'a -> list 'a -> ordering\<close>\<close>
\<comment> \<open>\<open>val lexicographicCompareBy : forall 'a. ('a -> 'a -> ordering) -> list 'a -> list 'a -> ordering\<close>\<close>

fun  lexicographicCompareBy  :: "('a \<Rightarrow> 'a \<Rightarrow> ordering)\<Rightarrow> 'a list \<Rightarrow> 'a list \<Rightarrow> ordering "  where 
     " lexicographicCompareBy cmp ([]) ([]) = ( EQ )"
|" lexicographicCompareBy cmp ([]) (_ # _) = ( LT )"
|" lexicographicCompareBy cmp (_ # _) ([]) = ( GT )"
|" lexicographicCompareBy cmp (x # xs) (y # ys) = ( (
      (case  cmp x y of 
          LT => LT
        | GT => GT
        | EQ => lexicographicCompareBy cmp xs ys
      )
    ))"


\<comment> \<open>\<open>val lexicographicLess : forall 'a. Ord 'a => list 'a -> list 'a -> bool\<close>\<close>
\<comment> \<open>\<open>val lexicographicLessBy : forall 'a. ('a -> 'a -> bool) -> ('a -> 'a -> bool) -> list 'a -> list 'a -> bool\<close>\<close>
fun  lexicographicLessBy  :: "('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow>('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list \<Rightarrow> bool "  where 
     " lexicographicLessBy less1 less_eq1 ([]) ([]) = ( False )"
|" lexicographicLessBy less1 less_eq1 ([]) (_ # _) = ( True )"
|" lexicographicLessBy less1 less_eq1 (_ # _) ([]) = ( False )"
|" lexicographicLessBy less1 less_eq1 (x # xs) (y # ys) = ( ((less1 x y) \<or> ((less_eq1 x y) \<and> (lexicographicLessBy less1 less_eq1 xs ys))))"


\<comment> \<open>\<open>val lexicographicLessEq : forall 'a. Ord 'a => list 'a -> list 'a -> bool\<close>\<close>
\<comment> \<open>\<open>val lexicographicLessEqBy : forall 'a. ('a -> 'a -> bool) -> ('a -> 'a -> bool) -> list 'a -> list 'a -> bool\<close>\<close>
fun  lexicographicLessEqBy  :: "('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow>('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list \<Rightarrow> bool "  where 
     " lexicographicLessEqBy less1 less_eq1 ([]) ([]) = ( True )"
|" lexicographicLessEqBy less1 less_eq1 ([]) (_ # _) = ( True )"
|" lexicographicLessEqBy less1 less_eq1 (_ # _) ([]) = ( False )"
|" lexicographicLessEqBy less1 less_eq1 (x # xs) (y # ys) = ( (less1 x y \<or> (less_eq1 x y \<and> lexicographicLessEqBy less1 less_eq1 xs ys)))"



definition instance_Basic_classes_Ord_list_dict  :: " 'a Ord_class \<Rightarrow>('a list)Ord_class "  where 
     " instance_Basic_classes_Ord_list_dict dict_Basic_classes_Ord_a = ((|

  compare_method = (lexicographicCompareBy 
  (compare_method   dict_Basic_classes_Ord_a)),

  isLess_method = (lexicographicLessBy 
  (isLess_method   dict_Basic_classes_Ord_a) (isLessEqual_method   dict_Basic_classes_Ord_a)),

  isLessEqual_method = (lexicographicLessEqBy 
  (isLess_method   dict_Basic_classes_Ord_a) (isLessEqual_method   dict_Basic_classes_Ord_a)),

  isGreater_method = (\<lambda> x y. (lexicographicLessBy 
  (isLess_method   dict_Basic_classes_Ord_a) (isLessEqual_method   dict_Basic_classes_Ord_a) y x)),

  isGreaterEqual_method = (\<lambda> x y. (lexicographicLessEqBy 
  (isLess_method   dict_Basic_classes_Ord_a) (isLessEqual_method   dict_Basic_classes_Ord_a) y x))|) )"



\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Append                  \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val ++ : forall 'a. list 'a -> list 'a -> list 'a\<close>\<close> \<comment> \<open>\<open> originally append \<close>\<close>
\<comment> \<open>\<open>let rec ++ xs ys=  match xs with
                     | [] -> ys
                     | x :: xs' -> x :: (xs' ++ ys)
                   end\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> snoc                    \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val snoc : forall 'a. 'a -> list 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>let snoc e l=  l ++ [e]\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Reverse                 \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open> First lets define the function [reverse_append], which is
   closely related to reverse. [reverse_append l1 l2] appends the list [l2] to the reverse of [l1].
   This can be implemented more efficienctly than appending and is
   used to implement reverse. \<close>\<close>

\<comment> \<open>\<open>val reverseAppend : forall 'a. list 'a -> list 'a -> list 'a\<close>\<close> \<comment> \<open>\<open> originally named rev_append \<close>\<close>
\<comment> \<open>\<open>let rec reverseAppend l1 l2=  match l1 with 
                                | [] -> l2
                                | x :: xs -> reverseAppend xs (x :: l2)
                               end\<close>\<close>

\<comment> \<open>\<open> Reversing a list \<close>\<close>
\<comment> \<open>\<open>val reverse : forall 'a. list 'a -> list 'a\<close>\<close> \<comment> \<open>\<open> originally named rev \<close>\<close>
\<comment> \<open>\<open>let reverse l=  reverseAppend l []\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Map                     \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val map_tr : forall 'a 'b. list 'b -> ('a -> 'b) -> list 'a -> list 'b\<close>\<close>
function (sequential,domintros)  map_tr  :: " 'b list \<Rightarrow>('a \<Rightarrow> 'b)\<Rightarrow> 'a list \<Rightarrow> 'b list "  where 
     " map_tr rev_acc f ([]) = ( List.rev rev_acc )"
|" map_tr rev_acc f (x # xs) = ( map_tr ((f x) # rev_acc) f xs )" 
by pat_completeness auto


\<comment> \<open>\<open> taken from: https://blogs.janestreet.com/optimizing-list-map/ \<close>\<close>
\<comment> \<open>\<open>val count_map : forall 'a 'b. ('a -> 'b) -> list 'a -> nat -> list 'b\<close>\<close>
function (sequential,domintros)  count_map  :: "('a \<Rightarrow> 'b)\<Rightarrow> 'a list \<Rightarrow> nat \<Rightarrow> 'b list "  where 
     " count_map f ([]) ctr = ( [])"
|" count_map f (hd1 # tl1) ctr = ( f hd1 # 
    (if ctr <( 5000 :: nat) then count_map f tl1 (ctr +( 1 :: nat)) 
    else map_tr [] f tl1))" 
by pat_completeness auto

 
\<comment> \<open>\<open>val map : forall 'a 'b. ('a -> 'b) -> list 'a -> list 'b\<close>\<close>
\<comment> \<open>\<open>let map f l=  count_map f l 0\<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> Reverse Map             \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val reverseMap : forall 'a 'b. ('a -> 'b) -> list 'a -> list 'b\<close>\<close>


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Folding                                                                    \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> fold left               \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val foldl : forall 'a 'b. ('a -> 'b -> 'a) -> 'a -> list 'b -> 'a\<close>\<close> \<comment> \<open>\<open> originally foldl \<close>\<close>

\<comment> \<open>\<open>let rec foldl f b l=  match l with
  | []      -> b
  | x :: xs -> foldl f (f b x) xs
end\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> fold right              \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val foldr : forall 'a 'b. ('a -> 'b -> 'b) -> 'b -> list 'a -> 'b\<close>\<close> \<comment> \<open>\<open> originally foldr with different argument order \<close>\<close>
\<comment> \<open>\<open>let rec foldr f b l=  match l with
  | []      -> b
  | x :: xs -> f x (foldr f b xs)
end\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> concatenating lists     \<close>\<close>
\<comment> \<open>\<open> ----------------------- \<close>\<close>

\<comment> \<open>\<open>val concat : forall 'a. list (list 'a) -> list 'a\<close>\<close> \<comment> \<open>\<open> before also called "flatten" \<close>\<close>
\<comment> \<open>\<open>let concat=  foldr (++) []\<close>\<close>


\<comment> \<open>\<open> -------------------------- \<close>\<close>
\<comment> \<open>\<open> concatenating with mapping \<close>\<close>
\<comment> \<open>\<open> -------------------------- \<close>\<close>

\<comment> \<open>\<open>val concatMap : forall 'a 'b. ('a -> list 'b) -> list 'a -> list 'b\<close>\<close>


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> universal qualification   \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val all : forall 'a. ('a -> bool) -> list 'a -> bool\<close>\<close> \<comment> \<open>\<open> originally for_all \<close>\<close>
\<comment> \<open>\<open>let all P l=  foldl (fun r e -> P e && r) true l\<close>\<close>



\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> existential qualification \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val any : forall 'a. ('a -> bool) -> list 'a -> bool\<close>\<close> \<comment> \<open>\<open> originally exist \<close>\<close>
\<comment> \<open>\<open>let any P l=  foldl (fun r e -> P e || r) false l\<close>\<close>


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> dest_init                 \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> get the initial part and the last element of the list in a safe way \<close>\<close>

\<comment> \<open>\<open>val dest_init : forall 'a. list 'a -> maybe (list 'a * 'a)\<close>\<close> 

fun  dest_init_aux  :: " 'a list \<Rightarrow> 'a \<Rightarrow> 'a list \<Rightarrow> 'a list*'a "  where 
     " dest_init_aux rev_init last_elem_seen ([]) = ( (List.rev rev_init, last_elem_seen))"
|" dest_init_aux rev_init last_elem_seen (x # xs) = ( dest_init_aux (last_elem_seen # rev_init) x xs )"


fun dest_init  :: " 'a list \<Rightarrow>('a list*'a)option "  where 
     " dest_init ([]) = ( None )"
|" dest_init (x # xs) = ( Some (dest_init_aux [] x xs))"



\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Indexing lists                                                             \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> index / nth with maybe   \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val index : forall 'a. list 'a -> nat -> maybe 'a\<close>\<close>

\<comment> \<open>\<open>let rec index l n=  match l with 
  | []      -> Nothing
  | x :: xs -> if (Instance_Basic_classes_Eq_nat.=) n 0 then Just x else index xs ((Instance_Num_NumMinus_nat.-)n 1)
end\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> findIndices               \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> [findIndices P l] returns the indices of all elements of list [l] that satisfy predicate [P]. 
   Counting starts with 0, the result list is sorted ascendingly \<close>\<close>
\<comment> \<open>\<open>val findIndices : forall 'a. ('a -> bool) -> list 'a -> list nat\<close>\<close>

fun  findIndices_aux  :: " nat \<Rightarrow>('a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow>(nat)list "  where 
     " findIndices_aux (i::nat) P ([]) = ( [])"
|" findIndices_aux (i::nat) P (x # xs) = ( if P x then i # findIndices_aux (i +( 1 :: nat)) P xs else findIndices_aux (i +( 1 :: nat)) P xs )"

\<comment> \<open>\<open>let findIndices P l=  findIndices_aux 0 P l\<close>\<close>



\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> findIndex                 \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> findIndex returns the first index of a list that satisfies a given predicate. \<close>\<close>
\<comment> \<open>\<open>val findIndex : forall 'a. ('a -> bool) -> list 'a -> maybe nat\<close>\<close>
\<comment> \<open>\<open>let findIndex P l=  match findIndices P l with
  | [] -> Nothing
  | x :: _ -> Just x
end\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> elemIndices               \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val elemIndices : forall 'a. Eq 'a => 'a -> list 'a -> list nat\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> elemIndex                 \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val elemIndex : forall 'a. Eq 'a => 'a -> list 'a -> maybe nat\<close>\<close>


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Creating lists                                                             \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> genlist                   \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> [genlist f n] generates the list [f 0; f 1; ... (f (n-1))] \<close>\<close>
\<comment> \<open>\<open>val genlist : forall 'a. (nat -> 'a) -> nat -> list 'a\<close>\<close>


\<comment> \<open>\<open>let rec genlist f n=
   match n with
    | 0 -> []
    | n' + 1 -> snoc (f n') (genlist f n')
  end\<close>\<close>


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> replicate                 \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val replicate : forall 'a. nat -> 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>let rec replicate n x=
   match n with
    | 0 -> []
    | n' + 1 -> x :: replicate n' x
  end\<close>\<close>


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Sublists                                                                   \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> splitAt                   \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> [splitAt n xs] returns a tuple (xs1, xs2), with "append xs1 xs2 = xs" and 
   "length xs1 = n". If there are not enough elements 
   in [xs], the original list and the empty one are returned. \<close>\<close>
\<comment> \<open>\<open>val splitAtAcc : forall 'a. list 'a -> nat -> list 'a -> (list 'a * list 'a)\<close>\<close>
function (sequential,domintros)  splitAtAcc  :: " 'a list \<Rightarrow> nat \<Rightarrow> 'a list \<Rightarrow> 'a list*'a list "  where 
     " splitAtAcc revAcc n l = ( 
  (case  l of
      []    => (List.rev revAcc, [])
    | x # xs => if n \<le>( 0 :: nat) then (List.rev revAcc, l) else splitAtAcc (x # revAcc) (n-( 1 :: nat)) xs
  ))" 
by pat_completeness auto


\<comment> \<open>\<open>val splitAt : forall 'a. nat -> list 'a -> (list 'a * list 'a)\<close>\<close>
\<comment> \<open>\<open>let rec splitAt n l= 
    splitAtAcc [] n l\<close>\<close>


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> take                      \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> take n xs returns the prefix of xs of length n, or xs itself if n > length xs \<close>\<close>
\<comment> \<open>\<open>val take : forall 'a. nat -> list 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>let take n l=  fst (splitAt n l)\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> drop                      \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> [drop n xs] drops the first [n] elements of [xs]. It returns the empty list, if [n] > [length xs]. \<close>\<close>
\<comment> \<open>\<open>val drop : forall 'a. nat -> list 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>let drop n l=  snd (splitAt n l)\<close>\<close>

\<comment> \<open>\<open> ------------------------------------ \<close>\<close>
\<comment> \<open>\<open> splitWhile, takeWhile, and dropWhile \<close>\<close>
\<comment> \<open>\<open> ------------------------------------ \<close>\<close>

\<comment> \<open>\<open>val splitWhile_tr : forall 'a. ('a -> bool) -> list 'a -> list 'a -> (list 'a * list 'a)\<close>\<close>
fun  splitWhile_tr  :: "('a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list \<Rightarrow> 'a list*'a list "  where 
     " splitWhile_tr p ([]) acc1 = (
    (List.rev acc1, []))"
|" splitWhile_tr p (x # xs) acc1 = (
    if p x then
      splitWhile_tr p xs (x # acc1)
    else
      (List.rev acc1, (x # xs)))"


\<comment> \<open>\<open>val splitWhile : forall 'a. ('a -> bool) -> list 'a -> (list 'a * list 'a)\<close>\<close>
definition splitWhile  :: "('a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list*'a list "  where 
     " splitWhile p xs = ( splitWhile_tr p xs [])"


\<comment> \<open>\<open> [takeWhile p xs] takes the first elements of [xs] that satisfy [p]. \<close>\<close>
\<comment> \<open>\<open>val takeWhile : forall 'a. ('a -> bool) -> list 'a -> list 'a\<close>\<close>
definition takeWhile  :: "('a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list "  where 
     " takeWhile p l = ( fst (splitWhile p l))"


\<comment> \<open>\<open> [dropWhile p xs] drops the first elements of [xs] that satisfy [p]. \<close>\<close>
\<comment> \<open>\<open>val dropWhile : forall 'a. ('a -> bool) -> list 'a -> list 'a\<close>\<close>
definition dropWhile  :: "('a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list "  where 
     " dropWhile p l = ( snd (splitWhile p l))"


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> isPrefixOf                \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val isPrefixOf : forall 'a. Eq 'a => list 'a -> list 'a -> bool\<close>\<close>
fun  isPrefixOf  :: " 'a list \<Rightarrow> 'a list \<Rightarrow> bool "  where 
     " isPrefixOf ([]) _ = ( True )"
|" isPrefixOf (_ # _) ([]) = ( False )"
|" isPrefixOf (x # xs) (y # ys) = ( (x = y) \<and> isPrefixOf xs ys )"


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> update                    \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open>val update : forall 'a. list 'a -> nat -> 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>let rec update l n e= 
   match l with
    | []      -> []
    | x :: xs -> if (Instance_Basic_classes_Eq_nat.=) n 0 then e :: xs else x :: (update xs ((Instance_Num_NumMinus_nat.-) n 1) e)
end\<close>\<close>



\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Searching lists                                                            \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> Membership test           \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> The membership test, one of the basic list functions, is actually tricky for
   Lem, because it is tricky, which equality to use. From Lem`s point of 
   perspective, we want to use the equality provided by the equality type - class.
   This allows for example to check whether a set is in a list of sets.

   However, in order to use the equality type class, elem essentially becomes
   existential quantification over lists. For types, which implement semantic
   equality (=) with syntactic equality, this is overly complicated. In
   our theorem prover backend, we would end up with overly complicated, harder
   to read definitions and some of the automation would be harder to apply.
   Moreover, nearly all the old Lem generated code would change and require 
   (hopefully minor) adaptions of proofs.

   For now, we ignore this problem and just demand, that all instances of
   the equality type class do the right thing for the theorem prover backends.   
\<close>\<close>

\<comment> \<open>\<open>val elem : forall 'a. Eq 'a => 'a -> list 'a -> bool\<close>\<close>
\<comment> \<open>\<open>val elemBy : forall 'a. ('a -> 'a -> bool) -> 'a -> list 'a -> bool\<close>\<close>

definition elemBy  :: "('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow> 'a \<Rightarrow> 'a list \<Rightarrow> bool "  where 
     " elemBy eq e l = ( ((\<exists> x \<in> (set l).  (eq e) x)))"

\<comment> \<open>\<open>let elem=  elemBy (=)\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> Find                      \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open>val find : forall 'a. ('a -> bool) -> list 'a -> maybe 'a\<close>\<close> \<comment> \<open>\<open> previously not of maybe type \<close>\<close>
\<comment> \<open>\<open>let rec find P l=  match l with 
  | []      -> Nothing
  | x :: xs -> if P x then Just x else find P xs
end\<close>\<close>


\<comment> \<open>\<open> ----------------------------- \<close>\<close>
\<comment> \<open>\<open> Lookup in an associative list \<close>\<close>
\<comment> \<open>\<open> ----------------------------- \<close>\<close>
\<comment> \<open>\<open>val lookup   : forall 'a 'b. Eq 'a              => 'a -> list ('a * 'b) -> maybe 'b\<close>\<close>
\<comment> \<open>\<open>val lookupBy : forall 'a 'b. ('a -> 'a -> bool) -> 'a -> list ('a * 'b) -> maybe 'b\<close>\<close>

\<comment> \<open>\<open> DPM: eta-expansion for Coq backend type-inference. \<close>\<close>
definition lookupBy  :: "('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow> 'a \<Rightarrow>('a*'b)list \<Rightarrow> 'b option "  where 
     " lookupBy eq k m = ( map_option (\<lambda> x .  snd x) (List.find ( \<lambda>x .  
  (case  x of (k', _) => eq k k' )) m))"


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> filter                    \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open>val filter : forall 'a. ('a -> bool) -> list 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>let rec filter P l=  match l with
                       | [] -> []
                       | x :: xs -> if (P x) then x :: (filter P xs) else filter P xs
                     end\<close>\<close>


\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> partition                 \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open>val partition : forall 'a. ('a -> bool) -> list 'a -> list 'a * list 'a\<close>\<close>
\<comment> \<open>\<open>let partition P l=  (filter P l, filter (fun x -> not (P x)) l)\<close>\<close>

\<comment> \<open>\<open>val reversePartition : forall 'a. ('a -> bool) -> list 'a -> list 'a * list 'a\<close>\<close>
definition reversePartition  :: "('a \<Rightarrow> bool)\<Rightarrow> 'a list \<Rightarrow> 'a list*'a list "  where 
     " reversePartition P l = ( List.partition P (List.rev l))"



\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> delete first element      \<close>\<close>
\<comment> \<open>\<open> with certain property     \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val deleteFirst : forall 'a. ('a -> bool) -> list 'a -> maybe (list 'a)\<close>\<close> 
\<comment> \<open>\<open>let rec deleteFirst P l=  match l with
                            | [] -> Nothing
                            | x :: xs -> if (P x) then Just xs else Maybe.map (fun xs' -> x :: xs') (deleteFirst P xs)
                          end\<close>\<close>


\<comment> \<open>\<open>val delete : forall 'a. Eq 'a => 'a -> list 'a -> list 'a\<close>\<close>
\<comment> \<open>\<open>val deleteBy : forall 'a. ('a -> 'a -> bool) -> 'a -> list 'a -> list 'a\<close>\<close>

definition deleteBy  :: "('a \<Rightarrow> 'a \<Rightarrow> bool)\<Rightarrow> 'a \<Rightarrow> 'a list \<Rightarrow> 'a list "  where 
     " deleteBy eq x l = ( case_option l id (delete_first (eq x) l))"



\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Zipping and unzipping lists                                                \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> zip                       \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open> zip takes two lists and returns a list of corresponding pairs. If one input list is short, excess elements of the longer list are discarded. \<close>\<close>
\<comment> \<open>\<open>val zip : forall 'a 'b. list 'a -> list 'b -> list ('a * 'b)\<close>\<close> \<comment> \<open>\<open> before combine \<close>\<close>
\<comment> \<open>\<open>let rec zip l1 l2=  match (l1, l2) with
  | (x :: xs, y :: ys) -> (x, y) :: zip xs ys
  | _ -> []
end\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> unzip                     \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val unzip: forall 'a 'b. list ('a * 'b) -> (list 'a * list 'b)\<close>\<close>
\<comment> \<open>\<open>let rec unzip l=  match l with
  | [] -> ([], [])
  | (x, y) :: xys -> let (xs, ys) = unzip xys in (x :: xs, y :: ys)
end\<close>\<close>

\<comment> \<open>\<open> ------------------------- \<close>\<close>
\<comment> \<open>\<open> distinct elements         \<close>\<close>
\<comment> \<open>\<open> ------------------------- \<close>\<close>

\<comment> \<open>\<open>val allDistinct : forall 'a. Eq 'a => list 'a -> bool\<close>\<close>
fun  allDistinct  :: " 'a list \<Rightarrow> bool "  where 
     " allDistinct ([]) = ( True )"
|" allDistinct (x # l') = ( \<not> (Set.member x (set l')) \<and> allDistinct l' )"


\<comment> \<open>\<open> some more useful functions \<close>\<close>
\<comment> \<open>\<open>val mapMaybe : forall 'a 'b. ('a -> maybe 'b) -> list 'a -> list 'b\<close>\<close>
function (sequential,domintros)  mapMaybe  :: "('a \<Rightarrow> 'b option)\<Rightarrow> 'a list \<Rightarrow> 'b list "  where 
     " mapMaybe f ([]) = ( [])"
|" mapMaybe f (x # xs) = (
      (case  f x of
        None => mapMaybe f xs
      | Some y => y # (mapMaybe f xs)
      ))" 
by pat_completeness auto


\<comment> \<open>\<open>val mapi : forall 'a 'b. (nat -> 'a -> 'b) -> list 'a -> list 'b\<close>\<close>
function (sequential,domintros)  mapiAux  :: "(nat \<Rightarrow> 'b \<Rightarrow> 'a)\<Rightarrow> nat \<Rightarrow> 'b list \<Rightarrow> 'a list "  where 
     " mapiAux f (n :: nat) ([]) = ( [])"
|" mapiAux f (n :: nat) (x # xs) = ( (f n x) # mapiAux f (n +( 1 :: nat)) xs )" 
by pat_completeness auto

definition mapi  :: "(nat \<Rightarrow> 'a \<Rightarrow> 'b)\<Rightarrow> 'a list \<Rightarrow> 'b list "  where 
     " mapi f l = ( mapiAux f(( 0 :: nat)) l )"


\<comment> \<open>\<open>val deletes: forall 'a. Eq 'a => list 'a -> list 'a -> list 'a\<close>\<close>
definition deletes  :: " 'a list \<Rightarrow> 'a list \<Rightarrow> 'a list "  where 
     " deletes xs ys = (
  List.foldl ((\<lambda> x y. remove1 y x)) xs ys )"


\<comment> \<open>\<open> ========================================================================== \<close>\<close>
\<comment> \<open>\<open> Comments (not clean yet, please ignore the rest of the file)               \<close>\<close>
\<comment> \<open>\<open> ========================================================================== \<close>\<close>

\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> skipped from Haskell Lib\<close>\<close>
\<comment> \<open>\<open> ----------------------- 

intersperse :: a -> [a] -> [a]
intercalate :: [a] -> [[a]] -> [a]
transpose :: [[a]] -> [[a]]
subsequences :: [a] -> [[a]]
permutations :: [a] -> [[a]]
foldl` :: (a -> b -> a) -> a -> [b] -> aSource
foldl1` :: (a -> a -> a) -> [a] -> aSource

and
or
sum
product
maximum
minimum
scanl
scanr
scanl1
scanr1
Accumulating maps

mapAccumL :: (acc -> x -> (acc, y)) -> acc -> [x] -> (acc, [y])Source
mapAccumR :: (acc -> x -> (acc, y)) -> acc -> [x] -> (acc, [y])Source

iterate :: (a -> a) -> a -> [a]
repeat :: a -> [a]
cycle :: [a] -> [a]
unfoldr


takeWhile :: (a -> Bool) -> [a] -> [a]Source
dropWhile :: (a -> Bool) -> [a] -> [a]Source
dropWhileEnd :: (a -> Bool) -> [a] -> [a]Source
span :: (a -> Bool) -> [a] -> ([a], [a])Source
break :: (a -> Bool) -> [a] -> ([a], [a])Source
break p is equivalent to span (not . p).
stripPrefix :: Eq a => [a] -> [a] -> Maybe [a]Source
group :: Eq a => [a] -> [[a]]Source
inits :: [a] -> [[a]]Source
tails :: [a] -> [[a]]Source


isPrefixOf :: Eq a => [a] -> [a] -> BoolSource
isSuffixOf :: Eq a => [a] -> [a] -> BoolSource
isInfixOf :: Eq a => [a] -> [a] -> BoolSource



notElem :: Eq a => a -> [a] -> BoolSource

zip3 :: [a] -> [b] -> [c] -> [(a, b, c)]Source
zip4 :: [a] -> [b] -> [c] -> [d] -> [(a, b, c, d)]Source
zip5 :: [a] -> [b] -> [c] -> [d] -> [e] -> [(a, b, c, d, e)]Source
zip6 :: [a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [(a, b, c, d, e, f)]Source
zip7 :: [a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [g] -> [(a, b, c, d, e, f, g)]Source

zipWith :: (a -> b -> c) -> [a] -> [b] -> [c]Source
zipWith3 :: (a -> b -> c -> d) -> [a] -> [b] -> [c] -> [d]Source
zipWith4 :: (a -> b -> c -> d -> e) -> [a] -> [b] -> [c] -> [d] -> [e]Source
zipWith5 :: (a -> b -> c -> d -> e -> f) -> [a] -> [b] -> [c] -> [d] -> [e] -> [f]Source
zipWith6 :: (a -> b -> c -> d -> e -> f -> g) -> [a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [g]Source
zipWith7 :: (a -> b -> c -> d -> e -> f -> g -> h) -> [a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [g] -> [h]Source


unzip3 :: [(a, b, c)] -> ([a], [b], [c])Source
unzip4 :: [(a, b, c, d)] -> ([a], [b], [c], [d])Source
unzip5 :: [(a, b, c, d, e)] -> ([a], [b], [c], [d], [e])Source
unzip6 :: [(a, b, c, d, e, f)] -> ([a], [b], [c], [d], [e], [f])Source
unzip7 :: [(a, b, c, d, e, f, g)] -> ([a], [b], [c], [d], [e], [f], [g])Source


lines :: String -> [String]Source
words :: String -> [String]Source
unlines :: [String] -> StringSource
unwords :: [String] -> StringSource
nub :: Eq a => [a] -> [a]Source
delete :: Eq a => a -> [a] -> [a]Source

(\\) :: Eq a => [a] -> [a] -> [a]Source
union :: Eq a => [a] -> [a] -> [a]Source
intersect :: Eq a => [a] -> [a] -> [a]Source
sort :: Ord a => [a] -> [a]Source
insert :: Ord a => a -> [a] -> [a]Source


nubBy :: (a -> a -> Bool) -> [a] -> [a]Source
deleteBy :: (a -> a -> Bool) -> a -> [a] -> [a]Source
deleteFirstsBy :: (a -> a -> Bool) -> [a] -> [a] -> [a]Source
unionBy :: (a -> a -> Bool) -> [a] -> [a] -> [a]Source
intersectBy :: (a -> a -> Bool) -> [a] -> [a] -> [a]Source
groupBy :: (a -> a -> Bool) -> [a] -> [[a]]Source
sortBy :: (a -> a -> Ordering) -> [a] -> [a]Source
insertBy :: (a -> a -> Ordering) -> a -> [a] -> [a]Source
maximumBy :: (a -> a -> Ordering) -> [a] -> aSource
minimumBy :: (a -> a -> Ordering) -> [a] -> aSource
genericLength :: Num i => [b] -> iSource
genericTake :: Integral i => i -> [a] -> [a]Source
genericDrop :: Integral i => i -> [a] -> [a]Source
genericSplitAt :: Integral i => i -> [b] -> ([b], [b])Source
genericIndex :: Integral a => [b] -> a -> bSource
genericReplicate :: Integral i => i -> a -> [a]Source


\<close>\<close>


\<comment> \<open>\<open> ----------------------- \<close>\<close>
\<comment> \<open>\<open> skipped from Lem Lib    \<close>\<close>
\<comment> \<open>\<open> ----------------------- 


val for_all2 : forall 'a 'b. ('a -> 'b -> bool) -> list 'a -> list 'b -> bool
val exists2 : forall 'a 'b. ('a -> 'b -> bool) -> list 'a -> list 'b -> bool
val map2 : forall 'a 'b 'c. ('a -> 'b -> 'c) -> list 'a -> list 'b -> list 'c 
val rev_map2 : forall 'a 'b 'c. ('a -> 'b -> 'c) -> list 'a -> list 'b -> list 'c
val fold_left2 : forall 'a 'b 'c. ('a -> 'b -> 'c -> 'a) -> 'a -> list 'b -> list 'c -> 'a
val fold_right2 : forall 'a 'b 'c. ('a -> 'b -> 'c -> 'c) -> list 'a -> list 'b -> 'c -> 'c


\<open> now maybe result and called lookup \<close>
val assoc : forall 'a 'b. 'a -> list ('a * 'b) -> 'b
let inline {ocaml} assoc = Ocaml.List.assoc


val mem_assoc : forall 'a 'b. 'a -> list ('a * 'b) -> bool
val remove_assoc : forall 'a 'b. 'a -> list ('a * 'b) -> list ('a * 'b)



val stable_sort : forall 'a. ('a -> 'a -> num) -> list 'a -> list 'a
val fast_sort : forall 'a. ('a -> 'a -> num) -> list 'a -> list 'a

val merge : forall 'a. ('a -> 'a -> num) -> list 'a -> list 'a -> list 'a
val intersect : forall 'a. list 'a -> list 'a -> list 'a


\<close>\<close>

\<comment> \<open>\<open>val     catMaybes : forall 'a. list (maybe 'a) -> list 'a\<close>\<close>
function (sequential,domintros)  catMaybes  :: "('a option)list \<Rightarrow> 'a list "  where 
     " catMaybes ([]) = (
        [])"
|" catMaybes (None # xs') = (
        catMaybes xs' )"
|" catMaybes (Some x # xs') = (
        x # catMaybes xs' )" 
by pat_completeness auto

end
